<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


$filename = '../../../../../logs/php_error.log';

if (file_exists($filename) == false)
	die("Le fichier $filename n'existe pas");

$string = file_get_contents($filename, "r");

$tab = explode("\n",$string);


$tab_error = array();

$compteur = 0;
foreach($tab as $current_line)
{
	// Exemple : [19-Dec-2016 11:04:59 Indian/Reunion] PHP Warning:  filesize(): stat failed for files/CA20160819_2124.slk in C:\wamp64\www\cabinet\comptes_bancaires\index.php on line 306

	$matches = array();
	preg_match('~^\[(.*)\](.*)~', $current_line, $matches);

	$date = new DateTime($matches[1]);

	if ($date->format("Y-m-d") >= $_GET['start'] && $date->format("Y-m-d") <= $_GET['end'] && $matches[2] <> "")
	{
		if (!strpos($matches[2], "PHP Warning") && !strpos($matches[2], "PHP Notice") && !strpos($matches[2], "PHP Fatal error") && !strpos($matches[2], "PHP Parse error"))
		{
			$tab_error[$compteur]['ligne']		.= $matches[2]."\n";
		}
		else
		{
			$compteur++;
			
			$tab_error[$compteur]['datetime']	= $matches[1];
			$tab_error[$compteur]['ligne']		= $matches[2];
		}
	}
}


foreach($tab_error as $current_line)
{
	if(strpos($current_line['ligne'], "PHP Warning"))
		$type_error = "PHP Warning";
	elseif(strpos($current_line['ligne'], "PHP Notice"))
		$type_error = "PHP Notice";
	elseif(strpos($current_line['ligne'], "PHP Fatal error"))
		$type_error = "PHP Fatal error";
	elseif(strpos($current_line['ligne'], "PHP Parse error"))
		$type_error = "PHP Parse error";
	else
		$type_error = "";

	$date = new DateTime($current_line['datetime']);


	dbquery("INSERT INTO log_php_error
		VALUES ('',
				'".$date->format("Y-m-d H:i:s")."',
				'".$type_error."',
				'".addslashes($current_line['ligne'])."'
					)");
}

// Efface le fichier de log
$filename = '../../../../../logs/php_error.log';

$fp = fopen($filename, 'w+');
fwrite($fp, '');
fclose($fp);








$datetime_start	= new DateTime($_GET['start']);
$datetime_end	= new DateTime($_GET['end']);

$teb_color_error = array();

$teb_color_error["PHP Fatal error"]	= "red";
$teb_color_error["PHP Parse error"]	= "red";
$teb_color_error["PHP Warning"]		= "orange";
$teb_color_error["PHP Notice"]		= "green";
$teb_color_error[""]				= "purple";

// Log error
$log_error = dbquery("SELECT * FROM log_php_error
		WHERE DATE(datetime)	>= '".$datetime_start->format('Y-m-d')."'
			AND DATE(datetime)	<= '".$datetime_end->format('Y-m-d')."'
		ORDER BY datetime");

for ($i=0;$i<dbnumrows($log_error);$i++)
{
	$datetime		= new DateTime(dbresult($log_error,$i,"datetime"));
	$type_error		= dbresult($log_error,$i,"type_error");
	$ligne			= dbresult($log_error,$i,"ligne");


	$data[] = array(
			'id'		=> $i,
			'title'		=> $ligne,
			'start'		=> $datetime->format("Y-m-d H:i:s"),
			'end'		=> $datetime->format("Y-m-d H:i:s"),
			'textColor' => 'white',
			'color'		=> $teb_color_error[$type_error],
			'allDay'	=>  false
		);
}


 // jQuery wants JSON data
echo json_encode($data);