<?php
// ============
// INFO SYSTEME
// ============
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header.inc.php");?>

<script type="text/javascript"> 
<!--
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})
});
//-->
</script> 

<?php
if (disk_total_space($_SERVER['DOCUMENT_ROOT'])/1000000000 > 1000)
{
	$label = "To";
	$indice = 1000000000000;
}
else
{
	$label = "Go";
	$indice = 1000000000;
}

$espace_total	= disk_total_space($_SERVER['DOCUMENT_ROOT'])/$indice;
$espace_libre	= disk_free_space($_SERVER['DOCUMENT_ROOT'])/$indice;
$espace_occupe	= $espace_total - $espace_libre;

$yellow_from	= floor($espace_total*0.8);
$yellow_to		= floor($espace_total*0.9);

$red_from		= floor($espace_total*0.9);
$red_to			= floor($espace_total);
?>

<div class="title">Info système</div>

<table id='table_systeme' class='tablesorter-blue'>
<thead>
</thead>
<tbody>
<tr>
	<td style="width:130px"><b>Système</b></td>
	<td style="width:500px"><?php echo php_uname('s')." ".php_uname('r')." ".php_uname('v')." (".php_uname('m').")" ?></td>
</tr>
<tr>
	<td><b>Nom</b></td>
	<td><?php echo php_uname('n') ?></td>
</tr>
<tr>
	<td><b>Date/heure</b></td>
	<td><?php echo $dico[date('l')]." ".date('j')." ".$dico[date("F")]." ".date("Y")." ".date("H:i")." (<i>".date_default_timezone_get()."</i>)"?></td>
</tr>
<tr>
	<td><b>Version de PHP</b></td>
	<td><?php echo phpversion(); ?></td>
</tr>
<tr>
	<td><b>Version de MySQL</b></td>
	<td><?php echo mysqli_get_server_info($link_mysqli); ?></td>
</tr>
<tr>
	<td><b>Espace occupé C:</b></td>
	<td><?php echo round($espace_occupe,1)." ".$label ?></td>
</tr>
<tr>
	<td><b>Espace libre C:</b></td>
	<td><?php echo round($espace_libre,1)." ".$label ?></td>
</tr>
</tbody>
</table>

<p><a href='bench.php' target='_new'>Benchmark</a></p>

<script type='text/javascript'>
  google.load('visualization', '1', {packages:['gauge']});
  google.setOnLoadCallback(drawChart);
  function drawChart() {
	var data = google.visualization.arrayToDataTable([
	  ['Label', 'Value'],
	  ['<?php echo $label ?>', <?php echo floor($espace_occupe) ?>],
	]);

	var options = {
	  max:<?php echo floor($espace_total) ?>,
	  width: 400, height: 120,
	  redFrom: <?php echo $red_from ?>, redTo: <?php echo $red_to ?>,
	  yellowFrom:<?php echo $yellow_from ?>, yellowTo: <?php echo $yellow_to ?>,
	  minorTicks: 5
	};

	var chart = new google.visualization.Gauge(document.getElementById('chart_div'));
	chart.draw(data, options);
  }
</script>


<div id='chart_div'></div>

<br>

<?php
// Affiche toutes les valeurs de configuration
if ($_GET['display_all_config_value'] == "1")
{
	echo "Valeurs de config : <a href='index.php?display_all_config_value=0'>Selection</a>";
	
	echo "<table id='table_config' class='tablesorter-blue'>";
	echo "<thead><tr><th>Valeur de configuration</th><th>global_value</th></tr></thead><tbody>";

	foreach (ini_get_all() as $key => $value)
	{
		echo "<tr><td>".$key."</td>";
		echo "<td>".$value['global_value']."</td></tr>";
	}
	echo "</tbody></table>";
}
else
// Affiche des valeurs de configuration selectionnées
{
	echo "Valeurs de config : <a href='index.php?display_all_config_value=1'>Toutes</a>";
	
	$priority_display = array("error_reporting","html_errors","log_errors","magic_quotes_gpc","error_log","date.timezone","SMTP","smtp_port","allow_url_fopen","allow_url_include");

	echo "<table id='table_config' class='tablesorter-blue'>";
	echo "<thead><tr><th>Valeur de configuration</th><th>global_value</th></tr></thead><tbody>";

	foreach($priority_display as $key => $value)
	{
		echo "<tr><td>".$value."</td>";
		echo "<td>".ini_get($value)."</td></tr>";
	}
	echo "</tbody></table>";
}


// Header
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>