<?php
// ============
// FILE CABINET
// ============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.file_cabinet.inc.php");
?>

<style>
tr.line:hover	{background-color:#EEEEEE }
td.folder:hover	{background-color:#EEEEEE }
td.file:hover	{background-color:#EEEEEE }
</style>

<script type="text/javascript">
<!--
$(document).ready(function() {
	
	var finder = "<?php if ( $_GET['finder'] == "search") echo "list"; else echo $_GET['finder'] ?>";
	
	$("#directory_parent").click( function(){
     	
		<?php
		if (id_file_parent($_GET['id_file']) == "")
		{
			echo "var id_file = 'NULL'";
		}
		else
		{
			echo "var id_file = '".id_file_parent($_GET['id_file'])."'";
		}
		?>
	
		// Icone en attente
		$("#explorer").html("<div class='spinner-border spinner-border-sm' role='status'></div>"); 

		// Chargement de la page définitive
		$("#explorer").load("index_ajax.php?id_file="+id_file+"&id_usage=<?php echo $_GET['id_usage'] ?>&finder="+finder);

		$("#id_file").val(<?php echo id_file_parent($_GET['id_file']) ?>);
	});
    
    	
	// Change de repertoire
	$(".folder").click( function(){
     			
		// Icone en attente
		$("#explorer").html("<div class='spinner-border spinner-border-sm' role='status'></div>"); 

		// Chargement de la page définitive
		$("#explorer").load("index_ajax.php?id_file="+this.id+'&id_usage=<?php echo $_GET['id_usage'] ?>&finder='+finder);

		$("#id_file").val(this.id);
	});

});

//-->
</script>

<?php
// +-------------------+
// | Archive  > ACD109 |
// +-------------------+
$tab = array_reverse(tab_id_file_parent($_GET["id_file"]));

// Repertoire parent
if ($_GET['rep'] =='/')
{
    $color = "#BFBFBF";
    $id    = "directory_parent_disable";
}
else
{
    $color = "#808080";
    $id    = "directory_parent";
}
?>


<table cellpadding='5'>
<!-- Repertoire parent -->
<tr>
	<td style='text-align:center' id='<?php echo $id ?>'><i style='color:<?php echo  $color ?>s' class='fa fa-arrow-up fa-lg' aria-hidden='true'></i></td>

	<?php
	foreach ($tab as $id_file)
	{
		echo "<td style='border:1px solid #D9D9D9' style='color:#191919' class='folder' id='".$id_file."'>".file_name($id_file)." <i style='color:#808080' class='fa fa-chevron-right' aria-hidden='true'></i></td>";
	}
	?>

</tr>
</table>

<?php
// ------------------
// 1. DISPLAY : Large
// ------------------
if ($_GET['finder'] == "large")
{
	$display = get_from_parent($_GET['id_file'],$_GET['id_usage']);
	
	echo "<table border='0' cellpadding='12' cellpadding='0'>";

	if (count($display) > 0)
	{
		foreach($display as $key => $value)
		{
			if ($key % 6 == 0)
				echo "<tr>";
			
			echo "<td style='text-align:left' valign='middle'>";
			
			
			echo "<table border='0' cellpadding='4' cellpadding='0' style='width:100%'>";
			
			// -----
			// Icone
			// -----
			echo "<tr><td style='width:40px' class='".$value['folder_file']."' id='".$value['id_file']."'>";
			// Fichier + Répertoire
			echo $value['icon'];
			echo "</td>";
			
			// ---------------------
			// Nom dossier / fichier
			// ---------------------
			echo "<td class='".$value['folder_file']."' id='".$value['id_file']."'>".utf8_encode($value['file_name'])."</td>";

			echo "</tr></table>";
			
			if ($key % 6 == 5)
				echo "</tr>";
		}
	}	
	else
		echo "<tr><td>Le dossier est vide</td></tr>";
	
	echo "</table>";
}

// -----------------
// 2. DISPLAY : List
// -----------------
if ($_GET['finder'] == "list")
{
	$display = get_from_parent($_GET['id_file'],$_GET['id_usage']);
	?>
	
	<table cellpadding='5' style='position:absolute;top:50px;left:10px;width:800px'>
	<tr>
		<td colspan='2' style='color:#808080;border:1px solid #D9D9D9;width:500px'>Nom</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Modifié le</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Type</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Taille</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Action</td>
	</tr>

	<?php
	if (count($display) > 0)
	{
		foreach($display as $value)
		{
			// Icone
			echo "<tr class='line'><td style='width:30px;text-align:center;border-left:1px solid #D9D9D9' class='".$value['folder_file']."' id='".$value['id_file']."'>".$value['icon']."</td>";
				
			// Nom fichier / repertoire
			echo "<td class='".$value['folder_file']."' id='".$value['id_file']."'>".utf8_encode($value['file_name'])."</td>";
			
			// Date de modification
			echo "<td style='width:80px;border-left:1px solid #D9D9D9'>".$value['date']->format('d/m/Y H:i')."</td>";
			
			// Type
			echo "<td style='width:80px;border-left:1px solid #D9D9D9'>".$value['type']."</td>";

			// Taille du fichier
			echo "<td style='width:120px;border-left:1px solid #D9D9D9;border-right:1px solid #D9D9D9'>".size_of_file($value['size'])."</td>";

			// Telechargement de fichier
			echo "<td style='text-align:center;border-left:1px solid #D9D9D9;border-right:1px solid #D9D9D9'>";
			
			if ($value['folder_file'] <> "file")
				echo "<a class='btn btn-info' style='text-decoration:none;color:white' href='tree.php?id_file=".$value['id_file']."'><i class='fa fa-newspaper-o' aria-hidden='true'></i></a>";
			else
				echo "<a class='btn btn-info' style='text-decoration:none' href='/cabinet/admin/file_cabinet/download.php?f=".$value['file_name']."'><i class='bi bi-download fa-lg' aria-hidden='true'></i></a>";
			
			echo "</td></tr>";		
		}
	}
	else
		echo "<tr><td>Le dossier est vide</td></tr>";

	echo "</table>";
}

// ---------------------
// 3. DISPLAY : Explorer
// ---------------------
if ($_GET['finder'] == "explorer")
{
	$tab_id_file_parent = tab_id_file_parent($_GET['id_file']);
	

	echo "<table border='0' cellpadding='10' cellspacing='0'><tr>";
	
	foreach (array_reverse($tab_id_file_parent) as $key => $id_file_parent)
	{
		$display = get_from_parent($id_file_parent,$_GET['id_usage']);

		
		echo "<td valign='top'>";
		echo "<table border='0' cellpadding='10' cellspacing='0'>";

		if (count($display) > 0)
		{
			foreach($display as $key2 => $value2)
			{
				$style_explorer_1 = "";
				$style_explorer_2 = "";
				
				// Selectionné : fond gris (#D8D7D8)
				
				if ($tab_id_file_parent[$key+1] == $value2['id_file'])
				{
					$style_explorer_1 = "background-color:#D8D7D8";
					$style_explorer_2 = "background-color:#D8D7D8;
									background-image: url(right.png);
									background-position: top -5px right -10px;
									background-origin: content-box;
									background-repeat: no-repeat;";
				}
					
				
				// -----
				// Icone
				// -----
				echo "<tr id='".$key.$key2."'>";
				// Fichier
				if ($value2['folder_file'] == "file")
					echo "<td style='".$style_explorer_1."'>".$value2['icon']."</td>";
				// Repertoire
				else
					echo "<td class='folder' id='".$value2['id_file']."' style='".$style_explorer_1."'>".$value2['icon']."</td>";

				
				// ----------------------
				// Nom fichier ou dossier
				// ----------------------				
				// Fichier
				if ($value2['folder_file'] == "file")
				{
					echo "<td style='".$style_explorer_2."'>".utf8_encode($value2['file_name'])."</td>";
				
					// -------------------------
					// Telechargement de fichier
					// -------------------------
					echo "<td style='text-align:center;border-left:1px solid #D9D9D9;border-right:1px solid #D9D9D9'>";
					echo "<a class='btn btn-info' style='text-decoration:none' href='/cabinet/admin/file_cabinet/download.php?f=".$value['file_name']."'><i class='bi bi-download fa-lg' aria-hidden='true'></i></a>";
					echo "</td>";
				}
				// Répertoire
				else
				{
					echo "<td style='".$style_explorer_2."' class='folder'  id='".$value2['id_file']."'>".utf8_encode($value2['file_name'])."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>";
					echo "<td><a class='btn btn-info' style='text-decoration:none;color:white' href='tree.php?id_file=".$value2['id_file']."&f=".$value2['file_name']."'><i class='fa fa-newspaper-o ' aria-hidden='true'></i></a></td>";
				}
				echo "</tr>";
			}
		}
		else
			echo "<tr><td>Le dossier est vide</td></tr>";

		echo "</table>";
		echo "</td>";
	}
	echo "</tr></table>";
}


// -------------------
// 4. DISPLAY : Search
// -------------------
if (isset($_GET['search']))
{
	$sql_search_in_file = dbquery("SELECT *
		FROM files
		WHERE file_name LIKE '%".addslashes($_GET['search'])."%'
			AND id_usage = '".$_GET['id_usage']."'
		ORDER BY id_file ASC");
	?>
	
	<table cellpadding='5' style='position:absolute;top:50px;left:10px;width:800px'>
	<tr>
		<td colspan='2' style='color:#808080;border:1px solid #D9D9D9;width:500px'>Nom</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Modifié le</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Type</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Taille</td>
		<td style='color:#808080;border:1px solid #D9D9D9'>Action</td>
	</tr>

	<?php
	if (dbnumrows($sql_search_in_file) > 0)
	{
		for ($i=0;$i<dbnumrows($sql_search_in_file);$i++)
		{
			$id_file	= dbresult($sql_search_in_file,$i,"id_file");
			$directory	= dbresult($sql_search_in_file,$i,"directory");
			$file_name	= dbresult($sql_search_in_file,$i,"file_name");
			$date		= new DateTime(dbresult($sql_search_in_file,$i,"date"));
			$size		= dbresult($sql_search_in_file,$i,"size");
			$extension	= dbresult($sql_search_in_file,$i,"extension");
			$folder_file= dbresult($sql_search_in_file,$i,"folder_file");
			$file_type = "Fichier ".$extension;
			
			if ($folder_file == "file")
			{
				$sql_icon = dbquery("SELECT type,color,font_awesome
					FROM file
					WHERE file_extension ='".$extension."'");
				if (dbnumrows($sql_icon)>0)
				{
					$file_type		= dbresult($sql_icon,0,"type");
					$color			= dbresult($sql_icon,0,"color");
					$font_awesome	= dbresult($sql_icon,0,"font_awesome");
					$font_awesome_html = "<i style='color:".$color."' class='".$font_awesome." fa-2x' aria-hidden='true'></i>";
				}
				else
					$font_awesome_html = "<i style='color:black' class='fa fa-file-o fa-2x' aria-hidden='true'></i>";
			}			
			else
			{
				$file_type			= "xDossier de fichier";
				$font_awesome_html	= "<i style='color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
			}

			echo "<tr class='line'><td class='".$folder_file."' id='".$id_file."' style='width:30px;text-align:center;border-left:1px solid #D9D9D9'>".$font_awesome_html."</td>";
			echo "<td class='".$folder_file."' id='".$id_file."' style='text-align:left'>".$file_name."</td>";
			echo "<td style='text-align:left;border-left:1px solid #D9D9D9'>".$date->format('d/m/Y H:i')."</td>";
			echo "<td style='text-align:left;border-left:1px solid #D9D9D9'>".$file_type."</td>";
			echo "<td style='text-align:left;border-left:1px solid #D9D9D9'>".size_of_file($size)."</td>";
			
			// Telechargement de fichier
			echo "<td style='text-align:center;border-left:1px solid #D9D9D9;border-right:1px solid #D9D9D9'>";
			
			if ($folder_file == "file")
				echo "<a class='btn btn-info' style='text-decoration:none;color:white' href='download.php?f=".$file_name."'><i class='bi bi-download' aria-hidden='true'></i></a>";
			
			echo "</td></tr>";
		}
	}
	else
		echo "<tr><td>Aucun élément ne correspond à votre recherche.</td></tr>";
}