CREATE DATABASE  IF NOT EXISTS `base_cabinet` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `base_cabinet`;
-- MySQL dump 10.13  Distrib 5.6.13, for Win32 (x86)
--
-- Host: localhost    Database: base_cabinet
-- ------------------------------------------------------
-- Server version	5.5.24-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actes`
--

DROP TABLE IF EXISTS `actes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actes` (
  `id_acte` int(11) NOT NULL AUTO_INCREMENT,
  `acte` tinytext NOT NULL,
  PRIMARY KEY (`id_acte`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actes`
--

LOCK TABLES `actes` WRITE;
/*!40000 ALTER TABLE `actes` DISABLE KEYS */;
INSERT INTO `actes` VALUES (1,'Consultation patient\r\n-16 ans'),(2,'Consultation spécialisée\r\navec majoration'),(3,'Consultation demandée\r\npar un autre confrère\r\npour avis'),(4,'Provocation'),(5,'EFR (pléthysmographie)'),(6,'EFR + B2 (Test aux\r\nbeta-2-mimétiques)'),(7,'EFR + B2 + DLCO\r\n(coefficient de diffusion)'),(8,'Polygraphie'),(9,'Polysomnographie 4h'),(10,'Polysomnographie 8h'),(11,'Polysomnographie 12h');
/*!40000 ALTER TABLE `actes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actes_ccam`
--

DROP TABLE IF EXISTS `actes_ccam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actes_ccam` (
  `id_acte` int(11) NOT NULL,
  `code_ccam` char(7) NOT NULL,
  PRIMARY KEY (`id_acte`,`code_ccam`),
  KEY `code_ccam` (`code_ccam`),
  CONSTRAINT `actes_ccam_ibfk_1` FOREIGN KEY (`id_acte`) REFERENCES `actes` (`id_acte`) ON UPDATE CASCADE,
  CONSTRAINT `actes_ccam_ibfk_2` FOREIGN KEY (`code_ccam`) REFERENCES `ccam` (`code_ccam`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actes_ccam`
--

LOCK TABLES `actes_ccam` WRITE;
/*!40000 ALTER TABLE `actes_ccam` DISABLE KEYS */;
INSERT INTO `actes_ccam` VALUES (9,'AMQP010'),(10,'AMQP012'),(11,'AMQP014'),(3,'C2'),(1,'CS'),(2,'CS'),(4,'GERD002'),(5,'GLQP002'),(6,'GLQP002'),(7,'GLQP002'),(8,'GLQP007'),(2,'MCS'),(2,'MPC'),(1,'MPJ'),(6,'YYYY006'),(7,'YYYY006'),(7,'YYYY076');
/*!40000 ALTER TABLE `actes_ccam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `agenda`
--

DROP TABLE IF EXISTS `agenda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agenda` (
  `id_agenda` int(11) NOT NULL AUTO_INCREMENT,
  `id_personnel` int(11) NOT NULL DEFAULT '0',
  `id_client` int(11) DEFAULT NULL,
  `datetime_debut` datetime NOT NULL,
  `datetime_fin` datetime NOT NULL,
  `id_type_rendez_vous` int(11) NOT NULL,
  `masse` int(3) DEFAULT NULL,
  `commentaire` text NOT NULL,
  `checked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id_agenda`),
  KEY `id_personnel` (`id_personnel`),
  KEY `id_client` (`id_client`),
  KEY `datetime_debut` (`datetime_debut`),
  KEY `datetime_fin` (`datetime_fin`),
  KEY `id_type_consultation` (`id_type_rendez_vous`),
  CONSTRAINT `agenda_ibfk_1` FOREIGN KEY (`id_personnel`) REFERENCES `personnel` (`id_personnel`) ON UPDATE CASCADE,
  CONSTRAINT `agenda_ibfk_2` FOREIGN KEY (`id_client`) REFERENCES `clients` (`id_client`) ON UPDATE CASCADE,
  CONSTRAINT `agenda_ibfk_3` FOREIGN KEY (`id_type_rendez_vous`) REFERENCES `type_rendez_vous` (`id_type_rendez_vous`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3039 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `agenda`
--

LOCK TABLES `agenda` WRITE;
/*!40000 ALTER TABLE `agenda` DISABLE KEYS */;
INSERT INTO `agenda` VALUES (1,1,1,'2013-07-19 13:00:00','2013-07-19 13:30:00',1,NULL,'',0),(2,1,2,'2013-07-19 14:00:00','2013-07-19 14:30:00',1,NULL,'',0),(3,1,3,'2013-07-19 14:30:00','2013-07-19 15:00:00',1,NULL,'',0),(4,1,4,'2013-07-19 15:30:00','2013-07-19 16:00:00',1,NULL,'',0),(5,1,5,'2013-07-19 16:30:00','2013-07-19 17:00:00',1,NULL,'',0),(6,1,6,'2013-07-19 17:30:00','2013-07-19 18:00:00',1,NULL,'',0),(14,1,25,'2013-07-22 13:00:00','2013-07-22 13:30:00',1,NULL,'',0),(16,1,26,'2013-07-22 13:30:00','2013-07-22 14:00:00',1,NULL,'',0),(17,1,27,'2013-07-22 14:30:00','2013-07-22 15:00:00',1,NULL,'',0),(18,1,28,'2013-07-22 15:00:00','2013-07-22 15:30:00',1,NULL,'',0),(19,1,29,'2013-07-22 15:30:00','2013-07-22 16:00:00',1,NULL,'',0),(20,1,30,'2013-07-22 16:00:00','2013-07-22 16:30:00',2,NULL,'',0),(21,1,31,'2013-07-22 16:30:00','2013-07-22 17:00:00',1,NULL,'',0),(23,1,1,'2013-07-22 16:30:00','2013-07-22 17:00:00',2,NULL,'',0),(24,1,32,'2013-07-23 08:00:00','2013-07-23 08:30:00',1,NULL,'',0),(25,1,33,'2013-07-23 08:30:00','2013-07-23 09:00:00',1,NULL,'',0),(27,1,29,'2013-07-23 09:00:00','2013-07-23 09:30:00',2,NULL,'',0),(28,1,34,'2013-07-23 09:30:00','2013-07-23 10:00:00',1,NULL,'',0),(29,1,35,'2013-07-23 10:00:00','2013-07-23 10:30:00',2,NULL,'',0),(30,1,36,'2013-07-23 10:30:00','2013-07-23 11:00:00',2,NULL,'',0),(31,1,37,'2013-07-23 11:00:00','2013-07-23 11:30:00',1,NULL,'',0),(32,1,38,'2013-07-23 11:00:00','2013-07-23 11:30:00',2,NULL,'',0),(33,1,39,'2013-07-23 11:30:00','2013-07-23 12:00:00',1,NULL,'',0),(34,1,40,'2013-07-23 13:00:00','2013-07-23 13:30:00',1,NULL,'',0),(35,1,41,'2013-07-23 13:30:00','2013-07-23 14:00:00',1,NULL,'',0),(36,1,42,'2013-07-23 14:30:00','2013-07-23 15:00:00',1,NULL,'',0),(37,1,43,'2013-07-23 15:30:00','2013-07-23 16:00:00',1,NULL,'',0),(38,1,44,'2013-07-29 13:00:00','2013-07-29 13:30:00',1,NULL,'',0),(39,1,45,'2013-07-29 13:30:00','2013-07-29 14:00:00',1,NULL,'',0),(40,1,46,'2013-07-29 14:00:00','2013-07-29 14:30:00',1,NULL,'',0),(41,1,47,'2013-07-29 14:00:00','2013-07-29 14:30:00',2,NULL,'',0),(42,1,48,'2013-07-29 14:30:00','2013-07-29 15:00:00',1,NULL,'',0),(43,2,49,'2013-08-01 14:00:00','2013-08-01 14:30:00',2,NULL,'Recherche SAS\r\nQuestionnaire Epworth + calendrier Sommeil',0),(45,2,255,'2013-08-01 15:00:00','2013-08-01 15:30:00',2,NULL,'',0),(46,2,52,'2013-08-01 15:30:00','2013-08-01 16:00:00',2,NULL,'',0),(47,2,272,'2013-08-02 15:30:00','2013-08-02 16:00:00',2,NULL,'',0),(48,1,54,'2013-08-01 10:00:00','2013-08-01 10:30:00',1,NULL,'',0),(49,1,55,'2013-08-01 10:30:00','2013-08-01 11:00:00',1,NULL,'',0),(50,1,57,'2013-08-01 11:30:00','2013-08-01 12:00:00',1,NULL,'',0),(51,1,58,'2013-08-22 11:00:00','2013-08-22 11:30:00',2,NULL,'',0),(53,1,59,'2013-08-05 11:30:00','2013-08-05 12:00:00',2,NULL,'',0),(54,1,2,'2013-08-05 15:00:00','2013-08-05 15:30:00',2,NULL,'',0),(55,1,60,'2013-08-05 15:45:00','2013-08-05 16:15:00',2,NULL,'',0),(56,1,61,'2013-08-06 08:30:00','2013-08-06 09:00:00',2,NULL,'',0),(57,1,34,'2013-08-06 09:00:00','2013-08-06 09:30:00',2,NULL,'',0),(58,1,42,'2013-08-06 10:00:00','2013-08-06 10:30:00',1,NULL,'',0),(59,1,270,'2013-08-06 11:00:00','2013-08-06 11:30:00',2,NULL,'',0),(60,1,63,'2013-08-06 11:30:00','2013-08-06 12:00:00',2,NULL,'',0),(61,1,64,'2013-08-06 14:00:00','2013-08-06 14:30:00',2,NULL,'',0),(62,1,65,'2013-08-06 15:00:00','2013-08-06 15:30:00',2,NULL,'',0),(63,1,66,'2013-08-06 15:30:00','2013-08-06 16:00:00',2,NULL,'',0),(64,1,67,'2013-08-21 14:45:00','2013-08-21 15:15:00',2,NULL,'',0),(66,1,54,'2013-08-07 08:15:00','2013-08-07 08:45:00',2,NULL,'Sommeil de mauvaise qualité\r\nprévoir polygraphie nocturne',0),(67,1,69,'2013-08-07 09:00:00','2013-08-07 09:30:00',2,NULL,'',0),(68,1,70,'2013-08-07 10:00:00','2013-08-07 10:30:00',2,NULL,'',0),(69,1,71,'2013-08-07 10:30:00','2013-08-07 11:00:00',2,NULL,'',0),(70,1,72,'2013-08-07 11:00:00','2013-08-07 11:30:00',2,NULL,'',0),(71,1,73,'2013-08-07 11:30:00','2013-08-07 12:00:00',2,NULL,'',0),(72,1,74,'2013-08-07 14:00:00','2013-08-07 14:30:00',2,NULL,'',0),(74,1,75,'2013-08-07 15:00:00','2013-08-07 15:30:00',2,NULL,'',0),(75,1,76,'2013-08-08 16:30:00','2013-08-08 17:00:00',2,NULL,'prévoir polygraphie nocturne',0),(76,1,283,'2013-08-13 16:00:00','2013-08-13 16:30:00',2,81,'sous OLD + PPC\r\npréparer un certificat pour Air Austral le 12 Septembre 2013.\r\nPréciser Aller/Retour le 18 nov. 2013\r\n+fauteuil roulant à Roissy aux aéroports',0),(77,1,78,'2013-08-08 15:00:00','2013-08-08 15:30:00',2,110,'Bonne soeur\r\ndonner RV CS + sommeil',0),(78,1,79,'2013-08-08 15:30:00','2013-08-08 16:00:00',2,78,'',0),(79,1,57,'2013-08-08 16:00:00','2013-08-08 16:30:00',2,NULL,'sous Xolair 450 mg ts les 2 sam\r\nSeretide 500 2x2, veut 2B + kiné\r\nAerosol (B-A)x3; Eludril',0),(80,1,80,'2013-08-09 14:00:00','2013-08-09 14:30:00',2,NULL,'',0),(81,1,55,'2013-08-09 15:00:00','2013-08-09 15:30:00',2,NULL,'',0),(82,1,81,'2013-08-09 15:30:00','2013-08-09 16:00:00',2,NULL,'Asthme\r\nmis sous XOLAIR\r\nAVP avec luxation épaule gauche\r\n\r\nAerosol (B-A)+P x 2 Foradil Miflonil',0),(83,1,82,'2013-08-09 16:00:00','2013-08-09 16:30:00',2,73,'Douleur abdominal\r\nadressé au Dr. Blais\r\nsous Tarceva',0),(84,1,83,'2013-08-12 09:00:00','2013-08-12 09:30:00',2,74,'',0),(85,1,84,'2013-08-12 09:30:00','2013-08-12 10:00:00',2,77,'',0),(86,1,41,'2013-08-12 14:30:00','2013-08-12 15:00:00',2,NULL,'',0),(87,1,85,'2013-09-03 15:20:00','2013-09-03 15:50:00',1,78,'',0),(88,1,86,'2013-08-12 16:30:00','2013-08-12 17:00:00',2,NULL,'',0),(89,1,29,'2013-08-07 16:00:00','2013-08-07 17:00:00',3,NULL,'',0),(91,1,35,'2013-08-08 16:00:00','2013-08-08 17:00:00',3,NULL,'',0),(92,1,38,'2013-08-12 14:00:00','2013-08-12 15:00:00',3,NULL,'',0),(94,1,40,'2013-08-12 14:00:00','2013-08-12 14:30:00',2,NULL,'',0),(95,1,43,'2013-08-14 14:00:00','2013-08-14 15:00:00',3,NULL,'',0),(96,1,275,'2013-08-22 14:00:00','2013-08-22 15:00:00',3,NULL,'',0),(97,1,277,'2013-09-10 16:00:00','2013-09-10 17:00:00',3,NULL,'',0),(98,1,90,'2013-08-09 14:30:00','2013-08-09 15:00:00',2,89,'',0),(99,1,91,'2013-08-21 09:00:00','2013-08-21 09:30:00',2,NULL,'',0),(100,1,30,'2013-08-19 14:00:00','2013-08-19 15:00:00',3,NULL,'',0),(101,1,258,'2013-08-28 16:00:00','2013-08-28 17:00:00',3,NULL,'',0),(103,1,54,'2013-09-24 16:00:00','2013-09-24 17:00:00',3,NULL,'',0),(104,1,93,'2013-08-26 14:30:00','2013-08-26 15:00:00',2,NULL,'',0),(105,1,36,'2013-08-09 17:20:00','2013-08-09 17:50:00',1,NULL,'Interprétation polygraphie nocturne',0),(106,1,49,'2013-09-04 16:00:00','2013-09-04 17:00:00',3,NULL,'Polygraphie nocturne',0),(107,1,254,'2013-09-09 14:00:00','2013-09-09 15:00:00',3,NULL,'',0),(108,1,95,'2013-09-12 16:00:00','2013-09-12 17:00:00',4,NULL,'PSG',0),(111,3,97,'2013-09-12 10:30:00','2013-09-12 11:00:00',2,NULL,'Cs le 07/08/2013\r\ndécortication mpleurale par Pr Reboul en Avril 1978.',0),(112,3,97,'2013-10-08 15:00:00','2013-10-08 15:30:00',1,NULL,'',0),(113,3,74,'2013-10-07 16:00:00','2013-10-07 17:00:00',3,NULL,'',0),(114,3,98,'2013-10-01 09:00:00','2013-10-01 09:30:00',2,NULL,'',0),(116,3,39,'2013-10-17 15:30:00','2013-10-17 16:00:00',1,NULL,'',0),(117,3,99,'2013-10-09 11:30:00','2013-10-09 12:00:00',1,NULL,'',0),(118,3,99,'2013-08-12 11:00:00','2013-08-12 11:30:00',2,NULL,'',0),(119,3,100,'2013-08-21 11:00:00','2013-08-21 11:30:00',2,NULL,'',0),(121,3,101,'2013-08-16 16:30:00','2013-08-16 17:00:00',2,NULL,'',0),(122,3,102,'2013-08-27 09:30:00','2013-08-27 10:00:00',2,NULL,'Demander RP + Echo-doppler + GDS\nDépressif, idées sucidaires',0),(123,3,103,'2013-08-27 10:00:00','2013-08-27 10:30:00',2,NULL,'Dr Pracisnore demande NFS+GDS',0),(124,3,103,'2013-10-01 08:00:00','2013-10-01 08:30:00',1,NULL,'',0),(125,3,104,'2013-08-27 10:30:00','2013-08-27 11:00:00',2,NULL,'demande :\r\n1/ TDM thorax sans injection\r\n2/CRP, TG x 3,\r\n0 692 20 32 93',0),(126,3,113,'2013-09-13 11:30:00','2013-09-13 12:00:00',2,NULL,'',0),(127,3,113,'2013-10-09 14:30:00','2013-10-09 15:00:00',1,NULL,'Dr a dit de ne pas venir !!!!',0),(128,3,114,'2013-08-29 14:00:00','2013-08-29 14:30:00',2,NULL,'Asthme',0),(129,3,115,'2013-08-19 16:30:00','2013-08-19 17:00:00',2,NULL,'forte suspicion SAS',0),(130,3,76,'2013-09-04 09:00:00','2013-09-04 09:30:00',1,NULL,'',0),(131,3,115,'2013-08-08 16:30:00','2013-08-08 17:00:00',1,NULL,'',0),(132,3,78,'2013-10-03 14:00:00','2013-10-03 15:00:00',3,NULL,'',0),(133,3,116,'2013-08-19 15:00:00','2013-08-19 15:30:00',2,NULL,'',0),(134,3,117,'2013-08-19 15:30:00','2013-08-19 16:00:00',2,NULL,'',0),(135,3,118,'2013-08-20 16:20:00','2013-08-20 16:50:00',1,NULL,'',0),(136,3,119,'2013-09-02 14:00:00','2013-09-02 14:30:00',2,NULL,'',0),(137,3,119,'2013-10-09 15:00:00','2013-10-09 15:30:00',1,NULL,'',0),(138,3,120,'2013-09-02 15:00:00','2013-09-02 15:30:00',2,NULL,'',0),(139,3,120,'2013-09-26 16:00:00','2013-09-26 17:00:00',3,NULL,'',0),(140,3,120,'2013-09-30 14:00:00','2013-09-30 14:30:00',1,NULL,'',0),(141,3,90,'2013-10-09 16:30:00','2013-10-09 17:30:00',3,NULL,'',0),(142,3,121,'2013-09-25 08:15:00','2013-09-25 08:45:00',2,NULL,'',0),(143,3,122,'2013-09-25 09:00:00','2013-09-25 09:30:00',2,NULL,'',0),(144,3,122,'2013-10-10 09:00:00','2013-10-10 09:30:00',1,NULL,'',0),(146,3,123,'2013-08-21 10:00:00','2013-08-21 10:30:00',2,NULL,'',0),(147,2,124,'2013-08-09 17:00:00','2013-08-09 17:30:00',2,69,'',0),(148,3,5,'2013-10-09 15:30:00','2013-10-09 16:00:00',1,NULL,'',0),(149,3,36,'2013-08-13 14:30:00','2013-08-13 15:00:00',1,NULL,'',0),(150,3,125,'2013-08-14 15:00:00','2013-08-14 15:30:00',2,NULL,'',0),(153,2,126,'2013-08-12 10:00:00','2013-08-12 10:30:00',2,84,'prévoir polygraphie nocturne\r\nGDS demandé\r\nAVC en 2008',0),(154,2,127,'2013-08-12 17:00:00','2013-08-12 17:30:00',2,NULL,'',0),(155,2,128,'2013-08-13 08:00:00','2013-08-13 08:30:00',2,NULL,'',0),(156,2,129,'2013-08-13 08:30:00','2013-08-13 09:00:00',2,NULL,'prévoir polygraphie nocturne\r\nfaire lettre pour Dr. Hossenboccus',0),(157,2,45,'2013-08-13 09:00:00','2013-08-13 09:30:00',2,NULL,'faire agenda de sommeil pour SAS',0),(158,2,131,'2013-08-13 09:30:00','2013-08-13 10:00:00',2,NULL,'',0),(159,2,132,'2013-08-13 10:00:00','2013-08-13 10:30:00',2,NULL,'',0),(161,2,134,'2013-08-14 11:00:00','2013-08-14 11:30:00',2,NULL,'',0),(162,2,35,'2013-08-13 16:45:00','2013-08-13 17:15:00',1,NULL,'polygraphie nocturne',0),(163,2,135,'2013-08-14 09:00:00','2013-08-14 09:30:00',2,NULL,'',0),(164,2,136,'2013-08-14 09:30:00','2013-08-14 10:00:00',2,NULL,'',0),(165,2,137,'2013-08-14 10:00:00','2013-08-14 10:30:00',2,NULL,'',0),(166,2,138,'2013-08-14 11:30:00','2013-08-14 12:00:00',2,NULL,'',0),(167,2,139,'2013-08-14 16:00:00','2013-08-14 16:30:00',2,NULL,'voir TDM Thorax + echocoeur mesure PAP',0),(168,2,95,'2013-08-14 17:00:00','2013-08-14 17:30:00',2,NULL,'',0),(169,2,33,'2013-08-16 09:00:00','2013-08-16 09:30:00',2,NULL,'',0),(170,2,46,'2013-08-16 09:30:00','2013-08-16 10:00:00',2,NULL,'',0),(171,2,48,'2013-08-16 10:00:00','2013-08-16 10:30:00',2,NULL,'prévoir agenda sommeil + polygraphie nocturne',0),(172,2,140,'2013-08-16 11:00:00','2013-08-16 11:30:00',2,NULL,'',0),(173,2,141,'2013-08-16 15:00:00','2013-08-16 15:30:00',2,NULL,'',0),(174,2,142,'2013-08-16 16:00:00','2013-08-16 16:30:00',2,NULL,'',0),(175,2,143,'2013-08-16 16:30:00','2013-08-16 17:00:00',2,NULL,'',0),(177,2,145,'2013-08-20 08:00:00','2013-08-20 08:30:00',2,NULL,'prévoir rendez-vous pour polygraphie nocturne à donner',0),(180,2,147,'2013-08-20 10:00:00','2013-08-20 10:30:00',2,NULL,'',0),(181,2,148,'2013-08-20 11:00:00','2013-08-20 11:30:00',2,NULL,'',0),(182,2,42,'2013-08-20 14:15:00','2013-08-20 14:45:00',2,NULL,'',0),(183,2,60,'2013-08-20 16:00:00','2013-08-20 17:00:00',3,NULL,'',0),(184,2,44,'2013-08-21 08:15:00','2013-08-21 08:45:00',2,74,'faire agenda de sommeil',0),(185,2,149,'2013-08-21 11:30:00','2013-08-21 12:00:00',2,NULL,'',0),(186,2,150,'2013-08-22 15:00:00','2013-08-22 15:30:00',2,NULL,'',0),(187,2,151,'2013-08-22 09:00:00','2013-08-22 09:30:00',2,NULL,'Donner RV pour exploration de sommeil\r\nvoir OLD Respidom',0),(188,2,152,'2013-08-22 10:00:00','2013-08-22 10:30:00',2,NULL,'Aérosol (B-A) + Foradil + Miflonil + kiné',0),(189,2,153,'2013-08-27 09:00:00','2013-08-27 09:30:00',2,NULL,'',0),(190,2,105,'2013-08-27 11:00:00','2013-08-27 11:30:00',2,NULL,'Aérosol (B-A) x 3 + pub x 2 + kiné + pneumo',0),(191,2,47,'2013-08-28 08:00:00','2013-08-28 08:30:00',2,NULL,'',0),(192,2,154,'2013-08-28 09:00:00','2013-08-28 09:30:00',2,NULL,'',0),(193,2,155,'2013-08-28 11:00:00','2013-08-28 11:30:00',2,NULL,'',0),(194,2,156,'2013-08-29 08:30:00','2013-08-29 09:00:00',2,NULL,'',0),(195,2,263,'2013-09-04 14:00:00','2013-09-04 14:30:00',2,NULL,'',0),(196,2,2,'2013-09-04 14:30:00','2013-09-04 15:00:00',2,NULL,'',0),(197,2,157,'2013-09-06 16:30:00','2013-09-06 17:00:00',2,NULL,'enfant de 2 ans',0),(198,2,86,'2013-09-16 14:00:00','2013-09-16 15:00:00',3,NULL,'',0),(199,2,145,'2013-10-01 16:00:00','2013-10-01 17:00:00',3,NULL,'',0),(200,3,84,'2013-10-07 10:00:00','2013-10-07 10:30:00',1,NULL,'',0),(201,3,126,'2013-10-07 14:15:00','2013-10-07 14:45:00',1,NULL,'',0),(202,3,126,'2013-10-21 16:00:00','2013-10-21 17:00:00',3,NULL,'',0),(203,3,158,'2013-10-01 15:30:00','2013-10-01 16:00:00',1,NULL,'',0),(204,3,158,'2013-08-22 15:00:00','2013-08-22 15:30:00',2,NULL,'',0),(205,2,159,'2013-08-22 16:00:00','2013-08-22 16:30:00',2,NULL,'Est venu en consultation le lundi 12/08/2013 Patient No 2.',0),(208,2,161,'2013-08-26 16:00:00','2013-08-26 16:30:00',2,NULL,'',0),(209,3,161,'2013-11-04 14:00:00','2013-11-04 14:30:00',1,NULL,'Est venue en consultation le 12/08/2013 Patiente No 4.',0),(210,2,40,'2013-10-14 16:00:00','2013-10-14 17:00:00',3,NULL,'',0),(211,3,40,'2013-10-15 08:00:00','2013-10-15 08:30:00',1,NULL,'',0),(212,3,41,'2013-10-15 08:30:00','2013-10-15 09:00:00',1,NULL,'',0),(215,3,127,'2013-10-07 16:30:00','2013-10-07 17:00:00',1,NULL,'',0),(218,2,164,'2013-09-03 17:00:00','2013-09-03 18:00:00',3,NULL,'',0),(219,2,164,'2013-08-12 18:00:00','2013-08-12 18:30:00',2,NULL,'',0),(221,3,165,'2013-08-26 15:20:00','2013-08-26 15:50:00',1,NULL,'Cf Cs du 13/08/2013 à 8:00',0),(223,3,166,'2013-08-29 09:00:00','2013-08-29 09:30:00',2,NULL,'Appareillé  avec ISIS Médical',0),(225,3,128,'2013-10-11 08:00:00','2013-10-11 08:30:00',1,NULL,'EFR du 13/08/2013',0),(226,3,167,'2013-09-05 14:00:00','2013-09-05 14:30:00',2,NULL,'Cs du 13/08/2013 patient No 3.',0),(227,3,167,'2013-10-11 10:00:00','2013-10-11 10:30:00',1,NULL,'',0),(228,2,129,'2013-10-23 16:00:00','2013-10-23 17:00:00',3,NULL,'',0),(230,3,168,'2013-10-08 09:15:00','2013-10-08 09:45:00',1,NULL,'',0),(231,3,169,'2013-09-03 08:00:00','2013-09-03 08:30:00',2,NULL,'Cs du 13/08/2013 pt4',0),(232,3,169,'2013-10-11 09:00:00','2013-10-11 09:30:00',1,NULL,'',0),(233,3,170,'2013-08-27 14:20:00','2013-08-27 14:50:00',1,NULL,'',0),(234,3,45,'2013-10-10 11:00:00','2013-10-10 11:30:00',1,NULL,'',0),(235,3,171,'2013-11-08 09:00:00','2013-11-08 09:30:00',1,NULL,'',0),(237,2,131,'2013-10-07 08:00:00','2013-10-07 08:30:00',1,NULL,'',0),(238,3,173,'2013-09-04 09:00:00','2013-09-04 09:30:00',2,NULL,'patiente n°7 du 13/08/2013',0),(239,3,173,'2013-10-16 09:00:00','2013-10-16 09:30:00',1,NULL,'',0),(240,3,132,'2013-10-31 09:00:00','2013-10-31 09:30:00',1,NULL,'avait rdv de sommeil en octobre. A preferé le faire à l\'hopital.',0),(241,3,174,'2013-08-28 14:00:00','2013-08-28 14:30:00',2,NULL,'Cs du 13/08/2013 pte No8',0),(242,3,174,'2013-10-18 14:00:00','2013-10-18 14:30:00',1,NULL,'',0),(244,3,175,'2013-09-03 09:00:00','2013-09-03 09:30:00',2,NULL,'Cs le 14/08/2013',0),(245,3,175,'2013-10-29 08:00:00','2013-10-29 08:30:00',1,NULL,'',0),(246,3,175,'2013-10-30 16:00:00','2013-10-30 17:00:00',3,NULL,'',0),(247,3,176,'2013-09-05 08:00:00','2013-09-05 08:30:00',2,NULL,'Cs le 14/08/2013',0),(249,3,177,'2013-09-03 10:00:00','2013-09-03 10:30:00',2,NULL,'Cs le 14/08/2013',0),(250,3,177,'2013-10-29 08:30:00','2013-10-29 09:00:00',1,NULL,'',0),(251,3,135,'2013-09-20 15:00:00','2013-09-20 15:30:00',1,NULL,'EFR le 14/08/2013',0),(252,3,178,'2013-09-09 11:00:00','2013-09-09 11:30:00',2,NULL,'Cs le 14/08/2013',0),(253,3,178,'2013-10-28 11:00:00','2013-10-28 11:30:00',1,NULL,'',0),(254,3,136,'2013-10-07 08:30:00','2013-10-07 09:00:00',1,NULL,'EFR du 14/08/2013',0),(256,3,137,'2013-09-04 10:00:00','2013-09-04 10:30:00',1,NULL,'EFR du 14/08/2013',0),(257,3,25,'2013-09-04 11:00:00','2013-09-04 11:30:00',2,NULL,'PSG  avec 31 IAH',0),(258,3,25,'2013-11-06 11:00:00','2013-11-06 11:30:00',1,NULL,'IAH à 31',0),(259,2,29,'2013-08-19 13:30:00','2013-08-19 14:30:00',3,NULL,'',0),(260,3,134,'2013-10-01 15:00:00','2013-10-01 15:30:00',1,NULL,'EFR le 14/08/2013',0),(263,3,138,'2013-10-15 10:00:00','2013-10-15 10:30:00',1,NULL,'',0),(264,3,179,'2013-09-03 15:45:00','2013-09-03 16:15:00',2,NULL,'Spondyle Ankylosante',0),(265,3,180,'2013-09-27 14:00:00','2013-09-27 14:30:00',2,NULL,'Tuberculose pulmonaire guéri',0),(266,3,181,'2013-09-10 09:00:00','2013-09-10 09:30:00',2,NULL,'Cs du 14/08/2013',0),(269,3,182,'2013-09-11 09:30:00','2013-09-11 10:00:00',2,NULL,'Cs du 14/08/2013',0),(270,3,182,'2013-11-05 09:30:00','2013-11-05 10:00:00',1,NULL,'',0),(271,2,183,'2013-08-20 15:00:00','2013-08-20 15:30:00',2,NULL,'60\'s',0),(272,3,184,'2013-09-05 15:00:00','2013-09-05 15:30:00',2,NULL,'',0),(273,3,184,'2013-11-07 08:30:00','2013-11-07 09:00:00',1,NULL,'',0),(274,3,185,'2013-09-06 15:00:00','2013-09-06 15:30:00',2,NULL,'Cs le 14/08/2013',0),(275,3,185,'2013-11-14 08:00:00','2013-11-14 08:30:00',1,NULL,'',0),(276,2,185,'2013-11-13 16:00:00','2013-11-13 17:00:00',3,NULL,'Sommeil leger, dort sous O2',0),(277,3,75,'2013-08-23 16:40:00','2013-08-23 17:10:00',1,NULL,'',0),(278,3,125,'2013-08-30 16:30:00','2013-08-30 17:00:00',1,NULL,'',0),(279,3,186,'2013-09-04 15:00:00','2013-09-04 15:30:00',2,NULL,'Cs le 14/08/2013',0),(280,2,186,'2013-11-20 16:00:00','2013-11-20 17:00:00',3,NULL,'',0),(282,3,187,'2013-09-10 08:15:00','2013-09-10 08:45:00',2,NULL,'Cs du 15/08/2013',0),(283,3,187,'2013-10-28 16:15:00','2013-10-28 16:45:00',1,NULL,'EFR le 10/09/2013',0),(284,3,188,'2013-09-24 10:00:00','2013-09-24 10:30:00',2,NULL,'Cs du 15/08/2013',0),(285,3,188,'2013-11-05 11:00:00','2013-11-05 11:30:00',1,NULL,'prevoir score d\'epworth',0),(286,3,189,'2013-09-24 10:30:00','2013-09-24 11:00:00',2,NULL,'',0),(287,3,189,'2013-11-05 11:30:00','2013-11-05 12:00:00',1,NULL,'Cs le 15/08/2013',0),(288,3,190,'2013-09-27 14:30:00','2013-09-27 15:00:00',1,NULL,'BPC0 Schizophénie AVC  Parkinson H',0),(289,3,33,'2013-11-07 10:00:00','2013-11-07 10:30:00',1,NULL,'',0),(291,3,48,'2013-09-10 10:00:00','2013-09-10 10:30:00',1,NULL,'',0),(293,3,140,'2013-09-13 14:00:00','2013-09-13 14:30:00',2,NULL,'',0),(294,3,191,'2013-08-20 08:30:00','2013-08-20 09:00:00',2,NULL,'',0),(295,3,192,'2013-09-02 16:15:00','2013-09-02 16:45:00',2,NULL,'Cs du 16/08/2013',0),(296,3,192,'2013-10-30 10:00:00','2013-10-30 10:30:00',1,NULL,'',0),(297,3,193,'2013-09-10 10:00:00','2013-09-10 10:30:00',2,NULL,'Cs du 16/08/2013',0),(298,3,193,'2013-10-31 10:00:00','2013-10-31 10:30:00',1,NULL,'',0),(299,3,194,'2013-09-04 10:00:00','2013-09-04 10:30:00',2,NULL,'cs du 16/08/2013',0),(300,3,194,'2013-10-23 09:00:00','2013-10-23 09:30:00',1,NULL,'',0),(301,3,195,'2013-09-03 10:30:00','2013-09-03 11:00:00',2,NULL,'',0),(302,3,195,'2013-10-17 14:00:00','2013-10-17 14:30:00',1,NULL,'',0),(303,3,196,'2013-09-05 09:00:00','2013-09-05 09:30:00',2,NULL,'Cs le 16/08/2013',0),(304,3,196,'2013-12-05 11:00:00','2013-12-05 11:30:00',1,NULL,'',0),(305,3,141,'2013-10-07 15:00:00','2013-10-07 15:30:00',1,NULL,'EFR du 16/08/2013',0),(306,3,36,'2013-08-23 13:45:00','2013-08-23 14:15:00',1,NULL,'',0),(307,3,197,'2013-09-04 08:30:00','2013-09-04 09:00:00',2,NULL,'',0),(309,3,142,'2013-09-03 15:40:00','2013-09-03 16:10:00',1,NULL,'EFR du 16/08/2013',0),(310,3,198,'2013-09-03 11:15:00','2013-09-03 11:45:00',2,NULL,'Cs du 2 et 16/08/2013',0),(311,3,198,'2013-10-29 10:00:00','2013-10-29 10:30:00',1,NULL,'',0),(312,3,143,'2013-09-13 10:30:00','2013-09-13 11:00:00',1,NULL,'EFR du 16/08/2013',0),(314,3,101,'2013-10-30 17:00:00','2013-10-30 17:30:00',1,NULL,'EFR à prévoir',0),(315,3,101,'2013-10-25 17:00:00','2013-10-25 17:30:00',2,NULL,'',0),(316,3,199,'2013-09-09 10:00:00','2013-09-09 10:30:00',2,NULL,'',0),(318,2,200,'2013-08-28 14:45:00','2013-08-28 15:15:00',2,NULL,'',0),(319,3,201,'2013-10-01 09:30:00','2013-10-01 10:00:00',2,NULL,'',0),(320,3,201,'2013-10-11 10:30:00','2013-10-11 11:00:00',1,NULL,'',0),(321,3,30,'2013-09-04 14:00:00','2013-09-04 14:30:00',1,NULL,'',0),(322,3,202,'2013-10-01 10:00:00','2013-10-01 10:30:00',2,NULL,'Cs le 19/08/2013\r\nNe pas oublier expliquer Polygraphie nocturne Décédé oct 2013',0),(325,3,117,'2013-10-14 10:00:00','2013-10-14 10:30:00',1,NULL,'',0),(326,3,203,'2013-09-03 14:00:00','2013-09-03 14:30:00',2,NULL,'',0),(327,3,203,'2013-10-29 14:00:00','2013-10-29 14:30:00',1,NULL,'',0),(328,2,203,'2013-11-19 16:30:00','2013-11-19 17:30:00',3,NULL,'',0),(329,2,115,'2013-08-29 17:30:00','2013-08-29 18:30:00',3,NULL,'',0),(331,1,191,'2013-08-19 17:00:00','2013-08-19 17:30:00',1,NULL,'',0),(332,3,145,'2013-10-17 08:00:00','2013-10-17 08:30:00',1,NULL,'rechercher une malformation cranio faciale',0),(333,3,204,'2013-09-24 11:00:00','2013-09-24 11:30:00',2,NULL,'Cs du 20/08/2013',0),(334,2,206,'2013-08-20 09:00:00','2013-08-20 09:30:00',2,NULL,'',0),(335,3,204,'2013-08-27 08:20:00','2013-08-27 08:50:00',1,NULL,'',0),(336,2,206,'2013-10-28 12:00:00','2013-10-28 12:30:00',1,NULL,'',0),(337,3,205,'2013-10-14 15:00:00','2013-10-14 15:30:00',1,NULL,'',0),(339,3,207,'2013-10-14 11:00:00','2013-10-14 11:30:00',1,NULL,'EFR le  14/10/2013 et cs le 20/08/2013. hospitalisée vers 12 nov : ne peut venir à son efr',0),(340,3,208,'2013-09-27 14:30:00','2013-09-27 15:00:00',2,NULL,'Cs le 20/08/2013',0),(341,3,208,'2013-10-15 10:30:00','2013-10-15 11:00:00',1,NULL,'',0),(342,3,147,'2013-10-16 09:30:00','2013-10-16 10:00:00',1,NULL,'EFR du 20/08/2013',0),(343,2,147,'2013-11-18 16:00:00','2013-11-18 17:00:00',3,NULL,'',0),(344,3,148,'2013-10-07 15:30:00','2013-10-07 16:00:00',1,NULL,'EFR du 20/08/2013',0),(345,3,209,'2013-08-21 14:00:00','2013-08-21 14:30:00',2,NULL,'',0),(346,3,210,'2013-09-25 14:00:00','2013-09-25 14:30:00',2,NULL,'',0),(347,3,210,'2013-11-06 14:00:00','2013-11-06 14:30:00',1,NULL,'Cs du 20/08/2013\r\nregarder aussi le 28/08/2013 (pas venue)',0),(348,3,42,'2013-09-19 14:20:00','2013-09-19 14:50:00',1,NULL,'EFR du 20/08/2013',0),(349,3,42,'2013-11-25 16:00:00','2013-11-25 17:00:00',3,NULL,'',0),(350,3,211,'2013-10-01 14:00:00','2013-10-01 14:30:00',2,NULL,'',0),(351,3,211,'2013-11-08 14:00:00','2013-11-08 14:30:00',1,NULL,'Cs du 20/08/2013',0),(353,3,212,'2013-09-26 09:00:00','2013-09-26 09:30:00',2,NULL,'Cs du 20/08/2013',0),(354,3,212,'2013-10-09 09:00:00','2013-10-09 09:30:00',1,NULL,'',0),(355,3,213,'2013-09-26 10:00:00','2013-09-26 10:30:00',2,NULL,'Cs le 20/08/2013',0),(357,2,213,'2013-11-27 16:00:00','2013-11-27 17:00:00',3,NULL,'',0),(358,3,43,'2013-08-28 08:40:00','2013-08-28 09:10:00',1,NULL,'sommeil',0),(359,3,214,'2013-09-25 10:30:00','2013-09-25 11:00:00',2,NULL,'Cs du 21/08/2013',0),(360,3,214,'2013-10-23 08:00:00','2013-10-23 08:30:00',1,NULL,'',0),(361,3,215,'2013-10-08 08:00:00','2013-10-08 08:30:00',2,NULL,'n\'est pasvenu chercher son résultat du efr ; rappellera.',0),(363,3,216,'2013-08-29 14:30:00','2013-08-29 15:00:00',2,NULL,'',0),(364,3,44,'2013-12-02 16:00:00','2013-12-02 17:00:00',3,NULL,'',0),(365,3,217,'2013-08-26 15:40:00','2013-08-26 16:10:00',1,NULL,'Cs du 21/08/2013\r\nPrévoir EFR',0),(366,3,218,'2013-09-27 15:00:00','2013-09-27 15:30:00',2,NULL,'Cs du 21/08/2013',0),(367,3,218,'2013-10-21 09:00:00','2013-10-21 09:30:00',1,NULL,'',0),(368,3,219,'2013-09-06 14:00:00','2013-09-06 14:30:00',2,NULL,'Cs du 21/08/2013',0),(369,3,219,'2013-10-18 15:00:00','2013-10-18 15:30:00',1,NULL,'EFR du 06/09/2013\r\nA refusé de venir en Cs le 18/10/2013.',0),(370,3,220,'2013-09-26 09:30:00','2013-09-26 10:00:00',2,NULL,'',0),(371,3,220,'2013-10-25 08:00:00','2013-10-25 08:30:00',1,NULL,'',0),(374,3,222,'2013-09-25 14:30:00','2013-09-25 15:00:00',2,NULL,'Cs du 21/08/2013\r\nSuspicion de SAS',0),(375,3,222,'2013-10-15 16:00:00','2013-10-15 17:00:00',3,NULL,'',0),(376,3,222,'2013-10-21 11:00:00','2013-10-21 11:30:00',1,NULL,'',0),(377,3,223,'2013-09-05 15:30:00','2013-09-05 16:00:00',2,NULL,'Cs du 21/08/2013',0),(378,3,223,'2013-10-16 15:00:00','2013-10-16 15:30:00',1,NULL,'',0),(379,3,224,'2013-09-05 16:00:00','2013-09-05 16:30:00',2,NULL,'Cs du 21/08/2013',0),(380,3,224,'2013-10-16 15:30:00','2013-10-16 16:00:00',1,NULL,'Cs du 21/08/2013',0),(381,3,225,'2013-09-03 15:00:00','2013-09-03 15:30:00',2,NULL,'Cs du 21/08/2013',0),(382,2,227,'2013-09-24 14:45:00','2013-09-24 15:15:00',2,NULL,'',0),(383,2,227,'2013-08-22 08:15:00','2013-08-22 08:45:00',1,NULL,'',0),(384,3,228,'2013-10-08 15:00:00','2013-10-08 15:30:00',2,NULL,'',0),(385,3,228,'2013-10-15 14:00:00','2013-10-15 14:30:00',1,NULL,'',0),(386,3,228,'2013-12-12 16:00:00','2013-12-12 17:00:00',3,NULL,'Cs du 22/08/2013',0),(387,3,229,'2013-10-08 15:00:00','2013-10-08 15:30:00',2,NULL,'cs du 22/08/2013',0),(388,3,229,'2013-10-23 15:00:00','2013-10-23 15:30:00',1,NULL,'',0),(389,3,230,'2013-10-09 08:00:00','2013-10-09 08:30:00',2,NULL,'',0),(390,3,230,'2013-10-30 08:00:00','2013-10-30 08:30:00',1,NULL,'Cs du 22/08/2013',0),(392,2,231,'2013-08-29 10:30:00','2013-08-29 11:00:00',2,NULL,'adressé par l\'hôpital psychiatrique',0),(394,3,232,'2013-09-25 15:00:00','2013-09-25 15:30:00',2,NULL,'',0),(395,3,232,'2013-11-06 15:00:00','2013-11-06 15:30:00',1,NULL,'Cs du 22/08/2013',0),(396,2,233,'2013-09-26 16:00:00','2013-09-26 17:00:00',3,NULL,'',0),(397,2,235,'2013-08-22 11:00:00','2013-08-22 11:30:00',1,NULL,'',0),(398,2,234,'2013-10-08 08:45:00','2013-10-08 09:15:00',2,NULL,'',0),(399,3,234,'2013-11-08 08:00:00','2013-11-08 08:30:00',1,NULL,'',0),(400,3,234,'2013-08-22 11:00:00','2013-08-22 11:30:00',1,NULL,'',0),(402,3,236,'2013-08-29 11:20:00','2013-08-29 11:50:00',1,NULL,'',0),(403,3,235,'2013-10-15 08:15:00','2013-10-15 08:45:00',2,NULL,'Scanner thoracique à voir .\r\ndossier à passer en RCP d\'Oncologie thoracique\r\nSous IRESSA.',0),(404,2,237,'2013-08-22 11:30:00','2013-08-22 12:00:00',1,NULL,'',0),(405,3,237,'2013-07-31 08:00:00','2013-07-31 08:30:00',2,NULL,'',0),(406,3,237,'2013-10-22 08:30:00','2013-10-22 09:00:00',1,NULL,'',0),(407,2,238,'2013-08-22 14:30:00','2013-08-22 15:00:00',1,NULL,'',0),(408,3,238,'2013-10-18 18:15:00','2013-10-18 19:15:00',4,NULL,'PSG',0),(409,3,238,'2013-10-17 08:15:00','2013-10-17 08:45:00',2,NULL,'',0),(410,3,238,'2013-10-23 08:30:00','2013-10-23 09:00:00',1,NULL,'',0),(411,3,150,'2013-10-07 09:00:00','2013-10-07 09:30:00',1,NULL,'EFr du 22/08/2013',0),(412,3,159,'2013-09-09 16:00:00','2013-09-09 16:30:00',1,NULL,'EFR du 22/08/2013',0),(413,3,66,'2013-08-23 13:30:00','2013-08-23 14:00:00',1,NULL,'',0),(415,4,1,'2013-08-23 14:40:00','2013-08-23 15:10:00',1,NULL,'cf 19/07/2013 a 14:00',0),(416,3,240,'2013-10-15 09:00:00','2013-10-15 09:30:00',2,NULL,'',0),(417,3,240,'2013-12-10 09:00:00','2013-12-10 09:30:00',1,NULL,'Cs du 23/08 et EFR du 15/10/2013',0),(418,3,241,'2013-10-02 14:00:00','2013-10-02 14:30:00',2,NULL,'Cs le 23/08',0),(419,3,241,'2013-10-23 14:00:00','2013-10-23 14:30:00',1,NULL,'',0),(420,3,242,'2013-09-06 15:30:00','2013-09-06 16:00:00',1,NULL,'',0),(421,3,243,'2013-09-26 11:00:00','2013-09-26 11:30:00',2,NULL,'Cs du 23/08/2013',0),(422,3,243,'2013-10-16 08:30:00','2013-10-16 09:00:00',1,NULL,'',0),(423,3,75,'2013-10-10 16:00:00','2013-10-10 17:00:00',3,NULL,'',0),(425,4,325,'2013-08-29 09:30:00','2013-08-29 10:00:00',1,NULL,'',0),(426,3,30,'2013-07-19 12:30:00','2013-07-19 13:00:00',1,NULL,'',0),(427,3,248,'2013-07-22 17:00:00','2013-07-22 17:30:00',1,NULL,'',0),(428,3,249,'2013-07-22 17:30:00','2013-07-22 18:00:00',1,NULL,'',0),(429,3,35,'2013-07-22 18:00:00','2013-07-22 18:30:00',1,NULL,'',0),(430,3,38,'2013-07-22 18:30:00','2013-07-22 19:00:00',1,NULL,'',0),(431,3,132,'2013-07-22 19:00:00','2013-07-22 19:30:00',1,NULL,'',0),(432,3,36,'2013-07-22 19:30:00','2013-07-22 20:00:00',1,NULL,'',0),(433,3,144,'2013-07-22 20:00:00','2013-07-22 20:30:00',1,NULL,'',0),(434,3,253,'2013-07-24 08:00:00','2013-07-24 08:30:00',1,NULL,'',0),(435,3,254,'2013-07-24 08:30:00','2013-07-24 09:00:00',1,NULL,'Astme sous xolair',0),(436,3,255,'2013-07-24 09:00:00','2013-07-24 09:30:00',1,NULL,'SAS  ARAR',0),(437,3,52,'2013-07-24 09:30:00','2013-07-24 10:00:00',1,NULL,'Adeno K TTF1 + lobectomie std 2b +CT adj',0),(438,3,47,'2013-07-24 10:00:00','2013-07-24 10:30:00',1,NULL,'Carci pulmr Primitif lobectomie sup Gche T1N0M0',0),(439,3,258,'2013-07-24 10:30:00','2013-07-24 11:00:00',1,NULL,'micro nodules LM',0),(440,3,259,'2013-07-24 11:00:00','2013-07-24 11:30:00',1,NULL,'',0),(441,3,260,'2013-07-24 11:30:00','2013-07-24 12:00:00',1,NULL,'',0),(442,3,261,'2013-07-24 12:00:00','2013-07-24 12:30:00',1,NULL,'',0),(443,3,262,'2013-07-24 14:00:00','2013-07-24 14:30:00',1,NULL,'',0),(444,3,263,'2013-07-24 14:30:00','2013-07-24 15:00:00',1,NULL,'Respidom',0),(445,3,153,'2013-07-25 08:00:00','2013-07-25 08:30:00',1,NULL,'',0),(446,3,131,'2013-07-25 08:30:00','2013-07-25 09:00:00',1,NULL,'',0),(447,3,165,'2013-07-25 09:00:00','2013-07-25 09:30:00',1,NULL,'',0),(448,3,135,'2013-07-25 09:30:00','2013-07-25 10:00:00',1,NULL,'',0),(449,3,136,'2013-07-25 10:00:00','2013-07-25 10:30:00',1,NULL,'Asthme sous Xolair',0),(450,3,83,'2013-07-25 10:30:00','2013-07-25 11:00:00',1,NULL,'',0),(451,3,270,'2013-07-25 11:00:00','2013-07-25 11:30:00',1,NULL,'',0),(452,3,271,'2013-07-25 11:30:00','2013-07-25 12:00:00',1,NULL,'AdenoK du LSD T2N0M1a\r\nsous IRESSA,ARIXTRA et OLD.',0),(453,3,272,'2013-07-25 12:00:00','2013-07-25 12:30:00',1,NULL,'',0),(454,3,273,'2013-07-25 14:00:00','2013-07-25 14:30:00',1,NULL,'agenda de sommeil',0),(455,3,80,'2013-07-25 14:30:00','2013-07-25 15:00:00',1,NULL,'Asthme grave ne prend pas de ttt de fond',0),(456,3,275,'2013-07-25 15:00:00','2013-07-25 15:30:00',1,NULL,'',0),(457,3,85,'2013-07-25 15:30:00','2013-07-25 16:00:00',1,NULL,'',0),(458,3,277,'2013-07-25 16:00:00','2013-07-25 16:30:00',1,NULL,'',0),(459,3,278,'2013-07-25 16:30:00','2013-07-25 17:00:00',1,NULL,'lobectomie Lm et tumorectomie le 04/07/2008 = 4 lignes de cT:1.CDDP NVB\r\n2.alimta 3..Tarceva 4.taxotere\r\nEn progression moderée.',0),(460,3,237,'2013-07-26 14:00:00','2013-07-26 14:30:00',1,NULL,'ARAR',0),(461,3,280,'2013-07-26 14:30:00','2013-07-26 15:00:00',1,NULL,'',0),(462,3,281,'2013-07-26 15:00:00','2013-07-26 15:30:00',1,NULL,'Sous anti TNF alpha.\r\nTub Latente',0),(463,3,282,'2013-07-26 15:30:00','2013-07-26 16:00:00',1,NULL,'ISIS sous VNI et OLD.',0),(464,3,283,'2013-07-26 16:00:00','2013-07-26 16:30:00',1,NULL,'ARAR PPC OLD',0),(465,3,139,'2013-07-26 16:30:00','2013-07-26 17:00:00',1,NULL,'SAS  ISIS',0),(466,3,143,'2013-07-26 17:00:00','2013-07-26 17:30:00',1,NULL,'',0),(467,3,124,'2013-07-29 15:00:00','2013-07-29 15:30:00',1,NULL,'AdenoK colorectal avec meta hepatique et pulmonaires',0),(468,3,287,'2013-07-29 15:30:00','2013-07-29 16:00:00',1,NULL,'Asthme',0),(470,3,293,'2013-10-07 14:00:00','2013-10-07 14:30:00',2,NULL,'Cs du 26/08/2013',0),(471,3,293,'2013-11-04 13:30:00','2013-11-04 14:00:00',1,NULL,'',0),(472,2,293,'2013-12-11 14:00:00','2013-12-11 15:00:00',3,NULL,'',0),(473,3,249,'2013-09-02 16:00:00','2013-09-02 16:30:00',1,NULL,'',0),(475,3,298,'2013-09-26 14:00:00','2013-09-26 14:30:00',2,NULL,'',0),(477,3,298,'2013-10-25 14:00:00','2013-10-25 14:30:00',1,NULL,'Cs du 26/08/2013',0),(478,3,93,'2013-11-13 08:00:00','2013-11-13 08:30:00',1,NULL,'EFR le 26/08/2013',0),(479,3,217,'2013-10-10 14:00:00','2013-10-10 14:30:00',2,NULL,'',0),(480,3,217,'2013-10-22 14:00:00','2013-10-22 14:30:00',1,NULL,'',0),(481,3,73,'2013-08-27 09:30:00','2013-08-27 10:00:00',1,NULL,'',0),(482,3,73,'2013-09-04 10:30:00','2013-09-04 11:00:00',1,NULL,'rappelera pour nouveau RV',0),(483,4,278,'2013-08-27 10:45:00','2013-08-27 11:15:00',1,NULL,'',0),(484,3,278,'2013-10-28 10:30:00','2013-10-28 11:00:00',1,NULL,'',0),(485,3,104,'2013-10-16 10:00:00','2013-10-16 10:30:00',1,NULL,'',0),(486,4,309,'2013-08-27 11:20:00','2013-08-27 11:50:00',1,NULL,'',0),(487,3,309,'2013-09-25 11:15:00','2013-09-25 11:45:00',2,NULL,'Cs du 27/08/2013',0),(488,3,309,'2013-10-24 08:00:00','2013-10-24 08:30:00',1,NULL,'',0),(489,3,310,'2013-10-01 08:15:00','2013-10-01 08:45:00',2,NULL,'cs du 27/08/2013',0),(490,3,310,'2013-11-18 08:00:00','2013-11-18 08:30:00',1,NULL,'',0),(492,3,170,'2013-10-15 14:30:00','2013-10-15 15:00:00',1,NULL,'',0),(493,3,60,'2013-09-16 17:00:00','2013-09-16 17:30:00',1,NULL,'SAS app le 27/08/2013.',0),(494,3,314,'2013-09-11 08:00:00','2013-09-11 08:30:00',2,NULL,'',0),(496,2,307,'2013-09-03 08:15:00','2013-09-03 08:45:00',2,NULL,'',0),(498,3,43,'2013-10-14 08:00:00','2013-10-14 08:30:00',1,NULL,'',0),(499,3,47,'2013-10-28 09:00:00','2013-10-28 09:30:00',1,NULL,'a ete hospitalisé ',0),(501,2,261,'2013-10-24 16:00:00','2013-10-24 17:00:00',3,NULL,'',0),(502,3,261,'2013-09-19 15:00:00','2013-09-19 15:30:00',1,NULL,'',0),(503,2,318,'2013-08-28 10:30:00','2013-08-28 11:00:00',1,NULL,'',0),(504,4,316,'2013-08-28 10:00:00','2013-08-28 10:30:00',1,NULL,'',0),(505,2,318,'2013-10-10 14:45:00','2013-10-10 15:15:00',2,NULL,'',0),(507,3,316,'2013-09-26 14:45:00','2013-09-26 15:15:00',2,NULL,'Cs du 28/08/2013',0),(508,3,155,'2013-09-24 11:30:00','2013-09-24 12:00:00',1,NULL,'',0),(509,4,225,'2013-08-28 11:00:00','2013-08-28 11:30:00',1,NULL,'',0),(511,3,319,'2013-10-01 11:00:00','2013-10-01 11:30:00',2,NULL,'',0),(512,3,319,'2013-10-17 10:00:00','2013-10-17 10:30:00',1,NULL,'',0),(513,3,319,'2013-08-28 14:00:00','2013-08-28 14:30:00',1,NULL,'Demande TDM thrx et GDS aa',0),(515,3,320,'2013-11-06 10:30:00','2013-11-06 11:00:00',1,NULL,'',0),(516,3,320,'2013-08-28 16:00:00','2013-08-28 16:30:00',1,NULL,'Demande TDM thrx sans injection',0),(517,3,258,'2013-09-04 15:00:00','2013-09-04 15:30:00',1,NULL,'',0),(518,3,322,'2013-08-28 15:00:00','2013-08-28 15:30:00',1,NULL,'',0),(519,3,322,'2013-09-12 15:00:00','2013-09-12 15:30:00',2,NULL,'Prévoir un rdv de sommeil',0),(521,4,324,'2013-09-04 08:10:00','2013-09-04 08:40:00',1,NULL,'',0),(522,3,325,'2013-09-02 15:15:00','2013-09-02 15:45:00',2,NULL,'Cs du 29/08/2013',0),(523,4,326,'2013-08-29 09:00:00','2013-08-29 09:30:00',1,NULL,'',0),(525,3,156,'2014-01-13 08:00:00','2014-01-13 08:30:00',2,NULL,'',0),(526,3,326,'2013-10-16 08:00:00','2013-10-16 08:30:00',2,NULL,'',0),(528,4,329,'2013-08-30 14:00:00','2013-08-30 14:30:00',1,NULL,'',0),(529,3,231,'2013-10-16 14:00:00','2013-10-16 14:30:00',1,NULL,'hosp: à EPSM',0),(530,3,331,'2013-09-06 14:30:00','2013-09-06 15:00:00',2,NULL,'',0),(531,3,331,'2013-11-07 09:00:00','2013-11-07 09:30:00',1,NULL,'',0),(532,2,331,'2013-08-29 11:30:00','2013-08-29 12:00:00',1,NULL,'',0),(533,3,332,'2013-10-10 08:00:00','2013-10-10 08:30:00',2,NULL,'',0),(535,2,330,'2013-08-29 11:30:00','2013-08-29 12:00:00',2,NULL,'',0),(536,2,332,'2013-08-29 12:00:00','2013-08-29 12:30:00',1,NULL,'',0),(537,3,236,'2013-09-25 15:30:00','2013-09-25 16:00:00',2,NULL,'',0),(538,3,236,'2013-09-27 17:00:00','2013-09-27 18:00:00',3,NULL,'',0),(539,3,236,'2013-11-08 15:00:00','2013-11-08 15:30:00',1,NULL,'Cs du 08/11/2013 + RP+IgE totales  +RAST Pneu\r\ntroph',0),(540,3,114,'2013-08-08 16:00:00','2013-08-08 16:30:00',1,NULL,'',0),(541,3,114,'2013-10-17 15:00:00','2013-10-17 15:30:00',1,NULL,'',0),(542,2,333,'2013-08-29 14:00:00','2013-08-29 14:30:00',1,NULL,'',0),(543,3,333,'2013-10-30 08:30:00','2013-10-30 09:00:00',1,NULL,'',0),(544,4,334,'2013-08-29 15:00:00','2013-08-29 15:30:00',1,NULL,'',0),(545,3,334,'2013-09-26 11:30:00','2013-09-26 12:00:00',2,NULL,'',0),(546,3,334,'2013-10-29 09:00:00','2013-10-29 09:30:00',1,NULL,'',0),(547,3,216,'2013-09-04 08:00:00','2013-09-04 08:30:00',1,NULL,'',0),(548,3,231,'2013-08-22 09:40:00','2013-08-22 10:10:00',1,NULL,'',0),(549,4,335,'2013-08-30 14:20:00','2013-08-30 14:50:00',1,NULL,'',0),(550,3,329,'2013-09-30 14:45:00','2013-09-30 15:15:00',2,NULL,'A prévenu quelle ne pouvait venir a sa consultation du 10 dec',0),(551,3,329,'2013-09-16 15:00:00','2013-09-16 15:30:00',1,NULL,'Education therapeutique',0),(552,4,336,'2013-08-30 14:40:00','2013-08-30 15:10:00',1,NULL,'',0),(553,4,52,'2013-08-30 15:20:00','2013-08-30 15:50:00',1,NULL,'',0),(554,3,335,'2013-10-08 09:30:00','2013-10-08 10:00:00',2,NULL,'',0),(555,3,336,'2013-09-09 09:00:00','2013-09-09 09:30:00',2,NULL,'',0),(556,3,336,'2013-10-30 09:00:00','2013-10-30 09:30:00',1,NULL,'',0),(557,4,338,'2013-09-04 14:20:00','2013-09-04 14:50:00',1,NULL,'',0),(558,3,52,'2013-11-20 08:30:00','2013-11-20 09:00:00',1,NULL,'',0),(559,2,115,'2013-09-03 16:30:00','2013-09-03 17:00:00',1,NULL,'resultat PSG',0),(560,4,240,'2013-09-03 09:00:00','2013-09-03 09:30:00',1,NULL,'AVAIT rv le 4 9/2013  A 9 H',0),(561,3,125,'2013-10-30 11:30:00','2013-10-30 12:00:00',1,NULL,'',0),(564,1,340,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(567,1,344,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(568,1,345,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'RV 8/10 supprimé ; nous rappelera',0),(569,1,346,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(572,1,349,'2013-08-06 08:00:00','2013-08-06 08:30:00',2,NULL,'',0),(573,1,350,'2013-08-28 08:00:00','2013-08-28 08:30:00',1,NULL,'',0),(574,3,352,'2013-10-10 08:30:00','2013-10-10 09:00:00',2,NULL,'Cs le 02/09/2013',0),(575,3,352,'2013-10-31 08:00:00','2013-10-31 08:30:00',1,NULL,'Prévoir Poly Noct voir PSG',0),(578,3,356,'2013-10-21 08:00:00','2013-10-21 08:30:00',1,NULL,'ne souhaite plus  venir',0),(579,3,356,'2013-09-11 09:00:00','2013-09-11 09:30:00',2,NULL,'Pas venu Hospitalisée\r\n',0),(580,4,280,'2013-09-02 09:20:00','2013-09-02 09:50:00',1,NULL,'',0),(581,3,46,'2013-11-06 09:30:00','2013-11-06 10:00:00',1,NULL,'',0),(582,4,46,'2013-09-02 09:00:00','2013-09-02 09:30:00',1,NULL,'',0),(583,3,280,'2013-10-25 08:30:00','2013-10-25 09:00:00',1,NULL,'',0),(584,3,357,'2013-09-09 08:00:00','2013-09-09 08:30:00',2,NULL,'',0),(585,3,357,'2013-11-04 08:00:00','2013-11-04 08:30:00',1,NULL,'',0),(586,3,363,'2013-10-08 11:00:00','2013-10-08 11:30:00',2,NULL,'',0),(588,3,364,'2014-03-04 11:00:00','2014-03-04 11:30:00',2,NULL,'',0),(589,4,369,'2013-09-02 11:20:00','2013-09-02 11:50:00',1,NULL,'',0),(591,3,29,'2013-09-20 14:40:00','2013-09-20 15:10:00',1,NULL,'',0),(592,3,369,'2013-10-14 08:30:00','2013-10-14 09:00:00',2,NULL,'',0),(593,3,369,'2013-11-15 14:00:00','2013-11-15 14:30:00',1,NULL,'',0),(594,2,364,'2013-09-02 08:00:00','2013-09-02 00:30:00',1,NULL,'',0),(596,3,371,'2013-10-10 10:00:00','2013-10-10 10:30:00',2,NULL,'Cs le02/09/2013',0),(598,4,100,'2013-09-02 14:20:00','2013-09-02 14:50:00',1,NULL,'',0),(599,3,100,'2013-11-13 14:00:00','2013-11-13 14:30:00',1,NULL,'',0),(600,3,325,'2013-11-04 09:00:00','2013-11-04 09:30:00',1,NULL,'',0),(601,3,379,'2013-09-02 16:30:00','2013-09-02 17:00:00',1,NULL,'',0),(602,3,379,'2013-10-09 08:45:00','2013-10-09 09:15:00',2,NULL,'',0),(603,3,379,'2013-10-17 16:30:00','2013-10-17 17:00:00',1,NULL,'donner interpretation EFR',0),(604,3,34,'2013-09-02 17:00:00','2013-09-02 17:30:00',1,NULL,'',0),(605,3,34,'2013-11-12 08:00:00','2013-11-12 08:30:00',1,NULL,'',0),(606,3,249,'2013-11-12 09:00:00','2013-11-12 09:30:00',1,NULL,'',0),(607,3,240,'2013-08-23 15:00:00','2013-08-23 15:30:00',1,NULL,'',0),(608,3,169,'2013-08-13 11:00:00','2013-08-13 11:30:00',1,NULL,'',0),(609,3,195,'2013-08-16 15:00:00','2013-08-16 15:30:00',1,NULL,'',0),(610,2,35,'2013-09-05 17:30:00','2013-09-05 18:30:00',3,NULL,'',0),(611,2,35,'2013-09-03 12:00:00','2013-09-03 12:30:00',1,NULL,'',0),(613,2,386,'2013-09-03 12:30:00','2013-09-03 13:00:00',1,NULL,'',0),(616,4,390,'2013-09-03 15:00:00','2013-09-03 15:30:00',1,NULL,'',0),(619,4,392,'2013-09-03 16:00:00','2013-09-03 16:30:00',1,NULL,'',0),(620,4,287,'2013-09-03 16:00:00','2013-09-03 16:30:00',1,NULL,'',0),(621,3,225,'2013-09-10 11:30:00','2013-09-10 12:00:00',1,NULL,'',0),(622,3,392,'2013-09-24 08:00:00','2013-09-24 08:30:00',2,NULL,'',0),(623,3,392,'2013-11-19 09:00:00','2013-11-19 09:30:00',1,NULL,'',0),(625,3,85,'2013-11-13 09:00:00','2013-11-13 09:30:00',1,NULL,'',0),(626,3,142,'2013-10-08 09:45:00','2013-10-08 10:15:00',1,NULL,'',0),(627,3,287,'2013-12-10 14:00:00','2013-12-10 14:30:00',1,NULL,'',0),(628,3,179,'2014-01-27 14:00:00','2014-01-27 14:30:00',2,NULL,'',0),(632,2,76,'2013-11-26 16:00:00','2013-11-26 17:00:00',3,NULL,'',0),(634,3,137,'2013-10-22 08:00:00','2013-10-22 08:30:00',1,NULL,'',0),(635,4,396,'2013-09-04 09:30:00','2013-09-04 10:00:00',1,NULL,'',0),(636,4,397,'2013-09-04 09:30:00','2013-09-04 10:00:00',1,NULL,'',0),(637,3,197,'2013-11-19 08:30:00','2013-11-19 09:00:00',1,NULL,'',0),(638,3,396,'2013-10-17 09:00:00','2013-10-17 09:30:00',2,NULL,'',0),(639,3,396,'2013-11-14 09:00:00','2013-11-14 09:30:00',1,NULL,'',0),(640,2,397,'2013-09-12 14:15:00','2013-09-12 14:45:00',2,NULL,'',0),(641,2,397,'2013-09-30 16:30:00','2013-09-30 17:30:00',3,NULL,'',0),(642,3,216,'2013-09-09 16:30:00','2013-09-09 17:00:00',1,NULL,'',0),(643,3,25,'2013-12-11 11:30:00','2013-12-11 12:00:00',1,NULL,'',0),(644,2,338,'2013-09-11 14:15:00','2013-09-11 14:45:00',2,NULL,'',0),(646,3,338,'2013-11-20 14:00:00','2013-11-20 14:30:00',1,NULL,'',0),(648,3,263,'2013-11-18 09:00:00','2013-11-18 09:30:00',1,NULL,'',0),(649,3,2,'2013-10-30 14:30:00','2013-10-30 15:00:00',1,NULL,'',0),(650,4,399,'2013-10-10 09:30:00','2013-10-10 10:00:00',1,NULL,'',0),(651,3,400,'2013-10-16 14:30:00','2013-10-16 15:00:00',1,NULL,'',0),(653,3,403,'2013-09-04 17:00:00','2013-09-04 17:30:00',1,NULL,'',0),(654,3,207,'2013-09-10 10:30:00','2013-09-10 11:00:00',1,NULL,'',0),(658,2,49,'2013-09-05 09:30:00','2013-09-05 10:00:00',1,NULL,'',0),(659,2,45,'2013-09-05 08:20:00','2013-09-05 08:50:00',1,NULL,'',0),(660,3,405,'2013-09-05 10:15:00','2013-09-05 10:45:00',1,NULL,'',0),(661,4,406,'2013-09-05 10:30:00','2013-09-05 11:00:00',1,NULL,'',0),(663,3,405,'2013-09-11 15:00:00','2013-09-11 15:30:00',2,NULL,'',0),(664,3,406,'2013-10-10 10:45:00','2013-10-10 11:15:00',2,NULL,'RV de sommeil et de Cs à donner',0),(666,2,49,'2013-10-01 10:00:00','2013-10-01 10:30:00',1,NULL,'lecture sommeil',0),(669,2,113,'2013-09-05 12:00:00','2013-09-05 12:30:00',1,NULL,'',0),(670,3,411,'2013-09-05 16:10:00','2013-09-05 16:40:00',1,NULL,'',0),(671,3,412,'2013-09-05 15:40:00','2013-09-05 16:10:00',1,NULL,'',0),(672,4,413,'2013-09-05 14:40:00','2013-09-05 15:10:00',1,NULL,'',0),(673,4,414,'2013-09-05 14:20:00','2013-09-05 14:50:00',1,NULL,'',0),(674,4,415,'2013-09-05 15:00:00','2013-09-05 15:30:00',1,NULL,'',0),(675,3,414,'2013-10-11 09:00:00','2013-10-11 09:30:00',2,NULL,'',0),(676,3,414,'2013-11-05 08:00:00','2013-11-05 08:30:00',1,NULL,'',0),(677,3,413,'2013-11-05 10:00:00','2013-11-05 10:30:00',2,NULL,'',0),(680,1,281,'2013-07-31 08:00:00','2013-07-31 08:30:00',2,NULL,'',0),(681,1,101,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(682,1,117,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(683,1,3,'2013-07-24 08:00:00','2013-07-24 08:30:00',2,NULL,'',0),(684,1,74,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(685,1,193,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(686,1,120,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(687,1,176,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(688,1,37,'2013-07-24 08:00:00','2013-07-24 08:30:00',2,NULL,'',0),(689,1,150,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(690,1,68,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(691,1,242,'2013-08-23 08:00:00','2013-08-23 08:30:00',1,NULL,'',0),(692,1,90,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(693,1,278,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(694,1,278,'2013-08-23 08:00:00','2013-08-23 08:30:00',1,NULL,'',0),(697,1,253,'2013-07-26 08:00:00','2013-07-26 08:30:00',2,NULL,'',0),(698,1,282,'2013-07-31 08:00:00','2013-07-31 08:30:00',2,NULL,'',0),(699,1,147,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(700,1,260,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(701,1,241,'2013-08-23 08:00:00','2013-08-23 08:30:00',1,NULL,'',0),(702,1,100,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(703,1,71,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(704,1,36,'2013-08-07 08:00:00','2013-08-07 08:30:00',3,NULL,'',0),(705,1,36,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(706,1,36,'2013-09-03 08:00:00','2013-09-03 08:30:00',1,NULL,'',0),(707,1,154,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(708,1,156,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(709,1,43,'2013-07-25 08:00:00','2013-07-25 08:30:00',2,NULL,'',0),(710,1,43,'2013-08-15 08:00:00','2013-08-15 08:30:00',1,NULL,'',0),(711,1,211,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(712,1,104,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(713,1,180,'2013-08-02 08:00:00','2013-08-02 08:30:00',1,NULL,'',0),(714,1,180,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(715,1,217,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(716,1,70,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(717,1,187,'2013-08-15 08:00:00','2013-08-15 08:30:00',1,NULL,'',0),(718,1,215,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(719,1,28,'2013-07-26 08:00:00','2013-07-26 08:30:00',2,NULL,'',0),(720,1,166,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(721,1,133,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(722,1,73,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(723,1,230,'2013-08-22 08:00:00','2013-08-22 08:30:00',1,NULL,'',0),(724,1,221,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(725,1,197,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(726,1,69,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(727,1,140,'2013-08-02 08:00:00','2013-08-02 08:30:00',1,NULL,'',0),(728,1,160,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(729,1,162,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(730,1,67,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(731,1,105,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(732,1,152,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(734,1,126,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(735,1,143,'2013-09-03 08:00:00','2013-09-03 08:30:00',1,NULL,'',0),(736,1,49,'2013-07-25 08:00:00','2013-07-25 08:30:00',1,NULL,'',0),(737,1,91,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(738,1,27,'2013-07-26 08:00:00','2013-07-26 08:30:00',2,NULL,'',0),(739,1,262,'2013-07-29 08:00:00','2013-07-29 08:30:00',2,NULL,'',0),(740,1,287,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(741,1,97,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(742,1,128,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(743,1,167,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(744,1,314,'2013-08-27 08:00:00','2013-08-27 08:30:00',1,NULL,'',0),(745,1,93,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(746,1,26,'2013-07-26 08:00:00','2013-07-26 08:30:00',2,NULL,'',0),(747,1,44,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(748,1,196,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(749,1,249,'2013-07-25 08:00:00','2013-07-25 08:30:00',2,NULL,'',0),(750,1,249,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(751,1,219,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(752,1,30,'2013-07-25 08:00:00','2013-07-25 08:30:00',1,NULL,'',0),(753,1,30,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(754,1,30,'2013-08-20 08:00:00','2013-08-20 08:30:00',2,NULL,'',0),(755,1,199,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(756,1,137,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(757,1,123,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(758,1,220,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(759,1,122,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(760,1,39,'2013-07-24 08:00:00','2013-07-24 08:30:00',2,NULL,'',0),(761,1,39,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(762,1,98,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(763,1,189,'2013-08-15 08:00:00','2013-08-15 08:30:00',1,NULL,'',0),(764,1,188,'2013-08-15 08:00:00','2013-08-15 08:30:00',1,NULL,'',0),(765,1,185,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(766,1,194,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(767,1,155,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(768,1,371,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(769,1,121,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(770,1,59,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(771,1,175,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(772,1,186,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(773,1,158,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(774,1,239,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(775,1,174,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(776,1,103,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(777,1,148,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(778,1,214,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(779,1,214,'2013-08-27 08:00:00','2013-08-27 08:30:00',1,NULL,'',0),(780,1,141,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(781,1,4,'2013-07-22 08:00:00','2013-07-22 08:30:00',2,NULL,'',0),(782,1,4,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(783,1,4,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(784,1,129,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(785,1,170,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(786,1,212,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(787,1,134,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(788,1,2,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(789,1,261,'2013-07-25 08:00:00','2013-07-25 08:30:00',1,NULL,'',0),(790,1,261,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(791,1,261,'2013-08-28 08:00:00','2013-08-28 08:30:00',1,NULL,'',0),(793,1,200,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(794,1,81,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(795,1,206,'2013-08-02 08:00:00','2013-08-02 08:30:00',1,NULL,'',0),(799,1,151,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(800,1,6,'2013-07-22 08:00:00','2013-07-22 08:30:00',2,NULL,'',0),(801,1,177,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(802,1,145,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(803,1,228,'2013-08-22 08:00:00','2013-08-22 08:30:00',1,NULL,'',0),(804,1,310,'2013-08-27 08:00:00','2013-08-27 08:30:00',1,NULL,'',0),(805,1,66,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(806,1,82,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(807,1,78,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(808,1,225,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(809,1,171,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(810,1,210,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(811,1,222,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(812,1,173,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(813,1,216,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(814,1,127,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(815,1,86,'2013-07-30 08:00:00','2013-07-30 08:30:00',1,NULL,'',0),(816,1,47,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(817,1,161,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(818,1,271,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(819,1,142,'2013-07-26 08:00:00','2013-07-26 08:30:00',1,NULL,'',0),(820,1,203,'2013-08-19 08:00:00','2013-08-19 08:30:00',1,NULL,'',0),(821,1,149,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(822,1,280,'2013-07-31 08:00:00','2013-07-31 08:30:00',2,NULL,'',0),(823,1,102,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(824,1,157,'2013-08-06 08:00:00','2013-08-06 08:30:00',1,NULL,'',0),(825,1,357,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(826,1,352,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(827,1,208,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(828,1,95,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(829,1,165,'2013-07-29 08:00:00','2013-07-29 08:30:00',2,NULL,'',0),(830,1,165,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(831,1,259,'2013-07-29 08:00:00','2013-07-29 08:30:00',2,NULL,'',0),(832,1,201,'2013-08-19 08:00:00','2013-08-19 08:30:00',1,NULL,'',0),(833,1,363,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(834,1,218,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(835,1,85,'2013-08-12 08:00:00','2013-08-12 08:30:00',2,NULL,'',0),(836,1,229,'2013-08-22 08:00:00','2013-08-22 08:30:00',1,NULL,'',0),(837,1,25,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(838,1,113,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(839,1,248,'2013-07-26 08:00:00','2013-07-26 08:30:00',2,NULL,'',0),(840,1,96,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(841,1,204,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(842,1,79,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(843,1,79,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(844,1,178,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(845,1,125,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(846,1,223,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(847,1,224,'2013-08-21 08:00:00','2013-08-21 08:30:00',1,NULL,'',0),(850,1,192,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(851,1,60,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(852,1,60,'2013-08-27 08:00:00','2013-08-27 08:30:00',1,NULL,'',0),(853,1,258,'2013-08-05 08:00:00','2013-08-05 08:30:00',2,NULL,'',0),(854,1,29,'2013-08-13 08:00:00','2013-08-13 08:30:00',1,NULL,'',0),(855,1,29,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(856,1,181,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(857,1,182,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(858,1,198,'2013-08-02 08:00:00','2013-08-02 08:30:00',1,NULL,'',0),(859,1,198,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(860,1,99,'2013-08-07 08:00:00','2013-08-07 08:30:00',1,NULL,'',0),(861,1,99,'2013-08-08 08:00:00','2013-08-08 08:30:00',1,NULL,'',0),(862,1,99,'2013-08-19 08:00:00','2013-08-19 08:30:00',1,NULL,'',0),(863,1,65,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(864,1,213,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(865,1,163,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(866,1,243,'2013-08-23 08:00:00','2013-08-23 08:30:00',1,NULL,'',0),(867,1,243,'2013-08-28 08:00:00','2013-08-28 08:30:00',1,NULL,'',0),(868,1,84,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(869,1,184,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(870,1,298,'2013-08-26 08:00:00','2013-08-26 08:30:00',1,NULL,'',0),(871,1,63,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(872,1,63,'2013-08-16 08:00:00','2013-08-16 08:30:00',1,NULL,'',0),(873,1,254,'2013-07-30 08:00:00','2013-07-30 08:30:00',2,NULL,'',0),(874,1,254,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(875,1,75,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(876,1,75,'2013-08-14 08:00:00','2013-08-14 08:30:00',1,NULL,'',0),(877,1,64,'2013-07-31 08:00:00','2013-07-31 08:30:00',1,NULL,'',0),(878,1,293,'2013-08-26 08:00:00','2013-08-26 08:30:00',1,NULL,'',0),(879,1,159,'2013-08-12 08:00:00','2013-08-12 08:30:00',1,NULL,'',0),(880,1,5,'2013-07-22 08:00:00','2013-07-22 08:30:00',2,NULL,'',0),(881,1,5,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(882,1,400,'2013-09-04 08:00:00','2013-09-04 08:30:00',1,NULL,'',0),(883,1,202,'2013-08-19 08:00:00','2013-08-19 08:30:00',1,NULL,'',0),(884,1,119,'2013-08-09 08:00:00','2013-08-09 08:30:00',1,NULL,'',0),(885,1,138,'2013-08-05 08:00:00','2013-08-05 08:30:00',1,NULL,'',0),(886,1,207,'2013-08-20 08:00:00','2013-08-20 08:30:00',1,NULL,'',0),(887,1,76,'2013-08-01 08:00:00','2013-08-01 08:30:00',1,NULL,'',0),(920,3,411,'2013-10-07 15:00:00','2013-10-07 15:30:00',2,NULL,'',0),(921,2,416,'2013-09-06 17:00:00','2013-09-06 17:30:00',1,NULL,'',0),(922,2,224,'2014-01-27 16:00:00','2014-01-27 17:00:00',3,NULL,'',0),(923,3,417,'2013-10-15 14:00:00','2013-10-15 14:30:00',2,NULL,'',0),(924,3,417,'2013-11-20 09:00:00','2013-11-20 09:30:00',1,NULL,'',0),(925,3,417,'2013-09-06 14:00:00','2013-09-06 14:30:00',1,NULL,'',0),(926,3,3,'2014-02-03 14:00:00','2014-02-03 14:30:00',1,NULL,'',0),(927,3,242,'2013-10-08 10:00:00','2013-10-08 10:30:00',2,NULL,'',0),(928,3,242,'2013-10-25 15:00:00','2013-10-25 15:30:00',1,NULL,'Ne viendra plus au cabinet.',0),(929,2,416,'2013-10-01 14:45:00','2013-10-01 15:15:00',2,NULL,'',0),(930,2,416,'2013-10-17 16:00:00','2013-10-17 17:00:00',3,NULL,'',0),(932,4,423,'2013-09-06 17:40:00','2013-09-06 18:10:00',1,NULL,'',0),(936,3,423,'2013-10-25 18:00:00','2013-10-25 19:00:00',4,NULL,'PSG',0),(937,3,426,'2013-09-13 08:00:00','2013-09-13 08:30:00',1,NULL,'Faire Epworth, sommeil? suspicion SAS',0),(938,3,36,'2013-09-23 14:00:00','2013-09-23 14:30:00',1,NULL,'',0),(939,2,199,'2014-02-03 14:00:00','2014-02-03 15:00:00',3,NULL,'',0),(940,3,429,'2013-10-08 14:00:00','2013-10-08 14:30:00',2,NULL,'',0),(941,3,429,'2013-09-16 16:00:00','2013-09-16 16:30:00',1,NULL,'ISIS Réunion',0),(942,2,429,'2014-02-05 16:00:00','2014-02-05 17:00:00',3,NULL,'',0),(943,3,430,'2013-10-24 09:00:00','2013-10-24 09:30:00',2,NULL,'ISIS Reunion',0),(944,3,430,'2013-11-06 08:30:00','2013-11-06 09:00:00',1,NULL,'',0),(945,3,430,'2013-09-19 09:30:00','2013-09-19 10:00:00',1,NULL,'',1),(946,2,115,'2013-09-10 16:30:00','2013-09-10 17:00:00',1,NULL,'',0),(947,4,432,'2013-09-09 15:40:00','2013-09-09 16:10:00',1,NULL,'',0),(948,3,159,'2013-12-10 08:00:00','2013-12-10 08:30:00',1,NULL,'',0),(949,3,432,'2013-09-27 16:00:00','2013-09-27 16:30:00',2,NULL,'',0),(950,2,356,'2013-09-02 08:00:00','2013-09-02 08:30:00',1,NULL,'',0),(951,2,59,'2013-09-10 10:20:00','2013-09-10 10:50:00',1,NULL,'',0),(952,2,434,'2013-09-10 08:20:00','2013-09-10 08:50:00',1,NULL,'',0),(954,2,38,'2013-09-10 09:20:00','2013-09-10 09:50:00',1,NULL,'',0),(955,2,46,'2013-09-10 09:40:00','2013-09-10 10:10:00',1,NULL,'',0),(956,2,82,'2013-09-10 10:40:00','2013-09-10 11:10:00',1,NULL,'',0),(957,2,436,'2013-09-10 14:00:00','2013-09-10 14:30:00',1,NULL,'',0),(958,2,437,'2013-09-10 14:30:00','2013-09-10 15:00:00',1,NULL,'',0),(960,3,254,'2013-10-01 16:00:00','2013-10-01 16:30:00',1,NULL,'',0),(961,4,439,'2013-09-11 15:00:00','2013-09-11 15:30:00',1,NULL,'',0),(962,3,440,'2013-10-02 15:30:00','2013-10-02 16:00:00',2,NULL,'',0),(963,3,440,'2013-11-08 10:30:00','2013-11-08 11:00:00',1,NULL,'',0),(964,2,254,'2013-09-10 08:30:00','2013-09-10 09:00:00',1,NULL,'',0),(965,2,440,'2013-09-10 09:00:00','2013-09-10 09:30:00',1,NULL,'',0),(967,3,448,'2013-10-18 15:00:00','2013-10-18 15:30:00',2,NULL,'',0),(968,3,448,'2013-11-12 10:00:00','2013-11-12 10:30:00',1,NULL,'',0),(969,2,448,'2013-09-10 09:00:00','2013-09-10 09:30:00',1,NULL,'',0),(970,4,450,'2013-09-10 11:00:00','2013-09-10 11:30:00',1,NULL,'',0),(971,3,38,'2013-10-23 10:00:00','2013-10-23 10:30:00',1,NULL,'',0),(973,3,82,'2013-11-13 10:00:00','2013-11-13 10:30:00',1,NULL,'',0),(974,3,59,'2013-11-20 10:00:00','2013-11-20 10:30:00',1,NULL,'',0),(975,3,450,'2013-09-17 15:30:00','2013-09-17 16:00:00',1,NULL,'',0),(976,3,437,'2013-10-15 15:00:00','2013-10-15 15:30:00',2,NULL,'ISIS Med',0),(977,3,437,'2013-11-14 10:00:00','2013-11-14 10:30:00',1,NULL,'ISIS',0),(979,3,464,'2013-11-13 11:00:00','2013-11-13 11:30:00',1,NULL,'',0),(981,3,454,'2013-11-04 10:00:00','2013-11-04 10:30:00',1,NULL,'',0),(982,2,454,'2013-09-17 16:00:00','2013-09-17 16:30:00',1,NULL,'',0),(983,4,455,'2013-10-08 10:30:00','2013-10-08 11:00:00',1,NULL,'',0),(984,3,115,'2013-10-25 16:30:00','2013-10-25 17:00:00',1,NULL,'',0),(985,1,3,'2013-09-06 08:00:00','2013-09-06 08:30:00',1,NULL,'',0),(988,1,430,'2013-09-09 08:00:00','2013-09-09 08:30:00',1,NULL,'',0),(989,1,36,'2013-09-09 08:00:00','2013-09-09 08:30:00',1,NULL,'',0),(995,1,429,'2013-09-09 08:00:00','2013-09-09 08:30:00',1,NULL,'',0),(998,2,454,'2013-09-10 16:00:00','2013-09-10 16:30:00',1,NULL,'',0),(999,4,456,'2013-10-07 17:00:00','2013-10-07 17:30:00',1,NULL,'',0),(1000,4,457,'2013-09-13 08:00:00','2013-09-13 08:30:00',1,NULL,'',0),(1002,4,458,'2013-09-13 09:00:00','2013-09-13 09:30:00',1,NULL,'',0),(1003,4,459,'2013-09-13 09:00:00','2013-09-13 09:30:00',1,NULL,'',0),(1004,4,460,'2013-09-13 09:20:00','2013-09-13 09:50:00',1,NULL,'',0),(1005,3,462,'2013-09-12 11:00:00','2013-09-12 11:30:00',1,NULL,'',0),(1006,3,405,'2013-11-04 14:00:00','2013-11-04 14:30:00',1,NULL,'',0),(1009,4,466,'2013-09-12 08:00:00','2013-09-12 08:30:00',1,NULL,'',0),(1012,1,464,'2013-09-11 14:45:00','2013-09-11 15:00:00',1,NULL,'',0),(1013,1,193,'2013-09-11 08:00:00','2013-09-11 08:30:00',2,NULL,'',0),(1014,1,437,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1015,1,386,'2013-09-11 08:00:00','2013-09-11 08:30:00',2,NULL,'',0),(1018,1,187,'2013-09-11 08:00:00','2013-09-11 08:30:00',2,NULL,'',0),(1019,1,59,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1021,1,48,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1022,1,440,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1026,1,82,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1030,1,38,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1031,1,254,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1032,1,207,'2013-09-11 08:00:00','2013-09-11 08:30:00',1,NULL,'',0),(1060,3,470,'2013-10-14 08:00:00','2013-10-14 08:30:00',2,NULL,'',0),(1061,3,470,'2013-11-21 08:00:00','2013-11-21 08:30:00',1,NULL,'',0),(1062,4,91,'2013-09-12 11:00:00','2013-09-12 11:30:00',1,NULL,'',0),(1063,3,472,'2013-09-26 08:30:00','2013-09-26 09:00:00',2,NULL,'',0),(1064,3,472,'2013-09-17 09:00:00','2013-09-17 09:30:00',1,NULL,'',0),(1065,4,467,'2013-09-19 14:40:00','2013-09-19 15:10:00',1,NULL,'',0),(1066,2,462,'2013-09-13 14:45:00','2013-09-13 15:15:00',2,NULL,'',0),(1067,2,475,'2013-10-08 15:30:00','2013-10-08 16:00:00',1,NULL,'pb de sommeil - endormissement. Rappelera pour rv efr',0),(1068,4,91,'2013-09-19 08:30:00','2013-09-19 09:00:00',1,NULL,'',0),(1069,2,476,'2013-09-12 13:30:00','2013-09-12 14:00:00',1,NULL,'',0),(1070,2,322,'2014-02-10 16:00:00','2014-02-10 17:00:00',3,NULL,'',0),(1071,3,322,'2013-11-19 10:00:00','2013-11-19 10:30:00',1,NULL,'RESPIDOM veut un courrier pour arreter l\'O2.',0),(1072,3,426,'2013-10-07 16:00:00','2013-10-07 16:30:00',2,NULL,'',0),(1073,3,426,'2013-10-28 16:00:00','2013-10-28 17:00:00',3,NULL,'',0),(1075,3,37,'2013-09-16 15:30:00','2013-09-16 16:00:00',1,NULL,'',0),(1076,4,458,'2013-10-11 10:00:00','2013-10-11 10:30:00',2,NULL,'',0),(1078,4,458,'2013-12-11 10:45:00','2013-12-11 11:15:00',1,NULL,'',0),(1079,4,460,'2013-10-11 10:45:00','2013-10-11 11:15:00',2,NULL,'',0),(1081,4,479,'2013-09-13 11:00:00','2013-09-13 11:30:00',1,NULL,'',0),(1082,4,479,'2013-10-09 10:30:00','2013-10-09 11:00:00',2,NULL,'',0),(1083,3,480,'2013-09-19 10:30:00','2013-09-19 11:00:00',1,NULL,'Renouvellemt Entente preal\r\nISIS',0),(1085,4,471,'2013-09-13 15:00:00','2013-09-13 15:30:00',1,NULL,'',0),(1086,3,140,'2013-10-08 14:30:00','2013-10-08 15:00:00',1,NULL,'',0),(1088,2,481,'2013-09-13 15:15:00','2013-09-13 15:45:00',2,NULL,'',0),(1089,3,471,'2013-10-11 11:30:00','2013-10-11 12:00:00',2,NULL,'',0),(1090,3,471,'2013-11-07 10:30:00','2013-11-07 11:00:00',1,NULL,'',0),(1091,4,482,'2013-09-16 15:00:00','2013-09-16 15:30:00',1,NULL,'',0),(1092,3,462,'2013-10-14 14:00:00','2013-10-14 14:30:00',1,NULL,'',0),(1093,3,484,'2013-09-17 16:45:00','2013-09-17 17:15:00',1,NULL,'',0),(1094,3,485,'2013-09-17 13:30:00','2013-09-17 14:00:00',1,NULL,'',0),(1095,3,486,'2013-10-22 15:30:00','2013-10-22 16:00:00',1,NULL,'ISIS Medical',0),(1096,3,253,'2013-11-26 14:00:00','2013-11-26 14:30:00',2,NULL,'',0),(1098,2,253,'2013-09-16 14:30:00','2013-09-16 15:00:00',1,NULL,'',0),(1099,3,37,'2013-11-04 14:00:00','2013-11-04 14:30:00',2,NULL,'',0),(1100,3,487,'2013-09-26 09:00:00','2013-09-26 09:30:00',1,NULL,'',0),(1102,3,482,'2013-10-30 15:00:00','2013-10-30 15:30:00',2,NULL,'EFR ou Cs\r\nprendre rdv pour CS',0),(1103,3,216,'2013-09-16 15:30:00','2013-09-16 16:00:00',1,NULL,'',0),(1106,2,489,'2013-09-16 16:45:00','2013-09-16 17:15:00',1,NULL,'',0),(1108,3,60,'2013-11-04 17:00:00','2013-11-04 17:30:00',1,NULL,'',0),(1109,2,487,'2013-09-16 15:00:00','2013-09-16 15:30:00',1,NULL,'',0),(1110,3,472,'2013-11-05 10:30:00','2013-11-05 11:00:00',1,NULL,'',0),(1111,3,492,'2013-10-29 09:00:00','2013-10-29 09:30:00',2,NULL,'',0),(1112,3,492,'2013-12-12 09:00:00','2013-12-12 09:30:00',1,NULL,'Isis Medical',0),(1113,4,493,'2013-10-07 09:30:00','2013-10-07 10:00:00',1,NULL,'',0),(1114,3,494,'2013-10-29 10:00:00','2013-10-29 10:30:00',2,NULL,'ISIS Médical. ne veut pas venir, il a  son médecin traitant;',0),(1116,4,495,'2013-09-17 16:30:00','2013-09-17 17:00:00',1,NULL,'',0),(1118,3,485,'2013-10-14 10:00:00','2013-10-14 10:30:00',2,NULL,'',0),(1119,3,485,'2013-10-29 11:00:00','2013-10-29 11:30:00',1,NULL,'',0),(1121,3,497,'2013-09-25 11:30:00','2013-09-25 12:00:00',2,NULL,'',0),(1122,4,138,'2013-09-24 11:00:00','2013-09-24 11:30:00',1,NULL,'',0),(1123,4,498,'2013-09-17 14:20:00','2013-09-17 14:50:00',1,NULL,'',0),(1124,3,498,'2013-10-24 10:00:00','2013-10-24 10:30:00',2,NULL,'',0),(1125,3,498,'2013-12-12 10:00:00','2013-12-12 10:30:00',1,NULL,'ISIS Medical',0),(1127,3,262,'2013-09-17 15:30:00','2013-09-17 16:00:00',1,NULL,'',0),(1129,3,262,'2014-02-17 16:00:00','2014-02-17 17:00:00',3,NULL,'Il faut donner un RV d Efr merci',0),(1130,3,484,'2013-10-04 14:00:00','2013-10-04 14:30:00',2,NULL,'',0),(1132,3,35,'2013-09-26 10:00:00','2013-09-26 10:30:00',1,NULL,'résultat sommeil',0),(1133,3,31,'2013-09-23 14:30:00','2013-09-23 15:00:00',1,NULL,'',0),(1134,3,500,'2013-09-23 15:00:00','2013-09-23 15:30:00',1,NULL,'',0),(1135,3,91,'2013-10-16 08:00:00','2013-10-16 08:30:00',1,NULL,'',0),(1137,3,501,'2013-10-31 09:00:00','2013-10-31 09:30:00',2,NULL,'',0),(1138,3,501,'2013-11-21 09:00:00','2013-11-21 09:30:00',1,NULL,'',0),(1139,3,501,'2013-10-08 08:30:00','2013-10-08 09:00:00',1,NULL,'',0),(1143,3,503,'2013-10-23 09:00:00','2013-10-23 09:30:00',2,NULL,'',0),(1144,3,503,'2013-11-28 16:00:00','2013-11-28 17:00:00',3,NULL,'PSG\r\nrepasser ses actes d\'EFR du 23/10/2013\r\na déjà eu une PV en 2012 (?)\r\nDépression nerveuse récente\r\nbcp de temps passé au lit (cf agenda de sommeil)\r\n\r\nrdv annulé. rappelera en janvier.',0),(1145,3,505,'2013-09-25 15:00:00','2013-09-25 15:30:00',1,NULL,'',0),(1148,3,261,'2013-12-10 14:30:00','2013-12-10 15:00:00',2,NULL,'',0),(1149,3,261,'2013-11-14 15:30:00','2013-11-14 16:00:00',1,NULL,'',0),(1151,3,29,'2013-11-19 14:00:00','2013-11-19 14:30:00',1,NULL,'',0),(1154,1,512,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,NULL,'',0),(1155,1,512,'0000-00-00 00:00:00','0000-00-00 00:00:00',2,NULL,'',0),(1156,1,512,'0000-00-00 00:00:00','0000-00-00 00:00:00',2,NULL,'',0),(1157,4,61,'2013-09-24 08:00:00','2013-09-24 08:30:00',1,NULL,'',0),(1159,3,31,'2013-10-16 10:00:00','2013-10-16 10:30:00',2,NULL,'',0),(1160,4,386,'2013-09-23 14:00:00','2013-09-23 14:30:00',1,NULL,'',0),(1161,3,31,'2013-11-07 15:00:00','2013-11-07 15:30:00',1,NULL,'',0),(1163,4,271,'2013-09-24 08:40:00','2013-09-24 09:10:00',1,NULL,'',0),(1164,3,519,'2013-11-05 16:00:00','2013-11-05 16:30:00',2,NULL,'',0),(1165,3,520,'2013-11-05 16:30:00','2013-11-05 17:00:00',2,NULL,'',0),(1166,3,519,'2013-10-23 16:00:00','2013-10-23 16:30:00',1,NULL,'vaccination Pneumo 23',0),(1167,3,520,'2013-10-23 16:30:00','2013-10-23 17:00:00',1,NULL,'',0),(1168,4,65,'2013-09-24 08:20:00','2013-09-24 08:50:00',1,NULL,'',0),(1170,4,27,'2013-09-24 09:00:00','2013-09-24 09:30:00',1,NULL,'',0),(1171,3,65,'2013-11-26 09:00:00','2013-11-26 09:30:00',2,NULL,'Prévoir TDM thoracique sans injection.',0),(1173,4,280,'2013-09-24 09:30:00','2013-09-24 10:00:00',1,NULL,'',0),(1174,3,27,'2013-11-13 09:00:00','2013-11-13 09:30:00',2,NULL,'',0),(1175,3,271,'2013-11-27 09:00:00','2013-11-27 09:30:00',2,NULL,'',0),(1177,4,79,'2013-09-24 10:00:00','2013-09-24 10:30:00',1,NULL,'',0),(1178,4,521,'2013-09-24 11:00:00','2013-09-24 11:30:00',1,NULL,'',0),(1179,3,79,'2013-12-10 09:00:00','2013-12-10 09:30:00',2,NULL,'',0),(1181,4,255,'2013-09-25 08:00:00','2013-09-25 08:30:00',1,NULL,'',0),(1182,4,282,'2013-09-25 08:40:00','2013-09-25 09:10:00',1,NULL,'',0),(1183,4,69,'2013-09-25 09:00:00','2013-09-25 09:30:00',1,NULL,'',0),(1184,4,128,'2013-09-25 09:20:00','2013-09-25 09:50:00',1,NULL,'',0),(1187,4,71,'2013-09-25 10:30:00','2013-09-25 11:00:00',1,NULL,'',0),(1189,3,204,'2013-10-14 11:00:00','2013-10-14 11:30:00',1,NULL,'',0),(1191,3,521,'2013-12-03 11:00:00','2013-12-03 11:30:00',1,NULL,'',0),(1193,3,155,'2013-12-10 14:30:00','2013-12-10 15:00:00',1,NULL,'',0),(1194,3,155,'2014-01-16 11:00:00','2014-01-16 11:30:00',2,NULL,'',0),(1196,4,93,'2013-09-25 14:15:00','2013-09-25 14:45:00',1,NULL,'',0),(1197,4,221,'2013-10-09 14:00:00','2013-10-09 14:30:00',2,NULL,'',0),(1198,3,523,'2013-10-17 11:00:00','2013-10-17 11:30:00',2,NULL,'',0),(1199,3,227,'2014-01-03 14:00:00','2014-01-03 14:30:00',1,NULL,'',0),(1201,3,522,'2013-12-18 08:00:00','2013-12-18 08:30:00',1,NULL,'',0),(1202,3,255,'2013-12-18 08:30:00','2013-12-18 09:00:00',1,NULL,'',0),(1203,3,69,'2013-10-08 17:00:00','2013-10-08 18:00:00',3,NULL,'',0),(1204,3,69,'2013-10-21 14:00:00','2013-10-21 14:30:00',1,NULL,'',0),(1205,3,121,'2013-10-10 08:30:00','2013-10-10 09:00:00',1,NULL,'',0),(1207,3,282,'2013-11-06 16:00:00','2013-11-06 16:30:00',1,NULL,'',0),(1208,4,70,'2013-09-26 11:00:00','2013-09-26 11:30:00',1,NULL,'',0),(1209,4,96,'2013-11-07 09:00:00','2013-11-07 09:30:00',2,NULL,'',0),(1212,3,71,'2014-01-06 09:30:00','2014-01-06 10:00:00',1,NULL,'',0),(1214,3,72,'2014-01-08 10:00:00','2014-01-08 10:30:00',1,NULL,'',0),(1215,3,524,'2013-09-26 15:00:00','2013-09-26 15:30:00',1,NULL,'Alpha C 200 Phcie Cheung Leung\r\nDécenchement Inspi -3 cm d\'H2O',0),(1216,4,526,'2013-10-10 08:00:00','2013-10-10 08:30:00',1,NULL,'',0),(1218,3,505,'2013-11-06 11:30:00','2013-11-06 12:00:00',1,NULL,'',0),(1219,3,505,'2013-10-09 11:00:00','2013-10-09 11:30:00',2,NULL,'',0),(1222,3,487,'2013-11-14 08:30:00','2013-11-14 09:00:00',2,NULL,'',0),(1223,3,165,'2013-09-27 14:30:00','2013-09-27 15:00:00',1,NULL,'',0),(1224,4,527,'2013-09-25 15:30:00','2013-09-25 16:00:00',2,NULL,'',0),(1225,4,500,'2013-10-09 10:00:00','2013-10-09 10:30:00',2,NULL,'',0),(1226,4,68,'2013-10-04 14:00:00','2013-10-04 14:30:00',1,NULL,'',0),(1227,3,35,'2013-10-25 09:30:00','2013-10-25 10:00:00',2,NULL,'',0),(1228,4,220,'2014-02-06 17:00:00','2014-02-06 18:00:00',3,NULL,'',0),(1231,4,133,'2013-10-01 14:30:00','2013-10-01 15:00:00',1,NULL,'',0),(1233,3,524,'2013-10-23 10:00:00','2013-10-23 10:30:00',2,NULL,'',0),(1234,3,524,'2013-11-04 15:00:00','2013-11-04 15:30:00',1,NULL,'',0),(1235,4,524,'2014-02-18 16:00:00','2014-02-18 17:00:00',3,NULL,'',0),(1237,2,527,'2013-09-26 14:30:00','2013-09-26 15:00:00',1,NULL,'',0),(1238,4,530,'2013-10-07 11:00:00','2013-10-07 11:30:00',1,NULL,'',0),(1239,3,190,'2013-10-15 11:30:00','2013-10-15 12:00:00',1,NULL,'Après explrt épancht pleural',0),(1240,4,316,'2013-10-21 15:00:00','2013-10-21 15:30:00',1,NULL,'',0),(1241,3,165,'2013-10-11 11:30:00','2013-10-11 12:00:00',1,NULL,'',0),(1242,4,528,'2013-10-02 15:00:00','2013-10-02 15:30:00',1,NULL,'',0),(1243,3,180,'2013-12-16 14:00:00','2013-12-16 14:30:00',1,NULL,'',0),(1248,4,536,'2013-09-30 16:00:00','2013-09-30 16:30:00',1,NULL,'',0),(1249,4,537,'2013-09-30 16:00:00','2013-09-30 16:30:00',1,NULL,'',0),(1251,3,120,'2013-11-07 14:00:00','2013-11-07 14:30:00',1,NULL,'',0),(1252,4,162,'2013-10-02 16:00:00','2013-10-02 16:30:00',2,NULL,'',0),(1253,3,236,'2013-10-14 15:30:00','2013-10-14 16:00:00',1,NULL,'',0),(1254,4,539,'2013-10-04 14:30:00','2013-10-04 15:00:00',2,NULL,'',0),(1255,4,533,'2013-10-04 15:30:00','2013-10-04 16:00:00',1,NULL,'',0),(1257,3,537,'2013-11-15 15:00:00','2013-11-15 15:30:00',2,NULL,'',0),(1259,3,536,'2013-11-15 15:30:00','2013-11-15 16:00:00',2,NULL,'',0),(1261,4,489,'2013-09-30 17:00:00','2013-09-30 17:30:00',1,NULL,'',0),(1262,3,489,'2013-10-21 15:00:00','2013-10-21 15:30:00',2,NULL,'',0),(1263,4,1,'2013-10-01 08:30:00','2013-10-01 09:00:00',1,NULL,'',0),(1264,4,59,'2013-10-01 14:00:00','2013-10-01 14:30:00',1,NULL,'',0),(1265,4,541,'2013-10-01 09:40:00','2013-10-01 10:10:00',1,NULL,'',0),(1266,4,153,'2013-10-01 09:20:00','2013-10-01 09:50:00',1,NULL,'',0),(1267,3,1,'2013-11-26 10:00:00','2013-11-26 10:30:00',2,NULL,'',0),(1270,3,103,'2014-01-03 15:00:00','2014-01-03 15:30:00',1,NULL,'',0),(1271,2,248,'2014-02-20 16:00:00','2014-02-20 17:00:00',3,NULL,'',0),(1273,2,248,'2014-02-27 08:00:00','2014-02-27 08:30:00',1,NULL,'',0),(1274,2,397,'2013-10-04 14:30:00','2013-10-04 15:00:00',1,NULL,'résultat PV',0),(1277,4,340,'2013-10-01 10:00:00','2013-10-01 10:30:00',1,NULL,'',0),(1278,2,49,'2013-10-29 16:00:00','2013-10-29 17:00:00',3,NULL,'PSG  ne peux venir car malade rappelera\r\nprendre rdv pour EFR en janvier / février (après son retour de vacances)',0),(1280,3,153,'2013-12-10 10:00:00','2013-12-10 10:30:00',1,NULL,'',0),(1281,3,541,'2013-10-29 11:00:00','2013-10-29 11:30:00',2,NULL,'Dcd',0),(1283,4,542,'2013-10-04 16:00:00','2013-10-04 16:30:00',1,NULL,'',0),(1284,2,340,'2013-12-18 09:00:00','2013-12-18 09:30:00',1,NULL,'',0),(1287,3,133,'2014-01-07 14:00:00','2014-01-07 14:30:00',2,NULL,'',0),(1289,3,133,'2013-10-22 15:00:00','2013-10-22 15:30:00',2,NULL,'pas venue',0),(1290,4,206,'2013-10-02 15:30:00','2013-10-02 16:00:00',1,NULL,'',0),(1291,2,416,'2013-10-24 14:45:00','2013-10-24 15:15:00',1,NULL,'résultat PV',0),(1294,4,63,'2013-10-03 15:30:00','2013-10-03 16:00:00',1,NULL,'',0),(1295,3,158,'2014-01-06 11:00:00','2014-01-06 11:30:00',1,NULL,'OUBLI DE SA RADIO AU CABINET DU Dr TANGUY.',0),(1297,4,543,'2013-10-01 16:30:00','2013-10-01 17:00:00',1,NULL,'',0),(1300,2,254,'2013-11-21 14:00:00','2013-11-21 14:30:00',1,NULL,'',0),(1301,3,543,'2013-10-04 16:30:00','2013-10-04 17:00:00',1,NULL,'',0),(1302,2,544,'2013-10-03 16:30:00','2013-10-03 17:00:00',1,NULL,'',0),(1303,3,547,'2013-10-03 17:00:00','2013-10-03 17:30:00',1,NULL,'Dr De Grandpré\r\npour PSG',0),(1304,3,68,'2013-11-06 09:00:00','2013-11-06 09:30:00',2,NULL,'',0),(1306,4,548,'2013-10-03 16:00:00','2013-10-03 16:30:00',2,NULL,'',0),(1307,2,528,'2013-10-03 15:30:00','2013-10-03 16:00:00',2,NULL,'',0),(1308,3,528,'2013-10-10 16:30:00','2013-10-10 17:30:00',3,NULL,'',0),(1311,4,206,'2013-11-20 15:00:00','2013-11-20 15:30:00',3,NULL,'malade - ne peut venir',0),(1312,3,386,'2013-10-28 15:00:00','2013-10-28 15:30:00',1,NULL,'',0),(1313,4,206,'2013-12-02 15:00:00','2013-12-02 15:30:00',2,NULL,'',0),(1314,4,550,'2013-10-10 15:00:00','2013-10-10 15:30:00',1,NULL,'',0),(1317,4,551,'2013-10-10 15:30:00','2013-10-10 16:00:00',1,NULL,'',0),(1318,3,78,'2013-10-22 10:45:00','2013-10-22 11:15:00',1,NULL,'résultats PV',0),(1319,4,552,'2013-10-03 15:00:00','2013-10-03 15:30:00',1,NULL,'',0),(1320,4,83,'2013-10-07 09:00:00','2013-10-07 09:30:00',1,NULL,'',0),(1321,4,149,'2013-10-07 09:40:00','2013-10-07 10:10:00',1,NULL,'',0),(1322,4,281,'2013-10-07 10:30:00','2013-10-07 11:00:00',1,NULL,'',0),(1323,4,270,'2013-10-07 11:30:00','2013-10-07 12:00:00',1,NULL,'',0),(1324,3,63,'2013-12-04 15:30:00','2013-12-04 16:00:00',2,NULL,'',0),(1325,3,63,'2014-01-08 16:00:00','2014-01-08 16:30:00',1,NULL,'',0),(1326,3,528,'2013-10-21 15:30:00','2013-10-21 16:00:00',1,NULL,'',0),(1327,2,548,'2013-10-15 16:30:00','2013-10-15 17:30:00',3,NULL,'',0),(1328,2,548,'2013-10-22 09:30:00','2013-10-22 10:00:00',1,NULL,'résultat PV .GSM inexact\r\n',0),(1329,2,390,'2013-10-08 17:00:00','2013-10-08 17:30:00',1,NULL,'rdv demandé par tel',0),(1332,2,547,'2013-10-14 11:00:00','2013-10-14 11:30:00',2,NULL,'',0),(1333,2,547,'2013-10-16 17:00:00','2013-10-16 18:00:00',4,NULL,'PSG',0),(1334,2,547,'2013-10-23 11:00:00','2013-10-23 11:30:00',1,NULL,'résultat PSG',0),(1335,2,552,'2013-10-04 15:30:00','2013-10-04 16:00:00',2,NULL,'',0),(1336,3,30,'2013-10-08 16:00:00','2013-10-08 16:30:00',1,NULL,'',0),(1337,2,397,'2013-10-14 16:45:00','2013-10-14 17:45:00',4,NULL,'PSG',0),(1338,2,397,'2013-10-25 15:45:00','2013-10-25 16:15:00',1,NULL,'résultat PSG',0),(1340,4,54,'2013-10-07 11:00:00','2013-10-07 11:30:00',1,NULL,'',0),(1341,3,484,'2013-10-18 14:30:00','2013-10-18 15:00:00',1,NULL,'Voir RP',0),(1342,4,55,'2013-10-08 08:00:00','2013-10-08 08:30:00',1,NULL,'',0),(1343,4,81,'2013-10-08 08:30:00','2013-10-08 09:00:00',1,NULL,'',0),(1345,3,533,'2013-11-08 15:30:00','2013-11-08 16:00:00',1,NULL,'Voir TDM thoracique',0),(1346,4,57,'2013-10-08 10:00:00','2013-10-08 10:30:00',1,NULL,'',0),(1347,2,539,'2013-10-07 16:45:00','2013-10-07 17:45:00',3,NULL,'PV',0),(1348,2,539,'2013-10-09 08:00:00','2013-10-09 08:30:00',1,NULL,'résultat PV',0),(1349,4,66,'2013-10-11 11:45:00','2013-10-11 12:15:00',1,NULL,'',0),(1350,2,552,'2013-10-14 16:00:00','2013-10-14 16:30:00',1,NULL,'',0),(1351,4,129,'2013-10-08 09:00:00','2013-10-08 09:30:00',1,NULL,'',0),(1352,2,542,'2013-10-08 16:30:00','2013-10-08 17:00:00',2,NULL,'',0),(1353,2,543,'2013-12-04 09:00:00','2013-12-04 09:30:00',1,NULL,'',0),(1356,4,544,'2013-10-08 15:45:00','2013-10-08 16:15:00',2,NULL,'',0),(1357,3,149,'2013-10-11 09:30:00','2013-10-11 10:00:00',1,NULL,'',0),(1358,3,84,'2013-12-04 09:30:00','2013-12-04 10:00:00',1,NULL,'',0),(1360,3,530,'2013-10-15 11:00:00','2013-10-15 11:30:00',2,NULL,'',0),(1361,3,281,'2013-11-21 14:00:00','2013-11-21 14:30:00',2,NULL,'',0),(1362,3,281,'2013-12-09 14:00:00','2013-12-09 14:30:00',1,NULL,'',0),(1363,2,54,'2014-01-21 16:30:00','2014-01-21 17:30:00',4,NULL,'PSG',0),(1364,3,54,'2013-12-02 15:30:00','2013-12-02 16:00:00',2,NULL,'',0),(1367,3,243,'2013-10-09 16:00:00','2013-10-09 16:30:00',1,NULL,'Masse de 29mm du LSD.',0),(1368,3,126,'2013-12-10 10:00:00','2013-12-10 10:30:00',2,NULL,'',0),(1369,3,126,'2013-12-26 08:30:00','2013-12-26 09:00:00',1,NULL,'',0),(1370,4,370,'2013-10-24 15:30:00','2013-10-24 16:00:00',1,NULL,'',0),(1371,4,76,'2013-10-08 10:30:00','2013-10-08 11:00:00',1,NULL,'',0),(1372,4,64,'2013-10-08 11:00:00','2013-10-08 11:30:00',1,NULL,'',0),(1374,3,293,'2013-12-23 14:00:00','2013-12-23 14:30:00',1,NULL,'',0),(1377,3,141,'2013-12-30 14:00:00','2013-12-30 14:30:00',1,NULL,'',0),(1378,2,357,'2013-10-28 16:00:00','2013-10-28 17:00:00',3,NULL,'',0),(1379,3,55,'2013-11-27 10:00:00','2013-11-27 10:30:00',2,NULL,'',0),(1380,3,55,'2013-12-12 08:00:00','2013-12-12 08:30:00',1,NULL,'',0),(1381,3,81,'2014-01-10 15:00:00','2014-01-10 15:30:00',2,NULL,'',0),(1382,3,81,'2014-01-16 09:30:00','2014-01-16 10:00:00',1,NULL,'',0),(1385,3,129,'2013-11-04 11:30:00','2013-11-04 12:00:00',1,NULL,'',0),(1387,3,57,'2014-01-07 09:30:00','2014-01-07 10:00:00',1,NULL,'Prevoir Vaccin antigrippal et Pneumo23',0),(1388,4,403,'2013-11-08 08:30:00','2013-11-08 09:00:00',1,NULL,'',0),(1389,3,76,'2013-12-11 09:00:00','2013-12-11 09:30:00',2,NULL,'',0),(1391,4,555,'2013-10-09 08:30:00','2013-10-09 09:00:00',1,NULL,'',0),(1393,2,557,'2013-10-25 15:00:00','2013-10-25 15:30:00',1,NULL,'prévoir PV',0),(1394,3,363,'2014-01-07 10:00:00','2014-01-07 10:30:00',1,NULL,'',0),(1395,3,335,'2014-01-07 11:00:00','2014-01-07 11:30:00',1,NULL,'part en métropole. Rappellera pour prochain rdv à son retour, en octobre',0),(1396,4,42,'2013-10-10 14:00:00','2013-10-10 14:30:00',1,NULL,'',0),(1397,3,140,'2013-11-07 14:00:00','2013-11-07 14:30:00',2,NULL,'TLCO pour décision arret de la Corticottt',0),(1398,2,429,'2013-10-24 11:00:00','2013-10-24 11:30:00',1,NULL,'donner résultat EFR',0),(1401,4,86,'2013-10-28 16:30:00','2013-10-28 17:00:00',1,NULL,'',0),(1402,3,97,'2014-02-11 10:00:00','2014-02-11 10:30:00',1,NULL,'',0),(1403,4,618,'2013-10-25 10:00:00','2013-10-25 10:30:00',1,NULL,'',0),(1404,3,390,'2013-11-04 15:00:00','2013-11-04 15:30:00',2,NULL,'',0),(1406,4,544,'2013-10-21 14:30:00','2013-10-21 15:00:00',1,NULL,'',0),(1407,3,542,'2013-11-15 16:30:00','2013-11-15 17:00:00',1,NULL,'',0),(1408,3,261,'2013-10-25 10:30:00','2013-10-25 11:00:00',1,NULL,'',0),(1410,3,212,'2013-12-18 10:00:00','2013-12-18 10:30:00',1,NULL,'',0),(1411,3,212,'2014-02-11 09:00:00','2014-02-11 09:30:00',2,NULL,'',0),(1413,4,123,'2013-10-09 13:30:00','2013-10-09 14:00:00',1,NULL,'',0),(1414,4,100,'2013-10-09 14:00:00','2013-10-09 14:30:00',1,NULL,'',0),(1415,3,479,'2013-10-17 11:00:00','2013-10-17 11:30:00',1,NULL,'',0),(1416,3,559,'2013-10-09 13:15:00','2013-10-09 13:45:00',1,NULL,'',0),(1418,3,123,'2014-01-08 14:00:00','2014-01-08 14:30:00',1,NULL,'',0),(1423,3,90,'2013-10-22 11:00:00','2013-10-22 11:30:00',1,NULL,'',0),(1424,3,90,'2013-12-04 09:00:00','2013-12-04 09:30:00',2,NULL,'',0),(1425,4,154,'2013-10-10 08:30:00','2013-10-10 09:00:00',1,NULL,'',0),(1426,3,121,'2013-12-17 08:00:00','2013-12-17 08:30:00',1,NULL,'',0),(1429,2,562,'2013-10-21 11:30:00','2013-10-21 12:00:00',1,NULL,'a téléphoné pour demander une PV',0),(1430,2,562,'2013-11-04 16:00:00','2013-11-04 17:00:00',3,NULL,'PV',0),(1431,4,320,'2013-10-16 11:30:00','2013-10-16 12:00:00',2,NULL,'',0),(1432,3,399,'2013-11-05 08:30:00','2013-11-05 09:00:00',2,NULL,'',0),(1434,4,96,'2013-10-10 10:00:00','2013-10-10 10:30:00',1,NULL,'',0),(1435,3,399,'2013-12-04 08:00:00','2013-12-04 08:30:00',1,NULL,'',0),(1436,2,371,'2013-11-19 14:30:00','2013-11-19 15:00:00',1,NULL,'',0),(1437,2,371,'2013-10-22 14:45:00','2013-10-22 15:15:00',1,NULL,'',0),(1440,2,406,'2013-11-21 16:00:00','2013-11-21 17:00:00',3,NULL,'',0),(1441,2,406,'2013-10-24 14:00:00','2013-10-24 14:30:00',1,NULL,'',0),(1442,3,45,'2013-12-04 10:00:00','2013-12-04 10:30:00',2,NULL,'',0),(1443,3,45,'2014-01-08 09:00:00','2014-01-08 09:30:00',1,NULL,'',0),(1444,3,563,'2013-10-15 17:00:00','2013-10-15 17:30:00',1,NULL,'',0),(1445,3,550,'2013-11-07 08:30:00','2013-11-07 09:00:00',2,NULL,'Supprime ce efr et sommeil car hospitalisé le 5 nov.',0),(1446,3,550,'2013-12-05 16:00:00','2013-12-05 17:00:00',3,NULL,'supprime rv sommeil rappelera',0),(1448,4,196,'2013-10-08 15:00:00','2013-10-08 15:30:00',1,NULL,'',0),(1449,3,551,'2013-10-15 09:30:00','2013-10-15 10:00:00',1,NULL,'',0),(1451,3,128,'2014-01-07 16:00:00','2014-01-07 16:30:00',1,NULL,'',0),(1452,3,169,'2013-12-11 10:00:00','2013-12-11 10:30:00',2,NULL,'',0),(1453,3,169,'2014-01-08 08:00:00','2014-01-08 08:30:00',1,NULL,'',0),(1454,3,149,'2014-01-07 09:00:00','2014-01-07 09:30:00',2,NULL,'',0),(1455,3,149,'2014-02-11 09:00:00','2014-02-11 09:30:00',1,NULL,'',0),(1456,3,122,'2013-10-16 11:00:00','2013-10-16 11:30:00',1,NULL,'',0),(1457,3,201,'2014-01-20 14:00:00','2014-01-20 14:30:00',1,NULL,'',0),(1459,3,66,'2013-12-10 10:00:00','2013-12-10 10:30:00',1,NULL,'',0),(1460,3,369,'2014-01-17 14:00:00','2014-01-17 14:30:00',2,NULL,'',0),(1461,3,117,'2013-12-12 08:00:00','2013-12-12 08:30:00',2,NULL,'',0),(1462,3,204,'2014-01-28 08:00:00','2014-01-28 08:30:00',2,NULL,'',0),(1463,3,204,'2014-02-12 08:00:00','2014-02-12 08:30:00',1,NULL,'',0),(1464,2,456,'2013-10-14 11:30:00','2013-10-14 12:00:00',2,NULL,'',0),(1465,4,555,'2013-10-14 11:30:00','2013-10-14 12:00:00',1,NULL,'',0),(1466,4,127,'2013-11-04 16:30:00','2013-11-04 17:30:00',1,NULL,'n\'a pas pu venir car elle n\'a pas pu récupérer son scanner.',0),(1467,2,456,'2013-10-24 16:30:00','2013-10-24 17:30:00',3,NULL,'PV',0),(1469,3,555,'2013-11-15 14:00:00','2013-11-15 14:30:00',2,NULL,'',0),(1471,4,567,'2013-10-22 11:30:00','2013-10-22 12:00:00',1,NULL,'',0),(1472,3,205,'2013-12-10 15:00:00','2013-12-10 15:30:00',2,NULL,'',0),(1473,3,552,'2013-10-18 15:30:00','2013-10-18 16:00:00',1,NULL,'',0),(1474,3,40,'2014-01-06 08:00:00','2014-01-06 08:30:00',1,NULL,'',0),(1475,3,41,'2014-01-06 08:30:00','2014-01-06 09:00:00',1,NULL,'',0),(1476,4,462,'2013-10-17 14:30:00','2013-10-17 15:00:00',1,NULL,'',0),(1477,4,570,'2013-10-22 09:00:00','2013-10-22 09:30:00',1,NULL,'',0),(1478,3,235,'2013-10-18 13:30:00','2013-10-18 14:00:00',1,NULL,'',0),(1480,3,551,'2013-11-07 14:45:00','2013-11-07 15:15:00',2,NULL,'Ne peut venir : son compagnon est hospitalisé.',0),(1482,3,138,'2014-01-13 10:00:00','2014-01-13 10:30:00',2,NULL,'',0),(1484,4,572,'2013-10-17 11:30:00','2013-10-17 12:00:00',1,NULL,'',0),(1485,3,190,'2013-11-06 10:00:00','2013-11-06 10:30:00',1,NULL,'',0),(1486,4,165,'2013-11-14 11:00:00','2013-11-14 11:30:00',1,NULL,'',0),(1487,3,530,'2013-10-23 15:30:00','2013-10-23 16:00:00',1,NULL,'',0),(1488,3,228,'2014-01-21 09:00:00','2014-01-21 09:30:00',1,NULL,'PGN le 12/12/2013',0),(1489,4,573,'2013-10-23 11:30:00','2013-10-23 12:00:00',1,NULL,'',0),(1490,4,573,'2013-10-29 16:30:00','2013-10-29 17:30:00',3,NULL,'',0),(1491,2,575,'2013-10-29 14:45:00','2013-10-29 15:15:00',1,NULL,'',0),(1492,2,575,'2013-11-20 09:00:00','2013-11-20 09:30:00',2,NULL,'n\'a pu venir en cs donc vient pour EFR',0),(1495,3,120,'2013-10-22 14:00:00','2013-10-22 14:30:00',1,NULL,'pour regler l\'app de PPC',0),(1497,4,76,'2013-11-19 11:00:00','2013-11-19 11:30:00',1,NULL,'',0),(1498,2,563,'2013-11-13 08:00:00','2013-11-13 08:30:00',2,NULL,'',0),(1499,4,134,'2013-11-13 15:00:00','2013-11-13 15:30:00',1,NULL,'',0),(1500,4,134,'2013-12-10 11:00:00','2013-12-10 11:30:00',2,NULL,'',0),(1501,2,326,'2013-10-24 08:30:00','2013-10-24 09:00:00',1,NULL,'donner résultat EFR',0),(1503,3,91,'2013-12-04 08:00:00','2013-12-04 08:30:00',2,NULL,'Prevoir PN',0),(1504,2,439,'2013-10-16 09:00:00','2013-10-16 09:30:00',2,NULL,'',0),(1505,3,243,'2013-10-29 09:30:00','2013-10-29 10:00:00',1,NULL,'',0),(1506,2,173,'2013-11-07 16:30:00','2013-11-07 17:30:00',3,NULL,'',0),(1507,2,576,'2013-11-07 16:30:00','2013-11-07 17:00:00',1,NULL,'suspicion SAS. Ne peut venir recontactera.',0),(1508,3,147,'2013-12-12 09:00:00','2013-12-12 09:30:00',2,NULL,'',0),(1509,3,122,'2013-12-23 10:00:00','2013-12-23 10:30:00',1,NULL,'',0),(1510,3,577,'2013-10-24 11:30:00','2013-10-24 12:00:00',1,NULL,'Toux persistante depuis 1 mois',0),(1511,3,224,'2014-02-12 14:00:00','2014-02-12 14:30:00',1,NULL,'résultat PV',0),(1512,3,223,'2014-02-12 14:45:00','2014-02-12 15:15:00',1,NULL,'',0),(1513,4,166,'2013-10-31 08:30:00','2013-10-31 09:00:00',1,NULL,'cs pour analyser  EFR',0),(1514,4,98,'2013-10-29 15:00:00','2013-10-29 15:30:00',1,NULL,'',0),(1515,2,423,'2013-10-17 10:30:00','2013-10-17 11:00:00',2,NULL,'',0),(1516,2,145,'2013-11-14 16:30:00','2013-11-14 17:30:00',4,NULL,'PSG',0),(1517,4,282,'2013-10-17 09:00:00','2013-10-17 09:30:00',1,NULL,'',0),(1519,4,579,'2013-10-25 11:30:00','2013-10-25 12:00:00',1,NULL,'',0),(1520,4,580,'2013-10-21 09:30:00','2013-10-21 10:00:00',1,NULL,'',0),(1521,4,581,'2013-10-21 09:30:00','2013-10-21 10:00:00',1,NULL,'NE VEUT PLUS VENIR',0),(1522,3,559,'2013-11-18 09:30:00','2013-11-18 10:00:00',1,NULL,'',0),(1523,3,319,'2013-12-23 11:00:00','2013-12-23 11:30:00',1,NULL,'',0),(1524,2,480,'2013-10-23 11:00:00','2013-10-23 11:30:00',2,NULL,' RV(ISIS)patient prévenue',0),(1525,3,479,'2013-10-30 10:30:00','2013-10-30 11:00:00',1,NULL,'',0),(1526,4,29,'2013-10-17 16:00:00','2013-10-17 16:30:00',1,NULL,'',0),(1527,2,572,'2013-10-23 11:30:00','2013-10-23 12:00:00',2,NULL,'',0),(1528,2,572,'2013-10-22 16:00:00','2013-10-22 17:00:00',3,NULL,'PV',0),(1529,3,523,'2013-11-13 09:00:00','2013-11-13 09:30:00',1,NULL,'',0),(1530,3,195,'2013-11-21 11:00:00','2013-11-21 11:30:00',1,NULL,'',0),(1531,3,379,'2013-12-04 11:00:00','2013-12-04 11:30:00',1,NULL,'',0),(1532,3,332,'2013-10-24 09:00:00','2013-10-24 09:30:00',1,NULL,'MESSAGE DE DR. MASCAREL : \r\nen regardant sur notre pacs je vois une radio faite hier pour un de tes patients , le radiolgue ne signale rien , mais moi je suis intrigué par son mediastin sup , je pense qu un scanner sans inj serait intéressante',0),(1533,3,75,'2013-10-21 08:30:00','2013-10-21 09:00:00',1,NULL,'A appareillé chez ISIS\r\nne veut pas porter l appareil',0),(1535,4,584,'2013-10-18 16:00:00','2013-10-18 16:30:00',1,NULL,'',0),(1536,3,235,'2013-11-08 11:00:00','2013-11-08 11:30:00',1,NULL,'',0),(1538,2,585,'2013-10-18 15:00:00','2013-10-18 15:30:00',1,NULL,'',0),(1539,3,484,'2013-11-08 14:30:00','2013-11-08 15:00:00',1,NULL,'',0),(1540,3,552,'2013-11-21 14:30:00','2013-11-21 15:00:00',2,NULL,'TDM thrx du 19/11/2013 à analyser',0),(1541,1,NULL,'2013-10-18 17:30:00','2013-10-18 18:30:00',5,NULL,'Kemda Tamadoum',0),(1542,4,459,'2013-11-14 14:00:00','2013-11-14 14:30:00',1,NULL,'',0),(1543,3,584,'2013-11-05 15:00:00','2013-11-05 15:30:00',2,NULL,'',0),(1544,3,150,'2013-10-28 14:00:00','2013-10-28 14:30:00',1,NULL,'',0),(1545,3,142,'2013-11-18 17:30:00','2013-11-18 18:00:00',2,NULL,'',0),(1548,3,218,'2014-01-07 09:30:00','2014-01-07 10:00:00',2,NULL,'',0),(1550,3,222,'2013-11-13 14:30:00','2013-11-13 15:00:00',1,NULL,'PPC ISIS',0),(1552,4,243,'2013-10-23 17:00:00','2013-10-23 17:30:00',1,NULL,'',0),(1553,4,216,'2013-10-25 17:00:00','2013-10-25 17:30:00',1,NULL,'',0),(1554,4,591,'2013-10-22 11:15:00','2013-10-22 11:45:00',1,NULL,'',0),(1555,3,592,'2013-10-22 10:00:00','2013-10-22 10:30:00',1,NULL,'',0),(1556,4,69,'2013-11-21 11:30:00','2013-11-21 12:00:00',1,NULL,'',0),(1559,3,528,'2014-02-11 09:30:00','2014-02-11 10:00:00',1,NULL,'',0),(1560,3,489,'2013-11-19 10:30:00','2013-11-19 11:00:00',1,NULL,'Prevoir Spiriva Respimat',0),(1561,3,316,'2014-01-08 16:00:00','2014-01-08 17:00:00',3,NULL,'PV. Patient sous O2; en civière.\r\nDesire un masque pour aerosol, merci',0),(1562,3,99,'2013-10-29 10:30:00','2013-10-29 11:00:00',1,NULL,'',0),(1563,2,126,'2013-10-22 15:15:00','2013-10-22 15:45:00',1,NULL,'',0),(1565,3,164,'2013-12-13 17:00:00','2013-12-13 17:30:00',2,NULL,'',0),(1566,3,237,'2013-12-05 14:30:00','2013-12-05 15:00:00',2,NULL,'',0),(1567,4,595,'2013-10-24 16:00:00','2013-10-24 16:30:00',1,NULL,'Adressé par Dr. Laurent de Granpré, Psg',0),(1568,4,548,'2014-01-07 09:00:00','2014-01-07 09:30:00',2,NULL,'',0),(1571,3,570,'2013-11-06 10:00:00','2013-11-06 10:30:00',2,NULL,'',0),(1572,3,592,'2013-10-25 10:30:00','2013-10-25 11:00:00',2,NULL,'',0),(1573,3,596,'2013-10-25 11:00:00','2013-10-25 11:30:00',2,NULL,'',0),(1574,3,78,'2013-11-21 15:00:00','2013-11-21 15:30:00',1,NULL,'',0),(1576,4,599,'2013-10-22 12:00:00','2013-10-22 12:30:00',1,NULL,'',0),(1577,3,591,'2013-12-04 09:30:00','2013-12-04 10:00:00',2,NULL,'',0),(1579,3,599,'2013-10-25 14:00:00','2013-10-25 14:30:00',2,NULL,'probnp\r\n2743',0),(1580,3,599,'2013-11-06 16:00:00','2013-11-06 17:00:00',3,NULL,'PV',0),(1581,2,596,'2013-10-22 10:30:00','2013-10-22 11:00:00',1,NULL,'',0),(1582,4,162,'2013-10-22 14:30:00','2013-10-22 15:00:00',1,NULL,'',0),(1583,3,217,'2013-12-11 14:00:00','2013-12-11 14:30:00',1,NULL,'',0),(1585,4,601,'2013-10-30 14:00:00','2013-10-30 14:30:00',1,NULL,'',0),(1587,3,400,'2013-11-13 08:30:00','2013-11-13 09:00:00',1,NULL,'',0),(1588,3,529,'2013-11-14 09:30:00','2013-11-14 10:00:00',1,NULL,'',0),(1589,3,603,'2013-11-07 09:30:00','2013-11-07 10:00:00',1,NULL,'',0),(1590,3,604,'2013-11-04 08:30:00','2013-11-04 09:00:00',1,NULL,'',0),(1591,4,136,'2013-11-12 09:30:00','2013-11-12 10:00:00',1,NULL,'',0),(1592,4,158,'2013-11-19 14:00:00','2013-11-19 14:30:00',2,NULL,'',0),(1593,3,214,'2014-01-16 14:30:00','2014-01-16 15:30:00',3,NULL,'PN sans VNI car déja app',0),(1594,3,214,'2013-12-23 14:30:00','2013-12-23 15:00:00',1,NULL,'',0),(1596,3,238,'2013-11-12 08:30:00','2013-11-12 09:00:00',1,NULL,'',0),(1597,3,161,'2013-10-28 15:30:00','2013-10-28 16:00:00',1,NULL,'',0),(1600,3,194,'2014-02-04 09:30:00','2014-02-04 10:00:00',2,NULL,'',0),(1601,2,480,'2013-11-12 16:00:00','2013-11-12 17:00:00',3,NULL,'PV',0),(1602,4,609,'2013-10-30 09:00:00','2013-10-30 09:30:00',1,NULL,'',0),(1603,3,38,'2013-11-21 15:30:00','2013-11-21 16:00:00',2,NULL,'',0),(1604,3,547,'2013-11-20 15:00:00','2013-11-20 15:30:00',1,NULL,'',0),(1606,3,572,'2013-10-28 11:30:00','2013-10-28 12:00:00',1,NULL,'',0),(1607,2,610,'2013-10-25 09:00:00','2013-10-25 09:30:00',1,NULL,'adressé par tel par le Dr. ?',0),(1608,3,229,'2013-12-12 08:30:00','2013-12-12 09:00:00',1,NULL,'',0),(1609,3,143,'2013-12-09 14:30:00','2013-12-09 15:00:00',1,NULL,'',0),(1611,2,309,'2014-01-09 16:00:00','2014-01-09 17:00:00',3,NULL,'PV.\r\nEst déjà apareillé par Respidom (CPAP? BPAP?)\r\nControler l\'IAH résiduel',0),(1613,3,326,'2014-01-14 08:30:00','2014-01-14 09:00:00',1,NULL,'',0),(1614,3,332,'2013-11-13 10:30:00','2013-11-13 11:00:00',1,NULL,'',0),(1615,4,612,'2013-10-24 14:30:00','2013-10-24 15:00:00',1,NULL,'Frère de Claude 0262230235',0),(1616,4,613,'2013-10-30 09:30:00','2013-10-30 10:00:00',1,NULL,'',0),(1617,4,615,'2013-11-12 15:00:00','2013-11-12 15:30:00',1,NULL,'',0),(1619,4,115,'2013-10-31 17:00:00','2013-10-31 17:30:00',1,NULL,'',0),(1620,2,416,'2014-01-14 16:00:00','2014-01-14 17:00:00',4,NULL,'PSG',0),(1621,3,370,'2013-11-15 16:00:00','2013-11-15 16:30:00',2,NULL,'nous rapellera pour un cs\r\nsouffre d\'une hernie discale\r\nva se faire operer de la catharaque',0),(1622,3,595,'2013-10-25 14:30:00','2013-10-25 15:00:00',2,NULL,'',0),(1623,3,595,'2013-10-31 16:30:00','2013-10-31 17:30:00',4,NULL,'psg',0),(1627,4,456,'2013-10-30 10:30:00','2013-10-30 11:00:00',1,NULL,'',0),(1629,4,162,'2013-10-25 11:00:00','2013-10-25 11:30:00',1,NULL,'',0),(1630,3,610,'2013-10-29 15:30:00','2013-10-29 16:00:00',1,NULL,'',0),(1632,2,493,'2013-10-25 10:30:00','2013-10-25 11:00:00',2,NULL,'',0),(1633,2,162,'2014-01-15 16:00:00','2014-01-15 17:00:00',3,NULL,'PV',0),(1634,3,35,'2013-12-05 09:00:00','2013-12-05 09:30:00',1,NULL,'',0),(1635,3,493,'2013-11-08 11:30:00','2013-11-08 12:00:00',1,NULL,'',0),(1636,4,460,'2013-12-05 10:00:00','2013-12-05 10:30:00',1,NULL,'',0),(1637,4,238,'2013-10-25 14:30:00','2013-10-25 15:00:00',1,NULL,'',0),(1638,3,592,'2013-11-06 15:30:00','2013-11-06 16:30:00',3,NULL,'PV',0),(1639,3,592,'2013-11-14 14:30:00','2013-11-14 15:00:00',1,NULL,'résultat PV',0),(1640,3,238,'2013-10-30 11:00:00','2013-10-30 12:00:00',5,NULL,'Mise en place de la PPC/VNI',0),(1641,3,298,'2014-01-08 15:00:00','2014-01-08 15:30:00',1,NULL,'',0),(1643,2,557,'2013-10-31 11:00:00','2013-10-31 11:30:00',2,NULL,'',0),(1644,2,557,'2014-01-16 16:00:00','2014-01-16 17:00:00',3,NULL,'',0),(1645,3,397,'2013-11-20 09:30:00','2013-11-20 10:00:00',1,NULL,'',0),(1646,3,216,'2013-12-03 09:00:00','2013-12-03 09:30:00',2,NULL,'',0),(1647,4,621,'2013-12-16 15:00:00','2013-12-16 15:30:00',1,NULL,'',0),(1648,2,423,'2013-11-18 18:00:00','2013-11-18 18:30:00',1,NULL,'résultat PSG',0),(1649,3,455,'2013-11-06 08:00:00','2013-11-06 08:30:00',1,NULL,'',0),(1650,3,278,'2013-11-05 11:00:00','2013-11-05 11:30:00',2,NULL,'',0),(1651,3,278,'2013-12-13 13:45:00','2013-12-13 14:15:00',1,NULL,'',0),(1653,4,624,'2013-11-15 14:30:00','2013-11-15 15:00:00',1,NULL,'',0),(1654,3,137,'2013-11-20 10:30:00','2013-11-20 11:00:00',1,NULL,'',0),(1655,3,572,'2013-11-18 11:00:00','2013-11-18 11:30:00',1,NULL,'',0),(1658,3,86,'2013-12-09 16:30:00','2013-12-09 17:00:00',1,NULL,'',0),(1659,4,625,'2013-11-15 15:00:00','2013-11-15 15:30:00',1,NULL,'',0),(1661,3,175,'2013-11-18 08:30:00','2013-11-18 09:00:00',1,NULL,'',0),(1662,3,334,'2014-01-14 14:00:00','2014-01-14 14:30:00',1,NULL,'',0),(1663,3,177,'2014-01-06 10:30:00','2014-01-06 11:00:00',1,NULL,'',0),(1664,3,243,'2013-11-13 16:00:00','2013-11-13 16:30:00',1,NULL,'Recupérer anatpath',0),(1665,2,492,'2014-01-30 16:00:00','2014-01-30 17:00:00',3,NULL,'PV',0),(1666,2,627,'2013-10-31 11:30:00','2013-10-31 12:00:00',1,NULL,'SOS Oxygène',0),(1667,2,628,'2013-10-31 10:30:00','2013-10-31 11:00:00',1,NULL,'',0),(1668,2,99,'2014-01-20 16:00:00','2014-01-20 17:00:00',3,NULL,'PV',0),(1669,3,99,'2014-01-14 10:00:00','2014-01-14 10:30:00',1,NULL,'',0),(1670,3,198,'2014-01-08 11:00:00','2014-01-08 11:30:00',1,NULL,'',0),(1671,2,485,'2014-01-21 16:00:00','2014-01-21 17:00:00',3,NULL,'PV',0),(1673,2,632,'2013-10-31 16:30:00','2013-10-31 17:00:00',1,NULL,'souhaiterai une PSG',0),(1675,3,98,'2014-01-27 10:00:00','2014-01-27 10:30:00',1,NULL,'',0),(1676,3,610,'2013-11-04 16:00:00','2013-11-04 16:30:00',1,NULL,'Doit porter l\'ancien TDM',0),(1677,3,230,'2014-01-10 14:30:00','2014-01-10 15:00:00',1,NULL,'',0),(1680,3,336,'2014-01-07 10:00:00','2014-01-07 10:30:00',2,NULL,'',0),(1681,3,609,'2013-11-07 11:00:00','2013-11-07 11:30:00',2,NULL,'Un employé dela pharmacie m\'a dit qu\'elle refuse d\'utiliser le concentrateur ainsi que la bouteille 02',0),(1682,3,613,'2013-11-04 11:30:00','2013-11-04 12:00:00',2,NULL,'',0),(1683,3,613,'2013-11-05 17:00:00','2013-11-05 18:00:00',3,NULL,'',0),(1684,3,192,'2014-01-14 08:30:00','2014-01-14 09:00:00',2,NULL,'',0),(1685,3,479,'2014-01-15 10:30:00','2014-01-15 11:00:00',1,NULL,'',0),(1686,4,79,'2013-11-08 10:00:00','2013-11-08 10:30:00',1,NULL,'',0),(1687,2,612,'2013-10-30 14:30:00','2013-10-30 15:00:00',2,NULL,'',0),(1688,4,105,'2013-11-21 10:30:00','2013-11-21 11:00:00',1,NULL,'',0),(1690,2,601,'2013-11-05 17:30:00','2013-11-05 18:30:00',3,NULL,'PV',0),(1691,3,601,'2013-11-04 08:30:00','2013-11-04 09:00:00',2,NULL,'',0),(1692,3,2,'2013-11-13 15:30:00','2013-11-13 16:00:00',1,NULL,'',0),(1696,3,166,'2014-01-27 09:30:00','2014-01-27 10:00:00',1,NULL,'',0),(1697,2,352,'2014-01-22 16:00:00','2014-01-22 17:00:00',3,NULL,'PV',0),(1698,4,508,'2013-10-31 09:30:00','2013-10-31 10:00:00',2,NULL,'',0),(1699,4,509,'2013-10-31 10:00:00','2013-10-31 10:30:00',2,NULL,'',0),(1700,4,160,'2013-12-05 16:00:00','2013-12-05 16:30:00',1,NULL,'',0),(1701,4,634,'2013-11-08 10:15:00','2013-11-08 10:45:00',1,NULL,'',0),(1702,2,508,'2013-09-18 08:00:00','2013-09-18 08:30:00',1,NULL,'',0),(1704,4,634,'2013-11-14 09:00:00','2013-11-14 09:30:00',2,NULL,'',0),(1705,2,196,'2013-10-31 10:00:00','2013-10-31 10:30:00',1,NULL,'',0),(1706,4,637,'2013-11-06 14:30:00','2013-11-06 15:00:00',1,NULL,'',0),(1707,2,508,'2013-11-08 16:00:00','2013-11-08 17:00:00',3,NULL,'PV',0),(1708,2,509,'2013-11-08 16:00:00','2013-11-08 17:00:00',3,NULL,'PV',0),(1709,3,628,'2013-11-06 14:00:00','2013-11-06 14:30:00',2,NULL,'',0),(1710,2,628,'2013-11-12 16:30:00','2013-11-12 17:30:00',4,NULL,'PSG',0),(1711,2,627,'2013-11-14 15:30:00','2013-11-14 16:30:00',3,NULL,'PV',0),(1712,2,627,'2013-11-15 14:30:00','2013-11-15 15:00:00',2,NULL,'',0),(1714,4,639,'2013-11-19 15:00:00','2013-11-19 15:30:00',2,NULL,'Examen d\'aptitude de plongee professionnel',0),(1716,2,632,'2013-11-18 17:30:00','2013-11-18 18:30:00',3,NULL,'PV',0),(1717,3,640,'2013-11-07 15:30:00','2013-11-07 16:00:00',1,NULL,'',0),(1718,4,220,'2013-11-08 16:00:00','2013-11-08 16:30:00',1,NULL,'',0),(1720,2,595,'2013-11-14 15:00:00','2013-11-14 15:30:00',1,NULL,'résultat PSG',0),(1721,4,640,'2013-10-31 16:00:00','2013-10-31 16:30:00',1,NULL,'',0),(1729,3,654,'2013-11-06 09:00:00','2013-11-06 09:30:00',1,NULL,'',0),(1731,3,426,'2014-01-07 14:00:00','2014-01-07 14:30:00',1,NULL,'',0),(1732,2,357,'2013-11-19 17:00:00','2013-11-19 18:00:00',4,NULL,'PSG',0),(1733,4,30,'2013-11-05 08:30:00','2013-11-05 09:00:00',1,NULL,'',0),(1734,4,567,'2013-11-12 11:30:00','2013-11-12 12:00:00',2,NULL,'PSG à programmer\r\nNE PEUT PAS VEN\r\nIR RAPPELLERA',0),(1735,4,467,'2014-01-07 11:00:00','2014-01-07 11:30:00',2,NULL,'',0),(1737,4,656,'2013-11-07 16:00:00','2013-11-07 16:30:00',1,NULL,'',0),(1739,3,579,'2013-11-12 15:30:00','2013-11-12 16:00:00',1,NULL,'',0),(1740,3,658,'2013-11-08 13:30:00','2013-11-08 14:00:00',1,NULL,'PN du 19/11/2012',0),(1741,3,129,'2013-11-15 16:15:00','2013-11-15 17:15:00',3,NULL,'',0),(1742,4,139,'2014-01-09 14:00:00','2014-01-09 14:30:00',1,NULL,'',0),(1743,2,661,'2013-11-12 14:00:00','2013-11-12 14:30:00',2,NULL,'Faire une ordonnance (séparéé) IGE datée du 12 nov merci : pharmacie 026253 19 29.',0),(1744,2,661,'2013-11-04 11:30:00','2013-11-04 12:00:00',1,NULL,'',0),(1745,3,161,'2013-11-18 13:30:00','2013-11-18 14:30:00',1,NULL,'',0),(1747,3,37,'2014-01-07 14:30:00','2014-01-07 15:00:00',1,NULL,'',0),(1748,4,495,'2013-11-13 15:30:00','2013-11-13 16:00:00',2,NULL,'',0),(1749,3,610,'2013-11-13 09:30:00','2013-11-13 10:00:00',1,NULL,'',0),(1750,3,390,'2014-02-03 15:00:00','2014-02-03 15:30:00',1,NULL,'',0),(1751,2,562,'2013-11-13 16:30:00','2013-11-13 17:00:00',1,NULL,'résultat PV',0),(1752,3,60,'2013-11-14 13:30:00','2013-11-14 14:00:00',1,NULL,'',0),(1753,3,182,'2013-12-04 08:30:00','2013-12-04 09:00:00',1,NULL,'',0),(1754,3,414,'2014-01-09 09:00:00','2014-01-09 09:30:00',1,NULL,'',0),(1755,3,663,'2013-11-07 11:30:00','2013-11-07 12:00:00',1,NULL,'',0),(1756,4,664,'2013-11-05 10:00:00','2013-11-05 10:30:00',1,NULL,'',0),(1757,3,30,'2014-01-09 10:00:00','2014-01-09 10:30:00',1,NULL,'',0),(1758,3,664,'2013-11-12 09:00:00','2013-11-12 09:30:00',2,NULL,'',0),(1760,2,26,'2013-12-02 16:30:00','2013-12-02 17:30:00',3,NULL,'Prevoir echelle de PICHOT dépression',0),(1761,3,472,'2013-11-19 09:30:00','2013-11-19 10:00:00',1,NULL,'Voir résultats PET Scan',0),(1762,3,188,'2014-02-04 11:00:00','2014-02-04 11:30:00',1,NULL,'',0),(1763,4,665,'2013-11-20 16:00:00','2013-11-20 16:30:00',1,NULL,'Intervention le 8/10/2013 au chu. Controle 1 mois après avec dr TANGUY',0),(1764,3,189,'2014-02-04 11:30:00','2014-02-04 12:00:00',1,NULL,'',0),(1765,4,199,'2013-11-08 09:30:00','2013-11-08 10:00:00',1,NULL,'',0),(1766,4,197,'2013-11-12 11:30:00','2013-11-12 12:00:00',1,NULL,'FAIRE DEMACHES POR RESPIDOM',0),(1767,2,584,'2013-11-12 14:30:00','2013-11-12 15:00:00',1,NULL,'résultat EFR',0),(1768,2,519,'2013-11-19 16:00:00','2013-11-19 16:30:00',1,NULL,'résultat EFR',0),(1769,2,520,'2013-11-19 16:30:00','2013-11-19 17:00:00',1,NULL,'résultat EFR',0),(1770,4,176,'2013-11-06 07:45:00','2013-11-06 08:15:00',1,NULL,'',0),(1772,2,601,'2013-11-14 16:00:00','2013-11-14 16:30:00',1,NULL,'résultat pv',0),(1773,3,176,'2014-01-09 08:30:00','2014-01-09 09:00:00',2,NULL,'',0),(1774,2,613,'2013-11-06 09:00:00','2013-11-06 09:30:00',1,NULL,'',0),(1775,2,613,'2013-11-07 14:30:00','2013-11-07 15:00:00',1,NULL,'résultat PV',0),(1776,3,430,'2013-12-17 08:30:00','2013-12-17 09:00:00',1,NULL,'',0),(1777,2,654,'2013-11-12 10:00:00','2013-11-12 10:30:00',2,NULL,'',0),(1779,3,190,'2014-01-07 10:30:00','2014-01-07 11:00:00',1,NULL,'',0),(1780,3,570,'2014-01-14 09:30:00','2014-01-14 10:00:00',1,NULL,'',0),(1781,3,320,'2014-02-05 10:30:00','2014-02-05 11:00:00',1,NULL,'',0),(1782,3,505,'2013-12-18 11:30:00','2013-12-18 12:00:00',1,NULL,'Père gros fumeur',0),(1783,2,637,'2013-11-08 15:00:00','2013-11-08 15:30:00',2,NULL,'',0),(1785,4,618,'2013-11-07 10:00:00','2013-11-07 10:30:00',2,NULL,'',0),(1786,4,455,'2013-11-18 10:30:00','2013-11-18 11:00:00',1,NULL,'',0),(1787,4,667,'2013-11-14 11:30:00','2013-11-14 12:00:00',1,NULL,'',0),(1789,3,331,'2014-01-08 10:00:00','2014-01-08 10:30:00',2,NULL,'',0),(1791,3,96,'2014-02-18 10:00:00','2014-02-18 10:30:00',2,NULL,'',0),(1792,4,668,'2013-12-04 14:30:00','2013-12-04 15:30:00',5,NULL,'reception de toutes vos exigences. m.bonnetarobassarar.fr',0),(1793,2,599,'2013-11-21 15:00:00','2013-11-21 15:30:00',1,NULL,'résultat PV',0),(1794,3,33,'2014-02-05 10:00:00','2014-02-05 10:30:00',1,NULL,'',0),(1795,3,609,'2014-01-09 09:30:00','2014-01-09 10:00:00',1,NULL,'',0),(1797,2,471,'2014-03-03 16:00:00','2014-03-03 17:00:00',3,NULL,'PV',0),(1799,2,663,'2013-11-13 14:30:00','2013-11-13 15:00:00',2,NULL,'',0),(1800,2,663,'2014-01-07 16:30:00','2014-01-07 17:30:00',3,NULL,'PV',0),(1802,3,120,'2014-01-08 14:00:00','2014-01-08 14:30:00',2,NULL,'',0),(1803,3,140,'2013-12-06 14:30:00','2013-12-06 15:00:00',2,NULL,'Uniquement TLCO',0),(1805,2,613,'2013-11-13 16:30:00','2013-11-13 17:30:00',4,NULL,'PSG',0),(1806,4,669,'2013-11-19 11:30:00','2013-11-19 12:00:00',1,NULL,'',0),(1807,4,669,'2013-11-26 14:45:00','2013-11-26 15:45:00',3,NULL,'ne peux venir ;ne viendra pas pour efr prevu demain',0),(1808,3,640,'2013-12-06 15:00:00','2013-12-06 15:30:00',2,NULL,'',0),(1809,2,656,'2013-11-12 08:30:00','2013-11-12 09:00:00',2,NULL,'',0),(1810,4,75,'2013-11-07 08:00:00','2013-11-07 08:30:00',2,NULL,'ne supporte pas la ppc - a l\'impression d\'étouffer.',0),(1811,4,61,'2014-01-07 08:00:00','2014-01-07 08:30:00',2,NULL,'',0),(1812,4,282,'2014-01-07 14:30:00','2014-01-07 15:00:00',2,NULL,'',0),(1814,3,173,'2013-11-13 08:30:00','2013-11-13 09:00:00',1,NULL,'',0),(1816,4,672,'2013-11-14 10:30:00','2013-11-14 11:00:00',1,NULL,'',0),(1817,4,135,'2014-01-07 15:30:00','2014-01-07 16:00:00',2,NULL,'Prévoir une cs',0),(1818,3,403,'2013-11-20 11:30:00','2013-11-20 12:00:00',1,NULL,'',0),(1819,3,555,'2013-11-08 16:30:00','2013-11-08 17:00:00',1,NULL,'',0),(1820,3,199,'2014-01-09 09:00:00','2014-01-09 09:30:00',2,NULL,'',0),(1821,3,673,'2014-01-09 09:30:00','2014-01-09 10:00:00',2,NULL,'',0),(1822,3,171,'2014-02-05 08:00:00','2014-02-05 08:30:00',1,NULL,'',0),(1823,4,162,'2013-11-08 11:45:00','2013-11-08 12:15:00',1,NULL,'',0),(1824,3,440,'2013-11-22 14:00:00','2013-11-22 14:30:00',1,NULL,'',0),(1825,3,235,'2014-01-09 08:00:00','2014-01-09 08:30:00',1,NULL,'',0),(1826,4,75,'2013-11-13 13:30:00','2013-11-13 14:30:00',5,NULL,'iSIS VIENT VOIR CE QUI NE VA PAS POUR LA PPC',0),(1827,3,493,'2014-01-03 14:30:00','2014-01-03 15:00:00',1,NULL,'',0),(1828,3,162,'2014-01-09 14:30:00','2014-01-09 15:00:00',1,NULL,'',0),(1829,4,674,'2013-11-20 15:00:00','2013-11-20 15:30:00',1,NULL,'',0),(1830,3,658,'2013-11-14 14:00:00','2013-11-14 14:30:00',2,NULL,'',0),(1831,3,484,'2013-11-22 14:30:00','2013-11-22 15:00:00',1,NULL,'',0),(1832,3,236,'2014-01-10 15:00:00','2014-01-10 15:30:00',1,NULL,'',0),(1833,3,637,'2013-11-22 15:00:00','2013-11-22 15:30:00',1,NULL,'',0),(1834,3,220,'2014-01-09 10:00:00','2014-01-09 10:30:00',2,NULL,'',0),(1835,3,533,'2014-01-08 15:00:00','2014-01-08 15:30:00',2,NULL,'Sur tracheo',0),(1836,4,675,'2013-11-12 09:00:00','2013-11-12 09:30:00',1,NULL,'',0),(1837,3,34,'2013-12-13 15:30:00','2013-12-13 16:00:00',2,NULL,'RV Dr Blanc le 06/01/2014 à 10:30',0),(1838,4,676,'2013-11-13 11:30:00','2013-11-13 12:00:00',1,NULL,'',0),(1839,3,238,'2013-12-17 09:00:00','2013-12-17 09:30:00',1,NULL,'Voir SOS OXG pour observance',0),(1842,4,678,'2013-11-18 11:30:00','2013-11-18 12:00:00',1,NULL,'Adressé par Dr. Lebihan',0),(1843,4,573,'2013-11-26 10:30:00','2013-11-26 11:00:00',2,NULL,'Contactera pour ces (résultat de EFR et PV)',0),(1844,4,632,'2013-11-13 15:00:00','2013-11-13 15:30:00',2,NULL,'',0),(1845,3,654,'2014-01-15 08:00:00','2014-01-15 08:30:00',1,NULL,'',0),(1846,2,679,'2013-11-19 08:00:00','2013-11-19 08:30:00',1,NULL,'adressé par tel par Dr. U. Paratian',0),(1847,3,675,'2013-11-19 10:30:00','2013-11-19 11:00:00',2,NULL,'',0),(1848,4,680,'2013-12-23 11:30:00','2013-12-23 12:00:00',1,NULL,'A des aptnées.\r\nN\'a pas pu venir a son RV',0),(1849,3,197,'2014-01-21 08:30:00','2014-01-21 09:00:00',2,NULL,'',0),(1850,3,584,'2013-11-22 14:40:00','2013-11-22 15:10:00',1,NULL,'',0),(1851,3,661,'2013-12-27 14:30:00','2013-12-27 15:00:00',1,NULL,'',0),(1852,2,615,'2013-11-25 15:15:00','2013-11-25 15:45:00',2,NULL,'',0),(1853,4,221,'2013-11-21 14:30:00','2013-11-21 15:00:00',1,NULL,'',0),(1855,3,173,'2013-12-04 14:00:00','2013-12-04 14:30:00',1,NULL,'',0),(1856,3,563,'2014-01-29 08:00:00','2014-01-29 08:30:00',1,NULL,'',0),(1857,3,85,'2013-12-11 09:00:00','2013-12-11 09:30:00',1,NULL,'',0),(1858,3,523,'2014-04-21 14:00:00','2014-04-21 14:30:00',2,NULL,'',0),(1860,3,523,'2013-12-09 15:00:00','2013-12-09 15:30:00',1,NULL,'',0),(1861,2,610,'2013-11-20 10:30:00','2013-11-20 11:00:00',2,NULL,'',0),(1862,2,610,'2014-02-19 15:30:00','2014-02-19 16:30:00',3,NULL,'PV',0),(1863,3,82,'2013-12-17 10:00:00','2013-12-17 10:30:00',1,NULL,'',0),(1864,3,332,'2014-01-09 10:30:00','2014-01-09 11:00:00',1,NULL,'',0),(1865,4,683,'2013-11-18 11:00:00','2013-11-18 11:30:00',1,NULL,'',0),(1866,3,439,'2014-01-15 08:30:00','2014-01-15 09:00:00',1,NULL,'',0),(1867,3,676,'2013-11-18 13:30:00','2013-11-18 14:30:00',2,NULL,'',0),(1868,3,75,'2013-12-16 14:30:00','2013-12-16 15:00:00',1,NULL,'',0),(1869,3,100,'2014-01-06 14:30:00','2014-01-06 15:00:00',1,NULL,'D après son gendre, Mr Boyer est essoufflé après avoir soulève un bouteille de 5 litres',0),(1870,3,222,'2014-02-05 14:00:00','2014-02-05 14:30:00',2,NULL,'',0),(1871,4,539,'2013-12-05 08:00:00','2013-12-05 08:30:00',1,NULL,'',0),(1872,4,68,'2013-12-05 08:30:00','2013-12-05 09:00:00',1,NULL,'',0),(1873,3,243,'2013-12-06 15:30:00','2013-12-06 16:00:00',1,NULL,'',0),(1874,4,154,'2013-12-05 11:30:00','2013-12-05 12:00:00',1,NULL,'',0),(1875,3,2,'2013-11-15 15:30:00','2013-11-15 16:00:00',1,NULL,'',0),(1876,4,47,'2013-12-05 09:30:00','2013-12-05 10:00:00',1,NULL,'',0),(1878,3,562,'2014-01-23 16:00:00','2014-01-23 17:00:00',4,NULL,'psg',0),(1879,3,185,'2013-11-22 16:00:00','2013-11-22 16:30:00',1,NULL,'résultat pv\r\nSeprodom',0),(1881,2,613,'2013-11-14 09:00:00','2013-11-14 09:30:00',1,NULL,'',0),(1882,2,613,'2013-11-20 15:30:00','2013-11-20 16:00:00',1,NULL,'résultat PSG',0),(1883,3,487,'2014-01-23 08:30:00','2014-01-23 09:00:00',1,NULL,'',0),(1885,4,688,'2013-11-19 15:00:00','2013-11-19 15:30:00',1,NULL,'',0),(1886,3,529,'2013-11-19 09:00:00','2013-11-19 09:30:00',2,NULL,'',0),(1887,4,689,'2013-12-04 14:30:00','2013-12-04 15:00:00',1,NULL,'Veux avoir des nouvelles de yOHAND Batou',0),(1888,4,249,'2013-11-18 15:00:00','2013-11-18 15:30:00',2,NULL,'',0),(1889,3,634,'2014-01-16 09:00:00','2014-01-16 09:30:00',1,NULL,'',0),(1890,3,437,'2014-02-11 08:00:00','2014-02-11 08:30:00',1,NULL,'',0),(1891,4,83,'2013-11-14 11:00:00','2013-11-14 11:30:00',1,NULL,'',0),(1892,4,83,'2014-02-11 11:00:00','2014-02-11 11:30:00',2,NULL,'',0),(1894,3,165,'2014-01-09 14:00:00','2014-01-09 14:30:00',2,NULL,'',0),(1895,4,690,'2013-11-14 13:30:00','2013-11-14 14:00:00',1,NULL,'',0),(1896,2,667,'2013-11-19 10:00:00','2013-11-19 10:30:00',2,NULL,'',0),(1897,2,667,'2013-11-25 15:30:00','2013-11-25 16:30:00',3,NULL,'PV. Lui remettre  enveloppe  pour son médecin traitant.',0),(1898,2,690,'2013-11-27 10:30:00','2013-11-27 11:00:00',2,NULL,'',0),(1901,4,329,'2014-02-04 16:00:00','2014-02-04 17:00:00',3,NULL,'',0),(1902,2,658,'2013-11-27 16:30:00','2013-11-27 17:30:00',4,NULL,'PSG',0),(1903,4,203,'2013-12-05 15:00:00','2013-12-05 15:30:00',1,NULL,'',0),(1904,3,592,'2014-04-08 08:30:00','2014-04-08 09:00:00',1,NULL,'',0),(1905,4,270,'2014-01-08 10:30:00','2014-01-08 11:00:00',2,NULL,'',0),(1907,4,692,'2013-12-05 15:45:00','2013-12-05 16:15:00',1,NULL,'',0),(1908,3,601,'2013-12-12 11:00:00','2013-12-12 11:30:00',1,NULL,'',0),(1909,3,625,'2013-11-22 15:00:00','2013-11-22 15:30:00',2,NULL,'',0),(1910,2,627,'2013-11-18 15:30:00','2013-11-18 16:00:00',1,NULL,'résultat PV',0),(1911,3,624,'2013-11-22 15:30:00','2013-11-22 16:00:00',2,NULL,'',0),(1912,4,81,'2014-01-09 16:30:00','2014-01-09 17:30:00',3,NULL,'PV prévoir jambiers',0),(1914,3,542,'2013-12-24 15:00:00','2013-12-24 15:30:00',1,NULL,'',0),(1916,2,693,'2013-11-20 16:30:00','2013-11-20 17:00:00',1,NULL,'',0),(1917,3,310,'2013-12-04 16:00:00','2013-12-04 16:30:00',1,NULL,'',0),(1918,3,175,'2014-01-15 08:30:00','2014-01-15 09:00:00',2,NULL,'',0),(1919,3,522,'2013-11-27 08:30:00','2013-11-27 09:00:00',2,NULL,'',0),(1920,4,695,'2013-12-12 11:30:00','2013-12-12 12:00:00',1,NULL,'rappelera pour rv efr',0),(1921,4,522,'2013-11-18 09:00:00','2013-11-18 09:30:00',1,NULL,'',0),(1923,3,191,'2013-11-20 08:30:00','2013-11-20 09:00:00',2,NULL,'',0),(1924,4,448,'2013-12-04 11:30:00','2013-12-04 12:00:00',1,NULL,'',0),(1925,4,316,'2013-12-05 10:30:00','2013-12-05 11:00:00',1,NULL,'',0),(1926,4,178,'2013-11-21 10:00:00','2013-11-21 10:30:00',1,NULL,'',0),(1928,3,455,'2014-01-14 09:30:00','2014-01-14 10:00:00',2,NULL,'',0),(1929,3,683,'2013-12-24 11:00:00','2013-12-24 11:30:00',1,NULL,'A signale qu\'elle ronfle la nuit',0),(1930,3,572,'2013-12-19 11:00:00','2013-12-19 11:30:00',1,NULL,'',0),(1931,3,678,'2013-11-19 08:30:00','2013-11-19 09:00:00',2,NULL,'',0),(1932,3,161,'2013-12-13 14:00:00','2013-12-13 14:30:00',1,NULL,'',0),(1933,3,676,'2013-12-17 14:30:00','2013-12-17 15:00:00',1,NULL,'',0),(1934,3,627,'2013-12-18 11:00:00','2013-12-18 11:30:00',1,NULL,'',0),(1935,3,423,'2013-12-13 17:00:00','2013-12-13 17:30:00',1,NULL,'',0),(1936,4,699,'2013-11-19 09:40:00','2013-11-19 10:10:00',1,NULL,'',0),(1937,3,679,'2013-11-22 17:15:00','2013-11-22 17:45:00',1,NULL,'',0),(1938,3,678,'2013-12-13 14:30:00','2013-12-13 15:00:00',1,NULL,'',0),(1940,3,529,'2013-12-26 09:30:00','2013-12-26 10:00:00',1,NULL,'',0),(1941,3,472,'2014-01-21 11:00:00','2014-01-21 11:30:00',1,NULL,'',0),(1942,3,699,'2013-12-05 14:00:00','2013-12-05 14:30:00',1,NULL,'Arixtra 7.5;tardyferon 80mg 1X3',0),(1943,3,489,'2013-11-22 16:30:00','2013-11-22 17:00:00',1,NULL,'',0),(1944,4,632,'2013-12-06 16:00:00','2013-12-06 16:30:00',1,NULL,'résultat PV',0),(1945,3,675,'2013-12-27 11:00:00','2013-12-27 11:30:00',1,NULL,'',0),(1947,3,669,'2013-12-06 15:00:00','2013-12-06 15:30:00',1,NULL,'',0),(1948,4,701,'2013-11-22 14:00:00','2013-11-22 14:30:00',2,NULL,'Spirometrie avec bouc débit volume',0),(1949,3,29,'2013-12-03 15:00:00','2013-12-03 15:30:00',2,NULL,'',0),(1950,3,29,'2013-12-23 15:30:00','2013-12-23 16:00:00',1,NULL,'résultat EFR',0),(1951,3,371,'2014-01-09 15:00:00','2014-01-09 15:30:00',2,NULL,'',0),(1953,3,519,'2013-12-16 16:00:00','2013-12-16 16:30:00',1,NULL,'',0),(1956,3,52,'2014-01-21 09:30:00','2014-01-21 10:00:00',2,NULL,'',0),(1957,4,184,'2013-12-05 13:45:00','2013-12-05 14:15:00',1,NULL,'',0),(1958,3,575,'2013-12-24 08:30:00','2013-12-24 09:00:00',1,NULL,'N avait pas amenersa carte vitale ne pas oublier de repasser sa carte vitale quand il revient en janvier',0),(1959,3,417,'2013-12-24 08:00:00','2013-12-24 08:30:00',1,NULL,'',0),(1960,2,191,'2013-11-18 10:00:00','2013-11-18 10:30:00',1,NULL,'',0),(1961,3,397,'2014-02-04 10:30:00','2014-02-04 11:00:00',2,NULL,'',0),(1962,4,357,'2013-12-11 14:30:00','2013-12-11 15:00:00',1,NULL,'Résultats psg',0),(1963,4,357,'2013-11-20 08:30:00','2013-11-20 09:00:00',1,NULL,'',0),(1964,4,271,'2013-11-21 15:30:00','2013-11-21 16:00:00',1,NULL,'n a plus de medicament',0),(1965,4,480,'2013-11-02 14:30:00','2013-11-02 15:00:00',1,NULL,'06922105',0),(1966,3,610,'2013-12-10 08:30:00','2013-12-10 09:00:00',1,NULL,'',0),(1967,3,137,'2014-01-28 11:00:00','2014-01-28 11:30:00',2,NULL,'',0),(1968,3,2,'2013-11-21 09:30:00','2013-11-21 10:00:00',1,NULL,'Consultera Dr Bourgeon le 6 DEC pour écho abdominale et autre',0),(1969,4,480,'2002-12-05 02:30:00','2002-12-05 03:00:00',1,NULL,'',0),(1970,3,403,'2013-12-13 15:00:00','2013-12-13 15:30:00',1,NULL,'',0),(1971,2,628,'2013-12-06 14:30:00','2013-12-06 15:00:00',1,NULL,'résultat PSG',0),(1972,2,702,'2013-12-05 14:30:00','2013-12-05 15:00:00',1,NULL,'adressée par le Centre de rééducation de Sainte-Clotilde',0),(1973,2,703,'2013-12-04 16:30:00','2013-12-04 17:00:00',1,NULL,'adressé par le Centre de rééducation de Sainte-Clotilde',0),(1974,2,704,'2013-12-06 16:30:00','2013-12-06 17:00:00',1,NULL,'adressée par le Centre de rééducation de Sainte-Clotilde',0),(1975,2,705,'2013-12-05 16:30:00','2013-12-05 17:00:00',1,NULL,'adressé par le Centre de rééducation de Sainte-Clotilde',0),(1976,2,480,'2013-12-05 14:30:00','2013-12-05 15:00:00',1,NULL,'',0),(1977,2,207,'2013-11-21 08:30:00','2013-11-21 09:00:00',1,NULL,'patiente envoyée par Dr. CADET Bruno. A été hospitalisée 10 jours en pneumo. VNI?',0),(1978,3,674,'2013-12-18 14:00:00','2013-12-18 14:30:00',1,NULL,'',0),(1979,3,547,'2013-12-24 10:00:00','2013-12-24 10:30:00',1,NULL,'',0),(1980,4,506,'2014-01-13 16:30:00','2014-01-13 17:30:00',4,NULL,'PSG',0),(1981,3,613,'2013-12-10 15:00:00','2013-12-10 15:30:00',1,NULL,'',0),(1982,3,665,'2014-01-10 14:00:00','2014-01-10 14:30:00',2,NULL,'',0),(1983,2,186,'2013-12-11 15:00:00','2013-12-11 15:30:00',1,NULL,'résultat PV',0),(1984,3,693,'2013-12-06 17:00:00','2013-12-06 17:30:00',1,NULL,'',0),(1985,2,693,'2013-11-26 11:00:00','2013-11-26 11:30:00',2,NULL,'',0),(1986,2,693,'2013-12-03 17:00:00','2013-12-03 18:00:00',3,NULL,'PV',0),(1987,3,470,'2014-02-13 08:00:00','2014-02-13 08:30:00',1,NULL,'',0),(1988,3,207,'2013-12-05 11:00:00','2013-12-05 11:30:00',2,NULL,'',0),(1989,3,178,'2014-01-28 09:00:00','2014-01-28 09:30:00',2,NULL,'',0),(1990,4,688,'2013-11-22 16:30:00','2013-11-22 17:00:00',2,NULL,'',0),(1993,4,487,'2013-11-21 09:00:00','2013-11-21 09:30:00',1,NULL,'',0),(1994,3,105,'2014-01-29 10:00:00','2014-01-29 10:30:00',1,NULL,'',0),(1995,4,129,'2013-12-09 15:30:00','2013-12-09 16:00:00',1,NULL,'resultat PSG',0),(1996,3,195,'2013-12-12 11:00:00','2013-12-12 11:30:00',2,NULL,'',0),(1997,3,69,'2013-12-17 10:30:00','2013-12-17 11:00:00',1,NULL,'',0),(1998,3,221,'2013-12-23 15:00:00','2013-12-23 15:30:00',1,NULL,'',0),(1999,3,552,'2013-12-10 16:00:00','2013-12-10 16:30:00',1,NULL,'',0),(2000,2,254,'2013-12-05 16:30:00','2013-12-05 17:30:00',4,NULL,'PSG',0),(2001,2,406,'2013-12-12 10:30:00','2013-12-12 11:00:00',1,NULL,'résultat PV',0),(2002,4,707,'2013-12-10 11:30:00','2013-12-10 12:00:00',1,NULL,'',0),(2003,3,599,'2013-12-10 16:30:00','2013-12-10 17:00:00',1,NULL,'',0),(2004,2,164,'2013-12-05 17:00:00','2013-12-05 17:30:00',1,NULL,'',0),(2005,2,145,'2013-12-13 16:30:00','2013-12-13 17:00:00',1,NULL,'Résultat PSG',0),(2006,3,440,'2014-02-05 08:30:00','2014-02-05 09:00:00',1,NULL,'',0),(2007,2,710,'2013-11-22 14:30:00','2013-11-22 15:00:00',1,NULL,'',0),(2008,2,710,'2013-11-27 15:30:00','2013-11-27 16:00:00',2,NULL,'',0),(2009,4,464,'2013-12-11 15:00:00','2013-12-11 15:30:00',1,NULL,'',0),(2010,4,134,'2013-11-22 15:30:00','2013-11-22 16:00:00',1,NULL,'',0),(2011,3,484,'2013-12-27 14:00:00','2013-12-27 14:30:00',1,NULL,'',0),(2012,3,584,'2013-12-18 15:30:00','2013-12-18 16:00:00',1,NULL,'',0),(2013,2,711,'2013-11-22 14:30:00','2013-11-22 15:00:00',1,NULL,'',0),(2014,2,711,'2013-11-29 17:00:00','2013-11-29 18:00:00',4,NULL,'PSG',0),(2016,3,711,'2013-12-09 16:00:00','2013-12-09 16:30:00',1,NULL,'résultat PSG',0),(2017,4,271,'2013-12-17 09:30:00','2013-12-17 10:00:00',1,NULL,'Résultat d\'EFR',0),(2018,3,185,'2013-12-12 09:30:00','2013-12-12 10:00:00',1,NULL,'Voir si bien app:SEPRODOM en VNI?',0),(2019,2,667,'2013-12-11 10:00:00','2013-12-11 10:30:00',1,NULL,'résultat PV + explication EFR',0),(2020,4,42,'2014-01-15 15:00:00','2014-01-15 15:30:00',2,NULL,'',0),(2021,4,93,'2014-01-16 09:30:00','2014-01-16 10:00:00',2,NULL,'',0),(2022,4,72,'2013-12-04 14:30:00','2013-12-04 15:00:00',2,NULL,'',0),(2023,4,530,'2014-01-15 10:30:00','2014-01-15 11:00:00',2,NULL,'',0),(2024,2,713,'2013-12-10 15:30:00','2013-12-10 16:00:00',1,NULL,'adressé par le Dr. Epatsin ?\r\ndiabète. décalage de phase. suspicion SAS. prévoir PV. Hospitalisé Dr rappellera.',0),(2025,2,714,'2013-12-09 17:00:00','2013-12-09 17:30:00',1,NULL,'pb de sommeil : ronflements, fatiguée le matin, migraines.\r\nSur les conseils de M. Lartin',0),(2026,2,714,'2013-12-10 17:00:00','2013-12-10 18:00:00',3,NULL,'PV?',0),(2027,2,715,'2013-12-04 17:00:00','2013-12-04 17:30:00',1,NULL,'Souhaiterai un deuxième avis après diagnostic sévère émis par le CHU. Ami de M. Cheung Lung.',0),(2028,2,715,'2013-12-05 10:30:00','2013-12-05 11:00:00',2,NULL,'EFR pris au cas ou il s\'avererai necessaire. A confirmer lors de la CS du 4 dec.',0),(2029,4,253,'2013-12-12 14:00:00','2013-12-12 14:30:00',1,NULL,'',0),(2030,2,1,'2013-12-12 14:30:00','2013-12-12 15:00:00',1,NULL,'donner résultat 2e EFR + renouveler médicaments',0),(2033,4,719,'2013-12-11 08:00:00','2013-12-11 08:30:00',1,NULL,'Dyspnée d effort. Dr GUilbaud0262 21 52 70',0),(2034,4,46,'2014-01-08 11:00:00','2014-01-08 11:30:00',2,NULL,'',0),(2037,4,148,'2013-12-11 15:30:00','2013-12-11 16:00:00',2,NULL,'A perdu ordonnance pour faire scanner',0),(2038,2,201,'2013-12-04 15:00:00','2013-12-04 15:30:00',1,NULL,'Mme Sylvie PICARDO (fille) souhaiterai une explication des résultat du scanner thoracique',0),(2039,2,213,'2013-12-12 15:00:00','2013-12-12 15:30:00',1,NULL,'donner résultat PV\r\na eu un examen EMG en faveur d\'un syndrome de canal carpien gauche prononcé.',0),(2040,2,710,'2013-12-12 17:00:00','2013-12-12 17:30:00',1,NULL,'résultat EFR',0),(2041,4,723,'2013-12-04 08:00:00','2013-12-04 08:30:00',1,NULL,'venue au cabinet vend lui ai conseillé d\'aller aux urgences.',0),(2043,4,103,'2014-01-09 11:30:00','2014-01-09 12:00:00',2,NULL,'',0),(2044,4,103,'2014-01-15 14:30:00','2014-01-15 15:00:00',1,NULL,'',0),(2046,4,136,'2014-01-14 10:00:00','2014-01-14 10:30:00',2,NULL,'',0),(2048,4,59,'2014-01-15 11:30:00','2014-01-15 12:00:00',2,NULL,'Hospitalisé nov aux urgences',0),(2052,4,826,'2013-12-27 08:00:00','2013-12-27 09:00:00',5,NULL,'',0),(2053,4,725,'2013-12-12 15:30:00','2013-12-12 16:00:00',1,NULL,'A fait une réaction respiratoire au vaccin contre la leptospiroses. Souhaiterai un bilan.6/1/2014 a déjà du son vaccin ne veux plus faire efr.',0),(2054,2,726,'2013-12-17 11:30:00','2013-12-17 12:00:00',1,NULL,'adressé par le Dr Satsou',0),(2056,2,723,'2013-12-09 14:30:00','2013-12-09 15:00:00',2,NULL,'',0),(2057,2,723,'2014-02-21 17:00:00','2014-02-21 18:00:00',3,NULL,'PV',0),(2058,4,729,'2013-12-17 11:30:00','2013-12-17 12:00:00',1,NULL,'Souhaite une Psgde la part de Laurent grd pre',0),(2059,3,182,'2014-02-12 08:30:00','2014-02-12 09:00:00',2,NULL,'',0),(2060,4,675,'2013-12-04 13:30:00','2013-12-04 14:00:00',1,NULL,'A domicile',0),(2061,3,543,'2014-03-10 14:00:00','2014-03-10 14:30:00',2,NULL,'',0),(2062,3,730,'2014-02-05 08:30:00','2014-02-05 09:00:00',2,NULL,'',0),(2063,4,731,'2013-12-19 08:30:00','2013-12-19 09:00:00',1,NULL,'',0),(2064,4,732,'2013-12-18 10:00:00','2013-12-18 10:30:00',1,NULL,'Centre de rééducation  adresse ce patient pour psg',0),(2065,4,730,'2013-12-04 10:00:00','2013-12-04 10:30:00',1,NULL,'',0),(2067,3,90,'2014-02-05 09:30:00','2014-02-05 10:00:00',1,NULL,'',0),(2068,4,150,'2013-12-12 14:30:00','2013-12-12 15:00:00',2,NULL,'',0),(2069,3,216,'2014-02-07 14:30:00','2014-02-07 15:00:00',1,NULL,'',0),(2070,4,671,'2014-03-04 14:00:00','2014-03-04 14:30:00',2,NULL,'Prévoir polygraphie nocturne\r\n',0),(2071,2,615,'2013-12-06 17:30:00','2013-12-06 18:30:00',5,NULL,'entretien embauche',0),(2072,4,234,'2014-03-04 14:30:00','2014-03-04 15:30:00',3,NULL,'',0),(2073,4,733,'2013-12-16 15:30:00','2013-12-16 16:00:00',1,NULL,'',0),(2075,4,734,'2013-12-16 16:00:00','2013-12-16 16:30:00',1,NULL,'',0),(2077,3,173,'2014-01-08 08:00:00','2014-01-08 08:30:00',2,NULL,'',0),(2078,3,173,'2014-02-12 09:00:00','2014-02-12 09:30:00',1,NULL,'renouvellement médicaments',0),(2080,2,689,'2014-01-28 16:00:00','2014-01-28 17:00:00',3,NULL,'PV',0),(2081,3,310,'2014-02-18 08:00:00','2014-02-18 08:30:00',1,NULL,'',0),(2082,2,703,'2013-12-11 16:00:00','2013-12-11 16:30:00',2,NULL,'',0),(2083,2,703,'2014-02-11 16:00:00','2014-02-11 17:00:00',4,NULL,'PSG',0),(2085,3,539,'2014-01-17 15:00:00','2014-01-17 15:30:00',2,NULL,'',0),(2086,3,68,'2014-02-13 09:00:00','2014-02-13 09:30:00',2,NULL,'',0),(2087,3,35,'2014-01-23 09:00:00','2014-01-23 09:30:00',2,NULL,'',0),(2088,2,26,'2013-12-10 16:00:00','2013-12-10 17:00:00',3,NULL,'PV',0),(2090,2,736,'2013-12-17 15:00:00','2013-12-17 15:30:00',1,NULL,'',0),(2091,3,47,'2014-01-13 11:00:00','2014-01-13 11:30:00',2,NULL,'Corticott à adjuster',0),(2092,3,460,'2014-01-23 10:00:00','2014-01-23 10:30:00',2,NULL,'',0),(2093,4,157,'2014-01-07 08:00:00','2014-01-07 08:30:00',1,NULL,'',0),(2094,3,316,'2014-02-04 11:00:00','2014-02-04 11:30:00',2,NULL,'',0),(2095,4,154,'2014-02-03 15:30:00','2014-02-03 16:30:00',3,NULL,'',0),(2096,3,154,'2014-01-23 11:00:00','2014-01-23 11:30:00',2,NULL,'',0),(2097,4,70,'2013-12-09 17:00:00','2013-12-09 17:30:00',2,NULL,'',0),(2098,3,196,'2014-01-29 08:30:00','2014-01-29 09:00:00',2,NULL,'',0),(2099,4,248,'2014-01-13 10:30:00','2014-01-13 11:00:00',2,NULL,'',0),(2100,3,715,'2014-02-11 11:30:00','2014-02-11 12:00:00',2,NULL,'',0),(2101,3,207,'2014-01-14 11:00:00','2014-01-14 11:30:00',1,NULL,'',0),(2102,2,386,'2013-12-06 14:00:00','2013-12-06 14:30:00',2,NULL,'',0),(2103,3,99,'2013-12-05 15:30:00','2013-12-05 16:00:00',1,NULL,'',0),(2104,3,184,'2014-02-05 14:00:00','2014-02-05 14:30:00',1,NULL,'',0),(2105,3,699,'2013-12-12 15:30:00','2013-12-12 16:00:00',1,NULL,'EchoD MI + Bil Thphil',0),(2106,2,702,'2014-01-20 14:00:00','2014-01-20 14:30:00',2,NULL,'',0),(2107,2,702,'2014-02-13 16:00:00','2014-02-13 17:00:00',3,NULL,'PV',0),(2108,4,43,'2014-02-24 16:00:00','2014-02-24 17:00:00',3,NULL,'',0),(2110,2,203,'2014-03-05 16:00:00','2014-03-05 17:00:00',4,NULL,'PSG',0),(2111,3,203,'2014-01-20 15:00:00','2014-01-20 15:30:00',2,NULL,'',0),(2112,3,99,'2013-12-06 16:30:00','2013-12-06 17:00:00',2,NULL,'',0),(2114,3,692,'2013-12-13 16:30:00','2013-12-13 17:00:00',2,NULL,'',0),(2115,3,160,'2014-04-01 16:00:00','2014-04-01 16:30:00',1,NULL,'',0),(2116,2,705,'2014-01-23 08:00:00','2014-01-23 08:30:00',2,NULL,'',0),(2118,4,314,'2014-02-26 16:00:00','2014-02-26 17:00:00',3,NULL,'',0),(2119,2,737,'2013-12-18 14:30:00','2013-12-18 15:00:00',1,NULL,'',0),(2120,2,738,'2013-12-16 16:30:00','2013-12-16 17:00:00',1,NULL,'',0),(2121,2,243,'2013-12-09 15:00:00','2013-12-09 15:30:00',2,NULL,'',0),(2123,3,386,'2013-12-13 15:30:00','2013-12-13 16:00:00',1,NULL,'',0),(2124,3,640,'2014-02-04 14:00:00','2014-02-04 14:30:00',1,NULL,'',0),(2125,3,704,'2014-01-20 16:30:00','2014-01-20 17:00:00',3,NULL,'',0),(2126,3,704,'2014-02-05 09:30:00','2014-02-05 10:00:00',2,NULL,'résultat PV?',0),(2128,2,632,'2014-03-06 16:00:00','2014-03-06 17:00:00',4,NULL,'PSG',0),(2129,4,689,'2013-12-06 17:00:00','2013-12-06 17:30:00',2,NULL,'',0),(2131,2,693,'2014-03-10 16:00:00','2014-03-10 17:00:00',4,NULL,'PSG',0),(2132,3,689,'2014-02-26 14:00:00','2014-02-26 14:30:00',2,NULL,'',0),(2134,3,243,'2013-12-16 16:45:00','2013-12-16 17:15:00',1,NULL,'',0),(2135,3,281,'2014-01-21 10:00:00','2014-01-21 10:30:00',1,NULL,'',0),(2137,4,744,'2013-12-18 10:30:00','2013-12-18 11:00:00',1,NULL,'De la part du cabinet Jacques  Coeur Dr Vignal',0),(2138,4,748,'2013-12-17 16:00:00','2013-12-17 16:30:00',1,NULL,'ne viendra pas a son efr DU 10 JANV',0),(2139,3,129,'2014-01-22 08:30:00','2014-01-22 09:00:00',2,NULL,'',0),(2140,4,309,'2013-12-09 17:00:00','2013-12-09 17:30:00',1,NULL,'',0),(2141,3,711,'2013-12-19 14:00:00','2013-12-19 14:30:00',1,NULL,'',0),(2142,4,128,'2014-01-14 15:00:00','2014-01-14 15:30:00',2,NULL,'',0),(2143,4,751,'2013-12-18 15:00:00','2013-12-18 15:30:00',1,NULL,'',0),(2144,3,86,'2014-02-10 17:00:00','2014-02-10 17:30:00',2,NULL,'',0),(2145,2,714,'2013-12-12 15:30:00','2013-12-12 16:00:00',2,NULL,'',0),(2146,4,57,'2014-01-28 09:30:00','2014-01-28 10:00:00',2,NULL,'',0),(2147,2,70,'2014-02-27 16:00:00','2014-02-27 17:00:00',3,NULL,'PV',0),(2148,3,70,'2014-01-22 10:00:00','2014-01-22 10:30:00',1,NULL,'',0),(2149,3,159,'2014-01-22 09:30:00','2014-01-22 10:00:00',2,NULL,'Son médecin aimerait quel vienne plus souvent consulter son pneumologue',0),(2150,4,753,'2013-12-11 08:30:00','2013-12-11 09:00:00',1,NULL,'',0),(2151,4,754,'2013-12-11 09:45:00','2013-12-11 10:15:00',1,NULL,'',0),(2152,2,754,'2013-12-12 10:30:00','2013-12-12 11:00:00',2,NULL,'',0),(2153,2,79,'2014-03-11 16:00:00','2014-03-11 17:00:00',3,NULL,'PV',0),(2154,4,167,'2013-12-24 11:30:00','2013-12-24 12:00:00',1,NULL,'',0),(2155,3,79,'2014-01-14 10:30:00','2014-01-14 11:00:00',1,NULL,'',0),(2156,4,757,'2013-12-10 16:15:00','2013-12-10 16:45:00',1,NULL,'',0),(2158,4,758,'2013-12-19 11:30:00','2013-12-19 12:00:00',1,NULL,'',0),(2159,3,240,'2014-02-18 09:00:00','2014-02-18 09:30:00',2,NULL,'',0),(2160,3,134,'2014-01-29 09:00:00','2014-01-29 09:30:00',1,NULL,'',0),(2161,3,707,'2013-12-17 16:30:00','2013-12-17 17:00:00',1,NULL,'',0),(2162,2,759,'2013-12-19 14:30:00','2013-12-19 15:00:00',1,NULL,'',0),(2164,2,761,'2013-12-19 15:30:00','2013-12-19 16:00:00',1,NULL,'',0),(2165,3,205,'2014-02-05 14:30:00','2014-02-05 15:00:00',1,NULL,'',0),(2166,3,613,'2014-01-15 11:00:00','2014-01-15 11:30:00',1,NULL,'',0),(2167,3,261,'2014-01-23 09:30:00','2014-01-23 10:00:00',1,NULL,'',0),(2168,3,552,'2013-12-30 15:30:00','2013-12-30 10:30:00',1,NULL,'',0),(2169,3,757,'2013-12-16 17:00:00','2013-12-16 17:30:00',1,NULL,'',0),(2170,3,599,'2014-02-06 09:00:00','2014-02-06 09:30:00',2,NULL,'',0),(2171,3,26,'2014-01-28 15:30:00','2014-01-28 16:00:00',1,NULL,'',0),(2172,2,714,'2013-12-17 17:00:00','2013-12-17 17:30:00',1,NULL,'résultat PV + résultat EFR',0),(2173,4,672,'2013-12-19 10:30:00','2013-12-19 11:00:00',1,NULL,'',0),(2174,3,85,'2014-03-04 08:30:00','2014-03-04 09:00:00',2,NULL,'',0),(2175,4,730,'2013-12-11 10:00:00','2013-12-11 10:30:00',1,NULL,'',0),(2176,2,667,'2014-03-12 16:00:00','2014-03-12 17:00:00',4,NULL,'PSG',0),(2177,2,658,'2013-12-24 14:30:00','2013-12-24 15:00:00',1,NULL,'Interpretation PSG',0),(2180,2,76,'2014-01-30 16:30:00','2014-01-30 17:30:00',4,NULL,'PSG',0),(2181,4,763,'2013-12-30 14:30:00','2013-12-30 15:00:00',1,NULL,'',0),(2183,2,458,'2014-03-17 16:30:00','2014-03-17 17:30:00',4,NULL,'PSG',0),(2184,3,25,'2014-02-26 11:00:00','2014-02-26 11:30:00',2,NULL,'',0),(2185,2,765,'2013-12-12 16:00:00','2013-12-12 16:30:00',1,NULL,'Opération de la cataracte prévue le mercredi 18 décembre. Son médecin demandée un bilan pulmonaire complet.',0),(2186,2,765,'2013-12-13 14:30:00','2013-12-13 15:00:00',2,NULL,'',0),(2187,2,2,'2013-12-19 08:00:00','2013-12-19 08:30:00',1,NULL,'',0),(2188,3,217,'2013-12-24 14:00:00','2013-12-24 14:30:00',1,NULL,'',0),(2189,4,767,'2013-12-23 10:30:00','2013-12-23 11:00:00',1,NULL,'A prévoir PSG',0),(2190,4,768,'2013-12-26 09:00:00','2013-12-26 09:30:00',1,NULL,'A prévoir PSG',0),(2191,2,766,'2014-01-21 10:30:00','2014-01-21 11:00:00',2,NULL,'',0),(2192,3,766,'2013-12-23 16:00:00','2013-12-23 16:30:00',1,NULL,'',0),(2193,2,766,'2013-12-11 15:00:00','2013-12-11 15:30:00',1,NULL,'',0),(2194,2,186,'2014-03-19 16:30:00','2014-03-19 17:30:00',4,NULL,'PSG',0),(2195,4,770,'2013-12-19 16:30:00','2013-12-19 17:30:00',5,NULL,'',0),(2197,3,55,'2014-02-18 08:30:00','2014-02-18 09:00:00',1,NULL,'',0),(2198,3,229,'2014-03-11 14:00:00','2014-03-11 14:30:00',2,NULL,'',0),(2199,2,117,'2014-03-18 16:30:00','2014-03-18 17:30:00',3,NULL,'PV',0),(2200,4,78,'2013-12-13 14:00:00','2013-12-13 14:30:00',2,NULL,'',0),(2201,3,185,'2014-02-05 10:30:00','2014-02-05 11:00:00',2,NULL,'',0),(2202,3,498,'2014-02-06 10:00:00','2014-02-06 10:30:00',2,NULL,'',0),(2203,4,572,'2013-12-12 11:30:00','2013-12-12 12:00:00',1,NULL,'',0),(2204,3,406,'2013-12-30 15:00:00','2013-12-30 15:30:00',1,NULL,'',0),(2205,3,754,'2014-01-16 10:00:00','2014-01-16 10:30:00',1,NULL,'',0),(2206,2,771,'2013-12-12 11:30:00','2013-12-12 12:00:00',1,NULL,'',0),(2207,2,771,'2014-01-22 10:30:00','2014-01-22 11:00:00',2,NULL,'',0),(2208,4,773,'2014-01-22 11:00:00','2014-01-22 11:30:00',1,NULL,'',0),(2209,3,771,'2013-12-16 13:45:00','2013-12-16 14:15:00',1,NULL,'',0),(2210,3,195,'2014-02-13 09:30:00','2014-02-13 10:00:00',1,NULL,'',0),(2211,3,601,'2014-01-10 15:30:00','2014-01-10 16:00:00',1,NULL,'',0),(2213,2,357,'2013-12-13 13:30:00','2013-12-13 14:00:00',1,NULL,'',0),(2214,3,253,'2014-02-11 15:00:00','2014-02-11 15:30:00',1,NULL,'',0),(2215,4,774,'2013-12-13 16:00:00','2013-12-13 16:30:00',1,NULL,'Depuis 10 jours : ne peux plus respirer.',0),(2216,3,1,'2014-03-04 09:30:00','2014-03-04 10:00:00',2,NULL,'',0),(2220,2,710,'2014-01-27 17:30:00','2014-01-27 18:30:00',3,NULL,'PV',0),(2221,3,777,'2013-12-17 13:30:00','2013-12-17 14:00:00',1,NULL,'',0),(2222,3,161,'2013-12-19 13:30:00','2013-12-19 14:00:00',1,NULL,'',0),(2223,3,278,'2014-01-16 10:30:00','2014-01-16 11:00:00',1,NULL,'',0),(2225,4,187,'2014-01-22 11:30:00','2014-01-22 12:00:00',2,NULL,'N a pas confirmer ce rendez vous ?',0),(2226,3,403,'2014-01-10 16:00:00','2014-01-10 16:30:00',1,NULL,'',0),(2227,3,386,'2013-12-27 15:00:00','2013-12-27 15:30:00',1,NULL,'',0),(2229,3,78,'2014-02-17 14:00:00','2014-02-17 15:00:00',1,NULL,'',0),(2230,4,699,'2013-12-13 16:15:00','2013-12-13 16:45:00',1,NULL,'',0),(2231,4,237,'2014-01-22 09:00:00','2014-01-22 09:30:00',1,NULL,'',0),(2232,2,774,'2014-01-15 14:30:00','2014-01-15 15:00:00',2,NULL,'',0),(2233,3,699,'2013-12-24 15:30:00','2013-12-24 16:00:00',1,NULL,'',0),(2234,3,145,'2014-01-17 17:00:00','2014-01-17 17:30:00',1,NULL,'',0),(2235,3,765,'2014-02-12 09:30:00','2014-02-12 10:00:00',1,NULL,'',0),(2236,3,692,'2014-02-18 16:30:00','2014-02-18 17:00:00',1,NULL,'',0),(2238,4,786,'2013-12-18 12:30:00','2013-12-18 13:30:00',5,NULL,'',0),(2239,3,733,'2014-02-12 14:00:00','2014-02-12 14:30:00',2,NULL,'',0),(2240,3,788,'2014-01-30 09:00:00','2014-01-30 09:30:00',2,NULL,'',0),(2241,3,621,'2014-02-12 14:30:00','2014-02-12 15:00:00',2,NULL,'',0),(2243,3,216,'2014-03-13 16:00:00','2014-03-13 17:00:00',3,NULL,'',0),(2244,3,519,'2014-04-18 16:00:00','2014-04-18 16:30:00',1,NULL,'',0),(2245,3,243,'2014-01-13 14:00:00','2014-01-13 14:30:00',1,NULL,'',0),(2246,3,738,'2013-12-30 15:30:00','2013-12-30 16:00:00',1,NULL,'',0),(2247,3,738,'2014-01-13 14:30:00','2014-01-13 15:00:00',2,NULL,'',0),(2248,3,121,'2014-02-12 08:00:00','2014-02-12 08:30:00',2,NULL,'',0),(2249,3,121,'2014-03-20 14:00:00','2014-03-20 15:00:00',3,NULL,'',0),(2250,4,194,'2013-12-17 14:00:00','2013-12-17 14:30:00',1,NULL,'',0),(2251,3,430,'2014-01-07 09:00:00','2014-01-07 09:30:00',1,NULL,'',0),(2252,4,730,'2013-12-24 09:00:00','2013-12-24 09:30:00',1,NULL,'',0),(2253,3,238,'2014-01-06 09:00:00','2014-01-06 09:30:00',1,NULL,'',0),(2254,4,791,'2013-12-27 15:30:00','2013-12-27 16:00:00',1,NULL,'',0),(2255,4,34,'2013-12-17 10:30:00','2013-12-17 11:00:00',1,NULL,'',0),(2256,4,211,'2013-12-24 10:30:00','2013-12-24 11:00:00',1,NULL,'',0),(2257,3,271,'2014-02-05 11:00:00','2014-02-05 11:30:00',1,NULL,'',0),(2258,4,698,'2013-12-30 13:00:00','2013-12-30 14:00:00',5,NULL,'0692004201 prestataire ISIS',0),(2259,3,82,'2013-12-03 16:30:00','2013-12-03 17:00:00',1,NULL,'',0),(2260,3,34,'2014-01-29 09:30:00','2014-01-29 10:00:00',2,NULL,'',0),(2261,3,726,'2014-01-30 09:30:00','2014-01-30 10:00:00',2,NULL,'',0),(2262,3,69,'2014-02-13 10:00:00','2014-02-13 10:30:00',2,NULL,'',0),(2264,3,729,'2014-02-19 16:30:00','2014-02-19 17:30:00',4,NULL,'PSG\r\nSOS Oxygène',0),(2266,4,38,'2013-12-17 15:00:00','2013-12-17 15:30:00',1,NULL,'',0),(2267,3,736,'2014-02-13 14:00:00','2014-02-13 15:00:00',4,NULL,'PSG',0),(2268,3,736,'2014-02-14 14:00:00','2014-02-14 14:30:00',2,NULL,'',0),(2269,3,676,'2014-01-23 11:00:00','2014-01-23 11:30:00',1,NULL,'',0),(2270,4,723,'2014-01-06 10:00:00','2014-01-06 10:30:00',1,NULL,'',0),(2271,3,38,'2014-02-07 09:30:00','2014-02-07 10:00:00',1,NULL,'',0),(2273,3,714,'2014-01-24 16:00:00','2014-01-24 17:00:00',4,NULL,'PSG',0),(2274,3,340,'2014-03-04 08:00:00','2014-03-04 08:30:00',1,NULL,'',0),(2275,4,794,'2013-12-24 09:30:00','2013-12-24 10:00:00',1,NULL,'',0),(2276,3,255,'2014-03-19 08:30:00','2014-03-19 09:00:00',1,NULL,'',0),(2277,3,522,'2014-03-19 08:00:00','2014-03-19 08:30:00',1,NULL,'',0),(2278,3,627,'2014-03-05 10:00:00','2014-03-05 10:30:00',1,NULL,'',0),(2279,3,744,'2014-01-09 15:30:00','2014-01-09 16:00:00',2,NULL,'',0),(2280,4,206,'2013-12-26 10:30:00','2013-12-26 11:00:00',1,NULL,'Donner résultat EFR',0),(2281,3,737,'2013-12-24 16:00:00','2013-12-24 16:30:00',1,NULL,'',0),(2282,3,737,'2014-01-16 14:00:00','2014-01-16 14:30:00',2,NULL,'',0),(2283,4,537,'2013-12-30 16:00:00','2013-12-30 16:30:00',1,NULL,'',0),(2284,4,536,'2013-12-30 16:30:00','2013-12-30 17:00:00',1,NULL,'',0),(2285,3,584,'2014-03-18 15:00:00','2014-03-18 15:30:00',2,NULL,'',0),(2286,4,797,'2013-12-19 09:00:00','2013-12-19 09:30:00',1,NULL,'',0),(2287,3,731,'2014-02-04 15:00:00','2014-02-04 16:00:00',3,NULL,'',0),(2288,3,731,'2014-02-05 11:00:00','2014-02-05 11:30:00',2,NULL,'',0),(2289,4,800,'2013-12-19 09:30:00','2013-12-19 10:00:00',1,NULL,'',0),(2290,4,801,'2013-12-19 09:45:00','2013-12-19 10:15:00',1,NULL,'',0),(2291,4,802,'2013-12-19 11:45:00','2013-12-19 12:15:00',1,NULL,'',0),(2292,4,213,'2014-01-09 11:30:00','2014-01-09 12:00:00',1,NULL,'',0),(2294,3,797,'2014-01-10 13:00:00','2014-01-10 13:30:00',2,NULL,'',0),(2296,3,797,'2014-03-24 16:00:00','2014-03-24 17:00:00',3,NULL,'',0),(2297,4,71,'2014-01-21 11:30:00','2014-01-21 12:00:00',2,NULL,'',0),(2298,3,800,'2013-12-26 11:00:00','2013-12-26 11:30:00',1,NULL,'',0),(2299,4,805,'2014-01-14 08:00:00','2014-01-14 08:30:00',1,NULL,'',0),(2300,3,801,'2013-12-26 11:15:00','2013-12-26 11:45:00',1,NULL,'',0),(2302,3,802,'2014-01-30 10:30:00','2014-01-30 11:00:00',2,NULL,'',0),(2303,3,672,'2014-03-05 08:00:00','2014-03-05 08:30:00',2,NULL,'',0),(2304,3,572,'2014-02-27 11:00:00','2014-02-27 11:30:00',2,NULL,'',0),(2306,3,758,'2014-02-05 14:30:00','2014-02-05 15:00:00',2,NULL,'',0),(2307,3,161,'2014-01-06 15:30:00','2014-01-06 16:00:00',1,NULL,'',0),(2308,3,711,'2014-01-17 14:30:00','2014-01-17 15:00:00',1,NULL,'',0),(2309,3,806,'2013-12-23 16:30:00','2013-12-23 17:00:00',1,NULL,'',0),(2310,3,807,'2014-02-11 11:00:00','2014-02-11 11:30:00',2,NULL,'',0),(2311,3,807,'2014-02-14 16:00:00','2014-02-14 17:00:00',4,NULL,'PSG',0),(2312,3,807,'2013-12-19 16:00:00','2013-12-19 16:30:00',1,NULL,'',0),(2313,4,808,'2014-01-13 15:00:00','2014-01-13 15:30:00',1,NULL,'',0),(2314,4,334,'2013-12-26 14:30:00','2013-12-26 15:00:00',1,NULL,'',0),(2315,3,761,'2014-02-27 14:00:00','2014-02-27 15:00:00',3,NULL,'',0),(2316,3,761,'2014-02-28 14:00:00','2014-02-28 14:30:00',2,NULL,'',0),(2318,3,357,'2013-12-27 15:45:00','2013-12-27 16:15:00',1,NULL,'SOS -Oxg\r\nA tel le 24 : \"je suis claustrophobe je ne supporte pas l appareil',0),(2319,3,810,'2014-01-14 14:30:00','2014-01-14 15:00:00',2,NULL,'',0),(2320,3,810,'2014-02-18 15:00:00','2014-02-18 16:00:00',3,NULL,'',0),(2321,3,767,'2014-02-06 08:00:00','2014-02-06 08:30:00',2,NULL,'',0),(2322,3,767,'2014-03-20 16:00:00','2014-03-20 17:00:00',4,NULL,'PSG',0),(2323,3,122,'2014-03-11 08:30:00','2014-03-11 09:00:00',2,NULL,'',0),(2324,3,811,'2013-12-26 15:30:00','2013-12-26 16:00:00',1,NULL,'',0),(2326,3,814,'2013-12-27 16:00:00','2013-12-27 16:30:00',1,NULL,'',0),(2327,3,319,'2014-02-19 08:30:00','2014-02-19 09:00:00',2,NULL,'',0),(2328,3,815,'2014-01-10 19:00:00','2014-01-10 20:00:00',3,NULL,'',0),(2329,3,221,'2014-02-20 14:00:00','2014-02-20 14:30:00',2,NULL,'',0),(2330,4,595,'2013-12-26 08:00:00','2013-12-26 08:30:00',1,NULL,'',0),(2331,4,2,'2013-12-24 16:30:00','2013-12-24 17:00:00',1,NULL,'',0),(2332,3,29,'2014-02-19 14:00:00','2014-02-19 14:30:00',1,NULL,'',0),(2333,4,817,'2013-12-26 10:15:00','2013-12-26 10:45:00',1,NULL,'',0),(2334,3,417,'2014-02-20 08:15:00','2014-02-20 08:45:00',2,NULL,'',0),(2335,3,575,'2014-01-08 11:30:00','2014-01-08 12:00:00',1,NULL,'',0),(2337,3,794,'2014-01-28 14:00:00','2014-01-28 14:30:00',2,NULL,'',0),(2338,3,818,'2014-01-22 09:00:00','2014-01-22 09:30:00',2,NULL,'',0),(2339,3,818,'2014-01-10 17:00:00','2014-01-10 18:00:00',3,NULL,'',0),(2340,3,820,'2013-12-26 16:15:00','2013-12-26 16:45:00',1,NULL,'',0),(2341,3,821,'2013-12-24 16:30:00','2013-12-24 17:00:00',1,NULL,'',0),(2342,3,547,'2014-03-19 11:00:00','2014-03-19 11:30:00',1,NULL,'',0),(2343,3,167,'2014-02-18 10:30:00','2014-02-18 11:00:00',2,NULL,'',0),(2344,3,683,'2014-02-20 09:00:00','2014-02-20 09:30:00',2,NULL,'',0),(2345,3,683,'2014-03-25 14:00:00','2014-03-25 15:00:00',3,NULL,'',0),(2346,3,217,'2014-02-19 14:00:00','2014-02-19 14:30:00',2,NULL,'',0),(2347,3,658,'2014-01-24 14:00:00','2014-01-24 14:30:00',1,NULL,'',0),(2348,3,542,'2014-02-24 17:30:00','2014-02-24 18:00:00',2,NULL,'',0),(2349,3,821,'2014-01-16 08:00:00','2014-01-16 08:30:00',1,NULL,'Prévoir EFR',0),(2350,3,113,'2013-12-30 16:30:00','2013-12-30 17:00:00',1,NULL,'',0),(2351,3,158,'2013-12-27 15:15:00','2013-12-27 15:45:00',1,NULL,'',0),(2352,3,595,'2014-02-28 16:00:00','2014-02-28 16:30:00',2,NULL,'',0),(2353,3,822,'2014-01-06 16:00:00','2014-01-06 16:30:00',1,NULL,'Expert Jeun Sports',0),(2354,4,809,'2013-12-26 09:45:00','2013-12-26 10:15:00',1,NULL,'',0),(2355,3,768,'2014-02-26 10:00:00','2014-02-26 10:30:00',2,NULL,'',0),(2356,3,768,'2014-03-04 16:00:00','2014-03-04 17:00:00',4,NULL,'PSG',0),(2357,4,133,'2013-12-30 17:00:00','2013-12-30 17:30:00',1,NULL,'',0),(2358,3,529,'2014-01-28 10:00:00','2014-01-28 10:30:00',1,NULL,'',0),(2359,3,809,'2014-02-27 10:00:00','2014-02-27 10:30:00',2,NULL,'',0),(2360,3,817,'2014-02-19 09:30:00','2014-02-19 10:00:00',2,NULL,'',0),(2361,3,823,'2014-02-19 09:00:00','2014-02-19 09:30:00',2,NULL,'',0),(2363,3,800,'2014-01-22 14:00:00','2014-01-22 14:30:00',1,NULL,'',0),(2364,3,801,'2014-01-22 14:00:00','2014-01-22 14:30:00',1,NULL,'',0),(2365,3,334,'2014-03-31 14:00:00','2014-03-31 15:00:00',3,NULL,'',0),(2366,4,813,'2014-01-16 14:00:00','2014-01-16 14:30:00',1,NULL,'',0),(2367,3,2,'2014-01-21 14:00:00','2014-01-21 14:30:00',1,NULL,'Ne peux venir, toujours hospitalisé',0),(2368,3,820,'2014-01-14 16:15:00','2014-01-14 16:45:00',1,NULL,'Prévoir EFR',0),(2369,3,484,'2014-03-07 14:00:00','2014-03-07 14:30:00',2,NULL,'',0),(2370,3,814,'2014-02-07 14:00:00','2014-02-07 14:30:00',2,NULL,'',0),(2371,3,814,'2014-03-06 14:30:00','2014-03-06 15:30:00',3,NULL,'',0),(2372,3,158,'2014-02-25 08:30:00','2014-02-25 09:00:00',2,NULL,'',0),(2373,3,386,'2014-01-21 14:00:00','2014-01-21 14:30:00',2,NULL,'Prévoir TDM thrx',0),(2374,3,357,'2014-01-07 14:15:00','2014-01-07 14:45:00',1,NULL,'',0),(2375,3,357,'2014-02-21 14:30:00','2014-02-21 15:00:00',2,NULL,'',0),(2376,3,825,'2013-12-30 17:15:00','2013-12-30 17:45:00',1,NULL,'',0),(2377,3,826,'2014-02-25 15:00:00','2014-02-25 16:00:00',5,NULL,'',0),(2378,3,826,'2014-03-04 15:00:00','2014-03-04 16:00:00',5,NULL,'',0),(2379,3,826,'2014-03-11 15:00:00','2014-03-11 16:00:00',5,NULL,'',0),(2380,3,826,'2014-03-18 15:00:00','2014-03-18 16:00:00',5,NULL,'',0),(2381,3,826,'2014-03-25 15:00:00','2014-03-25 18:00:00',5,NULL,'',0),(2382,3,826,'2014-04-01 15:00:00','2014-04-01 16:00:00',5,NULL,'',0),(2383,3,141,'2014-02-25 14:00:00','2014-02-25 14:30:00',2,NULL,'',0),(2384,3,406,'2014-01-15 14:00:00','2014-01-15 15:00:00',5,NULL,'Regler app de PPC ou passer BIPAP',0),(2386,3,113,'2014-02-21 15:00:00','2014-02-21 15:30:00',2,NULL,'',0),(2388,3,537,'2014-03-06 15:30:00','2014-03-06 16:00:00',2,NULL,'',0),(2389,3,536,'2014-03-06 15:00:00','2014-03-06 15:30:00',2,NULL,'',0),(2390,4,832,'2014-01-06 16:30:00','2014-01-06 17:00:00',1,NULL,'S\' endort au volant.',0),(2391,4,227,'2014-01-13 15:15:00','2014-01-13 15:45:00',1,NULL,'',0),(2392,3,456,'2014-01-06 13:30:00','2014-01-06 14:00:00',1,NULL,'',0),(2393,4,213,'2013-12-09 11:30:00','2013-12-09 12:00:00',1,NULL,'',0),(2394,4,656,'2014-01-22 14:30:00','2014-01-22 15:00:00',1,NULL,'',0),(2395,3,238,'2014-03-06 08:15:00','2014-03-06 08:45:00',2,NULL,'',0),(2396,4,667,'2014-01-15 15:00:00','2014-01-15 15:30:00',1,NULL,'',0),(2397,4,136,'2014-01-06 11:30:00','2014-01-06 12:00:00',1,NULL,'',0),(2398,4,405,'2014-01-17 14:00:00','2014-01-17 14:30:00',1,NULL,'',0),(2399,3,177,'2014-02-25 10:00:00','2014-02-25 10:30:00',2,NULL,'',0),(2400,4,758,'2014-01-14 15:00:00','2014-01-14 15:30:00',1,NULL,'',0),(2401,3,456,'2014-01-08 08:00:00','2014-01-08 08:30:00',1,NULL,'',0),(2402,3,456,'2014-05-19 09:00:00','2014-05-19 09:30:00',2,NULL,'',0),(2403,3,100,'2014-02-24 15:00:00','2014-02-24 15:30:00',2,NULL,'',0),(2404,3,161,'2014-01-13 14:30:00','2014-01-13 15:00:00',1,NULL,'',0),(2405,4,96,'2014-02-04 09:00:00','2014-02-04 09:30:00',1,NULL,'',0),(2406,3,822,'2014-01-21 15:00:00','2014-01-21 15:30:00',2,NULL,'Compter Expertise :\r\nC2+EFR+DLCO',0),(2407,3,832,'2014-03-27 16:30:00','2014-03-27 17:30:00',3,NULL,'',0),(2408,3,832,'2014-03-07 16:15:00','2014-03-07 16:45:00',2,NULL,'',0),(2409,4,829,'2014-01-15 10:00:00','2014-01-15 10:30:00',1,NULL,'',0),(2410,3,61,'2014-03-17 08:00:00','2014-03-17 08:30:00',1,NULL,'',0),(2411,3,430,'2014-02-12 09:00:00','2014-02-12 09:30:00',2,NULL,'',0),(2412,3,57,'2014-04-08 09:00:00','2014-04-08 09:30:00',1,NULL,'',0),(2413,3,363,'2014-06-02 10:00:00','2014-06-02 10:30:00',2,NULL,'',0),(2414,3,218,'2014-03-20 08:00:00','2014-03-20 08:30:00',1,NULL,'',0),(2415,3,190,'2014-03-05 09:00:00','2014-03-05 09:30:00',2,NULL,'',0),(2416,3,336,'2014-04-07 10:00:00','2014-04-07 10:30:00',1,NULL,'',0),(2417,4,840,'2014-01-16 15:00:00','2014-01-16 15:30:00',1,NULL,'De la part de Mr Blanc',0),(2418,4,174,'2014-01-16 14:30:00','2014-01-16 15:00:00',1,NULL,'Prévoir nouveau tdm THRX',0),(2419,3,548,'2014-03-12 14:00:00','2014-03-12 14:30:00',2,NULL,'',0),(2421,4,841,'2014-01-17 15:30:00','2014-01-17 16:00:00',1,NULL,'',0),(2422,4,842,'2014-01-08 17:00:00','2014-01-08 17:30:00',1,NULL,'',0),(2423,3,467,'2014-01-24 14:30:00','2014-01-24 15:00:00',1,NULL,'',0),(2424,4,253,'2014-01-07 16:00:00','2014-01-07 16:30:00',1,NULL,'',0),(2425,2,426,'2014-04-02 16:00:00','2014-04-02 17:00:00',3,NULL,'PSG\r\nRamènera l\'appareil le lendemain APRES-MIDI',0),(2426,4,719,'2014-01-07 15:00:00','2014-01-07 15:30:00',1,NULL,'',0),(2427,3,37,'2014-02-20 14:00:00','2014-02-20 14:30:00',2,NULL,'',0),(2428,3,719,'2014-03-05 14:30:00','2014-03-05 15:00:00',1,NULL,'',0),(2429,3,282,'2014-02-19 10:00:00','2014-02-19 10:30:00',1,NULL,'',0),(2430,4,333,'2014-01-08 09:30:00','2014-01-08 10:00:00',1,NULL,'recupere un papier',0),(2431,3,456,'2014-01-10 10:30:00','2014-01-10 11:00:00',1,NULL,'',0),(2432,3,280,'2014-01-23 11:30:00','2014-01-23 12:00:00',2,NULL,'',0),(2433,3,135,'2014-03-18 09:00:00','2014-03-18 09:30:00',1,NULL,'',0),(2435,3,45,'2014-03-05 08:30:00','2014-03-05 09:00:00',1,NULL,'',0),(2436,3,45,'2014-04-03 08:00:00','2014-04-03 08:30:00',2,NULL,'',0),(2437,2,45,'2014-04-07 16:00:00','2014-04-07 17:00:00',3,NULL,'PV',0),(2438,3,844,'2014-01-28 10:30:00','2014-01-28 11:00:00',1,NULL,'',0),(2439,3,218,'2014-02-06 08:30:00','2014-02-06 09:00:00',1,NULL,'',0),(2440,3,72,'2014-04-09 10:00:00','2014-04-09 10:30:00',2,NULL,'Nous avons faxé ordonnance aérosol au 0262463383',0),(2441,4,848,'2014-01-23 11:30:00','2014-01-23 12:00:00',1,NULL,'',0),(2442,2,270,'2014-04-08 14:00:00','2014-04-08 15:00:00',3,NULL,'PV',0),(2443,2,331,'2014-04-09 16:00:00','2014-04-09 17:00:00',3,NULL,'PV',0),(2444,3,46,'2014-03-04 09:00:00','2014-03-04 09:30:00',1,NULL,'',0),(2446,3,575,'2014-02-20 08:00:00','2014-02-20 08:30:00',1,NULL,'',0),(2448,3,198,'2014-02-06 09:30:00','2014-02-06 10:00:00',1,NULL,'',0),(2449,3,123,'2014-04-02 14:00:00','2014-04-02 14:30:00',2,NULL,'',0),(2450,2,48,'2014-02-06 15:45:00','2014-02-06 16:45:00',3,NULL,'PV',0),(2451,3,120,'2014-03-04 14:30:00','2014-03-04 15:00:00',1,NULL,'',0),(2452,3,298,'2014-03-06 14:00:00','2014-03-06 14:30:00',2,NULL,'',0),(2453,3,298,'2014-01-29 14:00:00','2014-01-29 14:30:00',1,NULL,'',0),(2455,4,206,'2014-01-24 15:00:00','2014-01-24 15:30:00',1,NULL,'rapportera sa carte vitale pour le 26 dec',0),(2456,3,842,'2014-01-13 14:00:00','2014-01-13 14:30:00',2,NULL,'',0),(2457,3,842,'2014-04-03 16:00:00','2014-04-03 17:00:00',3,NULL,'',0),(2458,3,63,'2014-03-26 15:30:00','2014-03-26 16:00:00',2,NULL,'',0),(2459,2,63,'2014-04-10 16:00:00','2014-04-10 17:00:00',3,NULL,'PV',0),(2460,4,618,'2014-01-14 15:30:00','2014-01-14 16:00:00',1,NULL,'',0),(2461,3,235,'2014-02-12 10:00:00','2014-02-12 10:30:00',2,NULL,'',0),(2462,3,609,'2014-02-20 10:00:00','2014-02-20 10:30:00',2,NULL,'',0),(2463,3,176,'2014-02-06 08:00:00','2014-02-06 08:30:00',1,NULL,'',0),(2464,3,414,'2014-03-12 09:00:00','2014-03-12 09:30:00',2,NULL,'',0),(2465,3,220,'2014-03-03 14:00:00','2014-03-03 14:30:00',1,NULL,'',0),(2466,4,612,'2014-01-22 15:00:00','2014-01-22 15:30:00',1,NULL,'',0),(2467,4,675,'2014-01-09 11:00:00','2014-01-09 11:30:00',1,NULL,'',0),(2468,3,332,'2014-03-13 09:00:00','2014-03-13 09:30:00',2,NULL,'',0),(2469,3,30,'2014-02-14 15:00:00','2014-02-14 15:30:00',1,NULL,'',0),(2470,3,213,'2014-03-12 09:00:00','2014-03-12 09:30:00',2,NULL,'',0),(2471,3,165,'2014-03-06 08:30:00','2014-03-06 09:00:00',1,NULL,'',0),(2472,3,162,'2014-03-05 10:00:00','2014-03-05 10:30:00',2,NULL,'',0),(2473,3,371,'2014-03-06 09:00:00','2014-03-06 09:30:00',1,NULL,'',0),(2474,3,852,'2014-01-13 16:00:00','2014-01-13 16:30:00',1,NULL,'',0),(2475,3,853,'2014-07-18 08:00:00','2014-07-18 09:00:00',5,NULL,'',0),(2476,3,854,'2014-02-10 14:00:00','2014-02-10 14:30:00',1,NULL,'',0),(2477,3,744,'2014-03-20 08:30:00','2014-03-20 09:00:00',1,NULL,'',0),(2478,3,230,'2014-03-13 09:30:00','2014-03-13 10:00:00',2,NULL,'',0),(2479,4,115,'2014-01-24 16:30:00','2014-01-24 17:00:00',2,NULL,'Recherche d\'une bronchoréactivité',0),(2480,4,678,'2014-02-07 08:00:00','2014-02-07 09:00:00',1,NULL,'',0),(2481,3,797,'2014-01-15 11:30:00','2014-01-15 12:00:00',1,NULL,'CRF Dr BLANC',0),(2482,3,665,'2014-05-09 14:00:00','2014-05-09 14:30:00',2,NULL,'',0),(2483,3,601,'2014-03-17 14:00:00','2014-03-17 14:30:00',2,NULL,'',0),(2484,4,148,'2014-01-16 11:30:00','2014-01-16 12:00:00',1,NULL,'',0),(2485,4,236,'2014-03-18 09:00:00','2014-03-18 09:30:00',1,NULL,'',0),(2487,3,403,'2014-01-24 14:30:00','2014-01-24 15:00:00',2,NULL,'',0),(2488,3,403,'2014-02-14 14:30:00','2014-02-14 15:00:00',1,NULL,'',0),(2489,3,815,'2014-01-23 18:00:00','2014-01-23 18:30:00',1,NULL,'',0),(2490,3,170,'2014-01-14 10:00:00','2014-01-14 10:30:00',2,NULL,'',0),(2491,2,156,'2014-04-14 16:00:00','2014-04-14 17:00:00',3,NULL,'PV',0),(2492,2,31,'2014-01-20 14:30:00','2014-01-20 15:00:00',1,NULL,'',0),(2493,3,138,'2014-03-24 10:00:00','2014-03-24 10:30:00',1,NULL,'',0),(2494,3,47,'2014-02-07 15:00:00','2014-02-07 15:30:00',1,NULL,'',0),(2495,3,243,'2014-01-29 11:00:00','2014-01-29 11:30:00',2,NULL,'',0),(2496,3,161,'2014-01-16 15:30:00','2014-01-16 16:00:00',1,NULL,'',0),(2497,3,227,'2014-05-05 14:00:00','2014-05-05 14:30:00',2,NULL,'',0),(2498,2,852,'2014-01-14 09:00:00','2014-01-14 09:30:00',2,NULL,'',0),(2499,4,855,'2014-01-21 14:00:00','2014-01-21 14:30:00',1,NULL,'',0),(2500,2,506,'2014-02-10 14:30:00','2014-02-10 15:00:00',1,NULL,'résultat PSG',0),(2501,3,326,'2014-03-11 09:00:00','2014-03-11 09:30:00',2,NULL,'',0),(2502,4,787,'2014-01-14 09:30:00','2014-01-14 10:00:00',1,NULL,'',0),(2503,3,192,'2014-03-25 09:00:00','2014-03-25 09:30:00',1,NULL,'',0),(2504,2,192,'2014-04-15 16:00:00','2014-04-15 17:00:00',3,NULL,'PV',0),(2505,2,787,'2014-01-23 10:30:00','2014-01-23 11:00:00',2,NULL,'expliquer comment remplir un agenda de sommeil',0),(2506,2,787,'2014-04-16 16:00:00','2014-04-16 17:00:00',3,NULL,'PV',0),(2509,2,455,'2014-04-22 16:00:00','2014-04-22 17:00:00',3,NULL,'PV',0),(2510,3,99,'2014-02-03 16:30:00','2014-02-03 17:00:00',1,NULL,'',0),(2511,3,136,'2014-03-03 09:00:00','2014-03-03 09:30:00',1,NULL,'',0),(2512,2,170,'2014-04-23 16:00:00','2014-04-23 17:00:00',3,NULL,'PV',0),(2513,4,260,'2014-01-16 16:00:00','2014-01-16 16:30:00',2,NULL,'',0),(2514,4,628,'2014-01-15 16:00:00','2014-01-15 16:30:00',1,NULL,'',0),(2515,3,79,'2014-04-08 08:30:00','2014-04-08 09:00:00',2,NULL,'',0),(2517,3,207,'2014-03-06 09:00:00','2014-03-06 09:30:00',2,NULL,'',0),(2518,4,119,'2014-01-27 11:00:00','2014-01-27 11:30:00',2,NULL,'N a pas ses papiers à jour. ',0),(2519,3,857,'2014-01-16 17:00:00','2014-01-16 17:30:00',1,NULL,'',0),(2520,2,763,'2014-01-14 14:00:00','2014-01-14 14:30:00',2,NULL,'',0),(2522,2,495,'2014-01-23 17:30:00','2014-01-23 18:00:00',1,NULL,'',0),(2523,3,128,'2014-03-24 09:00:00','2014-03-24 09:30:00',1,NULL,'',0),(2524,3,618,'2014-03-19 15:30:00','2014-03-19 16:00:00',2,NULL,'',0),(2525,3,820,'2014-03-26 16:00:00','2014-03-26 16:30:00',2,NULL,'',0),(2526,4,5,'2014-01-24 16:00:00','2014-01-24 16:30:00',1,NULL,'',0),(2527,3,416,'2014-02-10 15:00:00','2014-02-10 15:30:00',1,NULL,'résultat PSG',0),(2528,3,654,'2014-04-09 08:30:00','2014-04-09 09:00:00',2,NULL,'',0),(2529,3,439,'2014-03-10 08:30:00','2014-03-10 09:00:00',2,NULL,'',0),(2530,3,357,'2014-01-17 13:30:00','2014-01-17 14:00:00',1,NULL,'',0),(2531,2,858,'2014-01-23 14:30:00','2014-01-23 15:00:00',1,NULL,'Adressé par le Dr. De Granpré. A déjà eu une polygraphie ventilatoire, a besoin d\'une polysomnographie.',0),(2532,4,392,'2014-02-06 10:00:00','2014-02-06 10:30:00',2,NULL,'',0),(2533,2,858,'2014-01-28 16:30:00','2014-01-28 17:30:00',4,NULL,'PSG',0),(2534,3,175,'2014-03-19 09:00:00','2014-03-19 09:30:00',1,NULL,'',0),(2536,2,829,'2014-01-28 10:30:00','2014-01-28 11:00:00',2,NULL,'',0),(2537,4,82,'2014-01-29 10:00:00','2014-01-29 10:30:00',1,NULL,'',0),(2538,3,479,'2014-04-07 09:30:00','2014-04-07 10:00:00',2,NULL,'',0),(2540,3,797,'2014-01-27 10:30:00','2014-01-27 11:00:00',1,NULL,'',0),(2541,3,530,'2014-03-10 09:30:00','2014-03-10 10:00:00',2,NULL,'',0),(2542,4,637,'2014-01-23 16:30:00','2014-01-23 17:00:00',1,NULL,'',0),(2543,3,613,'2014-03-03 10:00:00','2014-03-03 10:30:00',1,NULL,'',0),(2544,4,84,'2014-01-29 11:00:00','2014-01-29 11:30:00',2,NULL,'',0),(2545,3,406,'2014-01-24 13:30:00','2014-01-24 14:30:00',5,NULL,'Mise en route VNI ou réglage PPC',0),(2546,3,103,'2014-03-04 10:00:00','2014-03-04 10:30:00',1,NULL,'',0),(2547,3,774,'2014-03-05 14:00:00','2014-03-05 14:30:00',1,NULL,'',0),(2548,3,42,'2014-03-13 10:00:00','2014-03-13 10:30:00',1,NULL,'',0),(2549,4,162,'2014-01-28 08:30:00','2014-01-28 09:00:00',1,NULL,'Résultat PV',0),(2550,3,628,'2014-03-19 14:00:00','2014-03-19 14:30:00',2,NULL,'',0),(2551,4,864,'2014-01-17 11:30:00','2014-01-17 12:00:00',2,NULL,'',0),(2552,2,865,'2014-01-30 11:00:00','2014-01-30 11:30:00',2,NULL,'',0),(2553,2,866,'2014-01-27 09:00:00','2014-01-27 09:30:00',1,NULL,'a eu un ENR',0),(2554,2,866,'2014-02-13 11:00:00','2014-02-13 11:30:00',2,NULL,'',0),(2555,4,868,'2014-01-27 08:00:00','2014-01-27 08:30:00',1,NULL,'POUR UNE PSG',0),(2556,4,868,'2014-01-31 14:30:00','2014-01-31 15:00:00',2,NULL,'',0),(2557,3,821,'2014-01-27 08:30:00','2014-01-27 09:00:00',2,NULL,'',0),(2558,4,432,'2014-01-23 15:00:00','2014-01-23 15:30:00',1,NULL,'Contactez Dr DARGAI FAGOUK (N° TEL 069226 76 96',0),(2559,3,634,'2014-03-18 08:30:00','2014-03-18 09:00:00',1,NULL,'',0),(2560,2,81,'2014-04-17 16:00:00','2014-04-17 17:00:00',4,NULL,'PSG',0),(2561,3,93,'2014-03-18 09:30:00','2014-03-18 10:00:00',1,NULL,'',0),(2562,3,148,'2014-02-18 11:00:00','2014-02-18 11:30:00',1,NULL,'',0),(2563,3,278,'2014-03-17 11:00:00','2014-03-17 11:30:00',2,NULL,'',0),(2564,4,30,'2014-01-16 14:00:00','2014-01-16 14:30:00',1,NULL,'Montrer les resultats',0),(2565,3,155,'2014-03-24 10:30:00','2014-03-24 11:00:00',1,NULL,'',0),(2566,3,813,'2014-02-25 11:00:00','2014-02-25 11:30:00',2,NULL,'',0),(2567,3,813,'2014-04-21 16:00:00','2014-04-21 17:00:00',3,NULL,'PV',0),(2568,3,737,'2014-02-19 14:00:00','2014-02-19 15:00:00',1,NULL,'',0),(2569,3,174,'2014-03-04 11:30:00','2014-03-04 12:00:00',2,NULL,'',0),(2570,3,161,'2014-02-19 15:00:00','2014-02-19 15:30:00',1,NULL,'',0),(2571,2,840,'2014-02-26 09:00:00','2014-02-26 09:30:00',2,NULL,'',0),(2572,2,840,'2014-04-24 16:00:00','2014-04-24 17:00:00',3,NULL,'PV',0),(2574,4,871,'2014-01-17 13:00:00','2014-01-17 14:00:00',5,NULL,'si rapport du sac apparei sommeil  n\'est pas là avant 13 h pour Mme Laravine',0),(2575,4,872,'2014-01-17 17:30:00','2014-01-17 18:00:00',1,NULL,'ASTHME',0),(2576,3,857,'2014-03-05 11:00:00','2014-03-05 11:30:00',2,NULL,'',0),(2577,3,857,'2014-03-26 14:00:00','2014-03-26 15:00:00',3,NULL,'',0),(2578,4,552,'2014-02-06 11:00:00','2014-02-06 11:30:00',2,NULL,'',0),(2579,3,557,'2014-02-06 11:30:00','2014-02-06 12:00:00',1,NULL,'',0),(2580,3,405,'2014-04-08 09:00:00','2014-04-08 09:30:00',2,NULL,'',0),(2581,3,369,'2014-05-02 14:00:00','2014-05-02 14:30:00',1,NULL,'',0),(2582,2,841,'2014-02-27 09:00:00','2014-02-27 09:30:00',2,NULL,'Faire agenda de sommeil',0),(2583,2,841,'2014-04-28 16:00:00','2014-04-28 17:00:00',3,NULL,'PV',0),(2584,4,765,'2014-01-17 15:00:00','2014-01-17 15:30:00',1,NULL,'',0),(2585,3,729,'2014-01-27 10:30:00','2014-01-27 11:00:00',2,NULL,'',0),(2586,3,872,'2014-01-24 17:00:00','2014-01-24 17:30:00',2,NULL,'',0),(2587,2,875,'2014-01-23 15:30:00','2014-01-23 16:00:00',1,NULL,'',0),(2588,3,874,'2014-01-27 09:00:00','2014-01-27 09:30:00',2,NULL,'',0),(2589,3,31,'2014-03-25 08:30:00','2014-03-25 09:00:00',2,NULL,'',0),(2590,3,201,'2014-03-25 09:30:00','2014-03-25 10:00:00',2,NULL,'',0),(2591,4,203,'2014-02-06 15:00:00','2014-02-06 15:30:00',1,NULL,'resultat de l efr',0),(2592,3,197,'2014-03-03 08:30:00','2014-03-03 09:00:00',1,NULL,'',0),(2594,3,52,'2014-04-28 08:30:00','2014-04-28 09:00:00',1,NULL,'',0),(2595,3,281,'2014-03-18 14:00:00','2014-03-18 14:30:00',2,NULL,'',0),(2596,3,766,'2014-03-27 09:00:00','2014-03-27 09:30:00',1,NULL,'',0),(2597,3,472,'2014-04-07 10:00:00','2014-04-07 10:30:00',2,NULL,'',0),(2598,3,71,'2014-04-07 11:00:00','2014-04-07 11:30:00',1,NULL,'',0),(2599,3,855,'2014-02-03 15:00:00','2014-02-03 15:30:00',2,NULL,'',0),(2600,3,855,'2014-02-07 15:30:00','2014-02-07 16:00:00',1,NULL,'',0),(2601,2,855,'2014-04-29 16:00:00','2014-04-29 17:00:00',3,NULL,'PV',0),(2602,3,386,'2014-01-27 14:00:00','2014-01-27 14:30:00',1,NULL,'',0),(2603,3,822,'2014-01-27 15:00:00','2014-01-27 15:30:00',1,NULL,'',0),(2604,4,485,'2014-01-22 09:45:00','2014-01-22 10:15:00',1,NULL,'ordonnance sérétide et renouvellement oxygène',0),(2605,3,883,'2014-01-28 15:00:00','2014-01-28 15:30:00',1,NULL,'',0),(2606,2,54,'2014-02-03 14:30:00','2014-02-03 15:00:00',1,NULL,'résultat PSG',0),(2607,4,482,'2014-01-23 10:30:00','2014-01-23 11:00:00',1,NULL,'prevoir EFR de surveillance',0),(2608,3,237,'2014-02-27 09:30:00','2014-02-27 10:00:00',1,NULL,'',0),(2609,3,485,'2014-02-11 14:30:00','2014-02-11 15:00:00',1,NULL,'',0),(2610,3,129,'2014-03-03 09:00:00','2014-03-03 09:30:00',1,NULL,'',0),(2611,2,818,'2014-02-12 16:30:00','2014-02-12 17:30:00',4,NULL,'PSG',0),(2612,3,159,'2014-03-06 10:00:00','2014-03-06 10:30:00',1,NULL,'',0),(2613,3,773,'2014-02-13 10:30:00','2014-02-13 11:00:00',2,NULL,'rappellera pour prendre rendez-rous pour PV',0),(2615,3,489,'2014-01-28 14:30:00','2014-01-28 15:00:00',1,NULL,'',0),(2616,3,801,'2014-03-20 10:30:00','2014-03-20 10:40:00',1,NULL,'',0),(2617,3,800,'2014-03-12 10:45:00','2014-03-12 11:00:00',1,NULL,'',0),(2618,3,656,'2014-03-24 09:30:00','2014-03-24 10:00:00',1,NULL,'',0),(2619,3,885,'2014-01-23 16:00:00','2014-01-23 16:30:00',1,NULL,'',0),(2620,3,612,'2014-05-05 16:00:00','2014-05-05 17:00:00',3,NULL,'PV',0),(2622,3,705,'2014-03-06 09:30:00','2014-03-06 10:00:00',1,NULL,'',0),(2623,3,35,'2014-02-25 09:00:00','2014-02-25 09:30:00',1,NULL,'',0),(2624,4,30,'2014-01-24 14:00:00','2014-01-24 14:30:00',1,NULL,'',0),(2625,3,261,'2014-03-12 10:00:00','2014-03-12 10:30:00',2,NULL,'',0),(2626,3,460,'2014-03-03 10:30:00','2014-03-03 11:00:00',1,NULL,'',0),(2627,4,886,'2014-01-28 11:30:00','2014-01-28 12:00:00',1,NULL,'bpco \r\nvient du chu',0),(2628,3,482,'2014-03-24 08:30:00','2014-03-24 09:00:00',2,NULL,'',0),(2629,3,154,'2014-02-04 08:00:00','2014-02-04 08:30:00',1,NULL,'',0),(2630,4,880,'2014-02-12 10:30:00','2014-02-12 11:00:00',1,NULL,'apnee\r\nc2',0),(2631,2,848,'2014-02-04 09:00:00','2014-02-04 09:30:00',2,NULL,'',0),(2632,2,848,'2014-04-15 16:30:00','2014-04-15 17:30:00',3,NULL,'PV',0),(2633,3,280,'2014-03-03 11:00:00','2014-03-03 11:30:00',1,NULL,'',0),(2634,2,887,'2014-01-24 17:30:00','2014-01-24 18:00:00',2,NULL,'',0),(2635,2,887,'2014-01-23 12:00:00','2014-01-23 12:30:00',1,NULL,'',0),(2636,2,858,'2014-01-27 10:00:00','2014-01-27 10:30:00',2,NULL,'',0),(2637,2,432,'2014-02-04 10:00:00','2014-02-04 10:30:00',2,NULL,'',0),(2638,3,875,'2014-02-10 11:00:00','2014-02-10 11:30:00',2,NULL,'',0),(2639,3,637,'2014-03-10 10:00:00','2014-03-10 10:30:00',2,NULL,'',0),(2640,3,885,'2014-02-07 15:00:00','2014-02-07 15:30:00',2,NULL,'',0),(2641,2,562,'2014-02-10 15:30:00','2014-02-10 16:00:00',1,NULL,'résultat PSG',0),(2642,2,815,'2014-02-21 18:30:00','2014-02-21 19:30:00',4,NULL,'PSG',0),(2643,3,495,'2014-03-07 14:30:00','2014-03-07 15:00:00',2,NULL,'',0),(2644,4,889,'2014-01-24 13:30:00','2014-01-24 14:00:00',1,NULL,'',0),(2645,4,890,'2014-01-28 09:30:00','2014-01-28 10:00:00',1,NULL,'Asthmatique',0),(2646,2,889,'2014-01-31 14:00:00','2014-01-31 14:30:00',2,NULL,'',0),(2647,3,889,'2014-02-04 14:30:00','2014-02-04 15:00:00',1,NULL,'',0),(2648,2,406,'2014-02-07 09:00:00','2014-02-07 09:30:00',1,NULL,'',0),(2649,3,357,'2014-01-27 14:30:00','2014-01-27 15:00:00',1,NULL,'',0),(2650,3,30,'2014-03-05 15:00:00','2014-03-05 15:30:00',1,NULL,'',0),(2651,3,658,'2014-01-28 13:30:00','2014-01-28 14:00:00',1,NULL,'SOS Oxyg',0),(2652,4,895,'2014-01-29 14:30:00','2014-01-29 15:00:00',1,NULL,'',0),(2654,3,206,'2014-03-12 10:30:00','2014-03-12 11:00:00',2,NULL,'',0),(2656,3,5,'2014-03-28 14:00:00','2014-03-28 14:30:00',2,NULL,'',0),(2657,3,872,'2014-03-28 17:30:00','2014-03-28 18:00:00',1,NULL,'',0),(2658,3,714,'2014-02-07 16:00:00','2014-02-07 16:30:00',1,NULL,'',0),(2659,3,887,'2014-03-06 11:30:00','2014-03-06 12:00:00',2,NULL,'',0),(2660,2,826,'2014-02-07 11:00:00','2014-02-07 11:30:00',5,NULL,'Prédication B. J. avec le surveillant',0),(2662,2,868,'2014-02-10 17:30:00','2014-02-10 18:30:00',4,NULL,'PSG',0),(2663,4,333,'2014-01-29 08:30:00','2014-01-29 09:00:00',1,NULL,'',0),(2664,4,459,'2014-02-06 11:30:00','2014-02-06 12:00:00',1,NULL,'',0),(2665,2,874,'2014-01-20 08:00:00','2014-01-20 08:30:00',1,NULL,'',0),(2666,2,898,'2014-01-28 08:00:00','2014-01-28 08:30:00',1,NULL,'',0),(2668,3,821,'2014-02-24 08:00:00','2014-02-24 08:30:00',1,NULL,'',0),(2669,3,166,'2014-03-17 10:00:00','2014-03-17 10:30:00',2,NULL,'',0),(2670,3,98,'2014-03-27 08:30:00','2014-03-27 09:00:00',2,NULL,'',0),(2671,2,866,'2014-02-20 16:30:00','2014-02-20 17:30:00',4,NULL,'PSG',0),(2672,3,797,'2014-02-18 09:30:00','2014-02-18 10:00:00',1,NULL,'',0),(2673,2,899,'2014-01-29 11:00:00','2014-01-29 11:30:00',1,NULL,'appelera des qu elle aura les résultats',0),(2674,3,119,'2014-02-20 08:30:00','2014-02-20 09:00:00',1,NULL,'',0),(2675,3,572,'2014-01-29 16:00:00','2014-01-29 16:30:00',1,NULL,'pb lors de son voyage',0),(2676,2,897,'2014-01-27 09:00:00','2014-01-27 09:30:00',1,NULL,'',0),(2677,2,897,'2014-01-29 07:45:00','2014-01-29 08:15:00',1,NULL,'',0),(2678,3,386,'2014-02-24 08:30:00','2014-02-24 09:00:00',2,NULL,'',0),(2679,4,224,'2014-01-28 09:00:00','2014-01-28 09:30:00',1,NULL,'',0),(2680,4,193,'2014-02-13 09:00:00','2014-02-13 09:30:00',1,NULL,'',0),(2682,2,900,'2014-02-10 16:30:00','2014-02-10 17:00:00',1,NULL,'ronflements importants',0),(2685,2,898,'2014-01-30 10:00:00','2014-01-30 10:30:00',2,NULL,'',0),(2686,2,898,'2014-01-31 16:30:00','2014-01-31 17:30:00',3,NULL,'PV\r\npasser CV  pour EFR du 30/1/2014',0),(2687,3,898,'2014-02-05 15:30:00','2014-02-05 16:00:00',1,NULL,'EFR fait le 30/1/2014\r\nScanner dans le dossier\r\n',0),(2689,4,903,'2014-02-11 09:30:00','2014-02-11 10:00:00',1,NULL,'',0),(2690,2,890,'2014-02-04 08:30:00','2014-02-04 09:00:00',2,NULL,'',0),(2691,3,178,'2014-03-17 09:00:00','2014-03-17 09:30:00',1,NULL,'',0),(2692,3,529,'2014-03-03 09:30:00','2014-03-03 10:00:00',2,NULL,'',0),(2693,4,228,'2014-02-18 14:00:00','2014-02-18 14:30:00',1,NULL,'',0),(2694,2,844,'2014-01-31 13:30:00','2014-01-31 14:00:00',2,NULL,'',0),(2695,3,844,'2014-02-05 16:00:00','2014-02-05 16:30:00',1,NULL,'',0),(2696,3,829,'2014-02-06 14:00:00','2014-02-06 14:30:00',1,NULL,'PET Scan à remplir\r\nprogrammer RCP',0),(2697,3,137,'2014-03-04 11:00:00','2014-03-04 11:30:00',1,NULL,'',0),(2698,2,907,'2014-04-08 10:00:00','2014-04-08 10:30:00',1,NULL,'Adressé par le centre de rééducation de Sainte-Clotilde pour une Polygraphie ventilatoire',0),(2699,2,658,'2014-03-28 14:00:00','2014-03-28 14:30:00',1,NULL,'',0),(2702,3,794,'2014-02-11 15:30:00','2014-02-11 16:00:00',1,NULL,'',0),(2703,3,489,'2014-02-06 15:30:00','2014-02-06 16:00:00',1,NULL,'',0),(2704,2,883,'2014-02-18 09:30:00','2014-02-18 10:00:00',2,NULL,'',0),(2705,2,908,'2014-01-28 15:30:00','2014-01-28 16:00:00',1,NULL,'',0),(2706,3,26,'2014-02-13 14:00:00','2014-02-13 14:30:00',1,NULL,'',0),(2707,2,908,'2014-01-31 15:00:00','2014-01-31 15:30:00',2,NULL,'',0),(2708,3,908,'2014-02-11 10:30:00','2014-02-11 11:00:00',1,NULL,'',0),(2709,2,858,'2014-02-10 16:00:00','2014-02-10 16:30:00',1,NULL,'résultat PSG',0),(2710,4,352,'2014-02-11 08:30:00','2014-02-11 09:00:00',1,NULL,'Résultat de PV',0),(2711,3,897,'2014-02-06 16:00:00','2014-02-06 16:30:00',1,NULL,'Rappelera pour une cs.',0),(2712,3,563,'2014-03-12 08:30:00','2014-03-12 09:00:00',2,NULL,'',0),(2715,3,105,'2014-03-18 10:00:00','2014-03-18 10:30:00',1,NULL,'',0),(2716,3,243,'2014-02-28 14:00:00','2014-02-28 14:30:00',1,NULL,'',0),(2717,3,82,'2014-02-21 14:00:00','2014-02-21 14:30:00',1,NULL,'',0),(2718,3,134,'2014-02-10 13:30:00','2014-02-10 14:00:00',1,NULL,'Alpha C 200',0),(2719,2,895,'2014-02-20 10:30:00','2014-02-20 11:00:00',2,NULL,'',0),(2720,2,895,'2014-05-07 16:00:00','2014-05-07 17:00:00',3,NULL,'PV',0),(2721,3,909,'2014-02-10 11:00:00','2014-02-10 11:30:00',1,NULL,'',0),(2723,2,726,'2014-02-13 10:00:00','2014-02-13 10:30:00',1,NULL,'résultat EFR',0),(2724,4,254,'2014-02-05 09:00:00','2014-02-05 09:30:00',1,NULL,'xolair.\r\nprevoir EFR\r\nlecture PSG',0),(2725,2,865,'2014-02-14 15:30:00','2014-02-14 16:00:00',1,NULL,'C2 (cf lettre dans le dossier médical) - Résultat EFR',0),(2726,4,910,'2014-02-05 15:00:00','2014-02-05 15:30:00',1,NULL,'',0),(2727,2,492,'2014-02-13 10:30:00','2014-02-13 11:00:00',1,NULL,'Résultat PV',0),(2728,4,911,'2014-02-04 08:00:00','2014-02-04 08:30:00',1,NULL,'',0),(2729,2,76,'2014-02-11 11:00:00','2014-02-11 11:30:00',1,NULL,'résultat PSG',0),(2730,2,912,'2014-02-03 16:00:00','2014-02-03 16:30:00',1,NULL,'En vacances à la Réunion (vient de Bretagne), il est encombré depuis le 28 janv.',0),(2731,4,150,'2014-02-04 15:00:00','2014-02-04 15:30:00',1,NULL,'',0),(2732,2,3,'2014-02-24 16:30:00','2014-02-24 17:30:00',3,NULL,'PV',0),(2734,2,390,'2014-02-25 10:30:00','2014-02-25 11:00:00',2,NULL,'',0),(2736,4,133,'2014-02-13 11:00:00','2014-02-13 11:30:00',1,NULL,'',0),(2737,3,917,'2014-02-05 09:15:00','2014-02-05 09:45:00',1,NULL,'',0),(2738,2,154,'2014-02-13 14:30:00','2014-02-13 15:00:00',1,NULL,'résultat PV',0),(2739,2,912,'2014-02-11 10:30:00','2014-02-11 11:00:00',2,NULL,'',0),(2740,2,99,'2014-04-09 09:30:00','2014-04-09 10:00:00',2,NULL,'',0),(2741,2,99,'2014-05-12 16:00:00','2014-05-12 17:00:00',4,NULL,'PSG',0),(2742,3,54,'2014-03-24 10:00:00','2014-03-24 10:30:00',2,NULL,'',0),(2743,2,693,'2014-02-04 10:00:00','2014-02-04 10:30:00',1,NULL,'',0),(2744,4,911,'2014-02-05 08:00:00','2014-02-05 08:30:00',2,NULL,'',0),(2745,4,3,'2014-02-20 15:00:00','2014-02-20 15:30:00',2,NULL,'',0),(2746,3,890,'2014-03-20 09:00:00','2014-03-20 09:30:00',1,NULL,'',0),(2747,3,738,'2014-02-05 16:30:00','2014-02-05 17:00:00',1,NULL,'',0),(2748,3,693,'2014-02-26 08:00:00','2014-02-26 08:30:00',1,NULL,'',0),(2749,3,188,'2014-03-18 10:00:00','2014-03-18 10:30:00',2,NULL,'',0),(2750,3,918,'2014-02-04 16:00:00','2014-02-04 16:30:00',1,NULL,'',0),(2751,2,210,'2014-02-12 15:15:00','2014-02-12 15:45:00',1,NULL,'',0),(2752,3,397,'2014-04-02 08:00:00','2014-04-02 08:30:00',1,NULL,'',0),(2753,3,316,'2014-02-24 14:00:00','2014-02-24 14:30:00',1,NULL,'',0),(2754,3,889,'2014-03-04 14:00:00','2014-03-04 14:30:00',1,NULL,'',0),(2755,3,150,'2014-03-31 10:30:00','2014-03-31 11:00:00',2,NULL,'',0),(2756,3,150,'2014-02-19 10:30:00','2014-02-19 11:00:00',1,NULL,'',0),(2757,3,357,'2014-03-17 14:30:00','2014-03-17 15:00:00',1,NULL,'',0),(2758,2,919,'2014-02-14 14:00:00','2014-02-14 14:30:00',1,NULL,'',0),(2759,2,918,'2014-02-11 09:30:00','2014-02-11 10:00:00',2,NULL,'',0),(2760,3,171,'2014-04-24 08:00:00','2014-04-24 08:30:00',1,NULL,'',0),(2761,3,440,'2014-05-20 08:15:00','2014-05-20 08:45:00',2,NULL,'',0),(2762,3,254,'2014-02-12 15:30:00','2014-02-12 16:00:00',1,NULL,'',0),(2763,3,920,'2014-02-07 16:30:00','2014-02-07 17:00:00',1,NULL,'',0),(2764,3,921,'2014-02-12 10:00:00','2014-02-12 10:30:00',1,NULL,'',0),(2765,3,917,'2014-02-12 08:30:00','2014-02-12 09:00:00',1,NULL,'',0),(2766,4,922,'2014-02-07 14:00:00','2014-02-07 14:30:00',1,NULL,'',0),(2767,3,704,'2014-02-12 11:30:00','2014-02-12 12:00:00',1,NULL,'',0),(2768,3,90,'2014-03-17 08:30:00','2014-03-17 09:00:00',1,NULL,'Prick tests',0),(2769,3,33,'2014-04-29 09:30:00','2014-04-29 10:00:00',2,NULL,'',0),(2770,4,869,'2014-02-05 11:30:00','2014-02-05 12:00:00',1,NULL,'',0),(2771,3,185,'2014-04-07 10:30:00','2014-04-07 11:00:00',1,NULL,'',0),(2772,2,731,'2014-02-13 15:00:00','2014-02-13 15:30:00',1,NULL,'résultat PV',0),(2773,4,400,'2014-02-05 11:45:00','2014-02-05 12:15:00',1,NULL,'',0),(2774,3,271,'2014-03-25 10:00:00','2014-03-25 10:30:00',1,NULL,'',0),(2775,2,869,'2014-02-13 09:30:00','2014-02-13 10:00:00',2,NULL,'',0),(2777,3,400,'2014-04-02 14:30:00','2014-04-02 15:00:00',1,NULL,'',0),(2778,2,926,'2014-02-13 15:30:00','2014-02-13 16:00:00',1,NULL,'Suspicion de SAS.',0),(2779,2,927,'2014-02-13 16:00:00','2014-02-13 16:30:00',1,NULL,'',0),(2780,2,928,'2014-02-24 11:00:00','2014-02-24 11:30:00',1,NULL,'',0),(2781,3,205,'2014-05-06 14:00:00','2014-05-06 14:30:00',2,NULL,'',0),(2782,3,222,'2014-03-26 14:00:00','2014-03-26 14:30:00',1,NULL,'',0),(2783,4,710,'2014-02-10 17:30:00','2014-02-10 18:00:00',1,NULL,'RESULTAT PV',0),(2784,2,758,'2014-03-03 16:30:00','2014-03-03 17:30:00',3,NULL,'PV',0),(2785,2,910,'2014-02-19 10:30:00','2014-02-19 11:00:00',2,NULL,'',0),(2786,2,898,'2014-02-26 15:00:00','2014-02-26 16:00:00',4,NULL,'PSG',0),(2787,2,738,'2014-02-24 09:30:00','2014-02-24 10:00:00',2,NULL,'',0),(2788,4,930,'2014-02-05 17:00:00','2014-02-05 17:30:00',1,NULL,'',0),(2789,3,738,'2014-02-10 11:30:00','2014-02-10 12:00:00',1,NULL,'',0),(2790,3,930,'2014-02-06 08:45:00','2014-02-06 09:15:00',1,NULL,'',0),(2791,3,176,'2014-04-03 08:30:00','2014-04-03 09:00:00',2,NULL,'',0),(2792,2,931,'2014-02-12 16:00:00','2014-02-12 16:30:00',1,NULL,'',0),(2793,3,932,'2014-02-10 10:00:00','2014-02-10 10:30:00',1,NULL,'+Laura,Fhayann,Rahia',0),(2794,2,429,'2014-02-19 09:30:00','2014-02-19 10:00:00',1,NULL,'résultat PV',0),(2795,3,599,'2014-03-05 08:00:00','2014-03-05 08:30:00',1,NULL,'',0),(2796,4,399,'2014-02-19 11:30:00','2014-02-19 12:00:00',1,NULL,'remettre la feuille verte pour la pharmacie de Bellepierre',0),(2797,3,198,'2014-03-03 10:00:00','2014-03-03 10:30:00',2,NULL,'',0),(2798,4,933,'2014-02-18 09:00:00','2014-02-18 09:30:00',1,NULL,'Ronfle, pense avoir des apnées.',0),(2799,3,498,'2014-04-09 10:30:00','2014-04-09 11:00:00',1,NULL,'',0),(2800,2,392,'2014-04-08 15:00:00','2014-04-08 16:00:00',3,NULL,'PV',0),(2801,3,392,'2014-03-17 09:30:00','2014-03-17 10:00:00',1,NULL,'',0),(2802,3,934,'2014-02-17 15:00:00','2014-02-17 15:30:00',1,NULL,'',0),(2803,3,557,'2014-02-17 15:30:00','2014-02-17 16:00:00',1,NULL,'',0),(2804,3,459,'2014-04-03 09:30:00','2014-04-03 10:00:00',2,NULL,'',0),(2805,3,552,'2014-02-17 14:30:00','2014-02-17 15:00:00',1,NULL,'',0),(2806,3,829,'2014-02-24 10:00:00','2014-02-24 10:30:00',1,NULL,'',0),(2807,3,203,'2014-03-27 14:00:00','2014-03-27 14:30:00',2,NULL,'',0),(2808,2,48,'2014-02-24 14:30:00','2014-02-24 15:00:00',1,NULL,'resultat PV',0),(2809,3,489,'2014-03-27 09:30:00','2014-03-27 10:00:00',2,NULL,'',0),(2810,3,935,'2014-02-13 11:30:00','2014-02-13 12:00:00',1,NULL,'',0),(2812,3,501,'2014-02-20 10:00:00','2014-02-20 10:30:00',1,NULL,'',0),(2813,2,220,'2014-02-18 16:00:00','2014-02-18 16:30:00',1,NULL,'résultat PV',0),(2814,3,678,'2014-04-07 08:30:00','2014-04-07 09:00:00',2,NULL,'',0),(2815,3,938,'2014-02-17 14:15:00','2014-02-17 14:45:00',1,NULL,'',0),(2816,3,406,'2014-03-06 10:00:00','2014-03-06 10:30:00',2,NULL,'',0),(2818,4,777,'2014-02-17 16:30:00','2014-02-17 17:00:00',2,NULL,'',0),(2819,3,939,'2014-02-07 15:00:00','2014-02-07 15:30:00',1,NULL,'',0),(2820,2,922,'2014-03-26 11:00:00','2014-03-26 11:30:00',2,NULL,'',0),(2821,2,216,'2014-03-19 09:00:00','2014-03-19 09:30:00',2,NULL,'',0),(2822,2,621,'2014-03-19 09:30:00','2014-03-19 10:00:00',2,NULL,'',0),(2823,2,733,'2014-03-19 10:00:00','2014-03-19 10:30:00',2,NULL,'',0),(2824,2,788,'2014-03-19 10:30:00','2014-03-19 11:00:00',2,NULL,'',0),(2826,3,47,'2014-03-05 10:30:00','2014-03-05 11:00:00',1,NULL,'',0),(2827,2,939,'2014-02-10 11:30:00','2014-02-10 12:00:00',2,NULL,'Doit 7.40 euros.',0),(2829,3,714,'2014-02-14 16:00:00','2014-02-14 16:30:00',1,NULL,'',0),(2831,2,920,'2014-02-17 16:30:00','2014-02-17 17:30:00',3,121,'PV',0),(2834,3,943,'2014-02-10 17:00:00','2014-02-10 17:30:00',1,NULL,'',0),(2835,3,944,'2014-02-11 16:00:00','2014-02-11 16:30:00',1,NULL,'L\'ambulanciere a ramenée  sa carte vitale.',0),(2836,3,909,'2014-02-27 11:15:00','2014-02-27 11:45:00',2,NULL,'',0),(2837,3,875,'2014-05-05 08:00:00','2014-05-05 08:30:00',1,NULL,'',0),(2839,3,134,'2014-03-13 10:00:00','2014-03-13 10:30:00',2,NULL,'',0),(2840,3,189,'2014-02-13 08:15:00','2014-02-13 08:45:00',1,NULL,'',0),(2841,2,945,'2014-02-10 14:30:00','2014-02-10 15:00:00',2,NULL,'',0),(2842,3,38,'2014-02-28 13:30:00','2014-02-28 14:30:00',5,NULL,'Mise sous VNI',0),(2844,2,416,'2014-05-19 16:00:00','2014-05-19 17:00:00',4,NULL,'',0),(2845,4,91,'2014-02-24 09:00:00','2014-02-24 09:30:00',1,NULL,'PV à prévoir',0),(2846,3,562,'2014-04-07 14:00:00','2014-04-07 14:30:00',1,NULL,'',0),(2847,4,153,'2014-03-25 10:30:00','2014-03-25 11:00:00',2,NULL,'',0),(2848,2,900,'2014-02-19 11:30:00','2014-02-19 12:00:00',2,NULL,'',0),(2849,2,900,'2014-03-13 16:30:00','2014-03-13 17:30:00',3,NULL,'',0),(2850,3,86,'2014-02-18 13:30:00','2014-02-18 14:30:00',5,NULL,'avec SEPRODOm\r\nVNI',0),(2851,3,943,'2014-03-06 08:00:00','2014-03-06 08:30:00',2,NULL,'',0),(2852,2,868,'2014-03-03 14:30:00','2014-03-03 15:00:00',1,NULL,'résultat PSG',0),(2853,2,710,'2014-05-26 16:00:00','2014-05-26 17:00:00',4,NULL,'',0),(2854,3,437,'2014-03-31 08:30:00','2014-03-31 09:00:00',2,NULL,'',0),(2855,3,946,'2014-03-10 08:00:00','2014-03-10 09:00:00',5,NULL,'Du 10 au 14 /03/2014',0),(2856,3,947,'2014-03-14 08:00:00','2014-03-14 09:00:00',5,NULL,'du 10 au 14/03/2014',0),(2857,3,948,'2014-04-16 08:00:00','2014-04-16 09:00:00',5,NULL,'16-18/04/2014',0),(2858,3,949,'2014-04-18 08:00:00','2014-04-18 09:00:00',5,NULL,'',0),(2859,3,212,'2014-02-19 08:00:00','2014-02-19 08:30:00',1,NULL,'',0),(2860,3,149,'2014-04-08 09:30:00','2014-04-08 10:00:00',2,NULL,'',0),(2861,2,352,'2014-06-02 16:00:00','2014-06-02 17:00:00',4,NULL,'',0),(2862,3,352,'2014-03-05 09:00:00','2014-03-05 09:30:00',1,NULL,'',0),(2863,3,97,'2014-09-22 08:30:00','2014-09-22 09:00:00',2,NULL,'',0),(2865,2,903,'2013-09-24 15:30:00','2013-09-24 16:00:00',2,NULL,'Doit etre opéré d\'un anévrysme Ao',0),(2866,2,903,'2014-02-24 11:00:00','2014-02-24 11:30:00',2,NULL,'',0),(2867,2,903,'2014-05-13 16:00:00','2014-05-13 17:00:00',3,NULL,'',0),(2868,3,918,'2014-02-28 15:30:00','2014-02-28 16:00:00',1,NULL,'',0),(2869,3,953,'2014-02-11 16:00:00','2014-02-11 16:30:00',1,NULL,'',0),(2870,3,954,'2014-02-14 16:30:00','2014-02-14 17:00:00',1,NULL,'',0),(2871,3,908,'2014-03-20 10:00:00','2014-03-20 10:30:00',1,NULL,'',0),(2872,3,912,'2014-02-26 09:00:00','2014-02-26 09:30:00',1,NULL,'',0),(2873,3,76,'2014-02-25 09:30:00','2014-02-25 10:00:00',1,NULL,'',0),(2874,3,83,'2014-03-06 10:30:00','2014-03-06 11:00:00',1,NULL,'',0),(2875,2,794,'2014-05-06 16:00:00','2014-05-06 17:00:00',3,NULL,'controle PPC',0),(2876,2,485,'2014-05-14 16:00:00','2014-05-14 17:00:00',3,NULL,'s\'assurer que les capteurs restent bien branchés',0),(2877,3,794,'2014-02-17 15:45:00','2014-02-17 16:15:00',1,NULL,'',0),(2878,2,253,'2014-02-19 10:00:00','2014-02-19 10:30:00',2,NULL,'',0),(2879,3,858,'2014-03-07 14:45:00','2014-03-07 15:15:00',1,NULL,'',0),(2880,2,944,'2014-03-11 10:00:00','2014-03-11 10:30:00',2,NULL,'',0),(2881,2,944,'2014-05-20 16:00:00','2014-05-20 17:00:00',3,NULL,'',0),(2882,3,944,'2014-02-26 09:30:00','2014-02-26 10:00:00',1,NULL,'',0),(2883,2,956,'2014-03-11 10:30:00','2014-03-11 11:00:00',2,NULL,'',0),(2884,2,956,'2014-02-11 16:15:00','2014-02-11 16:45:00',1,NULL,'',0),(2886,2,953,'2014-02-26 09:30:00','2014-02-26 10:00:00',2,NULL,'Enfant',0),(2887,4,958,'2014-02-25 11:00:00','2014-02-25 11:30:00',1,NULL,'',0),(2888,3,204,'2014-04-07 09:00:00','2014-04-07 09:30:00',2,NULL,'',0),(2889,2,917,'2014-03-03 09:00:00','2014-03-03 09:30:00',2,NULL,'',0),(2890,3,956,'2014-02-13 16:30:00','2014-02-13 17:00:00',1,NULL,'',0),(2891,3,960,'2014-02-17 11:00:00','2014-02-17 11:30:00',1,NULL,'polygraphie rapidement',0),(2892,3,961,'2014-02-17 11:30:00','2014-02-17 12:00:00',1,NULL,'',0),(2893,3,173,'2014-04-02 08:30:00','2014-04-02 09:00:00',2,NULL,'',0),(2894,3,121,'2014-04-10 08:30:00','2014-04-10 09:00:00',1,NULL,'',0),(2895,3,182,'2014-04-09 09:00:00','2014-04-09 09:30:00',1,NULL,'',0),(2896,3,430,'2014-02-26 08:30:00','2014-02-26 09:00:00',1,NULL,'',0),(2897,3,235,'2014-04-17 09:00:00','2014-04-17 09:30:00',1,NULL,'',0),(2898,2,921,'2014-02-26 08:30:00','2014-02-26 09:00:00',2,NULL,'',0),(2899,4,872,'2014-02-12 12:30:00','2014-02-12 13:00:00',1,NULL,'',0),(2900,2,880,'2014-02-17 15:00:00','2014-02-17 15:30:00',2,NULL,'PASSER CV POUR CS PRECEDENTE MERCI',0),(2901,3,704,'2014-03-17 10:30:00','2014-03-17 11:00:00',1,NULL,'',0),(2902,2,338,'2014-03-12 15:30:00','2014-03-12 16:30:00',3,NULL,'',0),(2903,3,872,'2014-02-18 08:00:00','2014-02-18 08:30:00',1,NULL,'',0),(2904,2,224,'2014-06-03 16:00:00','2014-06-03 17:00:00',3,NULL,'mettre un sparadrap pour la lunette nasale',0),(2905,3,224,'2014-04-04 14:00:00','2014-04-04 14:30:00',1,NULL,'',0),(2906,4,763,'2014-02-27 10:30:00','2014-02-27 11:00:00',1,NULL,'',0),(2907,2,210,'2014-03-03 11:00:00','2014-03-03 11:30:00',2,NULL,'',0),(2908,3,254,'2014-03-18 10:30:00','2014-03-18 11:00:00',1,NULL,'',0),(2909,2,818,'2013-12-24 08:00:00','2013-12-24 08:30:00',1,NULL,'',0),(2912,2,931,'2014-02-28 16:30:00','2014-02-28 17:00:00',2,NULL,'',0),(2913,4,27,'2014-03-03 08:00:00','2014-03-03 08:30:00',1,NULL,'',0),(2914,4,333,'2014-03-06 11:00:00','2014-03-06 11:30:00',1,NULL,'',0),(2915,2,818,'2014-02-27 10:00:00','2014-02-27 10:30:00',1,NULL,'résultat PSG',0),(2916,3,470,'2014-09-04 08:00:00','2014-09-04 08:30:00',2,NULL,'',0),(2917,4,964,'2014-02-20 11:00:00','2014-02-20 11:30:00',1,NULL,'',0),(2918,3,193,'2014-04-14 08:30:00','2014-04-14 09:00:00',2,NULL,'',0),(2919,3,726,'2014-04-10 09:00:00','2014-04-10 09:30:00',2,NULL,'',0),(2920,3,869,'2014-04-03 09:00:00','2014-04-03 09:30:00',1,NULL,'',0),(2921,2,195,'2014-03-10 10:30:00','2014-03-10 11:00:00',2,NULL,'',0),(2922,3,69,'2014-04-09 09:30:00','2014-04-09 10:00:00',1,NULL,'',0),(2923,2,133,'2014-03-17 09:00:00','2014-03-17 09:30:00',2,NULL,'',0),(2924,2,189,'2014-03-18 11:00:00','2014-03-18 11:30:00',2,NULL,'',0),(2925,3,492,'2014-04-10 10:00:00','2014-04-10 10:30:00',2,NULL,'',0),(2926,3,154,'2014-03-07 15:00:00','2014-03-07 15:30:00',1,NULL,'',0),(2927,4,333,'2014-02-14 14:15:00','2014-02-14 14:45:00',1,NULL,'',0),(2928,4,240,'2014-02-13 15:15:00','2014-02-13 15:45:00',1,NULL,'',0),(2929,3,731,'2014-02-28 14:30:00','2014-02-28 15:00:00',1,NULL,'',0),(2930,3,26,'2014-05-08 14:00:00','2014-05-08 14:30:00',1,NULL,'',0),(2931,2,702,'2014-03-03 11:30:00','2014-03-03 12:00:00',1,NULL,'résultat PV',0),(2932,2,926,'2014-03-20 09:00:00','2014-03-20 09:30:00',2,NULL,'',0),(2933,2,926,'2014-03-27 16:00:00','2014-03-27 17:00:00',3,NULL,'',0),(2934,2,927,'2014-03-20 09:30:00','2014-03-20 10:00:00',2,NULL,'',0),(2935,4,965,'2014-02-13 17:30:00','2014-02-13 18:00:00',1,NULL,'',0),(2936,3,59,'2014-02-18 10:00:00','2014-02-18 10:30:00',1,NULL,'',0),(2937,3,430,'2014-02-17 10:30:00','2014-02-17 11:00:00',1,NULL,'',0),(2938,2,919,'2014-03-07 15:30:00','2014-03-07 16:00:00',2,NULL,'',0),(2939,2,919,'2014-03-24 16:30:00','2014-03-24 17:30:00',3,NULL,'',0),(2940,4,40,'2014-02-14 15:00:00','2014-02-14 15:30:00',1,NULL,'',0),(2941,3,403,'2014-02-19 14:30:00','2014-02-19 15:00:00',1,NULL,'',0),(2942,3,736,'2014-03-07 14:30:00','2014-03-07 15:00:00',1,NULL,'',0),(2943,2,865,'2014-03-18 09:30:00','2014-03-18 10:00:00',2,NULL,'',0),(2944,4,967,'2014-03-07 14:00:00','2014-03-07 14:30:00',1,NULL,'',0),(2945,2,865,'2014-04-14 16:30:00','2014-04-14 17:30:00',3,NULL,'',0),(2946,3,40,'2014-03-27 10:30:00','2014-03-27 11:00:00',2,NULL,'',0),(2947,3,714,'2014-02-17 11:45:00','2014-02-17 12:15:00',1,NULL,'',0),(2948,3,954,'2014-03-20 08:30:00','2014-03-20 09:00:00',2,NULL,'',0),(2949,4,807,'2014-02-17 14:00:00','2014-02-17 14:30:00',1,NULL,'rapporte polygraphe',0),(2950,4,807,'2014-03-19 10:00:00','2014-03-19 10:30:00',1,NULL,'résultat de PSG',0),(2951,3,969,'2014-02-17 09:00:00','2014-02-17 09:30:00',1,NULL,'',0),(2952,3,971,'2014-03-17 11:30:00','2014-03-17 12:00:00',1,NULL,'PSG',0),(2953,3,969,'2014-02-27 08:30:00','2014-02-27 09:00:00',1,NULL,'',0),(2954,3,430,'2014-02-25 14:00:00','2014-02-25 14:30:00',1,NULL,'',0),(2955,3,76,'2014-02-21 13:45:00','2014-02-21 14:45:00',5,NULL,'',0),(2956,3,972,'2014-02-26 08:00:00','2014-02-26 08:30:00',1,NULL,'',0),(2957,3,797,'2014-04-02 09:00:00','2014-04-02 09:30:00',2,NULL,'',0),(2958,3,714,'2014-03-31 10:00:00','2014-03-31 10:30:00',2,NULL,'',0),(2959,3,27,'2014-02-25 14:30:00','2014-02-25 15:00:00',2,NULL,'',0),(2960,3,309,'2014-02-26 14:30:00','2014-02-26 15:00:00',1,NULL,'',0),(2961,3,552,'2014-03-05 14:30:00','2014-03-05 15:00:00',2,NULL,'',0),(2962,3,938,'2014-03-06 14:00:00','2014-03-06 14:30:00',1,NULL,'',0),(2963,3,78,'2014-04-04 14:00:00','2014-04-04 14:30:00',2,NULL,'',0),(2964,3,794,'2014-02-24 13:30:00','2014-02-24 14:30:00',5,NULL,'ARAR',0),(2965,3,557,'2014-04-01 14:00:00','2014-04-01 14:30:00',1,NULL,'',0),(2966,4,38,'2014-03-03 10:30:00','2014-03-03 11:00:00',2,NULL,'',0),(2967,3,934,'2014-02-27 14:00:00','2014-02-27 14:30:00',1,NULL,'',0),(2968,2,777,'2014-03-10 15:30:00','2014-03-10 16:30:00',3,NULL,'',0),(2969,2,920,'2014-02-21 15:30:00','2014-02-21 16:00:00',2,NULL,'résultat PV',0),(2970,3,310,'2014-04-15 08:00:00','2014-04-15 08:30:00',2,NULL,'',0),(2971,3,55,'2014-04-10 08:15:00','2014-04-10 08:45:00',2,NULL,'',0),(2972,2,933,'2014-03-17 08:00:00','2014-03-17 08:30:00',2,NULL,'',0),(2973,2,933,'2014-04-03 16:30:00','2014-04-03 17:30:00',3,NULL,'',0),(2974,4,945,'2014-02-25 14:00:00','2014-02-25 14:30:00',1,NULL,'',0),(2975,3,59,'2014-03-13 08:15:00','2014-03-13 08:45:00',2,NULL,'',0),(2976,3,59,'2014-03-18 08:00:00','2014-03-18 08:30:00',1,NULL,'',0),(2977,3,96,'2014-05-05 10:00:00','2014-05-05 10:30:00',1,NULL,'',0),(2978,3,167,'2014-04-21 10:00:00','2014-04-21 10:30:00',1,NULL,'',0),(2979,4,974,'2014-02-25 08:00:00','2014-02-25 08:30:00',1,NULL,'',0),(2980,4,975,'2014-02-25 08:30:00','2014-02-25 09:00:00',1,NULL,'',0),(2981,3,240,'2014-04-01 09:00:00','2014-04-01 09:30:00',1,NULL,'',0),(2982,2,148,'2014-03-17 15:00:00','2014-03-17 15:30:00',1,NULL,'',0),(2983,2,976,'2014-02-27 14:00:00','2014-02-27 11:00:00',1,NULL,'Adressée par le Centre de Rééducation de Sainte-Clotilde',0),(2984,2,976,'2014-03-17 16:00:00','2014-03-17 17:00:00',3,NULL,'',0),(2985,2,228,'2014-05-15 16:30:00','2014-05-15 17:30:00',4,NULL,'',0),(2986,3,228,'2014-04-15 14:00:00','2014-04-15 14:30:00',2,NULL,'',0),(2987,3,86,'2014-04-07 16:30:00','2014-04-07 17:00:00',1,NULL,'',0),(2988,2,810,'2014-03-03 15:00:00','2014-03-03 15:30:00',1,NULL,'résultat PV',0),(2989,2,533,'2014-03-04 10:30:00','2014-03-04 11:00:00',1,NULL,'Pt extubé en 11/2013',0),(2990,2,524,'2014-03-05 15:30:00','2014-03-05 16:00:00',1,NULL,'résultat PV',0),(2991,3,692,'2014-04-01 11:00:00','2014-04-01 09:30:00',2,NULL,'',0),(2992,3,940,'2014-02-19 16:30:00','2014-02-19 17:00:00',1,NULL,'',0),(2993,3,212,'2014-03-05 09:30:00','2014-03-05 10:00:00',1,NULL,'',0),(2994,3,319,'2014-04-28 09:00:00','2014-04-28 09:30:00',1,NULL,'',0),(2995,3,429,'2014-03-31 09:00:00','2014-03-31 09:30:00',1,NULL,'',0),(2996,3,253,'2014-03-26 09:00:00','2014-03-26 09:30:00',1,NULL,'',0),(2997,3,282,'2014-04-01 10:00:00','2014-04-01 10:30:00',1,NULL,'',0),(2998,3,150,'2014-02-24 16:00:00','2014-02-24 16:30:00',1,NULL,'',0),(2999,3,399,'2014-04-01 08:15:00','2014-04-01 08:45:00',2,NULL,'',0),(3000,3,29,'2014-04-18 14:00:00','2014-04-18 14:30:00',2,NULL,'',0),(3001,3,737,'2014-04-14 09:30:00','2014-04-14 10:00:00',2,NULL,'',0),(3002,4,855,'2014-03-03 16:00:00','2014-03-03 16:30:00',1,NULL,'',0),(3003,3,217,'2014-03-24 14:00:00','2014-03-24 14:30:00',1,NULL,'',0),(3004,4,570,'2014-03-18 11:30:00','2014-03-18 12:00:00',1,NULL,'',0),(3005,4,169,'2014-03-03 15:30:00','2014-03-03 16:00:00',1,NULL,'',0),(3006,3,403,'2014-02-25 14:30:00','2014-02-25 15:00:00',1,NULL,'',0),(3007,3,161,'2014-02-26 10:00:00','2014-02-26 10:30:00',1,NULL,'',0),(3008,4,978,'2014-02-20 10:15:00','2014-02-20 10:30:00',1,NULL,'',0),(3009,4,396,'2014-03-20 10:30:00','2014-03-20 11:00:00',1,NULL,'',0),(3010,4,979,'2014-02-27 15:00:00','2014-02-27 16:00:00',5,NULL,'',0),(3011,4,196,'2014-03-20 11:00:00','2014-03-20 11:30:00',1,NULL,'A ETE HOSPITALISE',0),(3012,3,940,'2014-03-03 08:15:00','2014-03-03 08:45:00',2,NULL,'',0),(3013,3,940,'2014-04-30 15:30:00','2014-04-30 16:30:00',3,NULL,'',0),(3014,4,42,'2014-03-19 14:30:00','2014-03-19 15:00:00',1,NULL,'',0),(3015,2,729,'2014-03-04 11:30:00','2014-03-04 12:00:00',1,NULL,'résultat PSG\r\nCOMPTER PSG (AMQP12+PAV) DU 19 FEV + CS DU 20 FEV\r\nattention, pretextera peut-être qu\'il est pressé et ne peut pas donner sa carte vitale',0),(3016,4,980,'2014-03-26 10:00:00','2014-03-26 10:30:00',1,NULL,'',0),(3017,4,981,'2014-03-26 11:00:00','2014-03-26 11:30:00',1,NULL,'',0),(3018,4,982,'2014-03-26 10:30:00','2014-03-26 11:00:00',1,NULL,'',0),(3019,3,575,'2014-04-21 08:15:00','2014-04-21 08:45:00',2,NULL,'',0),(3020,3,417,'2014-04-21 08:00:00','2014-04-21 08:30:00',1,NULL,'',0),(3021,3,119,'2014-04-28 14:00:00','2014-04-28 14:30:00',2,NULL,'',0),(3022,2,729,'2014-02-20 08:00:00','2014-02-20 08:30:00',1,NULL,'',0),(3023,3,935,'2014-02-28 13:30:00','2014-02-28 14:00:00',1,NULL,'',0),(3024,4,983,'2014-03-26 15:15:00','2014-03-26 16:00:00',1,NULL,'',0),(3025,3,978,'2014-02-24 10:30:00','2014-02-24 11:00:00',1,NULL,'',0),(3026,3,964,'2014-02-24 10:30:00','2014-02-24 11:00:00',2,NULL,'',0),(3027,2,221,'2014-02-24 13:50:00','2014-02-24 14:20:00',1,NULL,'résultat EFR + Xolaire',0),(3028,2,37,'2014-02-24 09:30:00','2014-02-24 10:00:00',1,NULL,'résultat EFR\r\nrenouvellement Kiné + médicaments',0),(3029,3,322,'2014-02-21 15:00:00','2014-02-21 15:30:00',1,NULL,'',0),(3030,2,866,'2014-03-17 11:00:00','2014-03-17 11:30:00',1,NULL,'résultat PSG',0),(3031,3,322,'2014-03-20 10:30:00','2014-03-20 11:00:00',2,NULL,'',0),(3032,3,322,'2014-05-21 16:00:00','2014-05-21 17:00:00',3,NULL,'',0),(3033,3,82,'2014-02-26 11:00:00','2014-02-26 11:30:00',1,NULL,'',0),(3034,2,944,'2014-02-24 15:30:00','2014-02-24 16:00:00',1,NULL,'',0),(3035,3,113,'2014-04-21 09:00:00','2014-04-21 09:30:00',1,NULL,'',0),(3036,3,920,'2014-04-08 11:00:00','2014-04-08 11:30:00',1,NULL,'',0),(3037,2,723,'2014-03-19 15:00:00','2014-03-19 15:30:00',1,NULL,'résultat PV',0),(3038,2,815,'2014-02-27 18:00:00','2014-02-27 18:30:00',1,NULL,'résultat PSG',0);
/*!40000 ALTER TABLE `agenda` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `agenda_ccam`
--

DROP TABLE IF EXISTS `agenda_ccam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agenda_ccam` (
  `id_agenda` int(11) NOT NULL,
  `code_ccam` char(7) NOT NULL,
  PRIMARY KEY (`id_agenda`,`code_ccam`),
  KEY `code_ccam` (`code_ccam`),
  CONSTRAINT `agenda_ccam_ibfk_1` FOREIGN KEY (`id_agenda`) REFERENCES `agenda` (`id_agenda`) ON UPDATE CASCADE,
  CONSTRAINT `agenda_ccam_ibfk_2` FOREIGN KEY (`code_ccam`) REFERENCES `ccam` (`code_ccam`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `agenda_ccam`
--

LOCK TABLES `agenda_ccam` WRITE;
/*!40000 ALTER TABLE `agenda_ccam` DISABLE KEYS */;
INSERT INTO `agenda_ccam` VALUES (183,'AMQP012'),(2000,'AMQP012'),(2273,'AMQP012'),(2311,'AMQP012'),(49,'C2'),(969,'C2'),(1871,'C2'),(1876,'C2'),(1960,'C2'),(2010,'C2'),(2603,'C2'),(1,'CS'),(2,'CS'),(3,'CS'),(4,'CS'),(5,'CS'),(6,'CS'),(14,'CS'),(16,'CS'),(17,'CS'),(18,'CS'),(19,'CS'),(21,'CS'),(24,'CS'),(25,'CS'),(28,'CS'),(31,'CS'),(33,'CS'),(34,'CS'),(35,'CS'),(36,'CS'),(37,'CS'),(38,'CS'),(39,'CS'),(40,'CS'),(42,'CS'),(48,'CS'),(50,'CS'),(275,'CS'),(331,'CS'),(531,'CS'),(540,'CS'),(548,'CS'),(676,'CS'),(964,'CS'),(965,'CS'),(1300,'CS'),(1406,'CS'),(1471,'CS'),(1499,'CS'),(1510,'CS'),(1634,'CS'),(1636,'CS'),(1774,'CS'),(1775,'CS'),(1793,'CS'),(1872,'CS'),(1881,'CS'),(1882,'CS'),(2819,'CS'),(2947,'CS'),(2949,'CS'),(2950,'CS'),(41,'GLQP002'),(43,'GLQP002'),(77,'GLQP002'),(85,'GLQP002'),(86,'GLQP002'),(87,'GLQP002'),(94,'GLQP002'),(123,'GLQP002'),(128,'GLQP002'),(138,'GLQP002'),(147,'GLQP002'),(161,'GLQP002'),(166,'GLQP002'),(170,'GLQP002'),(187,'GLQP002'),(191,'GLQP002'),(192,'GLQP002'),(266,'GLQP002'),(282,'GLQP002'),(294,'GLQP002'),(297,'GLQP002'),(392,'GLQP002'),(535,'GLQP002'),(1198,'GLQP002'),(1356,'GLQP002'),(1397,'GLQP002'),(1500,'GLQP002'),(1524,'GLQP002'),(1682,'GLQP002'),(1896,'GLQP002'),(1923,'GLQP002'),(1948,'GLQP002'),(2062,'GLQP002'),(2282,'GLQP002'),(2310,'GLQP002'),(2638,'GLQP002'),(2827,'GLQP002'),(101,'GLQP007'),(1528,'GLQP007'),(1683,'GLQP007'),(1897,'GLQP007'),(1,'MCS'),(2,'MCS'),(3,'MCS'),(4,'MCS'),(5,'MCS'),(6,'MCS'),(14,'MCS'),(16,'MCS'),(17,'MCS'),(18,'MCS'),(19,'MCS'),(21,'MCS'),(24,'MCS'),(25,'MCS'),(28,'MCS'),(31,'MCS'),(33,'MCS'),(34,'MCS'),(35,'MCS'),(36,'MCS'),(37,'MCS'),(38,'MCS'),(39,'MCS'),(40,'MCS'),(42,'MCS'),(48,'MCS'),(50,'MCS'),(275,'MCS'),(331,'MCS'),(531,'MCS'),(540,'MCS'),(548,'MCS'),(676,'MCS'),(964,'MCS'),(965,'MCS'),(1300,'MCS'),(1406,'MCS'),(1471,'MCS'),(1499,'MCS'),(1510,'MCS'),(1634,'MCS'),(1636,'MCS'),(1774,'MCS'),(1775,'MCS'),(1793,'MCS'),(1872,'MCS'),(1881,'MCS'),(1882,'MCS'),(2819,'MCS'),(2947,'MCS'),(2949,'MCS'),(2950,'MCS'),(1,'MPC'),(2,'MPC'),(3,'MPC'),(4,'MPC'),(5,'MPC'),(6,'MPC'),(14,'MPC'),(16,'MPC'),(17,'MPC'),(18,'MPC'),(19,'MPC'),(21,'MPC'),(24,'MPC'),(25,'MPC'),(28,'MPC'),(31,'MPC'),(33,'MPC'),(34,'MPC'),(35,'MPC'),(36,'MPC'),(37,'MPC'),(38,'MPC'),(39,'MPC'),(40,'MPC'),(42,'MPC'),(48,'MPC'),(50,'MPC'),(275,'MPC'),(331,'MPC'),(531,'MPC'),(540,'MPC'),(548,'MPC'),(676,'MPC'),(964,'MPC'),(965,'MPC'),(1300,'MPC'),(1406,'MPC'),(1471,'MPC'),(1499,'MPC'),(1510,'MPC'),(1634,'MPC'),(1636,'MPC'),(1774,'MPC'),(1775,'MPC'),(1793,'MPC'),(1872,'MPC'),(1881,'MPC'),(1882,'MPC'),(2819,'MPC'),(2947,'MPC'),(2949,'MPC'),(2950,'MPC'),(41,'YYYY006'),(77,'YYYY006'),(85,'YYYY006'),(86,'YYYY006'),(87,'YYYY006'),(94,'YYYY006'),(123,'YYYY006'),(128,'YYYY006'),(138,'YYYY006'),(147,'YYYY006'),(161,'YYYY006'),(166,'YYYY006'),(170,'YYYY006'),(187,'YYYY006'),(191,'YYYY006'),(192,'YYYY006'),(266,'YYYY006'),(282,'YYYY006'),(297,'YYYY006'),(392,'YYYY006'),(535,'YYYY006'),(1198,'YYYY006'),(1356,'YYYY006'),(1397,'YYYY006'),(1500,'YYYY006'),(1524,'YYYY006'),(1682,'YYYY006'),(1896,'YYYY006'),(1923,'YYYY006'),(1948,'YYYY006'),(2062,'YYYY006'),(2282,'YYYY006'),(2310,'YYYY006'),(2638,'YYYY006'),(2827,'YYYY006'),(41,'YYYY076'),(43,'YYYY076'),(77,'YYYY076'),(85,'YYYY076'),(86,'YYYY076'),(87,'YYYY076'),(94,'YYYY076'),(128,'YYYY076'),(138,'YYYY076'),(147,'YYYY076'),(191,'YYYY076'),(266,'YYYY076'),(282,'YYYY076'),(294,'YYYY076'),(297,'YYYY076'),(392,'YYYY076'),(535,'YYYY076'),(1198,'YYYY076'),(1356,'YYYY076'),(1397,'YYYY076'),(1500,'YYYY076'),(1524,'YYYY076'),(1682,'YYYY076'),(1896,'YYYY076'),(1923,'YYYY076'),(1948,'YYYY076'),(2062,'YYYY076'),(2282,'YYYY076'),(2310,'YYYY076'),(2638,'YYYY076'),(2827,'YYYY076');
/*!40000 ALTER TABLE `agenda_ccam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccam`
--

DROP TABLE IF EXISTS `ccam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccam` (
  `code_ccam` char(7) NOT NULL,
  `libelle` varchar(255) NOT NULL,
  `prix_acte` decimal(5,2) NOT NULL,
  `supplement_charge_cabinet` decimal(5,2) NOT NULL,
  `coefficiant_2e_acte` float NOT NULL,
  PRIMARY KEY (`code_ccam`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccam`
--

LOCK TABLES `ccam` WRITE;
/*!40000 ALTER TABLE `ccam` DISABLE KEYS */;
INSERT INTO `ccam` VALUES ('AMQP010','Polysomnographie de 4 à 8 heures, sans enregistrement vidéo',136.52,0.00,0.5),('AMQP012','Polysomnographie de 8 à 12 heures, sans enregistrement vidéo',181.53,0.00,0.5),('AMQP014','Polysomnographie de 12 à 24 heures, sans enregistrement vidéo',200.07,0.00,0.5),('C2','Avis de Consultant	\n',55.20,0.00,0.5),('CS','Consultation au cabinet par le médecin spécialiste qualifié et le médecin spécialiste qualifié en médecine générale',27.60,0.00,0.5),('GERD002','Épreuve de provocation par agent bronchoconstricteur ou facteur physique, au cours d\'une épreuve fonctionnelle respiratoire',0.00,0.00,0),('GLQP002','Mesure de la capacité vitale lente et de l\'expiration forcée, avec mesure des volumes pulmonaires mobilisables et non mobilisables par pléthysmographie',76.80,0.00,0.5),('GLQP007','Polygraphie respiratoire nocturne',119.31,0.00,0.5),('MCS','Majoration de coordination',3.00,0.00,1),('MPC','Majoration forfaitaire transitoire applicable à la CS',2.00,0.00,1),('MPJ','MPJ (MPC) : majoration forfaitaire transitoire applicable à la consultation par le spécialiste pour les patients de moins 16 ans',5.00,0.00,1),('YYYY006','Épreuve quantitative aux agents pharmacodynamiques ou de provocation aux allergènes comportant une mesure du seuil de réactivité',42.24,0.00,0.5),('YYYY076','Mesure du transfert de monoxyde de carbone, en état stable, en apnée, en inspiration unique ou en réinspiration',34.56,0.00,0.5);
/*!40000 ALTER TABLE `ccam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clients`
--

DROP TABLE IF EXISTS `clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients` (
  `id_client` int(11) NOT NULL AUTO_INCREMENT,
  `sexe` enum('H','F') NOT NULL,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(50) NOT NULL,
  `date_naissance` date NOT NULL,
  `telephone_fixe` varchar(20) NOT NULL,
  `telephone_portable` varchar(20) NOT NULL,
  `adresse` text NOT NULL,
  `code_postal` varchar(10) NOT NULL,
  `ville` varchar(50) NOT NULL,
  `pays` varchar(20) NOT NULL,
  `taille` int(3) DEFAULT NULL,
  `medecin_traitant` varchar(50) NOT NULL,
  `numero_nir` char(15) DEFAULT NULL,
  `id_etablissement` int(11) DEFAULT NULL,
  `deces` tinyint(1) NOT NULL,
  PRIMARY KEY (`id_client`),
  KEY `id_etablissement` (`id_etablissement`),
  KEY `numero_nir` (`numero_nir`),
  CONSTRAINT `clients_ibfk_1` FOREIGN KEY (`id_etablissement`) REFERENCES `etablissements` (`id_etablissement`)
) ENGINE=InnoDB AUTO_INCREMENT=984 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clients`
--

LOCK TABLES `clients` WRITE;
/*!40000 ALTER TABLE `clients` DISABLE KEYS */;
INSERT INTO `clients` VALUES (1,'H','TREPORT','REGIS','1937-08-17','','0692490194','','','','',NULL,'Dr Eric BOURDAIS','137089740803555',NULL,0),(2,'H','LEBRETON','Pierre','1952-02-23','0262321762','0692501066','','','','',NULL,'Dr Pothier','152029741520310',NULL,0),(3,'F','AGENOR','Monique Jacqueline','1956-07-28','0262526152','0692314777','','','','',NULL,'Dr SERY Etienne','256079741142533',NULL,0),(4,'H','LATCHIMY','Gabriel','1939-11-06','0 262 46 25 83','0 692 01 71 51','830 chemin de Centre','97440','Saint-André','',NULL,'','139119741382238',NULL,0),(5,'F','VELLEYEN','Charlotte','1925-04-07','','0692484842','','','','',NULL,'Dr KAPLER','225049741100581',NULL,0),(6,'F','MANGAL','Chandrowtee','1949-05-04','','','','','','',NULL,'','249059939033441',NULL,0),(25,'H','RASOANANTENAINA','Edwige','1953-02-19','0262566123','0692293761','','','','',NULL,'Dr Fun Yan Yuen','253029933326920',NULL,0),(26,'H','GAUTHIER','Denise','1932-11-16','0262568113','','','','','',NULL,'Dr PIERRON','232119740202305',NULL,0),(27,'H','FIDAHOUSSEN','Sp','1938-04-04','0262405061','0692455391','','','','',NULL,'Dr Courchinoux','138049933330624',NULL,0),(28,'H','CORDON','Jean David','1967-12-15','0262467661','0692562145','','','','',NULL,'Dr DABEE','167129741008591',NULL,0),(29,'F','SERY','Rosemay','1961-10-23','0262214693','','','','','',NULL,'DR Le BIHAN','156079741138130',NULL,0),(30,'F','GOULAMHOUSSEN','Kaniza','1930-12-12','0 262 29 59 01','','','','','',NULL,'Dr Goulam Abasse','230129933319523',NULL,0),(31,'H','GUICHARD','Jean Pierre','1949-02-20','0262525470','','','','','',NULL,'Dr Maigrat','149029742193125',NULL,0),(32,'H','ANDREE','Albert Volamand','1958-03-01','','','','','','',NULL,'','258039933332229',NULL,0),(33,'H','ARIVE','Jean Jimmy','1968-03-10','0 262 71 04 42','0 692 61 32 30','','','Le Port','',NULL,'Dr. Mareuil','274049741102387',NULL,0),(34,'H','ROBERT','Jean Marc','1948-12-23','','0 692 59 12 11','','','','',NULL,'Dr Jatob','148129740900565',NULL,0),(35,'F','SEPEROUMAL','Marie Rachel','1966-04-03','0 262 93','0 693 02 82 58','','','','',NULL,'Dr KAPLER','168019741120507',NULL,0),(36,'F','BOYER','Suzy','1935-08-16','','','','','','',NULL,'','235089741102325',NULL,0),(37,'H','ALPOU','Firmin','1944-01-12','069272 7923 (Ramassa','0 692 28 78 39','','','','',NULL,'Dr PILLAY','144019742093982',NULL,0),(38,'F','SELLINGUE ITEMA','Marie Paule','1937-07-08','0 262 23 88 57','0 693 41 95 13 (fill','','','','',NULL,'Dr Roseline PAYET','237079741103296',NULL,0),(39,'F','GRONDIN','Marie Françoise','1960-10-19','','','','','','',NULL,'','260109741209192',NULL,0),(40,'H','CLOTILDE','Jean Claude','1944-07-29','0 262 31 67 40','0 692 45 80 98','','','','',NULL,'Dr. Vingetama','144079741592551',NULL,0),(41,'F','CLOTILDE','Monique Gilette','1942-08-25','0 262 31 67 40','0 692 45 80 98','','','','',NULL,'Dr Vinguetama-Perianagom','242089741081980',NULL,0),(42,'F','NAGOU','Christiane','1935-04-03','0 262 460401','','','','','',NULL,'Dr VIRAPOULLE','235049740910536',NULL,0),(43,'F','CAMARET','Josiane','1944-09-20','','0692060462','','','','',NULL,'Dr Eric BOURDAIS','244099741840773',NULL,0),(44,'F','GAUVIN','Marie Rosemay','1952-10-02','0 262 19 54 02','0 692 37 71 80','','','','',157,'','252109741300753',NULL,0),(45,'H','SAMBENOUN','Emilien','1934-02-20','0 262 46 38 27','','','','','',0,'Dr. Hossenboccus','134029742006804',NULL,0),(46,'F','ECLAPIER','Marie Suzette','1939-04-04','0 262 22 21 57','0 692 14 60 36','','','La Possession','',146,'Dr Azzolin','239049742116304',NULL,0),(47,'H','NARIN','Joseph Narcisse','1933-07-02','0 262 45 20 61','','','','','',0,'Dr Kabagema','133079741401476',NULL,0),(48,'H','LERY','Issop','1934-11-22','0 262 52 50 35','0 692 08 41 00','248 rue du Général Lecler\r\nRésidence le Chanbly\r\nApt 4 bat B etage 1','97400','Saint-Denis','',0,'Dr Bobat','134119933325592',NULL,0),(49,'F','ETOUARIA','Jasmine Marie','1963-01-31','','0 692 78 02 87','','','','',0,'Dr N\'Guyen Maurice','263019740712910',NULL,0),(52,'H','DIJOUX','Valère','1940-10-22','','0 692 71 19 27','','','','',0,'Dr. Leveque','140109741101366',NULL,0),(54,'H','FENELON','Charlemagne','1937-07-18','0 262 97 37 92','','39, rue du Père Lafosse\r\nMoufia II','97490','Sainte-Clotilde','',0,'Dr LOW HONG','137079741100279',NULL,0),(55,'H','BENARD','Frederic Marc','1945-01-20','','0 692 15 56 08','','','Le Port','',0,'Dr. Charlette Limbe','145019741101464',NULL,0),(57,'F','PERRAULT','Marie Leonie','1953-08-03','0 262 58 29 54','0 692 74 47 94','17, lotissement Lacaussade','','Saint-André','',0,'Dr. Checkouri','253089742131902',NULL,0),(58,'F','VOLAMADRANTO','Egyptienne','0000-00-00','0 262  46 02 09','0 692 49 18 98','','','','',0,'',NULL,NULL,0),(59,'H','JAMS','MARC AUGUSTIN','1945-09-06','0 262 53 81 50','0 692 08 40 11','11, chemin des Cesires','','Saint-Bernard','',0,'Dr. Mas','145099741101891',NULL,0),(60,'H','SERGE','Jean Marcellin','1959-05-30','','0 692 65 44 59','','','','',0,'Dr. Laurent de Grandpré','159059741149330',NULL,0),(61,'F','BARAKA','Marie Danielle','1963-07-18','0 262 48 57 40','0 692 20 60 51','41, rue Christol Valentin','','Sainte Suzanne','',0,'Dr. Bruno Cadet','263079742039532',NULL,0),(63,'F','TOUSSAINT','JEANNINE MARIE','1948-10-01','','0692934801','','','St Denis','',0,'Dr Mondon-Barnabera','248109741301943',NULL,0),(64,'H','TURPIN','DANIEL ARSENE','1952-03-12','','','','','','',0,'','155039742013390',NULL,0),(65,'H','SOUPRAMANIEN','Edmond','1934-11-18','0262409865','','','','','',0,'Dr Patel','134119741807507',NULL,0),(66,'H','MOIMBA','Alexis','1943-11-13','0262335905','0692586745','','','','',0,'Dr Sabatier','143119741590785',NULL,0),(67,'H','DUCHEMANN','J Simon','1954-12-06','','','','','','',0,'','154129741002314',NULL,0),(68,'H','ANGAMA','Adrienne','1952-03-04','0 262 30 72 67','0692607131','','','','',0,'Dr IMBERT','252039742009432',NULL,0),(69,'F','DENISET','Lucie','1939-03-07','0 262 300 231','0 692 37 09 75','','','','',0,'Dr PARATIAN','239039741104122',NULL,0),(70,'F','CLOVIS','Oubanesbady','1951-08-01','','0692893469','','','','',0,'Dr Eric FONTAINE','251089922325140',NULL,0),(71,'H','BOYER','Sully Maxime','1929-03-18','0 262 47 70 87','','','','','',0,'Dr. gérard, Grand Ilet','129039742109118',NULL,0),(72,'F','SAUTRON','Melanie','1950-06-13','0 262 47 02 54','','','','','',0,'Dr. Rida / Dr. Paoli','250069742110144',NULL,0),(73,'H','DANDJEE VALDJEE','Fidahoussen','1931-11-08','0 262 50 61 91','0 692 08 06 68','123, rue Sainte-Marie\r\nRésidence Mickael\r\nApt. 12','','Saint-Denis','',0,'Dr. Siddick Goburdhun','131119933317627',NULL,0),(74,'F','AH YONE','Suzanne','1936-11-03','0 262 21 96 79 ','0 692 53 23 91','','','Saint-Denis','',0,'Dr. Yves Rochard','236119741183684',NULL,0),(75,'H','TSIFOUMBY','Georges','1954-10-14','','0692121432','','','Saint-André','',0,'Dr. Paoli','154109741007527',NULL,0),(76,'F','ZAINABA','Youssouf','1966-12-31','','0 693 10 85 23','App 8 SIDR\r\n33 rue Lory les Bas','97490','Sainte Clotilde','',0,'Dr KAPLER','266209939714113',NULL,0),(78,'F','MONDIA','Marie Thérèse','1944-01-05','','0 692 14 87 22','Cité Monbolos, Moufia\r\n9, rue Picarbie','','','',161,'Dr. Ismaël Moussa','244019740780373',NULL,0),(79,'H','ROBERT','Maximin','1937-10-31','0 262 56 38 13','','22, rue Théodore Chasseriau\r\nApt. 3, Bat. 22','','Sainte Clotilde','',165,'Dr. Jean-Marc Hoarau','137109740600184',NULL,0),(80,'F','GRONDIN','KILIANE ELEONOR','1999-06-01','','0 692 60 47 33','','','','',0,'','269079741121591',NULL,0),(81,'H','MAILLOT','DIDIER MAURICE','1967-07-02','0 262 58 53 83','0 692 63 77 53','114, rue Nicolas Vabris','','Saint-André','',0,'Dr. Alain Pascisnore','167079741800347',NULL,0),(82,'H','MOIMBE','Irène','1944-12-28','','0 692 14 60 85','173, Impasse du centre','97440','Saint-André','',172,'Dr. Viel','144129742155134',NULL,0),(83,'H','PREVOST','Roger','1941-02-03','0 262 41 02 56','0 692 82 51 30','','','','',181,'Dr. Arnaud Leroy','141025900800911',NULL,0),(84,'H','TESTAN','Yvon Francis','1937-12-20','0 262 52 21 07','0692708163','','','Sainte-Suzanne','',0,'Dr. Remy Mamias','137129742000283',NULL,0),(85,'F','RAKOTONIAINA','Voahanginirina','1965-02-17','0 262 41 68 95','0 692 55 64 26','','','Saint-Denis','',0,'ANDRIANTAVY','265029933313056',NULL,0),(86,'F','MOUTOUSSAMY','Bakion','1926-10-02','0262282971','0 692 87 50 81','','','','',0,'Dr. Colette Morel','226109741812094',NULL,0),(90,'H','ATCHAMA','Yoland','1969-06-07','','0 693 90 41 00','','','Saint-André','',0,'Dr. Michel Say-Liang-Fat','169069740902782',NULL,0),(91,'H','EVRIN','Joseph Axel','1939-10-23','0 262 44 35 55','0 692 65 26 15','3, chemin de la Giroday','97411','Saint-Paul','',0,'Dr. Tamburini','139109741502976',NULL,0),(93,'F','GABARET','Christine','1958-11-06','0 262 53 90 29','0 692 74 34 09','','','','',0,'Dr. Jean-Yves Mari','258119740903957',NULL,0),(95,'H','PARVEDY','Johny','1962-02-18','','0 692 66 69 04','','','','',0,'','162029741131711',NULL,0),(96,'F','ROBERT','Marie Monique','1946-06-23','0262582095','0692616346','149 Lotissement barau Ravine Creuse \r\n','','St André','',0,'Dr Bonne','246069740901705',NULL,0),(97,'H','FLEURY','Denis Irenee','1941-10-12','','0 692 80 08 52','Appt 14 Bruniquel\r\n48 avenue de l\'usine','','Saint-Gilles-les-Bains','',0,'Dr Gueneau ','141109741500502',NULL,0),(98,'F','GRONDIN','Marie Odette','1950-11-10','0 262 51 40 03','','20 chemin terre Rouge','','La Montagne','',0,'Dr Chabas','250119740210412',NULL,0),(99,'H','SOLIMAN','Eugene','1945-12-12','','0 692 92 48 65','111 route de domenjod','','Sainte-Clotilde','',0,'Dr Torre','145129741184093',NULL,0),(100,'H','BOYER','Pierre','1941-11-15','','0 692 83 25 08','Piton Cailloux\r\n28 Chemin Canaka','','Sainte-Marie','',0,'Dr AH SING','141119741895149',NULL,0),(101,'H','ACENSI','Patrick','1961-12-25','0 262 73 06 39','0 692 540 496','','','','',0,'Dr. Philipe Dappadie','161129935227538',NULL,0),(102,'H','OLIVIER','Luce Ravily','1947-08-25','0 262 47 58 89','0 692 86 32 51','Chemin de la Mare Virapa\r\nMare à Citrons','97433','Salazie','',0,'Dr Laravine','236119742100632',NULL,0),(103,'H','LARAVINE','Alex Celestin','1940-12-15','0 262 47 18 16','','1 chemin vanille\r\nbras pistolet','','Sainte-Suzanne','',0,'Dr Pracisnore','140129782083207',NULL,0),(104,'H','CAZAL','Louis Aldo','1965-08-12','','0 692 20 32 96','13 rue benoit boulard\r\nbourbiers','','Saint-Benoit','',0,'Dr Ringassamy','165089741007142',NULL,0),(105,'F','DUCHEMANN','Marie Justine','1941-09-26','','0 692 50 72 30','','','Salazie','',0,'Dr Lemetayer','241099742141723',NULL,0),(113,'F','REMILIE','Marie Céline','1940-08-05','0 262 30 37 65','','','','','',0,'Dr I. PATEL','240089741404160',NULL,0),(114,'H','TANGA','Lucay','1972-07-27','0262 53 00 69','0 693 01 19 38','54, rue Emery Talvi','97438','Sainte-Marie','',0,'Dr  PONROUCH','172079741835928',NULL,0),(115,'H','GASNIER','YANNIS JOEL','1977-05-01','0262193888','0692492164','44 rue tessan \r\nResidence Couleur Vanille\r\nAppt 11 Ste clotilde','','Ste Clotilde','',0,'Dr Marc Azollin','177059407801495',NULL,0),(116,'F','LEBON','Tatiana','1960-07-24','','0692714637','La Montagne','','','',0,'Dr Maigrat',NULL,NULL,0),(117,'F','ACORIA','Marie Aurelia','1931-02-24','0 262 28 22 26','','','','Chaudron','',0,'Dr AKBARALY Moise','231029741604649',NULL,0),(118,'H','CHARRETIER','Pierre','1950-08-28','02 62 28 07 38','06 22 59 16 92','','','','',0,'',NULL,NULL,0),(119,'F','VIRAPIN-CAROUMBIN','Marie Jocelyne','1968-12-06','0 262 94 13 07','0 693 94 11 43','','','Sainte-Marie','',0,'Dr. Doumercq','268129741115190',NULL,0),(120,'H','ALEXIS','Jean Claude','1944-12-12','0 262 28 65 20','0 692 88 59 57','','','Sainte-Clotilde','',0,'Dr Kapler','144129741100507',NULL,0),(121,'H','ITARRE','Sully','1971-08-29','','0 693 03 03 75','','','Saint-Denis','',0,'Dr Olivier DUPUIS','171089741161943',NULL,0),(122,'H','GRONDIN','Luc','1947-02-17','','0 692 35 98 46','','','Sainte-Clotilde','',0,'Dr Marie Thérèse Low Hong','147029741101875',NULL,0),(123,'F','GROENDU','Marie Antoinett','1958-08-24','0 262 46 82 78','','','','Sainte-Suzanne','',0,'Dr Bertaut','158119742071967',NULL,0),(124,'H','CERVEAUX','Alain Joseph','1943-04-19','0262 44 01 32','0 692 94 72 72','','','Saint-Paul','',168,'Dr. Delanoix','143049741592552',NULL,0),(125,'F','SANDANOM','Lauriane','2007-01-20','0 262 53 47 90','0 692 24 24 68','','','','',0,'Dr Jaglale-letniowski Cyndie','176029741119925',NULL,0),(126,'F','ELLAMA','Angelina','1937-02-25','0 262 37 89 96','','','','Sainte-Marie','',157,'Dr. Jatob','237029741811613',NULL,0),(127,'F','MOUTOUSSAMY','ANNISE M NICOLE','1963-05-07','','0 692 87 90 32','','','','',0,'Dr. Eugène Marie Mahe','263059741113545',NULL,0),(128,'H','FONTAINE','Jean Jo','1947-03-22','0 262 50 90 33','0 692 88 32 55','','','Saint-Benois','',0,'Dr. Paul Marimouttou','147039740510587',NULL,0),(129,'F','LEBON','Marie Huguette','1960-07-24','0 262 48 00 16','0 692 71 46 37','','','','',0,'Dr. Maigrat','260079741210926',NULL,0),(131,'H','ROBERT','Louis','1955-08-23','0 262 58 17 66','','','','','',0,'Dr. Paoli','155089742046928',NULL,0),(132,'F','AMAVY','Christiane','1931-02-18','0 262 48 56 48','','','','','',0,'Dr. Michel Calmariane','231029742000666',NULL,0),(133,'F','DAMOUR','Edith','1947-09-28','','0 692 12 91 63','','','','',0,'Dr LEROY','247099741940394',NULL,0),(134,'H','LEBRETON','Camille Joseph','1934-05-15','','0 692 17 74 35','100 rue JEAN XXIII','97438','Sainte-Marie','',0,'Dr Daniel JATOB','134059741812456',NULL,0),(135,'F','LANGENIER','Marie Lucienne','1926-07-31','0 262 45 08 69','','','','','',0,'Dr KABAGEMA','226079740981806',NULL,0),(136,'F','BOYER','Suzette Thérèse','1933-11-23','0 262 23 6512','0 692 90 48 03','','','','',0,'Dr. Eric Alanne','233119741185320',NULL,0),(137,'F','GRAVINA','Anne','1955-12-11','','0 692 88 33 45','','','Sainte-Anne','',0,'Dr. Bonne','255129741005775',NULL,0),(138,'H','VITRY','Xavier','1928-12-10','','','EHPAD \"Le Moutardier\"\r\n15, Chemin Manès Beaulieu','97470','Saint-Benoit','',0,'Dr Duval -Le Moutardier','128129741701618',NULL,0),(139,'F','WOON-SHOO-TONG','Dolly','1967-09-06','0 262 26 05 49','0 692 66 83 96','','','','',0,'Dr marie Woon','267099741404114',NULL,0),(140,'H','DIJOUX','Guy Remy','1958-04-05','0 262 46 76 71','0 692 70 17 58','750 chemin Valendin','97440','Saint-André','',0,'Dr DYALL','158049740901519',NULL,0),(141,'F','LASSON','Isabelle','1938-12-26','0 262 26 73 49','0 692 24 12 72','','','','',0,'Dr. Lecaplain','238129741586052',NULL,0),(142,'F','NOEL','MURIELLE','1988-12-26','0 262 23 78 35','0 693 91 29 43','','','','',0,'Dr. Fechner','288129741163977',NULL,0),(143,'H','ESPERANCE','Laurent','1928-09-01','0 262 53 55 26','0 692 8560 57','','','','',0,'Dr. Hamon','128099741103039',NULL,0),(144,'F','PASCUAL','Nadine','1958-08-21','0 262 13 00 70','0 692 90 76 57','','','','',0,'','154029933308412',NULL,0),(145,'H','MARIMOUTOU','Albert','1963-05-27','','0 692 97 45 66','','','','',0,'Dr. Roselyne Payet','163059741012142',NULL,0),(146,'F','ROBERT','Marie Louise','0000-00-00','','','','','','',0,'',NULL,NULL,0),(147,'F','BOUTMEZ','Herminie Nelcie','1940-06-23','','0 692 18 06 64','','','','',0,'Dr. Bruno Cadet','240069742025225',NULL,0),(148,'F','LARAVINE','Ange','1943-10-14','','0 692 57 75 37','','','','',0,'Dr. Francis Colin','243109741501241',NULL,0),(149,'H','ODULES','JEAN FELIX','1955-08-04','0 262 44 36 22','0 692 82 42 39','','','Saint-Marie','',0,'Dr. Gaëlle Lagarigue','155089741502738',NULL,0),(150,'H','AMOURGOM','Francis','1940-10-09','0 262 46 83 59','0 692 51 18 54','','','','',0,'Dr Dabee','140109740984570',NULL,0),(151,'F','MALBROUQUI','Andrée','1934-05-25','0 262 30 26 94','','30 cité Océan Montgaillard','97400','Saint-Denis','',0,'','234059741100742',NULL,0),(152,'F','DUGAIN','Marie Aurélia','1931-12-20','0 262 51 43 18','0 692 69 91 93','','','','',0,'','231129740602644',NULL,0),(153,'F','TESTAN','Eliane Marcelle','1942-04-13','0 262 52 21 76','','','','Sainte-Suzanne','',0,'Dr. Bruno Cadet','242049742015688',NULL,0),(154,'H','BOYER','Theresien','1933-12-17','','0 692 53 78 38','','','Sainte-Rose','',0,'Dr Pauvert','133129741701862',NULL,0),(155,'F','HONORINE','Marie Lucia','1962-11-26','0 262 45 08 36','0 692 67 66 78','','','Saint-Paul','',0,'Dr. Ythier','159109742324793',NULL,0),(156,'H','BREZE','Georges','1960-11-06','','0 692 17 78 08','','','','',0,'Dr Corouge','160119741003184',NULL,0),(157,'H','OLIVIER','Raphael','2011-04-18','069277 66 18','','','','','',0,'Dr Pastor/Dr Delnard','162117521300814',NULL,0),(158,'H','JEBANE','Jean Paul','1959-07-17','0 262 50 49 40','','Maison de retraite les moutardiers st benoit','','','',0,'Dr Duval','159079741006931',NULL,0),(159,'F','VARONDIN','Marie','1941-02-04','0 262 29 26 94','0 693 94 99 14','','','Sainte-Clotilde','',0,'Dr Gilbert BOYER','241029741104006',NULL,0),(160,'H','DORIQUE','jean Marin','1951-03-03','0262592058','0692768414','Le Port','','','',0,'Dr Omarjee/Dr Lai fat Fin','151039741300740',NULL,0),(161,'F','NATAN','MELANIE','1939-07-14','0262517188','0692259386','Ste Clotilde','','','',0,'Dr S.Goburdhun','239079741102505',NULL,0),(162,'F','DRULA','Denise Marlene','1951-09-06','0 262 41 58 08','0 692 15 17 45','Bellepierre','','','',0,'Dr Lebihan','251099741107182',NULL,0),(163,'F','TAOCHY','marguerite','1923-08-26','0262303595','','St Denis camelias','','','',0,'Dr Taochy','125029740402694',NULL,0),(164,'H','POINAPIN','Rosaire','1964-04-15','0 262 58 33 40','0 692 61 24 73','','','Sainte-Suzanne','',0,'Dr. Hoosenbocus','164049741127386',NULL,0),(165,'H','PAVADE','JOSEPH RICHEMON','1945-09-05','0262475536','','Salazie','','','',0,'Dr Fouassin','145099742140286',NULL,0),(166,'H','DALLEAU','Moise','1948-12-24','0 262 46 56 20','0 692 67 29 37','','','Bras Panon','',0,'Dr Divi','148129741895311',NULL,0),(167,'F','FOREAU','Marie Edith','1942-03-25','0 262 72 02 47','0 692 82 76 79','','','Bras Panon','',0,'Dr Rida','242039741810685',NULL,0),(168,'H','LEBON','Jean Yves','1956-05-22','0262480016','','La Montagne','','','',0,'dr Maigrat',NULL,NULL,0),(169,'H','ATCHIAMA','Jean Christian','1955-07-25','','0 692 68 93 95','Ste Suzanne','','','',0,'Dr. Der Kasbarian','155079742039784',NULL,0),(170,'F','LEBON','Marie Therese','1932-05-24','0262238535','0692824112','la montagne','','','',0,'Dr Colomb','232059740304452',NULL,0),(171,'F','MOREAU','LUCETTE MARIE','1948-10-16','0262475438','','salazie','','','',0,'Dr Fouassin et rahoelina','248109742180386',NULL,0),(173,'F','MOUCOUVEIA','Marie Renette','1956-09-21','0262465849','0692564399','St André','','','',0,'Dr Goeury/ISIS Médical','256099740225718',NULL,0),(174,'F','KAROUMBATA','Helene','1934-08-18','0 262 92 94 12','0 692 24 75 78','','','Saint-André','',0,'Dr. Virapoullé','234089740902634',NULL,0),(175,'F','JANOLAT','MARIE ROSE LUCE','1947-05-21','0262422350','0692586215','','','Le Port','',0,'Dr Zimny BOUSSER Marielle','247059741107219',NULL,0),(176,'F','ALIDINA','Rosemine','1960-05-04','0262923745','0692788038','','','Saint Denis','',0,'Dr Leveque dr Genin','260059933340871',NULL,0),(177,'H','MANORO','Gabriel','1942-08-31','0262904242','0692684951 IDE','EHPAD Croix Rouge Francaise\r\nSt Denis','','Saint Denis','',0,'Dr hallet/Dr jean Pierre CATTEAU','142089741189326',NULL,0),(178,'F','SADON','Marie Roseline','1956-04-28','','0 692 53 85 79','ste Rose','','Ste Rose','',0,'Dr Anna  Tcheremkhovitch','256049741806340',NULL,0),(179,'H','PARES','Jordy','1984-08-02','0262203585','0693709907','St André','','St Andre','',0,'Dr Janson Dr Degasnes','184083403201880',NULL,0),(180,'H','CHANE KOA','Chan Yai Wa','1952-11-05','','0693971274','','','Ste Clotilde','',0,'Dr Marone','152119933386357',NULL,0),(181,'H','SIDAT','Cassim','1948-04-13','0262200406','0692383592','','','St Denis','',0,'Dr Bobate','148049741200739',NULL,0),(182,'F','SIDAT','Khateejan','1948-11-24','0262200406','0692383592','','','Saint Denis','',0,'Dr Moussa','248119741101526',NULL,0),(183,'H','BOURDIN','Julien','1980-07-02','0 262 73 02 97','0 692 74 39 39','','','','',0,'',NULL,NULL,0),(184,'H','THIONVILLE','Mathieu Yannis','1983-01-01','0262536807','0692515211','','','Ste Marie','',0,'Dr Calichama','183019741101346',NULL,0),(185,'F','HOAREAU','Ines Marie','1931-12-11','0 262 52 34 48','0 692 85 79 41','Commune Argo\r\n3 chemin des Pamplemousses','97441','Ste Suzanne','',0,'Dr Welmant','231129741102589',NULL,0),(186,'F','JEAN BAPTISTE','Marie Michelle','1954-09-05','0262219542','','','','St Denis','',0,'Dr Chane woon Ming et Dr chabas','254099742133946',NULL,0),(187,'H','COMBRESSAMY','Ludovic','1977-04-17','','0 692 61 12 03','','','St Denis','',0,'Dr bureau SOS Médecins','177049741138912',NULL,0),(188,'F','HASSANALY','Samina','1959-03-29','0262215767','','','','Sainte Clotilde','',0,'Dr Corchinoux ','259039933321389',NULL,0),(189,'H','HASSANALY','Rossanaly','1938-10-25','0262215767','0692252750','','','Ste Clotilde','',0,'Dr Goulam Abasse','138109933329336',NULL,0),(190,'H','TEVANE','Nicolas','1924-04-25','0262504940','','','07400','St benoit','',0,'Dr Duval','124049742003871',NULL,0),(191,'F','AUMEER','Noorjahan','1969-06-21','0023054978426','0023057746370','','','','',0,'Dr Reesaul',NULL,NULL,0),(192,'H','SELLY','Hubert','1945-11-02','0 262 50 27 98','0 692 18 52 34','','','St Benoit','',0,'Dr Dallel et Koenig','145119741101529',NULL,0),(193,'F','ALAISE','Daniela Marie','1971-03-26','0262715330','0692 14 76 65','','97411','Saint Paul','',0,'Dr. Mete','271039741520909',NULL,0),(194,'F','HOAREAU','Marie Helene','1947-03-16','0262503118','','','','St Benoit','',0,'Dr Say Liang Fat','247039741000980',NULL,0),(195,'F','SAUTRON','Eva Marie Therese','1956-12-11','','0692965656','','','Bras Panon','',0,'Dr Omarjee','155099740223146',NULL,0),(196,'F','GISQUET','Marie Georgette','1948-08-30','0262485922','0692180914','','','bagatelle ste Suzanne','',0,'Dr Bruno Cadet','248089742035943',NULL,0),(197,'H','DELNARD','Gerald','1946-08-27','0262443005','0692229657','','','St Paul','',0,'Dr Delannoy','146089741592962',NULL,0),(198,'H','SINAPAN','Lucien','1938-02-02','0262534822','','','','Ste Marie','',0,'Dr Laurence LEGROS','138029741809040',NULL,0),(199,'H','GOVINDIN','Augustin','1942-03-29','0 262 97 62 74','0 692 88 16 58','','','Ste Marie','',0,'Dr Axel Kichenin','142039741810737',NULL,0),(200,'F','LIN-SI','Emmanuelle','1991-06-20','','','','','','',0,'','291069741129482',NULL,0),(201,'H','PICARDO','Marc','1934-10-05','0262410733','0692439374','','','Bas de la riviere','Saint Denis',0,'Dr Lee Kien On','134109741100577',NULL,0),(202,'H','VIENNE','Joseph','1926-01-07','0 262 53 61 90','0 692 02 98 26','','','0692720476','ste Marie',0,'Dr Mari Dr Kichenin,Cardiologue','126019741680851',NULL,1),(203,'F','NUMA','Anne Marie','1926-05-09','0262105184','','St clotilde','','','',0,'Goburdhun','226059741103023',NULL,0),(204,'H','ROBERT','Max Daniel','1967-08-03','','0692451096','Saint Denis','','','',0,'Dr Patel','167089741104933',NULL,0),(205,'H','MAILLOT','Jean-Pierre','1958-11-28','0262478217','','','','','',0,'Dr Stephane FOUASSIN','158119741809968',NULL,0),(206,'H','MAILLOT','NARCISSE FRANCOIS','1938-07-30','0262479084','','Mare a Martin\r\n18, impasse des Gerberas','97433','Salazie','',0,'Dr Séverin Gérard','138079742105070',NULL,0),(207,'F','VOULAMALE','Viviene','1936-10-12','0 262 52 10 04','','','','Ste Suzanne','',0,'Dr Bruno CADET','236109742015492',NULL,0),(208,'F','PARIS','Marie Daniela','1972-11-03','0262467479','0692470830','St Benoit','','','',0,'Dr Marimoutou Suzelle','272119741105373',NULL,0),(209,'F','TAMADOUM','KAREN MARIE','1990-06-09','0 262 30 73 21','0 692 80 49 15','','','Saint-André','',0,'Dr. Law Lane','290069741126563',NULL,0),(210,'F','MOREL','Rose Marie','1950-06-11','','0692784776','','','St Joseph','',0,'Dr Fun Yan Yuen ','250069741204183',NULL,0),(211,'F','CASSIM','Rasoul','1951-04-30','0262410003','0692617916','','','st Denis','',0,'Dr Pierron','251049741123433',NULL,0),(212,'H','LEBON','Noe','1942-01-11','0 262 28 97 38','','Moufia','','Ste Clotilde','',0,'Dr Deboisvilliers','142019741102506',NULL,0),(213,'H','TANGAPRIGANIN','Charles','1949-08-30','0262941545','','','','la Montagne','',0,'Dr Allane','149089741191846',NULL,0),(214,'F','LARAVINE','Marie Gillette','1939-11-29','0 262 48 53 49','0 692 30 49 67','','','St Denis','',0,'Dr Eric Bourdais','239119741583809',NULL,0),(215,'F','CORBIERE','Marie Josiane','1952-05-27','0262235436','','','','la Montagne','',0,'Dr Ramilison','252059741133791',NULL,0),(216,'F','MOUNIAPIN','Sabrina','1974-09-06','0 262 46 76 30','','','','Q.Francais','',0,'Dr Mesai','274099740903125',NULL,0),(217,'F','CLAIN','Marguerite','1928-02-03','','0693427082','','','saint denis','',0,'Dr Doussaud','228029741402088',NULL,0),(218,'H','RACOUTE','Augustin','1935-06-19','0 262 44 50 86','','','','St Paul','',0,'Dr Tamburini','135069740204597',NULL,0),(219,'H','GOBELIN','Michel','1957-09-26','','0 692 74 70 62','','','Ste Clotilde','',0,'Dr Ripault','157099741142368',NULL,0),(220,'H','GRONDIN','Henri Claude','1958-04-14','','0692870993','','','La Bretagne','',0,'Dr Etienne Sery','158049741803520',NULL,0),(221,'F','DELETRE','Marie Claude','1963-05-02','0262239599','0692 73 19 12','La Montagne','','','',0,'Dr Allane Eric','263059741101964',NULL,0),(222,'H','MOUCOUVEIA','Emile Pierre','1976-09-27','','0 692 89 16 28','StAndre','','St Andre','',0,'Dr Gouery ','176099741821508',NULL,0),(223,'F','SAUTRON','Berthe','1935-10-05','0262217349','0262886375','','','saint Denis','',0,'Dr Andriantavy','235109740708320',NULL,0),(224,'H','SAUTRON','Jules','1926-02-09','0262217349','0262886375','','','St Denis','',0,'Dr Andriatavy','126021106901314',NULL,0),(225,'F','MONTFORT','Monique','1960-05-23','0262101822','0692136015','Mes Devant Taille la main\r\n2, rue de la base  Chez mmonfortteddy\r\n95490 Vaureal','95490','vaureal','',0,'Dr Bourdais','157039741128909',NULL,0),(227,'H','GAUDENECHE','Roger','1940-07-25','','0 692 70 67 73','','','','',0,'Dr. F. Mete','140073854401742',NULL,0),(228,'F','MARIONNETTE','Mimose','1944-06-16','0262234583','0692386740','La montagne','','la montagne','',0,'Dr Richard Ramilison','244069741182907',NULL,0),(229,'F','RAMALINGOM','MARIYAE','1929-04-24','0692769506 ambulance','0692477908','Bras Panon','','','',0,'Dr Ferroul','229049741001403',NULL,0),(230,'F','DE VILLEPRE','Marie Laurence','1931-08-22','0262460670','0692','Stev Suzanne','','Ste Suzanne','',0,'Dr thierry Pauvert','131129742004048',NULL,0),(231,'F','MARCELIN','Patricia','1965-01-30','','','','','','',0,'','265019741529192',1,0),(232,'H','LERIVAIN','Melrick','1996-08-14','','0692555868','bellepierre','','Bellepierre','',0,'Dr Nguyen','196089740785263',NULL,0),(233,'F','HULIN','Thomas','1973-12-01','','0692872946','','','','',0,'',NULL,NULL,0),(234,'F','PEROUMAL-ELLAMA','Ange Marie','1933-12-14','0 262 53 45 81','','','','','',0,'','233129742011915',NULL,0),(235,'F','PITOU','Jeannine','1950-01-23','0 262 46 67 37','','','','','',0,'Dr Arnaud SATSOU','250019741608137',NULL,0),(236,'H','LASANTE','Serge','1965-08-26','0262091905','0 692 69 56 04','','','','',0,'Dr LEVEQUE/Dr Checkouri Gastro','165089922305090',NULL,0),(237,'F','OLLIVIER','Jeanne','1928-02-16','0262538718','0692859503','','','','',0,'Dr Satsou','228029742108210',NULL,0),(238,'F','RAKOTOMALALA','Ursula Marie','1973-01-31','0 262 68 11 88','0 692 26 38 59','','','','',0,'Dr. Andriatavy','273019933307195',NULL,0),(239,'F','JULLIAN','fanny','1923-01-26','0262235524','','','','le guillaume','',0,'','223019741500511',NULL,0),(240,'F','VOISIN','Marie Sylvie','1963-07-11','0262280948','0692630885','','','Saint Denis','',0,'dr Ah Sing','263079741122584',NULL,0),(241,'F','BOYER','marie paula','1924-12-24','','0692 64 58 03','le brulé','','','',0,'Dr Bocquel','224129741183411',NULL,0),(242,'F','ASENSIO','Jacqueline','1942-03-09','0262 41 35 02 ','0692 67 22 17','','','saint denis','',0,'Dr GUILBAUD','136059213400896',NULL,0),(243,'H','TESTAN','Joseph Marcel','1933-10-12','0262 98 04 62','','','','Ste Suzanne','',0,'  Bruno Cadet ','133109741100133',NULL,0),(248,'F','RIVIERE','Francois','1939-12-13','0262889717','0693929470','','','','',0,'Dr Jean kapler','139129740304663',NULL,0),(249,'F','GOASGUEN','Marie Pierre M','1965-11-02','0262553912','0692880998','','','','',0,'Dr Maillot','265116015900502',NULL,0),(253,'H','BEGUE','Milo','1927-03-16','0262280908','','SOS Oxygene','','','',0,'Dr Mahe','127039740804963',NULL,0),(254,'F','TREPORT','Marie Mimosette','1959-08-15','0 262 23 93 74','0 692 475805','28, chemin Motocross','97417','La Montagne','',0,'Dr Bordier','259089741125968',NULL,0),(255,'F','PONAMA','eglantine','1962-02-13','0262526031','0692804060','','','','',0,'Dr LEVEQUE','262029741006549',NULL,0),(258,'F','SERY','Marianne','1966-02-12','0262514354','0692329720','','','','',0,'Dr Charles RABEZIAKA','163089740606572',NULL,0),(259,'F','PAYET','CLAUDE GILBERTE','1952-02-02','0262720278','0692648773','Ste Marie','','','',0,'Dr Ponrouch','252029741102366',NULL,0),(260,'H','BOYER','Joseph lucien','1913-09-15','0262414821','','St Denis','','','',0,'Dr S.Megali','113099741900772',NULL,1),(261,'H','LEPERRE','JOSEPH ANTOINE','1927-01-04','0262243418','0692878834','','','St Gilles les bains','',0,'Dr Thill','127019840106603',NULL,0),(262,'H','FIGARO','Bruno','1949-10-06','','0 692 94 28 13','','','','',0,'Dr razakasoa','149109960412175',NULL,0),(263,'H','SALAMALA','Albert','1921-06-26','0262212264','0692807286','Respidom','','Le Brulé','',0,'Dr Chabas','121069840534872',NULL,0),(270,'F','AMACOUTY','marie angele','1939-10-13','','0692782598','St Denis','','','',0,'Dr Bourdais','239109741100672',NULL,0),(271,'F','NATIO','Noela','1932-01-25','0262556001','','St Paul','','','',0,'Dr Glorieux','232019741583303',NULL,0),(272,'F','MERALY','Parina','1971-04-17','','','','','','',0,'Dr Goburdhun','271049933313580',NULL,0),(273,'F','FATIMABA','Kamiza','0000-00-00','','','','','','',0,'',NULL,NULL,0),(275,'F','SELEMANY','rose','1946-09-18','','0693928486','','','','',0,'Dr Marone','141059742020458',NULL,0),(277,'F','DEJEAN','Almeriane','1928-04-02','0262539050','','','','','',0,'Dr Torre','228049741402914',NULL,0),(278,'H','BADOURALY','DILAVARHOUSSEN','1941-05-23','0262688195','0692182046','','','','',0,'Dr Dhunnoo','141059933347119',NULL,0),(280,'F','OLINARD','Marie Eveline','1941-09-24','','0692586261','ISIS','','','',0,'Dr HITIER','241099742340374',NULL,0),(281,'H','AKHOONE','Sulliman','1933-07-22','0262216904','','','','st Denis','',0,'Dr Issac Ismael','133079741102558',NULL,0),(282,'H','BELAIR','paul','1939-02-06','0262569158','','ISIS','','Ste Clotilde','',0,'Dr Jean SERGE','139029741100196',NULL,0),(283,'H','RIBOD','Christian','1949-07-22','0262480162','0692082427','','','St Francois','',0,'Dr. Winteller','149070105313679',NULL,0),(287,'F','FIGARO','marie josephe','1944-09-20','','O692942813','','','','',0,'DrRAZAKASOA','244099933367867',NULL,0),(293,'H','VALERY','Lucas','1940-06-23','0262247364','0692300076','','','','',NULL,'Dr Moreau','140069742025968',NULL,0),(298,'H','THOMAS','Antonin','1934-08-01','','0692795745','','','','',NULL,'Dr Vittori/SEPRODOM','134089741581783',NULL,0),(307,'H','HOARAU','Jacques Nelo','1958-11-11','','0 692 52 54 80','','','','',NULL,'Dr lajat','158119741928150',NULL,0),(309,'H','MASSEAUX','Bernard','1942-05-26','0262468579','0692052606','','','','',NULL,'Dr Kapler','142059741185516',NULL,0),(310,'F','MAUNIER','Jacqueline','1956-10-19','','0 692 95 56 15','','','','',NULL,'Dr Labussiere','256109741129121',NULL,0),(314,'F','FOUREZ','MIE JOSSELINE','1965-04-30','0 262 91 04 15','0 692 70 13 40','','','','',NULL,'Dr Alice Pelerin','265049740715531',NULL,0),(316,'H','OLIVIER','Antoine Roger','1940-04-29','0262475002 Ambulance','0 262 47 52 32','','','Salazie','',NULL,'Dr Fouassin','140049742182522',NULL,0),(318,'F','RAJAONARISOA','Olive','1967-09-17','0262210566','0692391951','','','','',NULL,'Dr RAZAKASOA','267099933318515',NULL,0),(319,'H','MADELEINE','Pierre','1932-12-03','','0 692 12 30 60','','','','',NULL,'Dr Jean Michel AZAIS','132129740804662',NULL,0),(320,'F','THIAN MENG','M Francine','1925-10-21','0262298377','0693971597','','','','',NULL,'Dr Doussaud','225129742203345',NULL,0),(322,'F','MURCY','Odile','1950-12-05','0 262 88 18 92','','','','','',NULL,'Dr Ibrahim PATEL','250129742274647',NULL,0),(324,'H','VELLAYE','Edmond','1933-11-22','0262536033','','','','','',NULL,'Dr Hallet/Dr Leonard','133119741102426',NULL,0),(325,'F','BOTO','Colette','1959-05-25','0262454992','0692781021','','','','',NULL,'Dr Lai Fat Fin','150099960406566',NULL,0),(326,'H','NOURRY','Louis André','1942-02-05','','0 692 74 19 07','','','','',NULL,'Dr Chistian Bertucchi','142029741301074',NULL,0),(329,'F','BAILLIF','Odette','1970-04-08','','0 692 73 52 76','','','Sainte-Suzanne','',NULL,'Dr. Lucien Bonne','270049742009538',NULL,0),(330,'H','ALHADI','Abrazi Ibrahim','1973-12-20','','06 39 05 06 55','','','','Mayotte',NULL,'Dr. Noel (Mayotte), Dr. Isaac (Saint-Denis)',NULL,NULL,0),(331,'H','CARPIN','Jean Kleber','1969-07-10','0262283793','0692284442','200B rue Gabriel Macé\r\nLa Bretagne','97490','Saint-Denis','',NULL,'Dr Eric bourdais','169079741116990',NULL,0),(332,'H','BOYER','Justin Antoine','1944-06-01','','0692333841','','','','',NULL,'Dr Pierre BERNARD','144069741795443',NULL,0),(333,'F','DOBARIA','Marie Expedite','1961-12-26','0262435862','0692508161','','','','',NULL,'Dr OMARJEE et Dr Dijoux','261129740850968',NULL,0),(334,'F','LUI HIN TSAN','Rose Marie','1926-06-10','0 262 20 09 73','','','','','',NULL,'Dr Chabas','226069741301492',NULL,0),(335,'F','RAMCHELAWON','Marie Pierre','1946-06-02','','0 692 55 16 26','1 Ter rue de la Carière','97441','Sainte-Suzanne','',NULL,'Dr. Pourouch','246067718600470',NULL,0),(336,'H','GRAVINA','Marie Joseph','1949-07-02','0 262 50 04 52','0 692 90 12 69','2, rue des petits vias','','Saint-Benoît','',NULL,'Dr. Philippe Koenig','149079741001194',NULL,0),(338,'H','DELETRE','Philippe','1947-03-11','0 262 53 51 26','0 692 86 29 60','24, rue Gillot Egat du parc','','Sainte-Marie','',NULL,'Dr. Pourouch','147039741102584',NULL,0),(340,'F','ABELARD','Louisette Marie','1962-03-29','','','','','','',NULL,'Dr OMARJEE / Dr GERARD','262039742113157',NULL,0),(344,'H','ALI MAHOMED','NOURAGUELA','1957-06-26','','','','','','',NULL,'','156059933333205',NULL,0),(345,'H','ATCHAMA SAGALOU','JEAN','1962-01-02','0262719117','0692869214','','','','',NULL,'','162019741501382',NULL,0),(346,'F','FONTAINE','MARIE CHANTALE','1963-02-24','','','','','','',NULL,'','263029741412712',NULL,0),(349,'F','MADELEINE','MARIE-NICOLE','1943-12-17','','','','','','',NULL,'','243129741103870',NULL,0),(350,'F','PHILIPPEAU','MARIE LISETTE','1952-10-09','','','','','','',NULL,'','252109939041389',NULL,0),(352,'H','PAQUIRY','Roger','1931-08-06','0262522174','0692937237','','','','',NULL,'Dr Nadia RAMASSAMY','131089742002004',NULL,0),(356,'F','ELEONORE','Emilia Josée Marlene','1943-07-07','0 262 41 46 21','','','','','',NULL,'Dr LEBIHAN','140059741102076',NULL,0),(357,'H','PAPAYA NARASSOUMOULOUNAID','Germain','1945-06-26','0 262 46 46 33','','','','','',NULL,'Dr Vally','145069740983166',NULL,0),(363,'F','POSEE','Blanche','1924-01-01','0 262 98 94 41','','','','','',NULL,'Dr Mosello','224019742193318',NULL,0),(364,'H','GIRAUD','Eric','1959-12-31','0262243578','0692030110','','','','',NULL,'Dr Negrel','159127835900881',NULL,0),(369,'H','BACCO','Alix','1963-08-16','','0693902330','','','','',NULL,'Dr. Doussaud','163089741128986',NULL,0),(370,'H','WEISBROD','Eric','1942-05-25','0 262 46 32 20','','Rue du stade','97440','Saint-André','',NULL,'Dr. Leroy','142052435202825',NULL,0),(371,'F','IMIZE','Marie Sylviane','1956-04-02','0262412205','0692567446','','','','',NULL,'Dr Rochat','256049740809715',NULL,0),(379,'H','HOAREAU','Louis','1935-04-28','0 262 50 27 14','0 692 61 86 24','','','','',NULL,'Dr. Jean Paul Moreau','135049741000262',NULL,0),(386,'H','AYOUBA ABDOU','Mohamed','1977-12-31','','0692482366','','','','',NULL,'Dr. Goburdhun','177129939704871',NULL,0),(390,'F','VELNA','Mathilde M France','1939-01-30','0262941760','','','','','',NULL,'Dr Patel','239019740401334',NULL,0),(392,'H','JIBASSIA','Jules','1939-10-06','0 262 46 27 21','','','','','',NULL,'Dr Vinguetama','139109740203671',NULL,0),(396,'F','CADET','Marie France','1954-09-09','','0692657254','','','','',NULL,'Dr Fontaine','254099741100303',NULL,0),(397,'H','CADET','Nicole','1952-11-06','0262729805','0 692 65 54 95','','','','',NULL,'Dr Eric FONTAINE','152119741202930',NULL,0),(399,'F','LOUISE','Raymonde','1946-04-20','','0692921403','','','','',NULL,'Dr Michelle LE BIDAN','246049740815856',NULL,0),(400,'F','VELOU','Jeanne','1930-08-17','0262317024','0692244548','','','','',NULL,'DR DE KASBARIAN','230089742022292',NULL,0),(403,'F','AUBRAS','Marie Lise','1958-03-02','','0692 96 10 73','','','','',NULL,'Dr Omarjee/Dr Morel','258039741301131',NULL,0),(405,'H','JONIN','Stephane','1946-03-25','0262598006','0692 96 05 88','','','','',NULL,'Dr Lai Fat Fin','146034419003140',NULL,0),(406,'H','AUGUSTIN','Jean Michel','1936-05-07','0262558265','0 692 89 34 48','','','','',NULL,'Dr Josette Fournier','136059741500966',NULL,0),(411,'H','MAILLOT','Sébastien','1979-05-31','','0 692 79 56 94','','','','',NULL,'Dr. Taochy(Sainte-Suzanne)','179059741168126',NULL,0),(412,'F','ARDIALE','Eleonore','1985-04-05','','0 692 05 67 97','','','','',NULL,'Dr. Plumier (Aix-En-Provence)','285049741110152',NULL,0),(413,'H','SANS','Julien','1949-07-24','0 262 91 30 34','0 692 50 50 10 (fils','','','','',NULL,'Dr Omarjee','149070915800446',NULL,0),(414,'H','LEVENEUR','Jean Baptiste','1931-06-22','0262471105','0693901515','Chemin Chapelle','97441','Sainte-Suzanne','',NULL,'Dr RAY','131069742201019',NULL,0),(415,'H','MICHAUD','Christophe','1944-06-09','0262300139','0692122638','','','','',NULL,'Dr Bocquel','144069740725374',NULL,0),(416,'H','LARTIN','Urbain','1926-11-07','0 262 21 63 35','','','','','',NULL,'Dr. Patel','126119741500277',NULL,0),(417,'F','CRESCENCE','Marie Risla','1957-01-14','0 262 26 84 03','0 692 36 91 12','','','','',NULL,'Dr Philippe MAS','257019741515142',NULL,0),(423,'H','ABDALLAH','Ahmed','1959-10-11','0 262 50 60 07','0 692 73 50 33','','','','',NULL,'Dr. Roseline Payet','159109939700987',NULL,0),(426,'F','PAPAYA NARASSOUMOUDAIDOU','Marie Jocelyne','1951-11-03','0 262 46 46 33','','','','','',NULL,'Dr Vally','251119740957261',NULL,0),(429,'F','SAGOUBY','MARIE GUYLENE','1963-02-15','0262470027','0692515783','','','','',NULL,'Dr Jean Jacques BRUNET','263029740905738',NULL,0),(430,'F','BOYER','Marie Anise','1966-06-13','','0692675187','','','','',NULL,'Dr VANNOOTE','266069741008789',NULL,0),(432,'H','MOHAMED','Ousman','1966-02-17','0 262 28 77 52','0 693 90 69 24','','','','',NULL,'Dr Bobate','166029741131115',NULL,0),(434,'H','GRONDIN','Joseph','1940-11-19','','0 692 28 97 00','8, rue Raoul Follereau\r\nAppt. 8, Bat. C\r\nRuisseau Blanc','97417','La Montagne','',NULL,'',NULL,NULL,0),(436,'H','KASSAMALY','Mounice','0000-00-00','0 262 23 43 47','0 692 691 066','','','','',NULL,'',NULL,NULL,0),(437,'H','ANASTHASIE','Francis','1938-09-26','0 262 23 78 82','','','','','',NULL,'Dr. Allane','138099741104321',NULL,0),(439,'F','MAILLOT','Kenza Elisabeth','2004-02-08','0262297572','0692436849','','','','',NULL,'Dr Grevelynche','161099741131973',NULL,0),(440,'H','MAILLOT','Henri','1932-03-17','0 262 31 85 07','','','','','',NULL,'Dr Deboisvilliers','132039741102345',NULL,0),(447,'F','LOUISE','Aurélie','0000-00-00','','0692921403','','','','',NULL,'',NULL,NULL,0),(448,'H','M\'BOLA','Joseph Marcel','1941-05-18','0262177844','0692739713','','','','',NULL,'Dr Patrick VINCENT','141059741400351',NULL,0),(450,'F','TARBY','Simone','1942-02-17','','','','','','',NULL,'','246029741300626',NULL,0),(454,'F','REBECCA','Marie Chantal','1963-12-05','','0692591489','','','','',NULL,'Dr Ramassamy Margarette','263129741109503',NULL,0),(455,'F','ARMOUGOM','Ghislaine','1946-09-12','0262412620','06922O3260','','','','',NULL,'Dr Ssi Yan kay','246099741104661',NULL,0),(456,'H','QUEMENER','Roger','1939-01-12','0613108206','0 692 01 83 10','','','','',NULL,'Dr ISSAC ISMAEL/DR MOULS','139012916300243',NULL,0),(457,'H','ZITTE','Camille','0000-00-00','0262598451','','','','','',NULL,'',NULL,NULL,0),(458,'F','METANIRE','Marie Viviane','1949-04-03','0 262 33 62 78','0 693 04 75 29','','','','',NULL,'Dr Sabatier','249049741500447',NULL,0),(459,'H','DOBARIA','Jean Sébastian','1988-06-28','0262435862','0 692 40 69 92','','','','',NULL,'Dr ATLAN-DIJOUX Stéphanie','188069740723768',NULL,0),(460,'H','TESTAN','Maurice Virgile','1936-09-22','0 262 22 27 60','0262221027','','','','',NULL,'Dr. Lacaze','136099740808570',NULL,0),(462,'H','DUCHEMANN','Nathan','2007-11-01','','0 692 88 68 65','','','','',NULL,'Dr. FROTTIER Dominique','274107816004259',NULL,0),(464,'H','MAILLOT','Mario','1961-09-18','0262297572','06923255045','','','','',NULL,'Dr van Grevelynghe','161099741131973',NULL,0),(466,'F','GISTA','Florence','0000-00-00','','0692439545','','','','',NULL,'',NULL,NULL,0),(467,'F','GAMALEYA','Erika','1980-06-02','','0692733031','','','','',NULL,'Dr CHABAS','280069741103903',NULL,0),(470,'F','JISTA','Florence','1963-02-16','0262230259','0692439545','','','','',NULL,'Dr Cole Rocher',NULL,NULL,0),(471,'F','MALEK RASSOUL','Fatma','1948-09-25','0262299019','','','','','',NULL,'Mohamed Ikbal BOBATE','248099933398549',NULL,0),(472,'H','HOARAU','Antoine','1937-08-07','0 262 20 10 85','0 692 52 48 81','','','','',NULL,'Dr BEHARY-LE BIHAN','137089741104354',NULL,0),(475,'F','LAMBES','Bernadatte','1944-04-16','','0 692 68 62 24','','','','',NULL,'Dr BESNARD','244049740815263',NULL,0),(476,'H','TIEFFENBACH','Léon Lucien','1938-07-20','0 262 22 80 46','0 692 87 97 55','','','','',NULL,'Dr. Thierry MAILLOT','138079933312361',NULL,1),(477,'H','BOYER','LUCIEN','0000-00-00','0262414821','','','','','',NULL,'',NULL,NULL,0),(479,'F','DELMONT','Andy Risla','1942-02-26','','0 692 37 26 02','','','','',NULL,'Dr. Richard Pierrat','242029741582522',NULL,0),(480,'F','BOYER','Celiane Marie','1938-04-05','','0692105981','41, chemin de la Comete\r\nSaint-François','97400','Saint-Denis','',NULL,'Dr I.PATEL','238049741107454',NULL,0),(481,'F','DUCHEMANN','Naomi','2003-07-02','','0 692 88 68 65','','','','',NULL,'Dr. Dominique FROTTIER','274107816004259',NULL,0),(482,'H','CARPAYE','Christian','1938-06-05','0 262 28 02 56','0692 70 06 48','','','','',NULL,'Dr. Chane Wai Nam','138069741106449',NULL,0),(484,'F','CANAGUY','Najlaa','1987-07-31','0 262 51 61 48','0 692 23 41 48','','','','',NULL,'Dr. Jaglale','287079741182158',NULL,0),(485,'H','SAUTRON','Andre','1926-08-18','0262213318','0692641642','','','','',NULL,'Dr I.PATEL','126089741101044',NULL,0),(486,'H','PICARD','charles henri','1958-02-22','0262943937','','','','','',NULL,'',NULL,NULL,0),(487,'H','BADAT','Houssen','1957-02-07','','0 692 85 06 83','','','','',NULL,'Dr Bashir OMARJEE','157029741110778',NULL,0),(489,'H','MARQUET','Jean Claude','1940-03-07','','0 692 45 71 52','','','','',NULL,'Dr. Andriantavy','140038708502204',NULL,0),(492,'F','PAYET','Rose Hermina','1929-10-24','0262521216/026252154','0692673242','','','','',NULL,'Dr Taochy','229109741302694',NULL,0),(493,'H','JULIENNE','Toussaint','1933-11-01','','0262521546','','','','',NULL,'Dr CADET Bruno','133119741581585',NULL,0),(494,'H','CAMATCHY','Yves','1942-04-09','','0692106442','','','','',NULL,'dr Vienne','142049741000705',NULL,0),(495,'F','COMBRESSAMY','Ellya','2009-07-06','','0 692 61 12 03','','','','',NULL,'Dr. KAH','277039939000830',NULL,0),(497,'H','BOUHASSOUN','Nasser','1986-12-27','','0 693 92 89 65','','','','',NULL,'Dr GERARD','186124227511014',NULL,0),(498,'H','HOARAU','Joseph Leon','1933-07-11','0 262 01 03 89','0692 07 77 62','','','','',NULL,'Dr VINCENT Emmanuel','133079740380404',NULL,0),(500,'F','HASSIM','Merbanou','1944-07-12','0262972401','0692251375','','','','',NULL,'Dr Goburdhun','142109933350021',NULL,0),(501,'F','PICARDO','Louisette suzanne','1930-08-16','','0692554675','','','','',NULL,'Dr Patrice HUMBERT','230089741603313',NULL,0),(503,'F','HOARAU','Marie Sylvette','1968-09-21','','0692596189','','','','',NULL,'Dr Maigrat','268099741139589',NULL,0),(505,'F','VIRGINIUS','Diane Marie Beatrice','1974-06-15','','0 693 90 39 86','','','','',NULL,'Dr Laurence LEGROS','274069741135182',NULL,0),(506,'H','LAW-YEN','Laurent Gérard','1982-01-04','laurent.lawyen@gmail','0692772323','','','','',NULL,'Dr Morel/Dr Wan Hoi','182019741108127',NULL,0),(508,'F','BEOLET','Daniele','1948-06-23','0262974027','0692439095','','','','',NULL,'Dr Ramilison','248069933389690',NULL,0),(509,'H','BEOLET','Andre Claude','1939-07-19','','0692439095','','','','',NULL,'Dr Ramilison','139079840111247',NULL,0),(512,'F','DUCHEMANN','SANDRINE','1974-10-22','','','','','','',NULL,'','274107816004259',NULL,0),(519,'H','MUSSIDAN','Michel','1952-12-13','0262504335','0692872097','','','','',NULL,'Dr KAPLER','152129741118616',NULL,0),(520,'F','MUSSIDAN','Marie Paule','1951-03-03','','0692872097','','','','',NULL,'Dr Kapler','251039741103324',NULL,0),(521,'F','DRAMSY','Dilbanou','1930-07-03','','0692427689','','','','',NULL,'Dr Azad RAJABALY','230079933321124',NULL,0),(522,'F','PONAMA','Denise','1942-03-17','0262301469','0692032918','','','','',NULL,'Dr Jean Marc HOARAU','242039740210680',NULL,0),(523,'H','DELAPORTE','Joel','1952-05-02','','0 692 73 13 17','','','','',NULL,'Dr Genin /Dr Peyronnet','152055939003067',NULL,0),(524,'H','CLAIN','Georges Jean Marc','1957-11-23','0262219978','','','','','',NULL,'Dr COROUGE','157119741136363',NULL,0),(526,'H','PARIS','Richard','1962-03-27','0262270177','0692597278','','','','',NULL,'Dr CHERON','162039741418569',NULL,0),(527,'F','LAPORTE','Viviane','1972-07-17','','0 692 26 85 20','','','','',NULL,'Dr FIDEL','272079933308829',NULL,0),(528,'H','TALBOT','Francis','1947-06-15','','0 692 17 77 71','','','','',NULL,'Dr Philippe ANDRIANTAVY','147069933391870',NULL,0),(529,'H','BOYER','Emmanuel','1928-09-26','0262530981','0692159496','','','','',NULL,'Dr Ponrouch','128099740900329',NULL,0),(530,'F','RAJAONARISOA','Olivia','1994-01-08','0262210566','','','','','',NULL,'Dr RAZAKASOA','294019933304958',NULL,0),(533,'H','BOYER','Elisien','1949-06-03','0262974173','0692555912','','','','',NULL,'Dr AKBARALY','149069741101247',NULL,0),(534,'F','LEQUEDIC','denise','0000-00-00','','0692112734','','','','',NULL,'dr manias',NULL,NULL,0),(536,'H','ORESTE','Teddy','1979-03-01','0262282910','0692226709','','','','',NULL,'Dr Belrose','179039741102766',NULL,0),(537,'H','ORESTE','Carol','1980-09-05','0262282910','0692226709','','','','',NULL,'Dr BELROSE','280099741111968',NULL,0),(539,'H','MAMODALY','Aziz Aly','1943-02-10','','0 692 03 17 80','APP 2\r\nResidence Colombier\r\n8, rue Marc Boyer','97490','Saint-Denis','',NULL,'Dr. Akbaraly Moise','143029933392105',NULL,0),(541,'H','IBOUTH','Sylvestre','1935-01-01','0262468017','0692163473','','','','',NULL,'Dr Conte,St Andre','135019740900145',NULL,0),(542,'H','MOOSBALLY','Sheik','1960-06-01','','0 692 38 96 41','','','','',NULL,'Dr. Bobate','160069939019102',NULL,0),(543,'F','ANDRIEN','Myriam','1935-02-01','0262213623','','','','','',NULL,'Dr MARONE',NULL,NULL,0),(544,'F','COUSIN','Cécile','1983-12-15','0 262 69 78 94','0 692 52 69 50','3 lot la Colline\r\nSainte-Therese','97419','La Possession','',NULL,'Dr. Thierry Borg','283129741133940',NULL,0),(547,'H','RAKOTOARIVONY','Gaetan','1960-08-06','0262285204','0692092332','','','','',NULL,'Dr Laurent Grandpré/Dr Venault','160089933328204',NULL,0),(548,'F','PUTIEN','Maelis','1996-12-03','','0 692 17 89 76','','','','',NULL,'Dr. PESCATORI (ORL)','296129741194855',NULL,0),(549,'H','RICHARD','Henri Rufus','1943-12-16','0262531604','0692853186','','','','',NULL,'Dr PONROUCH',NULL,NULL,0),(550,'H','LEPINAY','Joseph','1935-10-05','','0692520940','','','','',NULL,'Dr Lan Nang Fan M.Noelle','135109742201279',NULL,0),(551,'F','HOARAU','Margot','1936-08-21','','0692520940','','','','',NULL,'Dr LAN NANG FAN M NO','236089740603022',NULL,0),(552,'H','ROBERT','Gilbert','1949-04-10','','0693401124','','','','',NULL,'Dr CHARLES-RABESIAKA','149049740900582',NULL,0),(555,'H','GAY','Wilson','1961-06-01','0262448721','','','','','',NULL,'Dr Pillay','161069741400555',NULL,0),(557,'H','ASENSIO','Manuel','1936-05-27','0262413502','','','','','',NULL,'Dr Guilbaud','136059213400896',NULL,0),(559,'F','JOOMUN EADALLY','Bibi Seereen','1959-04-30','0262681721','0 692 58 81 80','Apt A42\r\n248, rue Marechal','97400','Saint-Denis','',NULL,'Dr. Bobate',NULL,NULL,0),(561,'H','KHUDERUN','Bibi Nafiza','1986-12-16','','','','','','',NULL,'','286129939001715',NULL,0),(562,'F','LLOPIS','Lydia','1957-11-28','0262288466','','','','','',NULL,'Dr. Françoise Gilbaud','257116437115383',NULL,0),(563,'H','HOAREAU','Noah','2003-04-22','','0 692 60 77 59','','','','',NULL,'Dr Joelle REDON','174049741152721',NULL,0),(567,'H','SOPHIE','Louis Vivian','1961-05-05','','0693415928','','','','',NULL,'Dr Nicolas Denis','161059939018540',NULL,0),(570,'F','DARAFY','Loana','2007-09-24','0262301488','0692881782','','','','',NULL,'Dr Guilbaud','269069741138106',NULL,0),(572,'H','KAMIS','Razaaly','1950-06-04','0262416470','0692722635','','','','',NULL,'Dr. Azad Rajabaly','150069960405231',NULL,0),(573,'F','PERITA','Catherine','1967-06-06','0262535998','0692675054','','','','',NULL,'Dr MOSSELLO','267069741113361',NULL,0),(575,'H','PAYET','Jean René','1959-12-01','0 262 26 84 03','','','','','',NULL,'Dr Michel MURAT','159129741400753',NULL,0),(576,'H','MOUCOUVEIA','Joseph','0000-00-00','0262465849','0692564399','','','','',NULL,'',NULL,NULL,0),(577,'F','DI MAURO','Arlette','1953-06-07','','','','','','',NULL,'',NULL,NULL,0),(579,'F','FLORUS','M. S heila','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(580,'H','GALPIN','Alphonse','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(581,'F','BATOU','Suzanne','1941-01-24','0262522867','0692775986','','','','',NULL,'Dr Bruno CADET','241019742000150',NULL,0),(584,'F','GRONDIN','Sylvie Elsa','1991-01-25','0262524434','0692632206','','','','',NULL,'Dr DOUSSAUD','291019781110426',NULL,0),(585,'H','MOUTON','Hervé','1958-08-29','0 624 98 29 27','','','','','',NULL,'Dr. Bicharzon-Lionnet, Ury, France','158080269116057',NULL,0),(591,'H','CANAGUY','KAVIRAJ','2008-08-16','0693904100','','','','','',NULL,'Dr René VIEL','169069740902782',NULL,0),(592,'H','LAURENT','Paul','1938-01-16','0 262 29 22 14','','','','','',NULL,'Dr Peyronnet','138019935028173',NULL,0),(595,'H','VIDOT','David','1977-04-18','0 262 50 01 89','0692 70 55 72','','','','',NULL,'Dr. Ray, Sainte-Suzanne','177049741143959',NULL,0),(596,'H','LAURENT','Marie Thérèse','1940-08-24','0 262 29 22 14','0 692 40 72 86','','','','',NULL,'Dr Peyronnet',NULL,NULL,0),(599,'H','BARDIERE','Louis Christophe','1958-01-27','0262418599','0692934663','Allée des Roses, Bld Providence','97400','Saint-Denis','',NULL,'Dr VENAULT Antoine','158019741137734',NULL,0),(601,'H','AMOUNY','Georges Michel','1959-02-04','','0692282012','','','','',NULL,'Dr Ledig/Dr Wan Hoi','159029740901139',NULL,0),(603,'H','MAILLOT','Elio Jasmin','1954-10-26','','','','','','',NULL,'','154109740228557',NULL,0),(604,'H','SEVOU','Dominique','1969-05-08','','','','','','',NULL,'','169059742115563',NULL,0),(609,'F','COJONDE','Valérie Theonia','1928-05-18','0262 30 49 35','','','','','',NULL,'Dr GOULAM ABASSE','228059742106476',NULL,0),(610,'H','MADI','Djoumoi','1930-01-01','','0 693 70 84 00','','','','',NULL,'GOULAM ABASSE','130019939707933',NULL,0),(612,'H','CHEUNG-LUNG','Joseph','1939-06-10','0 262 47 63 13','','','','','',NULL,'Dr. Corouge','139069741182020',NULL,0),(613,'F','RAZEFARSON','Maminirina Sandra','1980-01-12','0262681188','','23 avenue Jean Albani','97400','Saint-Denis','',NULL,'Dr I. PATEL','280019933301502',NULL,0),(615,'H','TANGUY','Pierre','1980-10-27','0262211023','0692251039','','','','',NULL,'Dr B.TANGUY','180109741149351',NULL,0),(617,'H','GUYVARCH','isabelle','1963-01-16','0262589148','','','','','',NULL,'Dr Michineau','162062923339691',NULL,0),(618,'H','IFANGOUSINE','Jean Hugues','1975-05-16','0262923946','0692790091','','','','',NULL,'Dr AKBARALY moise','175059741135563',NULL,0),(621,'F','MOUNIAPIN','marina','2001-12-27','0262467630','','','','','',NULL,'Dr Messai','274099740903125',NULL,0),(624,'H','VIDAL','Hervé','1969-03-01','026256 14 65','0692027840','','','','',NULL,'Dr Fun Yan Yuen','169033155502458',NULL,0),(625,'F','VIDAL','Elisabeth','1967-06-30','0262561465','0692027840','','','','',NULL,'Dr Fun Yan Yuen ','267063417235676',NULL,0),(627,'H','DUBARD','Jean Pierre','1949-01-04','0 262 32 44 25','','','','','',NULL,'Dr.  Sylvie Glorieux','149019741100769',NULL,0),(628,'H','BOULLEY','Jean Claude','1944-02-16','0 262 55 33 80','0 692 65 82 87','','','','',NULL,'Dr Slyvie GLORIEUX','144027511012341',NULL,0),(630,'H','MORBY','Jean-Yves','1968-11-23','0262548916','0692546908','','','','',NULL,'Dr ','168119741306157',NULL,0),(632,'F','ADOLPHE','Patricia','1962-01-09','0 262 28 90 30','0 692 54 58 22','','','','',NULL,'Dr Chuong','161079933314378',NULL,0),(634,'H','THIA KIME','Gertrude Bernadette','1922-11-22','0262417821','','','','','',NULL,'Dr Patel','222129741300703',NULL,0),(637,'H','PAYET','Alexandre','2007-07-27','0262687784','069393 85 41','','','','',NULL,'Dr Chabas','286109741166124',NULL,0),(639,'H','PHILIPPE','Jean Sébastian','1975-01-01','','0692 69 20 14','','','','',NULL,'Dr A.LEROY/Dr Bourdais','175015746301949',NULL,0),(640,'H','RIVIERE','Marie Alice','1943-05-22','0262217593','0692537581','','','','',NULL,'Dr Wan Hoi/Dr Dupuis','243059740420697',NULL,0),(654,'H','DALLEAU','Orane','2005-07-02','0262104169','0692950513','','','','',NULL,'Dr Akbaraly','282079741161128',NULL,0),(656,'F','LAUGIER','Mariam','1928-10-30','0692854401 (annick)','0692661166','','','','',NULL,'Dr Cole Rocher','228109912600884',NULL,0),(658,'H','CAILASSON','Jean Claude','1947-01-20','0262280639','0692227033','','','','',NULL,'Dr Kapler','147019741183518',NULL,0),(661,'H','CHADUC','Sandra','1981-09-02','0262979352','0692715455','','','','',NULL,'Dr Jaglale-Letniowski','281099741104197',NULL,0),(663,'H','PEYOU','Marie Ange','1957-01-04','','0692474609','','','','',NULL,'Dr Hubert de LISLE','157059741115974',NULL,0),(664,'F','ABDOUL RASSUL','Mylène','1989-07-22','0262295901','0692 52 99 06','','','','',NULL,'GOULAM ABASSE',NULL,NULL,0),(665,'H','CALICHARANE','YOHAN','1997-01-25','0262583515','0692328410','','','','',NULL,'Dr Ciceron','197019781100476',NULL,0),(667,'H','CHATEAU','Raymond','1970-07-09','0262206245','0692823675','','','','',NULL,'Dr Gruson Claude/Dr Dhiersat','170073950001561',NULL,0),(668,'F','BONNET','Maggy','0000-00-00','','O692911288','','','','',NULL,'',NULL,NULL,0),(669,'H','RAKOTOZANANY','Eric','1971-05-28','0262562849','0692 36 14 40','','','','',NULL,'Dr Andriantavy','171059933311569',NULL,0),(671,'H','PEROUMAL ELLAMA','Marie Jeanne','1938-08-16','026253 45 81','','','','','',NULL,'Dr Kon Sun Tack',NULL,NULL,0),(672,'F','BOYER','Marie Marguerite','1966-02-28','O262 30 15 70 ','069261 30 05','','','','',NULL,'Dr Bocquel/Dr Winteller','166049741164108',NULL,0),(673,'H','GOVINDIN','Anita','1947-01-24','0262976274','0692881658','','','','',NULL,'dr Axel KICHENIN',NULL,NULL,0),(674,'H','DEVANE','William','2003-03-14','','069281605','','','','',NULL,'Dr RIPAULT','263119741102359',NULL,0),(675,'F','MARQUET','Baptistine','1928-03-30','','0692 45 71 52','','','','',NULL,'Dr Andriantavy','228039741184647',NULL,0),(676,'H','PAINIAYE','ANTOINE','1938-06-11','','0692023300 (secretai','','','','',NULL,'Dr Eugenie MAHE','138069741001036',NULL,0),(678,'H','GRONDIN','Rubain','1937-01-16','0262219663','','','','','',NULL,'Dr Le Bihan-Behary','137019741581718',NULL,0),(679,'H','ROJEHOUSSEN','Amidine','1981-10-12','0262104703','0 692 67 00 30','','','','',NULL,'Dr Uvarajen PARATIAN','181109933302243',NULL,0),(680,'H','PIERRE DI GERARD','Alain','0000-00-00','','0692384218','','','','',NULL,'',NULL,NULL,0),(683,'F','BOYER','Marie Andrée','1958-12-12','','0692461730','','','','',NULL,'De Doineau Philippe','157059741123793',NULL,0),(685,'H','ODETTE','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(688,'H','LEON','Thierry','1966-12-09','0262345035','0692867827','','','','',NULL,'Dr Amouck de St Leu','166129741117124',NULL,0),(689,'H','BATOU','Yoland','1952-12-16','0262','0692113179','','','','',NULL,'Dr CADET Bruno','152129742076342',NULL,0),(690,'F','MOUTOUCOMORAPOULLE','Sarah','2010-05-07','0262531332','0692611378','','','','',NULL,'Dr Bruno CADET','277089939000516',NULL,0),(692,'F','GOMAR','Marie Thérèse','1935-07-11','0262175450','0692618212','','','','',NULL,'Dr Philippe Andriantavy','237079740901873',NULL,0),(693,'H','VILPONT','Gilbert','1966-09-19','0262 466149','0692 004743','','','','',NULL,'Dr BOINNEAU Philippe','166099741142315',NULL,0),(695,'H','LEPELLEY','SIMON','1982-03-20','','0692001630','','','','',NULL,'Dr Gallo','182031411832084',NULL,0),(697,'H','TANGUY','BERNARD','0000-00-00','','0692042562','','','','',NULL,'',NULL,NULL,0),(698,'F','TANGUY','Dominique','1952-11-17','','0693502046','','','','',NULL,'','146079939005861',NULL,0),(699,'H','HOARAU','Clemence','1989-07-26','','0692047886','','','','',NULL,'','289079741169784',NULL,0),(701,'H','HUBERT','Kevin','1989-10-09','','0 692 23 38 85','19 impasse Telinga','97438','Sainte-Marie','',NULL,'Dr MARI','191109741195322',NULL,0),(702,'F','THEMYR','Solange','1943-09-26','0262449488','','','','','',NULL,'Dr Vittori/Dr Blanc','243099740880920',NULL,0),(703,'H','GUICHARD','Claude','1964-09-20','0262297416','0692664281','','','','',NULL,'Dr KOWALCZYK/Dr Philippe BLANC','164099741211107',NULL,0),(704,'F','BOISSEL','Marie Madeleine','1928-06-21','0262581180','','','','','',NULL,'Dr LEDIG/Dr Blanc','228069742182015',NULL,0),(705,'H','SISAHAYES','Jean-Pierre','1967-07-26','0262281408','0692014755','','','','',NULL,'Dr kapler/Dr Blanc','162079741916305',NULL,0),(707,'H','DALLEAU','Idriss','2013-07-14','','0692148722','','','','',NULL,'Dr Moussa','281049741111144',NULL,0),(710,'H','HOARAU','Pierre','1963-09-20','0262300222','0692609665','','','','',NULL,'Dr Hubert de lisle/Dr Andriantavy','163099741136922',NULL,0),(711,'H','TIMON','Valere','1964-01-12','0262332915','0692041034','','','','',NULL,'Dr DOREMIEUX/Dr Alain MAZEL Intermétra','164019741512368',NULL,0),(713,'H','TOLSY','Yvon','1944-01-29','0 262 50 90 07','0 692 86 46 52','','','','',NULL,'Dr. Epatsin?',NULL,NULL,0),(714,'F','BAPOO','Beatrice','1963-06-10','','0 692 01 76 34','','','','',NULL,'Dr Doineau/Dr Patel','263060836701425',NULL,0),(715,'H','SCHAMBER','Jacques','1941-01-17','0262885520','0 692 39 54 74','','','','',NULL,'Dr C.Aouate','141013617123064',NULL,1),(719,'H','VIRAMA','Vivienne','1922-08-24','0262200161','','','','','',NULL,'DrGuilbaud Françoise ','222089741101885',NULL,0),(721,'F','ANTHONY','Lucille','1977-08-14','','0 692 61 13 78','','','','',NULL,'Dr. Bruno Cadet','277089939000516',NULL,0),(723,'F','CAROUMBIN VIRAPIN','Marie Rosine','1978-02-26','0262137001','0692 84 24 62','','','','',NULL,'Dr Patel','278029741153130',NULL,0),(725,'H','OGNARD','Emmanuel','1981-02-27','','0 692 88 08 17','','','','',NULL,'Dr Peraud/Dr Muller Sistbi','181029741156593',NULL,0),(726,'H','MINIENPOULLE','Marcel','1934-05-09','0 262 46 73 33 n pas','','','','','',NULL,'Dr Satsou Arnaud','134059740900458',NULL,0),(729,'H','MHARCHI','Ahmed','1964-06-20','0262297224',' 0692986030','','','','',NULL,'Dr Ahsing','164069935090697',NULL,0),(730,'F','BAGOWDJEE KANDJEE','Pospabay','1937-04-02','0262094770','0692385048','','','','',NULL,'Dr I.PATEL','237049933328742',NULL,0),(731,'F','CAZAL','Therese','1944-06-01','0262 28 58 43','','','','','',NULL,'Dr Ramassamy Dr Blanc','141029741500568',NULL,0),(732,'H','GRONDIN','Jacky','1963-01-04','0262575369 ','0692734183','','','','',NULL,'Dr Gerard-Tan Rouge/Dr Blanc','163019741106997',NULL,0),(733,'H','MOUNIAPIN','Jean Gerode','2000-03-19','0262467630','','','','','',NULL,'Dr Bashoun','100039781108032',NULL,0),(734,'H','SINARETTY RAMARETTY','Vincent','1995-04-24','','','','','','',NULL,'',NULL,NULL,0),(736,'H','VYNISALE','Ludovic','1937-04-26','','','','','','',NULL,'Dr Blanc/Dr Loggia','137049741403703',NULL,0),(737,'F','VIRIN','Marie-Therese','1927-10-08','0 262 53 94 49','0 262 53 61 83 (fill','','','','',NULL,'Dr Jean KAPLER','227109741103648',NULL,0),(738,'H','COINDEVEL-VALLIA','Julien-André','1950-08-09','','0 692 21 02 33','','','','',NULL,'Dr Law-Ping-Man Charles','150089741105683',NULL,0),(742,'H','RESMED','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(744,'H','MOTTE','Jean Marie','1979-05-10','0262730052','','','','','',NULL,'Dr Vignal','179059741121111',NULL,0),(748,'H','TECHER','Cécile','1957-01-11','0262775098','0692 61 50 64','','','','',NULL,'Hubert de Lisle ','257019741006584',NULL,0),(751,'F','BAILLY','fanny','0000-00-00','','0692573204','','','','',NULL,'',NULL,NULL,0),(753,'F','LE BRETON','S ylvie','0000-00-00','0262 59 30 17','','','','','',NULL,'',NULL,NULL,0),(754,'F','DAMOUR','Emma','2004-02-10','0262414576','0692689776','','','','',NULL,'Dr Bordier','277119400205354',NULL,0),(757,'F','CHEUNG LUNG','Christiane','1943-11-20','0262 47 63 13','','','','','',NULL,'Dr Corouge','243119740780388',NULL,0),(758,'H','COLLOMBET','Luce','1949-06-14','0262 26 27 01','','','','','',NULL,'Dr Baranoff','249067300604852',NULL,0),(759,'H','ARHIMAN','Jean-Claude','1968-04-06','','0 692 17 46 15','','','','',NULL,'',NULL,NULL,0),(761,'H','DORVAL','Jean-Michel','1954-05-16','0262274008','0 692 64 10 09','','','','',NULL,'Dr Jean Claude Behavana','154059741118105',NULL,0),(762,'F','MOHN POSPABAY','','1937-04-02','','','','','','',NULL,'','237049933328742',NULL,0),(763,'H','TRAPE','Henri','1942-07-13','0262443486','','','','','',NULL,'Dr Glorieux Sylvie','142077511009553',NULL,0),(765,'H','HALINI','Patrick','1956-09-11','','0 692 25 70 78','','','','',NULL,'Dr Jeu/Dr Sophie Saint Raymond,anesthésiste','156099935254463',NULL,0),(766,'H','MAGAMOOTOO','Hervé','1948-08-14','0262238919','0692668199','','','','',NULL,'Dr M-N LAN NANG FAN','148089741187640',NULL,0),(767,'H','LEOCADIE','jeannick','1943-02-10','','0692 32 02 96','','','','',NULL,'Dr Blanc/dr Ah-Sing','143029740180971',NULL,0),(768,'H','ALIBAY','Firozehoussen','1956-08-18','0262911905','0692 32 33 86','','','','',NULL,'Dr Blanc/Dr Manuella LORY','156089933332164',NULL,0),(770,'F','LABORATOIRE CHIESI','Laurence','0000-00-00','','0692 64 16 54','','','','',NULL,'',NULL,NULL,0),(771,'H','ZENA','Aurélie Leila','1985-03-24','','06927324 82','','','','',NULL,'Dr LOW HONG','285039741165168',NULL,0),(773,'H','MAMODALY KASSAMALY','Siaquataly','1953-08-19','0 262 97 01 45','0692 53 32 04','','','','',NULL,'Dr Courchinoux,Patrick','153089933329444',NULL,0),(774,'H','GAUTHEUR','Louis','2007-11-15','026277 56 76','0692 57 44 70','','','','',NULL,'Dr Winteler Benedicte','167015313014138',NULL,0),(775,'F','LABORATOIRES PIERRE FABRE','Catherine Dupont','0000-00-00','','0692351046','','','','',NULL,'',NULL,NULL,0),(777,'F','ESPERANCE','Pierrette','1965-08-15','0262411465','','','','','',NULL,'Dr I.Patel','265089741129529',NULL,0),(779,'H','BERNARD ET DOMINIQUE','Kine','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(782,'H','SEMAINEP SPECIALE','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(786,'H','KINE BERN DOM','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(787,'H','MARDE','Edmond','1953-12-12','0262 46 57 54','0692 76 05 84','','','','',NULL,'Dr Chekouri','153129740904670',NULL,0),(788,'H','TESTAN','Marie Christelle','1986-12-19','0262467630','','','','','',NULL,'Dr Pauvert','286129741009372',NULL,0),(791,'H','ARHIMAN','Jean Claude','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(794,'F','MONTEVILLE','Bibiane','1960-07-09','0262281558','','','','','',NULL,'Dr Marie Hélène RAY','260079740905177',NULL,0),(797,'H','MUSSARD','Jean Christian','1962-12-07','0262 69 70 52','0692505285','','','','',NULL,'Dr CHUONG VAN HUNG/Dr Pierre BERNARD','162129741111582',NULL,0),(800,'H','TESTAN','Aydan','2012-10-12','','0692 93 11 99','','','','',NULL,'Dr Jean Marc HOARAU','189059741119720',NULL,0),(801,'H','TESTAN','Kenza','2013-10-06','','0692 93 11 99','','','','',NULL,'Dr Jean Marc HOARAU','189059741119720',NULL,0),(802,'F','PAYET','Marie Paule','1942-04-13','','069212 71 04','','','','',NULL,'Dr Tcheng','242049741104779',NULL,0),(805,'H','BOYER','Miguel','2007-03-26','0262422268','0692888376','','','','',NULL,'Mme  Dr Tamburini','274089742234779',NULL,0),(806,'H','MANGRA','Florus','1975-07-03','','0692066880','','','','',NULL,'Dr Axel KICHENIN','175079742011961',NULL,0),(807,'H','HONORINE','Jimmy','1982-02-24','','','','','','',NULL,'Dr BLANC/DrSigal','182029207315361',NULL,0),(808,'H','ABDOURAHAMANE','Roukia','0000-00-00','','0639068879 Mayotte','','','','',NULL,'',NULL,NULL,0),(809,'F','MUSSARD','Eglantine','1958-04-23','026223 64 99','069245 07 17','','','','',NULL,'Dr Moreau','258049740109334',NULL,0),(810,'H','SERAPHINE','Jacques','1957-04-10','0262 28 89 32','0692082174','','','','',NULL,'Dr Patel','157049741112790',NULL,0),(811,'H','FOULON','Emile','0000-00-00','','0692823245','','','','',NULL,'Dr Philippe BLANC',NULL,NULL,0),(813,'F','SALEM','Marie Claudette','1955-02-28','026268 84 89','0692076473','','','','',NULL,'Dr Leveque','255029741310370',NULL,0),(814,'H','HOARAU','Paul','1947-05-12','','0692002749','','','','',NULL,'Dr Philippe BLANC/Dr lABAT','147059741501110',NULL,0),(815,'H','LEUNG PIN','Eddie-Robert','1957-06-30','','','','','','',NULL,'dr Leung-Pin',NULL,NULL,0),(817,'H','PEROUMAL THEVANIN','Jean Pierre','1964-03-06','','0692 10 57 01','','','','',NULL,'Dr Axel KICHENIN',NULL,NULL,0),(818,'H','PONAMA','Marie Sylviane','1968-02-10','0262460937','0692838395','','','','',NULL,'Dr Viel Rene','268029741121164',NULL,0),(820,'H','MODULE','Marie Claude','1951-11-15','','0692172162','','','','',NULL,'Dr Patel','251119740774941',NULL,0),(821,'H','CHANE SANE','Léon','1933-10-06','0262 30 99 47','','','','','',NULL,'Dr Patel','133109741103497',NULL,0),(822,'H','AURE','Frederic','1977-09-06','','0692001772','','','','',NULL,'Direct Jeun Sports','177099741108706',NULL,0),(823,'H','PEROUMAL THEVANIN','Anita Marie','1965-06-12','0262315797','0692104553.','','','','',NULL,'Dr Axel KICHENIN',NULL,NULL,0),(825,'H','PITOU','Dany','2013-06-11','','0692410783','','','','',NULL,'Dr Le Bihan','278049741405560',NULL,0),(826,'H','PREDICATION','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(829,'H','TANICODY','Joseph','1929-07-10','0262 46 50 67','','','','','',NULL,'Dr Vinguetama','129079742008620',NULL,0),(832,'H','CHAVRIACOUTY','Jean Luc','1957-08-03','','0692 21 15 66','','','','',NULL,'Dr Fournier Marie Josette','157089741105334',NULL,0),(833,'H','CHAVRIACOUTY','arlette','1959-03-05','0262590803','0692297717','','','','',NULL,'Dr Fournier','259036015901660',NULL,0),(835,'H','LABAUME','Gaston','1955-12-28','0262213878','0692912444','','','','',NULL,'Dr Maronne','155129740611194',NULL,0),(840,'H','TINJUS','Joseph','1938-09-28','0262 52 58 11','','','','','',NULL,'Dr Casobon','138099742381652',NULL,0),(841,'F','VIRAPIN','Denise','1965-12-31','','0692 18 86 93','','','','',NULL,'Dr VIRAPOULLE',NULL,NULL,0),(842,'F','BADOURALI','SERALI','1946-10-20','','0693 93 18 12','','','','',NULL,'Dr  GOULAMABASSE/Dr CHUONG','146109933389314',NULL,0),(844,'H','BIHR','Jean Jacques','1959-10-09','','0692870208','','','','',NULL,'Dr BLANC CRF','159106822410009',NULL,0),(848,'H','SERRALIA','Alexandre','1988-05-04','0262099240','0692 34 47 90','','','','',NULL,'Dr Ibrahim PATEL','188059741109970',NULL,0),(852,'H','BISHKA','florence','1948-07-23','0262412628','0692879093','','','','',NULL,'Dr DHUNNOO/Dr AOUATE','248079741503219',NULL,0),(853,'H','AD','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(854,'F','RABENAH','Marie Irene','0000-00-00','0262536196','','','','','',NULL,'Dr kICHENIN Axel',NULL,NULL,0),(855,'H','MOELON','Sylvaine','1958-09-14','','0692 54 60 25','','','','',NULL,'Dr GUILBAUD','258099741611332',NULL,0),(856,'H','DEWINTER','Emmanuelle','0000-00-00','visiteur medical','069226 87 47','','','','',NULL,'',NULL,NULL,0),(857,'H','CARDIN','Eric','1965-10-15','','0692788571','','','','',NULL,'DrMessy ',NULL,NULL,0),(858,'H','SIMON','Jean','1955-02-21','0262202594','0692244175','','','','',NULL,'Dr. Laurent  Granpré','155025965600268',NULL,0),(859,'F','LAB TEVA','','0000-00-00','','0692 34 28 67','','','','',NULL,'',NULL,NULL,0),(864,'H','GRANDPRE','Laurent','1952-04-22','0262211219','','','','','',NULL,'Dr Grandpré','152049741128283',NULL,0),(865,'H','SINCERE','Lilian','1962-12-10','','0 692 16 59 57','','','','',NULL,'Dr. Patel','162129741118710',NULL,0),(866,'H','GALLARD','Jean Michel','1949-07-18','','0 693 50 89 30','','','','',NULL,'Dr. Dalapa Amana',NULL,NULL,0),(868,'H','APALAMA','Jean Yves','1955-03-01','0262286529','0692 87 56 58','','','','',NULL,'Dr Jatob/Dr Laurent Grandpré','155039741800188',NULL,0),(869,'H','LOUKMANDJEE','Ibrahim','1931-02-05','','0692 34 35 41 ','','','','',NULL,'Dr BELROSE','131029933318469',NULL,0),(871,'H','APPELER AMBUL','0262 304 444','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(872,'F','OVIZE','Marion','1986-05-13','0262531252','0692 32 80 30','','','','',NULL,'Dr DER KASBARIAN','286053417222140',NULL,0),(874,'H','FETON','Sebastien','1973-01-22','0262211282','0692870971','','','','',NULL,'Dr Marie Noelle LAN NANG FAN','173019741518748',NULL,0),(875,'F','BENTOLILA','Cécile','1971-06-09','','0 692 68 41 32','40, Chemin de la Vigie\r\nSaint-Denis','97417','La Montagne','',NULL,'Dr. Herzog','271067511311013',NULL,0),(876,'H','MAILLOT','Timothée','2000-04-08','0262297572','','','','','',NULL,'Dr van Grevelyghe','161099741131973',NULL,0),(880,'H','BEGUE','Wilfred','1969-11-24','','0692889178 (S. Hoare','','','','',NULL,'Dr. Danielle LE BIHAN-BEHARY',NULL,NULL,0),(883,'H','CHAN-SUN','Marcel','1954-12-15','0 262 21 11 04','0 692 42 87 71','','','','',NULL,'Dr Chang- Kuw,Victor','154129741124355',NULL,0),(885,'H','M\'DOIHOMA','Frederic','1978-08-20','0262139575','0692189818','','','','',NULL,'Dr Ponrouch','178089741137343',NULL,0),(886,'F','CADET','Marie Elise','1929-09-29','','0692 04 13 06','','','','',NULL,'Dr Guilbauld',NULL,NULL,0),(887,'H','HOARAU','Frederic','1973-08-18','0262568924','0692610818','','','','',NULL,'Dr Ramilison','173089741133337',NULL,0),(889,'H','MISSY','Pierre','1948-06-24','','0692290 089','','','','',NULL,'Dr Laurent MAES','148065935036676',NULL,0),(890,'H','BAILLIF','Marie Monique','1959-05-02','','0 692 20 46 97','','','','',NULL,'Dr eugénie MAHE','259059741401181',NULL,0),(895,'F','CADIVEL','MARIE EUGENIE','1935-12-26','','0692 76 21 44','','','','',NULL,'Dr MARTINEZ','235129742013003',NULL,0),(897,'H','ALGER','Jean Claude','1952-08-02','0262210636','0692935501','','','','',NULL,'Dr TANGUY Bernard','152089720900582',NULL,0),(898,'H','DIOT','Claude','1962-12-20','0 262 28 29 69','0692372417','','','','',NULL,'Dr. Goeury','162125110808664',NULL,0),(899,'F','KASSAMALY','Shama','1958-05-28','0 262 30 09 65','','','','','',NULL,'Dr. Goulamabasse','152059933336571',NULL,0),(900,'H','HOARAU','Evelyne','1975-05-15','','0 693 03 11 36','','','','',NULL,'Dr. Hubert de Liste','275059741132939',NULL,0),(903,'H','BUCHLE','Lucien','1930-09-01','0262 20 38 22 ','','','','','',NULL,'Dr Yves Rochat','130099741501728',NULL,0),(907,'F','VERVUN','Monique','1948-05-30','0 262 23 64 59','0 692 76 32 82','','','','',NULL,'Dr. Allane',NULL,NULL,0),(908,'H','DELAINE','Arthur','1976-05-26','','0 693 40 13 13','','','','',NULL,'Dr. Lolinemei','176051038716176',NULL,0),(909,'F','KAMIS','Roukhsana','1954-12-18','0262416470','0692147205','','','','',NULL,'Dr Payet,Roseline',NULL,NULL,0),(910,'F','RAKOTOMALALA','Elodie','1994-02-01','026268 11 88','','','','','',NULL,'Dr Patel','294029741180737',NULL,0),(911,'H','ZILMIA','GUILLAUME','1993-10-04','','0692 16 91 02','','','','',NULL,'Dr Cole-rocher M.F.','193109741185819',NULL,0),(912,'H','CATTANEO','Louis Paul','1929-06-10','0693336181 (fille)','0693902667','','','','',NULL,'Dr Pierre JEZEQUEL','129067510807773',NULL,0),(916,'F','DEBALMINE','Edouard','1945-04-14','','0692 65 11 18','','','','',NULL,'Dr Andriantavy',NULL,NULL,0),(917,'H','MULLA','Mariam','1974-09-10','0262 21 20 23','0692844506','','','','',NULL,'Dr Bobate','274099741120384',NULL,0),(918,'H','LAN-CHIN','Graziella','1983-08-15','','0692089303','','','','',NULL,'Dr Gruzon/Dr Wan Hoi','283089741142980',NULL,0),(919,'F','SOUPRAYEN','Denise','1953-11-04','0262474985','0 692 74 13 43','','','','',NULL,'Dr. Ibrahim PATEL','253119741105433',NULL,0),(920,'F','NATIVEL','Amelie','1961-08-28','0262403774','0692509018','','','','',151,'Dr BLANC/Dr Torres,Carole','261089741147545',NULL,0),(921,'H','CARCAMY','Etienne','2010-04-12','','0692675443','','','','',NULL,'Dr J. Yves N G TOCK MINE','275059741148379',NULL,0),(922,'H','LACAILLE','Josiane','1953-01-07','0262211151','0692 81 81 47','','','','',NULL,'Dr COLE ROCHER',NULL,NULL,0),(926,'F','BROUSSAN','Graziella','1964-01-31','0262449072','0 692 67 80 37','','','','',NULL,'Dr. Anne BOUDAILLE','264019741158762',NULL,0),(927,'F','PARTULA','Suzie','1932-09-18','0262449072','0 692 67 80 37 (fill','','','','',NULL,'Dr. Anne BOUDAILLE','232099742009144',NULL,0),(928,'F','STIBALO','Leana','2009-08-02','0 262 88 81 05','','','','','',NULL,'',NULL,NULL,0),(930,'H','KASSAMALY','Sylvie','1968-02-17','0262282347','0692188190','','','','',NULL,'Dr BONNE','166039933315548',NULL,0),(931,'H','WAUTHIER','Marcel','1953-07-07','','0 692 28 90 60','','','','',NULL,'Dr laurent Grandpré/Dr PRIEUR',NULL,NULL,0),(932,'H','KASSAMALY','Rojehoussen','0000-00-00','','','','','','',NULL,'Dr Bonne',NULL,NULL,0),(933,'H','DUNOGUIEZ','Max','1964-05-22','0262418939','0693 33 94 45','','','','',NULL,'Dr BORDIER Sandrine',NULL,NULL,0),(934,'H','LENSELLE','Marie Annick','1957-01-16','0262372464','0692026720','','','','',NULL,'dr hoarau thierry/dr guillermin',NULL,NULL,0),(935,'H','HOAREAU','Ernest','1944-02-18','0262565896','0692674600','','','','',NULL,'Dr Fun Yan Yuen',NULL,NULL,0),(936,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(937,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(938,'H','DALLEAU','Iris','2013-07-04','','','','','','',NULL,'Dr Moussa',NULL,NULL,0),(939,'H','PRIOVOLOS','Bazile','1936-10-20','','','','','','',NULL,' Dr ',NULL,NULL,0),(940,'H','NATIVEL','ROMUALD','1985-10-10','0262698307','0693 33 26 56','','','','',NULL,'Dr carole VIGNAL','185109741124950',NULL,0),(941,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(943,'H','ALAMELOU','Pablo','2010-10-27','','0692865593','','','','',NULL,'Dr Morel','268029741151353',NULL,0),(944,'H','RAMAYE','Marie Vivienne','1932-06-12','0262501071','0692 35 66 26','','','','',NULL,'Dr Ferroul(Bras Panon)',NULL,NULL,0),(945,'F','TOORAWA','Hawabibi','1962-04-02','','0 692 77 41 78','','','','',NULL,'Dr. BOBATE ,I','262049939012681',NULL,0),(946,'H','CONGRES','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(947,'H','CONGRES','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(948,'H','CONGRES','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(949,'H','CONGRES','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(950,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(951,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(952,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(953,'H','AUGUSTE','Vincent','2007-05-27','','0693909124','','','','',NULL,'Dr Belrose Olivier','268109741141387',NULL,0),(954,'H','GALTIER','Dany','1969-07-19','0262395191','0692656324','','','','',NULL,'Dr CANIGGIA','169079741206765',NULL,0),(955,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(956,'H','RAMAYE','Jean Louis','1957-08-26','0262501071','','','','','',NULL,'Dr Ferroul','157089740229364',NULL,0),(957,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(958,'H','LALA','IKBAL','0000-00-00','0262 41 01 55','','','','','',NULL,'Dr BOBATE',NULL,NULL,0),(959,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(960,'H','MUSSARD','jean christ','1962-12-07','0262697052','','','','','',NULL,'dr blanc crf',NULL,NULL,0),(961,'H','APPADOO','gerald','1973-10-26','','0693943102','','','','',NULL,'Dr blanc:Dr koenig','173109741016771',NULL,0),(962,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(963,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(964,'H','SOUNDRON','Joseph','1946-05-11','','0692 70 61 01','','','','',NULL,'Dr VINGUETAMA','146059740901640',NULL,0),(965,'H','GRONDIN','jordan','2000-03-30','','0692 04 16 51','','','','',NULL,'','274029741143135',NULL,0),(966,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(967,'F','VYNISALE','Rose','1937-11-05','','','','','','',NULL,'Dr LOGGIA',NULL,NULL,0),(968,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(969,'F','SR CHECKIMANIN DRAVOUTIN','Jocelyne','1943-08-12','','0692833320','','','','',NULL,'Dr Dyall','243089741880992',NULL,0),(970,'F','TANGUY-PULA','Ghislaine Françoise','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(971,'F','ALBERT','daniele','1958-12-22','','','','','','',NULL,'Dr Laurent Grandpré',NULL,NULL,0),(972,'H','TECHER','Francois','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(973,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(974,'F','GENCE','Daisy','1941-05-25','0262 51 70 83','','','','','',NULL,'Dr Andritavy',NULL,NULL,0),(975,'H','GENCE','Margot','1943-09-13','0262 51 70 83','','','','','',NULL,'Dr Andritavy',NULL,NULL,0),(976,'F','DESILES','Rolande','1945-04-17','','0 692 90 91 51','','','','',NULL,'Dr. Bruno Cadet',NULL,NULL,0),(977,'H','','','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(978,'F','K\'BIDY','GILETTE','1957-08-27','0262 28 84 26','','','','','',NULL,'Dr TALTIN','257089741143587',NULL,0),(979,'H','PREDI......','MAM S','0000-00-00','','','','','','',NULL,'',NULL,NULL,0),(980,'F','NATIVEL','JENNIFER','1995-07-03','','0693 33 26 56','','','','',NULL,'Dr CAROLE VIGNAL',NULL,NULL,0),(981,'H','NATIVEL','JOEL','1957-02-27','','0692 86 35 25','','','','',NULL,'Dr RIPAULT',NULL,NULL,0),(982,'F','NATIVEL','iVANOHE','2010-05-07','','','','','','',NULL,'Dr CAROLE VIGNAL',NULL,NULL,0),(983,'H','ROBERT','Yves','1958-09-17','','0692 61 64 30','','','','',NULL,'Dr  Marguarette RAMASSAMY',NULL,NULL,0);
/*!40000 ALTER TABLE `clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comptes_bancaires`
--

DROP TABLE IF EXISTS `comptes_bancaires`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comptes_bancaires` (
  `date_arret_releve` date NOT NULL,
  `fichier` varchar(100) NOT NULL,
  PRIMARY KEY (`date_arret_releve`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comptes_bancaires`
--

LOCK TABLES `comptes_bancaires` WRITE;
/*!40000 ALTER TABLE `comptes_bancaires` DISABLE KEYS */;
INSERT INTO `comptes_bancaires` VALUES ('2013-07-26','Relev_ n_000001 du 26_07_2013_42531401.pdf'),('2013-08-26','Relev_ n_000002 du 26_08_2013_42563470.pdf'),('2013-09-26','Relev_ n_000003 du 26_09_2013_43202751.pdf'),('2013-10-25','Relev_ n_001 du 25_10_2013_43448073.pdf'),('2013-11-26','Relev_ n_002 du 26_11_2013_45122890.pdf'),('2013-12-26','Relev_ n_003 du 26_12_2013_45706293.pdf'),('2014-01-24','Relev_ n_001 du 24_01_2014_46358715.pdf');
/*!40000 ALTER TABLE `comptes_bancaires` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `courrier`
--

DROP TABLE IF EXISTS `courrier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `courrier` (
  `id_courrier` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `destinataires` text NOT NULL,
  `corps` text NOT NULL,
  PRIMARY KEY (`id_courrier`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `courrier`
--

LOCK TABLES `courrier` WRITE;
/*!40000 ALTER TABLE `courrier` DISABLE KEYS */;
INSERT INTO `courrier` VALUES (1,'2013-09-20','Monsieur le Directeur de la Clinique de Sainte Clotilde\r\nM. le Docteur Deleflie\r\nM. le Dr Soleilhac\r\nM. le Dr El Bok\r\nM. le Dr Veerapen','<p>Monsieur le Directeur,</p>\r\n<p>Chers Confr&egrave;res,</p>\r\n<p>J\'ai l\'honneur de renouveler ma demande d\'autorisation de pratiquer mes fibroscopies bronchiques et actes techniques&nbsp;en utilisant le plateau technique de votre clinique.</p>\r\n<p>Je pr&eacute;cise que ces actes concerneront mes propres malades et non ceux de &nbsp;la Clinique Sainte Clotilde.</p>\r\n<p>Ils s\'accompagneront d\'un reversement d\'honoraires &agrave; la Clinique pour utilisation de son plateau technique &agrave; l\'instar de&nbsp;ce qui se pratique dans d\'autres sp&eacute;cialit&eacute;s, la Gastro-Enterologie, par exemple.</p>\r\n<p>J\'en ai parl&eacute; &agrave; plusieurs reprises avec le Dr El Bok qui m\'a dit ne pas y &ecirc;tre oppos&eacute; .</p>\r\n<p>En esp&eacute;rant recevoir une r&eacute;ponse favorable de votre part,veuillez agr&eacute;er,Monsieur le Directeur et Chers&nbsp;Confr&egrave;res, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: right;\">Docteur Bernard TANGUY.</p>'),(5,'2013-10-25','La Sauvegarde\r\nGMF\r\nRisques spécifiques Production\r\n140 rue Anatole France \r\n92597 Levallois Perret Cedex','<p>Objet:Contrat No H135270.001K</p>\r\n<p>Soci&eacute;t&eacute; de Pneumologie de l\'Oc&eacute;an Indien</p>\r\n<p>49,All&eacute;e des Topazes,97400,Saint denis ,Ile de la R&eacute;union.</p>\r\n<p>Monsieur le Directeur,</p>\r\n<p>Je vous prie de noter que notre Soci&eacute;t&eacute; est en cours de changement &nbsp;de si&egrave;ge Social et que nous n\'avons toujours pas recu de demande de cotisation de votre part pour la p&eacute;riode &agrave; compter du 14/10/2013.</p>\r\n<p>Aussi pour &eacute;viter toute interruption de contrat je vous adresse en fonction de la demande de l\'ann&eacute;e derni&egrave;re la somme de 704euros 38 cents par ch&egrave;que CA No 0000355.</p>\r\n<p>Ce montant est la replique exacte de ce que nous avions pay&eacute; pour l\'ann&eacute;e derni&egrave;re &agrave; savoir:549.96 euros le 8/10/2012 et 154.42 euros le 04/03/2013.</p>\r\n<p>Nous vous serons tr&egrave;s reconnaissant de nous adresser &agrave; notre nouvelle adresse un autre exemplaire de notre contrat .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, monsieur le Directeur, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>Tresorier de la Soci&eacute;t&eacute; de pneumologie de l\'Oc&eacute;an Indien.</p>'),(6,'2013-10-29','CGSS de la Réunion\r\nTSA 90001\r\n97703 Saint Denis CTC Cedex 9.','<p>Monsieur le Directeur,</p>\r\n<p>Suite &agrave; avis amiable du 24/10/2013(document No1),je viens tr&egrave;s respectueusement vous faire remarquer que j\'ai pay&eacute; le 15/09/2013 par ch&egrave;que CA No0000002 de 8856 euros les cotisations du 01/07 au 30/09/2013 (document No2).</p>\r\n<p>D\'ailleurs ce ch&egrave;que a bien &eacute;t&eacute; encaiss&eacute; par vous le 19/09/2013-voir relev&eacute; bancaire du CA (document No3).</p>\r\n<p>D\'ailleurs mon expert comptable pense qu\'il s\'agit d\'une erreur de compte(voir Documents Nos 4 et 5 ).</p>\r\n<p>Je vous serais &nbsp;gr&eacute; de bien vouloir apporter les rectifications n&eacute;cessaires et enlever la majoration que vous avez appliqu&eacute; &agrave; la SELARL du DR Bernard TANGUY.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er,Monsieur le Directeur, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(7,'2013-11-12','Monsieur le Recteur\r\nDGSE','<p>Objet : Modification de l\'adresse des expertises pneumologiques.</p>\r\n<p>&nbsp;</p>\r\n<p>Monsieur le M&eacute;decin en Chef,</p>\r\n<p>Je vous prie de bien vouloir noter que mon lieu d\'exercice a chang&eacute;.</p>\r\n<p>D&eacute;sormais,les demandes d\'expertises ainsi que la convocation des personnes soumises &agrave; une expertise devront etre adress&eacute; au:</p>\r\n<p>Docteur Bernard TANGUY</p>\r\n<p>Pneumologue Agr&eacute;e</p>\r\n<p>49,All&eacute;e des Topazes,</p>\r\n<p>97400, Saint Denis,</p>\r\n<p>Tel:0262.41.77.53.</p>\r\n<p>Avec mes remerciements,je vous prie d\'agr&eacute;er,Monsieur le M&eacute;decin en Chef , l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY</p>\r\n<p>&nbsp;</p>'),(8,'2013-12-26','','<p>M.et Mme Bernard TANGUY</p>\r\n<p>8 All&eacute;e des Turquoises</p>\r\n<p>BellePierre&nbsp;</p>\r\n<p>97400 saint Denis-Ile de la R&eacute;union</p>\r\n<p>Le 26/12/2013 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;SAPA</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2,rue Escudier</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 92100 BOULOGNE</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ATTESTATION</p>\r\n<p>&nbsp;</p>\r\n<p>Nous &nbsp;soussign&eacute;s M.zet Mme Bernard TANGUY &nbsp;propri&eacute;taires certifions &nbsp;que notre &nbsp;appartement &nbsp;situ&eacute; au 26 Rue Daniel</p>\r\n<p>&nbsp;</p>\r\n<p>Stern,75015 PARIS 3&egrave;me &eacute;tage droite &nbsp;est achev&eacute; depuis plus de deux ans et &agrave; l\'usage exclusif d\'habitation .</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; Saint Denis le 26 d&eacute;cembre 2013.</p>\r\n<p>&nbsp;</p>\r\n<p>M.Bernard TANGUY &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mme Bernard TANGUY.</p>'),(9,'2013-12-27','','<p>Mme Dominique LHERIAU &eacute;pouse TANGUY</p>\r\n<p>8,All&eacute;e des Turquoises,</p>\r\n<p>Bellepierre,</p>\r\n<p>97400,Saint Denis,</p>\r\n<p>Ile de la R&eacute;union,</p>\r\n<p>le 27 d&eacute;cembre 2013</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M.le Directeur</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;CNRACL</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Rue de Vergne</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;33059 BORDEAUX Cedex</p>\r\n<p>&nbsp;</p>\r\n<p>Objet:Validation des services accomplis du 01/09/1971 au 31/08/1973 aupr&egrave;s d\'une collectivit&eacute; locale en vue du droit</p>\r\n<p>&nbsp;&agrave; pension &agrave; la caisse nationale de retraites des agents des collectivit&eacute;s locales.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;Monsieur le Directeur</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;J\'ai l\'honneur de solliciter de votre bienveillance la possibilit&eacute; de rachat des droits &agrave; pension pour</p>\r\n<p>des services que j\'ai accomplie du 01/09/1971 au 31/08/1973 aupr&egrave;s d\'une collectivit&eacute; locale.</p>\r\n<p>&nbsp;Je vous joins en vue d\'examen la lettre que j\'ai recu en date du 29/10/1975 ainsi que mon relev&eacute; de carri&egrave;re &eacute;tabli&nbsp;</p>\r\n<p>par la Caisse G&eacute;n&eacute;rale de S&eacute;curit&eacute; Sociale de la R&eacute;union.</p>\r\n<p>En vous remerciant de votre compr&eacute;hension,veuillez agr&egrave;er,Monsieur me Directeur,l\'assurance</p>\r\n<p>&nbsp;de ma haute consid&eacute;ration.</p>'),(10,'2014-01-07','CRC \r\nCentre de Gestion de Saint Denis\r\n2B Ruelle Pavée\r\nBP 1071\r\n97482 St Denis','<p>Monsieur le Directeur</p>\r\n<p>J\'ai bien recu votre courrier du mois de d&eacute;cembre 2013 dont je vous joins une copie.</p>\r\n<p>Veuillez noter que mon cabinet exerce sous forme de SELARL Dr Bernard TANGUY et non en nom personnel.</p>\r\n<p>Au titre de la SELARL les cotisations pour les deux salari&eacute;s que j\'embauche ont &eacute;t&eacute; bien d&eacute;clar&eacute;s et pay&eacute;s.Je vous adresse copie de la derni&egrave;re DUCS .</p>\r\n<p>Veuillez je vous prie faire les rectificatifs avec les n&eacute;cessaires annulations.</p>\r\n<p>Je vous prie d\' agr&eacute;er,Monsieur le Directeur,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>&nbsp;</p>\r\n<p>Docteur Bernard TANGUY.</p>'),(11,'2014-01-13','Greffe des Associations\r\nDirection de la Jeunesse,des Sports et de la Cohésion Sociale,\r\n14,Allée des saphirs,\r\nCS 61044, \r\n97404 St Denis Cedex','<p>Monsieur le Directeur,</p>\r\n<p>Je vous prie de trouver ci-joint les nouveaux statuts de la Soci&eacute;t&eacute; de Pneumologie de l\'Oc&eacute;an Indien (SPOI) adopt&eacute; lors de l\'Assembl&eacute;e G&eacute;n&eacute;rale extraordinaire du 27/11/2013 ainsi que les proc&eacute;s verbaux de l\'Assembl&eacute;e G&eacute;n&eacute;rale et extraordinaire du 27/11/2013.</p>\r\n<p>Je me permets de vous rappeler que la SPOI a &eacute;t&eacute; d&eacute;clar&eacute; le 21/02/1996 &agrave; la Pr&eacute;fecture de la R&eacute;union.</p>\r\n<p>Je vous joins une enveloppe timbr&eacute; pour le recipiss&eacute; de r&eacute;ception.</p>\r\n<p>&nbsp;</p>\r\n<p>Veuillez agr&eacute;er,Monsieure le Directeur,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(12,'2014-01-15','','<p>Mme &nbsp;Dominique TANGUY n&eacute;e LHERIAU,</p>\r\n<p>8,All&eacute;e des Turquoises,</p>\r\n<p>97400,Saint Denis,</p>\r\n<p>Ile de la R&eacute;union.</p>\r\n<p>le 16 janvier 2014.</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M.le Directeur</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;MDPH R&eacute;union,</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;13,rue Fenelon,</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; B.P.60183,</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;97464,Saint-Denis C&eacute;dex.</p>\r\n<p>&nbsp;</p>\r\n<p>Objet:<strong>Demande de reconnaissance de la qualit&eacute; de travailleur handicap&eacute;.</strong></p>\r\n<p>Monsieur le Directeur,</p>\r\n<p>J\'ai l\'honneur de demander une reconnaissance de travailleur handicap&eacute;.</p>\r\n<p>Je vous transmet &agrave; cet effet un dossier rempli par mon m&eacute;decin r&eacute;f&eacute;rent et du travail.</p>\r\n<p>Veuillez agr&eacute;er,Monsieur le Directeur,l\'assurance de ma haute consid&eacute;ration,</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mme D.TANGUY.</p>');
/*!40000 ALTER TABLE `courrier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `courrier_client`
--

DROP TABLE IF EXISTS `courrier_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `courrier_client` (
  `id_courrier` int(11) NOT NULL AUTO_INCREMENT,
  `id_client` int(11) NOT NULL,
  `date` date NOT NULL,
  `destinataires` text NOT NULL,
  `corps` text NOT NULL,
  PRIMARY KEY (`id_courrier`),
  KEY `id_client` (`id_client`),
  CONSTRAINT `courrier_client_ibfk_1` FOREIGN KEY (`id_client`) REFERENCES `clients` (`id_client`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1368 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `courrier_client`
--

LOCK TABLES `courrier_client` WRITE;
/*!40000 ALTER TABLE `courrier_client` DISABLE KEYS */;
INSERT INTO `courrier_client` VALUES (15,175,'2013-08-14','Dr Zimny','<p>Cher Consoeur,</p>\r\n<p>J\'ai vu ce jour en consultation Mme Janolat M. Rose Luce, n&eacute;e le 21/05/1947, que j\'avais fait op&eacute;rer d\'un cancer du poumon en juin 2010. Cette dame est non fumeuse et pr&eacute;sente comme facteur de risque une ob&eacute;sit&eacute; (94kg pour 1m60), avec un diabete insulino-d&eacute;pendant et une hypertension art&eacute;rielle. Son p&eacute;rimetre cervical est &agrave; 44 cm avec p&eacute;rimetre abdominal &agrave; 131 cm. Le score d\'Epworth est a 9/15, avec une dyspn&eacute;e grade 4 du Modified Medical Research Concil. L\'auscultation pulmonaire est ce jour normal, et l\'&eacute;chographie doppler des membres inf&eacute;rieurs retrouve un lymphoed&egrave;me. La patiente sera revue pour une EFR le 3/09/2013 &agrave; 9h, et aura une polygraphie nocturne le 30/10/2013 &agrave; 16h.</p>\r\n<p>Nous prevoyons chez elle un scanner thoracique de controle en fin d\'ann&eacute;e. Il convient de lui renouveller :</p>\r\n<p>- Aerosolth&eacute;rapie (Bricanyl Atrovant) x 3 / j</p>\r\n<p>- Onbrez 150&nbsp;&micro;g 1B / j</p>\r\n<p>- Spirova Respimat 2B / j</p>\r\n<p>- kin&eacute;sie resoiratoire, technique de ventilation dirig&eacute;e, x 3 / semaine &agrave; domicile</p>\r\n<p>- OLD de confort</p>\r\n<p>&nbsp;</p>'),(16,177,'2013-08-14','Dr. Jean François HALLET\r\nDr. Jean Paul LEONARD','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MANORO Gabriel.</p>\r\n<p>Ce patient pr&eacute;sente des ant&eacute;c&eacute;dents charg&eacute;s. Une insuffisance respiratoire du &agrave; son tabagisme (60 paquets/ann&eacute;es). Un alcoolisme sevr&eacute;, une maladie d\'Alzheimer, des st&eacute;noses art&eacute;riels de l\'art&egrave;re sous-clavi&egrave;re gauche op&eacute;r&eacute;. Le patient pr&eacute;sente une dyspn&eacute;e grade III du mMRC. L\'auscultation pulmonaire est sans particularit&eacute;. Je le reverrai le 3/09/2013 pour une EFR et adpater son traitement. Je demande ce jour une gazom&eacute;trie &agrave; air ambiant.</p>\r\n<p>En attendant, je le place sous Ombrez 150&micro;g 1B/jour, Spiriva Respimat 2B/ jour, Miflonil 400 et kin&eacute; respiratoire technique ventilation dirig&eacute;e, 20 s&eacute;ances / mois au domicile du malade. Il sera revu en consultation le 29 octobre 2013, &agrave; 8h30.</p>\r\n<p style=\"text-align: left;\">Confraternellement,</p>\r\n<p style=\"text-align: right;\">Docteur Bernard TANGUY</p>'),(25,174,'2013-08-28','Dr jean marie VIRAPOULLE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour en consultation:M./Mme/L\'enfant KAROUMBATA H&eacute;l&egrave;ne n&eacute;e le....18/08/1934;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note....un p&egrave;re asthmatique.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents personnels:</p>\r\n<p>Chirurgicaux....une appendicectomie</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;un abc&egrave;s de la jambe gauche</p>\r\n<p>M&eacute;dicaux.........un diab&egrave;te insulino d&eacute;pendant</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;une HTA</p>\r\n<p>Mme K...est non fumeuse mais cuisinait au feu de bois dans son enfance.</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Elle exerce la profession de ....assistante maternelle</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;elle est c&eacute;libataire sans enfant.</p>\r\n<p>Histoire de la Maladie:</p>\r\n<p>Mme K... a pr&eacute;sent&eacute; ses premi&egrave;res \"crises d\'asthme\" &agrave; l\'age de 21 ans &agrave; la suite d\'une bronchite.</p>\r\n<p>Elle est actuellement trait&eacute; par FORADIL,MIFLONIL,SPIRIVA RESPIMAT et KINESIE THERAPIE RESPIRATOIRE.</p>\r\n<p>Actuellement &agrave; l\'examen clinique on note une diminution des bruits pulmonaires sth&eacute;tacoustiques;</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re peu r&eacute;versible aux b2mimetiques avec distension pulmonaire et augmentation des resistances des voies a&eacute;riennes;Je demande chez elle un TDM thoracique sans injection.</p>\r\n<p>Au total le tableau clinique est plus en faveur d\'une BPCO que d\'un asthme.</p>\r\n<p>D\'ou necessit&eacute; du TDM thoracique sans injection lors de la consultation du 18/10/2013 pour readapter &eacute;ventuellement son traitement.</p>\r\n<p>Veuillez agr&egrave;er,cher Confr&egrave;re,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p style=\"text-align: right;\">Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(29,325,'2013-08-29','Dr Lai Fat Fin\r\n97420 Le Port','<p>Cher Confr&egrave;re et ami</p>\r\n<p>Merci de m\'avoir adress&eacute; Mme Colette BOTO n&eacute;e le 25/05/1959.</p>\r\n<p>Cette dame mari&eacute;e, 3 enfants travaille avec son mari dans un atelier de m&eacute;canique.</p>\r\n<p>Sa m&egrave;re a d&eacute;clench&eacute; un asthme tardivement .Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour fibrome ut&eacute;rin en 2004 et une allergie &agrave; l\'aspirine se traduisant par un oed&egrave;me de la face avec oppression thoracique.</p>\r\n<p>Histoire de la maladie:Mme Boto a debut&eacute; un asthme il y a 2 ans &agrave; la R&eacute;union apr&egrave;s une reunion en famille.</p>\r\n<p>Elle a &eacute;t&eacute; 2 fois aux Urgences pour asthme : en janvier 2013 au CHGM et aux urgences du CHU de Toulouse.</p>\r\n<p>Actuellement Mme Boto pr&eacute;sente environ une crise d\'asthme tous les 4 mois.</p>\r\n<p>Elle habite dans un appartement sans animaux.</p>\r\n<p>Elle est trait&eacute; par Symbicort 400 1BX2/J.</p>\r\n<p>La radiographie de Mme Boto est normale si ce n\'est un sd bronchique lobaire inf&eacute;rieur bilat&eacute;ral.</p>\r\n<p>La NFS ne retrouve pas d\'eosinophilie.</p>\r\n<p>Je demande ce jour un scanner des sinus maxillaires &agrave; la recherche d\'une polypose rhinosinusienne pour &eacute;liminer un syndrome de Widal;un dosage des Ige Totales et des RAST aux pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.</p>\r\n<p>Mme Boto aura une EFR le 02/09/2013 &agrave; 15:15.</p>\r\n<p>Je la reverrai &agrave; ce moment;</p>\r\n<p>Avec mes remerciements veuillez agr&egrave;er, Cher Confr&egrave;re et ami, l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p style=\"text-align: right;\">Dr B.TANGUY.</p>'),(30,166,'2013-08-29','Dr DIVI','<p>Cher Confr&egrave;re et ami</p>\r\n<p>j\'ai revu ce jour M.DALLEAU Moise n&eacute; le 24/012/1948.</p>\r\n<p>il a une bonne observance de sa PPC avec une moyenne d\'utilisation de 7H50 par nuit ;L\'IAH moyen est de 2,7/H de sommeil.</p>\r\n<p>L\'EFR retrouve un syndrome d\'insuff:resp:restrictif mod&eacute;r&eacute; avec CPT &agrave; 74%,VR &agrave; 67%,VGT &agrave; 73%.le VEMS est &agrave; 2,43L soit 77&ugrave; de la norme;</p>\r\n<p>En revanche la BMI reste elev&eacute;e 36.3 avec une obesit&eacute; s&eacute;v&egrave;re;Le patient a repris 4K et p&egrave;se ce jour 110kilos;</p>\r\n<p>Le perim&egrave;tre abdominal est &agrave; 118cm et le perimetre cervical &agrave; 43 cm. Le score de Mallampati est de 3/4.</p>\r\n<p>M. Dalleau sera revu en Cs &nbsp;le 16/10/2013.</p>\r\n<p>Recevez l\'assurance de mes amiti&eacute;s</p>\r\n<p>Dr B.TANGUY.</p>'),(31,231,'2013-08-29','Médecin\r\nEPSM','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme Patricia Marcelin, n&eacute;e le 30/01/1965, hospitalis&eacute;e chez vous pour psychose chronique et diabete de type 2.</p>\r\n<p>Cette patiente continue malheuresement &agrave; fumer 10 cigarettes par jour. Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'echelle du Modified Research Council. Elle pr&eacute;sente une toux avec expectoration quotidienne. L\'oscultation retrouve des ronchies dans les 2 champs pulmonaire.</p>\r\n<p>J\'aimerai pouvoir disposer d\'un scanner thoracique sans injection lors de sa prochaine consultation du 16/10/2013 &agrave; 14h.</p>\r\n<p>L\'EFR (cf ci-joint) retrouve des trouble ventilaoire mixte relativement moder&eacute; GOLD II moder&eacute; dans sa composante obstructive.</p>\r\n<p>Il convient de la placer sous ombrez 150 &micro;g, miflonil 400, 1Bx2 avec rin&ccedil;age, et kin&eacute;sith&eacute;rapie respiratoire techniques ventilation dirig&eacute;es, 3 s&eacute;ances semaines pendant 2 mois, ainsi que nicopatch 14mg/24h, 1 patch/24h pendant 6 semaines, puis 7 mg/24h, 1 patch/24h pendant 6 semaines.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(32,331,'2013-08-29','Dr Eric BOURDAIS','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour M. CARPIN Jean Klebert n&eacute; le 10/07/1969.</p>\r\n<p>Ce patient mari&eacute;, 3 enfants travaille &agrave; mi temps therapeutique dans l\'enseignement;</p>\r\n<p>Il a arret&eacute; sa consommation tabagique(il fumait 1 paquet/jour).</p>\r\n<p>Il a subi un quintuple pontage aorto coronarien pour maladie coronarienne tritronculaire le 30/08/2012 par le Dr Braumberger.</p>\r\n<p>Il a eu une readaptation cardiaque au CRF de Ste Clotilde.</p>\r\n<p>Actuellement il prend SPIRIVA&nbsp;RESPIMAT 2B/J.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire restrictif voir mixte &nbsp;mod&eacute;r&eacute; avec VEMS &agrave; 2.68 soit 74% de la norme.le Tiffeneau est &agrave; 91% et CPT &agrave; 77% de la norme.<br />Le Spiriva Respimat qui est utile en cas de distension pulmonaire ne semble pas tr&egrave;s indiqu&eacute;.je conseillerai plutot de l\'OMBREZ 150/j &agrave; passer &agrave; 300/j si bien support&eacute;.la kin&eacute;sie respiratoire est &agrave; poursuivre.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(33,332,'2013-08-29','Dr Pierre BERNARD','<p>Cher Confr&egrave;re</p>\r\n<p>j\'ai revu ce jour M.BOYER Justin Antoine n&eacute; le 01/06/01944</p>\r\n<p>Ce patient IRCG hypercapnique va mieux.</p>\r\n<p>Je demande une radiographie thoracique avec GDS &agrave; AA.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour des ronchi dans les 2 champs;</p>\r\n<p>Je le reverrai le 10/10/2013 pour une EFR et adaptation de son traitement.</p>\r\n<p>En attendra il poursuivra:</p>\r\n<p>Kinesie tt respiratoire,OLD; a&eacute;rosolttt (Bricanyl-atrovent)x2/j;pulmicort 4001X2;Onbrez 150/j;Spiriva Respimat 2B/J.</p>\r\n<p>Veuillez agr&eacute;er,cher confr&egrave;re,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(34,330,'2013-08-29','Dr NOEL  Michel MAMOUDZOU\r\nDr REVEL   CGSS Mayotte\r\ndr ISSAC ISMAEL','<p>Cher confr&egrave;re</p>\r\n<p>J\'ai revu ce jour M.ALHADI ABRAZI Ibrahim n&eacute; le 20/12/1973.</p>\r\n<p>Ce patient non fumeur,mari&eacute; 7 enfants,commercant,a subi une bilobectomie droite (inf&eacute;rieure et moyenne)le 17/04/2012 pour tumeur carcinoide atypique grade 2 &agrave; differenciation papillaire.Il a eu un premier controle en novembre 2012 &agrave; la R&eacute;union &nbsp;.Ce controle &nbsp;n\'avait pas retrouv&eacute; d\'&eacute;volutivit&eacute;.</p>\r\n<p>Un deuxi&egrave;me controle a &eacute;t&eacute; pratiqu&eacute; &agrave; St Germain en Laye en juillet 2013 comportant un scanner thoracique qui avait montr&eacute; un aspect cicatriciel du hile droit;la fibroscopie bronchique du 25/07/2013 a montr&eacute; l\'absence de r&eacute;cidive.</p>\r\n<p>Une EFR a &eacute;t&eacute; pratiqu&eacute; ce jour &agrave; la R&eacute;union et retrouve un trouble ventilatoire restrictif tr&egrave;s mod&eacute;r&eacute;.</p>\r\n<p>En ce qui concerne la surveillance de ce patient je pense qu\'un scanner thoracique est de mise dans 6 mois puis tous les ans.Bien entendu en cas de symptomatologie clinique :hemoptysie,toux,expectorations abondantes un scanner serait de mise imm&eacute;diatement.</p>\r\n<p>Veuillez agr&eacute;er,Chers Confr&egrave;res,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY.</p>'),(35,114,'2013-08-29','Dr PONROUCH','<p>cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en consultation M.TANGA Lucay n&eacute; le 27/07/1972.</p>\r\n<p>Ce patient a une m&egrave;re asthmatique.</p>\r\n<p>M.Tanga pr&eacute;sente des crises d\'asthme depuis l\'age de 30 ans.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; 2 fois pour crises d\'asthme en 2007 et en f&eacute;vrier 2013.</p>\r\n<p>L\'auscultation pulmonaire est ce jour normal mais M. TANGA prend de fortes doses de CS inhal&eacute;s:SERETIDE 500 2B m et s.Il pr&eacute;sente une symptomatologie de Reflux gastro oesophagien &agrave; ttt par Inexium 40 mg m et s avec Gaviscon 1X3.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec dosage IgE totales et RAST aux pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.</p>\r\n<p>Je le reverrai en consultation le 17/10/2013 &agrave; 15:00H.</p>\r\n<p>Veuillez agr&eacute;er Cher Confr&egrave;re l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B.TANGUY.</p>'),(36,333,'2013-08-29','Dr Omarjee\r\nDr Dijoux','<p>Chers confr&egrave;res&nbsp;</p>\r\n<p>J\'ai revu ce jour Mme DOBARIA Marie expedite n&eacute;e le 26/12/1961 et qui pr&eacute;sente un asthme difficile &agrave; traiter.</p>\r\n<p>Elle va actuellement bien sous XOLAIR 375 mg en S/C /mois et qui a &eacute;t&eacute; renouvel&eacute;.</p>\r\n<p>Veuillez agr&eacute;er,Chers confr&egrave;res,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(37,334,'2013-08-29','Dr CHABAS\r\nDr CHANE WOON MING','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai vu ce jour en consultation Mme LUI HIN TSAN Rose Marie n&eacute;e le 10/06/1926.</p>\r\n<p>Cette dame a eu un pontage aorto coronarien en 2001 et est trait&eacute; pour arthrose et HTA avec osteoporose.</p>\r\n<p>Elle pr&eacute;sente depuis sa vaccination anti grippale en juin 2013 du rhume avec eternuement et mal de gorge.</p>\r\n<p>De plus elle pr&eacute;dente une dyspn&eacute;e grade 3 du mMRC.</p>\r\n<p>L\'examen clinique montre une Sao2 &agrave; 95% et une TA &agrave; 16/9.</p>\r\n<p>l\'auscultation retrouve des sous crepitants aux bases;</p>\r\n<p>Je demande une radiographie pulmobnaire avec proBNP et GDS &agrave; AA.</p>\r\n<p>Pour l\'instant je la place sous a&eacute;rosolth&eacute;rapie Bricanyl-atroventX2/j</p>\r\n<p>associ&eacute; &agrave; Kin&eacute;sieth&eacute;rapie respiratoire:technique de Ventilation dirig&eacute;e 3 fois / semaine &agrave; domicile.</p>\r\n<p>Je la reverrai le 26/09/2013 &agrave; 11:30 pour une EFR et adapter son traitement.</p>\r\n<p>Veuillez agr&eacute;er,Chers Confr&egrave;res,l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(38,260,'2013-08-29','',''),(39,336,'2013-08-30','Dr KOENIG','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en cosultation M. GRAVINA Marie Joseph n&eacute; le 02/07/1949.</p>\r\n<p>Ce patient retrait&eacute; commercial est mari&eacute; et a 3 enfants.</p>\r\n<p>Il a eu un AVP (accident de moto) en 1980 et a subi une hepatectomie partielle.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; pour tuberculose pulmonaire il y a 2 ans.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un grandp&egrave;re et une fille asthmatique.</p>\r\n<p>HM: M. Gravina a pr&eacute;sent&eacute; un asthme dans l\'enfance et dit avoir une pachypleurite droite s&eacute;quellaire de sa tuberculose.</p>\r\n<p>M. Gavina pr&eacute;sente une dyspn&eacute;e grade 2 de l\'&eacute;chelle du mMRC.</p>\r\n<p>A l\'examen clinique on note une diminution des bruits pulmonaires sthetacoustiques.</p>\r\n<p>On demande ce jour un TDM thoracique, une gazometrie &agrave; AA et une NFS-Plaquette.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire mixte avec CPT &agrave; &nbsp;65% de la norme, le VR est &agrave; 68% de la norme.On note une composante obstructive Gold II, mod&eacute;r&eacute;, avec VEMS &agrave; 55% de la norme. La TLCO est &agrave; 84% de la norme donc sans particularit&eacute;.</p>\r\n<p>Je pr&eacute;conise chez lui le Vaccin antigrippal annuel; le Pneumo23 tous les 5 ans, onbrez 150 microg/j et la kin&eacute;sieth&eacute;rapie respiratoire 3 s&eacute;ances par semaine pendant 2 mois.</p>\r\n<p>Le traitement sera r&eacute;adapt&eacute; en fonction des r&eacute;sultats des EFR.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(40,52,'2013-08-30','Dr leveque','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation M. Dijoux Valere n&eacute; le 22/10/1940.</p>\r\n<p>Ce patient est un ancien fumeur 2 pqt/j sevr&eacute; il y a 28 ans.</p>\r\n<p>Il exercait la profession d\'agent d\'entretien au CHD. Il est mari&eacute; et a 4 enfants.</p>\r\n<p>Il a subi une lobectomie inf&eacute;rieure gauche le 23/07/2012 par le Dr Navarro pour un adenocarcinome pulmonaire inf&eacute;rieure gauche TTF1+ Std IIb suivie d\'une chimioth&eacute;rapie adjuvante qui l\'avait beaucoup fatigu&eacute;.</p>\r\n<p>Actuellement il va bien. L\'ausculation pulmonaire ne retrouve que quelques ronchi aux bases.</p>\r\n<p>Le TDM thoracique sans injection pratiqu&eacute; le 3/08/2013 retrouve des s&eacute;quelles de la lobectomie inf&eacute;rieure gauche, avec absence d\'adenopathie. Integrit&eacute; du foie,des reins, de la rate et des surrenales. Absence de l&eacute;sion osseuse secondaire. La biologie montre un taux d\'Hb &agrave; 12.8g/dl.</p>\r\n<p>L\'EFR est dans les limites de la normale.</p>\r\n<p>Dans ses conditions je reverrai M.Dijoux en surveillance dans 3 mois.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr. B. TANGUY</p>'),(41,125,'2013-08-30','Dr Cyndie JAGLALE-LETNIOWSKI','<p>Ch&egrave;re Consoeur</p>\r\n<p>j\'ai revu ce jour l\'enfant Lauriane SANDANOM n&eacute;e le 20/01/2007.</p>\r\n<p>Cette enfant pr&eacute;sente un terrain atopique avec des IgE sup&eacute;rieur &agrave; 2500UI/ml.</p>\r\n<p>Les RAST sont n&eacute;gatifs aux Trophallerg&egrave;nes et faiblement positifs aux phan&egrave;res de chien.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>La radiographie pulmonaire montre un &eacute;paississement muqueux bronchique aux bases.</p>\r\n<p>L\'EFR montre une spirographie subnormale avec am&eacute;lioration du VEMS de 4% sous b2 inhal&eacute;s, avec des signes de distension pulmonaire : VGT &agrave; 196%, CPT &agrave; 123%, VR &agrave; 194%de la norme. Les Resistances des voies a&eacute;riennes sont augment&eacute;es &agrave;n 0.91 pour une normale inf&eacute;rieure &agrave; 0.58.</p>\r\n<p>Je conseille la poursuite du Seretide 125 microg 1B m et s avec rin&ccedil;age de la bouche et Singulair 5 mg le soir.</p>\r\n<p>Je la reverrai en consultation le 01/11/2013 &agrave; 16H.</p>\r\n<p>Veuillez agr&eacute;er, ch&egrave;re consoeur, l\'assurance de mes hommages;</p>\r\n<p>Dr B. TANGUY.</p>'),(42,216,'2013-08-30','Docteur GAZAILLE\r\nCentre Hospitalier Universitaire de la Réunion','<p>Cher ami,</p>\r\n<p>Suite &agrave; notre conversation du 29 Ao&ucirc;t 2013,&nbsp;il convient d\'envisager pour Mme Mouniapin Sabrina n&eacute;e le 06/09/1974, une courte hospitalisation au Service des Maladies Respiratoires du CHU F&eacute;lix Guyon.</p>\r\n<p>Cette patiente pr&eacute;sente une maladie de Rendu-Osler avec de multiples malformations art&eacute;rioveineuses des deux champs pulmonaires &agrave; pr&eacute;dominance droite. Elle a b&eacute;n&eacute;fici&eacute; en septembre 2009 d\'une embolisation pulmonaire bilat&eacute;rale &agrave;&nbsp;l\'H&ocirc;pital Ambroise Par&eacute;.</p>\r\n<p>Son &eacute;tat s\'est aggrav&eacute; depuis le d&eacute;but de l\'ann&eacute;e, et elle recommence &agrave; avoir des h&eacute;moptysies. J\'avais &eacute;cris aux professeurs Chinet et Lacombe le 10 mai 2013 et vous trouverez une copie de cette lettre dans son dossier. J\'ai re&ccedil;u un courrier du Pr. Lacombe qui confirme un rendez-vous d\'hospitalisation &agrave;&nbsp;l\'H&ocirc;pital Ambroise Par&eacute; le mercredi 18 Septembre &agrave; 14h. Je vous ai remis un double de cette convocation. L\'&eacute;tat respiratoire de Mme Mouniapin Sabrina est tr&egrave;s pr&eacute;caire et les gaz du sang montrent un PH &agrave; 7.42, PCO2 44 TORR; PO2 47 TORR, CO2T 29, saturation 84%. L\'&eacute;preuve fonctionnelle respiratoire retrouve un trouble ventilatoire de nature mixte et s&eacute;v&egrave;re, avec VEMS &agrave; 32% de la norme. C\'est la raison pour laquelle cette patiente ne peut voyager qu\'avec accompagnement m&eacute;dical et elle souhaiterait &ecirc;tre hospitalis&eacute;e au pr&eacute;alable.</p>\r\n<p>Je vous serais reconnaissant de bien vouloir programmer une hospitalisation en pneumologie avant son d&eacute;part et me le faire savoir.</p>\r\n<p>Veuillez agr&eacute;er, cher ami, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr. B. TANGUY</p>'),(43,46,'2013-09-02','Dr. Marc AZZOLIN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en consultation Mme ECLAPIER Marie Suzette n&eacute;e le 04/04/1939.</p>\r\n<p>Cette dame mari&eacute;e 10 enfants ne pr&eacute;sente pas d\'ant&eacute;c&eacute;dents m&eacute;dico-chirurgicaux notable &agrave; part d\'un tremblement essentiel suivi par le Dr Dandelot &agrave; l\'&eacute;poque.</p>\r\n<p>Histoire de la Maladie: Mme Eclapier a &eacute;t&eacute; hospitalis&eacute;e le 23/12/2012 pour une dyspn&eacute;e aigue au CHGM.&nbsp;</p>\r\n<p>Actuellement elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du modified Medical Research Council avec sous traitement r&eacute;gression de la toux et de l\'expectoration.</p>\r\n<p>La Sao2 est &agrave; 93% et le pouls &agrave; 98.La TA est &agrave; 13/9</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les 2 champs pulmonaires.</p>\r\n<p>L\'EFR a montr&eacute; un Trouble Ventilatoire Obstructif Gold II avec distension pulmonaire: VGT &agrave; 126%,VR &agrave; 130% et augmentation de la r&eacute;sistance des voies a&eacute;riennes.</p>\r\n<p>La gazom&eacute;trie &agrave; AA montre: pH 7,41 pO2 61 Torr pCO2 48 Torr SaO2 90%.</p>\r\n<p>La radiographie thoracique retrouve des S.de distension thoracique avec aplatissement des coupoles diaphragmatiques, grosses A. pulmonaires et accentuation de la trame vasculaire dans les 23 champs pulmonaires. Il convient de poursuivre chez cette dame vaccination anti grippale tous les ans, pneumo 23 tous les 5 ans, OLD avec ISIS M&eacute;dical 2L/mn, Kin&eacute;sith&eacute;rapie respiratoire technique de ventilation Dirig&eacute;e tous les jours, A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent) x 2/jour, et PulmicortX2/j avec rin&ccedil;age de la bouche &agrave; l\'eau.</p>\r\n<p>Je la reverrai en consultation le 06/11/2013.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(44,364,'2013-09-02','Dr. NEGREL','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation M.GIRAUD Eric n&eacute; le 31/12/1959 qui a &eacute;t&eacute; trait&eacute; par chimio et radioth&eacute;rapie 6 s&eacute;ances de septembre 1995 &agrave; f&eacute;vrier 1996 pour un carcinome pulmonaire &agrave; petites cellules. Il a ensuite&nbsp;&eacute;t&eacute; op&eacute;r&eacute; en juillet 1996 par lobectomie sup&eacute;rieure gauche. Il persiste &agrave; titre s&eacute;quellaire au scanner thoracique un nodule de 9 mm du lobe inf&eacute;rieur droit.</p>\r\n<p>Actuellement ce patient est en r&eacute;mission totale mais a besoin d\'un suivi th&eacute;rapeutique.</p>\r\n<p>Il convient donc qu\'il puisse pour ce faire avoir le renouvellement de son ALD.</p>\r\n<p>Je le reverrai &nbsp;le 04/03/2014 &agrave; 11H pour une EFR.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B. TANGUY.</p>'),(45,369,'2013-09-02','Dr DOUSSAUD','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation M. Bacco Alix J. Michel n&eacute; le 16/08/1963.</p>\r\n<p>Je l\'avais vu au CHU pour une hemoptysie en septembre 2012.</p>\r\n<p>Le scanner thoracique avait retrouv&eacute; un infitrat du lobe inf&eacute;rieur gauche qui a r&eacute;gress&eacute; sur le TDM d\'avril 2013. La fibroscopie bronchique &eacute;tait normale.</p>\r\n<p>En revanche nous lui avons retrouv&eacute; une HTA &agrave; 16/9 que nous vous laissons le soin d\'explorer et de traiter.</p>\r\n<p>M. Bacco aura un scanner de controle le 03/10/2013 et je le reverrai par la suite.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(46,119,'2013-10-09','Dr Laurence DOUMERCQ\r\nSainte-Marie','<p>Ch&egrave;re Consoeur,</p>\r\n<p>J\'ai revu en consultation ce jour, Mme VIRAPIN CAROUMBIN Marie Jocelyne n&eacute;e le 06/12/1968 &nbsp;vivant en concubinage 2 enfants.</p>\r\n<p>Cette dame sans profession est non fumeuse.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents familiaux on note 5 soeurs asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels un grave AVP &agrave; l\'age de 12 ans avec coma.</p>\r\n<p>Son asthme s\'est d&eacute;clench&eacute; assez tardivement &agrave; l\'age de 39 ans. Elle faisait des crises s&eacute;v&egrave;res avec malaise.</p>\r\n<p>Son environment familial lui pose probl&egrave;me avec un fils alcoolique.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR son asthme s\'est am&eacute;lior&eacute;.</p>\r\n<p>L\'auscultation pulmonaire retrouve toujours le freinage expiratoire d&eacute;clenchant la toux.</p>\r\n<p>L\'EFR a montr&eacute; un Trouble &nbsp;Ventilatoire obstructif GOLD II mod&eacute;r&eacute; avec VEMS &agrave; 69% ainsi que des signes de distension pulmonaire : VGT &agrave; 166%, CPT &agrave; 115%, VR &agrave; 196%. Troubles du transfert, TLCO &agrave; 58% de la norme.</p>\r\n<p>Le scanner thoracique du 26/09/2013 a montr&eacute; un &eacute;paississement des parois bronchiques sans DDB ni remaniement parenchymateux.</p>\r\n<p>XOLAIR 375 mg X2/mois; SYMBICORT 400 2BX2;SINGULAIR 10 mg/j associ&eacute; &agrave; SPIRIVA RESPIMAT 2B/J</p>\r\n<p>Je la reverrai le 09/10/2013 &agrave; 15:00.</p>\r\n<p>Veuillez agr&eacute;er, ch&egrave;re Consoeur, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(47,120,'2013-09-02','Dr KAPLER\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour M.ALEXIS Jean Claude n&eacute; le 12/12/1944.</p>\r\n<p>Ce patient ancien fumeur 2pqts / jour est sevr&eacute; depuis 6 ans.</p>\r\n<p>Il exer&ccedil;ait la profession de ma&ccedil;on carreleur; il est mari&eacute; et a 4 enfants.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels il a eu une r&eacute;section endoscopique de la prostate en 1984 et une angioplastie coronarienne. Il est trait&eacute; pour DID.</p>\r\n<p>Actuellement il pr&eacute;sente une dyspn&eacute;e Stade II /III du mMRC; un ronflement avec Score d\'Epworth &agrave; 7/20;score de Mallampati &agrave; 3.</p>\r\n<p>La radiographie thoracique retrouve une accentuation de la trame vasculaire avec redistribution vasculaire vers les sommets.</p>\r\n<p>Les GDS &agrave; AA montrent : pH &agrave; 7,37, pCO2 &agrave; 52Torr pO2 &agrave; 68 torr SaO2 &agrave; 93%.Hct &agrave; 39,6%.</p>\r\n<p>L\'EFR montre un Sd Ventilatoire Mixte mod&eacute;r&eacute; avec CPT &agrave; 63%et augmentation des r&eacute;sistances des voies a&eacute;riennes, distension pulmonaire VR &agrave; 113% sans tr du transfert.</p>\r\n<p>M.Alexis est trait&eacute; par OLD, Kin&eacute;sith&eacute;rapie respiratoire, a&eacute;rosolth&eacute;rapie Bricanyl-AtroventX3;pulmicortX2 avec rincage, Onbrez 300 microg, Spiriva Respimat 2B/j.</p>\r\n<p>Je le reverrai pour une Polygraphie Ventilatoire le 26/09 /2013.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(48,100,'2013-09-02','Dr Ah Sing','<p>Cher Confr&egrave;re,</p>\r\n<p>M. Boyer Pierre n&eacute; le 15/11/1941 pr&eacute;sente un trouble ventilatoire obstructif GOLD III avec VEMS &agrave; 33% de la norme et Tiffeneau &agrave; 45%. Par ailleurs on note des signes de distension pulmonaire s&eacute;v&egrave;re avec VGT &agrave; 240% CPT &agrave; 140% VR &agrave; 265%. Les r&eacute;sistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.97 et il existe des troubles de la diffusion TLCO &agrave; 60%Norme. La GDS &agrave; AA montre pH &agrave; 7.45 pO2 &agrave; 78 Torr pCO2 &agrave; 43 torr. L\'h&eacute;matocrite est &agrave; 46.8%.</p>\r\n<p>J\'attends le r&eacute;sultat du TDM thoracique et je reverrai M. Boyer le 13/11/2013 &agrave; 14:00.</p>\r\n<p>Poursuivre entretemps OLD, kin&eacute;siettt respi; Miflonil 400 1X2; Onbrez 300; Spiriva Respimat 2B/j.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(49,325,'2013-09-02','Dr Lai Fat Fin','<p>Cher Confr&egrave;re et ami,</p>\r\n<p>J\'ai revu ce jour Mme BOTO Colette n&eacute;e le 25/05/1959.</p>\r\n<p>Le scanner des sinus ne retrouve pas de polypose rhinosinusienne ce qui fait qu\'on ne peut parler de Sd de Widal &agrave; proprement dit. Il existe toutefois un discret &eacute;paississement muqueux des sinus maxillaires. Par ailleurs aspect congestif de la muqueuse des fosses nasales avec hypertrophie des cornets, sugg&eacute;rant des ph&eacute;nom&egrave;nes de rhinite.<br />Les IgE totales sont &eacute;lev&eacute;s &agrave; 263UI/ml.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif mod&eacute;r&eacute; sans alt&eacute;ration de la r&eacute;sistance des voies a&eacute;riennes.<br />Je pense qu\'il convient de traiter la sinusite par a&eacute;rosolth&eacute;rapie :</p>\r\n<p>- Pulmicort m et s avec rin&ccedil;age de la bouche et gargarisme</p>\r\n<p>- Eludril gargarisme m et s 15 jrs / mois</p>\r\n<p>- Singulair 10 mg 1 cp le soir</p>\r\n<p>- Poursuivre Symbicort 400 1bX2 avec rin&ccedil;age</p>\r\n<p>- kin&eacute;sie tt respiratoire technique de ventilation dirig&eacute;e 2x/semaine pendant 2 mois;</p>\r\n<p>La patiente sera revue dans 2 mois en consultation.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re et ami, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(50,379,'2013-09-02','Dr. Jean Paul Moreau','<p>&nbsp;Cher Confr&egrave;re et ami,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; M. Hoareau Louis, n&eacute; le 28/04/1935. Ce patient, ancien cultivateur, est un ancien fumeur (1paquet/jour) sevr&eacute; depuis 40 ans.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents familiaux, on note un p&egrave;re asthmatique et dans ses ant&eacute;c&eacute;dents personnels un DID.</p>\r\n<p>M. Hoareau a &eacute;t&eacute; hospitalis&eacute; pour plusieurs exacerbations de BPCO. La Sa02 ce jour est &agrave; 94%, ce qui fait que la gazom&eacute;trie pratiqu&eacute;e le 7/08/2013, qui retrouvait une Sa02 &agrave; 50% &eacute;tait probablement du sang veineux. M. Hoareau pr&eacute;sente une dyspn&eacute;e stade III/IV du mMRC. L\'examen clinique retrouve un signe de Campbell avec cyphose dorsale et augmentation du diam&egrave;tre thoracique ant&eacute;ro-post&eacute;rieur. L\'auscultation montre une diminution des bruits pulmonaires st&eacute;thacoustique. M. Hoareau sera revu le 9/10/2013 pour une EFR et adaptation de son traitement.</p>\r\n<p>Je lui demande de pratiquer en externe une radio pulmonaire et une nouvelle gazom&eacute;trie &agrave; air ambiant. En attendant, il convient de poursuivre chez lui : kin&eacute; respi, OLD, VNI, ombrez 300, spiriva respimat 2b, a&eacute;rosol bricanyl atrovent x 2, et pulmicort x 2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Je vous prie de croire, chez confr&egrave;re et ami, &agrave; l\'assurance de ma haute consid&eacute;ration,<br />Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(51,34,'2013-09-02','Dr Jatob','<p>Cher ami</p>\r\n<p>J\'ai revu ce jour en consultation M.ROBERT Jean Marc n&eacute; le 23/12/1948.</p>\r\n<p>Ce patient pr&eacute;sente un trouble ventilatoire obstructif s&eacute;v&egrave;re Gold III avec VEMS &agrave; 39%.Il existe par ailleurs une distension pulmonaire avec CPT &agrave; 110&ugrave; VR &agrave; 201% et des troubles du transfert TLCO &agrave; 52%.La resistance des voies a&eacute;riennes est augment&eacute; &agrave; 0.65.</p>\r\n<p>Je demande ce jour une gazometrie &agrave; AA et une radiographie pulmonaire.</p>\r\n<p>il convient de poursuivre chez ce patient&nbsp;</p>\r\n<p>a&eacute;rosolth&eacute;rapie bricanyl-atrovent X2</p>\r\n<p>pulmicortx2 avec rincage</p>\r\n<p>Onbrez 300/j</p>\r\n<p>spirivaz respimat 2/j</p>\r\n<p>Kin&eacute;siett respiratoire&nbsp;</p>\r\n<p>OLD ;</p>\r\n<p>Je le reverrai en consultation le 12/11/2013 &agrave; 8:00.</p>\r\n<p>Amiti&eacute;s</p>\r\n<p>Bernard.</p>'),(52,192,'2013-09-02','Dr Dallel\r\nDr Koenig','<p>Chers confr&egrave;res</p>\r\n<p>J\'ai revu ce jour M. SELLY Hubert n&eacute; le 02/11/1945.</p>\r\n<p>Ce monsieur non-fumeur est ancien agent de service d\'usine et de lyc&eacute;e. Il nettoyait les incin&eacute;rateurs.</p>\r\n<p>Il est mari&eacute; et a 6 enfants.&nbsp;Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une hernie ombilicale.&nbsp;Il est suivi par le Dr Genin pour un LED depuis 1978.&nbsp;Il a &eacute;t&eacute; trait&eacute; il y a 30 ans&nbsp;&agrave; l\'hopital St-Joseph (Lyon) pendant un mois par corticoth&eacute;rapie.</p>\r\n<p>Actuellement il est trait&eacute; par Aprovel et lasilix. Il prend du Cortancyl &agrave; raison de 4 mg/J .</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e &nbsp;&eacute;valu&eacute;e au grade 1 de l\'&eacute;chelle du mMRC.</p>\r\n<p>L\'auscultation pulmonaire est normale.</p>\r\n<p>Son IMC est &agrave; 34.1 avec un poids de 83k pour 1m56.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif avec CPT &agrave; 64% VR &agrave; 78% et VEMS &agrave; 54% de la norme.il n\'existe pas de trouble du transfert.</p>\r\n<p>Le scanner thoracique ne montre pas d\'anomalie parenchymateuse pulmonaire; en revanche on note des calcifications des valves mitrale et aortique&nbsp;: une consultation cardiologique est n&eacute;cessaire.</p>\r\n<p>Un r&eacute;gime est n&eacute;cessaire avec musculation des muscles abdominaux.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr. B. TANGUY</p>'),(53,249,'2013-09-02','Dr M. ALIFANO\r\nHopital Cochin, Paris\r\n\r\nDr MAILLOT\r\nSt Paul','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous adresse comme convenu Mme GOASGUEN Marie Pierre n&eacute;e le 02/11/1965 et qui pr&eacute;sente une volumineuse fistule alv&eacute;olopleurale ant&eacute;rieure thoracique droite.</p>\r\n<p>Mme Goasguen est une ancienne fumeuse 1pqt/j et qui actuellement fume 2 &agrave; 3 cigarettes /jour.</p>\r\n<p>Elle a subie le 19 aout 2003 une bilobectomie du lobe sup&eacute;rieure droit et du lobe moyen pour un adenocarcinome class&eacute; pT3 NoMo suivie d\'une radio-chimioth&eacute;rapie au &nbsp;Carbo Taxol.</p>\r\n<p>En mai 2010 elle a eu une thoracostomie axillaire droite pour surinfection aspergillaire de la cavit&eacute; r&eacute;siduelle post op&eacute;ratoire avec pose de plaques d\'urbosorb. La persistance de secr&eacute;tions purulentes provenant de la plaie op&eacute;ratoire a conduit &agrave; une pneumonectomie totale droite en juillet 2011(lobectomie inf&eacute;rieure droite). L\'infection chronique de la cavit&eacute; de pneumonectomie s\'est poursuivie et la fistule s\'est major&eacute;e.</p>\r\n<p>Nous sommes actuellement dans une impasse th&eacute;rapeutique concernant cette patiente &agrave; la R&eacute;union et je vous l\'adresse en vous remerciant pour ce que vous ferez pour elle.</p>\r\n<p>Je vous prie d\'agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY</p>'),(56,307,'2013-09-03','Medecin Anesthesiologiste Clinique sainte Clotilde\r\nDr Jacques BLAIS\r\nDr LAJAT \r\nDr ADRIOUCH ASDR','<p>&nbsp;Chers Confr&egrave;res,</p>\r\n<p>&nbsp;</p>\r\n<p>Meci d\'examiner M. HOARAU Jacques Nelo n&eacute; le 11/11/1958 en vue de la pose d\'une GPE le 09/09/2013.</p>\r\n<p>Ce patient est atteint d\'une Scl&eacute;rose Lat&eacute;rale Amyotrophique depuis 2008 pour la famille &agrave; la suite d\'une vaccination contre la leptospirose. Son &eacute;tat s\'est aggrav&eacute; depuis et je l\'avais vu en Neurologie au CHU de Bellepierre pour mise en place d\'une VNI.</p>\r\n<p>Il ne s\'est pas pr&eacute;sent&eacute; &agrave; ma consultation le 21/08/2013.</p>\r\n<p>Le Dr ADRIOUCH de l\'ASDR a pos&eacute; l\'indication d\'une GPE.</p>\r\n<p>J\'ai contact&eacute; le Dr BLAIS qui envisage la GPE le 09/09/2013.</p>\r\n<p>En vous remerciant pour ce que vous ferez pour ce malade, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(57,240,'2013-09-03','Dr Ah Sing, St Denis\r\nDr Leung Pin Cardiologue.\r\nDr Poubeau CHU St Pierre','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation Mme Voisin Marie Sylvie n&eacute;e le 11/07/1963 et qui pr&eacute;sente un syndrome d\'Eisenmenger. Mme Voisin est trait&eacute; par TRACLEER depuis plus de 2 ans. Elle ressent parfois des c&eacute;phal&eacute;es avec bouff&eacute;es de chaleur. Les transaminases sont normales. L\'Hb est &agrave; 15.7g/100ml. La cr&eacute;atinin&eacute;mie est &agrave; 83micromol/L avec une Clairance corrig&eacute;e &agrave; 65ml/mn/1.73.</p>\r\n<p>La GDS &agrave; AA montre pH &agrave; 7,46 pCO2 &agrave; 35 pO2 &agrave; 55mmm Hg.</p>\r\n<p>Mme Voisin est actuellement trait&eacute;e par OLD de d&eacute;ambulation; Sintrom 1/2 cp/j Dernier INR &agrave; 2.65 et TRACLEER 1cp m et s.</p>\r\n<p>Je la reverrai le 15/10/2013 pour une EFR.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY</p>'),(58,169,'2013-09-03','Dr Der Kasbarian Michel\r\nSte Suzanne','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ATCHIAMA Jean Christian n&eacute; le 25/07/1955.</p>\r\n<p>Ce patient est trait&eacute; par XOLAIR pour un asthme s&eacute;v&egrave;re difficile &agrave; &eacute;quilibrer.</p>\r\n<p>Depuis l\'instauration de ce traitement il va bien et n\'a plus &eacute;t&eacute; hospitalis&eacute; pour asthme.</p>\r\n<p>L\'auscultation pulmonaire est normale.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif limite GOLD II/III avec un VEMS &agrave; 50% de la Norme. Le Tiffeneau est &agrave; 70%.Il existe des signes de distension pulmonaire avec VR &agrave; 156%CPT &agrave; 102% VGT &agrave; 139%. Les r&eacute;sistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.85. Il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Le traitement est bien adapt&eacute; avec Onbrez 300; Miflonil 400 1X2; Spiriva Respimat 2B/j; Singulair 10mg 1 le s associ&eacute; &agrave; Kin&eacute;sith&eacute;rapie respiratoire 3X/Semaine.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B. TANGUY</p>'),(59,175,'2013-09-03','Dr Jimny','<p>Cher Consoeur,</p>\r\n<p>L\'EFR de Mme Janolat Marie Rose Luce n&eacute;e le 21/05/1947 retrouve un trouble Ventilatoire Mixte avec VEMS &agrave; 1.06 soit 51% de la norme ; le Tiffeneau est &agrave; 78%. Il existe des signes de distension pulmonaire avec VGT &agrave; 115% et VR &agrave; 88%. La CPT est &agrave; 88%. Par ailleurs on note une augmentation des resistances des voies a&eacute;riennes &agrave; 0.84.</p>\r\n<p>Le traitement est bien adapt&eacute;.</p>\r\n<p>Veuillez agr&eacute;er, cher Consoeur, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY</p>'),(60,177,'2013-09-03','Médecin \r\nEHPAD Croix Rouge','<p>Cher Confr&egrave;re,</p>\r\n<p>M. MANORO Gabriel n&eacute; le 31/08/1942 a b&eacute;n&eacute;fici&eacute; ce jour d\'une EFR.</p>\r\n<p>Cet examen montre un trouble Ventilatoire Mixte; la composante obstructive est limite s&eacute;v&egrave;re/tr&egrave;s s&eacute;v&egrave;re Gold III/IV avec un VEMS &agrave; 30% de la norme. Il existe des signes de distension pulmonaire avec VGT &agrave; 184%, CPT &agrave; 110% et VR &agrave; 232% de la norme avec augmentation des R&eacute;sistances des voies a&eacute;riennes.</p>\r\n<p>Les GDS du sang &agrave; AA retrouvent: pH 7,41 pCO2 41Torr pO2 63Torr SaO292%.</p>\r\n<p>Le traitement est bien adapt&eacute; et je le reverrai en consultation le 29/10/2013 avec une radio pulmonaire.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(61,195,'2013-09-03','Dr Martnez','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en consultation Mme SAUTRON Eva Marie Therese n&eacute;e le 11/12/1956.</p>\r\n<p>Cette dame est trait&eacute;e pour sd d\'apn&eacute;e du sommeil par le Dr Omarjee. Elle est &eacute;galement suivie par le Dr Thirapathi pour diab&egrave;te.</p>\r\n<p>Sa derni&egrave;re crise d\'asthme date de juillet 2013.</p>\r\n<p>Mme Sautron est sous XOLAIR 375 mgX 2/mois.</p>\r\n<p>Ses EFR montrent:</p>\r\n<p>Spirom&egrave;trie dans les limites de la Normale.</p>\r\n<p>Pl&eacute;thysmographie: S. de distension pulmonaire: VGT 140% CPT 115% VR 145% et augmentation de la Resistance des voies a&eacute;riennes.</p>\r\n<p>Je la reverrai le 17/10/2013.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY</p>'),(62,35,'2013-09-03','Medecin Conseil MDPH\r\nDr Kapler','<p>Cher Confr&egrave;re,</p>\r\n<p>Vous allez examiner en expertise Mme SEPEROUMAL Marie Rachel n&eacute;e le 03/04/1966 que je suis pour un asthme s&eacute;v&egrave;re difficile &agrave; traiter.</p>\r\n<p>Cette dame non fumeuse est mari&eacute;e, 8 enfants, a un handicap de travail reconnu.</p>\r\n<p>Elle pr&eacute;sente des ant&eacute;c&egrave;dents familiaux d\'asthme.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e de plusieurs nodules thyroidiens avec des l&eacute;sions d\'arthrose rachidiennes.</p>\r\n<p>Son asthme a demarr&eacute; dans l\'enfance.</p>\r\n<p>Elle pr&eacute;sente une multiallergie aux phan&egrave;res de chien, de chat, aux gramin&eacute;es, aux acariens...</p>\r\n<p>Mme Seperoumal pr&eacute;sente un bronchospasme permanent avec freinage expiratoire.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif s&eacute;v&egrave;re avec VEMS &agrave; 33% de la Norme. Par ailleurs il existe une distension pulmonaire avec VGT &agrave; 138% VR &agrave;135% de la norme. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.13.</p>\r\n<p>Le traitement qu\'elle prend est lourd car elle pr&eacute;sente une intol&eacute;rance &agrave; beaucoup de m&eacute;dicaments.</p>\r\n<p>Elle ne supporte que des a&eacute;rosols: Bricanyl -Atrovent et Seretide &agrave; fortes doses;</p>\r\n<p>Son sommeil est tr&egrave;s perturb&eacute; (voir agenda de sommeil) et elle aura une polysomnographie;</p>\r\n<p>En vous remerciant pour votre sollicitude &agrave; son &eacute;gard, je vous prie d\'agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY</p>'),(63,198,'2013-09-03','dr LEGROS','<p>Ch&egrave;re Consoeur</p>\r\n<p>J\'ai revu en consultation ce jour M.SINAPAN Lucien n&eacute; le 02/02/1938.</p>\r\n<p>Ce patient pr&eacute;sente des bronches aux parois &eacute;paissies avec impactions mucoides et de disctretes DDB.</p>\r\n<p>Sur le plan fonctionnel M. Sinapan pr&eacute;sente une toux matinale avec une expectoration blanchatre visqueuse.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire obstructif Gold II mod&eacute;r&eacute; avec un VEMS &agrave; 66&ugrave; de la norme. Il existe des signes de distension pumonaire avec VGT &agrave; 110&ugrave; CPT &agrave; 108% VR 128% de la norme. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.63 sans trouble du transfert.</p>\r\n<p>Les IgE sont augment&eacute;es &agrave; 900UI/ml</p>\r\n<p>J\'avais plac&eacute; ce patient sous cure d\'antibith&eacute;rapie par augmentin qui l\'a amelior&eacute;.</p>\r\n<p>La kinesietherapie respiratoire est &agrave; poursuivre associ&eacute; &agrave; Onbrez 150 et Spiriva Respimat 2 B/J;</p>\r\n<p>Je le reverrai en consultation le 29 octobre;</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B. TANGUY.</p>'),(64,203,'2013-09-03','Dr Goburdhun','<p>Cher ami</p>\r\n<p>J\'ai revu ce jour Mme NUMA Anne Marie n&eacute;e le 09/05/1926 trait&eacute;e pour asthme s&eacute;v&egrave;re d\'origine allergique par XOLAIR 300mg toutes les 4 semaines en S/C.</p>\r\n<p>Mme NUMA presente dans ses ant&eacute;c&egrave;dents une cardiopathie isch&eacute;mique il y a 2 ans .Elle est trait&eacute; pour HTA.</p>\r\n<p>Elle est veuve et a 6 enfants.</p>\r\n<p>Son asthme est actuellement bien control&eacute; .</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour est dans les limites de la normale.</p>\r\n<p>Elle poursuivra&nbsp;</p>\r\n<p>A&eacute;rosolth&eacute;rapie Bricanyl-AtroventX2/j&nbsp;</p>\r\n<p>Miflonil 400X2/j</p>\r\n<p>Singulair 10mg 1 cp le soir.</p>\r\n<p>et XOLAIR.</p>\r\n<p>Je la reverrai en consultation le 29/10/2013.</p>\r\n<p>je te prie de croire en mes amiti&eacute;s</p>\r\n<p>Dr B.TANGUY.</p>'),(65,390,'2013-10-08','Dr Ibrahim PATEL','<p>Cher ami</p>\r\n<p>Merci de m\'avoir adress&eacute; Mme Velna Mathilde M. France n&eacute;e le 30/01/1939.&nbsp;Dans ses ant&eacute;c&eacute;dents personnels on note une m&egrave;re asthmatique.&nbsp;Mme velna a 3 filles.</p>\r\n<p>Elle exercait la profession de cantini&egrave;re et n\'a jamais fum&eacute;.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels on note un traitement pour HTA par aldactazine et traitement &nbsp;pour hypercholesterol&eacute;mie. Mme Velna est constip&eacute;e chronique.</p>\r\n<p>Elle pr&eacute;sente une toux chronique depuis 5 &agrave; 6 ans apr&egrave;s une fibroscopie gastrique associ&eacute;e &agrave; une coloscopie pour constipation.</p>\r\n<p>Il existe une symptomatologie de reflux gastro oesophagien pouvant &ecirc;tre responsable de la toux chronique.</p>\r\n<p>Je la reverrai pour une EFR le 04/11/2013.</p>\r\n<p>Le scanner thoracique du 28/05/2013 retrouve des DDB minimes lobaires inf&eacute;rieures qui ne semblent pas &agrave; l\'origine de la toux.</p>\r\n<p>Je conseille MOPRAL 40 MG x2/J associ&eacute; &agrave; Gaviscon 1X3 pendant 3 mois.Je lui prescrit un dosage d\'IgE et de RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Je lui ai conseill&eacute; un traitement par son de bl&eacute; ou d\'avoine pour sa constipation qui lui a fait du bien.je lui prescrit du sirop de PNEUMOREL 2 cuil &agrave; soupe m et s.</p>\r\n<p>Avec mes remerciements je te prie de croire en mes sentiments amicaux.</p>\r\n<p>Dr B. TANGUY</p>'),(66,225,'2013-09-03','Dr Bourdais','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme MONTFORT Monique n&eacute;e le 23/05/1960.</p>\r\n<p>Son poids est de 57k avec un taux d\'IgE de 274UI/ml ce qui correspond &agrave; XOLAIR 300mg/mois.je lui fournit une ordonnance de rectification. Les IgE sp&eacute;cifiques sont positifs &agrave; 2 v/s pollens de bouleau &agrave; 1v/S du latex et &agrave; 1 v/s dermatophagoides farinae. Le scanner thoracique retrouve des DDB avec des antig&egrave;nes solubles d\'aspergillus &agrave; 0.3.Nous suspectons une ABPA Aspergillose bronchopulmonaire allergique .</p>\r\n<p>Je demande une recherche d\'aspergillus dans l\'expectoration et une NFS pour recherche d\'une hypereosinophilie.</p>\r\n<p>Veuillez agr&eacute;er, cher confr&egrave;re, l\'assurance de mes sentiments les meilleurs;</p>\r\n<p>Dr B. TANGUY.</p>'),(67,392,'2013-09-03','Dr vinguetama','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. JIBASSIA Jules n&eacute; le 06/10/1939. Il est trait&eacute; pour une BPCO post cuisson feu de bois chez un non fumeur.</p>\r\n<p>Ant&eacute;c&egrave;dents d\'HTA,DNID, AC/FA,insuffisance r&eacute;nale dialys&eacute;, hernie inguinale op&eacute;r&eacute;e,plastie mitrale le 18/11/2011.</p>\r\n<p>Actuellement le patient pr&eacute;sente une dyspn&eacute;e au r&eacute;veil avec des expectorations abondantes parfois sales.</p>\r\n<p>L\'auscultation retrouve des sibilances dans les 2 champs pulmonaires.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Le FEVG est &agrave; 30%.</p>\r\n<p>Je demande ce jour une proBNP avec GDS &agrave; AA,et lui demande de rapporter le scanner thoracique qu\'il a eu &agrave; St Benoit.</p>\r\n<p>En attendant je conseille de poursuivre l\'a&eacute;rosolth&eacute;rapie BRICANYL-ATROVENT X2/j associ&eacute; &agrave; PULMICORTX2/j;Kin&eacute;sieth&eacute;rapie respiratoire,Onbrez 150 et Spiriva Respimat 2B/j.</p>\r\n<p>Je le reverrai le 24/09/2013 pour des EFR et r&eacute;adapter son traitement.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(68,85,'2013-09-03','Dr ANDRIATAVY\r\nISIS médical','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme RAKOTONIAINA Voahanginirina n&eacute;e le 17/02/1965.</p>\r\n<p>Cette dame pr&eacute;sente dans ses ant&eacute;c&egrave;dents une appendicectomie avec tachycardie trait&eacute; par propanolol1/4 cp le soir.</p>\r\n<p>Elle est appareill&eacute; par ISIS M&eacute;dical pour sd d\'apn&eacute;e de sommeil.</p>\r\n<p>Elle a pr&eacute;sent&eacute; une embolie pulmonaire le 14/10/2012 probablement du &agrave; la pillule contraceptive.Le traitement anticoagulant a &eacute;t&eacute; arret&eacute; en mai 2013.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>je l\'avais vu pour une EFR le 12/08/2013 &agrave; la suite d\'un bronchospasme avyant necessit&eacute; l\'intervaention de SOS M&eacute;decins.L\'EFR &eacute;tait dans les limites de la normale mais un traitement par FORADIL 1x2 et &nbsp;Miflonil 400 1x2 &nbsp;a &eacute;t&eacute; mis en route et l\'a beaucoup soulag&eacute;.</p>\r\n<p>Actuellement elle ressent une g&egrave;ne dans la gorge &agrave; &nbsp;traiter par gargarisme d\'ELUDRIL.</p>\r\n<p>Je la reverrai en consultation en novembre 2013.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(69,142,'2013-09-03','Dr FECHNER','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme NOEL MURIELLE n&eacute;e le 26/12/1988.</p>\r\n<p>Cette patiente a &eacute;t&eacute; hospitalis&eacute;e pour asthme aigue grave le 07/07/2013 au CHU de Bellepierre.</p>\r\n<p>Je vous avais adress&eacute; en date du 26/07/2013 un courrier au sujet de cette patiente.</p>\r\n<p>L\'EFR du 16/08/2013 a montr&eacute; un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec VEMS &agrave; 45% r&eacute;versible sous b2 mimetiques avec am&eacute;lioration de 38%.Il existait une distension pulmonaire avec VGT &agrave; 126% et VR &agrave; 119%.La TLCO &eacute;tait &agrave; 69% de la norme.</p>\r\n<p>Le TDM thoracique retrouve un aspect de distension thoracique.</p>\r\n<p>Les IgE Totales sont &agrave; 696UI/ml avec des RAST positifs Classe 6 &agrave; Dermatophagoides pteronyssinus et dermatophagoides Farinae .</p>\r\n<p>Compte tenu de son poids de 92 kilos et de son taux d\'IgE Totales de 696 elle pourra pas &nbsp;b&eacute;n&eacute;ficier d\'un traitement par XOLAIR .Mais une surveillance sp&eacute;cialis&eacute;e rapproch&eacute;e s\'impose dans son cas.</p>\r\n<p>Je conseille le traitement suivant:SYMBICORT 400 2BX2 avec rincage de la boucheSingulair 10 mg 1 cp le soir</p>\r\n<p>Kin&eacute;siett respiratoire avec musculation des abdominaux 3 s&eacute;ances / semaine.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(70,287,'2013-09-03','Dr Razakasoa','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme FIGARO marie josephe n&eacute;e le 20/09/1944.</p>\r\n<p>Cette dame pr&eacute;sente un trouble ventilatoire Mixte ,Gold III dans sa compiosante obstructive avec VEMS &agrave; 44% avec r&eacute;versibilit&eacute; de 10% sous b2 mimetiques.</p>\r\n<p>Elle a tir&eacute; b&eacute;n&eacute;fice du traitement par FORADIL MIFLONIL qui est &agrave; poursuivre.</p>\r\n<p>La radiographie thoracique ne montre pas de d&eacute;formation thoracique si ce n\'est un l&eacute;ger aplatissement des coupoles diaphragmatiques.Elle aurait interet &agrave; faire 3 s&eacute;ances / semaine de kin&eacute;sie respiratoire &nbsp;avec musculation des abdominaux.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est normale.</p>\r\n<p>Je la reverrai en d&eacute;cembre 2013.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(71,179,'2013-09-03','Dr janson \r\nDr Degasne','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. PARES Jordy n&eacute; le 02/08/1984.</p>\r\n<p>Ce patient non fumeur ,mari&eacute; un enfant ,pas d\'ant&eacute;c&egrave;dent particulier en dehors d\'une spondylarthrite ankylosante.</p>\r\n<p>son p&egrave;re et sa soeur t ain&eacute;e sont atteints de la meme maladie.</p>\r\n<p>Sa spondylarthrite ankylosante a &eacute;t&eacute; diagnostiqu&eacute; il y a 13 ans avec HLA B27 positif.il pr&eacute;sente aussi un psoriasis cutan&eacute; du cuir chevelu.il est actuellement trait&eacute; depuis un an par REMICADE.</p>\r\n<p>l\'auscultation pulmonaire est normale et M.Pares aeu il y a un an et demi un scanner thoracique normal.</p>\r\n<p>Je lui demande de poursuivre la kin&eacute;sieth&eacute;rapie respiratoire et de musculation;</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour est dans les limites de la normale en particulier il n\'existe pas de trouble du transfert.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(72,143,'2013-09-03','Dr Patrice DOUSSAUD\r\nDr LOLJEEH','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. ESPERANCE Laurent n&eacute; le 01/09/1928.</p>\r\n<p>M.Esperance est un ancien fumeur sevr&eacute; depuis 30 ans et qui se plaint d\'une toux rebelle depuis 2010.</p>\r\n<p>Par ailleurs on note dans ses ant&eacute;c&egrave;dents un glaucome,avec DNID,HTA,retinopathie diabetique.</p>\r\n<p>L\'auscultation pulmonaire retrouve un encombrement bronchique majeur avec ronchi dans les deux champs pulmonaires.</p>\r\n<p>Le TDM thoracique retrouve un &eacute;paissisement des parois bronchiques.avec des micronodules de bronchiolite.</p>\r\n<p>L\'examen cardiologique est satisfaisant.</p>\r\n<p>On note une symptomatologie de reflux gatron oesophagien avec hernie hiatale.</p>\r\n<p>Un traitement anti reflux avec aerosolth&eacute;rapie &agrave; vis&eacute;e bronchodilatatrice a eu un effet favorable doit etre poursuivie avec la kin&eacute;sieth&eacute;rapie respiratoire;</p>\r\n<p>je le reverrai en Novembre 2013.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(73,324,'2013-09-04','Dr Hallet','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. VELLAYE Edmond n&eacute; le 22/11/1933.</p>\r\n<p>Ce patient ancin fumeur totalisant 1pqt/j est sevr&eacute; depuis 30 ans.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une amputation partielle de la jambe droite;un DID,une HTA.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; au CHU de Bellepierre pour d&eacute;compnsation cardiaque.</p>\r\n<p>Sa SaO2 &agrave; AA est &agrave; 98% avec un pouls &agrave; 69.</p>\r\n<p>Je demande ce jour une radio pulmonaire avec GDS &agrave; AA et NFS-plaquettes et je le reverrai le 11/10/2013 pour des EFR avec le r&eacute;sultats des examens demand&eacute;s.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(74,76,'2013-10-08','Dr Kapler\r\nDr Mascarel','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme YOUSSOUF ZAINABA n&eacute;e le 31/12/1966.</p>\r\n<p>Cette dame pr&eacute;sente des ant&eacute;c&egrave;dents de bilobectomie gauche en 2005 pour carcinome pulmonaire.La CT adjuvante a du etre arret&eacute; car mal tol&eacute;r&eacute; par la malade.</p>\r\n<p>Mme Zainaba est une ancienne fumeuse chiqu&eacute; actuellement sevr&eacute;.</p>\r\n<p>Elle pr&eacute;sente un poids de 76K pour une taille de 150 avec un IMC de 33.8ce qui correspond &agrave; une obesit&eacute; moder&eacute;e.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Le score de Mallampati est de 2/3.</p>\r\n<p>Elle dit avoir un sommeil de mauvaise qualit&eacute; avec des ronflements.</p>\r\n<p>Mme Zainaba aura une polygraphie nocturne le 26/11/2013 &agrave; 16:00.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire mixte avec une composante obstructive GoldIi et des troubles du transfert:TLCO &agrave;63% de la norme.</p>\r\n<p>Elle poursuivra le meme traitement mis en route :Onbrez,Spiriva respimat,Formair,Miflonil et kin&eacute;sie respiratoire.</p>\r\n<p>Mme ZAINABA aura un TDM thoracique et surr&eacute;nalien le 7/11/2013 &agrave; 8H.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(75,137,'2013-10-22','Dr Lucien BONNE\r\nDr OMARJEE','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme GRAVINA Anne n&eacute;e le 11/12/1955.</p>\r\n<p>Cette dame est trait&eacute; est suivi par Dr Omarjee et trait&eacute; par moi par XOLAIR.</p>\r\n<p>Son scanner thoracique montre un important &eacute;paississement des parois bronchiques s\'associant &agrave; des bronchoc&egrave;les ,&agrave; des impactions mucoides et &agrave; des nodules bronchog&egrave;nes de bronchiolite.</p>\r\n<p>Il convient d\'&eacute;liminer une ABPA avant d\'incriminer un remodelage bronchique.</p>\r\n<p>Pour ce faire je demande au Dr Omarjee de bien vouloir pratiquer des tests cutan&eacute;s vis &agrave; vis d\'aspergillus fumigatus.</p>\r\n<p>Je redemande un dosage d\'IgE totales.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(76,197,'2013-09-04','Dr Delannoy','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour M. DELNARD Gerald n&eacute; le 27/08/1946.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council. Son EFR retrouve un trouble ventilatoire obstructif GOLD IV, avec un VEMS &agrave; 0,63L, soit 23% de la norme, et un Tiffenau &agrave; 40% de la norme. Il existe par ailleurs une distention pulmonaire majeure, avec VGT &agrave; 203%, CPT 124%, VR 240%. Les resistances des voies a&eacute;riennes sont &eacute;l&eacute;v&eacute;es &agrave; 0,62%, et il existe des troubles du transfert (TLCO &agrave; 62% de la norme).</p>\r\n<p>Les GDS AA : pH 7,4; pCO2 43 TORR; pO2 72 TORR.</p>\r\n<p>Malheuresement, Monsieur Delnard refuse la r&eacute;habilitation respiratoire et a limit&eacute; complement ses efforts. Je lui ai demand&eacute; de poursuivre une kin&eacute;sith&eacute;rapie respiratoire, et de se r&eacute;entrainer grace &agrave; l\'oxyg&eacute;noth&eacute;rapie de d&eacute;ambulation.</p>\r\n<p>Il convient de poursuivre chez lui: OLD, kin&eacute; respi, onbrez 300&micro;g, spiriva respimat 2b/j, a&eacute;rosol bricanyl atrovent et pulmicort. Vacination anti grippale annuelle et pneumo 23 tous les 5 ans.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(78,396,'2013-09-04','Dr Eric Fontaine','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme CADET Marie France n&eacute;e le 09/09/1954.</p>\r\n<p>Mme cadet est mari&eacute; 2 enfants.</p>\r\n<p>Cette dame pr&eacute;sente dans ses ant&eacute;c&egrave;dents familiaux un fils asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une tympanoplastie,varices et appendicectomie ainsi qu\'une rhinite allergique.</p>\r\n<p>elle pr&eacute;sente une allergie &agrave; la penicilline et &agrave; l\'aspirine.</p>\r\n<p>Son asthme a demarr&eacute; &agrave; la R&eacute;union en 1988.</p>\r\n<p>elle n\'a jamais &eacute;t&eacute; hospitalis&eacute; pour asthme, mais son asthme s\'est aggrav&eacute; depuis 6ans,sa derni&egrave;re grosse criqse date de mars 2012.</p>\r\n<p>L\'ausculation pulmonaire est ce jour normal .</p>\r\n<p>Je demande quand meme un TDM des sinus maxillaires pour rechercher une polypose nasale ainsi qu\'un dosage des IgE totales st des RASt aux pneuallergenes et aux trophallergenes.</p>\r\n<p>une EFR sera pratiqu&eacute; le 17/10/2013.</p>\r\n<p>En attendant il convient que mme Cadet poursuive seretide 500 BX2</p>\r\n<p>Aerius 5mg et singulair 10mg 1cp le soir;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>erius 1 cp le soir singulair 10mg 1 cp/jour.</p>\r\n<p>&nbsp;</p>'),(79,397,'2013-09-04','Dr Eric Fontaine','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. CADET Nicole n&eacute; le 06/11/1952.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une amygdalectomie et une appendicectomie.</p>\r\n<p>depuis plusieurs ann&eacute;es il pr&eacute;sente des ronflements dans la deuxieme partie de la nuit et quand il est sur le dos;</p>\r\n<p>son &eacute;pouse a not&eacute; des pauses respiratoires.</p>\r\n<p>Son Score d\'epworth est &agrave; 5/24.</p>\r\n<p>Le score de Mallampati est de 1/2</p>\r\n<p>Nous allons programmer &agrave; M.Cadet une polygraphie ventilatoire et des EFR.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(80,194,'2013-09-04','Dr Say Liang Fat','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme HOAREAU Marie Helene n&eacute;e le 16/03/1947.</p>\r\n<p>Cette dame pr&eacute;sente un asthme s&eacute;v&egrave;re avec DDB ;</p>\r\n<p>Elle est trait&eacute; par VNI,OLD Kin&eacute;sietherapie respiratoire, XOLAIR 150 mg 1X/mois.</p>\r\n<p>Solupred 10 mg/j; A&eacute;rosolth&eacute;rapie:bricanyl-atroventX3 et pulmicortX2/jour.</p>\r\n<p>Vaccination antigrippale annuelle et pneumo 23 tous les 5 ans;</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire note des sibilances dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique retrouve des signes de distension thoracique avec des DDB des bases.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold IV avec un VEMS &agrave; 18% de la norme, un Tiffeneau &agrave; 69% et des signes de distension pulmonaire: VGT &agrave; 272% CPT &agrave; 162% Vr &agrave; 331% les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.03.</p>\r\n<p>la NFS retrouve un Hct &agrave; 41.3% avec des GDS &agrave; AA : pH 7.38 pO2 93.6 pCO2 65.4;</p>\r\n<p>Je la reverrai en consultation le 21/10/2013.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(81,25,'2013-09-04','Dr Fun Yan Yuen\r\nISIS Medical','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. RASOANANTENAINA Edwige n&eacute; le 19/02/1953.</p>\r\n<p>Cette dame pr&eacute;sente un IMC &agrave; 25.8 ce qui correspond &agrave; un surpoids tr&egrave;s mod&eacute;r&eacute;;&nbsp;Son score d\'Epworth est &agrave; 8/24.&nbsp;Son score de Mallampati est &agrave; 2.</p>\r\n<p>elle pr&eacute;sente &agrave; la polysomnographie 248 ronflements/h avec une energie moyenne de 85db;</p>\r\n<p>L\'examen polysomnographique retrouve un index d\'apn&eacute;es hypopn&eacute;es &agrave; 31/h,&nbsp;avec 10 d&eacute;saturation /heure.</p>\r\n<p>Depuis qu\'elle a &eacute;t&eacute; appareill&eacute;, elle est moins somnolente et tol&egrave;re bien l\'appareil.&nbsp;L\'EFR pratiqu&eacute; ce jour est dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(82,338,'2013-09-04','Dr Ponrouch\r\n','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. DELETRE Philippe n&eacute; le 11/03/1947.</p>\r\n<p>Ce patient n\'a jamais fum&eacute;. Il est mari&eacute; 3 enfants et il est un ancien electricien.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note des soeurs asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels on note une appendicectomie avec fracture du M.I. gauche.</p>\r\n<p>M. Deletre ressent une douleur &agrave; type de serrement thoracique ant&eacute;rieur gauche depuis 2011 suite &agrave; une hospitalisation avec perte de conaissance en septembre 2011. D\'apr&egrave;s le malade il s\'agirait d\'une possible crise d\'asthme s&eacute;v&egrave;re qui aurait entrain&eacute; la perte de conaissance?</p>\r\n<p>Ce jour ce patient pr&eacute;sente une SaO2 &agrave; 98 avec un pouls &agrave; 74.</p>\r\n<p>L\'examen clinique retrouve des sibilances dans les 2 champs pulmonaires avec de discrets oed&egrave;mes des 2 chevilles.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 1 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Le Score de Mallampati est &agrave; 2.</p>\r\n<p>Les proBNp sont &agrave; 56 et la NFS dans les limites de la normale.</p>\r\n<p>La radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>Les EFR sont dans les limites de la normale.</p>\r\n<p>Je simplifierai son traitement par:</p>\r\n<p>Symbicort 400 1B m et s.&nbsp;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(83,30,'2013-09-04','Dr Goulamabasse\r\n','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme GOULAMHOUSSEN Kaniza n&eacute;e le 12/12/1930.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>la patiente se plaint de vertiges et de palpiations quand elle dort.Elle pr&eacute;sente 3 nyctiuries.</p>\r\n<p>Le score de Mallampati est de 3 /4 avec des ronflements:215/H averc une energie moyenne de 87db.Il existe &agrave; la polygraphie nocturne 4 d&eacute;saturations/h avec une minimale de 74%.</p>\r\n<p>Je demande ce jour une GDS &agrave; AA,une NFS_plqt,Glyc&eacute;mie avec Hemoglobine glyqu&eacute;,T4 et TSH.</p>\r\n<p>Il faut poursuivre OLD de confort &agrave; 2l/mn surtout le soir,aerosoltherapie Bricanyl-AtroventX2/j +pulmicortX2/j avec rincage de la bouche.La patiente refuse la kin&eacute;sieth&eacute;rapie.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(84,263,'2013-09-04','Dr Corinne CHABAS','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SALAMALA Albert n&eacute; le 26/06/1921.</p>\r\n<p>Il s\'agit d\'un ancien fumeur 2Pqt/j sevr&eacute; en 2003.</p>\r\n<p>M.Salama &eacute;tait un ancien travailleur de force ,veuf 12 enfants.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>l\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec VEMS &agrave; 0.59 soit 40% de la norme;Tiffeneau &agrave; 65% et s.de distension pulmonaire majeurs VGT &nbsp;&agrave; 214% CPT &agrave; 153% et VR &agrave; 251%;les resistances des voies a&eacute;riennes sont &eacute;lev&eacute;es &agrave; 1.09.</p>\r\n<p>Les GDS &agrave; AA montre pH &nbsp;7.45 PaO2 &agrave; 57 Torr pCO2 &agrave; 41 Torr.</p>\r\n<p>Il convient de poursuivre chez lui:</p>\r\n<p>OLD 1.5L/mn</p>\r\n<p>A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 et pulmicortX2 avec rincage</p>\r\n<p>Onbrez 300 et Spiriva Respimat 2B/j et kin&eacute;siesiettt respiratoire tous les jours.</p>\r\n<p>Je le reverrai en novembre avec une radiographie pulmonaire.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(85,2,'2013-09-04','Dr Pothier\r\nDr Beaumont\r\n','<p>Ch&egrave;re Consoeur,</p>\r\n<p>J\'ai vu ce jour M. LEBRETON Pierre n&eacute; le 23/02/1952.</p>\r\n<p>Ce patient a &eacute;t&eacute; trait&eacute; par radioth&eacute;rapie &nbsp;thoracique 15 s&eacute;ances pour un carcinome epidermoide pulmonaire avec metastases c&eacute;r&eacute;brales;</p>\r\n<p>Le controle fonctionnel pratiqu&eacute; ce jour n\'a pas montr&eacute; d\'alt&eacute;ration dfe la fonction respiratoire; il est meme en am&eacute;lioration par rapport au 05/08/2013. La TLCo est pass&eacute; de 62 &agrave; 63%. Le VEMS est pass&eacute; de 1.93 &agrave; 2.37L/mn.</p>\r\n<p>Le TDM thoracique du 26/08/2013 par rapport &agrave; celui du 06/06/2013 montre une diminution de la masse tissulaire.</p>\r\n<p>L\'IRM c&eacute;r&eacute;bral du 03/09/2013 avec injection ne retrouve plus de l&eacute;sion c&eacute;r&eacute;brale.</p>\r\n<p>Je pense que le dossier de ce patient devra etre rediscut&eacute; &agrave; la lumi&egrave;re des nouvelles constatations.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Consoeur, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(86,400,'2013-09-04','Dr Der Kasbarian','<p>Cher confr&egrave;re</p>\r\n<p>&nbsp;</p>\r\n<p>J\'ai vu ce jour Mme VELOU Jeanne n&eacute;e le 17/08/1930.</p>\r\n<p>Sa SaO2 est &agrave; 97% et son pouls &agrave; 77.TA &agrave; 12/7.</p>\r\n<p>Cette dame est atteinte de sd d\'Alzeihmer.</p>\r\n<p>Cette dame ne communique plus et est d&eacute;pendante &agrave; 100%.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire et une GDS &agrave; AA et une NFS plqt.</p>\r\n<p>Je la reverrai le mois prochain;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(87,258,'2013-09-04','Dr CHARLES RABEZIAKA','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme SERY Marianne n&eacute;e le 12/02/1966.</p>\r\n<p>Cette dame pr&eacute;sente un sommeil perturb&eacute; avec 2 &agrave; 3 nyctuiuries ;son score d\'Epworth est normal;</p>\r\n<p>Le score de Mallampati est de 2/4.</p>\r\n<p>la famille a obsev&eacute; des ronflements depuis sa prise en 2011.sa BMI est &agrave; 25.8 ce qui est &agrave; la limite du surpoids.</p>\r\n<p>Son EFR est dans les limites de la normale.</p>\r\n<p>La polygraphie nocturne pratiqu&eacute;e dans la nuit du 28 au 29/08/2013 montre un index d\'apn&eacute;es -hypopn&eacute;s &agrave; 14/heure ce qui est insuffisant pour l\'appareillage.</p>\r\n<p>Toutefois une analyse fine de l\'enregistrement retrouve des evenements de sommeil avec &eacute;crasement de l\'onde de pouls faisant penser &agrave; des micro reveils.de plus on note en d&eacute;but du matin de nombreuses d&eacute;saturations faisant suspecter des &eacute;venements se produisant en sommeil paradoxal(REM+).</p>\r\n<p>Je lui programme un rendez vous de polysomnographie &agrave; distance et lui demande de faire des seances de kin&eacute;siettt de musculation des abdominaux &nbsp;.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(88,186,'2013-09-04','Dr Chane Woon Ming\r\nDr Chabas','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme JEAN BAPTISTE Marie Michelle n&eacute;e le 05/09/1954.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; d\'une EFR qui est dans les limites de la normale.</p>\r\n<p>D\'ailleurs Mme Jean Baptiste est une sportive: aquagym, natation, marche.</p>\r\n<p>Mme Jean baptiste a pr&eacute;sent&eacute; des &eacute;pisodes de parasomnie et des mouvements des jambes dans son sommeil. Elle aura une polygraphie nocturne voire une polysomnographie le 20/11/2013.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(89,403,'2013-09-04','Dr Omarjee\r\nDr Morel\r\nDr Schlossmacher','<p>Cher Bashir,</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour avis Mme AUBRAS Marie Lise, n&eacute;e le 02/03/1958</p>\r\n<p>Cette dame mari&eacute;e 2 enfants employ&eacute;e de banque n\'a jamais fum&eacute;.</p>\r\n<p>Elle pr&eacute;sente une toux chronique depuis &nbsp;novembre 2012.</p>\r\n<p>Elle ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une tuberculose dans l\'enfance.</p>\r\n<p>Actuellement elle pr&eacute;sente une fatigue avec des frissons en plus de la toux.</p>\r\n<p>Il existe des l&eacute;sions scannographiques qui imposent de pratiquer des tubages gastriques voir une fibroscopie bronchique en cas de n&eacute;gativit&eacute; pour &eacute;liminer une reactivation de sa tuberculose pulmonaire;</p>\r\n<p>J\'ai contact&eacute; le Dr Schlossmacher qui s\'occupe de l\'hospitaliser demain en pneumologie et l\'appelera directement.</p>\r\n<p>De plus, je lui prescrit des tubages gastriques en ville;</p>\r\n<p>Avec mes remerciements, je te prie de croire, cher Bashir, &agrave; l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(90,45,'2013-09-05','Dr Hossenboccus','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SAMBENOUN Emilien n&eacute; le 20/02/1934.</p>\r\n<p>Ce malade ancien fumeur 1/2 pqt/j &nbsp;sevr&eacute; depuis 1 an.Ce monsieur est mari&eacute; et a 7 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DID,HTA .&nbsp;</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve des ronchi aux bases.</p>\r\n<p>La radiographie thoracique retrouve des signes de distension thoracique avec augmentation du diam&egrave;tre antero post&eacute;rieur et l&eacute;ger d&eacute;roulement de la ligne aortique gauche.Hct est &agrave; 37.2%</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte avec VEMS &agrave; 54% CPT &agrave; 65% VR &agrave; 76% VGT &agrave; 85%Les GDS &agrave; AA montrent:pH7,48 pO2 91 pCO2 37 Torr.</p>\r\n<p>Il existe une augmentation mod&eacute;r&eacute;e des resistances des voies a&eacute;riennes &agrave; 0.37.La TLCO est abaiss&eacute; &agrave; 54% de la norme.</p>\r\n<p>Sur le plan th&eacute;rapeutique nous allons modifier le traitement en introduisant de l\'Onbrez 150 micrg/j associ&eacute; &agrave; Spiriva respimat 2B/j et Alvesco 160microg/j &agrave; laide d\'une chambre d\'inhalation AeroChamber avec rin&ccedil;age de la bouche par la suite associ&eacute; &agrave; la&nbsp;&nbsp;kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(91,176,'2013-09-05','Dr Leveque\r\nDr Genin','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme ALIDINA Rosemine n&eacute;e le 04/05/1960.</p>\r\n<p>Cette dame a eu une transplantation r&eacute;nale le 15/10/2012.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note des asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels des bronchopneumonies &agrave; Madagascar et surtout une insuffisance r&eacute;nale en 2006.</p>\r\n<p>Elle faisait des crises d\'asthme dans l\'enfance. Sa derni&egrave;re crise d\'asthme date de janvier 2013.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II/III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec quelques sibilances.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold II avec distension thoracique pulmonaire et trouble mod&eacute;r&eacute; de la diffusion. Son traitment comportera d&eacute;sormais:</p>\r\n<p>Symbicort 1BX2 rincage; Spiriva Respimat 2B;kin&eacute;sieth&eacute;rapie respiratoire 3 s&eacute;ances / semaine pendant 1 mois.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(92,405,'2013-09-05','Dr Lai Fat Fin','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. JONIN Stephan n&eacute; le 25/03/1946.</p>\r\n<p>Ce patient est atteint d\'une retinite pigmentaire.</p>\r\n<p>Patient non fumeur, sportif, ancien militaire de carri&egrave;re.</p>\r\n<p>Ant&eacute;c&egrave;dents personnels: rhume de foin,allergie aux pollens et aux acariens.</p>\r\n<p>Appendicectomie et retinite pigmentaire.</p>\r\n<p>Histoire de la Maladie: Asthme d&eacute;but &agrave; l\'age de 22 ans. D&eacute;clench&eacute; par s&eacute;jour dans les Landes.</p>\r\n<p>Actuellement trait&eacute; par FORADIL et BRICANYL. Ne prend pas de corticosteroide inhal&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est ce jour normale.</p>\r\n<p>Le scanner thoracique retrouve un &eacute;paississement des parois bronchiques faisant suspecter un remodelage bronchique;</p>\r\n<p>Je recommande un &nbsp;dosage des IgE Totales et des RAST aux pneumallerg&egrave;nes et aux trophallergenes.</p>\r\n<p>Je le reverai pour une EFR le 11 Septembre &agrave; 15h.&nbsp;</p>\r\n<p>La NFS ne montre pas d\'hypereosinophilie.</p>\r\n<p>Pour l\'instant je recommenderai de reprendre un traitement de fond par SERETIDE 500 1BX2 /jour avec rincage de la bouche par la suite.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(93,406,'2013-09-05','Dr FOURNIER','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. AUGUSTIN Jean Michel n&eacute; le 07/05/1936.</p>\r\n<p>Ce monsieur est un ancien fumeur 1/2 paquet / jour sevr&eacute; depuis 7/8ans.</p>\r\n<p>Il est mari&eacute; 3 enfants et &eacute;tait employ&eacute; communal &agrave; la retraite.</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une tumeur b&eacute;nigne de la colonne vert&eacute;brale. En 2011 M.Augustin a eu une resection endoscopique de la prostate.</p>\r\n<p>Il est trait&eacute; pour DID,HTA,glaucome.</p>\r\n<p>histoire de la maladie:il pr&eacute;sente une dyspn&eacute;e depuis 2 &agrave; 3 ans et qui s\'est aggrav&eacute;;</p>\r\n<p>Actuellement iIl pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Sa sao2 &agrave; AA est &agrave; 95%.on note un freinage expiratoire avec quelques sibilances et un discret oed&egrave;me des membres inf&eacute;rieurs.</p>\r\n<p>M.Augustin pr&eacute;sente un ronflement sonore avec des difficult&eacute;s respiratoires en d&eacute;cubitus.</p>\r\n<p>M.Augustin pr&eacute;sente une hypersomnolence diurne avec un Score d\'EPWORTH &agrave; 12/15.</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>Le diametre cervical est &agrave; 41cm et un diametre abdominal de 102cm.</p>\r\n<p>M. Augustin aura une EFR le 10/10/2013.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire et un dosage de proBNP,nFS-Plqt,GDS &agrave; AA.</p>\r\n<p>sur le plan th&eacute;rapeutique on poursuivra:Onbrez 300 1B/j;spiriva Respimat 2B/j Kin&eacute;sieth&eacute;rapie respiratoire 3 s&eacute;ances / semaine pendant 2 mois.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(94,196,'2013-10-08','Dr Bruno CADET','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme GISQUET Marie Georgette n&eacute;e le 30/08/1948.</p>\r\n<p>Cette dame n\'a jamais fum&eacute;. Mme Gisquet &eacute;tait employ&eacute; communal.Elle est veuve et a 6 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DNID,HTA,une surdit&eacute; op&eacute;r&eacute;e.Elle a eu une angioplastie coronaire avec pose d\'un stent coronarien.</p>\r\n<p>Histoire de la Maladie: elle a &eacute;t&eacute; hospitalis&eacute; &agrave; 3 reprises me dit elle &nbsp;en reanimation pour d&eacute;tresse respiratoire probablement pour BPCO du au feu de bois.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified medical &nbsp;Research Council.</p>\r\n<p>L\'ausculation pulmonaire retrouve des sibilances dans les 2 champs pulmonaires.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire mixte &agrave; pr&eacute;dominance obstructive Gold II avec VEMS &agrave; 64%.Le tiffeneau est &agrave; 60% de la norme.Il existe des signes de distension pulmonaire avec VGT &agrave; 136%. La CPT est &agrave; 89% et le VR &agrave; 79%.Les resistances des vouies a&eacute;riennes sont augment&eacute;es &agrave; 0.69.il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Sa radiographie thoracique montre une coiffe pleurale mod&eacute;r&eacute;e bi-apicale avec syndrome bronchique des deux pyramides basales.L\'aspect est strictement superposable aux radiographies ant&eacute;rieures;</p>\r\n<p>Le bilan biologique montre un proBNP &agrave; 13ng/l avec des IgE totales &agrave; 64UI/ml Le Phadiatop(m&eacute;lange de pneumallerg&egrave;nes) est n&eacute;gatif ainsi que le Trophatop(m&eacute;lange de Trophallerg&egrave;nes).il n\'existe pas d\'hyper&eacute;osinophilie.</p>\r\n<p>Son ECG est normal(Dr SIBRA).Sa GDS a malheureusement &eacute;t&eacute; faite en IV au lieu d\'etre en intra arterielle.</p>\r\n<p>&nbsp;Pour l\'instant nous poursuivons le meme traitement avec la VNI,kin&eacute;sieth&eacute;rapie respiratoire,Onbrez 300 1B/j Spiriva Respimat 2B/j et pulmicort 400 1B m ets avec rincage de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(95,113,'2013-09-05','Dr I .Patel','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme REMILIE Marie C&eacute;line n&eacute;e le 05/08/1940.</p>\r\n<p>Cette dame fumait de mani&egrave;re intermittente et ne fume plus depuis plusieurs ann&eacute;es.</p>\r\n<p>Elle est s&eacute;par&eacute;e et a 3 enfants. Mme remilie est une ancienne blanchisseuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA.</p>\r\n<p>Elle me dit avoir &eacute;t&eacute; hospitalis&eacute;e en mai 2013 pour dyspn&eacute;e aigue. Pendant son hospitalisation elle aurait fait une chute et depuis elle conserve des douleurs thoraciques latero-post&eacute;rieur droites qui l\'obligent de porter une bande de contention.</p>\r\n<p>Ce jour elle pr&eacute;sente une toux grasse.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les 2 champs pulmonaires.</p>\r\n<p>Le scanner thoracique retrouve plusieurs images nodulaires parenchymateuses;</p>\r\n<p>je demande un PET Scan pour elle et je lui prescrit une bande de contention elastique pour ses douleurs thoraciques.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold II/III avec s.de distension pulmonaire : VGT &agrave; 169% CPT &agrave; &nbsp;104% VR &agrave; 169% de la norme;</p>\r\n<p>Il convient de poursuivre chez elle a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent) X 2 associ&eacute; &agrave; Spiriva Respimat 2B/jour.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(96,167,'2013-09-05','Dr RIDA\r\nDr PAOLI','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme FOREAU Marie Edith n&eacute;e le 25/03/1942.</p>\r\n<p>Cette dame non fumeuse a 2 enfants.elle travaillait comme femme de m&eacute;nage.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e d\'un cancer du sein gauche en 2007(?);</p>\r\n<p>Elle est trait&eacute; pour un DID, arthrose diffuse;</p>\r\n<p>Je la suit pour un asthme probablement associ&eacute; &agrave; une BPCO post cuisson au feu de bois.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Research Council.mme foreau est sous OLD 24/24 avec O2 de d&eacute;ambulation.</p>\r\n<p>Ses EFR font &eacute;tat d\'un trouble ventilatoire obstructif GOLD IV tr&egrave;s s&eacute;v&egrave;re avec VEMS a 0,4L et Tiffenau &agrave; 0,4%. Par ailleurs, il existe une augmentation de la resistance des voies a&eacute;riennes a &nbsp;2,10%. Nous n\'avons pu r&eacute;aliser de ph&eacute;tismographie.</p>\r\n<p>Je demande pour elle&nbsp;une radiographie pulmonaire, associ&eacute;e &agrave; une num&eacute;ration formule sanguine-plaquettes, et une gazom&eacute;trie &agrave; air ambiant.</p>\r\n<p>Elle poursuis entre temps son traitement, et je la reverrai au mois d\'octobre.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(97,414,'2013-09-05','Dr RAY','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour M. LEVENEUR Jean Baptiste n&eacute; le 22/06/1931.</p>\r\n<p>Ce patient, ancien fumeur 2 paquets/j, sevr&eacute; depuis environs 2 ans, dit avoir &eacute;t&eacute; op&eacute;r&eacute; du foie (?) et de la hanche gauche.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; pour UGD et est trait&eacute; pour hypertension art&eacute;rielle et goutte. Par ailleurs, il pr&eacute;sente une cardiopathie hypertensive et une BPCO.&nbsp;</p>\r\n<p>Sur le plan clinique: il pr&eacute;sente une dyspn&eacute;e grade III/IV de l\'&eacute;chelle du Modified Research Council. L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires t&eacute;tacoustiques, avec quelques sous cr&eacute;pitants aux bases.</p>\r\n<p>Son scanner thoracique du mois de mars 2012 montrait un emphys&egrave;me centrolobulaire avec des micronudules sous pleuraux.Le scanner thoracique en date du 26/09/2013 montre un &eacute;paississement&nbsp;</p>\r\n<p>Je demande ce sous un TDM thoracique et surr&eacute;nalien, sans injection, qu\'il aura le jeudi 26 septembre &agrave; 8h &agrave; la clinique Saint-Vincent, avec le Dr. Mascarel. Je demande par ailleurs une gazom&eacute;trie air ambiant, associ&eacute;e &agrave; une NFS plaquettes, ainsi qu\'une proBNP.</p>\r\n<p>Je lui pratiquerai une EFR le 11 octobre 2013, &agrave; 9h.</p>\r\n<p>Sur le plan respiratoire, je recommande le traitement suivant, qui sera a r&eacute;adapter au vu des &eacute;preuves fonctionnelles respiratoires: onbrez 150&micro;g 1b/j; spiriva respimat 2b/j, pulmicort 400 1x2, avec rin&ccedil;age, associ&eacute; &agrave; kin&eacute; respi, techniques ventilations dirig&eacute;es 3 s&eacute;ances/semaine.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(98,413,'2013-09-05','Dr Omarjee','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SANS Julien n&eacute; le 24/07/1949.</p>\r\n<p>Ce monsieur ancien fumeur2pqts/ jour est sevr&eacute; 37 ans.</p>\r\n<p>Il exercait la profession de macon.Il est mari&eacute; et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fils asthmatique;A signaler une allergie au ciment chez M.Sans.</p>\r\n<p>Tu a &eacute;t&eacute; op&eacute;r&eacute; en 1983 de la colonne vert&egrave;brale ;3 &eacute;ventrations;menisque interne bilat&eacute;rale ;&eacute;paule droite;</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; d\'un UGD suite aux antiinflammatoires.</p>\r\n<p>Depuis 1975 il a pr&eacute;sent&eacute; des bronchites &agrave; repetition et depuis 10 ans une symptomatologie de BPCO avec hospitalisation au CH de St Pierre il y a 10ans.</p>\r\n<p>Sous traitement son &eacute;tat s\'&eacute;tait amelior&eacute; mais lors d\'un s&eacute;jour &agrave; l\'Ile Maurice au mois de mai il a pr&eacute;sent&eacute; une probable surinfection bronchique avec crachats sales ila &eacute;t&eacute; trait&eacute; par corticoth&eacute;rapie &agrave; son retour &agrave; la R&eacute;union.</p>\r\n<p>M.Sans est un sportif qui n\'a pas de g&egrave;ne respiratoire particulier.</p>\r\n<p>Je demande une radiographie pulmonaire avec un dosage d\'IgE Totales;RAST aux peumallerg&egrave;nes et aux trophallerg&egrave;nes,NFS plqt,GDS &agrave; AA.</p>\r\n<p>Poursuivre sur le plan th&eacute;rapeutique les vaccinations antigrippale annuel et pneumo 23 tous les 5 ans;Foradil et Miflonil et kin&eacute;sie respiratoire.Le traitement sera readapt&eacute; au vu des r&eacute;sultats des EFR.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(99,415,'2013-09-05','Mme le Dr Bocquel\r\nRespidom','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. MICHAUD Christophe n&eacute; le 09/06/1944.</p>\r\n<p>Ce patient ancien fumeur:3pqt/j est sevr&eacute; depuis 2010.Il exercait la profession de macon.Il est mari&eacute; et a 2 enfants.</p>\r\n<p>Il a&eacute;t&eacute; renvers&eacute; par un camion en 1973 avec une par&eacute;sie droite s&eacute;quellaire.</p>\r\n<p>Il pr&eacute;sente par ailleurs un DID,une HTA.</p>\r\n<p>Il a pr&eacute;sent&eacute; un AVC en 2002.Par ailleurs M.Michaud est trait&eacute; pour un SAS .sa femme se plaint que l\'appareil est trop bruyant.M.Michaud se d&eacute;place &agrave; l\'aide d\'un d&eacute;ambulateur.</p>\r\n<p>Ce jour auscultation pulmonaire normale</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec NFS plqt ,GDS &agrave; AA ,proBNP.</p>\r\n<p>je le reverrai le 18/10/2013 pour readapter son traitement;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(100,412,'2013-09-05','',''),(101,184,'2013-09-05','Dr Calichiama','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. THIONVILLE Mathieu Yannis n&eacute; le 01/01/1983.</p>\r\n<p>Ce jeune homme non fumeur sans profession .</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une sinusite.</p>\r\n<p>Il n\'a pas d\'ant&eacute;c&egrave;dents familiaux d\'asthme.</p>\r\n<p>Son allergologue lui a trouv&eacute; une allergie aux acariens;</p>\r\n<p>l\'auscultation pulmonaire est ce jour normal.Il va mieux depuis ses s&eacute;ances de d&eacute;sensibilisation;</p>\r\n<p>La radio pulmonaire est normale.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire restrictif avec CPT &agrave; 66% de la norme Tiffeneau &agrave; 82%.Lze VR est &agrave; 72%.il existe une augmentation des resistances des voies a&eacute;riennes.</p>\r\n<p>Je pr&eacute;f&egrave;re revoir le patient avec un scanner thoracique sans injection et un dosage des IgE totales,RAST aux pneumallerg&egrave;nes etaux trophallerg&egrave;nes;</p>\r\n<p>Je lui prescrit de la kin&eacute;sieth&eacute;rapie respiratoire et le reverrai en novembre.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(102,411,'2013-09-05','Dr Taochy','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MAILLOT S&eacute;bastien n&eacute; le 31/05/1979.</p>\r\n<p>Ce monsieur fumeur 15 cigarettes/jour continue de fumer 5 cigarettes/jour;</p>\r\n<p>Il travaille &agrave; la banque et est c&eacute;libataire;</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; des v&eacute;g&eacute;tations;</p>\r\n<p>Il ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>M. Maillot a eu un asthme dans l\'enfance qui a regress&eacute; &agrave; l\'age de 15/16 ans.</p>\r\n<p>Depuis hier, il a des c&eacute;phal&eacute;es avec fi&egrave;vre, rhinite eau de roche et opression thoracique, surtout une toux productive incoercible qui le fatigue.</p>\r\n<p>Je conseille le traitement suivant:</p>\r\n<p>- Singulair 10mg 1cp le soir</p>\r\n<p>- Eludril gargarisme m et s</p>\r\n<p>- a&eacute;rosolth&eacute;rapie (Bricanylm-Atrovent)x2+PulmicortX2 avec rincage; Symbicort 400mgX2 avec rincage .</p>\r\n<p>Je le reverrai le 07/10/2013 pour des EFR.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(103,223,'2013-09-05','Dr Andriatavy','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SAUTRON Berthe n&eacute;e le 05/10/1935.</p>\r\n<p>Elle a pr&eacute;sent&eacute; un asthme dans l\'enfance avec urticaire et rhinite allergique.</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 80% de la norme, sans trouble du transfert. Le VEMS est &agrave; 1.41 soit 71% de la norme. Le tiffeneau est &agrave; 89 % de la norme.</p>\r\n<p>Il faut poursuivre la kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(104,224,'2013-09-05','Dr andriatavy','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SAUTRON Jules n&eacute; le 09/02/1926.</p>\r\n<p>Ce monsieur ancien fumeur 2 paquets/jour est sevr&eacute; depuis 35 ans.</p>\r\n<p>M.Sautron a &eacute;t&eacute; op&eacute;r&eacute; de l\'appendicite et des hemorroides.</p>\r\n<p>il &eacute;tait trait&eacute; pour HTA.il apr&eacute;sent&eacute; un AVC le 18/12/2002.</p>\r\n<p>il conserve une par&eacute;sie droite.</p>\r\n<p>ses EFR retrouvent un trouble ventilatoire restrictif marqu&eacute; avec CPT &agrave; 54% de la norme,VGT &agrave; 71% de la norme,VR &agrave; 70% de la norme.le VEMS est &agrave; 1.15soit 45&ugrave; de la norme avec ub Tiffeneau &agrave; 83% de la norme.La TLCO est &agrave; 59% de la norme;</p>\r\n<p>Ce patient est trait&eacute; par ONBREZ 3000 1b le m /</p>\r\n<p>.Il convient d\'y ajouter de la kin&eacute;sieth&eacute;rapie respiratoire TVD .</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(106,115,'2013-09-06','Dr Marc AZZOLIN\r\n\r\nDr Ramiaramanana\r\nIntermétra','<p>Cher ami,</p>\r\n<p>&nbsp;</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour<strong> polysomnographie</strong> M. GASNIER Yannis JOEL, n&eacute; le 01/05/1977.</p>\r\n<p>Ce patient n\'a jamais fum&eacute; et pr&eacute;sente un poids de 115 kilos pour une taille de 1m76, soit un IMC de 37.1 ce qui repr&eacute;sente une obesit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>Monsieur Gasnier est conseiller &agrave; l\'insertion et &agrave; l\'emploi. Il est c&eacute;libataire sans enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une HTA,une varicoc&egrave;le,une bronchite asthmatiforme dans l\'enfance et une prethalass&eacute;mie.</p>\r\n<p>M. Gasnier a pris 30 kilos en metropole.</p>\r\n<p>Son <strong>Score d\'Epworth</strong> est &agrave; 9/24.</p>\r\n<p>Son <strong>Score de Berlin</strong> retrouve un ronflement fort, genant autrui avec une HTA.</p>\r\n<p>Son <strong>Score de Mallampati</strong> est de 2/3.</p>\r\n<p>Son perimetre cervical est &agrave; 40 cm et son perimetre abdominal &agrave; 131 cm.</p>\r\n<p>Son <strong>agenda de sommeil</strong> montre qu\'il se couche entre 21 et 23 heures avec endormissent 2 heures apr&egrave;s en g&eacute;n&eacute;ral. Le patient s\'endort en regardant la t&eacute;l&eacute;vision dans sa chambre &agrave; coucher. Lorsqu\'il travaille, il se leve g&eacute;n&eacute;ralement &agrave; 5H30. Le lev&eacute; est souvent pr&eacute;c&egrave;d&eacute; d\'une phase de demi sommeil. La dur&eacute;e du sommeil est en moyenne de 6 heures.</p>\r\n<p>L<strong>\'EFR</strong> montre un trouble ventilatoire restrictif tr&egrave;s mod&eacute;r&eacute; avec VGT &agrave; 64% de la norme, CPT &agrave; 80% de la norme, VR &agrave; 71% de la norme, du vraisemblablement &agrave; l\'ob&eacute;sit&eacute;.</p>\r\n<p>L<strong>\'Examen polysomnographique</strong> montre:</p>\r\n<p>L\'<strong>Analyse du sommeil</strong> a &eacute;t&eacute; effectu&eacute;e sur une p&eacute;riode enregistr&eacute;e &nbsp;de sommeil de 5H50.</p>\r\n<p>97 micro&eacute;veils ont &eacute;t&eacute; enregistr&eacute;s soit 18/ heure.</p>\r\n<p>Evenements respiratoires: 79 apn&eacute;es obstructives ont &eacute;t&eacute; enregistr&eacute;es soit 15/H.</p>\r\n<p>310 hypopn&eacute;es ont &eacute;t&eacute; valid&eacute;es soit 59/h.</p>\r\n<p>255 hypopn&eacute;es entrainaient une d&eacute;saturation ;</p>\r\n<p>392 d&eacute;saturations ont &eacute;t&eacute; not&eacute;s soit 74/H avec des minimales de 71% atteint en REM+(sommeil paradoxal).</p>\r\n<p><strong>Mouvement periodiques des jambes:</strong></p>\r\n<p>31 MPJ ont &eacute;t&eacute; enregistr&eacute;s, soit 6 par heure.</p>\r\n<p>En ce qui concerne les <strong>Ronflements:&nbsp;</strong>nous avons not&eacute;s un total de 4128 ronflements &nbsp;soit 785/heure avec une dur&eacute;e cumul&eacute;e de 250minutes soit 79%du TST. L\'energie moyenne est de 92 dB.</p>\r\n<p>Au total: l<strong>\'Index d\'Apn&eacute;es hypopn&eacute;es</strong> est de 74/heure ce qui justifie l\'appareillage du patient en mode autopilot&eacute;e de 4 &agrave; 14 cm d\'h2O par la Soci&eacute;t&eacute; SOS-Oxyg&egrave;ne.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(107,417,'2013-09-06','Dr P.MAS','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme CRESENCE Marie Risla n&eacute;e le 14/01/1957.</p>\r\n<p>Cette dame est non fumeuse, ex-femme de menage, 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une soeur, un enfant et des cousines asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un goitre avec hyperthyroidie d&eacute;courte depuis un an et demi.</p>\r\n<p>Son asthme a d&eacute;marr&eacute; &agrave; l\'age de 40 ans, deux consultations aux Urgences hospitali&egrave;res pour asthme.</p>\r\n<p>Patiente suivie par moi depuis environ 3 ans. A b&eacute;n&eacute;fici&eacute; d\'une &eacute;ducation th&eacute;rapeutique dans le cadre de l\'Ecole de l\'asthme. Actuellement sous XOLAIR.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale. Elle n\'est pas tr&egrave;s dyspn&eacute;ique dans sa vie de tous les jours mais doit recourir &agrave; la Ventoline 2 fois par jour.</p>\r\n<p>Je lui prescrit une radiographie pulmonaire ainsi qu\'une NFS-Plqt, IgE totales, RAST aux pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.</p>\r\n<p>Mme Cresence aura le 15/10 une EfR et nous maintenons chez elle:&nbsp;XOLAIR 375 mgX2/mois, Singulair 10mg 1cp le soir et Ventoline 2X2</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(108,3,'2013-09-06','Dr Etienne SERY','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme AGENOR Monique Jacquel n&eacute;e le 28/07/1956.</p>\r\n<p>Cette dame non fumeuse, mari&eacute;e 2 enfants est aidesoignante au CHU de BellePierre.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note 2 c&eacute;sariennes,une hypothroidie trait&eacute; par LEVOTHYROX.</p>\r\n<p>A partir de 1984 infection pulmonaire s&eacute;v&egrave;re avec &eacute;panchement pleural bilat&eacute;ral &nbsp;en metropole.Depuis infection bronchique &agrave; repetition.DDB bilat&eacute;rale d&eacute;couverte il y a une dizaine d\'ann&eacute;es.</p>\r\n<p>Sous traitement stabilisation des DDB.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 2 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques sibilances &nbsp;thoracique ant&eacute;rieur droit.</p>\r\n<p>SaO2 &agrave; 98% &agrave; AA.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire mixte mod&eacute;r&eacute; avec VEMS &agrave; 1.42l/mn soit 68% de la norme avec Tiffeneau &agrave; 77% &nbsp;et CPT &agrave; 89% de la norme.</p>\r\n<p>Patiente sous Zithromax 250 mgX3/semaine. Je lui conseille une kin&eacute;sieth&eacute;rapie respiratoire;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(109,242,'2013-10-08','Dr Guilbaud','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme ASENSIO Jacqueline n&eacute;e le 09/03/1942.</p>\r\n<p>Cette dame est non fumeuse. Elle est mari&eacute;e et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie, une bartholinite.</p>\r\n<p>En mars 2011 il lui a &eacute;t&eacute; diagnostiqu&eacute; un adenocarcinome pulmonaire d\'embl&eacute;e metastatique Std IV; Un traitement par Chimioth&eacute;rapie&nbsp;Carbo-Alimta avait &eacute;t&eacute; demarr&eacute; suivie d\'une th&eacute;rapie cibl&eacute;e. L\'adenocarcinome de Mme Asensio &eacute;tant sensible aux inhibiteurs de l\'EGFR.</p>\r\n<p>Sous TARCEVA 150 mg des l&eacute;sions dermatologiques de plus en plus rebelles sont apparues. La pommade au LIPIKAR a meme eu un effet aggravateur.</p>\r\n<p>Il a donc &eacute;t&eacute; d&eacute;cid&eacute; de passer &agrave; TARCEVA 100mg/Jour. Une am&eacute;lioration a &eacute;t&eacute; not&eacute;.</p>\r\n<p>Le RCP d\'Oncologie thoracique avait pr&eacute;conis&eacute; un TDM de controle tous les 4 mois.</p>\r\n<p>Un scanner thoracique sera pratiqu&eacute; le10 Octobre ainsi q\'une EFR.Le dossier sera repr&eacute;sent&eacute; en RCP fin Octobre 2013.</p>\r\n<p>ce jour l\'EFR a montr&eacute; un trouble ventilatoire mixte mod&eacute;r&eacute; ,Gold II mod&eacute;r&eacute; dans sa composante obstructive avec un VEMS &agrave; 1.27 soit 65% de la norme.La CPT est &agrave; 83% et le Tiffeneau &agrave; 100% de la norme.Il existe une distension pulmonaire avec VGT &agrave; 135%,VR &agrave; 132% de la norme.</p>\r\n<p>Je lui renouvelle ce jour :Tarceva 100mg/j et TETRALYSAL 300mg/Jour.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(110,416,'2013-10-01','Docteur I.PATEL','<p>Cher Ibrahim</p>\r\n<p>Je te &nbsp;remercie de m\'avoir adress&eacute; pour avis M. LARTIN Urbain, n&eacute; le 07/11/1026</p>\r\n<p>Ce monsieur ancien fumeur un demi paquet/j sevr&eacute; depuis 40 ans.Il exercait la profession d\'archiviste.Il est mari&eacute; et a 6 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note des interventions pour hernie inguinale bilat&eacute;rale .</p>\r\n<p>Il a eu une angioplastie coronarienne en 1993 par les Drs Chuong et Moshinaly.Il est trait&eacute; pour HTA,DID et a pr&eacute;sent&eacute; une embolie pulmonaire en 2012.</p>\r\n<p>Sa femme dit que M.LARTIN ronfle et ce patient a 2 nyctiuries par nuit.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade1/2 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Son score d\'Epworth est &agrave; 14/18.</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>nous allons apprendre &agrave; M.Latrin &agrave; remplir un agenda de sommeil.</p>\r\n<p>l\'auscultation pulmonaire est ce jour sans particularit&eacute;.</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour montre un trouble ventilatoire mixte Gold II mod&eacute;r&eacute; avec un VEMS &agrave; 1.51 soit 67% de la norme;le Tiffeneau est &agrave; 78% de la norme avec CPT &agrave; 63% VR &agrave; 58% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.53 et la TLCO &agrave; 72% de la norme traduisant des troubles mod&eacute;r&eacute;es de la Diffusion.</p>\r\n<p>Il serait bon de pratiquer une radiographie pulmonaire et je place M.LARTIN sous Foradil 1 gel inhal&eacute; m et s et kin&eacute;siettt respiratoire 3 s&eacute;ances /semaine pendant 2 mois.</p>\r\n<p>Avec mes remerciements, veilles agr&eacute;er, cher Ibrahim , l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(111,185,'2013-09-06','Dr Welmant\r\nSeprodom','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme HOAREAU Ines Marie n&eacute;e le 11/12/1931.</p>\r\n<p>Cette dame est non fumeuse. Elle est mari&eacute; et a 3 enfants.</p>\r\n<p>Elle est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une c&eacute;sarienne et une fracture de la jambe gauche en 2004.</p>\r\n<p>Elle pr&eacute;sente un asthme depuis la naissance;son grand p&egrave;re &eacute;tait asthmatique;</p>\r\n<p>En 2010 elle a &eacute;t&eacute; hospitalis&eacute; pour crise d\'asthme.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3/4 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires sthetacoustiques.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique avec dilatation de l\'arc inf&eacute;rieur droit.</p>\r\n<p>Je pense qu\'une echocardiographie est n&eacute;cessaire ainsi qu\'un dosage des IgE Totales,des RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes,&nbsp;associ&eacute; &agrave; une NFS.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte Gold II dans sa composante obstructive avec distension pulmonaire et augmentation de la resistance des voies a&eacute;riennes sans tr du transfert.</p>\r\n<p>Il convient de poursuivre le meme traitement et je la reverrai en Novembre.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(112,423,'2013-09-06','Dr Chopra-Cardiologue\r\nDr Roselyne PAYET\r\nSOS Oxygène','<p>Cher Coll&egrave;gue,</p>\r\n<p>M. ABDALLAH Ahmed, n&eacute; le 11/10/1959 a b&eacute;n&eacute;fici&eacute; dans la nuit du 25 au 26/10/2013 d\'une Polysomnographie.</p>\r\n<p>Cet examen a port&eacute; sur un temps de sommeil total de 6H39 minutes.Il existe une efficacit&eacute; temps de sommeil total/p&eacute;riode totale du sommeil de 86%.</p>\r\n<p>17 micro-&eacute;veils ont &eacute;t&eacute; d&eacute;tect&eacute;s soit 3/heure .10 micro-&eacute;veils ont present&eacute; &nbsp;une dur&eacute;e de plus de 30 secondes.</p>\r\n<p>L\'Index d\'Apn&eacute;s-hypopn&eacute;es(IAH) est de 44/heure avec un IAH avec diminutions de 59/Heure.</p>\r\n<p>300 d&eacute;saturations ont &eacute;t&eacute; not&eacute;s soit 45/heure avec une d&eacute;saturation minimale de 78%.</p>\r\n<p>le malade passe 43 minutes de sommeil avec une d&eacute;saturation endessous de 90%.</p>\r\n<p>Il pr&eacute;sente 10 mouvements p&eacute;riodiques des jambes par heure de sommeil.</p>\r\n<p>304 ronflements sont not&eacute;s par heure de sommeil avec une energie moyenne de 90db.</p>\r\n<p>M.ABDALLAH sera appareill&eacute; par la soci&eacute;t&eacute; SOS Oxyg&egrave;ne en mode autopilot&eacute; en pression positive continue avec une pression entre 5 et 15 cm d\'eau.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Coll&egrave;gue, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(113,357,'2013-09-09','Dr Vally\r\nDr Degasne','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. PAPAYA NARASSOUMOULOUNAID Germain n&eacute; le 26/06/1945. Ce patient non fumeur est un coiffeur &agrave; la retraite. Il est mari&eacute; et a 5 enfants. Dans ses ant&eacute;c&egrave;dents on note une intervention au niveau des hanches et intervention des tendons de la main gauche en 1977.</p>\r\n<p>En 1977 il a &eacute;t&eacute; diagnostiqu&eacute; une spondylarthrite ankylosante &nbsp;avec HLA B27 positive suivie &agrave; l\'&eacute;poque par le Dr Le Goc. Il a &eacute;t&eacute; trait&eacute; par REMICADE pendant 4 ans au CHU de Bellepierre.</p>\r\n<p>Actuellement il ressent des brulures au niveau des &eacute;paules, de la colonne vert&eacute;brale, de la plante des pieds, dans les bras et les jambes. Cela l\'emp&egrave;che de dormir le soir.</p>\r\n<p>Il est parfois g&eacute;n&eacute; sur le plan respiratoire.Il pr&eacute;sente une dyspn&eacute;e grade 1 de l\'&eacute;chelle du Modified Research Council &agrave; savoir que pour un effort intense.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale mais le patient est bloqu&eacute; au niveau de sa colonne vert&eacute;brale.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire restrictif minime ave CPT &agrave; 77% de la norme, VR &agrave; 74% de la norme;le Tiffeneau est &agrave; 87% avec un VEMS &agrave; 2.28 soit 85% de la norme. La TLCO est &agrave; 72%de la norme. Le patient a rendez vous en decembre avec le Dr Degasne. Je lui conseille de poursuivre la kin&eacute;sieth&eacute;rapie d\'assouplissement .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(114,60,'2013-09-09','Dr Laurent Grandpré Jean Pierre\r\n\r\nDr Legros Laurence\r\n\r\nSOS Oxygene','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour une<strong> polysomnographie</strong>&nbsp;M. SERGE Jean Marcellin, n&eacute; le 30/05/1959.</p>\r\n<p>Ce patient pr&eacute;sente un poids de 70 kilos pour une taille de 1m57 soit une BMI de 28,4 ce qui correspond &agrave; un surpoids.</p>\r\n<p>M.SERGE exerce la profession d\'&eacute;lectricien. Il est non fumeur.</p>\r\n<p>Ses EFR sont dans les limites de la normale.</p>\r\n<p>Son Score d\'Epworth est de 18/24.</p>\r\n<p>Son Score de Mallampati est &agrave; 3.</p>\r\n<p>Il pr&eacute;sente un ronflement intense.</p>\r\n<p>L\'analyse de son&nbsp;<strong>agenda de sommeil&nbsp;</strong>retrouve une bonne efficacit&eacute; de sommeil (a savoir le temps pass&eacute; au lit par rapport &nbsp;au temps dormi). On note en moyenne 7 heures de sommeil avec absence de difficult&eacute; d\'endormissement. Il y a peu de reveil nocturne, sauf perturbation par les enfants.</p>\r\n<p><strong><em>Analyse de&nbsp;</em>la&nbsp;polysomnographie :</strong></p>\r\n<p><strong>&nbsp; Analyse du ronflement</strong>: On note 1397 ronflements, soit 193 par heure avec une energie de 91dB.</p>\r\n<p>&nbsp;&nbsp;<strong>Analyse du sommeil</strong>: est comparable &agrave; celle de l\'agenda de sommeil mais retrouve de nombreux micro-&eacute;veils: 82 soit 12/heure. 46 de ces micro&eacute;veils durent plus de 30 secondes et on note une dur&eacute;e totale de 86 minutes de micro-&eacute;veils.</p>\r\n<p><strong>&nbsp; Analyse des mouvements periodiques de jambes</strong></p>\r\n<p>On note 5 MPJ, soit 1 par heure.</p>\r\n<p>&nbsp; <strong>Analyse des &eacute;venements respiratoires :</strong></p>\r\n<p>Ils totalisent 59 Apn&eacute;es &nbsp;soit 9/heure. On note 55 &eacute;venements obstructives, une centrale et 0 Mixtes.</p>\r\n<p>S\'y associent: 160 hypopn&eacute;es,soit 24/heure. 120 hypopn&eacute;es s\'accompagnent de d&eacute;saturation et 2 de micro&eacute;veils. Le patient passe 32% de son sommeil en d&eacute;saturation.</p>\r\n<p>Au total<strong> l\'Index d\'apn&eacute;es-hypopn&eacute;es est de 32/heure</strong> ce qui justifie l\'appareillage du patient en auto-pilot&eacute;e de 4 &agrave; 14 cm d\'H2O par la Soci&eacute;t&eacute; SOS-Oxyg&egrave;ne.</p>\r\n<p>Revu le 16/09/2013: Patient moins somnolent ce jour depuis qu\'il a &eacute;t&eacute; appareill&eacute; il y a 2 semaines.Nous sommes en attente du dossier d\'observance de SOS Oxyg&egrave;ne.</p>\r\n<p>Nez toujours bouch&eacute;.Patient pr&eacute;sentant une classe 3 vis &agrave; vis des acariens et insectes.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, chers Confr&egrave;res, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(115,36,'2013-09-09','',''),(116,199,'2013-11-08','Dr Axel KICHENIN\r\nDr Caboche\r\nUrologue','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. GOVINDIN Augustin n&eacute; le 29/03/1942.</p>\r\n<p>Ce patient ancien fumeur : 1 paquet/jour totalisant 42 PA est sevr&eacute; depuis 2002. Il est ancien cultivateur, mari&eacute; 6 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une cholecystectomie, un psoriasis, un DID.Depuis sa cholecystectomie en 2009 il pr&eacute;sente une toux avec secretions bronchiques visqueux et blanchatres.Il a par ailleurs &eacute;t&eacute; op&eacute;r&eacute; le 24/10/2013 pour un calcul du rein gauche.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'ascultation pulmonaire retrouve une diminution des bruits pulmonaires sthetacoustiques.La SaO2 est &agrave; 98%.</p>\r\n<p>La radiographie thoracique montre un degr&eacute; de distension thoracique avec aplatissement des coupoles diaphragmatiques. L\'echographie abdominale semble montrer un degr&eacute; de st&eacute;atose.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire mixte avec CPT &agrave; 74% de la norme. Le VEMS est &agrave; 1.71 soit 65%,le Tiffeneau &agrave; 90%. Il existe une distension pulmonaire avec VGT &agrave; 124%,Vr &agrave; 109%. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.46. La tLCO n\'a pu etre mesur&eacute;e car le malade n\'a pu tenir l\'apn&eacute;e.</p>\r\n<p>Son traitement actuel consiste Onbrez 300, Spiriva Respimat 2B /j, Miflonil400 1BX2 avec rin&ccedil;age de&nbsp;</p>\r\n<p>&nbsp;la bouche &agrave; l\'eauauquel et &nbsp;kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(117,178,'2013-09-09','Dr Anna Tcheremkhovitch','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme SADON Marie Roseline n&eacute;e le 28/04/1956.</p>\r\n<p>Cette dame non fumeuse est ancienne femme de m&eacute;nage. Elle est divorc&eacute;e et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un p&egrave;re et 3 fr&egrave;res asthmatiques. Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie, une hysterectomie en 1985 pour cancer du col de l\'uterus. Elle a aussi eu une op&eacute;ration pour kyste de l\'ovaire gauche en 1998 et a &eacute;t&eacute; op&eacute;r&eacute;e du ligament crois&eacute; droit en 1998.</p>\r\n<p>Mme sadon est ancienne migraineuse, a &eacute;t&eacute; soign&eacute; pour UGD. Elle est porteuse d\'une hernie hiatale &nbsp;et est suivie pour sciatalgie et HTA.</p>\r\n<p>Son asthme a d&eacute;but&eacute; depuis l\'age de &nbsp;33 ans. Sa derni&egrave;re crise d\'asthme date du mois d\'aout 2013.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour un freinage expiratoire.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec VEMS &agrave; 0.79 soit 41% de la norme,passant &agrave; 0.85 sous b2 mimetiques. Il existe une distension pulmonaire avec VR &agrave; 129% de la norme. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.5 &nbsp;sans anomalie notable de la diffusion: TLCO &agrave; 77% de la norme.</p>\r\n<p>Il convient de poursuivre le XOLAIR &agrave; 375 mg X 2 /mois. Seretide 250 bX2; Aerosoltherapie (Bricanyl-Atrovent)X2 avec pulmicortX2/j et Singulair 10 mg 1 cp le soir. Elle prend de mani&egrave;re intermittente de la Ventoline .Elle est en outre trait&eacute;e pour HTA. Je la reverrai le 28/10/0213. Elle m\'apportera une radiographie pulmonaire avec dosage des IgE Totales.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(118,429,'2013-09-09','Dr Jean Jacques BRUNET\r\nSt André','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme SAGOUBY Guylene n&eacute;e le 15/02/1963.</p>\r\n<p>Cette dame mari&eacute;, 4 enfants est sans profession. Elle est non fumeuse;</p>\r\n<p>Elle pr&eacute;sente un poids de 137 kilos pour une taille de 1m61.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DID, une HTA.</p>\r\n<p>Son p&eacute;rimetre cervical est de 48cm et son perim&egrave;tre abdominal est de 154cm.</p>\r\n<p>Son Score d\'Epworth est de 5/21. Son score de Mallampati est 3/4.</p>\r\n<p>Actuellement cette dame est appareill&eacute; par VNIet OLD par ISIS R&eacute;union pour syndrome d\'ob&eacute;sit&eacute; hypoventilation depuis le mois de mars 2012.</p>\r\n<p>Son &eacute;tat s\'est amelior&eacute; depuis son appareillage et elle est plus &eacute;veill&eacute;. Elle pr&eacute;sente n&eacute;anmoins 2 nyctiuries.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve quelques ronchi aux bases avec discrets oed&egrave;mes mall&eacute;olaires.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec NFS et plaquettes ainsi qu\'une gazom&egrave;trie &agrave; air ambiant.</p>\r\n<p>Je la place pour l\'instant sous Onbrez 150 et kin&eacute;sie respiratoire.</p>\r\n<p>Je la reverrai en consultation le 16/09/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(120,430,'2013-09-09','Dr Vanoote\r\nLa Possession','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme BOYER Marie Anise n&eacute;e le 13/06/1966.</p>\r\n<p>Cette femme mari&eacute;e, 3 enfants n\'a jamais fum&eacute;.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note : une appendicectomie, une c&eacute;sarienne, une cholecystectomie.</p>\r\n<p>En 2006 il lui a &eacute;t&eacute; d&eacute;couvert un goitre.</p>\r\n<p>Histoire de la maladie: Mme Boyer a pr&eacute;sent&eacute; une coqueluche &agrave; l\'age de deux ans et a conserv&eacute; une DDB bilat&eacute;rale;</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e en novembre 2011 pour DDB.</p>\r\n<p>Sa SaO2 est de 98%.</p>\r\n<p>Elle pr&eacute;sente une toux avec expectoration visqueuse et abondante;</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve un freinage expiratoire avec sibilances dans les 2 champs pulmonaires.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec NFS-plaquettes, CRP, ECBC crachats pr&eacute;lev&egrave;s si possible par kin&eacute;sieth&eacute;rapie respiratoire : ex:Direct, culture, ATB.</p>\r\n<p>Je la reverrai le 24/10/2013 pour des EFR.</p>\r\n<p>En attendant il convient de poursuivre chez elle :</p>\r\n<p>A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent) X3/j, Zithromax 250mgX3/semaine;kin&eacute;siett respiratoire tous les jours;</p>\r\n<p>En fonction de ses r&eacute;sultats des crachats une antibioth&eacute;rapie en ar&eacute;opsol pourrait etre ajout&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(121,159,'2013-09-09','Dr Gilbert BOYER\r\nDr C.KICHENIN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme VARONDIN Marie n&eacute;e le 04/02/1941.</p>\r\n<p>Cette dame a 5 enfants. Elle est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un ulc&egrave;re gastro duodenal.</p>\r\n<p>Histoire de la maladie:depuis quelques ann&eacute;es elle pr&eacute;sente une g&egrave;ne respiratoire.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale;</p>\r\n<p>Le TDM thoracique sans injection retrouve une cardiomegalie avec des veines pulmonaires bien visibles t&eacute;mognant d\'un coeur gauche. Aspect large de l\'A. pulmonaire (34mm).</p>\r\n<p>Echo coeur montre une bonne cin&eacute;tique du VG. On note une dilatation du Vd avec HTAP &agrave; 50mmHg connue, stable depuis 1997 (Dr Kichenin).</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 74% de la norme. Le VEMS est &agrave; 0.96 soit 61% de la norme. Le Tiffeneau est &agrave; 85% de la norme. La TLCO est ininterpr&eacute;table car la patiente n\'a pu tenir l\'apn&eacute;e.</p>\r\n<p>Il serait bon de pratiquer une kin&eacute;sieth&eacute;rapie respiratoire &agrave; cette patiente ainsi que FORADIL 1BX2.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(122,432,'2013-09-09','Dr Bobate','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MOHAMED Ousman n&eacute; le 17/02/1966.</p>\r\n<p>Comme vous le savez ce patient pr&eacute;sente un adenocarcinome pulmonaire diffus metastatique d&eacute;couvert en d&eacute;cembre 2012 et sensible aux inhibiteurs des r&eacute;cepteurs de l\'EGFR. Il pr&eacute;sentait au d&eacute;part une carcinomatose pulmonaire milaire metastatique avec une volumineuse masse du LSD.</p>\r\n<p>Sous IRESSA puis TARCEVA la carcinomatose miliaire a regress&eacute;e et il ne persiste qu\'une image nodulaire du LSD.</p>\r\n<p>Malheurusement en raison de son &eacute;tat h&eacute;patique le patient ne peut prendre du TARCEVA qu\'&agrave; raison de 25mg/jour.</p>\r\n<p>Le patient se plaint de fatigue. Je demande &agrave; voir son taux d\'hemoglobine et je lui programme une EFR le 27/09/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(123,216,'2013-09-09','Medecin SAMU','<p>Cher Confr&egrave;re,</p>\r\n<p>Comme convenu, je r&eacute;it&egrave;re ma demande d\'une EVASAN m&eacute;dicalis&eacute;e pour Mme MOUNIAPIN Sabrina, n&eacute;e le 06/09/1974.</p>\r\n<p>Cette dame pr&eacute;sente une maladie de Rendu-Osler avec de multiples malformations art&eacute;rioveineuses des deux champs pulmonaires &agrave; pr&eacute;dominance droite. Elle a b&eacute;n&eacute;fici&eacute; en septembre 2009 d\'une embolisation pulmonaire bilat&eacute;rale &agrave;&nbsp;l\'H&ocirc;pital Ambroise Par&eacute;.</p>\r\n<p>Son &eacute;tat s\'est aggrav&eacute; depuis le d&eacute;but de l\'ann&eacute;e, et elle recommence &agrave; avoir des h&eacute;moptysies. J\'avais &eacute;cris aux professeurs Chinet et Lacombe le 10 mai 2013 et vous trouverez une copie de cette lettre dans son dossier. J\'ai re&ccedil;u un courrier du Pr. Lacombe qui confirme un rendez-vous d\'hospitalisation &agrave;&nbsp;l\'H&ocirc;pital Ambroise Par&eacute; le mercredi 18 Septembre &agrave; 14h. Je vous ai remis un double de cette convocation. L\'&eacute;tat respiratoire de Mme Mouniapin Sabrina est tr&egrave;s pr&eacute;caire et les gaz du sang montrent un PH &agrave; 7.42, PCO2 44 TORR; PO2 47 TORR, CO2T 29, saturation 84%. L\'&eacute;preuve fonctionnelle respiratoire retrouve un trouble ventilatoire de nature mixte et s&eacute;v&egrave;re, avec VEMS &agrave; 32% de la norme. C\'est la raison pour laquelle cette patiente ne peut voyager qu\'avec accompagnement m&eacute;dical et elle souhaiterait &ecirc;tre hospitalis&eacute;e au pr&eacute;alable.</p>\r\n<p>Je vous suis extrement reconnaissant de bien vouloir organiser son EVASAN m&eacute;dicalis&eacute;. L\'assistance sociale du service de cardiologie, Mme M\'LAMALI Prisca, tel : 0 262 90 61 76 est au courant du dossier, du suivi social.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(124,254,'2013-10-01','Dr Bordier\r\nPcie Cheung Leung\r\n','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme TREPORT Marie Mimosette n&eacute;e le 15/08/1959.Cette dame mari&eacute;e 3 enfants est femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note deux c&eacute;sariennes.Mme Treport a un fils asthmatique.</p>\r\n<p>Elle pr&eacute;sente un asthme ayant d&eacute;but&eacute; en 2010.Son asthme s\'est aggrav&eacute; et a &eacute;t&eacute; hospitalis&eacute; 3 fois pour asthme.</p>\r\n<p>Elle a grossi et a pris 3kilos en un an sous corticith&eacute;rapie. ,son IMC est &agrave; 30.1 ce qui correspond &agrave; surpoids.Actuellement on note des sibilances dans les deux champs pulmonaires.Le score de Mallampati est de3 /4.Son score d\'Epworth est &agrave; 9/18.Elle pr&eacute;sente 1 nyctiurie nocturne.</p>\r\n<p>L\'EFR du 30/07/2013 retrouvait un trouble ventilatoire obstructif GOLD II avec reversibilit&eacute; du VEMS qui passe de 1.36 &agrave; 1.43 sous b2inhal&eacute;s. Il existe par ailleurs une distension pulmonaire avecVGT &agrave; 107% ,VR &agrave; 137%. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.49. Il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Les IgE totales sont &agrave; 513UI/ml .Son poids est de 74 kilos ce qui correspond &agrave; un traitement de XOLAIR &agrave; 450 mg en S/C 2 fois/mois.Elle a eu le 09/09/2013 une polygraphie nocturne qui a retrouv&eacute; un IAH &agrave; 19/Heure mais un taux d\'IAH avec &eacute;venements &agrave; 48/heure ;Par ailleurs on note 338/heure avec une energie moyenne de 87dB ce qui correspond &agrave; un ronflement majeur.Mme Treport b&eacute;n&eacute;ficiera d\'une polysomnographie.&nbsp;</p>\r\n<p>Elle prend pour son asthme: A&eacute;rosolttt\'Bricanyl-Atrovent)X3/jPulmicortX2/JSingulair 10 mg 1cp le soirAerius 5mg 1cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(125,440,'2013-10-02','Dr Deboisvilliers','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour M. MAILLOT henri n&eacute; le 17/03/1932.</p>\r\n<p>Ce monsieur veuf a 7 enfants. Il exercait la profession de charpentier coffreur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour hernie inguinale bilat&eacute;rale avec resection endoscopique de la prostate.</p>\r\n<p>M. Maillot n\'a jamais fum&eacute;.Il a &eacute;t&eacute; hospitalis&eacute; en 1987 pour expectoration sales.Il pr&eacute;sente une dyspn&eacute;e grade2/3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires sthetacoustiques;Je demande ce jour un TDM thoracique sans injection avec NFS-Plqt.Il pr&eacute;sente une symptomatollogie de reflux gastro oesophagien avec toux et je lui prescrit:Inexium 40mg matin et soir,gaviscon 1 sachetX3/J;</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte mod&eacute;r&eacute; GOLD &nbsp;II dans sa composante obstructive avec un VEMS &agrave; 1.37 soit 69% de la norme peu r&eacute;versible sous b2inhal&eacute;s.Le Tiffeneau est &agrave; 91% et il existe une distension pulmoniare avec VR &agrave; 134% et VGT &agrave; 117%.La resistance des voies a&eacute;riennes est augment&eacute;e &agrave; 0.42.</p>\r\n<p>Je conseille &agrave; M.Maillot un traitement par Onbrez 150 associ&eacute; &agrave; Spiriva Respimat 2B/j et kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(126,187,'2013-09-10',' SOS Médecins','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. COMBRESSAMY Ludovic n&eacute; le 17/04/1977.</p>\r\n<p>Ce monsieur non fumeur est mari&eacute; 2 enfants.</p>\r\n<p>Il exerce la profession de g&eacute;rant des soci&eacute;t&eacute;s.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents il a pr&eacute;sent&eacute; un syndrome des jambes sans repos.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un p&egrave;re asthmatique.</p>\r\n<p>Son asthme a demarr&eacute; dans l\'enfance avec exacerbation depuis 10 ans.</p>\r\n<p>Sa derni&egrave;re grosse crise date du mois d\'aout.</p>\r\n<p>Ce jour sous traitement il va mieux mais on note une symptomatologie de reflux gastro oesophagien.</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale. La phlethysmographie sera &agrave; recontroler dans 3 mois apr&egrave;s le traitement antireflux.</p>\r\n<p>Le bilan allergologique montre des IgE totales &agrave; 337UI/ml;</p>\r\n<p>RAST aux trophallerg&egrave;nes n&eacute;gatif.</p>\r\n<p>RAST aux pneumallerg&egrave;nes faiblement positifs aux phan&egrave;res de chien et aux cafards mais classe 3 aux acariens.</p>\r\n<p>Le scanner des sinus montre un &eacute;paississement muqueux des cellules ethmoidales.</p>\r\n<p>Son traitement comporttera:</p>\r\n<p>Eludril gargarisme m et s 10jrs/mois pendant 2 mois;</p>\r\n<p>Inexium 40 mg m zets avec gaviscon 1 schtX3 pdt 3 mois avec Symbicort 2BX2.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(127,181,'2013-09-10','Dr BOBATE','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SIDAT Cassim n&eacute; le 13/04/1948.</p>\r\n<p>Ce monsieur mari&eacute; a un enfant.</p>\r\n<p>Il exercait la profession d\'artisan.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une angioplastie coronarienne en 2004,2008 et 2010. Il a eu une radiofr&egrave;quence cardiaque en 2010 &agrave; St Pierre. Par ailleurs il est tarait&eacute; pour hypertrophie prostatique, DID, HTA, goutte., glaucome, UGD.</p>\r\n<p>Le patient se plaint de dyspn&eacute;e.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ses EFR montrent une spirographie peu perturb&eacute;. VEMS &agrave; 2.21 soit 76% de la norme. Tiffeneau &agrave; 83% de la norme. Phlethysmographie N; Pas de trouble de la diffusion.</p>\r\n<p>Le TDM thoracique&nbsp;retrouve de discr&eacute;tes DDB au niveau du lobe moyen et de la lingula.</p>\r\n<p>Le patient se plaint en outre d\'une toux s&eacute;che le soir. Je pense qu\'un traitement antireflux m&eacute;rite d\'etre essay&eacute; associ&eacute; &agrave; une kin&eacute;sieth&eacute;rapie respiratoire.a associer &agrave; dimetane sirop sans sucre jusqu\'&agrave; 2 cuil mesureX3/J.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(128,448,'2013-09-10','Dr Patrick VINCENT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. M\'BOLA Joseph Marcel n&eacute; le 18/05/1941.</p>\r\n<p>Ce patient pr&eacute;sente un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 4.15,soit 70% de la norme et un VR &agrave; 1.36 soit 55% de la norme.Le VEMS est &agrave; 1.89 soit 78% avec un Tiffeneau &agrave; 79% de la norme.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>&nbsp;</p>\r\n<p>Dr. B. TANGUY</p>'),(129,38,'2013-09-10','Dr Roseline PAYET','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SELLINGUE ITEMA Marie Paule n&eacute;e le 08/07/1937.</p>\r\n<p>Cette dame, veuve, 2 enfants, &eacute;tait employ&eacute;e de maison.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents on note une hysterectomie, une angioplastie coronarienne, une HTA, un DID.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 4 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif grade II avec VEMS &agrave; 0.63 soit 57% le Tiffeneau est &agrave; 61%; En phlethysmographie on note des signes de distension pulmonaire avec VGT &agrave; 143% CPT &agrave; 105% VR &agrave; 147%.</p>\r\n<p>La resistance des voies a&eacute;riennes est augment&eacute;e &agrave; 1.63 sans trouble majeur du transfert.</p>\r\n<p>Son IMC est &agrave; 36 ce qui correspond &agrave; une obesit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>Elle pr&eacute;sente une hypersomnie diurne avec un Score de Mallampati &agrave; 3/4.</p>\r\n<p>Son Score d\'Epworth est &agrave; 11/12</p>\r\n<p>Mme Sellingue Itema aura une radiographie pulmonaire ainsi qu\'une GDS &agrave; AA.</p>\r\n<p>Elle poursuivra son traitement habituel et je la reverrai le 23/10/2013 en consultation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(130,48,'2013-09-10','Dr Bobate','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. LERY Issop n&eacute; le 22/11/1934.</p>\r\n<p>Ant&eacute;c&eacute;dents : on note un tabagisme depuis l\'age de 13 ans, sevr&eacute; en 2010, totalisant 60 paquets/an. Appendicectomie et op&eacute;r&eacute; d\'une hernie inguinale droite.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2-3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique retrouve ce jour des discrets des membres inf&eacute;rieurs, avec&nbsp;ventre ballonn&eacute;. Le patient pr&eacute;sente un ronflement avec un score d\'Epworth &agrave; 6/24 et un&nbsp;score de Mallampati est de 2-3. Il recevra une polygraphie nocturne le 18 d&eacute;cembre.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>La radiographie pulmonaire montre des signes de distention thoracique&nbsp;avec applatissement des coupoles diaphragmatique&nbsp;et l&eacute;ger d&eacute;roulement de la ligne para-aortique gauche.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire mixte GOLD II dans sa composante obstructive, avec VEMS &agrave; 70% de la norme, Tiffenau &agrave; 88% de la norme, CPT &agrave; 52% de la norme, avec Trouble de la diffusion (TLCO &agrave; 56% de la norme).</p>\r\n<p>Traitement :</p>\r\n<p>-OLD avec Respidom</p>\r\n<p>-a b&eacute;n&eacute;fici&eacute; d\'un programme de r&eacute;habilitation respiratoire</p>\r\n<p>-refuse la kin&eacute; respiratoire</p>\r\n<p>-onbrez 300 &micro;g</p>\r\n<p>-spiriva respimat 2b/j</p>\r\n<p>-a&eacute;rosol th&eacute;rapie</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(131,193,'2013-09-10','Dr METE','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme ALAISE Daniela Marie n&eacute;e le 26/03/1971.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents familiaux on note 2 fils asthmatiques. Elle ne pr&eacute;sente pas d\'ant&eacute;c&eacute;dents m&eacute;dico-chirurgical particulier, si ce n\'est un asthme depuis l\'&acirc;ge de 6 ans. Elle a &eacute;t&eacute; hospitalis&eacute; &agrave; l\'&acirc;ge de 18 ans pour asthme, et 2 autres fois.</p>\r\n<p>Actuellement, elle va mieux depuis qu\'elle est sous Xolair, son &eacute;tat s\'est nettement am&eacute;lior&eacute;.&nbsp;</p>\r\n<p>Son IMC est &agrave; 27.9, ce qui correspond &agrave; un surpoids.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour quelques ronchies.</p>\r\n<p>L\'EFR montre un trouble ventilaltoire obstctructif GOLD II. Le VEMS est &agrave; 1,36L, soit 57% de la norme, avec des signes de distention thoracique, VGT 159% de la norme, VPT 115% de la norme et VR 182% de la norme. Les resistances des voies a&eacute;riennes sont augment&eacute;es a 0,43. Il n\'existe pas de trouble du transfert.</p>\r\n<p>Son traitement actuel est Xolair, 150 mg, sigulair inovair 2B m+s avec rin&ccedil;age.</p>\r\n<p>Elle sera revue le 31 octobre 2013 en consultation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(132,82,'2013-09-10','Dr. Viel','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MOIMBE Ir&egrave;ne n&eacute; le 28/12/1944.</p>\r\n<p>Ce patient, ancien fumeur 1 paquet/j depuis l\'&acirc;ge de 16 ans, a pr&eacute;sent&eacute; un&nbsp;ad&eacute;nocarcinome pulmonaire TTF1 positif depuis Ao&ucirc;t 2010, avec nodule pulmonaire contre lat&eacute;ral, soit stade 4. Il a &eacute;t&eacute; trait&eacute; par chimioth&eacute;rapie ALIMTA en premi&egrave;re ligne, puis par tarc&eacute;va 100mg en deuxi&egrave;me ligne.</p>\r\n<p>Il est en outre trait&eacute; pour DID, HTA, BPCO post-tabagique.&nbsp;Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire ce jour est dans les limites de la normale. Le scanner thoracique pratiqu&eacute; le 6 mars 2013 a montr&eacute; l\'absence de foyer pulmonaire &agrave; l\'&eacute;tage thoracique, et l\'absence d\'anomalie &agrave; l\'&eacute;tage abdominal. Je demande un scanner&nbsp;thoraco-abdomino-pelvien de contr&ocirc;le, qu\'il aura le 31 octobre &agrave; 8h.</p>\r\n<p>L\'EFR a montr&eacute; un trouble ventilatoire obstructif GOLD II, avec VEMS a 1,77L soit 60% de la norme, Tiffenau &agrave; 73%. Il existe des signes de distension thoracique avec VGT &agrave; 137% de la norme, VR 142% de la norme. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0,51. La TLCO est abaiss&eacute;e a 71%.</p>\r\n<p>Nous poursuivons chez ce patient :</p>\r\n<p>- spiriva respimat 2b/j</p>\r\n<p>- onbrez 150&micro;G, 1b/J</p>\r\n<p>- tarciva 100mg 1b/j</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(133,59,'2013-09-10','Dr. Mas','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. JAMS MARC AUGUSTIN n&eacute; le 06/09/1945. Ce patient, ancien fumeur, sevr&eacute; depuis 16 ans, totalise environs 30 paquets/an. Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une&nbsp;hernie inguinale droite en 2013. Il pr&eacute;sente une BPCO post tabagique s&eacute;v&egrave;re.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p><strong>Auscultation :</strong></p>\r\n<p>Rochi dans les 2 champs pulmonaires avec freinage expiratoire.</p>\r\n<p><strong>EFR :</strong></p>\r\n<p>Trouble ventilatoire obstructif GOLD II mod&eacute;r&eacute;, sans distension thoracique, sans trouble du transfert</p>\r\n<p><strong>Gazom&eacute;trie air ambiant :</strong></p>\r\n<p>pH : 7.4</p>\r\n<p>pO2 : 66</p>\r\n<p>TORR pCO2 : 45</p>\r\n<p>TORR SaO2 : 93%</p>\r\n<p><strong>Traitement :</strong></p>\r\n<p>Patient pris en charge par SOS Oxyg&egrave;ne, sous VNI, a&eacute;rosol, oxyg&egrave;ne.</p>\r\n<p>Onbrez 300 &micro;g (2B x 150 &micro;g) spiriva respimat 2B A&eacute;rosol th&eacute;rapie (bricanyl atrovent) 3x par jour</p>\r\n<p>Je demande un dosage d\'IgE total, avec un scanner thoracique qu\'il aura le jeudi 7 Novembre 2013, &agrave; 8h, &agrave; la clinique Saint-Vincent.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(134,207,'2013-09-10','Dr. Bruno CADET\r\nSEPRODOM','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme VOULAMALE Viviene n&eacute;e le 12/10/1936.</p>\r\n<p>Cette dame a &eacute;t&eacute; hospitalis&eacute;e a plusieurs reprises au CHU de Bellepierre pour d&eacute;compensation de BPCO du a la cuisson au feu de bois. Elle est non fumeuse, c&eacute;libataire sans enfant.</p>\r\n<p>Elle a subie une hyst&eacute;ristomie totale il y a plusieurs ann&eacute;es, pour raison x.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique retrouve a l\'auscultation : un assourdissement des&nbsp;bruits pulmonaires st&eacute;thacoustiques. La radiographie thoracique retrouve un applatissement des coupoles diaphragmatique, avec l&eacute;ger d&eacute;roulement de la ligne para-aortique gauche.</p>\r\n<p><strong>GDS AA :</strong></p>\r\n<p>pH 7,44; pCO2 47 TORR; pO2 70 TORR; SaO2 93%.</p>\r\n<p>Elle est trait&eacute; actuellement par VNI, kin&eacute; respiratoire, onbrez 300&micro;g/j, spiriva respimat 2b/j, miflonil 400 1bx2, avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(135,225,'2013-09-10','Dr Bourdais','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme MONTFORT Monique n&eacute;e le 23/05/1960.</p>\r\n<p>La num&eacute;ration formule sanguine ne montre pas d\'hyper &eacute;osinophilie. En revanche, on note de nombreux colonies pseudomonas aeruginosa.</p>\r\n<p>Il convient donc d\'additionner au traitement du ZITHROMAX 250 mg X/semaine et poursuivre une kin&eacute;siettt intensive de d&eacute;sobstruction bronchique.</p>\r\n<p>Veuillez agr&eacute;er, cher confr&egrave;re, l\'assurance de mes sentiments les meilleurs;</p>\r\n<p>Dr B. TANGUY.</p>'),(136,437,'2013-09-10','Dr. Allane','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ANASTHASIE Francis n&eacute; le 26/09/1938. Ce monsieur, c&eacute;libataire sans enfant, ancien fumeur, 10 cigarettes/j, sevr&eacute; depuis 2012, totalise env. 30 paquets/an. Il est&nbsp;ancien manoeuvre camion, soumis &agrave; un fort enpousi&egrave;rage.&nbsp;</p>\r\n<p>Ce patient a &eacute;t&eacute; op&eacute;r&eacute; d\'unulc&egrave;re gastro duod&eacute;nal, et d\'une art&eacute;rite du membre inf&eacute;rieur gauche. Il est &eacute;galement trait&eacute; pour hernie discale, avec sciatalgie.</p>\r\n<p>Sur le plan respiratoire, ce patient pr&eacute;sente une toux s&egrave;che, avec&nbsp;une dyspn&eacute;e grade 4 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'ausculatation montre un asourdissement des bruits pulmonaire st&eacute;tacoustique avec des ronchi perceptibles dans les deux champs pulmonaires.</p>\r\n<p>Nous allons demander un scanner thoracique et M. Anasthasie aura une EFR le 15 Octobre &agrave; 15h.</p>\r\n<p>Sa SaO2 &agrave; air ambiant est de 97%, pouls &agrave; 62.</p>\r\n<p>Je pr&eacute;scrit ce jour une radiographie thoracique que M. Anasthasie m\'apportera lors de sa prochaine visite.</p>\r\n<p>Sur le plan th&eacute;rapeutique, il convient de continuer une kin&eacute;sith&eacute;rapie respiratoire, poursuivre onbrez, spiriva respimat 2b/j, pulmicort 400,&nbsp;a&eacute;rosol th&eacute;rapie bricanyl atrovent 2x/j, et a&eacute;rosol pulmicort x2 avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(137,439,'2013-09-10','Dr Grevelynche','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour l\'enfant MAILLOT Kenza n&eacute;e le 08/02/2004.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une cousine et un fr&egrave;re asthmatique.</p>\r\n<p>Histoire de la maladie : Kenza pr&eacute;sente un asthme depuis la tendre enfance mais n\'a jamais &eacute;t&eacute; hospitalis&eacute;e pour asthme.</p>\r\n<p>Actuellement elle pr&eacute;sente une toux nocturne avec parfois &nbsp;des sibilances.</p>\r\n<p>Elle pr&eacute;sente une symptomatologie de reflux gastro oesophagien avec vomissements trois fois par mois.</p>\r\n<p>Sa TA est &agrave; 11/7 avec SaO2 &agrave; 99% poids &agrave; 26.4K pour&nbsp;</p>\r\n<p>L\'auscultation est dans les limites de la normale.</p>\r\n<p>Je demande ce jour une radiographie thoracique ainsi qu\'un examen parasitologique des selles en raison de douleurs abdominales.</p>\r\n<p>Je pense qu\'il convient de mettre en route un traitement anti-reflux.</p>\r\n<p>Mopral granul&eacute;s pour enfant 10 mg m et s; gaviscon suspension apr&egrave;s les trepas 1 c&agrave;c m et s s&eacute;seretide 250 1 &agrave; 2 B m et s.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(138,439,'2013-09-10','','<p>Je soussign&eacute; Docteur Bernard TANGUY certifie que la jeune MAILLOT Kenza n&eacute;e le 08/02/2004</p>\r\n<p>&nbsp;&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>s\'est pr&eacute;sent&eacute; ce jour &agrave; ma consultation et n\'a pu se rendre &agrave; l\'&eacute;cole.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; St Denis le 10/09/2013.</p>'),(139,454,'2013-09-10','Medecin traitant','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme REBECCA Marie Chantal n&eacute;e le 05/12/1963.</p>\r\n<p>Cette dame non fumeuse, c&eacute;libataire, 4 enfants, travaille aux services d\'entretien de la mairie.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie, une &eacute;ventration abdominale, des kystes des ovaires, un lipome de la face et du bras droit, tendon d\'Achille droit.</p>\r\n<p>Histoire de la Maladie : Mme Rebecca pr&eacute;sente une toux grasse depuis aout 2013.</p>\r\n<p>Cette toux s\'accompagne de dyspn&eacute;e avec sibilances.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour un freinage expiratoire.</p>\r\n<p>Elle m\'apportera sa radiographie pulmonaire et fera un dosage des IgE totales associ&eacute; &agrave; des RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Je lui paratiquerai des EFR le 17/10/2013 pour readapter son traitement.</p>\r\n<p>En attendant je lui prescrit :</p>\r\n<p>- Eludril gargarisme m et s pdt 10 jrs</p>\r\n<p>- Foradil 1 gel inhal&eacute; m et s&nbsp;</p>\r\n<p>- Miflonil 4010 1 gel inhale m et s avec rincage</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(140,386,'2013-09-10','Dr Goburdhun\r\nPr Mal\r\nCHJU Bichat \r\nService de Pneumologie B et de transplantation pulmonaire','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. AYOUBA ABDOU Mohamed n&eacute; le 31/12/1977.</p>\r\n<p>J\'avais adress&eacute; ce patient au Pr Mal pour une transplantation pulmonaire. Il a eu un bilan pr&eacute; greffe et devait &ecirc;tre revu au mois de septembre &agrave; Bichat. Je vais adresser ce jour un mail au Pr Mal pour lui r&eacute;clamer la lettre qu\'il a faite lors de sa consultation du 26/08/2013 et qe je n\'ai pas re&ccedil;u.</p>\r\n<p>Ce jour le patient se sent moins bien et il pr&eacute;sente&nbsp;&nbsp;une dyspn&eacute;e grade3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire restrictif avec VEMS &agrave; 1.73 soit 43% de la norme et un Tiffeneau &agrave; 97%.</p>\r\n<p>Le VGT est &agrave; 54% le CPT &agrave; 39% VR &agrave; 50%.</p>\r\n<p>Je lui prescris des a&eacute;rosols Bricanyl-atroventX3 associ&eacute; kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(141,118,'2013-09-11','Dr MJ TIROLIEN-PHARAON\r\n','<p>Cher Confr&egrave;re,</p>\r\n<p>Suite &agrave; votre lettre du 29/08/2013 Ref : DRMJTP/SH/GA/2013/499 je vous prie de trouver ci-joint une copie de la lettre du Professeur ESCOURROU concernant M.CHARRETIER Pierre n&eacute; le 28/08/1950.</p>\r\n<p>Ce monsieur a en effet &eacute;t&eacute; explor&eacute; &agrave; l\'Hopital Antoine B&eacute;cl&egrave;re de Clamart.</p>\r\n<p>Il semble que ce patient voyage beaucoup et je l\'avais appareill&eacute; lors d\'un de ses s&eacute;jours &agrave; la R&eacute;union.</p>\r\n<p>Il ne s\'est pas pr&eacute;sent&eacute; &agrave; ma consulatation du 20/08/2013.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re , l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(142,314,'2013-09-11','Dr Benaich\r\nDr Alice Pelerin','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme FOUREZ Marie Josseline, n&eacute;e le 30/04/1965.</p>\r\n<p>Cette dame pr&eacute;sente une toux s&egrave;che qui s\'est aggrav&eacute;e depuis son remplacement de valvule aortique le 08/01/2013.</p>\r\n<p>Elle a pris 13 kilos depuis son intervention passant de 56 &agrave; 69 kilos. Son IMC est &agrave; 28 ce qui correspond &agrave; un surpoids.</p>\r\n<p>Son EFR retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 75% de la norme,&nbsp;le Tiffeneau est &agrave; 90% avec VGT &agrave; 79%. Il existe un trouble mod&eacute;r&eacute; de la diffusion avec TLCO &agrave; 69% de la norme.</p>\r\n<p>Elle est actuellement sous traitement anti reflux pour un reflux gastro oesophagien. Depuis vendredi elle pr&eacute;sente une rhinite avec extinction de voix.Je la place sous traitement localis&eacute;.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(143,182,'2013-09-11','Dr MOUSSA','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme SIDAT Khateejan n&eacute;e le 24/11/1948.</p>\r\n<p>Cette dame non fumeuse ,mari&eacute; un enfant,est ancienne employ&eacute;e de maison.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un p&egrave;re &nbsp;,un fr&egrave;re et des neveux et ni&egrave;ces asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne note rien de particulier si ce n\'est un asthme ayant d&eacute;but&eacute; dans l\'enfance.</p>\r\n<p>A signaler plusieurs consultations en urgence ,notamment, par SOS M&eacute;decins pour asthme.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR son &eacute;tat s\'est nettement amelior&eacute;.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Elle prend XOLAIR 300mg 1 fois /mois,&nbsp;ainsi que Singulair 10mg 1 cp le soir et Clarityne.</p>\r\n<p>Elle a &eacute;galement Miflonil 400 1 B le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(144,191,'2013-09-11','Pr NUNES Hilario\r\nHopital Avicennes \r\n125 Rue de Stalingrad\r\n93009 BOBIGNY\r\n\r\nDr REESAUL\r\nChest Clinic \r\nPort Louis \r\nIle Maurice.','<p>Monsieur,</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>J\'ai l\'honneur de vous soumettre pour avis le cas de Mme AUMEER Noorjahan n&eacute;e le 21 juin 1969.</p>\r\n<p>Cette dame, mari&eacute;e a 2 enfants. Elle habite &agrave; l\'Ile Maurice et exerce la profession d\'agent de bureau dans la fonction publique.</p>\r\n<p>Elle est non fumeuse et dans ses ant&eacute;c&egrave;dents on note un prurit cervical il y a 4 ans mis sur le compte du stress.</p>\r\n<p><strong>Histoire de la Maladie&nbsp;</strong>: En d&eacute;cembre 2010 Mme Aumeer pr&eacute;sente une toux lors d\'un s&eacute;jour en Malaisie &agrave; Kuala Lumpur.</p>\r\n<p>A son retour &agrave; l\'Ile Maurice, elle fait 4 \"bronchites\" en 2011 et 2 autres \"bronchites\" en 2012 accompagn&eacute;es de fi&egrave;vre, de toux et de dyspn&eacute;e. Aucun examen radiologique n\'est pratiqu&eacute; &agrave; l\'&eacute;poque.</p>\r\n<p>Ce n\'est que le 07/03/2013 qu\'une radiographie pulmonaire est pratiqu&eacute;e suivi le 15/03/2013 d\'un scanner thoracique.</p>\r\n<p>Cet examen &eacute;voque une UIP avec atteinte reticulaire diffuse pr&eacute;dominant en r&eacute;gion sous-pleurale avec des bronchectasies et pr&eacute;sence de rayon de miel.</p>\r\n<p>Mme Aumeer me consulte &agrave; la R&eacute;union en avril 2013.</p>\r\n<p>Sur le plan clinique il existe une dyspn&eacute;e &agrave; l\'effort avec un hippocratisme digital.</p>\r\n<p>L\'auscultation retrouve des rales velcro.</p>\r\n<p>Un LBA est pratiqu&eacute; le 05/04/2013. Cet examen ram&egrave;ne 90mL de liquide tint&eacute; rosatre avec 55 leucocytes/mm; 3,2100 hematies/mm3. La formule leucocytaire montre : 8% de polynucl&eacute;aires neutrophiles, 4% de polynucl&eacute;aires eosinophiles, 29%de lymphocytes, 59%de macrophages. Le phenotypage des sous-populations lymphocytaires montre : CD3 93.6% CD4 19.2% CD8 62.7% Rapport CD4/CD8 0.3 CD19 3% CD56 + 3%.&nbsp;</p>\r\n<p>La recherche de mycobact&eacute;ries dans le LBA est revenue n&eacute;gative &agrave; l\'examen direct et &agrave; la culture. De meme la recherche de Pneumocystis jirovenci, de cytom&eacute;galovirus s\'est r&eacute;v&egrave;l&eacute;e n&eacute;gative.</p>\r\n<p>L\'examen cyto-pathologique du LBA montre 70% de cellules macrophagiques, 10% de lymphocytes, 4% de polynucl&eacute;aires neutrophiles, 1%de polynucl&eacute;aires &eacute;osinophiles, 5%de cellules cili&eacute;es, 10% d\'hematies. Le score de Golde apr&egrave;s coloration de Perls est de 5%. Conclusion de l\'anatompathologiste : LBA l&eacute;g&egrave;rement hemorragique, sans caract&egrave;re suspect.</p>\r\n<p>L\'EFR r&eacute;alis&eacute; au CHU de Bellepierre le 08/04/2013 montre un trouble ventilatoire de nature restrictive avec VEMS &agrave; 1.3 soit 48% la CVF est &agrave; 1.3 soit 13% avec un Tiffeneau &agrave; 92%. La phlethysmographie ne fonctionnait pas &agrave; l\'hopital au mois d\'avril.</p>\r\n<p>La NFS montre l\'absence d\'hypereosinopilie et de lymphocytose.</p>\r\n<p>L\'electrophor&egrave;se des proteines s&eacute;riques montre un profil inflammatoire avec albumin &agrave; 53.3%, alpha1 &agrave; 4.8% Alpha2 &agrave; 14.2% Beta1 &agrave; 6.6% beta2 &agrave; 5.8% gamma &agrave; 15.3%. Prot&eacute;ines 73G/l A/G 1.14.</p>\r\n<p>Les GDS &agrave; AA montrent : pH 7.45 pCo2 : 35mmHg; pO2 : 99mmHg; SaO2 : 98%.</p>\r\n<p>Le TM6 : Test de marche de 6 minutes montre une d&eacute;saturation au bout de 2 minutes. La SaO2 passant de 98% &agrave; 92%. Le test est arr&eacute;t&eacute; &agrave; 3 minutes la SaO2 passant &agrave; 91%. Distance parcourue 320m pour une distance th&eacute;orique de 631m.</p>\r\n<p>Sur le plan biologique :</p>\r\n<p>Autoanticorps anti-nucl&eacute;aires : n&eacute;gatif, ANCA n&eacute;gative, Anticorps des myosites : anti ARNt synth&eacute;tases, ati:PL7, PL12, EJ, OJ n&eacute;gatif; anticorps anti-SRP n&eacute;gatif; anti-Mi2 n&eacute;gatif. Anticorps anti-Ku, anti-Pm/Scl n&eacute;gatif.</p>\r\n<p>Serologie de la Maladie du poumon des &eacute;leveurs d\'oiseaux : anti s&eacute;rum de pigeon, de poulet n&eacute;gatif; antid&eacute;jection de pigeon 1 arc de pr&eacute;cipitation. Anticorps anti aviaires absence d\'arc de pr&eacute;cipitation. Serologie de la maladie du poumon de fermier : n&eacute;gatif.</p>\r\n<p>Auto anticorps anti nucl&eacute;aires n&eacute;gatif; anticorps antinucl&eacute;aires solubles negatif; S&eacute;rodiagnostic de l\'Aspergillose inf &agrave; 1/80 non significative.</p>\r\n<p>Recherche de facteur rhumatoide n&eacute;gative. Creatinine &agrave; 61 micromol/l, Calc&eacute;mie &agrave; 2.33 mmol/l. Transaminases Normale.</p>\r\n<p>Au terme de ce bilan une corticoth&eacute;rapie est mis en route : Cortancyl 60 mg le m pendant 6 semaines &agrave; doses d&eacute;gressive suivi de 40 mg le matin pendant 6 semaines puis 20 mg le m pendant 6 semaines et 10 mg le m.</p>\r\n<p>La patiente est revu &agrave; la R&eacute;union fin aout 2013. Sur le plan clinique elle se sent mieux et dit &ecirc;tre moins dyspn&eacute;ique.</p>\r\n<p>Un TDM thoracique est pratiqu&eacute; le 19/08/2013. L\'aspect scannographique est inchang&eacute; par rapport au TDM du mois d\'avril 2013.</p>\r\n<p>L\'EFR du 20/08/2013 montre un trouble ventilatoire restrictif avec CPT &agrave; 53% de la norme, VGT &agrave; 59% de la norme, Vr &agrave; 77% de la norme. Le VEMS est &agrave; 1.16 soit 42% le Tiffeneau &agrave; 100%. La TLCO est &agrave; 35% de la norme.</p>\r\n<p>Le test de marche de 6 minutes montre une d&eacute;saturation au bout de 2 minutes : la SaO2 passant de 98% &agrave; 88%. Toutefois la patiente poursuit son effort pendant 6 minutes et la SaO2 repasse &agrave; 91% &agrave; 6 minutes. Distance parcourue 600m pour une th&eacute;orique de 605m.</p>\r\n<p>Je vous adresse le scanner thoracique de cette patiente en vous demandant de bien vouloir me conseiller sur son diagnostic et sa prise en charge.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, Monsieur, l\'assurance des mes sentiments distingu&eacute;s et de ma haute consid&eacute;ration,</p>\r\n<p>Dr. B. TANGUY</p>'),(145,405,'2013-09-11','Dr Lai Fat Fin','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. JONIN Stephane n&eacute; le 25/03/1946.</p>\r\n<p>Son taux d\'IgE totales est de 328UI/ml.Le PHADIATOP est positif &agrave; 34.2.</p>\r\n<p>M.JONIN est probablement allergique aux acariens.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.Il a repris une activit&eacute; sportive;</p>\r\n<p>Il convient qu\'il continue pour l\'instant le SERETIDE 500 1BX2 avec rin&ccedil;age de la bouche &agrave; l\'eau par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(146,83,'2013-09-11','','<p>Je soussign&eacute; Docteur Bernard TANGUY,Pneumologue agr&eacute;e,certifie que l\'&eacute;tat de sant&eacute; de&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><strong>M.PREVOST Roger n&eacute; le 03/02/1941&nbsp;</strong></p>\r\n<p>&nbsp;</p>\r\n<p>ne lui permets pas de se d&eacute;placer.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; Saint Denis le 11/09/2013 et remis en main propre &agrave; l\'interss&eacute; pour servir et valoir ce que de droit.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Dr Bernard TANGUY.</p>'),(147,464,'2013-09-11','Dr Eric BOURDAIS','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. MAILLOT Mario n&eacute; le 18/09/1961.</p>\r\n<p>Ce patient non fumeur s\'occupe de l\'entretien d\'une r&eacute;sidence.</p>\r\n<p>Il est mari&eacute; et a 2 enfants.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une intervention pour des hemorroides.</p>\r\n<p>il est DNID depuis 4 &agrave; 5 ans et a un lumbago chronique;</p>\r\n<p>depuis hier soir il a ressenti une vive douleur dans le dos suite &agrave; un dem&eacute;nagement;</p>\r\n<p>Il pr&eacute;sente une douleur lombaire irradiant dans les 2 M.I.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(148,356,'2013-09-11','',''),(149,282,'2013-09-12','Medecin Service des Urgences\r\nCHU Felix Guyon\r\nDr Jean SEGE','<p>Cher Confrere</p>\r\n<p>Je vous serai reconaissant de bien vouloir hospitaliser M.BELAIR Paul qui pr&eacute;sente une exacerbation de sa BPCO suite &agrave; des travaux dans sa salle de bains.</p>\r\n<p>Ce patient pr&eacute;sente une BPCO s&eacute;v&egrave;re Gold III et est trait&eacute; par VNI,OLD,Onbrez 300,Spiriva Respimat 2B/j,A&eacute;rosolth&eacute;rapie Bricanyl-Atrovent et Pulmicort.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(150,470,'2013-09-12','Dr Marie-Francoise COLE-ROCHER','<p>Cher Consoeur,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme JISTA florence, n&eacute;e le 16/02/1963.</p>\r\n<p>Cette dame mari&eacute;e,3 enfants est agent &agrave; la CGSS.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne note pas d\'asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on ne note aucune maladie sinon un astme ayant d&eacute;but&eacute; dans l\'adolesence &agrave; l\'age de 15 ans.</p>\r\n<p>A l\'epoque elle avait commenc&eacute; &agrave; fumer 10 cigarettes /jour.Elle a arret&eacute; de fumer il y a 17 ans.Mme Jista totalise donc environ 9 PA.mme Jista n\'a jamais &eacute;t&eacute; hospitalis&eacute; et n\'a jamais fait de crise &agrave; proprement parler.Elle est trait&eacute; par PULMICORT depuis plus de vingt ans.</p>\r\n<p>Elle a pr&eacute;sent&eacute; fin juin une grosse bronchite avec secretions bronchiques purulentes.Depuis elle ressent une accentuation de sa dyspn&eacute;e.elle a besoin de recourrir &agrave; la ventoline.</p>\r\n<p>L\'Auscultation retrouve un freinage expiratoire avec quelques sibilances.</p>\r\n<p>Je demande une radiographie pulmonaire,une NFS pour recherche d\'une hyper&eacute;osinophilie,dosage des IgE totales,RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>&nbsp;Sur le &nbsp;plan th&eacute;rapeutique il convient de renforcer le traitement par Symbicort 2B m et s pendant 1 mois avec rincage de la bouche par la suite.</p>\r\n<p>Je pratiquerai le 14/10 une EFR &agrave; Mme Jista.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(151,472,'2013-09-12','Dr Adeline DUTARTRE\r\nDr Danielle BEHARY-LE BIHAN','<p>Cher Consoeur,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. HOARAU Antoine, n&eacute; le 07/08/1937</p>\r\n<p>Ce monsieur est un ancien fumeur 1 paquet/jour, sevr&eacute; depuis plus de 20 ans, totalisant environ 30PA.</p>\r\n<p>Il exercait la profession de manoeuvre macon. Il est veuf et a 7 enfants.</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une hernie inguinale gauche et il est sous previscan pour une thrombose veineuse profonde du MIG.</p>\r\n<p><strong>Histoire de la Maladie :&nbsp;</strong>Dans le cadre d\'une douleur paravert&eacute;brale droite a &eacute;t&eacute; pratiqu&eacute; un scanner thoracique le 25/06/2013. Cet examen a retrouv&eacute; une image parenchymateuse du segment 7 du LID. Un controle scannographique a &eacute;t&eacute; &nbsp;pratiqu&eacute; le 09/07/2013 et le 09/09/2013. J\'ai compar&eacute; les scanners de juin et de septembre 2013. On note la persistance de l\'image qui rsete stable et fait penser &agrave; quelque chose de cicatricielle. En revanche il existe des signes d\'emphys&eacute;me pulmonaire majeur.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Son poids est de 47.5 Kg pour une taille de 155cm</p>\r\n<p>La SaO2 est &agrave; 97%. L\'auscultation retrouve un assourdissement des bruits pulmonaiores sthetacoustiques.</p>\r\n<p>J\'ai appell&eacute; le CHU pour pratiquer un PETScan. Ils vont m\'adresser un formulaire &agrave; remplir.</p>\r\n<p>Je reverrai M. Hoarau le 17/09 et le 26/09 pour des EFR.</p>\r\n<p>En attendant je le place sous Onbrez 150/j Spiriva Respimat 2B/j et Pulmicort 400 1B m et s ainsi que kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, ch&egrave;re Consoeur, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(152,462,'2013-09-12','Dr ARSAC\r\nDr SATSOU\r\nDR FROTTIER','<p>Cher Confr&egrave;re,</p>\r\n<p>&nbsp;</p>\r\n<p>J\'ai vu ce jour Enfant DUCHEMAN Nathan n&eacute; le 01/11/2007.</p>\r\n<p>Cet enfant pr&eacute;sente des ant&eacute;c&egrave;dents familiaux d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note des bronchites asthmatiformes avec infection bronchopulmonaire. Il a &eacute;t&eacute; hospitalis&eacute; une fois.</p>\r\n<p>Recemment, d&eacute;but ao&ucirc;t, le Dr Satsou, cardiologue, a eu le m&eacute;rite de lui diagnostiquer une CIA sinus venosus.</p>\r\n<p>Je n\'ai pu joindre le Dr Satsou ce matin et comme je connais la famille j\'ai appel&eacute; le Dr Moshinaly qui m\'a parl&eacute; d\'une mission de Marie Lannelongue qui sera &agrave; la R&eacute;union en octobre 2013.</p>\r\n<p>La maman &eacute;tant T&eacute;moin de J&eacute;hovah elle est &agrave; la recherche d\'une technique peu invasive pour limiter les risques de saignement.</p>\r\n<p>Je vous serai reconaissant d\'examiner cet enfant pour me faire part d\'une solution interventionelle le concernant.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp; &nbsp; &nbsp;&nbsp;</p>'),(153,462,'2013-09-12','','<p>Je sousign&eacute;, Dr. Bernard TANGUY, certifie que M. Ducheman V., est venu consulter ce matin pour sa famille.</p>\r\n<p>&nbsp;</p>\r\n<p>Dr. Bernard TANGUY</p>'),(154,97,'2013-10-08','Dr Gueneau\r\nDr Gatina','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. FLEURY Denis Irenee n&eacute; le 12/10/1941.</p>\r\n<p>Ce monsieur est un ancien p&eacute;cheur &agrave; la retraite. Il est divorc&eacute; et a 4 enfants.</p>\r\n<p>Il pr&eacute;sente dans ses ant&eacute;c&egrave;dents une pleurectomie droite en 1978 et une proth&egrave;se de hanche en 1984.</p>\r\n<p>Il est trait&eacute; pour un DNID.</p>\r\n<p>Actuellement il ne pr&eacute;sente pas de symptomatologie respiratoire.</p>\r\n<p>Ses EFR sont dans les limiters de la normale.</p>\r\n<p>La radiographie thoracique retrouve une ascension de l\'hemicoupole diaphragmatique droit avec &eacute;moussement du cul de sac costodiaphragmatique droit d\'origine s&eacute;quellaire.Il n\'existe pas d\'image parenchymateuse &eacute;volutive.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(155,91,'2013-09-12','Dr Tamburini-Bonnefoy','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. EVRIN Joseph Axel n&eacute; le 23/10/1939.</p>\r\n<p>Ce patient a consult&eacute; aux Urgences du CHGM le 11/09/2013 pour exacerbation de sa BPCO.</p>\r\n<p>Je lui prescrit en a&eacute;rosolth&eacute;rapie : Bricanyl-AtroventX3/j</p>\r\n<p>PulmicortX2/j</p>\r\n<p>Rulid 150 mg 1X2 pendant 7 jours</p>\r\n<p>Solupred 60mg en diminuant de 5 mg tous les 2 jours en vue arret.</p>\r\n<p>Kin&eacute;sieth&eacute;rapie respiratoire 2 fois par jour</p>\r\n<p>Inexium 40 mg/j</p>\r\n<p>Gaviscon 1X3.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(156,476,'2013-09-16','Service des Urgences\r\nCentre Hospitalier Gabriel Martin\r\nSaint-Paul','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de bien vouloir hospitaliser ce jour M. TIEFFENBACH Lucien, n&eacute; le 20/07/1938;</p>\r\n<p>Je connais bien ce patient qui a eu une laryngectomie totale en decembre 2012.</p>\r\n<p>Depuis 10 jours le patient a ressenti une asth&eacute;nie suivie d\'une anorexie avec fi&egrave;vre. Sur le plan radiologique on note en date du 09/09/2013 une opacit&eacute; heterog&egrave;ne sous claviculaire gauche avec &agrave; la base droite une opacit&eacute; ovoide probablement de nature pleurale.</p>\r\n<p>Actullement le patient est toujours sous antibiotique : Amoxicilline-Rovamycine.</p>\r\n<p>Son &eacute;tat g&eacute;n&eacute;ral s\'est beaucoup aggrav&eacute; et il a b&eacute;n&eacute;fici&eacute; ce jour d\'un scanner thoracique et abdominal &agrave; Saint-Paul. Cet examen montre une masse pulmonaire avec atteinte m&eacute;diastinale et lyse osseuse. Il y a une forte suspicion de m&eacute;tastase thoracique chez ce patient. De plus, il pr&eacute;sente des vomissements avec constipation. Son &eacute;tat est incompatible avec un maintient &agrave; domicile, et je vous l\'adresse pour prise en charge hospitali&egrave;re.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(157,254,'2013-09-12','Dr Maigrat','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme TREPORT Marie Mimosette n&eacute;e le 15/08/1959 qui m\'a dit avoir &eacute;t&eacute; r&egrave;s g&eacute;n&eacute;e ce matin pour respirer. Elle m\'a dit cracher sales et de mani&egrave;re abondante.</p>\r\n<p>L\'auscultation pulmonaire n\'est pas tr&egrave;s alarmant.Elle a de plus mal &agrave; la gorge et je la place sous ELUDRIL gargarisme m et s.</p>\r\n<p>Je la vois un peu tendu et je lui conseille de prendre de l\'ATARAX 25 mg m et s.</p>\r\n<p>Ainsi que Rulid 1cpX2.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(158,397,'2013-09-12','Dr Eric FONTAINE\r\nISIS Réunion','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. CADET Nicole n&eacute; le 06/11/1952.</p>\r\n<p>Ce patient a b&eacute;n&eacute;fici&eacute; dans la nuit du 14 au 15/10/2013 d\'une polysomnographie.</p>\r\n<p>Cet examen a retrouv&eacute; un Index d\'Apn&eacute;es-hypopn&eacute;es de 30/H .On note 25 micro-&eacute;veils/h et l\'IAH passe &agrave; 37/H quand on y associe les &eacute;venements.</p>\r\n<p>Par ailleurs on note 12 d&eacute;saturations/H avec une SaO2 minimale de 84%.</p>\r\n<p>En ce qui concerne les ronflements ,on note 294/h avec une energie moyenne de 89db.</p>\r\n<p>M.Cadet pr&eacute;sente donc un syndrome d\'apn&eacute;es du sommeil et sera appareill&eacute; la semaine prochaine par la Soci&eacute;t&eacute; ISIS Reunion en PPC en mode autopilot&eacute;e avec une pression entre 5 et 12 cmd\'eau.</p>\r\n<p>De plus compte tenu de son hyperr&eacute;activit&eacute; bronchique -voir ma lettre pr&eacute;c&egrave;dente-je lui propose un traitelment par FORADIL 1 gelule inhal&eacute;e m et s .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(159,322,'2013-09-12','Dr Ibrahim PATEL\r\nRESPIDOM','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme MURCY Odile n&eacute;e le 05/12/1950.</p>\r\n<p>Cette dame veuve 3 enfants est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note des fr&egrave;res et soeurs asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un AVP avec fracture de la jambe gauche. Elle a aussi &eacute;t&eacute; op&eacute;r&eacute;e d\'une st&eacute;nose carotidienne bilat&eacute;rale. Elle est &eacute;galement trait&eacute; pour hernie discale.</p>\r\n<p>Elle est diab&eacute;tique insulino d&eacute;pendant,hypertendue.</p>\r\n<p>Son IMC est &agrave; 33.3 ce qui correspond &agrave; une obesit&eacute; mod&eacute;r&eacute;e.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Le perimetre cervical est &agrave; 41 cm, le perimetre abdominal &nbsp;est &agrave; 105cm.</p>\r\n<p>Le score de Mallampati est de 3 /4.</p>\r\n<p>Le Score d\'Epworth est de 6/15.</p>\r\n<p>La radiographie thoracique montre une sur&eacute;l&eacute;vation de la coupole diaphragmatique droite avec de grosses art&egrave;res pulmonaires.</p>\r\n<p>L\'EFR montre une augmentation de la resistance des voies a&eacute;riennes &agrave; 0.62.</p>\r\n<p>Il existe un trouble ventilatoire restrictif mod&eacute;r&eacute;.</p>\r\n<p>Je lui donne un RV de polygraphie nocturne le 10/02/2014 &agrave; 16H et un rendez vous de Cs le 19/11/2013.</p>\r\n<p>Elle poursuivra entre temps son traitement habituel .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(161,426,'2013-10-07','Dr VALLY\r\n','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme PAPAYA Jocelyne n&eacute;e le 03/11/1951.Cette dame non fumeuse est mari&eacute;,5 enfants.</p>\r\n<p>Elle travaillait aux services d\'entretien de la BNP.Elle n\'a pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une cholecystectomie,une hysterectomie partielle par le Dr Kah;</p>\r\n<p>Elle est &eacute;galement suivie pour HTA,glyc&eacute;mie limite,hypercholesterol&eacute;mie,glaucome,st&eacute;nose carotidienne &agrave; 50% et 60%</p>\r\n<p><strong>Histoire de la Maladie&nbsp;</strong>:&nbsp;L\'asthme de Mme Papaya a d&eacute;but&eacute; il y a quelques ann&eacute;es.Sa derni&egrave;re crise d\'asthme date de mars 2012.Le soir elle pr&eacute;sente des sifflements.Elle pr&eacute;sente une dyspn&eacute;e grade3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Elle pr&eacute;sente en outre un ronflement g&eacute;nant pour l\'&eacute;poux et des pauses respiratoires.</p>\r\n<p>Elle pr&eacute;sente un poids de 72kilos pour une taille de 151cm avec un IMC de 31.6 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.Son Score d\'Epworth est &agrave; 17/24.&nbsp;Le score de Mallampati est de 2/4.</p>\r\n<p>La radiographie thoracique retrouve un &eacute;paisissement bronchique mod&eacute;r&eacute;.Les IgE totales sont &agrave; 12UI/ml Il n\'existe pas d\'hypereosinophilie:eosinocytes &agrave; 172/mm3.Les RAST aux pneumallerg&egrave;nes sont n&eacute;gatifs ainsi qu\'aux trophallerg&egrave;nes.Classe 2 aux phan&egrave;res de chien.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif avec CPT &agrave; 66% VR &agrave; 37% de la norme.Spirographie et diffusion dans les limites de la normale.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille elle prend pour l\'instant du &nbsp;MIFLONIL400 1X2 avec rincage.Je lui presrit la kin&eacute;siettt respiratoire.</p>\r\n<p>&nbsp;Une polygraphie nocturne est programm&eacute;e le 28/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(162,458,'2013-09-13','Dr Sabatier\r\nLa saline','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme METANIRE Marie Viviane n&eacute;e le 03/04/1949.</p>\r\n<p>Cette dame est nonfumeuse. Elle est une ancienne agricultrice.</p>\r\n<p>Elle vit en concubinage et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents familiaux on ne note pas d\'asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels on retrouve aucune maladie si ce n\'est un asthme;</p>\r\n<p>Son asthme a d&eacute;but&eacute; dans l\'enfance; Sa derni&egrave;re crise d\'asthme s&eacute;v&egrave;re date de 2006.</p>\r\n<p>Le traitement par XOLAIR lui a &eacute;t&eacute; profitable.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Sa famille lui dit qu\'elle ronfle le soir. Son score d\'Epworth est &agrave; 12/18.</p>\r\n<p>Le score de Mallampati est de 3 /4.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire ainsi qu\'un dosage d\'IgE totales de RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes et une NFS.</p>\r\n<p>Mme Metanire aura le 11/10/2013 une EFR et le 12/02/2013 une polygraphie nocturne.</p>\r\n<p>En attendant elle poursuivra Xolair 375 mgX2/mois et FORADIL-MIFLONIL.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(163,460,'2013-09-13','Dr LACAZE\r\nO2CM','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. TESTAN Maurice Virgile n&eacute; le 22/09/1936.</p>\r\n<p>Ce patient est un ancien fumeur 2 pqt/j, sevr&eacute; depuis plus de 10 ans.</p>\r\n<p>Il s\'agit d\'un ancien macon, mari&eacute; 9 enfants.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont demarr&eacute; depuis plus de 15 ans.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Sa SaO2 est &agrave; 84% avec un pouls &agrave; 80.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec assourdissements des bruits pulmonaires stethacoustiques.</p>\r\n<p>Je demande ce jour une radiographie thoracique avec GDS &agrave; AA ,une NFS et CRP.</p>\r\n<p>il convient de poursuivre chez ce patient :OLD 2L/mn 24H/24.A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent) x 3/J; onbrez300; Spiriva &nbsp;Respimat 2B/j; pulmicortX2/j; Il refuse la kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Je reverrai le 11/10/2013 pour des EFR et r&eacute;adapter son traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(164,143,'2013-09-13','Dr DOUSSAUD','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. ESPERANCE Laurent n&eacute; le 01/09/1928.</p>\r\n<p>Ce patient a pr&eacute;sent&eacute; une gastroenterite ayant d&eacute;but&eacute; il y a une semaine en cours de regression.</p>\r\n<p>La toux qui s\'&eacute;tait calm&eacute; s\'est r&eacute;accentu&eacute;.</p>\r\n<p>Il convient d\'attendre que les choses se tassent.</p>\r\n<p>Et poursuivre a&eacute;rosolth&eacute;rapie Bricanyl-Atroventx/j;pulmicortX2 avec rin&ccedil;age;Inexium 40mgX2 et Gaviscon 1 sachetX3.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(165,479,'2013-10-09','Dr Richard PIERRA','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme DELMOND Andy Risla n&eacute;e le 26/02/1942.</p>\r\n<p>Cette dame est non fumeuse et travaillait comme aide &agrave; domicile.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une hypercholesterol&eacute;mie, une intervention pour cataracte bilat&eacute;rale et des nodules thyroidiens stables.</p>\r\n<p>&nbsp;Le 20/04/2012 Mme Delmond a eu un AVP qui lui a paratiqu&eacute; un scanner thoracique qui a r&eacute;v&egrave;l&eacute; un adenocarcinome pulmonaire bilat&eacute;rale &agrave; forme bronchiloalv&eacute;olaire avec mutations activatrices de l\'EGFR-TK.</p>\r\n<p>Elle est trait&eacute; depuis fin septembre 2012 par IRESSA 250mg 1cp/jour.</p>\r\n<p>Elle a pr&eacute;sent&eacute; des effets secondaires dermatologiques diffuses ecz&eacute;mateuses prurigineuses pris en charge en ville par Dr Tia Tiong Fat avec une efficacit&eacute;.</p>\r\n<p>&nbsp;Ce jour l\'examen clinique de Mme Delmont est sans grande particularit&eacute; si ce n\'est un ventre un peu ballonn&eacute;.</p>\r\n<p>le poids est &agrave; 68.8k pour une taille de 1m64 soit un IMC de 25.</p>\r\n<p>Mme DeLMONT a b&eacute;n&eacute;fici&eacute; d\'un Scanner thoracique le 25/09/2013.Il convient que Mme Delmont recup&egrave;re son ancien scanner au CHU de Bellepierre &agrave; des fins de comparaison.</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour a montr&eacute; une spirographie et une plethysmographie dans les limites de la normale.La TLCO est l&eacute;g&egrave;rement abaiss&eacute; &agrave; 72% de la norme.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(166,140,'2013-10-08','Dr DYALL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. DIJOUX Guy Remy n&eacute; le 05/04/1958.</p>\r\n<p>Comme vous le savez ce patient est trait&eacute; par corticoth&eacute;rapie &agrave; dose d&eacute;gressive pour une pneumopathie infiltrante diffuse en rapport avec une vraisemblable PINS (pneumopathie interstitielle non sp&eacute;cifique). Actuellement il est sous prednisone 10mg/j.</p>\r\n<p>Sa dyspn&eacute;e a compl&egrave;tement regress&eacute;;l\'auscultation est dans les limites de la normale. Le patient pr&eacute;sente des doigts de m&eacute;canicien avec des anticorps antiJo1 n&eacute;gatif.</p>\r\n<p>Les EFR pratiqu&eacute;s ce jour compar&eacute; &agrave; celles du 16/08/2013 montrent un TLCO passant de 6.64 soit 77% &agrave; 6.2 soit 71% ce jour.</p>\r\n<p>Le scanner du 08/08/2013 avait montr&eacute; une nette r&eacute;gression des images en verre d&eacute;poli .Le scanner thoracique du 03/10/2013 compar&eacute; &agrave; celui du 08/08/2013 a montr&eacute; une stabilit&eacute; des images.</p>\r\n<p>Dans ces conditions nous repratiquerons une EFR avec TLCO le 07/11/02013 avant de d&eacute;cider d\'arreter la corticoth&eacute;rapie.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(167,459,'2013-09-13','Dr Atlan-Dijoux','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. DOBARIA Jean S&eacute;bastian n&eacute; le 28/06/1988.</p>\r\n<p>Ce patient est trait&eacute; par XOLAIR pour un asthme s&eacute;v&egrave;re. Il va mieux depuis qu\'il est sous XOLAIR.</p>\r\n<p>Je lui ai renouvel&eacute; XOLAIR 375 mgX2 /mis en S/C pendant 3 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(168,471,'2013-09-13','Dr M.I.Bobate','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MALEK RASSOUL Fatma n&eacute;e le 25/09/1948.</p>\r\n<p>Cette dame presente un tabagisme passif mais n\'a jamais fum&eacute;.</p>\r\n<p>Elle est sans profession. Elle est mari&eacute; et a 5 enfants.</p>\r\n<p>Mme Malek a subi un triple pontage aorto-coronarien &agrave; Bichat en 1998, une appendicectomie.</p>\r\n<p>Elle est trait&eacute; pour HTA,DID,hypercholesterol&eacute;mie.</p>\r\n<p>Elle a &eacute;t&eacute; adress&eacute; par mes soins au centre de R&eacute;education fonctionelle de la Clinque St Clotilde avec le Dr Blanc.</p>\r\n<p>Elle avait des secretions bronchiques visqueuses difficile &agrave; expectorer.</p>\r\n<p>Elle va mieux actuellement mais se plaint d&nbsp;une dyspn&eacute;e grade 3de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je demande ce jour une radiographie pulmonire\'une NFS et un dosage d\'IgE totales.</p>\r\n<p>Je sous la place sous kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(169,462,'2013-09-13','Dr SATSOU\r\nDr FROTTIER\r\nPr D.BONNET','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour l\'enfant DUCHEMAN Nathan n&eacute; le 01/11/2007.</p>\r\n<p>Cet enfant pr&eacute;sente des ant&eacute;c&eacute;dents familiaux d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels on note des bronchites asthmatiformes avec infection bronchopulmonaire. Il a &eacute;t&eacute; hospitalis&eacute; une fois.</p>\r\n<p>Recemment, d&eacute;but ao&ucirc;t, le Dr Satsou, cardiologue, a eu le m&eacute;rite de lui diagnostiquer une CIA &agrave; sinus venosus.La maman &eacute;tant T&eacute;moin de J&eacute;hovah elle est &agrave; la recherche d\'une technique peu invasive pour limiter les risques de saignement.Le Dr Arsac a conseill&eacute; de maintenir l\'indication chirurgicale &agrave; Necker en juin 2014.Je demande donc &agrave; la famille de bien vouloir prendre contact directement avec le Pr Bonnet pour ce faire et obtenir la garantie de non utilisation de sang.</p>\r\n<p>Nous avons pratiqu&eacute; de EFR &agrave; cet enfant ce jour. La spirographie est dans les limites de la normale. La plethysmographie montre une distension pulmonaire avec VGT &agrave; 176%, CPT &agrave; 140% et VR &agrave; 181%de la norme.</p>\r\n<p>Les resistances des voies a&eacute;riennes sont augment&eacute;es 0.64.</p>\r\n<p>Je pr&eacute;conise la kin&eacute;sieth&eacute;rapie respiratoire associ&eacute; &agrave; la Ventoline et Flixotide 125.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(170,481,'2013-09-13','Dr Satsou\r\nDr Frottier\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Melle DUCHEMAN Naomi n&eacute;e le 02/07/2003.</p>\r\n<p>Cet enfant pr&eacute;sente un souffle au coeur et son p&egrave;re est asthmatique.</p>\r\n<p>Elle vous consultera pour une echocardiographie.</p>\r\n<p>Je lui ai pratiqu&eacute; des EFR.</p>\r\n<p>La spirographie est dans les limites de la normale.La plethysmographie montre des signes de distension pulmonaire avec un VR &agrave; 273 % de la norme CPT &agrave; 133% VGT &agrave; 166% de la norme. Le reste des examens est dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(171,253,'2013-09-16','Dr MAHE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BEGUE Milo n&eacute; le 16/03/1927.</p>\r\n<p>Ce patient est un ancien fumeur sevr&eacute; depuis 30 ans totalisant 36 PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un AVP en 1982 avec fracture du MIG.</p>\r\n<p>Il a &eacute;galement &eacute;t&eacute; soign&eacute; pour un UGD.</p>\r\n<p>Depuis ann&eacute;es il pr&eacute;sente une g&egrave;ne respiratoire.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Le TDM thoracique montre un emphyseme pulmonaire diffus bilat&eacute;rale.</p>\r\n<p>HCt est &agrave; 44.4%.</p>\r\n<p>La gazom&egrave;trie &agrave; AA retrouve : pH 7.42 pCO2 46Torr pO2 54Torr Sao 88%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold IV avec augmentation des resistances des voies a&eacute;riennes et trouble de la diffusion.</p>\r\n<p>Il convient de poursuivre le meme traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(172,37,'2013-09-16','Dr PILLAY','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ALPOU Firmin n&eacute; le 12/01/1944.</p>\r\n<p>Ce patient ancien gendarme est non fumeur mais buvait.Il est sevr&eacute; depuis 2006.</p>\r\n<p>Il est &agrave; la retraite depuis 17 ans.</p>\r\n<p>il a &eacute;t&eacute; op&eacute;r&eacute; de la hanche gauche en 01/2012 &agrave; la suite d\'une chute.</p>\r\n<p>Il aurait fait un AVC en 2011.</p>\r\n<p>Je l\'avais vu pour une toux incoercible qui a regress&eacute; sous traitement anti reflux.</p>\r\n<p>Le scanner thoracique du 24/01/2013 montre une fibrose pulmonaire peripherique non modifi&eacute; par rapport &agrave; aout 2012.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 4/5de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>La GDS &agrave; AA montre pH 7.44;pCO2:44Torr;pO2:104Torr;SaO2:98%.</p>\r\n<p>La NFS:Hb:12.5g/dl avec Hct:38.6%.</p>\r\n<p>Ses EFR sont en am&eacute;lioration par rapport au 24/07/2013.Le VEMS est pass&eacute; de 1.02 &agrave; 1.84 soit de 32 &agrave; 75% de la norme.Le Tiffeneau est &agrave; 100%.La distension pulmonaire s\'est &eacute;galement &nbsp;r&eacute;duite.Il existe un trouble ventilatoire restrictif avec CPT &agrave; 67% de la norme.</p>\r\n<p>Le meme traitement est &agrave; poursuivre en passant Onbrez &agrave; 300/j;Spiriva Respimat 2B/j;A&eacute;rosolttt (bricanyl-Atrovent)X3,Pulmicortx2 avec rin&ccedil;age et kin&eacute;siettt RespiratoireX5/sem.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(173,487,'2013-09-16','Dr OMARJEE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BADAT Houssen n&eacute; le 07/02/1957.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une tante at des cousines asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un traumatisme cranien en 1976.</p>\r\n<p>Il est allergique aux acariens aux pollens, latex avec asthme et ecz&egrave;ma de contact.</p>\r\n<p>Histoire de la maladie: Me Badat a d&eacute;clench&eacute; une bronchite avec frissons apr&egrave;s course &agrave;npied et une douche froide le 06/09/2013.</p>\r\n<p>Actuellement il pr&eacute;sente une grosse sinusite avec comblement complet du sinus frontal droit.</p>\r\n<p>L\'auscultation pulmonaire montre un freinage expiratoire avec des ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie pulmonaire est normale.</p>\r\n<p>Je conseille le traitement suivant :</p>\r\n<p>ELUDRIL gargarisme m et s pendant 10 jours</p>\r\n<p>A&eacute;rosolth&eacute;rapie PULMICORT X2 rincage de la bouche &agrave; l\'eau</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Bricanyl-AtroventX2/j</p>\r\n<p>RULID 150 m et s pdt 7 jrs.</p>\r\n<p>Atarax 25 mg le s.</p>\r\n<p>Kinesie th&eacute;rapie respiratoire 1 fois / jour.</p>\r\n<p>un panorex dentaire devra etre pratiqu&eacute; par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(174,482,'2013-09-16','Dr Chan Wai Nam','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CARPAYE Christian n&eacute; le 05/06/1938.</p>\r\n<p>Ce monsieur n\'a jamais fum&eacute; et il est mari&eacute; 4 enfants.</p>\r\n<p>Il exercait la profession de transporteur et a &eacute;t&eacute; soumis &agrave; une forte pollutiopn avec empoussi&egrave;re de 2002 &agrave; 2008 lors de la construction du boulevard Sud qui passait &agrave; 5 m&egrave;tres de sa maison.&nbsp;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne note rien de bien particulier.</p>\r\n<p>Histoire de la Maladie : Fin 2009 M. Carpaye a commenc&eacute; &agrave; avoir des troubles respiratoires qui se sont aggrav&egrave;es.</p>\r\n<p>Le patient a consult&eacute; le Dr Zadvat puis le Dr Paratian pour une pneumopathie infiltrante diffuse.</p>\r\n<p>Il a &eacute;t&eacute; bilant&eacute; au CHU f&eacute;lix Guyon et le diagnostic retenu &eacute;tait celui de PINS.</p>\r\n<p>Une corticoth&eacute;rapie a &eacute;t&eacute; pr&eacute;conis&eacute; mais le malade &eacute;tait au d&eacute;part r&eacute;ticient.</p>\r\n<p>Finalement une corticoth&eacute;rapie &agrave; r&eacute;gressive et demi dose a &eacute;t&eacute; mis enrote de mi janvier &agrave; mai 2013.</p>\r\n<p>Une am&eacute;lioration sensible a &eacute;t&eacute; not&eacute;.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2/3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique ne d&eacute;c&egrave;le pas d\'hippocratisme digital.L\'auscultation retrouve quelques rales velcro aux bases.</p>\r\n<p>L\'Hct est &agrave; 49.5%.</p>\r\n<p>Je redemande un scanner thoracique comparatif.</p>\r\n<p>Une EFR sera pratiqu&eacute; le 21/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(175,216,'2013-09-16','Pr Thierry CHINET\r\nPr Pascal LACOMBE\r\nService de Pneumologie\r\nHopital Ambroise Paré\r\n92104 Boulogne Cedex.','<p>Monsieur</p>\r\n<p>Je vous remercie d\'accueillir dans votre service Mme MOUNIAPIN Sabrina n&eacute;e le 06/09/1974.</p>\r\n<p>Cette patiente, qui a &eacute;t&eacute; hospitalis&eacute;e dans votre service en septembre 2009, pr&eacute;sente une maladie de Rendu-Osler avec de multiples malformations art&eacute;rioveineuses des deux champs pulmonaires &agrave; pr&eacute;dominance droite. Elle a b&eacute;n&eacute;fici&eacute; en septembre 2009 d\'une embolisation pulmonaire bilat&eacute;rale.</p>\r\n<p>Son &eacute;tat s\'est aggrav&eacute; depuis le d&eacute;but de l\'ann&eacute;e, et elle recommence &agrave; avoir des h&eacute;moptysies.&nbsp;Ses gaz du sang montrent un PH &agrave; 7.42, PCO2 44 TORR; PO2 47 TORR, CO2T 29, saturation 84%. L\'&eacute;preuve fonctionnelle respiratoire retrouve un trouble ventilatoire de nature mixte et s&eacute;v&egrave;re, avec VEMS &agrave; 32% de la norme. C\'est la raison pour laquelle cette patiente ne peut voyager qu\'avec accompagnement m&eacute;dical.</p>\r\n<p>Actuellement, Mme Mouniapin est sous oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e, et elle voyagera accompagn&eacute;e par le SAMU de la R&eacute;union. Elle ne connait personne &agrave; Paris, et quittera votre service pour rentrer &agrave; la R&eacute;union.</p>\r\n<p>En vous remerciant pour ce que vous ferez pour cette patiente, veuillez agr&eacute;er, Monsieur, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(177,329,'2013-09-30','Dr Lucien Bonne','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BAILLIF Odette n&eacute;e le 08/04/1970.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un p&egrave;re asthmatique,des neveux et ni&egrave;ces asthmatiques.</p>\r\n<p>Mme Baillif travaille dans la restauration .Elle est mari&eacute; et a un enfant.Dans ses ant&eacute;c&egrave;dents personnels on note une amygdalectomie.</p>\r\n<p>Histoire de la Maladie : Son asthme a d&eacute;but&eacute; dans l\'enfance. Elle a eu plusieurs hospitalisations, la derni&egrave;re en 2012 &agrave; st Benoit. Cette ann&eacute;e elle a eu 2 crises d\'asthme. Elle est trait&eacute;e que par Ventoline.Lors de la consultation du 30/08/2013 son asthme &eacute;tait compl&egrave;tement non &eacute;quilibr&eacute; avec rhinite allergique et nez bouch&eacute;.</p>\r\n<p>A l\'auscultation ce jour on note la disparition des sibilances.les IgE totales sont &agrave; 194UI/ml; les RAST montrent une allergie aux acariens : Blomia tropicalis, D. pteronyssinus, D. farinae(classe 2 et 3). Pas d\'allergie aux trophallerg&egrave;nes.</p>\r\n<p>Mme BAILLIF pr&eacute;sente un score d\'Epworth &agrave; 8/18 avec un endormissement diurne et 2nyctiuries.on pr&eacute;voit une polygraphie nocturne le 10/12/2013 &agrave; 16:00.Mme Baillif aura un agenda de sommeil &agrave; remplir.Sa&nbsp;Radiographie pulmonaire est normale.</p>\r\n<p>Poursuivre le meme traitement Foradil-miflonil et Singulair.</p>\r\n<p>L\'EFR retrouve ce jour(30/09/2013) untrouble ventilatoire obstructif GOLD II avec un VEMS &agrave; 1.39 soit 53% de la norme &nbsp;r&eacute;versible sous b2mimetiques passant &agrave; 1.55 soit 12%d\'am&eacute;lioration,le Tiffeneau est &agrave; 67% et il existe une distension pulmonaire moder&eacute;e avec VGT &agrave; 115%.La TLCO est &agrave; 69% de la &nbsp;norme .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(178,429,'2013-10-08','Dr Jean Jacques BRUNET\r\n','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SAGOUBY Guylene n&eacute;e le 15/02/1963.</p>\r\n<p>Cette dame mari&eacute;e, 4 enfants est sans profession. Elle est non fumeuse;</p>\r\n<p>Elle pr&eacute;sente un poids de 135 kilos pour une taille de 1m61 avec un IMC de 52.1 ce qui correspond &agrave; une ob&eacute;sit&eacute; morbide.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DID, une HTA , elle est donc porteuse d\'un syndrome metabolique.</p>\r\n<p>Son p&eacute;rimetre cervical est de 48cm et son perim&egrave;tre abdominal est de 154cm.</p>\r\n<p>Son Score d\'Epworth est de 5/21. Son score de Mallampati est 3/4.</p>\r\n<p>Actuellement cette dame est appareill&eacute; par VNI et OLD par ISIS R&eacute;union pour syndrome d\'ob&eacute;sit&eacute; hypoventilation depuis le mois de mars 2012.</p>\r\n<p>Son &eacute;tat s\'est amelior&eacute; depuis son appareillage et elle est plus &eacute;veill&eacute;. Elle pr&eacute;sente n&eacute;anmoins 2 nyctiuries.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve quelques ronchi aux bases avec discrets oed&egrave;mes mall&eacute;olaires.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif avec CPT &agrave; 63% VR &agrave; 64% .Le VEMS est &agrave; 1.54 soit 61% avec un Tiffeneau &agrave; 86% de la norme.La TLCO est &agrave; 75%.</p>\r\n<p>J\'augmente l\'Onbrez &agrave; 300/j &nbsp;et kin&eacute;sie respiratoire avec VNI et OLD</p>\r\n<p>La Gazom&egrave;trie &agrave; AA montre:pH 7.46 pO2 82 Torr pCO2 43 Torr SaO2 96%;Hct &agrave; 36%.</p>\r\n<p>La radiographie thoracique montre une augmentation de volume de la silhouette cardiovasculaire avec redistribution vasculaire vers les sommets.L\' echocardiographie montre une HVG avec FEVG &agrave; 54% discr&egrave;tement alt&eacute;r&eacute;e avec PAP Normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(179,489,'2013-09-16','Dr Andriantavy\r\nMedecin Consultation de memoire','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MARQUET Jean Claude n&eacute; le 07/03/1940.</p>\r\n<p>Ce patient a eu 2 resections endoscopiques de la prostate pour adenome.</p>\r\n<p>Il est deprim&eacute; et a &eacute;t&eacute; mis sous PROZAC par le Dr Hatteea.</p>\r\n<p>Ce jour TA 13/9 et auscultation pulmonaire normale.</p>\r\n<p>Son scanner c&eacute;r&eacute;bral a montr&eacute; une sinusite chronique avec dilatation ventriculaire et atrophie cortico sous corticale diffuse pr&eacute;dominant dans la r&eacute;gion amygdalo-hippocampique.</p>\r\n<p>je vous serai reconaissant de lui pratiquer un examen de memoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(180,472,'2013-09-17','Dr Behary-Le Bihan','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. HOARAU Antoine n&eacute; le 07/08/1937.</p>\r\n<p>le formulaire du PET-Scan a &eacute;t&eacute; d&eacute;pos&eacute; en m&eacute;decine nucl&eacute;aire et le malade sera convoqu&eacute; directement par le CHU F&eacute;lix Guyon.</p>\r\n<p>Il moins dyspn&eacute;ique depuis qu\'il est sous traitement.l\'EFR du 26/09 nous en renseignera davantage.</p>\r\n<p>L\'auscultation de ce jour est tr&egrave;s satisfaisant et il convient de poursuivre le meme traitement;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Consoeur, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(181,492,'2013-09-17','Dr Taochy','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PAYET Rose Hermina n&eacute;e le 24/10/1929.</p>\r\n<p>Cette dame non fumeuse, ex agricultrice.</p>\r\n<p>Elle est veuve et a 9 enfants.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents on note une cholecystectomie et intervention pour occlusion intestinale. Elle a &eacute;galement &eacute;t&eacute; op&eacute;r&eacute;e d\'un entropion de l\'oeil gauche.</p>\r\n<p>Elle est trait&eacute; pour HTA et DNID ainsi que pour arthrose des genoux, hanches et la r&eacute;gion lombaire et cervicale.</p>\r\n<p>Mme Payet est appareill&eacute;e pour syndrome d\'apn&eacute;es du sommeil par la soci&eacute;t&eacute; ISIS M&eacute;dical.</p>\r\n<p>Elle est moins somnolente ; l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>La radiographie thopracique retrouve une augmentation de volume de la silhouette cardiovasculaire avec d&eacute;roulement aortique et des signes de distension thoracique et aplatissement des coupoles diaphragmatiques.</p>\r\n<p>L\'echocoeur pratiqu&eacute; le 14/06/2013 par le Dr Joret montre une bonne fonction VG avec un FEVG &agrave; 70%.Il existe&nbsp;</p>\r\n<p>une HVG mod&eacute;r&eacute;e avec une HTAP mod&eacute;r&eacute;e.</p>\r\n<p>Mme Payet avait arret&eacute; son traitement par PPC en raison de son entropion .Il convient qu\'elle reprenne son traitement par PPC.elle poursuivra &eacute;galement Miflonil4001X2 avec rincage,onbrez 300 1B/J ;associ&eacute; &agrave; Kin&eacute;siett respiratoire 4 jours / semaine.</p>\r\n<p>Je la reverrai le 29/10/2013 pour des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(182,454,'2013-09-17','Medecin traitant','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme REBECCA Marie Chantal n&eacute;e le 05/12/1963.</p>\r\n<p>Malgr&eacute; le traitement par FORADIL et MIFLONIL elle est toujours g&eacute;n&eacute; pour respirer le soir.elle pr&eacute;sente surtout une toux et a eu des vomissements hier soir.</p>\r\n<p>Mise sous Inexium 40 1cp/j et Gaviscon 1X3</p>'),(183,494,'2013-09-17','Dr Vienne','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CAMATCHY Yves n&eacute; le 09/04/1942.</p>\r\n<p>Ce monsieur divorc&eacute; a 8 enfants.Il exercait la profession d\'ouvrier agricole et est &agrave; la retraite.</p>\r\n<p>Il fumait 2 paquets /jour depuis l\'age de 15 ans;il est sevr&eacute; depuis l\'age de 50 ans et totalise plus de 60PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note essentiellement une BPCO post tabagique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3/4 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>La SaO2 est &agrave; 84% et le pouls &agrave; 124.</p>\r\n<p>Je demande ce jour un scanner thoracique sans injection le 17/10/2013 &agrave; 8:00,une NFS-Plqt avec GDS &agrave; AA.</p>\r\n<p>Sur &nbsp;le plan th&eacute;rapeutique il convient de poursuivre:</p>\r\n<p>VNI,OLD,kin&eacute;sieth&eacute;rapie respiratoire 3X/semaine ;Onbrez 300/j;Miflonil 400X2 avec rincage et Spiriva Respimat X2 et a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X2/J.</p>\r\n<p>je le reverrai le 29/10/2013 pour des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(184,96,'2013-09-17','Dr. Dufay','<p>Cher Consoeur,</p>\r\n<p>J\'ai vu en consultation&nbsp;Mme ROBERT Marie Monique n&eacute;e le 23/06/1946. Cette dame &eacute;tait en cours de r&eacute;habilitation respiratoire au Centre de R&eacute;&eacute;ducation de Sainte-Clotilde.</p>\r\n<p>On note dans ses ant&eacute;c&eacute;dents, un&nbsp;pontage aorto coronarien. Elle a par ailleurs subi, le 1er mai 2012, une&nbsp;lobectomie inferieure gauche pour une&nbsp;mati&egrave;re synth&eacute;tique laiss&eacute;e en place. Mme ROBERT est par ailleurs trait&eacute;e par PPC pour Syndr&ocirc;me d\'Apn&eacute;e du Sommeil. J\'ai demand&eacute; au cours de ma consultation un bilan radiologique et biologique et je la reverrai le 2 octobre 2013 pour des &eacute;preuves fonctionnelles respiratoires.</p>\r\n<p>Je vous ferai un compte rendu plus d&eacute;taill&eacute; et circonstanci&eacute; &agrave; ce moment.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Consoeur, l\'assurance des mes homages,</p>\r\n<p>Dr. B. TANGUY</p>'),(185,485,'2013-09-17','Dr I.PATEL','<p>Cher ami</p>\r\n<p>J\'ai vu ce jour M. SAUTRON andre n&eacute; le 18/08/1926.</p>\r\n<p>Ce monsieur est un ancien fumeur 10 cigarettes/j sevr&eacute; en 1980,totalisant environ 20PA.</p>\r\n<p>Il travaillait dans le bitume sur les routes.</p>\r\n<p>M.Sautron est veuf et a 7 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une op&eacute;ration pour hernie inguinale gauche en 1969.</p>\r\n<p>Depuis 1986 il se plaint de troubles respiratoires.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ce jour la SaO2 est &agrave; 96% avec un pouls &agrave; 100.</p>\r\n<p>L\'auscultation note des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je demande une radiographie pulmonaire avec une NFS/CRP et une GDS &agrave; AA.</p>\r\n<p>Je le reverrai pour des &nbsp;EFR le 14/10/2013.</p>\r\n<p>Cher ami</p>\r\n<p>&nbsp;M. SAUTRON andre n&eacute; le 18/08/1926 a eu ce jour des EFR.Cet examen montre un trouble ventilatoire mixte &agrave; pr&eacute;dominance obstructive.Le VEMS est &agrave; 0.54 soit 32% de la norme avec un Tiffeneau &agrave; 59%.Le patient est donc Gold III s&eacute;v&egrave;re non r&eacute;versible sous b2 inhal&eacute;s.La CPT est &agrave; 67% de la norme avec augmentation de la resistances des voies a&eacute;riennes RVA &agrave; 1.14 sans trouble du transfert.</p>\r\n<p>Sur le plan biologique ,l\'Hct est &agrave; 42.2% et les GDS retrouvent:pH:7.46 pCO2 40 Torr pO2 :81 Torr SaO2 96%.La CRP est &agrave; 4 mg/l.</p>\r\n<p>La radiographie thoracique retrouve une augmentation de volume de la silhouette cardiovasculaire avec d&eacute;roulement de la ligne paraaortique gauche et des grosses art&egrave;res pulmonaires.</p>\r\n<p>Je pense qu\'un suivi cardiologique s\'impose pour ce patient.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Il est trait&eacute; en ce moment &nbsp;par OLD,A&eacute;rosolth&eacute;rapie Bricanyl-atroventX2,seretide 1BX2</p>\r\n<p>auquel je rajoute la kin&eacute;sieth&eacute;rapie respiratoire X3 /semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(186,497,'2013-09-17','Dr GERARD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BOUHASSOUN Nasser n&eacute; le 27/12/1986.</p>\r\n<p>Ce monsieur sportif:course &agrave; pied et marche est fumeur 7 &agrave; 8 cigarettes par jour.</p>\r\n<p>Il est infirmier aux Soins intensifs de neurologie.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie,hernie inguinale droite.</p>\r\n<p>Il est consulter pour un certificat d\'escalade &agrave; la Possession.</p>\r\n<p>L\'examen clinique retrouve une scoliose avec lordose.</p>\r\n<p>Une radiographie de la colonne thoracique et lombaire est prescrite ainsi que des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(187,497,'2013-09-17','','<p>Je soussign&eacute; Docteur Bernard TANGUY,Pneumologue Agr&eacute;e, certifie avoir examin&eacute; ce jour&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>M.BOUHASSOUN Nasser n&eacute; le 27/12/1986.</p>\r\n<p>&nbsp;</p>\r\n<p>Il ne pr&eacute;sente pas de contreindication &agrave; la pratique de l\'escalade.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; Saint Denis le 17/09/2013 et remis &agrave; l\'interss&eacute; en main propre pour servir et valoir ce que de droit.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Docteur Bernard TANGUY.</p>'),(188,498,'2013-09-17','Dr VINCENT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. HOARAU Joseph n&eacute; le 11/07/1933.</p>\r\n<p>Ce monsieur est mari&eacute; un enfant ,non fumeur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une thoracoplastie du sommet droit pendant son service militaire.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; pour une n&eacute;vralgie faciale gauche&nbsp;</p>\r\n<p>Actuellement il est trait&eacute; pour une probable tumeur prostatique &agrave; St Pierre avec cimentoplastie dans la colonne vert&eacute;brale.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade4 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Il a perdu 6 kilos passant de 70 &agrave; 64 kilos.</p>\r\n<p>La Sao2 est &agrave; 95% et le pouls &agrave; 72.</p>\r\n<p>l\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je demande une radiographie pulmonaire.</p>\r\n<p>Je lui prescrit Onbrez 300 microg /j associ&eacute; &agrave; Spiriva Respimat 2B/j et A&eacute;rosolth&eacute;rapie Bricanyl-Atrovent x2/j avec la Soci&eacute;t&eacute; ISIS. ceci associ&eacute; &agrave; kin&eacute;sieth&eacute;rapie respiratoire et de mobilisation X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(189,262,'2013-09-17','Dr Razakasoa','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. FIGARO Bruno n&eacute; le 06/10/1949.</p>\r\n<p>Ce patient ancien fumeur 7 cigarettes /j est sevr&eacute; depuis &nbsp;1988.il &nbsp;est un ancien marin.</p>\r\n<p>Il est mari&eacute; et a 3 enfants.</p>\r\n<p>Il n\'a pas d\'ant&eacute;c&egrave;dents familiaux d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note des interventions pour calculs urinaires.</p>\r\n<p>Il est trait&eacute; pour DID,HTA,triglycerid&eacute;mie.</p>\r\n<p>&nbsp;Il a &eacute;t&eacute; hospitalis&eacute; pour probl&egrave;mes respiratoires cette ann&eacute;e.</p>\r\n<p>M.Figaro pr&eacute;sente un poids de 97kilos pour une taille de 171 cm avec un IMC de 33.2, ce qui correspond &agrave; une obesit&eacute; moder&eacute;e.Son perimetre cervical est &agrave; 46 cm et le perim&egrave;tre abdominal &agrave; 115cm.</p>\r\n<p>Le Score d\'Epworth est &agrave; 14/18 et&nbsp;le score de Mallampati est de 3 /4.</p>\r\n<p>Sa femme a not&eacute; des ronflements.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade2 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'EFR pratiqu&eacute; le 29/07/2013 retrouvait une diminution mod&eacute;r&eacute;e de la VGT &agrave; 58% de la norme avec trouble mod&eacute;r&eacute;e de la diffusion:TLCO &agrave; 70% de la norme.La spirom&eacute;trie &eacute;tant dans les limites de lanormale.</p>\r\n<p>M.Figaro aura une polygraphie nocturne le 17/02/2014.</p>\r\n<p>Il est trait&eacute; actuellement par Seretide 250 1B m et s.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(190,484,'2013-10-04','Dr Wan-Hoi\r\nORL\r\nDr Jaglale','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour Melle CANAGUY Najlaa n&eacute;e le 31/07/1987.</p>\r\n<p>Cette jeune femme est c&eacute;libataire sans enfant.</p>\r\n<p>Elle travaille dans un cabinet de comptabilit&eacute;.</p>\r\n<p>Elle est non fumeuse.</p>\r\n<p>Elle n\'a pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels elle a &eacute;t&eacute; hospitalis&eacute; dans la tendre enfance &agrave; la Clinique Ste Clotilde pour un saignement du nombril. Elle a &eacute;t&eacute; platr&eacute; pour une fracture du bras gauche &agrave; l\'age de 5 ans.</p>\r\n<p>Histoire de la Maladie:Melle Canaguy se plaint d\'une toux depuis janvier 2013.</p>\r\n<p>L\'examen ORL ne r&eacute;v&egrave;le pas de foyer infectieux ou irritatif.</p>\r\n<p>Cette toux est survenu &agrave; la suite d\'une infection qui a demarr&eacute; &agrave; la suite d\'un voyage de retour en Inde.</p>\r\n<p>&nbsp;L\'interrogatoire retrouve la notion d\'un reflux gastro oesophagien qui a &eacute;t&eacute; trait&eacute;.</p>\r\n<p>Melle Canaguy me dit avoir eu un scanner thoracique qui &eacute;tait normale.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>L\'EFR pratiqu&eacute;e ce jour retrouve un VEMS &agrave; 2.45 soit 80% de la norme non am&eacute;lior&eacute; sous b2inhal&eacute;s avec un Tiffeneau &agrave; 99% de la norme.Il existe une distension pulmonaire avec VGT &agrave; 117% VR &agrave; 125%. Par ailleurs on note un &nbsp;trouble de la diffusion avec TLCO &agrave; 66%.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire et je la reverrai la semaine prochaine en consultation.</p>\r\n<p>Je la place en attendant sous FORADIL et MIFLONIL.Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(191,495,'2013-09-17','Dr KAH','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour l\'Enfant COMBRESSAMY Ellya n&eacute;e le 06/07/2009.</p>\r\n<p>Son p&egrave;re est asthmatique et son fr&egrave;re a pr&eacute;sent&eacute; des crises d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on ne retrouve rien d\'autre.</p>\r\n<p>Sa premi&egrave;re crise d\'astme retrouve il y a un an soit &agrave; l\'age de 3 ans.</p>\r\n<p>Actuellement elle est g&eacute;n&eacute;e tous les 2 &agrave; 3 mois. Derni&egrave;re grosse crise au mois de mai 2013 n&eacute;cessitant un traitement par Ventoline et flixotide.</p>\r\n<p>Cette enfant pr&eacute;sente une rhinite allergique ;l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je demande &nbsp;une radiographie des sinus maxillaires ainsi qu\'une NFS,et des RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>&nbsp;Je prescrit ce jour:Singulair 1 sac. de 4mg le s au coucher;Collu-hextril 1 pulv:m et s ;flixotide 125 mg m et savec rin&ccedil;age &agrave; l\'aide d\'une chambre d\'inhalation;et si g&egrave;ne respiratoire:Ventoline 1 &agrave; 2 B/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(192,501,'2013-10-08','Dr Patrice HUMBERT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PICARDO Louisette suzanne n&eacute;e le 30/08/1930.</p>\r\n<p>Elle ne m\'a pas apport&eacute; ses r&eacute;sultats biologiques ni sa radiographie pulmonaire.</p>\r\n<p>Mme PICARDO a &eacute;t&eacute; tr&egrave;s amelior&eacute; par le traitement et ce jour son auscultation pulmonaire est redevenue normale.</p>\r\n<p>Il convient &nbsp;de poursuivre une Kin&eacute;sieth&eacute;rapie respiratoire associ&eacute; &agrave; l\'a&eacute;rosolth&eacute;rapie:Bricanyl-Atrovent)X4/j et Pulmicort)X2 avec rincage de la bouche .</p>\r\n<p>Je le reverrai pour des EFR le 31/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(193,480,'2013-09-19','Dr I.PATEL\r\nDr CHUONG Cardiologue.','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOYER celiane Marie n&eacute;e le 05/04/1938.</p>\r\n<p>Cette dame veuve n\'a jamais fum&eacute;.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention en 2009 pour arterite des M.I ainsi qu\'une c&eacute;sarienne.</p>\r\n<p>Elle est trait&eacute; pour &nbsp;HTA et a eu une angioplastie coronarienne en 2009 avec stent.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute; au CHU de Bellepierre en novembre 2012 et a &eacute;t&eacute; mise sous OLD par la Soci&eacute;t&eacute; ISIS M&eacute;dical.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e gradeIV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Ce jour SaO2&agrave; 93% et pouls &agrave; 75.Mme boyer pr&eacute;sente au moins 5 nyctiuries.</p>\r\n<p>l\'examen clinique retrouve de discrets oed&egrave;mes des MI avec un ventre ballonn&eacute;.</p>\r\n<p>L\'auscultation retrouve un assoudissement des bruits pulmonaires sthetacoustiques.</p>\r\n<p>Le score de Mallampati est de 3/4.Le score d\'Epworth est &agrave; 9/15.</p>\r\n<p>&nbsp;Je demande ce jour une radiographie pulmonaire ainsi qu\'une GDS &agrave; AA.</p>\r\n<p>Elle est trait&eacute; actuellement par SPIRIVA,Onbrez que l\'on peut passer &agrave; raison de 300microg/j et Miflonil.Son traitement sera readapt&eacute; en fonction de des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(194,503,'2013-09-19','Dr Maigrat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme HOARAU Marie Sylvette n&eacute;e le 21/09/1968.</p>\r\n<p>Cette dame vit en concubinage et a 1 enfant.</p>\r\n<p>Elle est sans profession.</p>\r\n<p>Elle a eu une c&eacute;sarienne en 1990.</p>\r\n<p>Elle mesure 1.61m et p&egrave;se 68.500Kg.Elle a pris 4 kilos en 1 ann&eacute;e.</p>\r\n<p>Elle pr&eacute;sente un ronflement g&eacute;nant pour son entourage avec des pauses pendant le sommeil.</p>\r\n<p>Son sommeil n\'est pas r&eacute;parateur et elle prend du LYSANSIA pour dormir jusqu\'a 2 cp.Elle pr&eacute;sente une insomnie chronique.Nous allons lui faire remplir un calendrier de sommeil.</p>\r\n<p>Son score d\'Epworth est &agrave; 17/21.</p>\r\n<p>Le score de Mallampati est de 3 /4.</p>\r\n<p>L\'examen clinique retrouve un reflux gastro oesophagien &agrave; traiter par Inexium 40 mgX2 et Gaviscon 1x3 pendant 3 mois.</p>\r\n<p>Mme Hoarau aura une EFR le 23/10 et une polygraphie nocturne le 28/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(195,430,'2013-09-19','Dr Van Hoote','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOYER Marie Anise n&eacute;e le 13/06/1966.</p>\r\n<p>La radiographie pulmonaire du 18/09/2013 montre un poumon d&eacute;truit gauche en quasi-totalit&eacute;.</p>\r\n<p>Je vais recup&eacute;rer avec le Dr Mascarel le scanner thoracique qu\'elle aurait eu cette ann&eacute;e.</p>\r\n<p>La NFS ne retrouve pas d\'hyperleucocytose nin de polynucl&eacute;ose neutrophile.La CRP est &agrave; 0.8mg/l.</p>\r\n<p>L\'ECBC montre &agrave; la culture une atteinte polymicrobienne avec contamination par une flore commensale.</p>\r\n<p>Actuellement elle est reveill&eacute;e 3 &agrave; 4 fois la nuit avec une sensation d\'oppression thoracique et de nez bouch&eacute;.</p>\r\n<p>je rajoute au traitement de l\'ELUDRIL gargarisme m et s ;Onbrez 150 microg/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(196,42,'2013-10-10','Dr VIRAPOULLE\r\nDr LOLLJEE\r\nDr Serveaux \r\nService de Neurologie\r\nCHU de BellePierre','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme NAGOU Christiane n&eacute;e le 03/04/1935.</p>\r\n<p>Cette dame est veuve et &nbsp;a 4 enfants.</p>\r\n<p>Elle est non fumeuse .Elle a &eacute;t&eacute; op&eacute;r&eacute;e d\'un fibrome ut&eacute;rin.</p>\r\n<p>Elle est trait&eacute; pour HTA,arthrose diffus et &nbsp;elle est aussi suivie sur le plan cardiaque.Elle pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Research Council.Elle pr&eacute;sente un trembement intentionnel qui la g&egrave;ne beaucoup.Je conseille une consultation neurologique.Son poids est de 70 kilos pour une taille de 160cm .L\'IMC est de 27.3 ce qui correspond &agrave; un surpoids..Sa SaO2 est &agrave; 94% &agrave; AA avec un pouls de 95;elle pr&eacute;sente un ronflement avec 2 nyctiuries.</p>\r\n<p>L\'examen clinique r&eacute;v&egrave;le un discret oed&egrave;me des M.I.L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires stethacoustiques.Le ventre est ballonn&eacute;.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique avec aplatissement des coupoles diaphragmatiques.Par ailleurs on note des grosses art&egrave;res pulmonaires avec augmentation de volume de la silhouette cardio vasculaire.</p>\r\n<p>L\'EFR r&eacute;v&egrave;le un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec un VEMS &agrave; 0.76 soit 43% de la norme.Il existe par ailleurs une distension pulmonaire avec VGT &agrave; 5.01,soit 189% de la norme.La GDS &agrave; AA montre:pH 7.44 pO2 69Torr pCO2 46Torr SaO2 93%.</p>\r\n<p>Mme Nagou pr&eacute;sente donc une BPCO post cuisson de feu de bois.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre:VNI,OLD,Kin&eacute;sieth&eacute;rapie respiratoire,Onbrez &agrave; passer &agrave; 300microg/jSpiriva Respimat 2B/J et Ventoline en cas de besoin.Elle recourt 10 fois /j &agrave; la Ventoline.Je vais rajoputer de l\'Alvesco 160microg/j &agrave; l\'aide d\'une chambre d\'inhalation AeroChamber avec rin&ccedil;age de la bouche par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(197,467,'2013-09-19','Dr CHABAS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GAMALEYA Erika n&eacute;e le 02/06/1980.</p>\r\n<p>Cette dame a 3 enfants,elle est sans profession.</p>\r\n<p>Elle fume 15cigarettes/jour.Ses tentatives de sevrage tabagique se sont r&eacute;v&egrave;l&eacute;s infructueuses.</p>\r\n<p>Elle a commenc&eacute; &agrave; fumer &agrave; l\'age de 15 ans et fume reguli&egrave;rement depuis 10 ans.</p>\r\n<p>&nbsp;Elle a &eacute;t&eacute; op&eacute;r&eacute;e de kystes ovarien gauche.Elle pr&eacute;sente une menopause pr&eacute;coce.</p>\r\n<p>Elle a &eacute;t&eacute; trait&eacute; pour tuberculose pulmonaire en septembre 2000.Elle a eu 6 &agrave; 9 &nbsp;mois de traitement antituberculeux.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>La radiographie thoracique ne r&eacute;v&egrave;le pas de signe de rechute mais on note un aplatissement des coupoles diaphragmatiques.</p>\r\n<p>Je reverrai Mme Gamaleya le 05/11/2013 pour des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(198,261,'2013-09-19','Dr THILL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LEPERRE JOSEPH ANTOINE n&eacute; le 04/01/1927.</p>\r\n<p>Ce monsieur est mari&eacute; 3 enfants.</p>\r\n<p>Il a fum&eacute; 6 cigarettes par jour et a &eacute;t&eacute; sevr&eacute; il y a 40 ans.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention sur la vessie &agrave; la Clinique Ste Clotilde.</p>\r\n<p>Lors de son service militaire en 1945 il a pr&eacute;sent&eacute; une pleur&eacute;sie gauche probablement d\'origine tuberculeuse.Il en a gard&eacute; des s&eacute;quelles &agrave; titre de pachypleurite gauche.Il a ensuite &eacute;t&eacute; trait&eacute; pour tuberculose pulmonaire par le &nbsp;Dr Desnanot &agrave; la R&eacute;union.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Son sommeil s\'est am&eacute;lior&eacute;.</p>\r\n<p>L\'auscultation retrouve des ronchi dans les deux champs pulmonaires.Il existe des oed&egrave;mes des M.I.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique avecaplatissement des coupoles diaphragmatiques et des signes de s&eacute;quelles pleurales gauches.</p>\r\n<p>Son Hct est &agrave; 46% avec des GDS &agrave; AA :pH7.39 pCo2 48 Torr pO2 61 Torr SaO2 95%.</p>\r\n<p>M.Leperre m\'apportera le r&eacute;sultats de son echocardiaque.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre:</p>\r\n<p>OLD 2L/mn;A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/j,PulmicortX2/j;Onbrez 300 1B/j Kin&eacute;sieth&eacute;rapie respiratoire 1X/J et Ventoline en cas de g&egrave;ne respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(199,506,'2013-09-19','Dr Wan Hoi\r\nDr Colette MOREL','<p>Cher ami</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour avis M. LAW YEN Laurent, n&eacute; le 04/01/1982.</p>\r\n<p>Ce monsieur est c&eacute;libataire sans enfant,employ&eacute; de commerce.</p>\r\n<p>Il est non fumeur.</p>\r\n<p>Il est n&eacute; prematur&eacute; &agrave; 6 mois et a &eacute;t&eacute; trach&eacute;otomis&eacute; en metropole.Il a eu une st&eacute;nose laryng&eacute; s&eacute;quellaire.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; par laser au niveau du larynx et a subi une laryngoplastie, toujours en metropole.</p>\r\n<p>En 2012 il a &eacute;t&eacute; retracheotomis&eacute; au Centre Hospitalier Georges Pompidou &agrave; Paris.</p>\r\n<p>Actuellement il a une paralysie d\'une corde vocale.</p>\r\n<p>Son sommeil est de mauvaise qualit&eacute; et non r&eacute;parateur.</p>\r\n<p>Il a des cephal&eacute;es dans la journ&eacute;e.</p>\r\n<p>L\'auscultation retrouve des ronchi dans les 2 champs pulmonaires.</p>\r\n<p>Le Score d\'Epworth est &agrave; 11/18.</p>\r\n<p>M.LAW YEN a d&eacute;ja eu une polygraphie nocturne avec le DrGazaille avant la trach&eacute;otomie.</p>\r\n<p>Il veut obtenir une polysomnographie.Nous lui donnons un rendez vous le 31/10/2103 &agrave; 16:00.</p>\r\n<p>Avec mes remerciements, veuillsz agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(200,508,'2013-09-20','Dr Ramilison\r\nDr Moshinaly','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BEOLET Daniele n&eacute;e le 23/06/1948.</p>\r\n<p>Cette dame est non fumeuse et sans profession.</p>\r\n<p>Elle est mari&eacute; et a 4 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,une ptose de ut&eacute;rus.</p>\r\n<p>Elle a eu un accident coronarien en 2008 avec une angioplastie coronarienne et pose de stent.Elle &eacute;tait trait&eacute;e pour HTA.Elle souffre aussi d\'hyothroidie et prend du LEVOTHYROX.Par ailleurs Mme BEOLET est suivie pour gonarthrose et sciatique gauche.Elle prend de l\'AVLOCARDYL &nbsp;qui est un b-bloquant.</p>\r\n<p>Elle ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dents familial d\'asthme.</p>\r\n<p>Elle a d&amp;&eacute;but&eacute; en asthme il y a 2 ans ayant commenc&eacute; par une bronchite.</p>\r\n<p>Elle est trait&eacute; par FORADIL et MIFLONIL.A la R&eacute;union son asthme est bien &eacute;quilibr&eacute; mais pas lors d\'un r&eacute;cent s&eacute;jour en metropole.</p>\r\n<p>L\'auscultation retrouve ce jour un freinage expiratoire.</p>\r\n<p>son Score d\'Epworth est &agrave; 9/15.</p>\r\n<p>Elle pr&eacute;sente un ronflement.Mme Beolet s\'es appercue qu\'elle fait des pauses respiratoires.</p>\r\n<p>Elle pr&eacute;sente 3 nyctuiries.</p>\r\n<p>Le score de Mallampati est de 3 /4.Son perimetre cervical est &agrave; 37cm;son perimetre abdominal est &agrave; 110cm.</p>\r\n<p>mme Beolet sera revu le 31/10/2013 pour des EFR et le 03/12/2013 pour une consultation.</p>\r\n<p>elle attendant poursuite du meme traitement FORADIL 1 gel inhal&eacute; m et s et MIFLONIL 400 1 gel inhale m et s avec rincage de la bouche;</p>\r\n<p>Voir avec le Dr Moshinaly s\'il est possible de remplacer l\'Avocardyl.Une polygraphie nocturne lui sera propos&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(201,509,'2013-09-20','Dr Ramilison','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BEOLET Andre Claude n&eacute; le 19/07/1939.</p>\r\n<p>Ce patient est un ancien fumeur ,environ 10PA.Il s\'agit d\'un ancien electricien &agrave; la retraite.</p>\r\n<p>M.Beolet a &eacute;t&eacute; op&eacute;r&eacute; d\'une resection endoscopique de la prostate en 2009.</p>\r\n<p>Il a aussi eu une angioplastie coronarienne avec stent en 2008.</p>\r\n<p>Dans son enfance il a&eacute;t&eacute; trait&eacute; pour asthme.</p>\r\n<p>L\'auscultation pulmonaire est ce jour normale.</p>\r\n<p>M.Beolet aura une EFR le 31/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(202,29,'2013-09-20','Dr LEBIHAN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme SERY Rosemay n&eacute;e le 23/10/1961.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note 3 c&eacute;sariennes;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on retrouve &nbsp;1 fr&egrave;re et 1 soeur asthmatique;</p>\r\n<p>Ses manifestations allergiques ont commenc&eacute; dans la r&eacute;gion Parisienne quant elle travaillait dans une blanchisserie.</p>\r\n<p>Sa premi&egrave;re grosse crise d\'asthme a debut&eacute; en 1995 dans la r&eacute;gion toulousaine.</p>\r\n<p>Actuellemnt elle pr&eacute;sente un asthme difficile &agrave; traiter malgr&eacute; XOLAIR.Elle a &eacute;t&eacute; hospitalis&eacute; &agrave; plusieurs reprises pour exacerbation asthmatique.Mme Sery est en outre trait&eacute; pour une insuffisance surrenalienne corticoinduite.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IVde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>Le score de Mallampati est de 3 /4.</p>\r\n<p>Son Score d\'Epworth est &agrave; 10/24.</p>\r\n<p>Elle pr&eacute;sente un ronflement avec des pauses respiratoires dans son sommeil.</p>\r\n<p>Le perimetre cervical est &agrave; 37cm;avec un perimetre abdominal &agrave;, 106 cm.</p>\r\n<p>Son IMC est &agrave; 32,ce qui correspond &agrave; une obesit&eacute; mod&eacute;r&eacute;.</p>\r\n<p>Une polygraphie nocturne a &eacute;t&eacute; pratiqu&eacute; le 07/08/2013 et retrouve un IAH &agrave; 26/H de sommeil.La patiente a &eacute;t&eacute; mise sous PPC en mode autopilot&eacute;e.</p>\r\n<p>Nous poursuivons son traitement actuel:</p>\r\n<p>XOLAIR 300mg/mois;Hydrocortisone 20mg le m + 10mg si stress ou infection intercurrente:a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X4;PulmicortX2 avec rincage;Seretide 2BX2;Atarax 25 mgX2;Singulair 10 mg le s;aerius 5 mg le s;Kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(203,135,'2013-09-20','Dr  KABAGEMA','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LANGENIER Marie Lucienne n&eacute;e le 31/07/1926.</p>\r\n<p>Cette dame ,veuve, a 10 enfants.Elle n\'a jamais fum&eacute;.</p>\r\n<p>Elle est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une fausse couche.Elle a &eacute;t&eacute; hospitalis&eacute; &agrave; 2 ou 3 reprises pour l\'asthme.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 1/2de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je demande une radiographie pulmonaire.</p>\r\n<p>Elle poursuivra son traitement par FORADIL 1 gel inhal&eacute; m et s ainsi que MIFLONIL 400 1 gel inhal&eacute; m et s avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(204,134,'2013-09-20','Dr Daniel JATOB\r\nDr Philippe BLANC\r\nSociété RESPIDOM','<p>Cher Daniel,Cher Philippe,</p>\r\n<p>J\'ai vu ce jour M. LEBRETON Camille Joseph n&eacute; le 15/05/1934.</p>\r\n<p>Ce patient pr&eacute;sente une BPCO post tabagique ;il s\'agit d\'un ancien fumeur totalisant 60PA sevr&eacute; depuis 5 mois.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeIII de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Il est actuellement il est en reeducation fonctionelle respiratoire au Centre de reeducation fonctionnel de la Clinique Ste Clotilde.Il pr&eacute;sente deux des crit&egrave;res d\'Anthonisen avec augmentation de la dyspn&eacute;e et augmentation du volume de l\'expectoration.Les crachats sont visqueux difficiles &agrave; expectorer.</p>\r\n<p>L\'auscultation r&eacute;v&egrave;le ce jour un freinage expiratoire avec un degr&eacute; d\'assourdissement des bruits pulmonaires stethacoustiques.</p>\r\n<p>Le TDM thoracique du 08/08/2013 avait rev&eacute;l&eacute; un important emphys&eacute;me centro-lobulmaire diffus avec un important syndrome bronchique avec des impactions mucoides.Ceci associ&eacute; &agrave; quelques DDB lobaires inf&eacute;rieures bilat&eacute;rales.</p>\r\n<p>L\'EFR du 14/08/2013 avait montr&eacute; un trouble ventilatoire obstructif Gold III avec un Tiffeneau &agrave; 61% et un VEMS &agrave; 0.90 soit 49% de la norme.S\'y associat une distension pulmonaire importante avec VGT &agrave; 209% CPT &agrave; 143% et VR &agrave; 202%.Le resistances des voies a&eacute;riennes &eacute;taient augment&eacute;es &agrave; 0.62.</p>\r\n<p>Les GDS r&eacute;v&egrave;laient pH7.48 pO2 67Torr pCO2 31Torr.</p>\r\n<p>&nbsp;Le Dr Blanc a not&eacute; une hypox&eacute;mie nocturne importante.Le patient pr&eacute;sente actuellement une exacerbation de sa BPCO.</p>\r\n<p>J\'ai demand&eacute; &agrave; la Soci&eacute;t&eacute; RESPIDOM d\'aller recontroler son concentrateur qui selon les dires du patient ne fonctionne pas bien.</p>\r\n<p>Je le place pendant 7 jours sous Augmentin 1gX3 avec Ultralevure.</p>\r\n<p>J\'y associe une corticoth&eacute;rapie &agrave; doses d&eacute;gressive:Cortancyl 40mg le matin en diminuant de 5 mg tous les 2 jours en vue arret avec Inexium 40 mg pendant la dur&eacute;e de la corticoth&eacute;rapie.Si lundi le patient n\'est pas amelior&eacute; on fera une halte en mati&egrave;re de reeducation respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(207,31,'2013-09-23','Dr Maigrat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GUICHARD Jean Pierre n&eacute; le 20/02/1949.</p>\r\n<p>Ce patient est un ancien fumeur sevr&eacute; depuis 1an.il totalise environ 22PA.</p>\r\n<p>Il est mari&eacute; 1 enfant.Il exercait la profession de manoeuvre macon.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une insuffisance h&eacute;patique post ethylique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IIIde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Sa SaO2 est &agrave; 98% avec un pouls &agrave; 95.</p>\r\n<p>L\'auscultation note un assourdissement des bruits pulmonaires sthetacoustiques.</p>\r\n<p>M.Guichard aura une EFR le 16/10/2013.Nous lui prescrivons une radiographie pulmonaire ainsi qu\'une GDS &agrave; AA avec NFS.</p>\r\n<p>Sur le plan th&eacute;rapeutique le patient poursuivra:Onbrez 300;Spiriva Respimat 2B/j;miflonil400 1X2;A&eacute;rosolttt Bricanyl-Atrovent et kin&eacute;siett respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(208,386,'2013-09-23','Dr Goburdhun\r\nPr Herve MAL','<p>Cher ami,</p>\r\n<p>J\'ai vu ce jour M. AYOUBA ABDOU Mohamed n&eacute; le 31/12/1977.</p>\r\n<p>Comme tu le sais le diagnostic retenu par les Prs Mal et Crestani de Paris est celui de tr&egrave;s probable Syndrome de Sjogren primitif.</p>\r\n<p>Pour l\'instant la greffe pulmonaire est abandonn&eacute; et le malade a &eacute;t&eacute; mis sous corticotherapie 40 mg le matin pendant 3 mois &agrave; compter du 07/07/2013.Il passera &agrave; 30 mg le matin &agrave; compter du 08/10/2013 avec diminution de 10 mg tous les mois jusqu\'&agrave; une dose seuil de 10mg/jour,en dessous de laquelle on ne pourra probablement pas descendre.En cas d\'aggravation lors de la baisse de la corticoth&eacute;rapie on introduira de l\'IMUREL per os &agrave; la dose de 2mg/K/J.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, mes amiti&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(209,500,'2013-09-23','Dr Goburdhun','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme HASSIM Merbanou, n&eacute;e le 12/07/1944.</p>\r\n<p>Cette dame est nonfumeuse,elle est mari&eacute; et a 2 enfants.Elle est sans profession;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA,une suspicion d\'hypercorticisme,une discopathie lombaire , un d&eacute;but d\'insuffisance r&eacute;nale et une osteoporose outre une allergie &agrave; la PENICILLINE.</p>\r\n<p>Mme Hassim est menopaus&eacute;e.</p>\r\n<p>Histoire de la Maladie:Mme Hassim se plaint d\'ne toux apparue depuis 1 an.</p>\r\n<p>Elle est trait&eacute; par LOSARTAN,PARIET,TAHOR,TEMERIT.</p>\r\n<p>Le TEMERIT est un beta-bloquant cardio selectif et peut etre &agrave; l\'origine d\'une toux.</p>\r\n<p>L\'auscultation pulonaire retrouve des sibilances et des ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique avec abaissement des coupoles diaphragmatiques.</p>\r\n<p>Je demande un dosage des Ige totales et un RAST aux pneumallergenes et aux Trophallergenes ainsi qu\'une NFS pour rechercher une hypereosinophilie.je reverrai Mme hassim le 04/10/2013 pour des EFR et bien adapter son traitement.J\'aimerai avoir le compte rendu de l\'Echocardiographie.</p>\r\n<p>Je conseille pour l\'instant INNOVAIR 2 BX2 avec rincage de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(210,519,'2013-09-23','Dr kapler\r\nDr A.THIA\r\nCardiologue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MUSSIDAN Michel n&eacute; le 13/12/1952.</p>\r\n<p>Ce patient ancien fumeur totalisant 24PA est sevr&eacute; depuis 1990.</p>\r\n<p>Il travaille &agrave; l\'imprimerie de la S&eacute;curit&eacute; Sociale.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une tachycardie en 2008 avec hospitalisation en 2009 .</p>\r\n<p>Il est en outre trait&eacute; pour syndrome d\'apn&eacute;e du sommeil et est appareill&eacute; par RESPIDOM.</p>\r\n<p>&nbsp;</p>'),(211,520,'2013-09-23','Dr kapler\r\nDr THIA','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MUSSIDAN Marie Paule n&eacute;e le 03/03/1951.</p>\r\n<p>Cettedame ancienne fumeuse 1 paquet /j sevr&eacute; en 1990 totalise 23PA.</p>\r\n<p>elle a &eacute;t&eacute; trait&eacute; pour insuffisance respiratoire.</p>'),(212,61,'2013-09-24','Dr Bruno CADET','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme BARAKA Marie Danielle, n&eacute;e le 18/07/1963</p>\r\n<p>Cette dame mari&eacute; a 2 enfants.</p>\r\n<p>Elle n\'a pas d\' ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une hysterectomie pour saignement en 2009.Elle a &eacute;t&eacute; op&eacute;r&eacute;e des parathyroides pour hypercalc&eacute;mie en juillet 2011.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels outre son asthme il convient de noter un ecz&egrave;ma chronique,une rhinite allergique,.</p>\r\n<p>Mme Baraka pr&eacute;sente un asthme persistant s&eacute;v&egrave;re ayant d&eacute;but&eacute; en 1978 au d&eacute;c&egrave;s de son p&egrave;re.</p>\r\n<p>Actuellement son asthme est bien equilibr&eacute; sous XOLAIR.</p>\r\n<p>La NFS ne retrouve pas d\'hypereosinophilie.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Elle aura une EFR de controle le 17/12/2013 &agrave; 8:00.</p>\r\n<p>Je lui renouv&egrave;le XOLAIR 300 /mois et elle prendra en sus SERETIDE,SINGULAIR,AERIUS,AVAMYS,VENTOLINE.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(213,65,'2013-09-24','Dr PATEL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. SOUPRAMANIEN Edmond n&eacute; le 18/11/1934.</p>\r\n<p>Ce mosieur mari&eacute; 6 enfants fumait un paquet et demi par jour.Il est sevr&eacute; depuis 2 ans.Il totalise plus de 70PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une resection endoscopique de la prostate avec op&eacute;ration pour arterite des M.I et hernie discale.</p>\r\n<p>Il pr&eacute;sente une BPCO post tabagique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e II grade de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>L\'EFR du 06/08/2013 montre un trouble ventilatoire Mixte ,Gold II dans sa composante obstructive,mod&eacute;r&eacute;e dans sa composante restrictive avec trouble du transfert:56% de la norme.</p>\r\n<p>la radiographie thoracique ne r&eacute;v&egrave;lait pas d\'anomalie parenchymateuse &eacute;volutive;compte tenu dui pass&eacute; tabagique du patient un scanner thoracique sans injection sera prescrit lors de la prochaine consultation.</p>\r\n<p>Il poursuivra son traitement habituel:Symbicort 400 1X2 et kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(214,27,'2013-09-24','Dr COURCHINOUX','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. FIDAHOUSSEN Sp n&eacute; le 04/04/1938.</p>\r\n<p>Ce monsieur mari&eacute; a 3 enfants.</p>\r\n<p>Il fumait 1 pqt/j.Il est pass&eacute; en tabac electronique depuis 5 mois.</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; pour hernie ombilicale en 2009 et 2012.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade Vde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi aux deux bases.</p>\r\n<p>L\'EFR du 26/07/2013 montrait un trouble ventilatoire Mixte Gold III dans qsa composante obstructive avec augmentatiopn de la resistance des voies a&eacute;riennes et trouble de la diffusion TLCO &agrave; 56% de la norme.</p>\r\n<p>Je demande ce jour un scanner thoracique sans injection avec une GDS &agrave; AA .</p>\r\n<p>M. Fidahoussen n\'est pas venu &agrave; son RV de polygraphie nocturne le 06/08/2013.je lui donne un autre RV le 12/02/2013.</p>\r\n<p>Il poursuivra la vaccination antigrippale annuelle avec Pneumo 23 tous les 5 ans.</p>\r\n<p>VNI et OLD avec aerosolth&eacute;rapie (Bricanyl-atrovent)X3 et PulmicortX2 avec rin&ccedil;age.</p>\r\n<p>aerosolttt (Bricanyl-Atrovent)X3 PulmicortX2;Onbrez300,Spiriva rEspimat2B;Ventoline;kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(215,392,'2013-09-24','Dr VINGUETAMA','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. JIBASSIA Jules n&eacute; le 06/10/1939. Il est trait&eacute; pour une BPCO post cuisson feu de bois chez un non fumeur.</p>\r\n<p>Ant&eacute;c&egrave;dents d\'HTA,DNID, AC/FA,insuffisance r&eacute;nale dialys&eacute;, hernie inguinale op&eacute;r&eacute;e,plastie mitrale le 18/11/2011.</p>\r\n<p>Actuellement le patient pr&eacute;sente une dyspn&eacute;e au r&eacute;veil avec des expectorations abondantes parfois sales.</p>\r\n<p>L\'auscultation retrouve des sibilances dans les 2 champs pulmonaires.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Le FEVG est &agrave; 30%.</p>\r\n<p>Je demande ce jour une proBNP avec GDS &agrave; AA,et lui demande de rapporter le scanner thoracique qu\'il a eu &agrave; St Benoit.</p>\r\n<p>En attendant je conseille de poursuivre l\'a&eacute;rosolth&eacute;rapie BRICANYL-ATROVENT X2/j associ&eacute; &agrave; PULMICORTX2/j;Kin&eacute;sieth&eacute;rapie respiratoire,Onbrez 150 et Spiriva Respimat 2B/j.</p>\r\n<p>L\'EFR de ce jour montre un trouble ventilatoire obstructif Grade III S&eacute;v&egrave;re avec VEMS &agrave; 0.72 soit 37% de la norme.Il existe une distension pulmonaire avec VGT &agrave; 197% ;CPT &agrave; 134% et Vr &agrave; 222% de la norme.Les ressistanceses voies a&eacute;riennes sont augment&eacute;es &agrave; 1.79 avec TLCO &agrave; 78% de la norme.</p>\r\n<p>Le TDM thoracique montre une atheromatose aortique sans l&eacute;sion pleuro-parenchymateuse &eacute;volutive(Dr COURCHAY).M.JIBASSIA m\'apportera lors de sa consultation du 19/11 les r&eacute;sultats de sa prise de sang.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(216,271,'2013-09-24','Dr Glorieux','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme NATIO noella n&eacute;e le 25/01/1932.</p>\r\n<p>Cette dame non fumeuse ,veuve 6 enfants est trait&eacute; pour un adenocarcinome du lobe sup&eacute;rieur droit class&eacute; T2N0M1a.</p>\r\n<p>Actuellement l\'epanchement pleural de la base droite s\'est stabilis&eacute;.</p>\r\n<p>Sa SaO2 est &agrave; 96% &agrave; AA</p>\r\n<p>L\'examen clinique retrouve un amaigrissement de 2.5 kilos en 2 mois.</p>\r\n<p>Elle utilise de l\'oxyg&egrave;ne la nuit.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire Mixte avec CPT &agrave; 52% de la norme.Il existe une composante Obstructive Gold III s&eacute;v&egrave;re avec VEMS &agrave; 0.63 soit 37% de la norme.</p>\r\n<p>La radiographie thoracique montre un epanchement pleural droit stabilis&eacute; avec une masse apicale droite de 3 cm de diam&egrave;tre.La NFS montre Hb 13.6,fonction hepato-renale satisfaisante.</p>\r\n<p>Pour l\'instant poursuivre le meme traitement:</p>\r\n<p>IRESSA 250 mg/j;ARIXTRA 7.5 mg/j;OLD 2L/mn;</p>\r\n<p>auquel je rajoute CETORNAN 5g X2 et CLINUTREN HP 1X3.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(217,79,'2013-09-24','Dr jean-Marc HOARAU','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ROBERT Maximin n&eacute; le 31/10/1937.</p>\r\n<p>Ce monsieur mari&eacute; est sans enfant.Il exercait la profession de ferailleur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie.</p>\r\n<p>On ne retrouve pas d\'ant&eacute;c&egrave;dent familial d\'asthme.Il s\'agit d\'un ancien fumeur sevr&eacute; en 1975.Il fumait entre 2&agrave;3paquets/jour.Il totalise environ 50PA.</p>\r\n<p>Depuis les ann&eacute;es 1980 il presente des exacerbations de BPCO et d\'asthme.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeIIIde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques sibilances et ronchi dans les 2 champs pulmonaires.</p>\r\n<p>la GDS &agrave; AA retrouve pH 704 pCO2 59 pO2 50 SaO2 86%.</p>\r\n<p>il a eu un scanner thoracique dont il m\'apportera les r&eacute;sultats.</p>\r\n<p>L\'EFR montrun trouble ventilatoire Obstructif Gold IV tr&egrave;s s&eacute;v&egrave;re avec S.de distension pulmonaire majeure et tr de la diffusion TLCO &agrave; 43%.</p>\r\n<p>Son traitement reste inchang&eacute;:</p>\r\n<p>Symbicort 400 1X2</p>\r\n<p>Spiriva Respimat 2B</p>\r\n<p>aerosolttt (Bricanyl-Atrovent)X3</p>\r\n<p>PulmicortX2</p>\r\n<p>Kin&eacute;siett respiratoire 4 s&eacute;ances/semaine;Cetornan5gX2 et CLINUTREN HPX3/J.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(219,188,'2013-09-24','Dr COURCHINOUX','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme HASSANALY Samina n&eacute;e le 29/03/1959.</p>\r\n<p>Elle a termin&eacute;e sa reeducation fonctionelle au CRF de Ste Clotilde.</p>\r\n<p>Son EFR montre un trouble ventilatoire mixte Gold III dans sa composante obstructive avec distension pulmonaire et augmentation des resistances des voies voies a&eacute;riennes. Dans l\'expectoration a &eacute;t&eacute; retrouv&eacute; du Pseudomonas aeruginosa multisensible.</p>\r\n<p>Pour l\'instant poursuivre le meme traitement :</p>\r\n<p>Zithromax 250 mgX3/semaine, FORADIL, SPIRIVA RESPIMAT VENTOLINE et kinesiettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(220,189,'2013-09-24','Dr Goulam Abasse','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. HASSANALY Rossanaly n&eacute; le 25/10/1938.</p>\r\n<p>Son EFR retrouve un trouble ventilatoire mixte GOLD II dans sa composante obstructive, avec un VEMS &agrave; 1,71 L, soit 52% de la norme. La CPT est &agrave; 59% de la norme, avec TLCO &agrave; 72% de la norme.</p>\r\n<p>Je demande ce jour un scanner thoracique que M.&nbsp;HASSANALY Rossanaly m\'apportera lors de sa consultation du 5 Novembre.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(221,280,'2013-09-24','Dr HITIER','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme OLINARD Marie Eveline n&eacute;e le 24/09/1941. Cette dame a &eacute;t&eacute; hospitalis&eacute;e a plusieurs reprises pour un trouble ventilatoire obstructif s&eacute;v&egrave;re GOLD III, avec acidose respiratoire.</p>\r\n<p>Elle est sous VNI et OLD.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'oscultation retrouve des sibilants dans les deux champs pulmonaires.</p>\r\n<p>Il convient de poursuivre chez elle :</p>\r\n<p>A&eacute;rosol bricanyl atrovent 3x/jour, a&eacute;rosol pulmicort x2 acec rin&ccedil;age,&nbsp;ombrez 300 1B/j,&nbsp;spirivat respimat 2B/j, clinutren HP 1x33, cetonnan 5g 1x2,&nbsp;tout en poursuivant la VNI et l\'OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(222,204,'2013-09-24','Dr Patel\r\nMédecin, Service d\'addictologie','<p>Cher ami, chers confr&egrave;res,</p>\r\n<p>J\'ai vu ce jour M. ROBERT Max Daniel n&eacute; le 03/08/1967. Il a arr&ecirc;t&eacute; de fumer, et est actuellement sous nicopatch.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif GOLD II, avec un VEMS &agrave; 2,42L, soit 71% de la norme. Il existe &eacute;galement une distention thoracique, avec VGT &agrave; 146% de la norme, VR 122%.</p>\r\n<p>Il convient de poursuivre le m&ecirc;me traitement :</p>\r\n<p>nicopatch, foradil, une g&eacute;lule inal&eacute;e matin &amp; soir, miflonil avec rin&ccedil;age, spiriva respimat 2B/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher ami,&nbsp;chers confr&egrave;res, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(223,72,'2013-09-24','Dr RIDA\r\nDr PAOLI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme SAUTRON Melanie n&eacute;e le 13/06/1950.</p>\r\n<p>Cette mari&eacute;e a 4 enfants.Elle est sans profession.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une intervention pouir cataracte .</p>\r\n<p>Elle est DNID,hypercholesterol&eacute;mie.</p>\r\n<p>A l\'age de 22ans il lui a &eacute;t&eacute; diagnostiqu&eacute; des DDB bilat&eacute;rales.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 1/2de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Son IMC est &agrave; 24.9 ce qui correspond &agrave; une corpulence normale.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je demande un scanner thoracique sans injection qu\'elle m\'apportera au prochain rendez vous.</p>\r\n<p>L\'EFR montrait un trouble ventilatoire restrictif avec CPT &agrave; 73&ugrave;;Le VEMS est &agrave; 0.7 soit 36% de la norme.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille ZITHROMAX 250 mg X 3 fois semaine ;Kin&eacute;sieth&eacute;rapie respiratoire associ&eacute; &agrave; Vaccion antigrippal annuel et Pneumo 23 tous les 5 ans.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(224,521,'2013-09-24','Dr Azad RAJABALY','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme DRAMSY Dilbanou n&eacute;e le 03/07/1930.</p>\r\n<p>Elle pr&eacute;sente dans ses ant&eacute;c&eacute;dents familiaux : une m&egrave;re et deux enfants asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels, on note une op&eacute;ration sur probable oclusion intestinale, et une intervention pour fibrome ut&eacute;rin. Elle est trait&eacute;e pour hypertension art&eacute;rielle.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade de l\'&eacute;chelle IV du Modified Research Council.</p>\r\n<p>L\'oscultation pulmonaire retrouve des ronchies dans les deux champs pulmonaires. L\'examen clinisque retrouve par ailleurs un&nbsp;oed&egrave;me de la jambe gauche. Je demande ce jour un &eacute;cho dopler des membres inf&eacute;rieurs, qu\'elle vous fera voir. Je demande &eacute;galement une radiographie du poumon, une prise de sang avec dosage IGE total, RAST aux pneumallergene et aux trophealergene et NFS + Plqt.</p>\r\n<p>Sur le plan th&eacute;rapeutique, il convient de poursuivre chez elle :</p>\r\n<p>Singulaire, 10mg, symbicort 400 1Bx2 avec rin&ccedil;age, ventoline 2bx2, kin&eacute;sith&eacute;rapie respiratoire, technique de ventilation dirig&eacute;e, 3x/semaine pendant 3 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(225,155,'2013-09-24','Dr. Ythier','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme HONORINE Marie Lucia n&eacute;e le 26/11/1962.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents familiaux, on note un fils asthmatique, qui a &eacute;t&eacute; hospitalis&eacute; pour asthme aigu grave. Mme Honornine est une ancienne fumeuse, sevr&eacute;e depuis 1989.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents on note une c&eacute;sarienne et une intervention pour kyste ovarien.</p>\r\n<p>Son asthme a d&eacute;marr&eacute; en 1992, et elle a eu plusieurs hospitalisation pour asthme.</p>\r\n<p>Elle est atuellement trait&eacute;e par xolaire, 225mg tous les 15 jours , s&eacute;retide et a&eacute;rosol bricalyn atrovent en cas de g&egrave;ne.</p>\r\n<p>L\'osculatation est dans les limites de la normle.</p>\r\n<p>Je demande ce jour un dosage d\'IGE Total de RAST aux tropallerg&egrave;ne et aux pneumallerg&egrave;nes, NFS + plaquettes.</p>\r\n<p>L\'EFR en date du 28/08/2013 avait retrouv&eacute; un trouble ventilatoire obstructif GOLD II, avec VEMS &agrave; 1,8L, et tiffneau &agrave; 64%. Il existait par ailleurs des signes de distension pulmonaire, avec VGT 140%, CPT 120% VR 131%. On notait une augmentation des voies a&eacute;rienne &agrave; 0,73. Le scanner thoracique &eacute;tait dans les limites de la normale.</p>\r\n<p>Elle continuera le m&ecirc;me traitement : seretide, singulair, a&eacute;rosol en cas de g&egrave;ne respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(226,138,'2013-09-24','Dr. Moutou, EPSMR, Saint-Benoit,\r\nMédecin EHPAD Le moutardier, Saint-Benoit.\r\nDr. Champeaux','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. VITRY Xavier n&eacute; le 10/12/1928.</p>\r\n<p>M. Vitry a eu une appendicectomie,une prostatectomie et une endariectomie carotidienne gauche.Il a &eacute;t&eacute; op&eacute;r&eacute; recemment d\'un h&eacute;matome sous dural bilat&eacute;ral.</p>\r\n<p>Ce patient pr&eacute;sente une BPCO post tabagique, un syndrome m&eacute;tabolique avec HTA, diab&egrave;te de type II et arterite.</p>\r\n<p>M.Vitry a pr&eacute;sent&eacute; un AVC en 2000 et un UGD en 2000.Il pr&eacute;sente par ailleurs un glaucome chronique &agrave; angle ouvert.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Ce monsieur se plaint ce jour d\'une constipation opiniatre.</p>\r\n<p>L\'EFR avait montr&eacute; chez lui un trouble ventilatoire obstructive Gold II avec signes de distension pulmonaire et augmentation de la resistance des voies a&eacute;riennes.</p>\r\n<p>Il convient de poursuivre chez lui Onbrez 150 ;Spiriva respimat 2B;Aerosolth&eacute;trapie (Bricanyl-Atrovent)X3 PulmicortX2 et kin&eacute;sieth&eacute;rapie respiratoire.Ceci associ&eacute; &agrave; l\'oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(227,523,'2013-09-24','Dr GENIN\r\nDr Peyronnet','<p>Cher ami,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. DELAPORTE Joel, n&eacute; le 02/05/1952</p>\r\n<p>Ce monsieur mari&eacute; 3 enfants est un ancien fumeur 10 cigarettes /j est sevr&eacute; depuis 2003.Il a travaill&eacute; dans la construction navale de 1970 &agrave; fin 1986.Il travaillait dans les chaudi&egrave;res et la tolerie.Il a &eacute;galement &eacute;t&eacute; ma&ccedil;on,plombier ,carreleur .Il a &eacute;t&eacute; arret&eacute; sur le plan professionnel par la M&eacute;decine du Travail en 2007 &agrave; Toulon.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une greffe r&eacute;nale &agrave; Toulon en 2003 suite &agrave; une maladie de Berger.Il a &eacute;t&eacute; amput&eacute; du MI gauche &agrave; la R&eacute;union en 2010 &agrave; la suite d\'une infection du MI gauche mal soign&eacute; &agrave; Madagascar.</p>\r\n<p>Actuellement le patient est sous CELLCEPT et voudrait savoir s\'il y a uine contreindication avec son exposition &agrave; l\'amiante pour laquelle il est indemnis&eacute; &agrave; 25%.</p>\r\n<p>Pour ce faire ,je demande je lui pratiquerai une EFR le 17/10/2013.</p>\r\n<p>Il m\'apportera son recent scanner thoracique.A signaler la pr&eacute;sence d\'epaississement calcifi&eacute; pleural en rapport avec une maladie asbestosique et de troubles ventilatoires r&eacute;tractiles du segment post&eacute;rieur du LSG et du LSD sur le scanner du 04/06/2010.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(228,227,'2013-09-24','Dr F.METE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GAUDENECHE Roger n&eacute; le 25/07/1940.</p>\r\n<p>Ce monsieur est un ancien fumeur 6Pa sevr&eacute; depuis 1970.</p>\r\n<p>Il est &agrave; la retraite des hopitaux depuis fin 1999.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents il a eu une appendicectomie &nbsp;et a &eacute;t&eacute; op&eacute;r&eacute; des varices.</p>\r\n<p>Il est trait&eacute; pour HTA .</p>\r\n<p>Il rel&egrave;ve d\'une gastro enterite;</p>\r\n<p>Les EFR montrent &nbsp;une distension pulmonaire avec Vr &agrave; 160% de la norme;VGT &agrave; 151% de la norme.La spirographie est dans les limites de la normale ainsi que la diffusion.</p>\r\n<p>ce monsieur fait r&eacute;guli&egrave;rement du sport.</p>\r\n<p>il pourra poursuivre Onbrez 300microg/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(230,522,'2013-09-25','Dr Jean-Marc HOARAU\r\nARAR\r\nDr Christian KICHENIN','<p>.</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PONAMA Denise n&eacute;e le 17/03/1942.</p>\r\n<p>Cette dame non fumeuse est veuve et a 10 enfants.</p>\r\n<p>Elle travaillait comme cantini&egrave;re et est &agrave; la retraite.Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie et une op&eacute;ration pour fibrome ut&eacute;rin.</p>\r\n<p>Elle est suivie pour HTA,DID,Syndrome d\'apn&eacute;e du sommeil avec comme prestataire l\'ARAR.</p>\r\n<p>Elle a &eacute;t&eacute; trait&eacute;e pour pleur&eacute;sie &nbsp;droite en 1969.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation est ce jour sans grande particularit&eacute;.</p>\r\n<p>Je demande une radiographie pulmonaire.</p>\r\n<p>Je lui pratiquerai le 06/11/2013 une EFR.</p>\r\n<p>Il convient de poursuivre Seretide 500 1B X2 avec rincage de la bouche auquel il convient d\'associer une kin&eacute;sieth&eacute;rapie resiratoire;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(231,255,'2013-09-25','Dr LEVEQUE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PONAMA eglantine n&eacute;e le 13/02/1962.</p>\r\n<p>Cette est c&eacute;libataire,2enfants.Elle travaille comme employ&eacute;e communale.</p>\r\n<p>Elle est non fumeuse.Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour endometriose et une intervention pour granulome des cordes vocales.</p>\r\n<p>Sur le plan m&eacute;dical elle est trait&eacute;e pour HTA,hypercholesterol&eacute;mie ,DNID et syndrome d\'apn&eacute;e du sommeil.</p>\r\n<p>Depuis la tendre enfance elle pr&eacute;sente de l\'asthme.</p>\r\n<p>Mme Ponama pr&eacute;sente un poids de 81K pour une taille de 1m57.Avec un IMC de 32.9 ce qui correspond &agrave; une obesit&eacute; mod&eacute;r&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Son EFR pratiqu&eacute; le 01/08/2013 est dans les limites de la normale.</p>\r\n<p>Elle a &eacute;t&eacute; en reeducation fonctionelle &agrave; la CRF de la clinique Ste Clotilde.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(232,69,'2013-09-25','Dr PARATIAN,Govindah\r\nRESPIDOM','<p>Cher ami</p>\r\n<p>J\'ai vu ce jour Mme DENISET Lucie n&eacute;e le 07/03/1939.</p>\r\n<p>L\'Echelle d\'Epworth est &agrave; 19/24.</p>\r\n<p>Le score de Mallampati est de 4 /4.et il existe 2 nyctiuries.</p>\r\n<p>Cette dame a b&eacute;n&eacute;fici&eacute; d\'un enregistrement polygraphique qui retrouve un index d\'apn&eacute;es,hypopn&eacute;es et d\'&eacute;v&egrave;nements (diminutions) de 45/heure.Compte tenu du contexte clinique (hypersomnie diurne) et de la difficult&eacute; de r&eacute;aliser une polysomnographie qui serait mal support&eacute; par la patiente,je la fait appareill&eacute; par RESPIDOM en PPC en mode autopilot&eacute; entre 5 et 20 cm d\'eau dans un premier temps.</p>\r\n<p>Avec mes remerciements, veuilles &nbsp;agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(233,121,'2013-10-10','Dr Olivier DUPUIS\r\n\r\ncopie à : SOS Oxygène','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ITARRE Sully n&eacute; le 29/08/1971. Ce patient a eu ce jour une EFR. Il p&egrave;se 137kg pour 1,69 m, avec un IMC &agrave; 48, ce qui correspond a une ob&eacute;sit&eacute; morbide. Il a perdu 20.2 kg, passant de 155 &agrave; 134.8 kg.</p>\r\n<p>Ce jour, l\'EFR retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute;, avec une CPT &agrave; 71%, VGT &agrave; 76%, VR 69%. Le VEMS est &agrave; 2,81L, soit 79 % de la norme, avec un Tiffeneau &agrave; 92% de la norme. La TLCO est peu perturb&eacute;e avec 72%</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale. La radiographie thoracique ne montre pas d\'anomalies pleuro parenchymateuses pulmonaires.</p>\r\n<p>La gazom&eacute;trie &agrave; air ambiant pH 7.41, pCO2 47, pO2 62, CO2 tot 31,2,&nbsp;h&eacute;matocrite 42,7.Il persiste donc une hypercapnie.</p>\r\n<p>M. ITARRE pr&eacute;sente donc un&nbsp;syndrome ob&eacute;sit&eacute; hypoventilation. Il n\'est pas pr&ecirc;t pour une r&eacute;adaptation respiratoire que je lui ai propos&eacute; ce jour. Il convient de poursuivre chez lui kin&eacute;sith&eacute;rapie respiratoire, r&eacute;gime hypocalorique, VNI, Onbrez 300 &micro;g 1B/j, SpirivaRespimat2B/J.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(234,128,'2013-09-25','Dr Paul MARIMOUTOU\r\nSociété RESPIDOM\r\nDr Blanc-Centre de Reeducation Fonctionnel.','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. FONTAINE Jean Jo n&eacute; le 22/03/1947.</p>\r\n<p>Ce patient ancien fumeur jusqu\'&agrave; 3paquets/j .Il est sevr&eacute; depuis 2002.Il totalise environ 100PA.</p>\r\n<p>M.Fontaine &eacute;tait technicien agricole.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention au niveau des sinus.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels une arthrose des 2 &eacute;paules &agrave; predominance droite ,des 2 genoux et de la r&eacute;gion lombaire avec une hernie discale.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont debut&eacute; depuis 4 ans.Il a &eacute;t&eacute; hospitalis&eacute; &agrave; 4 reprises il y a 2 ans &agrave; St Benoit.</p>\r\n<p>Il est actuellement appareill&eacute; pour syndrome d\'apn&eacute;e de sommeil .</p>\r\n<p>Il pr&eacute;sente donc un \"Overlap Syndrome\" &agrave; savoir l\'association d\'une BPCO &agrave; un syndrome d\'apn&eacute;e du sommeil.</p>\r\n<p>Il pr&eacute;sente &nbsp;2 nyctiuries contre 7 autrefois.</p>\r\n<p>Le poids est stable &agrave; 108/109 kilos.</p>\r\n<p>Sa qualit&eacute; de sommeil s\'est amelior&eacute; depuis qu\'il est sous PPC.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeIII/IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>Sa spirographie du 13/08/2013 la spirographie est dans les limites de la normale avec un VEMS &agrave; 2.6 soit 81% de la norme;Tiffeneau &agrave; 85%;Plethysmographie dans les limites de la normale;TLCO 100%.</p>\r\n<p>M.Fontaine a rendez vous le 12/11/2013 au centre de Reeducation Fonctionnel de la Clinique Ste Clotilde pour &nbsp;une rehabilitation respiratoire.Il supporte moins bien la chaleyur.</p>\r\n<p>En attendant je lui conseille de poursuivre l\'oxgenoth&eacute;rapie de confort,A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/j;PulmicortX2/j;Onbrez 300/j et Spiriva Respimat 2B/j associ&eacute; &agrave; la kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(235,122,'2013-09-25','Dr Low Hong','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. GRONDIN Luc n&eacute; le 17/02/1947.</p>\r\n<p>Ce patient, ancien fumeur est sevr&eacute; depuis 2007. Il a eu une lobectomie sup&eacute;rieure gauche le 13/10/2007 suivie d\'une chimioth&eacute;rapie adjuvante pour un ad&eacute;nocarcinome bronchiolo-alv&eacute;olaire. Son dernier scanner thoracique date du 14/01/2013 et montrait pas de l&eacute;sion &eacute;volutive.</p>\r\n<p>Il a &eacute;galement eu un pontage axillo f&eacute;morale commune droite par le Dr. Navarro en 2007, avec endarteriectomie G en 2008 par le Dr. Navarro.</p>\r\n<p>Actuellement, il pr&eacute;sente une dyspn&eacute;e grade 1 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Son EFR r&eacute;alis&eacute; ce jour retrouve un trouble ventilatoire obstructif GOLD II avec un VEMS &agrave; 1,51L, soit 74%, et un Tiffeneau &agrave; 70%. Il existe par ailleurs des signes de distension pulmonaire, avec VGT &agrave; 123%, CPT 111% et VR &agrave; 140%.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.&nbsp;Il convient de poursuivre chez lui Onbrez 150&micro;g, spiriva respimat 2B/j, miflonil 400 1B m&amp;s, avec rin&ccedil;age.</p>\r\n<p>Le scanner thoracique du 03/10/2013 retrouve des s&eacute;quelles de lobectomie &agrave; gauche sans particularit&eacute;.On suspecte une l&eacute;sion pari&eacute;tale de lma face post&eacute;rieure de la vessie de 8 mm.Je lui prescrit une echographie r&eacute;nale et v&eacute;sicale le 11/10/2013 &agrave; 7:45.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(236,71,'2013-09-25','Dr GERARD','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. BOYER Sully Maxime n&eacute; le 18/03/1929. Ce patient non fumeur a &eacute;t&eacute; soumi a une intense pollution au feu de bois par son m&eacute;tier de cuisinier restaurateur. Ces probl&egrave;mes respiratoires datent de 1999 quand il a &eacute;t&eacute; hospitalis&eacute; en pneumologie et a &eacute;t&eacute; suivi par moi.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2/3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchies et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique montre une l&eacute;g&egrave;re distension thoracique sans anomalie parachymateuse &eacute;volutive. L\'&eacute;peuve fonctionnell retrouve un trouble ventilatoire obstructif Gold II, avec VEMS &agrave; 1,03, soit 55% de la norme, avec un Tiffeneau &agrave; 68%. il existe des signes de distension thoracique avec VGT 129%, CPT 106%, VR 158%. La r&eacute;sistance des voies a&eacute;rienne est augment&eacute; &agrave; 1,03. La gazom&eacute;trie retrouve : ph :7.4, pCO2 39TORR, pO2 85 TORR, sa02 97%. L\'h&eacute;matocrite est &agrave; 46%.&nbsp;</p>\r\n<p>Il convient de poursuivre chez ce patient Onbrez 300 &micro;g 1B/j, 1B/j, spiriva respimat 2b/j, a&eacute;rosol bricanyl atrovent x 3/j, pulmicort x 2/j avec rin&ccedil;age, kin&eacute; respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(237,214,'2013-09-25','Dr Eric BOURDAIS\r\n\r\ncopie à : Seprodom','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme LARAVINE Marie Gillette n&eacute;e le 29/11/1939.</p>\r\n<p>Cette dame anciene fumeuse totalise environs 40 paquets ann&eacute;e. Elle est sans profession. Elle est veuve et a 6 enfants. Elle est DID.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute; en r&eacute;animation polyvalente en 2008 pour probl&egrave;me respiratoire.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3/4 de l\'&eacute;chelle du Modified Research Council. L\'oscultation pulmonaire retrouve une diminution desbruits pulmonaire st&eacute;thacoustiques. Le scanner montre une l&eacute;g&egrave;re cardiom&eacute;galie avec un degr&eacute; de trach&eacute;omalacie. Les bronches pr&eacute;sentent des paroies &eacute;paissies.</p>\r\n<p>L\'IMC est &agrave; 33,7, ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.&nbsp;Son EFR pratiqu&eacute; ce jour retrouve un trouble ventilatoire obtructif GOLD II, avec VEMS &agrave; 0,93L, soit 52%. Le Tiffeneau est &agrave; 75%. Il existe une distension pulmonaire avec VGT &agrave; 129% et VR 125%. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0,72%.</p>\r\n<p>Il convient de poursuivre chez elle la VNI / OLD avec Respidom, A&eacute;rosol th&eacute;rapie bricanyl atrovent, pulmicort x2, onbrez 300 &micro;g, spiriva respimat 2b/j, associ&eacute; &agrave; kin&eacute; respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(238,497,'2013-09-25','Dr GERARD\r\nTan Rouge','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BOUHASSOUN Nasser n&eacute; le 27/12/1986.</p>\r\n<p>Ses EFR montrent une spirographie dans les limites de la normale.</p>\r\n<p>La plethysmographie montre une distension pulmonaire mod&eacute;r&eacute;e avec VGT &agrave; 133% VR &agrave; 132% de la norme.La resistance des voies a&eacute;riennes est l&eacute;g&egrave;rement augment&eacute; &agrave; 0.33.;la TLCO l&eacute;g&egrave;rement diminu&eacute; &agrave; 74% de la norme.</p>\r\n<p>Il est conseill&eacute; &agrave; M.Bouhassoun d\'arreter de fumer.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(239,309,'2013-09-25','Dr Jean KAPLER\r\nDr Eddie LEUNG PIN\r\nDr KNEZYNSKI\r\nRESPIDOM\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MASSEAUX Bernard n&eacute; le 26/05/1942.</p>\r\n<p>Ce monsieur a &eacute;t&eacute; hospitalis&eacute; du 20 au 24/09/2013 &nbsp;pour decompensation cardio respiratoire.</p>\r\n<p>A &eacute;t&eacute; mis en &eacute;vidence une an&eacute;mie &agrave; 8.4 g/dl pour laquelle il a &eacute;t&eacute; transfus&eacute;.Je demande ce jour un bilan martial.</p>\r\n<p>Un scanner thoracique pratiqu&eacute; le 12/09/2013 a montr&eacute; des signes d\' HTAP avec dilatation de l\'A.pumonaire &agrave; 37 mm.Il existait une cardiom&eacute;galie avec signes de coeur gauche.</p>\r\n<p>Je demande au Dr Leung Pin de bien vouloir pratiquer une echocardiographie pour authentifier une HTAP &nbsp;dans le cadre d\'une cardiopathie gauche.</p>\r\n<p>En attendant il poursuivra son traitement habituel et je le reverrai le 24/10/2013 en consultation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(240,527,'2013-09-25','Dr FIDEL','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme LAPORTE Viviane n&eacute;e le 17/07/1972.</p>\r\n<p>Cette dame a &eacute;t&eacute; op&eacute;r&eacute;e d\'une tumeur carcinoide par le Dr Navarro le 16/05/2012.</p>\r\n<p>Elle r&eacute;side &agrave; Madagascar et elle est actuellement de passage &agrave; la R&eacute;union.</p>\r\n<p>Depuis l\'op&eacute;ration elle a parfois des douleurs thoraciques ant&eacute;rieurs droites.</p>\r\n<p>L\'examen clinique est sans grande particularit&eacute; avec palpation des aires ganglionnaires normale et auscultation pulmonaire normale.</p>\r\n<p>L\'EFR montre une spirographie normale avec un VEMS &agrave; 2.41 soit 80% de la norme. La resistance des voies a&eacute;riennes est augment&eacute; &agrave; 0.47 &nbsp;sans trouble de la diffusion.</p>\r\n<p>Mme LAPORTE a eu ce jour un scanner thoraco-abdomino-pelvien avec injection du produit de contraste.Cet examen est strictement superposable &agrave; celui du mois de mars 2013.</p>\r\n<p>Pour l\'instant nous pouvons rassurer Mme Laporte.Elle aura un nouveau scanner dans 1 an.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(241,505,'2013-09-25','Dr Laurence LEGROS','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme VIRGINIUS Diane Marie Beatrice, n&eacute;e le 15/06/1974</p>\r\n<p>Cette dame c&eacute;libataire sans enfant travaille dans une cr&egrave;che.</p>\r\n<p>Elle est non fumeuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on retrouve des cousins germains asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un ulc&egrave;re bulbaire,une d&eacute;pression au d&eacute;c&egrave;s de sa m&egrave;re.</p>\r\n<p>Elle a &eacute;t&eacute; trait&eacute; pour crises d\'asthme dans l\'enfance jusqu\'&agrave; l\'age de 7 ans.</p>\r\n<p>On note chez elle une rhinite allergique avec les yeux qui larmoient.</p>\r\n<p>Jeudi dernier le Dr Calichiama a incis&eacute; un phlegmon amygdalien gauche.</p>\r\n<p>Elle toux depuis avril 2013 avec des sibilances.Depuis elle est sous SYMBICORT.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour un l&eacute;ger freinage expiratoire.</p>\r\n<p>Sa radio pulmonaire est vous l\'avez dit normale.Je demande un dosage d\'IgE totales et de RAST aux Pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.</p>\r\n<p>Je la reverrai le 9/10/2013 pour une EFR et d\'ici l&agrave; elle poursuivra le SYMBICORT.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(242,403,'2013-09-25','Dr MOREL\r\nDr Omarjee','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme AUBRAS Marie Lise n&eacute;e le 02/03/1958.</p>\r\n<p>Cette dame pr&eacute;sente bien une reactivation de sa tuberculose pulmonaire et des BK ont &eacute;t&eacute; mis en &eacute;vidence dans ses expectorations lors de son hospitalisation du 05 au 25/09/2013.</p>\r\n<p>Elle est sorti avec un traitement par RIFATER et DEXAMBUTOL et sera suivi au CLAT par le Dr POUDEROUX et le Dr SCHLOSSMACHER.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(243,222,'2013-09-25','Dr GOUERY','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MOUCOUVEIA Emile Pierre n&eacute; le 27/09/1976.</p>\r\n<p>ce monsieur est fumeur 12 cigarettes par jour depuis l\'age de 18 ans .il a r&eacute;duit sa consommation tabagique et fume 7 cigaresttes par jour.</p>\r\n<p>Il est actuellement au chomage.iIl vit en concubinage et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents il a &eacute;t&eacute; pour un clou enfonc&eacute; dans son crane en 1989.</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>Il est suivi pour troubles psychiques.</p>\r\n<p>Son IMC est &agrave; 30.5 ce qui correspond &agrave; une obesit&eacute; mod&eacute;r&eacute;.</p>\r\n<p>Son score d\'Epworth est &agrave; 8/20.il ne pr&eacute;sente opas de nyctiuries.</p>\r\n<p>l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>l\'EFR montre une spirographie normale;la plethsmographie montre une distension pulmonaire moder&eacute; avec VGT &agrave; 120%CPT &agrave; 110% et VR &agrave; 138%.</p>\r\n<p>il a rempli un calendrier de sommeil et aura une polygraphie nocturne le 15/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(244,487,'2013-09-26','Dr Omarjee','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BADAT Houssen n&eacute; le 07/02/1957.</p>\r\n<p>Il va nettementmieux et devra prendre Seretide 500 2X2 pendant 1 semaine;Puis 1BX2.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(245,472,'2013-09-26','Dr Behary-Le Bihan','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. HOARAU Antoine n&eacute; le 07/08/1937.</p>\r\n<p>Son EFR montre un trouble ventilatoire obstructif Gold II avec un VEMS &agrave; 1.19 soit 59% de la norme.Le Tiffeneau est &agrave; 73%.Il existe par ailleurs une distension pulmonaire avec un VR &agrave; 121% et un VGT &agrave; 119%.Les resistances des voies a&eacute;riennes sont mod&eacute;r&egrave;ment augment&eacute;es &agrave; 0.36.La TLCO est peu alt&eacute;r&eacute; &agrave; 76% de la norme.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Nous avons fait la demande du PET Scan dont nous sommes en attente.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(246,212,'2013-10-09','Dr Deboisvilliers\r\nRESPIDOM\r\nDr BLANC','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LEBON Noe n&eacute; le 11/01/1942.</p>\r\n<p>Ce monsieur est mari&eacute; et a 4 enfants.Il s\'agit d\'un ancien peintre metallique.</p>\r\n<p>Il s\'agit d\'un ancien fumeur sevr&eacute; depuis 3 ans.Il fumait 1pqt/j et totalise plus de 50PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une occlusion intestinale et une brulure corporelle accidentelle.Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; il y a 10 ans.Il a &eacute;t&eacute; hospitalis&eacute; en 2010 au CHU F&eacute;lix Guyon pour d&eacute;compensation de BPCO.Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un assourdissement des bruits pulmonaires sthetacoustiques.Le scanner thoracique montre un important emphys&eacute;me avec un infiltrat apical gauche de 7 mm qu\'il faudra recontroler en pratiquant un scanner en janvier 2014.Les parois bronchiques sont &eacute;paissies .Les GDS &agrave; AA montrent:pH 7.46 pO2 73Torr pCO2 38 Torr SaO2 95%.Les EFR retrouvent un trouble ventilatoire Obstructif tr&eacute;s s&eacute;v&egrave;re Gold IV.le VEMS est &agrave; 25% de la norme;le tiffeneau &agrave; 38%.Il existe une distension pulmonaire avec VGT &agrave; 181% CPT &agrave; 119% et VR &agrave; 211%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.03 et la TLCO est &agrave; 77% de la norme.</p>\r\n<p>Le patient poursuivra son traitement habituel avec VNI,OLD kin&eacute;siettt respiratoire,Vaccination anti grippale annuelle et Pneumo 23 tous les 5 ans.A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 ;PulmicortX2 avec rin&ccedil;age de la bouche;Onbrez 300/j avec Spiriva Respimat 2B/j.</p>\r\n<p>Je telephone ce jour au Centre de Reeducation Fonctionnelle de Ste Clotilde pour une readaptation respiratoire.Le malade a rendez vous le 07/03/2013 &agrave; 10H.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(247,220,'2013-09-26','Dr Etienne SERY\r\nDr P.BLANC','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GRONDIN Henri Claude n&eacute; le 14/04/1958.</p>\r\n<p>Ce monsieur est ancien fumeur sevr&eacute; depuis 5 ans.Il fumait 2paquets /j depuis l\'age de 15 ans et totalise plus de 50 PA.Il exercait la profession de macon en batiment et a &eacute;t&eacute; licenci&eacute; au mois de mai 2013.Il est reconnu comme travailleur handicap&eacute; par la MDPH.</p>\r\n<p>Il est mari&eacute; et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un DNID,une HTA .</p>\r\n<p>Ses probl&egrave;mes respiratoires ont commenc&eacute; il y a 4 &agrave; 5 ans.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique retrouve &agrave; l\'auscultation un assourdissement des bruits pulmonaires sthetacoustiques.</p>\r\n<p>Le scanner thoracique montre un important emphys&eacute;me avec destruction parenchymateuse et des bulles sous pleurales,la plus volumineuse &agrave; droite mesure 43 mm.il existe une distension thoracique majeure.Les parois bronchiques sont &eacute;paissies.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Majeur Gold IV avec VEMS &agrave; 0.83 soit 26% de la norme.Le Tiffeneau est &agrave; 59%.Il existe une distension pulmonaire avec VR &agrave; 401% VGT &agrave; 299% et CPT &agrave; 181%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.47.Il existe des troubles de la Diffusion avec TLCO &agrave; 51%.</p>\r\n<p>M.Grondin a un sommeil de mauvaise qualit&eacute; et nous allons lui faire remplir un agenda de sommeil sur 3 semaines.</p>\r\n<p>&nbsp;M; Grondin voudrait attendre avant d\'envisager une rehabilitation respiratoire.Je lui prescrit une GDS &agrave; AA.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre Onbrez300/j;Spiriva Respimat 2B/j;a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X3 et PulmicortX2 avec rin&ccedil;age et kin&eacute;siettt respiratoire. et Alpha C 200.Le SINGULAIR n\'a pas d\'indication dans la BPCO.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(248,35,'2013-09-26','Dr KAPLER\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme SEPEROUMAL Marie Rachel n&eacute;e le 03/04/1966.</p>\r\n<p>Cette dame est mari&eacute; et a 8 enfants.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents familiaux on note un pere,menuisier, et des enfants asthmatiques.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e de plusieurs nodules thyroidiens en 1995/1996.</p>\r\n<p>Elle est trait&eacute; pour arthrose rachidienne.</p>\r\n<p>elle pr&eacute;sente un asthme difficile &agrave; trait&eacute; depuis l\'enfance (environnement de menuiserie).</p>\r\n<p>Elle ne supporte que des a&eacute;rosol(bricanyl-Atrovent)X3 &agrave; 4 X/j &nbsp;et SERETIDE 2BX2.</p>\r\n<p>La rehabilitation respiratoire a &eacute;t&eacute; chez elle un &eacute;chec.</p>\r\n<p>L\'auscultation pulmonaire montre un freinage expiratoire.</p>\r\n<p>La polysomnographie retrouve un IAH &agrave; 16/heure de sommeil ne n&eacute;cessitant pas d\'appareillage.</p>\r\n<p>Elle gardera l\'oxygenotherapie de confort.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(249,70,'2013-09-26','dr Eric FONTAINE','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme CLOVIS Oubanesbady n&eacute;e le 01/08/1951.</p>\r\n<p>Cette dame mari&eacute; 3 enfants est sans profession.</p>\r\n<p>Elle est non fumeuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une pose de pace maker,une greffe r&eacute;nale en 2012,une biopsie pulmonaire chirurgicale en 2009 pour une BOOP.</p>\r\n<p>Elle est trait&eacute; pour HTA ,une hypothyroidie.</p>\r\n<p>Mme CLOVIS pr&eacute;sente un asthme depuis 25 ans &agrave; son arriv&eacute;e &agrave; la R&eacute;union.</p>\r\n<p>Son p&egrave;re est asthmatique.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute; en 1997 pour asthme au CH F&eacute;lix Guyon.</p>\r\n<p>L\'auscultation pulmonaire retrouve un l&eacute;ger freinage expiratoire.</p>\r\n<p>les IgE totales sont &agrave; 87UI/l ;Les RAST aux pneumallergenes et aux trophallergenes sont n&eacute;gatifs.La NFS ne montre pas d\'hypereosinophilie.</p>\r\n<p>la radiographie pulmonaire ne montre pas d\'anomalie parenchymateuse &eacute;volutive.</p>\r\n<p>Il convient de poursuivre chez elle a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X2 ,pulmicortX2 avec rincage;Symbicort400 1BX2 avec rin&ccedil;age de la bouche avec kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(250,213,'2013-09-26','Dr ALLANE\r\nSOS OXYGENE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. TANGAPRIGANIN Charles n&eacute; le 30/08/1949.</p>\r\n<p>Ce monsieur divoc&eacute; 3 enfants travaillait aux archives.Il est actuellement &agrave; la retraite.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un AVP avec fracture de la tete femorale droite,une hernie inguinale gauche;adenome de la prostate.</p>\r\n<p>M.Tangapriganin est un ancien fumeur sevr&eacute; en ce moment.Il fume depuis l\'age de 17 ans et fumait 3 &agrave; 4 cigarettes /jour. Il est trait&eacute; pour Sd d\'apn&eacute;e de sommeil depuis 2003.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade I de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>Il existe de discrets oed&egrave;mes des M.I.</p>\r\n<p>L\'EFR est dans les limites de la normale .On ne note qu\'une l&eacute;g&egrave;re diminution de la TLCO &agrave; 73% de la norme.</p>\r\n<p>Toutefois le score d\'Epworth &agrave; 13/24 .</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>J\'ai appel&eacute; ce jour SOS OXYGENE pour controler la PPC de ce malade et je le reverrai en consultation le 11/10/2013 et il aura une polygraphie nocturne sous appareillage le 27/11/2013.</p>\r\n<p>Je le place sous FORADIL 1X2 et MIFLONIL 1X2 avec rin&ccedil;age en attendant.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(251,84,'2013-10-07','Dr Remy MAMIAS\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. TESTAN Yvon Francis n&eacute; le 20/12/1937.</p>\r\n<p>Il exercait la profession de ferailleur et fumait 2 pqt/j.Il est sevr&eacute; depuis plus de 20 ans.Il totalise plus de 50PA.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents personnels on note un DID,HTA.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; en 2007.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade II/III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>il pr&eacute;sente une toux avec expectoration blanchatre matinale.</p>\r\n<p>L\'examen clinique retrouve de discrets oed&egrave;mes des M.I. avec des ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique avec aplatissement des coupoles diaphragmatiques et augmentation de volume de la silhouette cardiovasculaire.</p>\r\n<p>Les GDS &agrave; AA retrouvent pH7.48 pCO2 43 pO2 77 Torr SaO2 95%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte avec VEMS &agrave;1.28 soit 61% de la norme Le Tiffeneau est &agrave; 87% avec CPT &agrave; 76% de la norme.Les resistances des voies a&eacute;riennes sont mod&eacute;r&eacute;ment augment&eacute;es &agrave; 0.38 mais on note des troubles du transfert avec TLCO &agrave; 24% de la norme.</p>\r\n<p>M.Testan poursuivra son traitement par VNI,OLD,Onbrez300/j ,Spiriva Respimat 2B/j Miflonil 400 1BX2 avec rin&ccedil;age ainsi que Kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(252,243,'2013-10-09','Dr Gazaille\r\nDr Schlossmacher\r\nservice des Maladies Respiratoires-CHU de St Denis\r\nDr Bruno CADET','<p>Chers Coll&egrave;gues</p>\r\n<p>J\'ai vu ce jour M. TESTAN Joseph Marcel n&eacute; le 12/10/1933 qui pr&eacute;sente une masse lobaire sup&eacute;rieure droite de 29 mm d\'allure suspecte.</p>\r\n<p>Ce monsieur est veuf et a 4 enfants.</p>\r\n<p>Il s\'agissait d\'un ancien fumeur 2 &agrave; 3 paquets/j. Il est sevr&eacute; depuis 2002 et &nbsp;totalise plus de 100PA.</p>\r\n<p>Il s\'git d\'un ancien macon en batiment.</p>\r\n<p>Il est trait&eacute; essentiellement pour une BPCO.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade II/III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique retrouve une diminution des bruits pulmonaires stethacoustiques avec discrets oed&egrave;mes des M.I.</p>\r\n<p>L\'EFR montre un trouble ventilatoire tr&egrave;s s&eacute;v&egrave;re GOLDIV avec un VEMS &agrave; 0.44 soit 18% de la norme; un Tiffeneau &agrave; 30% et des signes de distension pulmonaire avec VGT &agrave; 196% CPT &agrave; 117% VR &agrave; 206%. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.26 avec des troubles de la Diffusion : TLCO &agrave; 63% de la norme.</p>\r\n<p>je l\'adresse aux Drs gazaille et Schlossmacher pour exploration de cette masse pour laquelle je demande ce jour un PETScan.</p>\r\n<p>Je rappelle que ce malade est trait&eacute; par VNI, OLD, a&eacute;rosolth&eacute;rapie (Bricanyl_Atrovent)X3, PulmicortX2 avec rin&ccedil;age; Onbrez 300 1 B/j; Spiriva Respimat 2B/j et kin&eacute;sieth&eacute;rapie respiratoire 4 s&eacute;ances/semaine .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Coll&egrave;gues, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(253,334,'2013-09-26','Dr Chabas\r\nDr Chane Woon Ming','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai vu ce jour en consultation Mme LUI HIN TSAN Rose Marie n&eacute;e le 10/06/1926.</p>\r\n<p>Cette dame a eu un pontage aorto coronarien en 2001 et est trait&eacute; pour arthrose et HTA avec osteoporose.</p>\r\n<p>Elle pr&eacute;sente depuis sa vaccination anti grippale en juin 2013 du rhume avec eternuement et mal de gorge.</p>\r\n<p>De plus elle pr&eacute;dente une dyspn&eacute;e grade 3 du mMRC.</p>\r\n<p>L\'examen clinique montre une Sao2 &agrave; 95% et une TA &agrave; 16/9.</p>\r\n<p>l\'auscultation retrouve des sous crepitants aux bases;</p>\r\n<p>La radiographie thoracique montre un aplatissement des coupoles diaphragmatiques avec une l&eacute;g&egrave;re augmentation de volume de la silhouette cardiovasculaire.</p>\r\n<p>Les GDS &agrave; AA montrent pH 7.48 pCO2 37Torr pO2 76 Torr SaO2 95%.Les proBNP sont &agrave; 216pg/ml .</p>\r\n<p>Il est n&eacute;cessaire que Mme LUI &nbsp;revoye le Dr Chane Woon Ming pour une echocardiographie.</p>\r\n<p>Les EFR sont dans l\'ensemble satisfaisante:Spirographie et plethysmographie dans les limites de la normale.On note une diminution mod&eacute;r&eacute;e de la TLCO &agrave; 3.46 soit 68% de la norme.</p>\r\n<p>Pour l\'instant on poursuit l\'a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X2/ jour</p>\r\n<p>associ&eacute; &agrave; Kin&eacute;sieth&eacute;rapie respiratoire:technique de Ventilation dirig&eacute;e 3 fois / semaine &agrave; domicile.</p>\r\n<p>Veuillez agr&eacute;er,Chers Confr&egrave;res,l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(254,298,'2013-09-26','Dr VITTORI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. THOMAS Antonin n&eacute; le 01/08/1934.</p>\r\n<p>Ce monsieur est veuf et a 5 enfants.</p>\r\n<p>Il travaillait comme charpentier dans le batiment.</p>\r\n<p>iI fumait 2 paquets/j et est sevr&eacute; depuis en 2005.Il totalise environ 80PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour arterite des MI et un traumatisme thoracique dans son travail.Il a aussi eu un AVP.</p>\r\n<p>Il est aussi trait&eacute; pour HTA.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont commenc&eacute;s surtout en 2005 avec hospitalisation au CHGM &agrave; St Paul.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Research Council.de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>M.Thomas pr&eacute;sente une toux avec expectoration abondante e visqueuse blanchatre.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires avec dimunition des bruits pulmonaires stethacoustiques.On note un Signe de Campbell avec sternum projet&eacute; vers l\'avant.</p>\r\n<p>La radiographie thoracique montre des signes de distension thoracique majeure avec aplatissement des coupoles diaphragmatiques et de grosses art&egrave;res pulmonaires.</p>\r\n<p>L\'EFR montre un trouble ventilatoire Obstructif majeur Gold IV avec un VEMS &agrave; 24% non r&eacute;versible sous b2mimetiques.Le Tiffeneau est &agrave; 63%;il existe une distension pulmonaire avec VGT &agrave; 170%.</p>\r\n<p>Je demande une GDS &agrave; AA avec NFS et CRP.</p>\r\n<p>En attendant il poursuivra le meme traitement :VNI,Kin&eacute;siettt respi:Aerosolttt;OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(255,524,'2013-09-26','Dr COROUGE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CLAIN Georges Jean Marc n&eacute; le 23/11/1957.Ce monsieur ancien gros fumeur ,un demi &agrave; deux paquets /j est sevr&eacute;b depuis 1998.Il totalise environ 35PA.Il s\'agit d\'un ancien militaire de carri&egrave;re &agrave; la retraite depuis 1997.Il est mari&eacute; sans enfant.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention chirurgicale en 2008 par le DrZin suivi d\'une &eacute;ventration abdominale.Il aurait &eacute;t&eacute; hospitalis&eacute; en 2012 pour hemoptysie?</p>\r\n<p>Par ailleurs est trait&eacute; pour DID,tachycardie et une surdit&eacute;.Il est trait&eacute; par ONBREZ,SPIRIVA RESPIMAT et MIFLONIL ainsi que alpha C 200.Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.L\'examen clinique retrouve &agrave; l\'auscultation quelques ronchi.</p>\r\n<p>Je demande une radiographie pulmonaire qu\'il m\'apportera &agrave; la prochaine consultation.</p>\r\n<p>Sur le plan th&eacute;rapeutique on poursuivra :Onbrez 150 microg,Spiriva repimat 2B/j et pulmicort 1BX2 avec rincage.</p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(256,316,'2013-09-26','Dr Fouassin\r\nPhcie Bellepierre','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. OLIVIER Antoine Roger n&eacute; le 29/04/1940.</p>\r\n<p>Ce monsieur est mari&eacute; et a 4 enfants.Il s\'agit d\'un ancien cultivateur qui fumait 2 paquets/j.Il est sevr&eacute; depuis 10 ans.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note essentiellement une BPCO post tabagique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV/V &nbsp;de l\'&eacute;chelle du Modified MEDICAL Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi et des sibilances dans les deux champs pulmonaires avec un ventre ballonn&eacute;.</p>\r\n<p>La radiographie thoracique montre des parois bronchiques &eacute;paissies avec absence d\'anomalie pleuro-parenchymateuse &eacute;volutive.</p>\r\n<p>L\'hematocrite est &agrave; 46.2% et la GDS &agrave; AA retrouve:pH 7.44 pO2 57 Torr,pCO2 49 Torr et SaO2 87%.</p>\r\n<p>Il existe donc un syndrome d\'hypoxie-hypercapnie s&eacute;v&egrave;re.</p>\r\n<p>L\'EFR montre:un trouble ventilatoire probablement mixte ,GOLD III s&eacute;v&egrave;re dans sa composante obstructive,non r&eacute;versible sous beta2mimetiques.Le patient n\'a pu r&eacute;aliser les mouvements de plethysmographie et de m&eacute;canique ventilatoire.</p>\r\n<p>Je le reverrai en consultation le 17/10/2013 et poursuivra en attendant le meme traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(257,190,'2013-09-27','Dr STASICA\r\nDr DUVAL\r\nEHPAD Le Moutardier','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai vu ce jour M. TEVANE Nicolas n&eacute; le 25/04/1924.</p>\r\n<p>Ce patient est porteur d\'une BPCO,d\'une schizophr&eacute;nie,d\'un Parkinson et a pr&eacute;sent&eacute; un AVC isch&eacute;mique avec hemipar&eacute;sie droite.</p>\r\n<p>Il a par ailleurs une surdit&eacute; bilat&eacute;rale et a pr&eacute;sent&eacute; une d&eacute;compensation cardiaque.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; en reanimation en d&eacute;cembre 2010.</p>\r\n<p>Le scanner thoracique pratiqu&eacute; le 17/09/2013 a montr&eacute; un &eacute;panchementpleural bilat&eacute;ral qui devra etre explor&eacute; en adressant le malade au Centre hospitalier de saint Benoit ou au CH F&eacute;lix Guyon.</p>\r\n<p>Je le reverrai avec les r&eacute;sultats de cet examen le 15/10/2013 &agrave; 11:30.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(258,120,'2013-09-27','Dr KAPLER','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ALEXIS Jean Claude n&eacute; le 12/12/1944.</p>\r\n<p>Il a eu hier soir un enregistrement polygraphique nocturne.</p>\r\n<p>Il s\'est couch&eacute; &agrave; 22H et s\'est endormi &agrave; 22:15.Il a eu 2 nyctiuries &agrave; 1:00 et &agrave; 3:00 et s\'est rendormi rapidement.</p>\r\n<p>L\'examen a &eacute;t&eacute; accompli sans oxyg&egrave;noth&eacute;rapie.Il a beaucoup boug&eacute; dans son sommeil.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(259,165,'2013-09-27','Dr LARAVINE','<p>Cher Consoeur</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. PAVADE JOSEPH RICHEMON, n&eacute; le 05/09/1945</p>\r\n<p>Ce monsieur a pr&eacute;sent&eacute; une fi&egrave;vre avec une opacit&eacute; &nbsp;du culmen sur l&eacute;sions bulleuses.</p>\r\n<p>On &eacute;voque en premier lieu un probl&egrave;me infectieux qui sera long &agrave; irradiquer car survenant sur des sequelles parenchymateuses.</p>\r\n<p>Actuellement la fi&egrave;vre a regress&eacute;e et le patient va mieux quoique fatigu&eacute;.</p>\r\n<p>Je propose de renforcer le traitement par&nbsp;</p>\r\n<p>Rocephine 2g en IVD associ&eacute; &agrave; Rovamycine per os 1.5M UI 2cpX3/j pendant 10 jours. avec Ultralevure 2 cpX3 , Cetornan 5 g X2 et Aerosolth&eacute;rapie (Bricanyl-atrovent)X3 &nbsp;ainsi que Kin&eacute;sieth&eacute;rapie respiratoire drainage du LSG.</p>\r\n<p>A l\'issue pratiquer une NFS ,CRP.</p>\r\n<p>Je reverrai M.PAVADE le 11/10/2023 &agrave; 11:30.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(260,180,'2013-09-27','Dr MARONE','<p>Cher ami</p>\r\n<p>J\'ai vu ce jour M. CHANE KOA Chan Yai Wa n&eacute; le 05/11/1952.</p>\r\n<p>Ce monsieur fumeur 1pqt/j continue de fumer 6 cigarettes/j.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; pour tuberculose pulmonaire pulmonaire en juin 2012.Le traitement a &eacute;t&eacute; arret&eacute; &nbsp;au bout de 6 mois</p>\r\n<p>Sa radiographie pulmonaire du 06/08/2013 retrouve une opacit&eacute; sous claviculaire gauche qu\'il conviendra de controler en pratiquant une nouvelle radiographie au mois d\'octobre 2013.La VS &eacute;tait &agrave; 3,1&egrave;re heure le 06/03/2013 avec tubages gastriques n&eacute;gatifs ex direct et culture.</p>\r\n<p>Ce jour ses EFR monrent:Spirographie:dans les limites de la noramle;phlethysmographie signes de distension pulmonaire;augmentation des resistances des voies a&eacute;riennes.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(261,208,'2013-09-27','Dr MARIMOUTOU','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour Mme PARIS Marie Daniela n&eacute;e le 03/11/1972.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re et un fils asthmatique.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents personnels on retrouve chirurgical pour les menisques gauche.</p>\r\n<p>Mme PARIS pr&eacute;sente un asthme depuis la tendre enfance .</p>\r\n<p>En ce moment elle est enceinte de 3mois.</p>\r\n<p>Elle pr&eacute;sente une symptomatologie de RGO.</p>\r\n<p>l\'auscultation est ce jour &nbsp;dans les limites de la normale.</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale;la plethysmographie montre une distension pulmonaire mod&eacute;r&eacute;e avec l&eacute;g&egrave;re diminution de la TLCO &agrave; 73% de la norme.</p>\r\n<p>Elle poursuivra le traitement FORADIL 1gel inhal&eacute; m et s et MIFLONIL 400 1 gel inhal&eacute; m et s avec rin&ccedil;age et GAVISCON en gel 3 fois par jour.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(262,218,'2013-09-27','Dr TAMBURINI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. RACOUTE Augustin n&eacute; le 19/06/1935.</p>\r\n<p>Ce &nbsp;patient est un ancien fumeur 1 paquet/j sevr&eacute; depuis plus de 20 ans totalisant 30PA environ.</p>\r\n<p>Il s\'agit d\'un ancien agriculteur,veuf,8 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une resction endoscopique de la prostate,une appendicectomie.</p>\r\n<p>il est trait&eacute; pour HTA .Je le suis depuis de nombreuses ann&eacute;es pour une BPCO.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.Il pr&eacute;sente une toux matinale avec expectoration blanchatre.</p>\r\n<p>L\'examen clinique retrouve &agrave; l\'auscultation une diminuition des bruits pulmonaires stethacoustiques avec un signe de Harzer.</p>\r\n<p>Le scanner thoracique note une discr&egrave;te d&eacute;formation thoracique sans anomalie parenchymateuse pulmonaire &eacute;volutive.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif GOLD IV tr&egrave;s s&eacute;v&egrave;re avec un VEMS &agrave; 0.49 soit 24% de la norme.Le Tiffeneau est &agrave; 56% .La plethysmographie montre des signes de distension pulmonaire avec VR &agrave; 243% CPT &agrave; 145% VGT &agrave; 222%.il existe des troubles de la diffusion avec TLCO &agrave; 55%.</p>\r\n<p>Sur le plan th&eacute;rapeutique il poursuivra le meme traitement:Onbrez 300 1B/j;Spiriva Respimat 2B/j;Ventoline en cas de besoin;A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 Miflonil 1 gel inhal&eacute; m et s;kin&eacute;sieth&eacute;rapie respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(263,432,'2013-09-27','','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MOHAMED Ousman n&eacute; le 17/02/1966.</p>\r\n<p>Comme vous le savez ce patient pr&eacute;sente un adenocarcinome pulmonaire diffus metastatique d&eacute;couvert en d&eacute;cembre 2012 et sensible aux inhibiteurs des r&eacute;cepteurs de l\'EGFR. Il pr&eacute;sentait au d&eacute;part une carcinomatose pulmonaire milaire metastatique avec une volumineuse masse du LSD.</p>\r\n<p>Sous IRESSA puis TARCEVA la carcinomatose miliaire a regress&eacute;e et il ne persiste qu\'une image nodulaire du LSD.</p>\r\n<p>Malheurusement en raison de son &eacute;tat h&eacute;patique le patient ne peut prendre du TARCEVA qu\'&agrave; raison de 25mg/jour.</p>\r\n<p>Le patient se plaint de fatigue. Je demande &agrave; voir son taux d\'hemoglobine et je lui programme une EFR le 27/09/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(264,120,'2013-09-30','Dr. KAPLER\r\nDr. VENAULT\r\nDr. LEUNG-PIN\r\n\r\ncopie à SOS OXYGENE','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ALEXIS Jean Claude n&eacute; le 12/12/1944.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; d\'un enregistrement polygraphique nocturne dans la nuit du 26 au 27/09/2013.&nbsp;Le patient s\'est endormi &agrave; 22:15 et s\'est reveill&eacute; &agrave; 7:10. Il a eu 2 r&eacute;veils nocturnes &agrave; 1:00 et &agrave; 3:30.</p>\r\n<p>L\'IAH (Index Apn&eacute;e/Hypopn&eacute;e) s\'est revel&eacute; &ecirc;tre &agrave; 33 par heure, avec 43 apn&eacute;es, hypopn&eacute;es et evenements par heure. L\'examen a &eacute;t&eacute; effectu&eacute; sans oxyg&eacute;noth&eacute;rapie et le patient &agrave; pr&eacute;sent&eacute; 368 d&eacute;saturations, soit 44 d&eacute;saturations par heure de sommeil. On notait une saturation minimale a 61%, avec une saturation moyenne &agrave; 87%. A l\'eveil, la saturation est a 92%. Le capteur de son n\'&eacute;tait plus en place ce qui n\'a pas permis d\'authentifier les ronflements.</p>\r\n<p>Il convient que ce patient pr&eacute;sente un poids de 93 kg&nbsp;pour une taille de 1,71 m&nbsp;avec un IMC &agrave; 31 kg/m&sup2;, ce qui correspond &agrave; une ob&eacute;sit&eacute; moder&eacute;e.&nbsp;Le p&eacute;rim&egrave;tre cervicale est de 45 cm et le p&eacute;rim&egrave;tre abdominal est de 119 cm.&nbsp;Le score de Mallampati est de 3 /4. On note un score&nbsp;d\'Epworth&nbsp;&agrave; 7/20.</p>\r\n<p>Nous avons pris contact avec SOS Oxyg&egrave;ne qui appareillera le patient chez lui, avec une PPC en mode autopilot&eacute;, entre&nbsp;entre 4 et 14 cm d\'eau.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(265,236,'2013-09-30','Dr LEVEQUE\r\nDr CHECKOURI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LASANTE Serge n&eacute; le 26/08/1965.</p>\r\n<p>Ce patient non fumeur est mari&eacute; sans enfant et travaille comme op&eacute;rateur en telesurveillance;Dans ses ant&eacute;c&egrave;dents familiaux on note une polypose adenomateuse familiale .On note un neveu et une ni&egrave;ce asthmatique.Dans ses ant&eacute;c&egrave;dents personnels un reflux gastro oesophagien.Histoire de la Maladie:Depuis une ann&eacute;e,M.Lasant&eacute; a present&eacute; une symptomatologie de reflux gastrooesophagien avec des sibilances trait&eacute; par Ventoline et Gaviscon et Mopral.</p>\r\n<p>L\'examen clinique avait montr&eacute; des sibilances dans les deux champs pulmonaires avec douleur epigastrique et remont&eacute;e acide dans la bouche.Le patient pr&eacute;sentait une toux incoercible.Le poids &eacute;tait &agrave; 81K pour 1m66 soit un IMC &agrave; 29.4 ce qui correspond &agrave; un surpoids.Le score d\'Epworth est &agrave; 13/21 .Le score de Mallampati est de 2 /4.Le perim&egrave;tre cervical est &agrave; 40 cm avec un perim&egrave;tre abdominal &agrave; 103cm.L\'EFR montre un trouble ventilatoire mixte avec un VEMS &agrave; 1.87 soit 57% de la norme .Le Tiffeneau est &agrave; 95% .Il existe une distension pulmonaire avec un VGT &agrave; 166%,le VR est &agrave; 197%.La TLCO est &agrave; 69%.</p>\r\n<p>J\'ai demand&eacute; une radiographie pulmonaire ainsi qu\'une NFS,des IgE totales et des RAST aux pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.L\'agenda de sommeil est atr&eacute;r&eacute; compte tenu que le patient a un travail post&eacute;.Il a eu une polysomnographie dans la nuit du 27 au 28/09/2013.</p>\r\n<p>Le patient a &eacute;t&eacute; mis sous traitement antireflux ainsi que FORADIL et MIFLONIL.Sous traitement son &eacute;tat s\'est consid&eacute;rable&ugrave;ment amelior&eacute;.Il sera revu le 14/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(266,537,'2013-09-30','Dr BELROSE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme. ORESTE Carol n&eacute; le 05/09/1980.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour v&eacute;g&eacute;tations dans l\'enfance et des prol&egrave;mes bronchiques dans l\'enfance.Elle a &eacute;galement pr&eacute;sent&eacute; un ecz&egrave;ma et des rhinites allergiques.Depuis un an Mme Oreste a represent&eacute; des sifflements dans la poitrine.Elle a grossi sous pilulecontraceptive qu\'elle vient arreter il y a 1mois et demi.</p>\r\n<p>je demande ce jour une radiographie des sinus maxillaires et une EFR.</p>\r\n<p>Mme Oreste prendra du Singulair 10 mg 1 cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(267,536,'2013-09-30','Dr Belrose','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ORESTE Teddy n&eacute; le 01/03/1979.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une grand m&egrave;re paternelle asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une rhinite allergique et un eryth&egrave;me cutan&eacute; au froid.</p>\r\n<p>Depuis 2 semaines il ressent une irritation de la gorge necessitant la prise de celest&egrave;ne.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale ainsi que l\'examen ORL.</p>\r\n<p>les IgE totales sont &agrave; 442UI/ml.Les RAST montrent une allergie classe 3 &agrave; blomia Tropicalis ;classe4 &agrave; &nbsp;D.farinae et D.pteronyssinus.</p>\r\n<p>M.Oreste prendra outre de l\'aerius du singulair 10 mg 1 cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(268,153,'2013-09-30','Dr Bruno CADET','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme TESTAN Eliane Marcelle n&eacute;e le 13/04/1942.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA.</p>\r\n<p>Son asthme a d&eacute;but&eacute; &agrave; l\'age de 2 ans.elle a &eacute;t&eacute; hospitalis&eacute; pour asthme en 2005.</p>\r\n<p>Depuis sous traitement son asthme est bien control&eacute;.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour un freinage expiratoire mod&eacute;r&eacute;.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec NFS ,IgE totales RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes .L\'EFR montrait un trouble ventilatoire obstructif Gold II avec signes de distension pulmonaire VGT &agrave; 116% Vr &agrave; 118% de la norme.</p>\r\n<p>Mme TESTAN poursuivra FORADIL et MIFLONIL .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(269,1,'2013-10-01','Dr Eric BOURDAIS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. TREPORT REGIS n&eacute; le 17/08/1937.</p>\r\n<p>Ce patient mari&eacute; a 4 enfants.</p>\r\n<p>Il exercait la profession de macon.Il fumait 1paquet de cigarette /j et est sevr&eacute; depuis 1988.Il totalise 30PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour hernie inguinale bilat&eacute;rale.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; en 1992.Il a &eacute;t&eacute; hospitalis&eacute; &agrave; 3 reprises pour exacerbation de BPCO,la derni&egrave;re fois en 2012.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique retrouve des ronchi dans les deux champs pulmonaires.Il existe un RHJ (reflux hepato jugulaire)mod&eacute;r&eacute;.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec une gazom&eacute;trie &agrave; AA et une NFS.</p>\r\n<p>Sur le plan th&eacute;rapeutique M.Treport poursuivra l\'OLD la nuit,a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X2/j ,kin&eacute;sieth&eacute;rapie respiratoire X3/semaine,Symbicort 4001BX2?</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(270,103,'2013-10-01','Dr PRACISNORE','<p>Cher Confr&egrave;re et ami</p>\r\n<p>J\'ai vu ce jour M. LARAVINE Alex Celestin n&eacute; le 15/12/1940.Il continue &agrave; fumer 3 &agrave;4 cigarettes/j et totalise plus de 30PA.</p>\r\n<p>Ce patient veuf a 8 enfants.Il exercait la profession de charpentier parmis d\'autres.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council avec toux et crachats visqueux,blanchatres.</p>\r\n<p>L\'auscultation pulmonaire note un freinage expiratoire avec quelques sibilances et une cyphose dorsale.</p>\r\n<p>La radiographie thoracique retrouve des sequelles de lobectomie sup&eacute;rieure gauche avec des signes d\'emphys&egrave;me pulmonaire.</p>\r\n<p>La GDS &agrave; AA montre pH 7.41 pO2 66 Torr pCO2 37.9 Torr SaO2 95%.Hct est &agrave; 42.1%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif s&eacute;v&egrave;re Gold III avec signes de distension pulmonaire et augmentation de la resistance des voies a&eacute;riennes.LeVEMS est &agrave; 0.77 soit 38% de la norme avec un Tiffeneau &agrave; 53%.Le VGt est &agrave; 209% CPT &agrave; 133% VR &agrave; 203%.La RVA est &agrave; 0.76.</p>\r\n<p>Il poursuivra OLD,A&eacute;rosolth&eacute;rapie (bricanyl-Atrovent)X2;PulmicortX2 avec rincage,Onbrez 300;Spiriva Respi&ugrave;mat 2B/j.</p>\r\n<p>Kin&eacute;siettt respiratoire X3/Semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(271,248,'2013-10-01','Dr Jean KAPLER\r\nARAR','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. RIVIERE francois n&eacute;e le 13/12/1939.</p>\r\n<p>Ce monsieur mari&eacute; 3 enfants est un ancien fumeur sevr&eacute; depuis 2003.il fumait 2pqt/j et totalise 50PA.</p>\r\n<p>Il travaillait comme macon-coffreur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour hernie inguinale bilat&eacute;rale et une fracture de la jambe droite ainsi qu\'une amputation du pied gauche ;</p>\r\n<p>Il est trait&eacute; pour diab&egrave;te insulino-d&eacute;pendant ,HTA, et BPCO post tabagique.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Le patient pr&eacute;sente un ronflement qui a r&eacute;gress&eacute; sous VNI.</p>\r\n<p>Le score de Mallampati est de 3 /4.Il pr&eacute;sente 3 &agrave; 4 nyctiuries et son score d\'Epworth est &agrave; 18/24.</p>\r\n<p>&nbsp;M; RIVIERE aura une tDM thoracique sans injection le 31/10/2013 &agrave;n 8:00 &agrave; la Clinique st Vincent.</p>\r\n<p>Ses EFR retrouvaient un trouble ventilatoire Mixte ; s&eacute;v&egrave;re Gold III dans sa composante obstructive avec un VEMS &agrave; 0.93 soit 45% et un Tiffeneau &agrave; 69%.Par aiolleurs on note une composante restrictive avec un VGT &agrave; 69% CPT &agrave; 59% VR &agrave; 62%.</p>\r\n<p>Sur le plan th&eacute;rapeutique ce patient poursuivra :OLD,VNI,a&eacute;rosolth&eacute;rapie (bricanyl-Atrovent)X3/j PulmicortX2 avec rin&ccedil;age de la bouche,onbrez 300/j et Spiriva Respimat 2B/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(272,98,'2013-10-01','Dr CHABAS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GRONDIN Marie Odette n&eacute;e le 10/11/1950.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fils qui a pr&eacute;sent&eacute; des &eacute;pisodes asthmatiques.</p>\r\n<p>Mme Grondin a d&eacute;ja pr&eacute;sent&eacute; de l\'ecz&egrave;ma,de l\'urticaire,une conjonctivite et une rhinite allergique.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e des amygdales &nbsp;et a pr&eacute;sent&eacute; une dipht&eacute;rie dans l\'enfance.</p>\r\n<p>Elle fait de l\'asthme depuis 2 &agrave; 3 ans.</p>\r\n<p>Sous traitement tout a regr&eacute;ss&eacute; et l\'asthme est bien control&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Je demande un dosage des IgE totales ,une NFS, des RAST aux pneumallerg&egrave;es et aux trophallergh&egrave;nes ainsi qu\'une radiographie pulmonaire.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif tr&egrave;s mod&eacute;r&eacute; avec un VEMS &agrave; 1.4 soit 76% de la norme passant &agrave; 1.59 soit 85% de la norme sous b2mimetiques,traduisant une hyperreactivit&eacute; bronchique.</p>\r\n<p>Poursuivre le meme traitement FORADIL 1 gel inhal&eacute; m et s et MIFLONIL 200 1 gel inhal&eacute; m et s avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(273,49,'2013-10-01','Dr N\'Guyen','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ETOUARIA Jasmine Marie n&eacute;e le 31/01/1963.</p>\r\n<p>Cette dame est c&eacute;libataire 3 enfants.Elle est non fumeuse et est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,une HTA,un infarctus du myocarde en 2011.</p>\r\n<p>Elle a eu une angioplastie avec pose d\'un stent au CHU de Saint Denis.</p>\r\n<p>Son score d\'Epworth est &agrave; 5/24 .&nbsp;</p>\r\n<p>Le score de Mallampati est de 1 /4.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je demande une radiopgraphie pulmonaire.</p>\r\n<p>L\'EFR retrouvait un trouble ventilatoire obstructif Gold II avec un VEMS &agrave; 1.81 soit 69% de la norme.</p>\r\n<p>Une polygraphie nocturne a montr&eacute; un IAH &agrave; 13/H avec &eacute;venements.Compte tenu que la canule nasale s\'est d&eacute;plac&eacute;e pendant l\'enregistrement et que la patiente a pr&eacute;sent&eacute; un infarctus du myocarde sans grand facteur de risque une polysomnographie sera pratiqu&eacute; le 29/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(274,201,'2013-10-01','',''),(275,541,'2013-10-01','Dr   CONTE                                                                                                                                                                    ','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. IBOUTH Sylvestre n&eacute; le 01/01/1935.</p>\r\n<p>Ce monsieur est un ancien fumeur 1 pqt/j sevr&eacute; depuis 1984.Il buvait aussi et est sevr&eacute;.</p>\r\n<p>Il exercait la profession de coupeur de canne.Il est c&eacute;libataire sans enfant.Il a &eacute;t&eacute; op&eacute;r&eacute; d\'un cancer colique il y a 2 &agrave; 3 ans.je vais essayer de recup&eacute;rer son dossier &agrave; ONCORUN.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade&nbsp;IVde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique montre un assourdissement des bruits pulmonaires stethacoustiques.</p>\r\n<p>Je demande ce jour un TDM TAP thoraco abdomino pelvien et je reverrai ce patient pour EFR le 29/10 et Cs le 07/11/2013.</p>\r\n<p>Sur le plan th&eacute;rapeutique il covient de poursuivre a&eacute;rosolth&eacute;rapie(Bricanyl-atrovent)X2, Onbrez 150 /j et Kin&eacute;siettt respiratoire x3/semaine;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(276,340,'2013-10-01','Dr OMARJEE\r\nDr GERARD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ABELARD LOUISETTE MARIE n&eacute;e le 29/03/1962.</p>\r\n<p>Cette dame pr&eacute;sente un asthme s&eacute;v&egrave;re trait&eacute; par XOLAIR 150mg 1 fois par mois.</p>\r\n<p>Grace &agrave; ce traitement son asthme est parfaitement control&eacute;.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(277,202,'2013-10-01','Dr MARI\r\nDr KICHENIN\r\nCardiologue\r\nRESPIDOM\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. VIENNE Joseph n&eacute; le 07/01/1926.</p>\r\n<p>Ce monsieur non fumeur a exerc&eacute; la profession de cultivateur entre autres.</p>\r\n<p>Il est mari&eacute; et a 7 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une pose de pacemaker.M.Vienne est trait&eacute; pour HTA,DID.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Medical &nbsp;Modified Research Council.</p>\r\n<p>Le score de Mallampati est de3 /4.</p>\r\n<p>M. Vienne se plaint d\'une mauvaise qualit&eacute; de son sommeil et a une hypersomnolence diurne.Il pr&eacute;sente 2 nyctiuries.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je demande ce jour une gazom&eacute;trie &agrave; AA ainsi qu\'une radiographie pulmonaire.</p>\r\n<p>L\'EFR montre un trouble ventilatoire Mixte &nbsp;GOLD II dans sa composante obstructive avec un VEMS &agrave; 1.25 soit 57% de la norme;il existe une distension pulmonaire avec VGT &agrave; 112% Vr &agrave; 102% de la norme.</p>\r\n<p>Il poursuivra OLD,A&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X2 pulmicortX2 avec rin&ccedil;age Kin&eacute;siettt respiratoire X3/semaine.</p>\r\n<p>&nbsp;et Onbrez 150 1B/J;Ce patient aura une polygraphie nocturne le 06/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(278,319,'2013-10-01','Dr AZAIS\r\nRSEPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MADELEINE Pierre n&eacute; le 03/12/1932.</p>\r\n<p>Ce monsieur ancien fumeur sevr&eacute; depuis 5 ans fumait un &nbsp;paquet /jour.</p>\r\n<p>Il s\'agit d\'un ancien manoeuvre macon &agrave; la retraite.Il est mari&eacute; 10 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA avec IVG avec FEVG &agrave; 40/45%,une insuffisance r&eacute;nale chronique,un DID,une BPCO post tabagique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council.Le patient est sous OLd 24H/24.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques fins crepitants aux bases.Le TDM thoracique du 04/09/2013 montre des DDB cylindriques des deux lobes inf&eacute;rieurs et du lobe moyen.Des l&eacute;sions emphysemateuses pr&eacute;dominant aux 2 lobes sup&eacute;rieurs .</p>\r\n<p>L\'EFr montre un trouble ventilatoire mixte :GOLD III s&eacute;v&egrave;re dans sa composante obstructive .Il, existe des signes de distension pulmonaire avec VGT &agrave; 226% CPT &agrave; 127% VR &agrave; 258%.Hct &agrave; 23.3%.Je demande ce jour une GDS &agrave; AA.</p>\r\n<p>Il convient de poursuivre chez cz patient A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X2 PulmicortX2 avec rin&ccedil;age Onbrez 150 microg/j Spiriva Respimat 2B/j et Kin&eacute;siettt respiratoire X2/jopur ainsi que OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(279,59,'2013-10-01','Dr Mas','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. JAMS MARC AUGUSTIN n&eacute; le 06/09/1945.</p>\r\n<p>L\'auscultation retrouve des sibilances dans ses 2 champs pulmonaires.</p>\r\n<p>Il poursuivra le meme</p>\r\n<p>traitement;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(280,133,'2013-10-01','Dr LEROY','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DAMOUR Edith n&eacute;e le 28/09/1947.</p>\r\n<p>Cette dame c&eacute;libataire sans enfant fumait 5 cigarettes/j de 14 &agrave; 17 ans.</p>\r\n<p>Elle travaillait comme patissi&egrave;re -boulang&egrave;re et a cess&eacute; de travailler en 1991 en raison d\'un asthme professionnel.</p>\r\n<p>Dans ses ant&eacute;c&egrave;nts on note une hysterectomie en 1991.Elle est DID.</p>\r\n<p>Son asthme a d&eacute;but&eacute; en 1995/1996.Elle a &eacute;t&eacute; plusieurs fois pour asthme aigue grave.</p>\r\n<p>Son asthme difficile &agrave; traiter entre dans le cadre d\'une ABPA(Aspergillose broncho pulmonaire Allergique)et Mme Damour a &eacute;t&eacute; trait&eacute; par ITRACONAZOLE(SPORANOX).Elle est actuellement trait&eacute; entre autres par XOLAIR(OMALIZIMAB).</p>\r\n<p>Actuellement grace &agrave; l\'a&eacute;rosolth&eacute;rapie son asthme est assez bien &eacute;quilibr&eacute;.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage respiratoire mod&eacute;r&eacute; avec quelques sibilances.</p>\r\n<p>Le taux d\'IgE totales est de 983 UI/ml.Son poids est de 76.3Kilos .Mme Damour a pris 16 Kilos en quelques mois.Sa dose de XOLAIR doit etre augment&eacute;e encons&eacute;quence et elle prendra d&eacute;sormais 600mg de XOLAIR toutes les 2 semaines.Il convient de poursuivre l\'a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 PulmicortX2/j avec rin&ccedil;age ;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>P.S:mme Damour refuse de prendre le XOLAIR &agrave; raison de 600mg tous les 2 semaines car elle dit que cela la fait grossir et veut le XOLAIR &agrave; raison de 375mg ts les 15 jrs.</p>'),(281,211,'2013-10-01','Dr Pierron\r\nDr Yvin','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme CASSIM Rasoul n&eacute;e le 30/04/1951.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fr&egrave;re asthmatique.Mme Cassim a fum&eacute; 5 &agrave; 6 cigarettes/j et est sevr&eacute; depuis 2009.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie et un kyste synovial du genou gauche et une meatomie du sinus maxillaire gauche &nbsp;et une proth&egrave;se sur an&eacute;vrysme de l\'aorte thoracique en 2010.</p>\r\n<p>Elle est suivi pour un Sd de Gougerot_Sjogren associ&eacute; &agrave; une polyarthrite rhumatoide suivi par Dr Yvin.</p>\r\n<p>Elle a demarr&eacute; un asthme apr&egrave;s le d&eacute;c&egrave;s de sa m&egrave;re.Mme Cassim presente une toux avec expectoration blanchatre visqueux parfois abondant.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour quelque ronchi.</p>\r\n<p>Le TDM thoracique sans injection du 26/09/2013 ne retrouve pas d\'anomalie;l\'Hct est &agrave; 39.1%&nbsp;</p>\r\n<p>Les RAST ont montr&eacute; une allergie classe 4 &agrave; D.Farinae et clsse 3 &agrave; D.Pteronyssinus.Elle est donc allergique aux Acariens.Les IgE Totales sont &agrave; 123UI/ml.</p>\r\n<p>Les EFR montrent un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re non r&eacute;versible aux b2 mimetiques.il existe une distension pulmonaire avec VGT &agrave; 122% VR &agrave; 142%.La TLCO est &agrave; 66% de la norme traduisant des troubles de la diffusion.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre Seretide 500 1 &agrave; 2 BX2 avec rin&ccedil;age de la bouche azuquel il serait de rajouter du SPIRVA RESPIMAT 2B/J et kin&eacute;sieth&eacute;rpie respiratoire 3 seances/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(282,134,'2013-10-01','Dr daniel JATOB\r\n','<p>Cher Daniel</p>\r\n<p>Je revois ce jour M.LEBRETON Camille Joseph n&eacute; le 15/05/1934 qui va mieux.</p>\r\n<p>La soci&eacute;t&eacute; RESPIDOM a chang&eacute; son appareil qui &eacute;tait d&eacute;fectueux.</p>\r\n<p>Il &nbsp;pr&eacute;sente actuellement une dysurie avec sensation douloureuse du perin&eacute;.Il est sous XATRAL 10mg mais continue &agrave; souffrir .Je lui demande de te consulter pour cela.Je lui prescrit un dosage de PSA avec ECBU &nbsp;et une echographie prostatique.</p>\r\n<p>Je le reverrai en consultation le 26/11/2013.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher Daniel, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(283,158,'2013-10-01','Dr DUVAL\r\nLe MOUTADIER','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. JEBANE Jean Paul n&eacute; le 17/07/1959.</p>\r\n<p>Ce patient non mari&eacute; est non fumeur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une amygdalectomie,et une intervention sur l\'oreille droite.</p>\r\n<p>s\'y associe un tassement vert&eacute;bral de S1,une hernie hiatale par glissement ,une hyperlipid&eacute;mie avec hypertriglycerid&eacute;mie.</p>\r\n<p>M.Jebane a pr&eacute;sent&eacute; une meningite &agrave; 15 jours de la naissance avec d&eacute;formation des pieds ce qui l\'emp&egrave;che de marcher.Il est reconnu comme travailleur handicap&eacute;.Il n\'a plus de proche parent.</p>\r\n<p>Son asthme a d&eacute;but&eacute; dans les ann&eacute;es 1970.sa derni&egrave;re hospitalisation pour asthme date de f&eacute;vrier 2013 &agrave; St Benoit.</p>\r\n<p>Actuellement son asthme est bien equilibr&eacute; sauf quand il est contrari&eacute;.</p>\r\n<p>l\'auscultation pulmonaire est ce jouir dans les limites de la normale.</p>\r\n<p>Je demande une radiographie pulmonaire.</p>\r\n<p>Les IgE totales sont &agrave;; 953UI/ml; avec des RASt t&eacute;mognant une polyallergies :D.Pteronyssinus classe 3;Pollens divers Classe 2;Blatte classe 2;divers sensibilisation aux trophallerg&egrave;nes.</p>\r\n<p>Son poids est &agrave; 67kilos ce qui correspond &agrave; un taux de XOLAIR &agrave; 600mg tous les 15 jours.Il poursuivra INNOVAIR 2BX2 avec rincage.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(284,310,'2013-10-01','Dr labussiere','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MAUNIER Jacqueline n&eacute;e le 19/10/1956.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; ce jour d\'une EFR qui a montr&eacute; un syndrome d\'insuffisance respiratoire mixte mod&eacute;r&eacute;e avec un VEMS &agrave; 2.32 soit 75% de la norme,un Tiffeneau &agrave; 75% avec des signes &nbsp;de distension pulmonaire VGT &agrave; 115% et aussi des signes de trouble ventilatoire restrictif :CPT &agrave; 69% VR&agrave; 18%(?) .Il existe une augmentation de la resistance des voies a&eacute;riennes &agrave; 1.08.</p>\r\n<p>Mme Maunier aura une radiographie pulmonaire avec une prise des ang dosage IgE Totales,RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes et NFS.</p>\r\n<p>je la reverrai le 18/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(285,543,'2013-10-01','Dr MARONE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ANDRIEN MYRIAM n&eacute;e le 01/02/1935.</p>\r\n<p>Cette non fumeuse, veuve 5 enfants est ancienne employ&eacute; de la CAF.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note rien de particulier sinon &nbsp;une HTA trait&eacute; par hytacand remplac&eacute; par son g&eacute;n&eacute;rique CANDESARTAN. Elle est &eacute;galement trait&eacute; par CRESTOR remplac&eacute; par TAHOR mais son g&eacute;n&eacute;rique:ATORVASTATINE.</p>\r\n<p>Je demande ce jour une NFS+plqt avec Ferritin&eacute;mie et Cholest&eacute;rol total:HDL et LDL.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(286,68,'2013-10-02','',''),(287,68,'2013-10-02','Dr IMBERT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ANGAMA Adrienne n&eacute; le 04/03/1952.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels elle a eu une c&eacute;sarienne et une intervention du genou gauche pour accident de moto.</p>\r\n<p>Elle est trait&eacute; pour HTA.</p>\r\n<p>Depuis 2011 elle pr&eacute;sente un psoriasis g&eacute;n&eacute;ralis&eacute; suivi par le Dr Krikorian.</p>\r\n<p>Son asthme a d&eacute;but&eacute; en 2006 avec une hospitalisation la meme ann&eacute;e.</p>\r\n<p>Elle a &eacute;t&eacute; instruite &agrave; l\'&eacute;cole de l\'asthme.Elle a arret&eacute;e le XOLAIR et est trait&eacute; par FORADIL,MIFLONIL et SINGULAIR.</p>\r\n<p>Actuellement son asthme est bien &eacute;quilibr&eacute;e.</p>\r\n<p>L\'auscultation r&eacute;v&egrave;le des ronchi et sibilances dans les deux champs pulmonaires.</p>\r\n<p>Je conseille de pratiquer une radiographie pulmonaire avec dosage des IgE Totales,NFS,RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Il convient d\'ajouter au traitement des a&eacute;rosols (Bricanyl-Atrovent)x3 et PulmicortX2 avec rincage.</p>\r\n<p>je la reverrai le 06/11/2013 pour une EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(288,528,'2013-10-03','Dr Philippe ANDRIANTAVY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. TALBOT Francis, n&eacute; le 15/06/1947.Ce monsieur,mari&eacute; ,a 12 enfants.Il exercait la profession de cultivateur.</p>\r\n<p>Il fumait 1paquet de cigarettes /jour depuis 1961 et est non sevr&eacute;.Il totalise environ plus de 50PA.Il dit continuer &agrave; fumer environ 16 cigarettes/jour.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents vous signalez une HTA,une BPCO,une phl&eacute;bite avec embolie pulmonaire en 2008 et un adenome prostatique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade II/IIIde l\'&eacute;chelle du Modified Medical Research Council.Son IMC est &agrave; 31.6 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.</p>\r\n<p>Il dit tousser parfois avec expectoration blanchatre non visqueux.M.Talbot pr&eacute;sente un ronflement important avec 2 nyctiuries.Le score de Mallampati est de 3 /4.Son Score d\'Epworth est &agrave; 5/24.Il pr&eacute;sente 3 nyctiuries.L\'auscultation pulmonaire retrouve des ronchi et quelques sibilances dans les deux champs pulmonaires.Il existe un freinage expiratoire.On note un ventre proeminent et de discrets oed&egrave;mes mall&eacute;olaires.</p>\r\n<p>La radiographie thoracique montre une deformation avec aplatissement des coupoles diaphragmatiques,on note des signes de Kerley aux bases .M.Talbot a eu ce jour &nbsp;une EFR &nbsp;qui montre un trouble ventilatoire mixte ,GOLD II dans sa composante obstructive avec un VEMS &agrave; 1.73 soit 65% de la norme,non r&eacute;versible sous b2inhal&eacute;s.Le Tiffeneau est &agrave; 82% de la norme &nbsp;et il existe des troubles de la diffusion avec un TLCO &agrave; 56% de la norme avec augmentation de la resistance des voies a&eacute;riennes &agrave; 0.39.</p>\r\n<p>Nous prevoyons &eacute;galement une polygraphie nocturne le 10/10/2013 &agrave; 16:30.</p>\r\n<p>Sur le plan th&eacute;rapeutique il importe que que le patient cesse de fumer.Je lui prescrit du NICOPATCH.Je pense aussi qu\'il tirera b&eacute;n&eacute;fice par un traitement comportant ONBREZ 150 /j avec SPIRIVA RESPIMAT 2B/j et Kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(289,206,'2013-10-02','Dr Sevrin GERARD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MAILLOT Fran&ccedil;ois n&eacute; le 30/07/1938.</p>\r\n<p>Ce monsieur mari&eacute; a 7 enfants.Il s\'agit d\'un ancien cultivateur qui fumait 10 cigarettes/j.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA.Il a &eacute;t&eacute; hospitalis&eacute; pour exacerbation de sa BPCO.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires avec un prurit du cou.</p>\r\n<p>la radiographie thoracique a montr&eacute; des signes de distension thoracique avec grosses art&egrave;res pulmonaires.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire obstructif tr&egrave;s s&eacute;v&egrave;re Gold IV avec un VEMS &agrave; 0.54 soit 24% de la norme.Le Tiffeneau est &agrave; 57% .Ile xiste des signes de distension pulmonaire avec VGT &agrave; 307% CPT &agrave; 187% et VR &agrave; 385% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.55.</p>\r\n<p>La GDS &agrave; AA montre:pH 7.45 pCO2 51 Torr pO2 61Torr SaO2 89%.L\'Hct est &agrave; 34.5%.</p>\r\n<p>Il convient de poursuivre chez ce patient:OLD,VNI,a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 pulmicortX2 avec rin&ccedil;age Spiriva Respimat2b/j et Onbrez 300/j et Kin&eacute;sieth&eacute;rapie Respiratoire 3 s&eacute;ances / semaine au domicile du patient.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(290,162,'2013-10-02','Dr Le Bihan','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DRULA Denise Marlene n&eacute;e le 06/09/1951.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une tante asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une c&eacute;sarienne et une intervention pour ptose vesicale.</p>\r\n<p>Elle est trait&eacute; pour HTA et un meningiome pour lequel elle est suivie par le Dr De Monredon.</p>\r\n<p>Son asthme a demarr&eacute; dans l\'enfance et s\'est accentu&eacute; dans les ann&eacute;es 1980.Il s\'agissait d\'un asthme difficile &agrave; traiter.Elle a &eacute;t&eacute; hospitalis&eacute;e &agrave; plusieurs reprises pour asthme. Son asthme a &eacute;t&eacute; &eacute;quilibr&eacute; grace aux Anti IgE (XOLAIR) par lequel elle est trait&eacute; depuis plusieurs ann&eacute;es.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Mme Drula pr&eacute;sente un poids de 66Kilos pour une taille de 1m56 soit un IMC de 27.1 ce qui correspond &agrave; un surpoids.</p>\r\n<p>L\'EFR montre un VEMS &agrave; 1014 soit 57% de la norme.Le VEMS passe &agrave; 1.26 soit 63% sous b2inhal&eacute;s.Le Tiffeneau est &agrave; 78%.Il existe des signes de distension pulmonaire avec VGT &agrave; 117% CPT &agrave; 96% et VR &agrave; 124%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.79 sans trouble de la diffusion.TLCO &agrave; 104% de la norme.</p>\r\n<p>Je redemande un dosage d\'IgE Totales pour bien adapter la posologie de XOLAIR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(292,63,'2013-10-03','Dr Mondon Barnabera','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme TOUSSAINT JEANNINE MARIE n&eacute;e le 01/10/1948.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux &nbsp;on note une m&egrave;re et un fr&egrave;re asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie et une cholecystectomie.On note la notion de cuission au feu de bois dans l\'enfance.Elle a eu une cuisini&egrave;re &agrave; gaz quand elle s\'est mari&eacute;e &agrave; 19 ans.</p>\r\n<p>Elle est non fumeuse,divorc&eacute; avec 4 enfants.Il y a un an elle a pr&eacute;sent&eacute; de l\'ecz&egrave;ma.</p>\r\n<p>Son asthme a d&eacute;but&eacute; &agrave; l\'age de 40 ans lors d\'une &eacute;ruption volcanique qu\'elle avait &eacute;t&eacute; voir.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute; &agrave; plusieurs reprises pour asthme .La derni&egrave;re hospitalisation date de juillet 2012.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR et a&eacute;rosolth&eacute;rapie son asthme est bien &eacute;quilibr&eacute;.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IIde l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire mod&eacute;r&eacute;.</p>\r\n<p>Le scanner thoracique montre des bronches aux parois &eacute;paissies avec des zones de trappage t&eacute;moignant d\'une atteinte des petites bronches.(Dr Mascarel).</p>\r\n<p>L\'EFR est dans les limites de la normale en ce qui concerne la spirographie et la plethsmographie.On note toutefois des troubles moder&eacute;s de la diffusion avec un TLCO &agrave; 69% de la norme.</p>\r\n<p>Mme Toussaint est actuellement trait&eacute; par XOLAIR 150 mg en S/C toutes les 4 semaines,associ&eacute; &agrave; Onbrez 300,Spiriva respimat 2B/j,Miflonil 400 1BX2 avec rincage .ventoline au besoin &agrave; savoir 1 fois / semaine.Elle a aussi un d\'a&eacute;rosolth&eacute;rapie avec Bricanyl-Atrovent X2/j en cas de g&egrave;ne respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(293,544,'2013-10-08','Dr Thierry BORG\r\nDr HARVEY Gynecologue','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme COUSIN C&eacute;cile, n&eacute;e le 15/12/1983</p>\r\n<p>Cette dame est mari&eacute; ,en cours de grosesse &agrave; 12semaines d\'amenorrh&eacute;e.</p>\r\n<p>Elle est auxiliaire de puericulture &agrave; la Possession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on retrouve des allergies chez son fr&egrave;re qui pr&eacute;sente une rhinite allergique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une amygdalectomie.Elle pr&eacute;sente une allergie aux poils de chat et aux acariens.</p>\r\n<p>Son asthme a d&eacute;but&eacute; dans l\'enfance avec exacerbation depuis septembre 2012.</p>\r\n<p>Son traitement actuel consiste en SYMBICORT 400 1BX2.</p>\r\n<p>Actuellement elle pr&eacute;sente des vomissements de la grossesse et a perdu 4 kilos en 4 semaines.Elle a pr&eacute;sent&eacute; un malaise il y a 3 semaines avec d&eacute;saturation.</p>\r\n<p>L\'auscultation retrouve des sibilances dans les deux champs pulmonaires .La SaO2 est &agrave; 94% &agrave; Air ambiant;</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale;une plethysmographie montrant une distension pulmonaire mod&eacute;r&eacute;e avec TLCO &agrave; 61% de la norme mais pouvant etre du au fait qu\'elle a eu du mal &agrave; maintenir l\'apn&eacute;e.</p>\r\n<p>Nous sommes &nbsp;pass&eacute;s &agrave; SYMBICORT 400 2B m et s avec rin&ccedil;age de la bouche &agrave; l\'eau par la suite mais le bronchospasme persiste.dans ces conditions nous recourrons &agrave; une a&eacute;rosolth&eacute;rapie (bricanyl-atrovent)X2 en sus avec l\'arret &agrave; prescrire par le gyn&eacute;cologue.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(294,548,'2013-10-03','Dr PESCATORI\r\nORL\r\nDr Arnaud LEROY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme PUTIEN Maelis, n&eacute;e le 03/12/1996</p>\r\n<p>Cette jeune fille est lyc&eacute;enne en terminale.Elle est non fumeuse.</p>\r\n<p>Elle a eu une amygdalectomie .</p>\r\n<p>Depuis l\'enfance elle une malformation des cordes vocales ce qui alt&egrave;re sa voix.</p>\r\n<p>Elle pr&eacute;sente un IMC &agrave; 36.5(poids &agrave; 91 kilos et taille &agrave; 1m58) ce qui correspond &agrave;la limite d\'une ob&eacute;sit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Le score de Mallampati est de 2 /4.Le Score d\'Epworth est au minimum de 6/24.</p>\r\n<p>Elle d&eacute;crit un sommeil de mauvaise qualit&eacute; avec des r&eacute;veils nocturnes et une fatiguabilit&eacute; tr&egrave;s tot dans la journ&eacute;e.nous allons lui demander de remplir un agenda de sommeil.la m&egrave;re dit que Melle putien pr&eacute;sente un ronflement important.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dissemin&eacute;s dans les deux champs pulmonaires.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte &agrave; pr&eacute;dominance restrictive avec VGT &agrave; 74&ugrave; &nbsp;VR &agrave; 64% et CPT &agrave; 82% de la norme.Le VEMS est &agrave; 75% passant &agrave; 80% sous b2 mimetiques.Le Tiffeneau est &agrave; 79% de la norme avec des troubles de la diffusion:64% de la norme.</p>\r\n<p>mellze PUTIEN aura une polygraphie nocturne le 15/10/2013.</p>\r\n<p>Je conseille de la traiter par FORADIL 1 gel inhal&eacute; m et s et Miflonil 400 1 gel inhal&eacute; m et s avec rincage de la bouche associ&eacute; &agrave; kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(295,547,'2013-10-03','Dr J.P. LAURENT GRANDPRE\r\nDr VENAULT','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. RAKOTOARIVONY Gaetan, n&eacute; le 06/08/1960</p>\r\n<p>Ce patiet ancien fumeur 1 paquet/j est sevr&eacute; depuis 10 ans.Il totalise environ 20PA.</p>\r\n<p>M.Rakotoarivony est enseignant,mari&eacute;,un enfant.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une amygdalectomie et op&eacute;ration pour dent de sagesse.</p>\r\n<p>Il est trait&eacute; pour HTA et hypercholesterol&eacute;mie ainsi qu\'une tendinite de l\'epaule.</p>\r\n<p>Il pr&eacute;sente un ronflement depuis toujours.Son Score d\'Epworth peut etre &eacute;valu&eacute; &agrave; 3.</p>\r\n<p>Le score de Mallampati est de 2 /4.L\'auscultation pulmonaire retrouve quelques ronchi aux bases.</p>\r\n<p>Le perimetre cervical est &agrave; 39 cm avec un perim&egrave;tre abdominal &agrave; 95 cm.</p>\r\n<p>Nous allons apprendre au patient &agrave; remplir un agenda de sommeil.</p>\r\n<p>M. Rakotoarivony aura une une polysomnographie le 16/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(296,552,'2013-10-04','Dr CHARLES-RABESIAKA\r\nDr Schlossmacher\r\nDr Gazaille\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. ROBERT Gilbert, n&eacute; le 10/04/1949</p>\r\n<p>Ce monsieur c&eacute;libataire a 3 enfants. Il est agriculteur et &eacute;leve une centaine de poules, canard et oies.</p>\r\n<p>Il est ancien fumeur sevr&eacute; depuis 20 ans.Il fumait 1 paquet /j et totalise environ 20PA.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents on note une op&eacute;ration pour calcul r&eacute;nal, op&eacute;ration des 2 menisques ainsi qu\'une greffe de la main droite &agrave; la suite d\'un accident de travail en metropole.</p>\r\n<p>Il est trait&eacute; pour DID.</p>\r\n<p>M.ROBERT dit etre g&eacute;n&eacute; pour respirer depuis une ann&eacute;e.Depuis une semaine sa dyspn&eacute;e s\'est accentu&eacute;.</p>\r\n<p>Sa SaO2 est &agrave; 93% avec un pouls &agrave; 88.</p>\r\n<p>Auscultation retrouve quelques fins cr&eacute;pitants aux bases.Il n\'existe pas d\'hippocratisme digital.</p>\r\n<p>Le scanner thoracique retrouve effectivement des signes de pneumopathie infiltrante diffuse pour laquellt une fibroscopie bronchique avec LBA. J\'adresse pour ce faire, un email au Dr. Gazail, qui contactera directement le malade a son domicile au 0 693 401 124.</p>\r\n<p>L\'EFR pratiqu&eacute;e ce jour retrouve un trouble ventilatoire restrictif avec VGT &agrave; 57%, CPT 51% et VR &agrave; 38% de la norme. Le VEMS est a 2,11L soit 70% de la norme, avec un Tiffeneau a 93%. Il existe des troubles de la diffusion avec TLCO a 47%.</p>\r\n<p>Je demande ce jour :</p>\r\n<p>- une gazom&eacute;trie &agrave; air ambiant</p>\r\n<p>- NFS + plaquettes, TP/TCA</p>\r\n<p>- electrophorese des prot&eacute;ines plasmatiques</p>\r\n<p>- cr&eacute;atinin&eacute;mie</p>\r\n<p>- bilan h&eacute;patique</p>\r\n<p>- une &eacute;lectrophor&egrave;se des prot&eacute;ines plasmatiques</p>\r\n<p>- recheche de facteurs antinucl&eacute;aires, de facteur rhumatoide, d\'anti-SSA et d\'anti-SSB,&nbsp;d\'anticorps antisynth&eacute;tases</p>\r\n<p>- dosage des CPK, de la calc&eacute;mie et une recherche d\'ANCA</p>\r\n<p>- recherche de pr&eacute;cipitine vis &agrave; vis de maladie d\'&eacute;leveur d\'oiseau et de maladie du poumon de fermier.</p>\r\n<p>Je revois le patient le patient le 14 octobre &agrave; 15h30.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(297,30,'2013-10-03','Dr GOULAM-ABASSE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GOULAMHOUSSEN Kaniza n&eacute;e le 12/12/1930.</p>\r\n<p>Elle est trait&eacute; pour une infection des jambes depuis le 27/09/2013.</p>\r\n<p>Depuis hier soir elle est davantage essoufl&eacute; avec fi&egrave;vre et a une expectoration jaunatre.</p>\r\n<p>Sa SaO2 est &agrave; 93% &agrave; AA avec un pouls &agrave; 85.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.La patiente refuse l\'hospitalisation.Mme Goulamhoussen n\'a pas &eacute;t&eacute; vaccin&eacute; contre la grippe.De plus tous les 5 ans il faudra la vacciner par le pneumo 23.</p>\r\n<p>Je propose de remplacer la spiramycine par Augmentin 1gX3 tout en donnant de l\'Ultralevure 2X3 avec un regime anti diarrh&eacute;ique ;Le traitement habituel est &agrave; poursuivre .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(298,476,'2013-10-04','','<p>Dcd le 02/10/2013.</p>'),(299,397,'2013-10-04','Dr Eric FONTAINE\r\nISIS réunion','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CADET Nicole n&eacute; le 06/11/1952.</p>\r\n<p>Je lui ai remis &agrave; M.Nicole CADET son interpretation de polygraphie nocturne.Cet examen montre une forte suspicion de &nbsp;syndrome d\'apn&eacute;e de sommeil en position dorsale avec un IAH &agrave; 14/H .Cet index passe &agrave; 29/h avec les evenements accompagn&eacute;s d\'&eacute;crasement de l\'onde de pouls .Nous avons programm&eacute; une polysomnographie le 14/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(300,533,'2013-10-04','Dr AKBARALY Moise\r\nARAR-HAD.\r\nMme l\'ortophoniste','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. BOYER Elisien, n&eacute; le 03/06/1949</p>\r\n<p>Ce patient ancien fumeur un paquet/j est sevr&eacute; depuis 7 ans.Il totalise environ 35PA.</p>\r\n<p>Il exercait la profession de macon .Il est mari&eacute; et a 2 enfants.</p>\r\n<p>Il a eu une laryngectomie le 21/06/2013 par le Dr Delagranda pour un neo du larynx.Il est depuis en HAD avec l\'ARAR.</p>\r\n<p>Ce patient est trait&eacute; pour HTA et BPCO Gold III s&eacute;v&egrave;re.<br />Pr&eacute;alablement &agrave; sa laryngectomie le patient a b&eacute;n&eacute;fici&eacute; d\'une gastrostomie d\'alimentation.</p>\r\n<p>L\'auscultation pulmonaire r&eacute;v&egrave;le une spasticit&eacute; bronchique avec des ronchi dans les deux champs pulmonaires.&nbsp;</p>\r\n<p>Je lui prescrit un scanner thoracique sans injection &nbsp;ainsi qu\'une NFS et une GDS &agrave; AA.</p>\r\n<p>Le spiriva Respimat et l\'Onbrez ne pourront etre repris qu\'&agrave; la fermeture de la tracheotomie.</p>\r\n<p>En attendant devra etre poursuivi l\'a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/j et PulmicortX2 avec rin&ccedil;age ainsi que Kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(301,539,'2013-10-09','Dr. Akbaraly Moise\r\nDr. Jop\r\nDr. Braumberger\r\nSOS Oxygène','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. MAMODALY LADA Aziz Aly, n&eacute; le 10/02/1943.</p>\r\n<p>Ce patient est un ancien fumeur (9 paquets/ann&eacute;es), sevr&eacute; depuis 45 ans, mari&eacute;, 4 enfants. Il excer&ccedil;ait la profession de commer&ccedil;ant, marchant ambulant, boulanger.&nbsp;Son poids est de 83 kg pour une taille de 1,65m, avec un IMC de 30,5 m/kg&sup2;, ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.Le perimetre cervical est &agrave; 45cm et le perim&egrave;tre abdominal &agrave; 111cm.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents personnels, on note une cholecystectomie en 2011, &nbsp;une hypertension art&eacute;rielle et un DNID.</p>\r\n<p>Ce patient pr&eacute;sent un ronflement. Le score de Mallampati est de 3 /4. Le score d\'Epworth est de 9/24.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 3 de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>A l\'oscultation, on note un assourdissement des bruitspulmonaires st&eacute;thacoustique.</p>\r\n<p>L\'EFR est peu perturb&eacute;e avec un VEMS &agrave; 2,05L soit 80% de la norme. La capacit&eacute; vitale est r&eacute;duite &agrave; 2,20L, soit 66% de la norme. Le Tiffeneau est &agrave; 94%.</p>\r\n<p>La pl&eacute;thysmographie&nbsp;est l&eacute;g&eacute;rement est dans les limites de la normale. Il n\'existe pas de trouble de la diffusion : TLCO normale, mais on note une augmentation de la r&eacute;sistance des voies a&eacute;riennes &agrave; 0,47.</p>\r\n<p>Devant le syndrome m&eacute;tabolique, le ronflement, et les perturbations des scores d\'Epworth et de Mallampati, un polygraphie nocturne a &eacute;t&eacute; programm&eacute;e le 7 octobre &agrave; 16h45.</p>\r\n<p>cet examen retrouve 160 ronflements/H avec une energie moyenne de 84dB ce qui correspond au bruit d\'un aspirateur.L\'Index d\'Apn&eacute;es-hypopn&eacute;es est de 38/heure avec un index d\'apn&eacute;es ,d\'hypopn&eacute;es et d\'&eacute;venements &agrave; 55/heure avec des d&eacute;saturations atteignant 75% d\'SaO2.</p>\r\n<p>M.MAMODALY est donc porteur d\'un sndrome d\'apn&eacute;e du sommeil et sera appareill&eacute; le plus rapidement possible par la soci&eacute;t&eacute; SOS Oxyg&egrave;ne en pression positive continue en mode auto pilot&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(302,552,'2013-10-04','',''),(303,542,'2013-10-04','Dr. Bobate\r\nDr. Moshinaly\r\nDr. Blanc, Centre de Rééducation, clinique Sainte-Clotilde\r\nDr. Chitson','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. MOOSBALLY Sheik n&eacute; le 01/06/1960.</p>\r\n<p>Dans ces ant&eacute;c&eacute;dents, on note un p&egrave;re asthmatique, une insuffissance coronarienne avec angioplastie coronarienne et pose d\'un stent le &nbsp;5 juin 2013. Ce monsieur est gestionnaire d\'atelier d\'automobile. Il est mari&eacute;, 3 enfants. Il est actuellement appareill&eacute; pour Syndrome d\'Apn&eacute;e du Sommeil par l\'ARAR.</p>\r\n<p>Son asthme a d&eacute;marr&eacute; depuis l\'enfance, avec 3 hospitalisations dans l\'adolescence.Egalement hospitalis&eacute; pour asthme en 2009 et en 2010 au CHU de Bellepierre.</p>\r\n<p>Il travaille dans un environnement stressant. il ne pr&eacute;sente plus de crise d\'asthme mais il est essouffl&eacute; surtout depuis son accident cardiaque.Il est trait&eacute; par xolair 300mg, s&eacute;r&eacute;tide 250mg, 2b m&amp;s a l\'aide d\'une chambre d\'inhalation.</p>\r\n<p>Il est actuellement en r&eacute;&eacute;ducation fonctionnelle au centre de r&eacute;&eacute;ducation de Sainte-Clotilde.Il pr&eacute;sente une dyspn&eacute;e grade 2-3 de l\'&eacute;chelle du Modified Medical Research Council.L\'auscultation pulmonaire est ce jour dans les limites de la normale.Il a eu un bilan allergologique et est allergique aux acariens, &agrave; la moisissure et aux poils de chat.</p>\r\n<p>La NFS montre Hb &agrave; 14.7g/dl Il existe une hypereosinophilie mod&eacute;r&eacute;e &agrave; 519/mm3 .Le pro-BNP est &agrave; 17 traduisant une origine respiratoire de la dyspn&eacute;e.Les IgE totales sont &agrave; 430UI/ml traduisant un terrain atopique.</p>\r\n<p>les EFR montrent un trouble ventilatoire obstructif Gold II mod&eacute;r&eacute; avec un VEMS &agrave; 2.05 soit 64% de la norme.non r&eacute;versible sous b2 inhal&eacute;s.La plethysmographie est dans les limites de la normale avec une augmentation de la resistance des voies a&eacute;riennes &agrave; 0.73.Il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Je conseille de rajouter un b2 de tr&egrave;s longue dur&eacute;e d\'action au traitement :Onbrez150 &agrave; passer secondairement &agrave; 300/j.Je serai tr&egrave;s interss&eacute; par son test d\'effort.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(304,543,'2013-10-04','Dr MARONE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ANDRIEN MYRIAM n&eacute;e le 01/02/1935.</p>\r\n<p>Cette non fumeuse, veuve 5 enfants est ancienne employ&eacute; de la CAF.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note rien de particulier sinon &nbsp;une HTA trait&eacute; par hytacand remplac&eacute; par son g&eacute;n&eacute;rique CANDESARTAN. Elle est &eacute;galement trait&eacute; par CRESTOR remplac&eacute; par TAHOR mais son g&eacute;n&eacute;rique:ATORVASTATINE.</p>\r\n<p>Son taux d\'hemoglobine est &agrave; 13g/l.Elle n\'a donc pas pas d\'an&eacute;mie et le traitement martial peut etre arret&eacute;.</p>\r\n<p>Son bilan lipidique est aussi normal..</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>CANDESARTAN 8mg/j pdt 3 mois</p>\r\n<p>TA 13/9 pouls 65 et SaO2:95%.</p>'),(305,542,'2013-10-04','',''),(306,476,'2013-10-05','Famille Lucien TIEFFENBACH','<p dir=\"ltr\">Ch&egrave;re Famille</p>\r\n<p dir=\"ltr\">Permettez moi de vous renouveler toute ma sympathie pour la perte de Lucien : votre &eacute;poux, p&egrave;re, beau-p&egrave;re et grand-p&egrave;re.</p>\r\n<p dir=\"ltr\">Nous perdons tous en lui un ami tr&egrave;s cher.</p>\r\n<p dir=\"ltr\">Lucien &eacute;tait un homme d\'exception et de grande g&eacute;n&eacute;rosit&eacute; comme l\'a rappel&eacute; Fr&eacute;d&eacute;ric. Sa foi &eacute;tait immense et il ne se plaignait jamais m&ecirc;me quand il &eacute;tait soumis aux &eacute;preuves les plus intenses.</p>\r\n<p dir=\"ltr\">Sa m&eacute;moire restera parmi nous et nous sert d\'exemple.</p>\r\n<p dir=\"ltr\">Personnellement, je consid&egrave;re comme un privil&egrave;ge d\'avoir c&ocirc;toy&eacute; un tel homme. Je pense l\'avoir rencontr&eacute; pour la premi&egrave;re fois en 1978 dans le cadre de son activit&eacute; professionnelle. Il me parlait de ce &ldquo;syst&egrave;me de choses&rdquo; ce qui me fit penser qu\'il s\'agissait d\'un T&eacute;moin.</p>\r\n<p dir=\"ltr\">Vous pouvez &ecirc;tre fier de Lucien et vous rappeler que notre Dieu J&eacute;hovah n\'oubliera pas ses &oelig;uvres. Il le ressuscitera pour la vie &eacute;ternelle dans le Paradis.</p>\r\n<p dir=\"ltr\">Votre fr&egrave;re,</p>\r\n<p dir=\"ltr\">Bernard</p>\r\n<p><strong id=\"docs-internal-guid-75c16b93-9d09-567e-d190-1cb3bfb39517\"></strong><br class=\"Apple-interchange-newline\" /><br /></p>'),(307,83,'2013-10-07','Dr Arnaud LEROY\r\nDr De Monredon\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PREVOST Roger n&eacute; le 03/02/1941.</p>\r\n<p>Ce patient ancien fumeur 1 paquet/j est sevr&eacute; depuis 2009.Il totalise environ 45PA.</p>\r\n<p>Il s\'agit d\'un ancien militaire de carri&egrave;re ,ancien commercial.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une iltervention pour hernie inguinale droite.Il est trait&eacute; pour HTA,dyslipid&eacute;mie et lombosciatique L4L5 trait&eacute; par infiltration.</p>\r\n<p>Recemment M.Prevost a &eacute;t&eacute; hospitatis&eacute; pour PRN trait&eacute; par TEGELINE</p>\r\n<p>M.Prevost pr&eacute;sente un trouble ventilatoire obstructif GoldIV tr&egrave;s s&eacute;v&egrave;re avec un VEMS &agrave;,0.8 soit 25% de la norme et un Tiffeneau &agrave; 35% de la norme.Il s\'y ajoute une distension pulmonaire s&eacute;v&egrave;re avec VGT &agrave; 222% CPT &agrave; 137% et VR &agrave; 252%.La resistance des voies a&eacute;riennes est augment&eacute; &agrave; 0.81 avec TLCO &agrave; 62% soit existence de troubles du transfert.</p>\r\n<p>Sur le plan clinique il&nbsp;pr&eacute;sente une dyspn&eacute;e gradeIII de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>je demande un Scanner thoracique sans injection et une GDS &agrave; AA pour la prochaine consultation.</p>\r\n<p>M.Prevost poursuivra son traitement par VNI,OLD,Kin&eacute;sieth&eacute;rapie respiratoire ,Bronchodual 1X4,Seretide 500X2 et A&eacute;rosolttt (Bricanyl-Atrovent)x4.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(308,136,'2013-10-07','Dr Eric ALLANE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOYER Suzette Th&eacute;r&egrave;se n&eacute;e le 23/11/1933.</p>\r\n<p>Les IgE totales sont &agrave; 873UI/ml et son poids est de 50kilos ce qui correspond &agrave; 375 mg de XOLAIR toutes les deux semaines.Comme Mme Boyer ne fait plus de crises d\'asthme,elle pr&eacute;f&egrave;re arreter le XOLAIR.</p>\r\n<p>l\'auscultation pulmonaire retrouve ce jour un freinage expiratoire.</p>\r\n<p>Nous poursuivrons chez cette dame :A&eacute;rosolttt (Bricanyl-Atrovent)X2;pulmicortX2;Spiriva Respimat 2B/j et Kin&eacute;siettt Respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(309,493,'2013-10-07','Dr Bruno CADET\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. JULIENNE Toussaint n&eacute; le 01/11/1933.</p>\r\n<p>Ce monsieur est un ancien fumeur 1pqt/j sevr&eacute; depuis 1995.Il totalise 28PA.</p>\r\n<p>Il travaillait au CHD et &eacute;tait ancien militaire.Il est mari&eacute; et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne note rien de bien particulier.</p>\r\n<p>Il pr&eacute;sente des ronflements nocturnes avec un toux matinale et expectoration color&eacute;s et blanchatres assez abondants.</p>\r\n<p>Il dit ne pas etre dyspn&eacute;ique.</p>\r\n<p>L\'examen clinique montre un discret oed&egrave;me des M.I. avec &agrave; l\'auscultation quelques ronchi.</p>\r\n<p>L\'EFR montre une plethysmographie dans les limites de la normale;Sur le plan spirographique il existe une diminution mod&eacute;r&eacute;e des volumes et des d&eacute;bits avec un VEMS &agrave; 1.7 soit 71% de la norme;la CV est &agrave; 2.14 soit 66% de la norme.</p>\r\n<p>Il aura son scanner thoracique le 08/11/2013.</p>\r\n<p>Il poursuivra: FORADIL 1 gel m et s et ALVESCO 160 microg/j &nbsp;avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(310,149,'2013-10-07','Dr Lagarigue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ODULES JEAN FELIX n&eacute; le 04/08/1955.</p>\r\n<p>ce patient ancien fumeur sevr&eacute; depuis 2013 totalise environ 37PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un pontage aorto coronarien en 2012 par le Dr Braumberger.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade 2&nbsp;de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>L\'EFR retrouve un trouble ventilatire restrictif avec CPT &agrave; 57% VR &agrave; 60% .Le vEMS est &agrave; 1.67 soit 56% et le Tiffeneau &agrave; 98%.Le TDm thoracique montre un emphys&egrave;me pulmonaire avec distension pulmonaire.</p>\r\n<p>La GDS &agrave; AA montre pH 7.37 pCO2 43 &nbsp;TORR &nbsp;pO2 51 Torr SaO2 85%.</p>\r\n<p>Le patient est sous ONBREZ 300;Spiriva Respimat 2B Pulmicort1BX2 avec rin&ccedil;age et Kin&eacute;siettt respiratoire.</p>\r\n<p>Nous allons recontroler ses GDS &agrave; AA pour decider d\'une OLD Oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e et je reverrai M.Odules le 11/10/2013 &agrave; 9:30.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(311,530,'2013-10-07','Dr Didier RAZAKASOA\r\nDr MASCAREL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Melle RAJAONARISOA Olivia n&eacute;e le 08/01/1994.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour kyste &agrave; l\'oreille gauche.</p>\r\n<p>Depuis quelques temps elle se plaint g&egrave;ne respiratoire avec des picotements quand elle inspire.</p>\r\n<p>L\'examen clinique est dans les limites de la normale.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire mixte avec CPT &agrave; 55% VR &agrave; 68% de la norme.Le VEMS est &agrave; 39% ce qui fait que la patiente presente une composante obstructive Gold III S&eacute;v&egrave;re peu r&eacute;versible sous b2 inhal&eacute;s passant &agrave; 42% .Le tiffeneau est &agrave; 71% avec des VGT &agrave; 116%.Il existe par ailleurs il existe des troubles de la diffusion avec TLCO &agrave; 51% de la norme.</p>\r\n<p>Je l\'ai plac&eacute; &nbsp;sous ALVESCO 160 b/j avec FORADIl 1 gel inhal&eacute; m et s avec Kin&eacute;siettt respiratoire x3/semaine ;</p>\r\n<p>Je demande pour plus de pr&eacute;cision un scanner thoracique sans injection.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(312,530,'2013-10-07','','<p>Je soussign&eacute; Dr B.TANGUY certifie que</p>\r\n<p>&nbsp;</p>\r\n<p>Melle RAJAONARISOA Olivia n&eacute;e le 08/01/1994</p>\r\n<p>&nbsp;</p>\r\n<p>est venue me consulter ce jour;</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; St Denis le 07/10/2013.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(313,281,'2013-10-07','Dr ISSAC ISMAEL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. AKHOONE sulliman n&eacute; le 22/07/1933.</p>\r\n<p>Ce patient a &eacute;t&eacute; trait&eacute; pour une tuberculose pulmonaire latente alors qu\'il &eacute;tait sous anti-TNF alpha.</p>\r\n<p>Il s\'agissait d\'un ancien fumeur 1pqt/j sevr&eacute; depuis 1 an.Il totalise environ 60PA.</p>\r\n<p>Il est mari&eacute; et a 5 enfants.il, s\'agit d\'un ancien commercant.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; d\'une resection endoscopique de la prostate.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IIIde l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Le TDM thoracique montre de nombreuses bulles emphysemateuses dissemin&eacute;es dans les deux champs pulmonaires avec un nodule d\'1cm partiellement calcifi&eacute; du lobe moyen et qui sera &agrave; controler fin 2013.</p>\r\n<p>L\'EFr montre un trouble ventilatoire mixte,tr&egrave;s s&eacute;v&egrave;re Gold IV dans sa composante obstructive avec un VEMS &agrave; 0.70 soit 28&ugrave; et un Tiffeneau &agrave; 78%.Il existe une distension pulmonaire avec VR &agrave; 139% et VGT &agrave; 108%.</p>\r\n<p>L\'Hct est &agrave; 38.5% avec des GDS :pH7.43 pO2:75Torr pCO2 38Torr SaO2 95%.</p>\r\n<p>Il convient de poursuivre:O?NBREZ 300;Spiriva Respimat 2B;aerosolth&eacute;rapie (Bricanyl-Atrovent)X3 PulmicortX2 rin&ccedil;age;Kin&eacute;sietttrespiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(314,54,'2013-10-07','Dr Low Hong\r\nARAR','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. FENELON Charlemagne n&eacute; le 18/07/1937.</p>\r\n<p>Il s\'agit d\'un ancien fumeur sevr&eacute; en 1994.Il fumait un demi Pqt/j et totalise environ 20PA.Il exercait la profession de macon et il est divorc&eacute;.il a eu 9 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une proth&egrave;se de hanche droite et une fracture de la jambe gauche et intervention sur la rotule gauche.Il est trait&eacute; pour DID.Il est &eacute;galement suivi pour troubles trophiques avec ulc&egrave;res &nbsp;des M.I.en Dermatologie au CHU de Bellepierre.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute;s depuis plusieurs ann&eacute;es.Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council. &nbsp;</p>\r\n<p>M.Fenelon pr&eacute;sente des ronflements et a un sommeil de mauvaise qualit&eacute;.Son Score de Mallampati est &agrave; 3 eavec un score d\'Epworth &agrave; 5/6explor&eacute;.L\'IMC est de 26.2 ce qui correspond &agrave; un surpoids.l\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>L\'EFR a montr&eacute; un trouble Ventilatoire Obstructif GOLD IV tr&egrave;s s&eacute;v&egrave;re &nbsp;avec un VEMS &agrave; 0.8 soit 27% et un Tiffeneau &agrave; 51%.La TLCO est &agrave; 44%.La radiographie thoracique retrouve une distension thoracique avec deformation et aplatissement des coupoles diaphragmatiques et des grosses art&egrave;res pulmonaires. &nbsp;L\'Hct est &agrave; 44.2% avec &agrave; la GDS AA:ph 7.4 pO2 64 Torr pCO2:55 Torr SaO2:92%.</p>\r\n<p>la polygraphie Nocturne r&eacute;alis&eacute;e le 24/09/2013 montre 271 ronflements/h avec une energie moyenne de 86dB ce qui correspond au bruit d\'un aspirateur. L\'IAH est de 8/h mais passe &agrave; 28/h quand on y ajoute les &eacute;venements respiratoires. &nbsp;Dans ces conditions nous pr&eacute;voyons une Polysomnographie que M.Fenelon aura le 28/01/2013. &nbsp;</p>\r\n<p>En attendant il poursuivra ONBREZ 300 1B/j,Spiriva Respimat 2B/j OLD; &nbsp; A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X2/j et Kin&eacute;siettt respiratoire .Vaccination antigrippale annuelle et Pneumo 23 tous les 5 ans. &nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p>\r\n<p>&nbsp;</p>'),(315,270,'2013-10-07','Dr Eric BOURDAIS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme AMACOUTY marie angele n&eacute;e le 13/10/1939.</p>\r\n<p>Cette est divorc&eacute;e et a 2 enfants.Elle &eacute;tait femme de m&eacute;nage.</p>\r\n<p>Elle fumait quelques cigarettes /j et est sevr&eacute; depuis plusieurs ann&eacute;es.Elle cuisinait au feu de bois dans sa jeunesse.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e de la cataracte.Elle est suivie pour DNID,HTA et m.de Parkinson;</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; depuis plusieurs ann&eacute;es avec hospitalisation au CHU de Bellepierre.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.Sa SaO2 &agrave; AA est &agrave; 89%.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire de nature mixte avec une composante obstructive Gold III s&eacute;v&egrave;re.Le VEMS est &agrave; 0.62 soit 41% de la norme partiellement r&eacute;versible sous b2 inhal&eacute;s passant &agrave; 0.68 soit un gain de 10%. Le Tiffeneau est &agrave; &nbsp;&agrave; 90% de la norme.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec une GDS &agrave; AA.</p>\r\n<p>En attendant elle poursuivra OLD,kin&eacute;siettt respiratoire;innovair 2BX2 &agrave; l\'aide d\'une chambre d\'inhalation;spiriva Respimat 2B/J;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(316,126,'2013-10-07','Dr Jatob\r\nARAR','<p>Cher Ami,</p>\r\n<p>J\'ai vu ce jour Mme ELLAMA Angelina n&eacute;e le 25/02/1937.</p>\r\n<p>Cette dame ,veuve,4enfants,ex-commercante est non fumeuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une c&eacute;sarienne .Elle est trait&eacute;e pour DNID,hypothyroidie,HTA,SAS,st&eacute;nose carotidienne interne droite de 50% ,goutte,un goitre cervical.On note un AVC isch&eacute;mique en 2008,le Chikungunia en 2004,une cholecystite aigue en 2009.Elle a par ailleurs &eacute;t&eacute; trait&eacute;e par MEDIATOR et pr&eacute;sente une arthrose des 2 hanches ce qui ne lui permets de se d&eacute;placer facilement.</p>\r\n<p>Mme Ellama pr&eacute;sente un poids de 84 Kilos pour une taille de 1m57 avec un IMC &agrave; 34.1 ce qui corresponds &agrave; une ob&eacute;sit&eacute; moder&eacute;e.Elle pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council.&nbsp;Le perim&egrave;tre cervical est &agrave; 41 cm avec un perim&egrave;tre abdominal de 122 cm.Le Score d\'Epworth est de 23/24 avec un&nbsp;&nbsp;score de Mallampati est de 3 /4.L\'auscultation pulmonaire est sans grande particularit&eacute;.</p>\r\n<p>Les GDS &agrave; AA montrent:pH 7.41 pO2 :81 Torr pCO2:35 Torr;SaO2:96%.l\'EFR montre un trouble ventilatoire restrictif s&eacute;v&egrave;re avec CPT &agrave; 31% VR &agrave; 12% VGT &agrave; 83%.Le VEMS est &agrave; 1.12 soit 66% et le Tiffeneau &agrave; 94%.</p>\r\n<p>Je demande ce jour une radiographie thoracique et je reverrai Mme Ellama le 21/10/2013 pour une polygraphie nocturne.En attendant elle poursuivra:A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3/j pulmicortX2 avec rin&ccedil;age;Onbrez 300/j;kin&eacute;siettt respiratoire et PPC .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(317,126,'2013-10-07','','<p>Je soussign&eacute; Dr B.TANGUY</p>\r\n<p>certifie que Mme ELLAMA Angelina n&eacute;e le 25/02/1937 pr&eacute;sente un handicap respiratoire s&eacute;v&egrave;re.</p>\r\n<p>&nbsp;</p>\r\n<p>son taux d\'IPP est estim&eacute;e &agrave; 85%;</p>\r\n<p>&nbsp;</p>\r\n<p>fait &agrave; Saint Denis le 07/10/2013.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Dr B.TANGUY.</p>'),(318,293,'2013-10-07','Dr MOREAU','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. VALERY Lucas n&eacute; le 23/06/1940.</p>\r\n<p>Ce monsieur ancien fumeur sevr&eacute; depuis 15 ans fumait 3 cigarettes/jour;Il est veuf 8 enfants.il travaillait comme macon-coffreur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour UGD,an&eacute;vrysme aortique,genou gauche.Il est trait&eacute; pour HTA,DID.Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Le score de Mallampati est de 3/4.Son poids est de 111kilos pour une taille de 1m67 soit un IMC de 39.8 ce qui correspond &agrave; une ob&eacute;sit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique retrouve une d&eacute;formation avec abaissement des coupoles diagphragmatiques avec d&eacute;roulement de la ligne paraaortique gauche La SCV est augment&eacute;e de volume.</p>\r\n<p>L\'EFR pratiqu&eacute;e ce jour montre un trouble ventilatoire restrictif avec CPT &agrave; 57% VR &agrave; 59%;Le VEMS est &agrave; 1.84 soit 71% de la nor&ugrave;me;le tiffeneau est &agrave; 91&ugrave; de la norme.J\'ai demand&eacute; une GDS &agrave; AA que le malade n\'a pas encore eu.</p>\r\n<p>Il convient de poursuivre chez lui:kin&eacute;siettt respiratoire ;Onbrez 150 microg/j Spiriva Respimat 2B/j et OLD de confort.M.VALERY aura une polygraphie nocturne le 11/12/2013.&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(319,148,'2013-10-07','Dr Francis COLIN\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LARAVINE Ange n&eacute;e le 14/10/1943.</p>\r\n<p>Cette dame est divorc&eacute; et a 5 enfants.Elle &eacute;tait femme de m&eacute;nage.</p>\r\n<p>Mme laravine est une fumeuse 1pqt/j qui continue de fumer 5 cigarettes/j.Elle totalise environ 50PA.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Medical Research Council avec toux et crachats blanchatres.</p>\r\n<p>L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires stethacoustiques.</p>\r\n<p>Je demande un scanner thoracique sans injection.Sa GDS &agrave; AA montre pH 7.41 pO2:55torr pCO2:50Torr SaO2:93%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire Obstructif Gold II/III s&eacute;v&egrave;re avec un VEMS &agrave; 0.83 soit 62&ugrave; Le Tiffeneau est &agrave; 73% et il existe une distension pulmonaire:VGT &agrave; 158% CPt &agrave; 117% et VR &agrave; 170%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.15 avec trouble de la diffusion: TLCO &agrave; 60% de la norme.</p>\r\n<p>il convient que Mme Laravine cesse compl&egrave;tement de fumer et poursuive:OLD,a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 Innovair 1B X2 &agrave;l\'aide d\'une chambre d\'inhalation,onbrez 300/j et kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(320,141,'2013-12-30','Dr LECAPLAIN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LASSON Isabelle n&eacute;e le 26/12/1938.</p>\r\n<p>Son asthme est actuellement bien control&eacute;.</p>\r\n<p>Je lui renouvelle XOLAIR 150mg /mois associ&eacute; &agrave; Singulair 10mg et symbicort 400 1B le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(321,456,'2013-10-07','Dr ISSAC ISMAEL\r\nDr MOULS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. QUEDEMER Roger n&eacute; le 17/01/1939.</p>\r\n<p>Ce monsieur ancien gendarme ,ancien policier &agrave; la retraite depuis 1995 vit &agrave; l\'Ile Maurice depuis 2003,6 mois dans l\'ann&eacute;e et 3 mois &agrave; la r&eacute;union et en metropole.</p>\r\n<p>Il s\'agit d\'un ancien gros fumeur totalisant plus de 50PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,d\'une fistule anale,une prostatectomie pour cancer en 2005,une angioplastie coronarienne avec pose de 2 stents en 2003 &agrave; Brest.en 2004 pose d\'un nouveau stent coronarien &agrave; Montpellier.de plus il a &eacute;t&eacute; trait&eacute; pour DDB &agrave; 10-11 ans trait&eacute; &agrave; la Bourboule.</p>\r\n<p>sur le plan m&eacute;dicamenteux M.QUEMENER prend de l\'ADANCOR 20 mg le m et 10 mg le s;XARELTO 20 mg;ELISOR 40mg le s;XALATAN gtes ds chq oeil.OMEPRAZOLE.</p>\r\n<p>Au mois de juin 2013 on lui d&eacute;couvre une pneumopathie infiltrante diffuse &agrave; la suite d\'une toux s&eacute;che ,invalidante.</p>\r\n<p>il pr&eacute;sentait une f&eacute;bricule le soir avec amaigrissement de 8 kilos depuis le mois de juin 2013.</p>\r\n<p>l\'auscultation pulmonaire retrouve des crepitants aux 2 bases avec ce jour un d&eacute;but d\'hippocrate digital qui n\'&eacute;tait pas signal&eacute; au mois de mai 2013.</p>\r\n<p>le scanner thoracique du 30/09/2013 compar&eacute; &agrave; celui du 18/10/2012 montre une r&eacute;gression des ad&eacute;nopathies m&eacute;diastinales au niveau de la loge de Barety et ant&eacute;rieur.La fibrose pulmonaire des lobes inf&eacute;rieurs est retrouv&eacute;.</p>\r\n<p>Une fibroscopie bronchique avait &eacute;t&eacute; pratiqu&eacute; le 22/05/2013 avec LBA.Sur le plan anatpath on notait l\'absence d\'&eacute;lement suspect de malignit&eacute;;la recherche de BK &eacute;tait n&eacute;gative &agrave;l\'examen direct et &agrave; la culture;la formule liquidienne retrouvait:80 leucocytes/mm3;PNNeutro 40% PN eosino 2% Lymphocytes 10% Macrophages 48%;Recherche aspargillius n&eacute;gative;Recherche Bk sur aspiration tracheobronchique n&eacute;gatif ex direct et culture.</p>\r\n<p>Ph&eacute;notypage non r&eacute;alis&eacute;.</p>\r\n<p>BGSA biopsie des glandes salivaires accessoires mod&eacute;r&egrave;ment inflammatoires avec infiltrat grade2 selon le score de Chisholm.</p>\r\n<p>serologie m;du poumon d\'eleveurs d\'oiseaux n&eacute;gatif;m.du poumon du fermier 1 arc de precipitation:recherche anticorps actinomyc&egrave;tes thermophiles n&eacute;gatif;autoanticorps anti nucl&eacute;aires n&eacute;gatifs;anticorps des myosites n&eacute;gatifs;</p>\r\n<p>Enzyme de conversion de l\'angiotensine :75U.ACE le 29/05/2013 passant &agrave; 33UECA le 01/10/2013.Transaminases N;Creatinine 108 micro mol/L.Hepatite B et C n&eacute;gatif.</p>\r\n<p>L\'examen ophtalmologique a &eacute;t&eacute; r&eacute;alis&eacute; &agrave; Montpellier et aurait &eacute;t&eacute; normale si ce n\'est une catarcte qui a donn&eacute; lieu &agrave; un traitement de l\'oeil gauche avec traitement pr&eacute;ventif d\'un glaucome.</p>\r\n<p>Une corticoth&eacute;rapie Solupred 60 mg le matin a &eacute;t&eacute; d&eacute;marr&eacute; le 28/07/2013 pass&eacute; &agrave; 40 mg le 08/09/2013 et &agrave; 30 mg le 01/10/2013.Le patient se sent mieux depuis.<br />Je demande ce jour Anticorps anti SSA,anti SSB,CPK,Anticorps anti synth&eacute;tases,et ANCA.et je programme une EFR le 14/10/2013 ainsi qu\'une electrophor&egrave;se des prot&eacute;ines s&eacute;riques.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(322,55,'2013-10-07','Dr CHARLETTE-LIMBE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BENARD Frederic Marc n&eacute; le 20/01/1945.</p>\r\n<p>Ce monsieur ancien marin est c&eacute;libataire sans enfant.</p>\r\n<p>Il est ancien fumeur 1 &agrave;3paquets/jour,totalisant plus de 50PA il est sevr&eacute; depuis 1991.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une adenectomie prostatique en 2012 et un UGD.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont commenc&eacute; dans les ann&eacute;es 1980.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi et sibilances aux deux bases.</p>\r\n<p>L\'EFR pratiqu&eacute; le 09/08/2013 montre une spirographie dans les limites de la normale.La plethysmographie retrouve une distension pulmonaire avec VGT&agrave; 112% CPT &agrave; 109% et VR &agrave; 103% de la norme.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Je demande un scanner thoracique sans injection que le patient vous emmenera.</p>\r\n<p>Il convient de poursuivre chez lui:Onbrez 300;Spiriva Respimat 2b/j et Alvesco 160 1B avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(323,81,'2013-10-08','Dr PRACISNORE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MAILLOT DIDIER MAURICE n&eacute; le 02/07/1967.</p>\r\n<p>Ce monsieur mari&eacute;,un enfant ancien eboueur est actuellement sans travail.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fr&egrave;re et une soeur asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on retrouve une op&eacute;ration des deux &eacute;paules pour luxation.</p>\r\n<p>il est trait&eacute; pour HTA,hypercholesterol&eacute;mie;</p>\r\n<p>Il est ronfleur et pr&eacute;sente une hypersomnie diurne.Son score d\'Epworth est &agrave; 16/21;</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeIIIde l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>M.maillot pr&eacute;sente un poids de 100Kilos pour une taille de 1m70 soit un IMC &agrave; 34.6 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;.L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Son asthme est bien control&eacute; .</p>\r\n<p>Nous allons lui pratiquer une Polygraphie nocturne le 17/12/2013 &agrave; 16:00.</p>\r\n<p>Les IgE totales sont &agrave; 265UI/ml et les RAST montre une allergie Classe 4 au phan&egrave;res de chien.</p>\r\n<p>M. Maillot poursuivra FORADIL ,MIFLONIL.Je lui ai conseill&eacute; de se d&eacute;barasser de son chien.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(324,234,'2013-10-08','Dr Kon Sun Tack','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PEROUMAL ELLAMA Ange Marie C&eacute;line n&eacute;e le 14/12/1933.</p>\r\n<p>Cette dame c&eacute;libataire sans enfant,est non fumeuse.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents familiaux on note un gradp&egrave;re et une grandm&egrave;re ainsi qu\'un fr&egrave;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie et une brulure par l\'alcool.Elle est &eacute;galement trait&eacute; pour HTA et diab&egrave;te.</p>\r\n<p>Elle pr&eacute;sente un asthme depuis l\'enfance.</p>\r\n<p>Cette asthme est actuellement bien cotrol&eacute; par Seretide 250 1BX2 &agrave; l\'aide d\'une chambre d\'inhalation,Singulair 10mg/j (et Doliprane1000 mg si cephal&eacute;es).</p>\r\n<p>Son bilan cardiologique d&eacute;but aout(Dr AhMouck) &eacute;tait normal.</p>\r\n<p>ce jour auscultation pulmonaire normale.</p>\r\n<p>Les EFR montre une spirographie normale avec toutefois augmentation de la resistance des voies a&eacute;riennes &agrave; 0.68 et augmentation de la VGT&agrave; 114% de la norme pouvant traduire un d&eacute;but de distension pulmonaire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(325,129,'2013-10-08','Dr MAIGRAT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LEBON Marie Huguette n&eacute;e le 24/07/1960.Mme Lebon est mari&eacute; et a 3 filles.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note des interventions pour hernie abdominale,&eacute;ventration abdominale,hernie discale,canal carpien de la main gauche,3 &nbsp;c&eacute;sariennes.Elle est trait&eacute; pour DNID.</p>\r\n<p>Son asthme a d&eacute;but&eacute; dans l\'enfance .Elle a &eacute;t&eacute; &nbsp;trait&eacute; par d&eacute;sensibilisation.</p>\r\n<p>Elle pr&eacute;sente une symptomatologie de reflux gastro oesophagien.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Mme LEBON pr&eacute;sente un poids de 68Kilos pour une taille de 1m45 soit un IMC de 32.3 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e. Son score d\'Epworth est de 10/24 avec un&nbsp;&nbsp;score de Mallampati est de 3 /4. Elle aura une polygraphie nocturne le 23/10/2013 &agrave; 16:00.</p>\r\n<p>&nbsp;Ses EFR du 13/08/2013 sont dans les limites de la normale si ce n\'est une petite distension pulmonaire.</p>\r\n<p>Son asthme est actuellement bien stabilis&eacute; mais elle a tendance &agrave; oublier de prendre son traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(326,57,'2013-10-08','Dr CHECKOURI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PERRAULT Marie Leonie n&eacute;e le 03/08/1953.</p>\r\n<p>Cette dame c&eacute;lbataire a eu 3 enfants dont un d&eacute;c&eacute;d&eacute;.</p>\r\n<p>Elle &eacute;tait barmaid et est actuellement sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une appendicectomie et une hysterectomie pour fibrome.</p>\r\n<p>Son asthme a d&eacute;but&eacute; dans l\'enfance avec regression et resurvenue &agrave; la naissance de sa fille il y a 38 ans.</p>\r\n<p>elle rel&egrave;ve d\'une grippe s&eacute;v&egrave;re et n\'a pas &eacute;t&eacute; vaccin&eacute; cette ann&eacute;e contre la grippe.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade I de l\'&eacute;chelle du Modified Medical Research Council avec difficile le matin au r&eacute;veil c&eacute;dant aux bronchodilatateurs.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif s&eacute;v&egrave;re Gold IIi avec VEMS &agrave; 0.92 soit 40% de la norme et un Tiffeneau &agrave; 64%.Il existe une augmentation de la resistance des voies a&eacute;riennes avec RVA &agrave; 1.2.</p>\r\n<p>Son ttt actuel kin&eacute;siettt respiratoire 3 X/semaine;A&eacute;rosolttt (Bricanyl-Atrovent)X3/j Seretide 500 2BX2 avec rin&ccedil;age ;a&eacute;rius ;XOLAIR 450 mg toutes les 2 semaines;singulair 10 mg le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(327,455,'2013-10-08','Dr Ssi Yan Kay\r\nDr Mascarel','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ARMOUGOM Ghislaine n&eacute;e le 12/09/1946.</p>\r\n<p>Cette dame sans profession est non fumeuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour goitre thyroidien par le Dr Wan Hoi.</p>\r\n<p>Elle est trait&eacute; pour HTA.Elle a eu le Chikunguya il y a 6 ans et depuis elle ressent des douleurs articulaires et une fatiguabilit&eacute;.</p>\r\n<p>Depuis 4 mois Mme Armougom ressent une douleur thoracique ant&eacute;rieure droite sans irradiation .</p>\r\n<p>Cette douleur est isol&eacute;e et &nbsp; le bilan biologique &nbsp;pratiqu&eacute; est assez rassurant.</p>\r\n<p>Nous allons demander un scanner thoracique avec injection et je reverrai cette dame par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(328,363,'2013-10-08','Dr Mosello','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme POSEE Blanche n&eacute;e le 01/01/1924.</p>\r\n<p>Cette dame est veuve et a eu 9 enfants.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une arthrose g&eacute;n&eacute;ralis&eacute;e.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute; pour insuffisance respiratoire il y a environ 3 ans.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.On note une cyphose dorsale mod&eacute;r&eacute;e.</p>\r\n<p>La radiographie thoracique une distension thoracique avec aplatissement des coupoles diaphragmatiques.</p>\r\n<p>L\'EFR objective une spirographie dans les limites de la normale.La plethysmographie montre des signes de distension pulmonaire avec VGT &agrave; 165% CPT &agrave; 127% et VR &agrave; 154% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.02.</p>\r\n<p>Elle poursuivra son traitement actuel :A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3;Spiriva Respimat2B/j seretide 500 1BX2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(329,335,'2013-10-08','Dr PONROUCH\r\nDr Wan HOI','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAMCHELAWON M Pierre n&eacute;e le 02/06/1946.</p>\r\n<p>Cette dame est enseignante &agrave; la retraite.Mari&eacute; et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une coqueluche dans l\'enfance.</p>\r\n<p>Elle pr&eacute;sente des infections bronchiques &agrave; repetition depuis toujours.</p>\r\n<p>Un Scanner thoracique a &eacute;t&eacute; pratiqu&eacute; le 17/09/2012 et a r&eacute;v&egrave;l&eacute; un syndrome bronchique des deux pyramides basales ainsi qu\'une hepatom&eacute;galie.</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour montre :Spirographie dans les limites de la normale.plethysmographie:trouble ventilatoire Restrictif avec CPT &agrave; 84% et VR &agrave; 68% de la norme.La TLCO est dans les limites de la normale.</p>\r\n<p>Le scanner encephalique retrouve une sinusite shenoidale gauche qui devra etre trait&eacute;e apr&egrave;s avoir rechercher un foyer dentaire en pratiquant un panorex dentaire.de meme je conseille un bilan biologique h&eacute;patique.</p>\r\n<p>Entre temps Mme RAMCHELAWON poursuivra l\'a&eacute;rosolth&eacute;rapie Bicarbonate14% et zithromax 250 mg X3/semaine avec ELUDRIL.Elle consultera le Dr Wan Hoi.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(330,475,'2013-10-08','Dr BESNARD\r\nSt PAUL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LAMBES Bernadatte n&eacute;e le 16/04/1944.</p>\r\n<p>Cette dame est divorc&eacute; et a 3 enfants.Elle travaillait au CHGM et est retrait&eacute;e.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une hallux valgus en f&eacute;vrier 2013 et une appendicectomie.</p>\r\n<p>Elle pr&eacute;sente des brulures gastriques le soir.</p>\r\n<p>Depuis son divorce elle des difficult&eacute;s pour s\'endormir.Elle ne pr&eacute;sente pas de ronflement ni de pauses respiratoires.</p>\r\n<p>Elle pr&eacute;sente 3 &agrave; 4 nyctiuries par nuit.Son score d\'Epworth est de 5/24.</p>\r\n<p>Le score de Mallampati est de 1 /4.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.Toutefois elle se plaint de constipation et de brulures d\'estomac.</p>\r\n<p>Nous allons l\'instruire &agrave; remplir un agenda &nbsp;de sommeil.</p>\r\n<p>Je la reverrai pour une polygraphie nocturne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(331,429,'2013-10-08','',''),(333,150,'2013-10-09','Dr DABEE\r\nMme Gossard\r\nrespidom','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. AMOURGOM Francis, n&eacute; le 09/10/1940.</p>\r\n<p>Malheureusement je ne suis plus &agrave; l\'hopital et je ne puis garantir que M.AMOURGOM puisse &nbsp;etre hospitalis&eacute; du 21 au 29/12/2013 dates de &nbsp;vacances de la famille d\'accueil.Le mieux est de le laisser rentrer chez lui pendant cette p&eacute;riode ou de n&eacute;gocier une hospitalisation sur St Benoit ou Saint Andr&eacute;.</p>\r\n<p>Ce monsieur est mari&eacute; et a 4 enfants.il exercait la profession de macon.Dans ses ant&eacute;c&egrave;dents on note un tabagisme difficile &agrave; &eacute;valuer.Sur le plan clinique on note&nbsp;&nbsp;une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council avec une douleur du membre sup&eacute;rieur gauche et de la r&eacute;gion thoracique lat&eacute;rale gauche.Le tout accompagn&eacute; d\'une par&eacute;sie gauche.Le patient se d&eacute;place &agrave; l\'aide d\'une canne.Je pense qu\'un IRM c&eacute;r&eacute;bral d\'&eacute;valuation ainsi qu\'une echocardiographie seraient utiles et je vous laisse programmer ces examens.</p>\r\n<p>La radiographie thoracique avait montr&eacute; des signes de distension thoracique avec des grosses art&egrave;res pulmonaires .on notait und&eacute;roulement de la ligne paraaortique gauche avec une calcification aortique.</p>\r\n<p>L\'EFR du 22/08/2013 montrait un trouble ventilatoire obstructif tr&egrave;s s&eacute;v&egrave;re Gold IV avec un VEMS &agrave; 0.43 soit 15% de la norme;Le Tiffeneau &eacute;tait &agrave; 46%.La GDS &agrave; AA PH 7.48 pCO2 47Torr pO2 70Torr SaO2 &nbsp;94%.</p>\r\n<p>Il convient de poursuivre chez ce patient:A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 Spiriva Respimat 2B;Onbrez 300/j;OLD;kin&eacute;siettt respiratoire;Clinutren 1X3;Cetornan 5g 1X2.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(334,555,'2013-10-09','Dr PILLAY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. GAY Wilson, n&eacute; le 01/06/1961.</p>\r\n<p>Ce monsieur est un ancien fumeur 5 &agrave; 6 cigarettes/j sevr&eacute; depuis le 01/10/2013.Il a fum&eacute; jusqu\'&agrave; 1 paquet /jour et totalise environ 30PA.M.gay est employ&eacute; de banque.Il est mari&eacute; et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note des fractures du poignet droit et de la cheville droite.Il est trait&eacute; pour HTA.</p>\r\n<p>M.Gay a pris froid en Suisse le 26/09/2013.Il a pr&eacute;sent&eacute; une forte fi&egrave;vre et a rentr&eacute; &agrave; la R&eacute;union le 29/09/2013.M.Gay a &eacute;t&eacute; trait&eacute; par AUGMENTIN le 05/10/2013.</p>\r\n<p>ce jour o,n note une SaO2 &agrave; 97% &agrave; AA avec un pouls &agrave; 88.sa TA est 10/7.</p>\r\n<p>L\'auscultation pulmonaire montre des ronchi en particulier &agrave; la base gauche.</p>\r\n<p>La radiographie thoracique montre un e opacit&eacute; de la base gauche avec un &eacute;panchement pleural gauche qui s\'est cloisonn&eacute;.La NFS montre une hyperleucocytose avec polynucl&eacute;ose neutrophile.La cr&eacute;atinine est &agrave; 121mmicromol/l.La CRP est &agrave; 270.</p>\r\n<p>Je pense que M.Gay a pr&eacute;sent&eacute; une pneumopathie de la base gauche probablement &agrave; ^pneumocoque compliqu&eacute; de pleur&eacute;sie purulente peu abondante qui s\'est cloisonn&eacute;.</p>\r\n<p>il convient de renforcer l\'antibioth&eacute;rapie en adjoinant de la ROVAMYCINE &agrave; l\'AUGMENTIN tout en associant une a&eacute;rosolth&eacute;rapie (BRICANYL-ATROVENT)x2 et surtout une Kin&eacute;sieth&eacute;rapie respiratoire centr&eacute; sur l\'hemicoupole diaphragmatique gauche.</p>\r\n<p>Une NFS/CRP de surveillance s\'impose dans les 48H.En cas d\'aggravation une hospitalisation s\'imposera.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(335,99,'2013-10-09','Dr TORRE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. SOLIMAN Eugene n&eacute; le 12/12/1945.</p>\r\n<p>Ce monsieur est un ancien fumeur sevr&eacute; depuis 11 ans. Il fumait jusqu\'&agrave; 2 pqt/j et totalise pr&egrave;s de 50PA.</p>\r\n<p>il exercait la profession de plombier -electricien. Il est mari&eacute; et a 5 enfants.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note un d&eacute;but de diab&egrave;te et un AVC en 2004 avec hemipar&egrave;sie du MSGauche.</p>\r\n<p>M.Soliman a fait une chute le 03/08/2013 et a pr&eacute;sent&eacute; une fracture sans d&eacute;placement de la 10e et de la 11e cote droite. Il a &eacute;t&eacute; trait&eacute; par contention thoracique et Dafalgan cod&eacute;in&eacute;.</p>\r\n<p>Le patient pr&eacute;sente &nbsp;une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'EFR du 12/08/2013 retrouvait un trouble ventilatoire Obstructif Gold IV avec un VEMS &agrave; 0.75 soit 27% de la norme. Le Tiffeneau &eacute;tait &agrave; 61% avec une distension pulmonaire:VGT &agrave; 116% VR &agrave; 142%. La resistance des voies a&eacute;riennes est augment&eacute;e &agrave; 1.27 sans trouble du transfert.Sa SaO2 est ce jouir &agrave; 97% &agrave; AA.</p>\r\n<p>L\'&eacute;pouse de M. Solliman se plaint qu\'il pr&eacute;sente des ronflements. Il pr&eacute;sente 3 nyctiuries.</p>\r\n<p>Le score de Mallampati est de 3 /4.Le score d\'Epworth est &agrave; 12/24.</p>\r\n<p>Nous allons programmer une polygraphie nocturne le 20 janvier 2014.</p>\r\n<p>Il poursuivra la kin&eacute;siettt respiratoire associ&eacute; &agrave; a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 et onbrez 150/j et pulmicortX2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(336,559,'2013-10-09','Dr Bobate\r\nDr Ramgoolam\r\nQ.Bornes\r\nDr Gazaille\r\nDr Schlossmacher\r\nService de Pneumologie \r\nCHU de Saint Denis','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme JOOMUN EADALLY Bibi Seereen, n&eacute;e le 30/04/1959</p>\r\n<p>Cette dame est non fumeuse et &agrave; la R&eacute;union depuis le 06/10/2013 en vacances chez son fils.Elle est mari&eacute; et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note 3 c&eacute;sariennes et une ligature de la trompe;</p>\r\n<p>Cette dame est asthmatique.</p>\r\n<p>Au mois d\'aout 2013 elle a ressentie une douleur dorso lat&eacute;rale gauche avec dyspn&eacute;e.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e &agrave; l\'Hopital de Flacq puis de Poudre d\'OR ou on a mis en &eacute;vidence un &eacute;panchement pleural gauche sero-sanguin.Des cellules carcinomateuses y auraient &eacute;t&eacute; mises en &eacute;vidence.la famille a jug&eacute;e bon de la faire venir &agrave; la R&eacute;union ou le fils r&eacute;side depuis 1998.</p>\r\n<p>Un scanner thoraco-abdomino-pelvien a &eacute;t&eacute; pratiqu&eacute; le 07/10/2013 et a montr&eacute; un &eacute;paississement de la pl&egrave;vre diaphragmatique gauche .</p>\r\n<p>Mme Joomun a consult&eacute;e le Dr Moreau (Gynecologue) qui a retrouv&eacute;e une image ovarienne liquidienne gauche pour laquelle elle a demand&eacute;e un IRM pelvien.La mammographie a montr&eacute; un ACR1 droit et ACR2 gauche.</p>\r\n<p>J\'adresse Mme Joomun au Drs gazaille et Schlossmacher pour r&eacute;aliser une fibroscopie bronchique voir une ponction pleurale et essayer d\'obtenir un diagnostic histologique pr&eacute;cis.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(337,123,'2013-10-09','Dr Bertaut','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GROENDU Marie Antoinett n&eacute;e le 24/08/1958.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un p&eacute;re asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on ne note rien de particulier si ce n\'est un asthme existant depuis l\'enfance.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e plusieurs fois pour asthme.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR, son asthme est bien control&eacute;.&nbsp;</p>\r\n<p>Ce jour l\'auscultation pulmonaire est normale.</p>\r\n<p>L\'EFR pratiqu&eacute; le 21/08/2013 montrait un trouble ventilatoire obstructif Gold i avec un VEMS &agrave; 1.45 soit 71% de la norme.Le Tiffeneau &eacute;tait &agrave; 76% de la norme.</p>\r\n<p>Je lui renouvelle ce jour le XOLAIR 300mg 1amp/mois en S/C .Elle prend &eacute;galement Flixotide 1BX2 avec rin&ccedil;age ,Singulair 10mg ,Xyzall 1 cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(338,221,'2013-10-09','Dr ALLANE','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DELETRE Marie Claude n&eacute;e le 02/05/1963.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une cholecystectomie,intervention pour canal carpien de la main droite et des hemorroides.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e plusieurs fois pour asthme.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR 150mg/mois,a&eacute;rosolth&eacute;rapie,son asthme est bien stabilis&eacute;.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif mod&eacute;r&eacute; avec un VEMS &agrave; 1.68 soit 73% de la norme,non r&eacute;versible sous b2 inhal&eacute;s.Il existe des signes de distension pulmonaire avec un VGT &agrave; 170% CPT 133% et Vr &agrave; 210% de la norme.Les resistances des voies a&eacute;riennes sontb augment&eacute;es &agrave; 0.58,sans trouble de la diffusion.</p>\r\n<p>Je conseille d\'adjoindre du Spiriva Respimat 2B/j au traitement et de pratiquer une radiographie thoracique.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(339,5,'2013-10-09','Dr Kapler','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme VELLEYEN Charlotte n&eacute;e le 07/04/1925.</p>\r\n<p>Cette est veuve et a 2 enfants.Elle travaillait comme femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une HTA.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; en 2012 avec une infection pulmonaire pour laquelle elle a &eacute;t&eacute; hospitalis&eacute;e au CHU de Bellepierre actuellement sa SaO2 est &agrave; 88% &agrave; AA.&nbsp;</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e gradeIII &nbsp;de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'examen clinique retrouve une cyphoscoliose avec &agrave; l\'auscultation pulmonaire quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique a montr&eacute; une cyphoscoliose avec calcification aortique et aplatissement des coupoles diaphragmatiques.Sur le plan biologique l\'Hb est &agrave; 13.8g/dl avec un Hct &agrave; 43%.</p>\r\n<p>La GDS &agrave; aa retrouve pH 7.43 pO2 76Torr, pCO2 38Torr SaO2 95%.</p>\r\n<p>Sous traitement son &eacute;tat s\'est amelior&eacute;.elle poursuivra:</p>\r\n<p>A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)x3/j PulmicortX2 &nbsp;et Kin&eacute;siettt Respiratoire 3 s&eacute;ances / semaine .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(340,90,'2013-10-09','Dr Say Liang Fat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ATCHAMA Yoland n&eacute; le 07/06/1969.</p>\r\n<p>il poursuivra:</p>\r\n<p>Kin&eacute;siettt respiratoire et de la colonne lombaire\'douleur rachidienne s&eacute;quellaires) 5 jours / semaine</p>\r\n<p>Aerius 5mg;Eludril gargarisme m et s ;Onbrez 300/j;Spiriva Respimat 2b/j;A&eacute;rosolttt (Bricanyl-Atrovent)X4/j;a&eacute;rosolttt PulmicortX2/j;Singulair 10mg/j;Rhinocort 1X2 avec rin&ccedil;age.</p>'),(341,154,'2013-10-10','Dr Pauvert\r\nSte Rose','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BOYER Theresien n&eacute; le 17/12/1933.</p>\r\n<p>Ce patient est un ancien fumeur 1pqt/j sevr&eacute; depuis 20ans totalisant environ 40PA.Il est divorc&eacute; et a 3 enfants.Il s\'agit d\'un ancien cultivateur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour hernie inguinale droite.Ses probl&egrave;mes respiratoires ont commenc&eacute; il y a une vingtaine d\'ann&eacute;es avec plusieurs hospitalisations pour decompensation et exacerbation de BPCO.Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un assourdissement des bruits pulmonaires stethacoustiques.Il pr&eacute;sente des ronflements,le score de Mallampati est de 3 /4,le score d\'Epworth est &agrave; 8/24.La radiographie thoracique montre des signes de distension thoracique avec des grosses art&egrave;res pulmonaires.</p>\r\n<p>Les examens biologiques montrent une Hct &agrave; 53.6% Les GDS &agrave; AA:pH7.37 pCO2 52.3 pO2 57.8 Torr SaO2:91%.il existe donc une hypoventilation alv&eacute;olaire.</p>\r\n<p>Les EFR retrouvent un trouble ventilatoire obstructif tr&egrave;s s&eacute;v&egrave;re Gold IV avec un VEMS &agrave; 0.65 soit 29&ugrave; de la norme.Le Tiffeneau est &agrave; 63%.il existe des signes de distension pulmonaire avzec VGT &agrave; 141% VR &agrave; 164% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.60.Nous allons pratiquer chez ce patient une polygraphie nocturne le 06/01/2013 &agrave; 16:00.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre:OLD,a&eacute;rosolttt(Bricanyl-Atrovent)X3;Onbrez 300/j;Spiriva Respimat 2B/j;Alvesco 160 1B /j &agrave; l\'aide d\'une chambre d\'inhalation AeroChamber avec rin&ccedil;age de la bouche et kin&eacute;siettt respiratoire.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(342,399,'2013-10-10','Dr Lebidan','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LOUISE Raymonde n&eacute;e le 20/04/1946.</p>\r\n<p>Cette dame est une fumeuse actuellement 2 cigarettes/j ,autrefois 3/4 de paquets/j totalisant environ 20PA.</p>\r\n<p>Elle est s&eacute;par&eacute; &nbsp;et a 3 enfants.elle a travaill&eacute; comme femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une cholecystectomie.Elle est trait&eacute; pour HTA,DNID.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e en r&eacute;animation du 21 au 27/10/2009 pour la grippe A.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un assourdissement des bruits pulmonaires stethacoustiques avec quelques ronchi.</p>\r\n<p>Il &nbsp;existe un Signe de Campbell avec un sternum projet&eacute; &agrave; l\'avant et une cyphose dorsale.</p>\r\n<p>Mme LOUISE aura une EFR le 05/11/2013 et je lui prescrit une radiographie pulmonaire et une GDS &agrave; AA avec NFS.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre l\'OLD,l\'a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/j;onbrez 300/j;Spiriva-Respimat2B/j;Kin&eacute;siettt Respiratoire 20 s&eacute;ances/mois au domicile de la malade.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(343,352,'2013-10-10','Dr Nadia RAMASSAMY','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PAQUIRY Roger n&eacute; le 06/08/1931.</p>\r\n<p>Il pr&eacute;sente une symptomatologie de RGO et je lui prescrit un traitement anti reflux.</p>\r\n<p>Gaviscon 1 sachetX3 et Inexium 40 mg m et s pendant 3 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(344,526,'2013-10-10','Dr Cheron','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PARIS Richard n&eacute; le 27/03/1962.</p>\r\n<p>Ce monsieur est non fumeur ,mari&eacute; sans enfant.Il b&eacute;n&eacute;fice de l\'AAH et travaillait autrefois comme macon menuisier.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une op&eacute;ration pour d&eacute;viation de la cloison nasale ,des acouph&egrave;nes,hyperaccousie;</p>\r\n<p>Ses probl&egrave;mes repiratoires ont commenc&eacute; dans l\'enfance avec des bronchites &agrave; repetition.</p>\r\n<p>En 1997 il travaillait dans la metallurgie et &nbsp;a inhal&eacute; un produit &agrave; base de zinc Dans les &nbsp;suites on lui a trouv&eacute; des DDB.</p>\r\n<p>Ces DDB pr&eacute;dominent dans la lingula,dans le lobe moyen,et surtout au niveau des lobes inf&eacute;rieurs dans les segments ventraux.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires .</p>\r\n<p>Des tests &agrave; la sueur et une enquete genetique ont permis d\'eliminer une mucoviscidose.</p>\r\n<p>Actuellement M.Paris pr&eacute;sente un tournant dans l\'&eacute;volution de sa maladie dans la mesure ou il a present&eacute; une infection &agrave; pseudomonas aeruginosa &nbsp;avec des bronchites &agrave; repetition qui a &eacute;t&eacute; &nbsp;trait&eacute; &agrave; domicile par TAZOCILLINE et CIFLOX pendant 15 jours.Cela a coincid&eacute; avec une diminution de sa VEMS &agrave; 55% de la norme.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille de renforcer la kin&eacute;siettt avec musculation des abdominaux,de la ceinture scapulaire avec drainage de posture et technique de ventilation dirig&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(345,96,'2013-10-10','Dr Bonne  Lucien\r\nDr Appavoupoulle\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ROBERT Marie Monique n&eacute;e le 23/06/1946.</p>\r\n<p>Cette dame c&eacute;libataire ,un enfant,est &agrave; la retraite.Elle travaillait comme secretaire de direction &agrave; la prefecture.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,un double pontage aorto coronarien en 1993 au CHU de Bellepierre et une lobectomie inf&eacute;rieure gauche en mai 2012 pour mat&eacute;riel synth&eacute;tique laiss&eacute; en place.</p>\r\n<p>Elle est &eacute;galement trait&eacute;e pour DID,HTA,syndrome d\'apn&eacute;e de sommeil.</p>\r\n<p>Actuellement elle pr&eacute;sente des vertiges quand elle change de position;elle est suivie pour cela par un ORL.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale et Mme Robert aura une EFR le 07/11/2013.</p>\r\n<p>Je lui prescrit des s&eacute;ances de Kin&eacute;siett respiratoire avec musculation de la ceinture abdominale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(346,550,'2013-10-10','Dr Lan Nang Fan M.Noelle','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LEPINAY Joseph n&eacute; le 05/10/1935.</p>\r\n<p>Ce monsieur ancien fumeur 1paquet /j est sevr&eacute; depuis 10 ans.Il totalise environ 48PA.Il est divorc&eacute; et a eu 10 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention vasculaire abdominale &agrave; BellePierre.Il est trait&eacute; pour DID et HTA.</p>\r\n<p>Depuis son op&eacute;ration il est g&eacute;n&eacute; pour respirer et pr&eacute;sente des probl&egrave;mes de sommeil.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Son score d\'Epworth est &agrave; 15/24.son&nbsp;score de Mallampati est de 2.Son perim&egrave;tre cervical est de 42cm avec un perim&egrave;tre abdominal de 106cm.</p>\r\n<p>Sa TA est &agrave; 12/7.L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec une NFS et une GDS &agrave; AA.</p>\r\n<p>Je le reverrai le 07/11/2013 pour des EFR.</p>\r\n<p>En attendant je le place sous Onbrez 150microg;Spiriva Respimat 2B/j; Alvesco 160 microg ;Cetornan5gX2;clinutren HPX3 et Kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(347,551,'2013-10-15','Dr Lan Nang Fan\r\nDr Checkouri\r\ngastro Enterologue\r\nDr Perrichot\r\nDiabetologue\r\nDr Christian KICHENIN \r\nCardiologue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme HOARAU Margot n&eacute;e le 21/08/1936.</p>\r\n<p>Cette dame a 7 enfants.Elle a travaill&eacute; comme cultivatrice.</p>\r\n<p>Elle n\'a jamais fum&eacute;;Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,une intervention des sinus maxillaires,un curetage ut&eacute;rin et une hysterectomie.</p>\r\n<p>Elle est trait&eacute; pour HTA et DID.Pour son HTA elle prend Amlor et Sectral.</p>\r\n<p>Le Dr Checkouri la suit pour &nbsp;des alternances de diarrh&eacute;e et de constipation.Elle a b&eacute;n&eacute;fici&eacute; le 16/04/2013 d\'un FOGD qui s\'est r&eacute;v&egrave;l&eacute; normal jusqu\'&agrave; D2 &nbsp;ainsi que d\'une coloscopie qui s\'est r&eacute;v&egrave;l&eacute;e normale jusqu\'au caecum.Elle est trait&eacute; par regulateur du transit avec antispasmodique et antihemorroidaire locaux avec IPP 1/2 dose.</p>\r\n<p>Elle est &eacute;galement suivi pour maladie de Paget avec deformation et douleurs articulaires et osseuses.Mme HOARAU pr&eacute;sente sur sa radiographie du 22/05/2009 une gonarthrose femoro tibiale interne bilat&eacute;rale mod&eacute;r&eacute;e .On note &eacute;galement une arthrose interphalangienne distale.</p>\r\n<p>Le scanner c&eacute;r&eacute;bral du 13/01/2013 montre un &eacute;paississement cortico-sous-corticale osseuse diffuse du crane sans anomalie intra-c&eacute;r&eacute;brale.la radiographie du rachiis cervical et dorso-lombaire montre une discocerviarthrose pr&eacute;dominant en C6-C7 avec l&eacute;sions de dorso lombarthrose &eacute;tag&eacute;es avec pincements de L4-L5 et L5-S1.</p>\r\n<p>La NFS du 11/10/2013 montre un taux d\'hemoglobine &agrave; 12.7g/dl.La CRP est &agrave; 0.9mg/l avec TSH &agrave; 1.696 mUI/L.</p>\r\n<p>Par moments Mme Hoarau se plaint de g&egrave;ne respiratoire.Je la reverrai pour des EFR le 07/11/2013 et je conseille un traitement par kin&eacute;siettt des articulations X3/semaine &agrave; domicile.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(348,318,'2013-10-10','Dr RAZAKASOA','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAJAONARISOA Olive n&eacute;e le 17/09/1967.</p>\r\n<p>Son EFR est ce jour dans les limites de la normale.</p>\r\n<p>Son traitement anti RGO lui a &eacute;t&eacute; profitable.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(349,169,'2013-10-11','Dr Der Kasbarian','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ATCHIAMA Jean Christian n&eacute; le 25/07/1955.</p>\r\n<p>Ce monsieur est c&eacute;libataire sans enfant.Il exercait la profession d\'exploitant agricole et il est actuellement en invalidit&eacute; jusqu\'&agrave; la retraite.</p>\r\n<p>Ce patient est trait&eacute; par XOLAIR 150mg 1 ampoule / mois pour un asthme s&eacute;v&egrave;re difficile &agrave; &eacute;quilibrer.</p>\r\n<p>Depuis l\'instauration de ce traitement il va bien et n\'a plus &eacute;t&eacute; hospitalis&eacute; pour asthme.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est normale.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif limite GOLD II/III avec un VEMS &agrave; 50% de la Norme. Le Tiffeneau est &agrave; 70%.Il existe des signes de distension pulmonaire avec VR &agrave; 156%CPT &agrave; 102% VGT &agrave; 139%. Les r&eacute;sistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.85. Il n\'existe pas de trouble de la diffusion.</p>\r\n<p>La radiographie thoracique retrouve des signes de distension thoracique avec aplatissement des coupoles diaphragmatiques en dessous du 7&egrave; arc costal ant&eacute;rieur.Sur le clich&eacute; de profil on retrouve cette distension thoracique avec une augmentation du diam&egrave;tre ant&eacute;ro post&eacute;rieur et une hyperclart&eacute; retro sternale.Le radiologue a eu l\'excellente id&eacute;e de r&eacute;aliser un clich&eacute; en expiration forc&eacute;e qui montre une remont&eacute;e des coupoles diaphragmatiques de plusieurs centim&egrave;tres.</p>\r\n<p>Dans le cas de M.Atchiama il convient de discuter fortement une BPCO associ&eacute; &agrave; son asthme.</p>\r\n<p>Le traitement est bien adapt&eacute; avec Onbrez 300; Miflonil 400 1X2; Spiriva Respimat 2B/j; Singulair 10mg 1 le s associ&eacute; &agrave; Kin&eacute;sith&eacute;rapie respiratoire 3X/Semaine.M. Atchiama a refus&eacute; des s&eacute;ances de rehabilitation respiratoire.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B. TANGUY</p>'),(350,149,'2013-10-11','Dr gaelle LAGARIGUE','<p>Cher Consoeur</p>\r\n<p>J\'ai revu ce jour en consultation M.Odules Jean Felix n&eacute; le 04/08/1955.</p>\r\n<p>Il a refait le 07/10/2013 une gazom&eacute;trie qui retrouve :</p>\r\n<p>pH 7.39 pO2 96Torr pCO2 40 Torr CO2 Total 25 BE-1 SaO2 97%.</p>\r\n<p>Ce malade n\'a donc pas besoin d\'oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(351,414,'2013-10-11','Dr RAY','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour M. LEVENEUR Jean Baptiste n&eacute; le 22/06/1931.</p>\r\n<p>Ce patient, ancien fumeur 2 paquets/j, sevr&eacute; depuis environs 2 ans, dit avoir &eacute;t&eacute; op&eacute;r&eacute; du foie (?) et de la hanche gauche.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; pour UGD et est trait&eacute; pour hypertension art&eacute;rielle et goutte. Par ailleurs, il pr&eacute;sente une cardiopathie hypertensive et une BPCO.&nbsp;</p>\r\n<p>Sur le plan clinique: il pr&eacute;sente une dyspn&eacute;e grade III/IV de l\'&eacute;chelle du Modified Research Council. L\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires st&eacute;thacoustiques, avec quelques sous cr&eacute;pitants aux bases.</p>\r\n<p>Le scanner thoracique en date du 26/09/2013 montre un &eacute;paississement des parois bronchiques sans DDB.Il existe un l&eacute;ger &eacute;paississement pleural lobaire moyen avec un micronodule de 4 mm du lobe moyen.</p>\r\n<p>L\'EFR de ce jour montre un trouble ventilatoire Mixte &nbsp;avec CPT &agrave; 59% ,tiffeneau &agrave; 95% VEMS &agrave; 1.26 soit 63% de la norme.Il existe une augmentation des resistances des voies a&eacute;riennes avec RVA &agrave; 0.66.</p>\r\n<p>Sur le plan biologique l\'Hct est &agrave; 37.8% et la GDS &agrave; AA montrent:pH 7.45;pO2 79Torr pCO2 44 Torr CO2 Total 31mmol/l SaO2 95%.</p>\r\n<p>Sur le plan respiratoire, je recommande le traitement suivant, qui sera a r&eacute;adapter au vu des &eacute;preuves fonctionnelles respiratoires: onbrez 150&micro;g 1b/j; spiriva respimat 2b/j, pulmicort 400 1x2, avec rin&ccedil;age, associ&eacute; &agrave; kin&eacute; respi, techniques ventilations dirig&eacute;es 3 s&eacute;ances/semaine.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(352,201,'2013-10-11','Dr Lee Kien On\r\nDr KICHENIN,Christian\r\nDr Mascarel\r\nPharmacie de Bellepierre','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PICARDO Marc n&eacute; le 05/10/1934.</p>\r\n<p>Ce monsieur est un ancien fumeur 1paquet/j sevr&eacute; depuis 2000 et totalise environ 46PA.</p>\r\n<p>Il exercait la profession de macon.Il est mari&eacute; et a 6 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un pontage aorto coronarien en 2000,cancer ORL en 2011:carcinome epidermoide diu pharynx ,r&eacute;section endoscopique de la prostate.</p>\r\n<p>Il est trait&eacute; pour insuffisance cardiaque,HTA.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.La SaO2 est &agrave; 94% &agrave; AA.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte,Gold IV (tr&egrave;s s&eacute;v&egrave;re) dans sa composante obstructive .Le VEMS est &agrave; 0.8 soit 29% avec un Tiffeneau &agrave; 73%.Il existe des signes de distension pulmonaire avec VGT &agrave; 137% et VR &agrave; 139%.Par ailleurs il existe des troubles de la diffusion avec une TLCO &agrave; 33%.</p>\r\n<p>Un TDM TAP est demand&eacute; ce jour et sera r&eacute;alis&eacute; le 21/11/2013.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre de l\'OLD de confort,Kin&eacute;siettt respiratoire,A&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 et pulmicortX2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(354,458,'2013-10-11','Dr Sabatier','<p>Cher Consoeur,</p>\r\n<p>J\'ai vu ce jour Mme METANIRE Marie Viviane n&eacute;e le 03/04/1949.</p>\r\n<p>Elle pr&eacute;sente une toux.</p>\r\n<p>l\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Ses IgE totales sont &agrave; 200 et poids &agrave; 87K300.</p>\r\n<p>Cela correspond bien &agrave; une dose de XOLAIR 300 mg toutes les 4 semaines.</p>\r\n<p>Elle prend en plus du FORADIL et du MIFLONIL auquel il serait bon de rajouter du SINGULAIR 10 mg le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(355,167,'2013-10-11','','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme FOREAU Marie Edith n&eacute;e le 25/03/1942.</p>\r\n<p>Elle tousse et pr&eacute;sente une oppression thoracique avec irritation de la gorge.Le matin et le soir elle pr&eacute;sente une rhinite allergique.</p>\r\n<p>La biologie retrouve un Hct &agrave; 36.9%</p>\r\n<p>La GDS &agrave; AA retrouve pH 7.46 pCO 52Torr pO2 77 torr CO2 total 38mmol/l SaO2 94%.Elle traduit une hypoventilation alv&eacute;olaire.</p>\r\n<p>la radiographie thoracique montre des signes de distension thoracique avec aplatissement des coupoles diaphragmatiques avec accentuation de la vascularisation pulmonaires.</p>\r\n<p>il serait bon de r&eacute;aliser une echocardiographie &agrave; Mme Foreau.</p>\r\n<p>Mme FOREAU poursuivra le meme traitement avec Eludril gargarisme m ets.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(356,460,'2013-10-11','','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. TESTAN Maurice Virgile n&eacute; le 22/09/1936.</p>\r\n<p>Ce patient est un ancien fumeur 2 pqt/j, sevr&eacute; depuis plus de 10 ans.</p>\r\n<p>Il s\'agit d\'un ancien macon, mari&eacute; 9 enfants.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont demarr&eacute; depuis plus de 15 ans.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e gradeV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Sa SaO2 est &agrave; 84% avec un pouls &agrave; 80.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec assourdissements des bruits pulmonaires stethacoustiques.La radiographie thoracique montre une distension thoracique majeure avec aplatissement des coupoles diaphragmatiques avec des grosses art&egrave;res pulmonaires.</p>\r\n<p>Hct est &agrave; 45.8%et la GDS &agrave; AA montre:pH 7.34 pCO2 64.5 Torr pO2 88 Torr CO2 Total 36.9 mmol/l Sao2 95.7% .Il existe donc une hypoventilation alv&eacute;olaire.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif tr&egrave;s s&eacute;v&egrave;re Gold IV avec un VEMS &agrave; 0.41 soit 18% de la norme,le Tiffeneau est &agrave; 43% .Il existe une distension pulmonaire s&eacute;v&egrave;re avec VGT &agrave; 214% CPT &agrave; 134% et VR &agrave; 266%.La resistance des voies a&eacute;riennes est augment&eacute;e &agrave; 0.96 .</p>\r\n<p>.il convient de poursuivre chez ce patient :OLD 2L/mn 24H/24.A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent) x 3/J; onbrez300; Spiriva &nbsp;Respimat 2B/j; pulmicortX2/j; Il refuse la kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Je reverrai le 11/10/2013 pour des EFR et r&eacute;adapter son traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(357,165,'2013-10-11','Dr Laravine','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. PAVADE JOSEPH RICHEMON n&eacute; le 05/09/1945.</p>\r\n<p>Sa fi&egrave;vre a compl&egrave;tement regress&eacute;e et il va mieux.</p>\r\n<p>Ses r&eacute;sultats biologiques montrent une r&eacute;gression de l\'hyperleucocytose qui est pass&eacute;e de 13280 &agrave; 6200/mm3.les PNN sont pass&eacute;s de 10903 &agrave; 4098/mm3</p>\r\n<p>.La CRP a regress&eacute;e de 341 &agrave; 0.6.</p>\r\n<p>M.PAVADE fera une radiographie pulmonaire qu\'il m\'apportera &agrave; sa prochaine consultation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(358,471,'2013-10-11','Dr Bobate','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MALEK RASSOUL Fatma n&eacute;e le 25/09/1948.</p>\r\n<p>Les EFR pratiqu&eacute;s ce jour montrent un trouble ventilatoire restrictif avec CPT &agrave; 73% et VR &agrave; 44%.Il existe des troubles de la diffusion avec TLCO &agrave; 50% de la norme.</p>\r\n<p>Je demande un scanner thoracique qu\'elle m\'apportera &agrave; la prochaine consultation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(359,66,'2013-10-11','Dr Sabatier\r\nDr MANLAY \r\nCardiologue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MOIMBA Alexis n&eacute; le 13/11/1943.</p>\r\n<p>Ce monsieur ancien fumeur est porteur d\'un carcinome epidermoide de la bronche souche droite diagnostiqu&eacute; en 2010 et d\'embl&eacute;e metastatique.Sa tumeur &nbsp;&eacute;tait class&eacute; T4 N2M1a et a &eacute;t&eacute; trait&eacute; par chimioth&eacute;rapie et radioth&eacute;rapie palliative.</p>\r\n<p>Actuellement il est trait&eacute; par TARCEVA 150 mg.Il continue de s\'alimenter me dit sa fille mais pr&eacute;sente un poids de 38K800 pour 1m60 soit un IMC de 15 &nbsp;ce qui correspond &agrave; une d&eacute;nutrition.</p>\r\n<p>L\'EFR montrait un trouble ventilatoire mixte avec une CPT &agrave; 62% le VEMS est &agrave; 0.63 soit 27% de la norme avec augmentation de la resistances des voies a&eacute;riennes &agrave; 0.6.Ce patient est class&eacute;b &nbsp;Gold IV dans sa composante obstructive.</p>\r\n<p>Le scanner TAP du 22/07/2013 montre une masse pulmonaire droite de 84X79 mm ayant grossi car elle mesurait pr&eacute;c&egrave;demment 58X73mm.On notait l\'apparition d\'un &eacute;panchement p&eacute;ricardique et d\'une ascite de faible abondance.</p>\r\n<p>L\'echocardiographie pratiqu&eacute;e ce matin, montre un &eacute;panchement p&eacute;ricardique de 800cc bien support&eacute;.</p>\r\n<p>Compte tenu de l\'&eacute;tat du patient et de son pronostic je pense qu\'une simple surveillance s\'impose pour l\'instant.</p>\r\n<p>Il poursuivra le meme traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(360,43,'2013-10-14','Dr Eric BOURDAIS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme CAMARET Josiane n&eacute;e le 20/09/1944.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une m&egrave;re asthmatique.Mme Camaret est veuve et a 6 enfants.Elle est non fumeuse.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e d\'un fibrome ut&eacute;rin,d\'une hemorroidectomie,d\'un lipome et de la cataracte.</p>\r\n<p>Elle est trait&eacute;e pour HTA,DNID,lombalgies depuis 1995 et a pr&eacute;sent&eacute; un ictus c&eacute;r&eacute;bral le 05/07/2013 Elle &nbsp;a eu un IRM c&eacute;r&eacute;bral le 05/09/2013 qui n\'a me dit elle rien montr&eacute;.</p>\r\n<p>Depuis janvier 2013 elle pr&eacute;sente un essouflement avec toux laryng&eacute;.Il s\'agit de crises de toux.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire ne retrouve rien de particulier.L\'indice d\'Epworth est &agrave; 5/18 avec un score de Mallampati &agrave; 3/4.La radiographie thoracique est normale si on excepte une calcification aortique.</p>\r\n<p>L\'EFR montre une augmentation mod&eacute;r&eacute;e de la resistance des voies a&eacute;riennes avec RVA &agrave; 0.45.Le VEMS est &agrave; 1.37 soit 75% passant &agrave; 1.54 soit 85% de la norme sous b2 inhal&eacute;s ce qui traduit une hyperreactivit&eacute; bronchique.Toutefois le traitement FORADIL-MIFLONIL n\'a pas fait regress&eacute; la toux.</p>\r\n<p>Une Polygraphie nocturne a &eacute;t&eacute; r&eacute;alis&eacute;e le 14/08/2013 et a retrouv&eacute; 57 ronflements/h avec une energie moyenne de 89dB .L\'index d\'apn&eacute;es -hypopn&eacute;es est &agrave; 12/h passant &agrave; 28/h si on y aoute les &eacute;v&eacute;nements respiratoires.C\'est la raison pour laquelle une polysomnographie est pr&eacute;vue le 26/12/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(361,470,'2013-10-14','Dr Cole- Rocher ,Marie Francoise','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme JISTA Florence n&eacute;e le 16/02/1963.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on ne note rien de bien particulier sinon une rhinite allergique chez un de ses fils.</p>\r\n<p>mme&nbsp;</p>'),(362,470,'2013-10-14','Dr Cole - Rocher','<p>Cher Consoeur,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme JISTA florence, n&eacute;e le 16/02/1963.</p>\r\n<p>Cette dame mari&eacute;e,3 enfants est agent &agrave; la CGSS.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne note pas d\'asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on ne note aucune maladie sinon un astme ayant d&eacute;but&eacute; dans l\'adolesence &agrave; l\'age de 15 ans.</p>\r\n<p>A l\'epoque elle avait commenc&eacute; &agrave; fumer 10 cigarettes /jour.Elle a arret&eacute; de fumer il y a 17 ans.Mme Jista totalise donc environ 9 PA.Mme Jista n\'a jamais &eacute;t&eacute; hospitalis&eacute; et n\'a jamais fait de crise &agrave; proprement parler.Elle est trait&eacute; par PULMICORT depuis plus de vingt ans.</p>\r\n<p>Elle a pr&eacute;sent&eacute; fin juin une grosse bronchite avec secretions bronchiques purulentes.Depuis elle ressent une accentuation de sa dyspn&eacute;e.elle a besoin de recourrir &agrave; la ventoline.</p>\r\n<p>L\'Auscultation retrouve un freinage expiratoire avec quelques sibilances.</p>\r\n<p>La radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>La NFS ne retrouve pas d\'hypereosinophilie.Les IgE totales sont &agrave; 45UI/ml;les RAST aux a&eacute;ro-allerg&egrave;nes et aux trophallerg&egrave;nes sont normaux.</p>\r\n<p>L\'EFR pratiqu&eacute;s ce jour est dans les limites de la normale.</p>\r\n<p>Le SYMBICORT 2BX2 a eu un effet b&eacute;n&eacute;fique et je conseille &agrave; Mme JISTA de passer &agrave; 1BX2avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(363,369,'2013-10-14','Dr Doussaud','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation M. Bacco Alix J. Michel n&eacute; le 16/08/1963.</p>\r\n<p>L\'hemoptysie a compl&egrave;tement regress&eacute;.M.Bacco a eu un scanner thoracique le 03/10/2013 .Cet examen n\'a pas retrouv&eacute; d\'anomalie tant au niveau du parenchyme pulmonaire qu\'au niveau du m&eacute;diastin.</p>\r\n<p>M.Bacco a b&eacute;n&eacute;fici&eacute; ce jour d\'une EFR.Cet examen a retrouv&eacute; un trouble ventilatoire restrictif mod&eacute;r&eacute; avec VR &agrave; 67% et CPT &agrave; 77% de la norme.Le VEMS est &agrave; 2.51 soit 75% et le Tiffeneau &agrave; 100%.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Je conseille une kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>&nbsp;</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(364,117,'2013-10-14','Dr AKBARALY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme ACORIA Marie Aurelia, n&eacute;e le 24/02/1931</p>\r\n<p>Cette dame c&eacute;libataire a un enfant.Elle est non fumeuse et exercait la profession de femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour valvulopathie mitrale en 1998.</p>\r\n<p>Elle est trait&eacute; pour DNID,hypercholesterol&eacute;mie,HTA.</p>\r\n<p>Elle a pr&eacute;sent&eacute; de l\'asthme dans l\'enfance et cuisinait au feu de bois.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II/III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>La radiographie thoracique retrouve des fils metalliques de sternotomie avec remplacement valvulaire mitral.On note une calcification du bouton aortique avec redistribution vasculaire vers les sommets.</p>\r\n<p>Sur le plan biologique on note une Hb &agrave; 12.5g/dl avec une hypereosinophilie &agrave; 1100/mm3.</p>\r\n<p>La gazom&egrave;trie montre:pH 7.46 pCO2 :44Torr pO2 65 Torr;SaO2 90%.</p>\r\n<p>Les EFR du 29/08/2013 montraient un trouble ventilatoire mixte mod&eacute;r&eacute; avec un VEMS &agrave; 0.86 soit 72% de la norme;le Tiffeneau est &agrave; 93% avec des signes de distension pulmonaire:VGT &agrave; 127% VR &agrave; 158% et augmentation de la resistance des voies a&eacute;riennes:RVA &agrave; 1.06.</p>\r\n<p>il convient de poursuivre le meme traitement Onbrez 300 1/j;Spiriva Respimat 2B/j; MIFLONIL &nbsp;1BX2 avec rin&ccedil;age de la bouche ainsi que Kin&eacute;siettt Respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(365,485,'2013-10-14','Dr I.Patel\r\nMédecin Cardiologue\r\nPhcie Bellepierre','<p>&nbsp;</p>\r\n<p>Cher ami</p>\r\n<p>&nbsp;M. SAUTRON andre n&eacute; le 18/08/1926 a eu ce jour des EFR.Cet examen montre un trouble ventilatoire mixte &agrave; pr&eacute;dominance obstructive.Le VEMS est &agrave; 0.54 soit 32% de la norme avec un Tiffeneau &agrave; 59%.Le patient est donc Gold III s&eacute;v&egrave;re non r&eacute;versible sous b2 inhal&eacute;s.La CPT est &agrave; 67% de la norme avec augmentation de la resistances des voies a&eacute;riennes RVA &agrave; 1.14 sans trouble du transfert.</p>\r\n<p>Sur le plan biologique ,l\'Hct est &agrave; 42.2% et les GDS retrouvent:pH:7.46 pCO2 40 Torr pO2 :81 Torr SaO2 96%.La CRP est &agrave; 4 mg/l.</p>\r\n<p>La radiographie thoracique retrouve une augmentation de volume de la silhouette cardiovasculaire avec d&eacute;roulement de la ligne paraaortique gauche et des grosses art&egrave;res pulmonaires.</p>\r\n<p>Je pense qu\'un suivi cardiologique s\'impose pour ce patient.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p><span style=\"font-size: 11px;\">&nbsp;</span></p>\r\n<p>&nbsp;</p>'),(366,204,'2013-10-14','Dr I.Patel','<p>Cher ami,</p>\r\n<p>J\'ai vu ce jour M. ROBERT Max Daniel n&eacute; le 03/08/1967.</p>\r\n<p>Ce patient ancien fumeur 10 cigarettes/j . Il totalise environ 15PA.Il a arr&ecirc;t&eacute; de fumer &nbsp;et est actuellement sous Nicopatch.Il est s&eacute;par&eacute; et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fils ,une soeur et 2 neveux asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention pour an&eacute;vrysme c&eacute;r&eacute;bral en 2003.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; dans l\'enfance pour l\'asthme par VENTOLINE.</p>\r\n<p>Ses EFR ont montr&eacute; &nbsp;un trouble ventilatoire obstructif GOLD II.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est redevenu dans les limites de la normale.</p>\r\n<p>Il convient de poursuivre nicopatch, foradil, une g&eacute;lule inal&eacute;e matin &amp; soir, miflonil avec rin&ccedil;age, spiriva respimat 2B/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher ami,&nbsp;chers confr&egrave;res, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(367,207,'2013-10-14','Dr Bruno CADET','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme VOULAMALE Viviene n&eacute;e le 12/10/1936.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour sans grande particularit&eacute; et je demande un dosage des pro-BNP.</p>\r\n<p><span style=\"font-size: 11px;\">Mme Voulamal&eacute; aura des EFR le 13/11/2013 &agrave; 10:00.</span></p>\r\n<p>Elle est trait&eacute; actuellement par VNI,OLD, a&eacute;rosolth&eacute;rapie:(Bricanyl-Atrovent)X3 kin&eacute; respiratoire, onbrez 300&micro;g/j, spiriva respimat 2b/j, miflonil 400 1bx2, avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGU</p>'),(368,547,'2013-10-14','Dr laurent de grandpré \r\nDr Venault','<p>Cher Confr&egrave;re</p>\r\n<p>M.RAKOTOARIVONY Gaetan n&eacute; le 06/08/1960 a eu ce jour des EFR.</p>\r\n<p>Cet examen retrouve un trouble ventilatoire restrictif avec CPT &agrave; 53%.la spirographie est dans les limites de la normale ainsi que la TLCO.</p>\r\n<p>Il nous apportera son agenda de sommeil le 16/10 lors de sa polygraphie nocturne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(369,456,'2013-10-14','Dr ISSAC ISMAEL\r\nDr MOULS','<p>Cher Confr&egrave;re</p>\r\n<p>M.Quemener a eu ce jour des EFR.Cet examen retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 77% VR 73%.le VEMS est &agrave; 2.84 soit 94% de la norme avec un TLCO &agrave; 62% de la norme.</p>\r\n<p>On maintien Solupred 20mg jusqu\'&agrave; mi janvier 2014.nous pratiquerons alors de nouvelles EFR pour voir s\'il faut augmenter,diminuer,ou maintenir la meme dose.</p>\r\n<p>En attendant je le place en outre sous Onbrez 150micrg/j et alvesco 160 1b/j &agrave; l\'aide d\'une chambre d\'inhalation avec rin&ccedil;age de la bouche.M.Quemener aura une polygraphie nocturne en raison de son hypersomnie accompagn&eacute; de ronflement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(370,555,'2013-10-14','Dr Pillay\r\nDr Mascarel','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. GAY Wilson, n&eacute; le 01/06/1961.</p>\r\n<p>Sa radiographie du 31/10/2013 montre des s&eacute;quelles pleurales gauches avec &eacute;moussement du sinus costo-diaphragmatique gauche et r&eacute;traction et l&eacute;g&egrave;re sur&eacute;l&egrave;vation du champ pulmonaire gauche.</p>\r\n<p>Il convient de poursuivre la kin&eacute;siettt respiratoire centr&eacute;e sur l\'hemicoupole diaphragmatique gauche et pratiquer un TDM thoracique avec injection le jeudi 14/11/2013 &agrave; 8H &agrave; la Clinique St Vincent avec le Dr Mascarel.</p>\r\n<p>Comme il est dyspn&eacute;ique &agrave; l\'effort je lui renouvelle a&eacute;rosolttt (bricanyl-Atrovent)X2 avec Onbrez 150microgf/J&nbsp;</p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(371,236,'2013-10-14','Dr LEVEQUE\r\nSOS Oxygène','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LASANTE Serge n&eacute; le 26/08/1965.&nbsp;</p>\r\n<p>Sa radiographie thoracique est dans les limites de la normale.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; le 27/09/2013 d\'une polysomnographie.Cet examen montre un Index d\'Apn&eacute;es-hypopn&eacute;es de 30/heure.Cet index passe &agrave; 47 en y associant les &eacute;v&egrave;nements .</p>\r\n<p>On note 836 ronflements par heure avec une energie moyenne de 92dB ce qui correspond &agrave; un ronflement majeur.</p>\r\n<p>Le nombre total de d&eacute;saturation est de 212 soit 30/heure avec une d&eacute;saturation minimale de 83%.On note 2 mouvements p&eacute;riodiques de jambes par heure.</p>\r\n<p>Dans ces conditions M.Lasant&eacute; doit etre appareill&eacute; et nous allons contacter la soci&eacute;t&eacute; SOS Oxyg&egrave;ne pour ce faire.Il sera appareill&eacute; en mode autopilot&eacute; entre 4 et 12 cmd\'H2O.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(372,205,'2013-10-14','Dr FOUASSIN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MAILLOT Jean-Pierre n&eacute; le 28/11/1958.</p>\r\n<p>Ce monsieur mari&eacute; 1enfant travail aux espaces verts.</p>\r\n<p>Il n\'a jamais fum&eacute;.Dans ses ant&eacute;c&egrave;dents on note rien de particulier &agrave; part des DDB.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; il y 3 &agrave; 4 ans pour surinfection de DDB.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade I de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Il pr&eacute;sente une toux avec expectoratio blanchatre.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Le TDM thoracique du 03/10/2013 montre des DDB importantes du lobe moyen et de la lingula.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte avec CPT &agrave; 87% de la norme.Le VEMS est &agrave; 1.99 soit 63% avec un Tiffeneau &agrave; 88%de la norme.Il existe une distension pulmonaire avec VGT &agrave; 103% et VR &agrave; 121% de la norme.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille de la Kin&eacute;siettt respiratoire 3X/semaine avec ZITHROMAX 250 mg X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(373,552,'2013-10-14','Dr Charles-Rabesiaka\r\nDr Gazaille','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour M. ROBERT Gilbert n&eacute; le 10/04/1949.Il&nbsp;n\'a malheureusement pas &eacute;t&eacute; convoqu&eacute; par le Dr Gazaille pour sa fibroscopie bronchique avec LBA.</p>\r\n<p>J\'ai appel&eacute; cet apr&egrave;s midi le service et laiss&eacute; un message pour le Dr Gazaille.</p>\r\n<p>Sur le plan biologique on note une Hct &agrave; 47.5%;Il n\'existe pas d\'hypereosinophilie.</p>\r\n<p>La gazom&eacute;trie montre:pH 7.4 pCO2 33.1mmHg pO2 :75.8mmHg SaO2 96%.Fonction r&eacute;nale Normale;Calc&eacute;mie normale &agrave; 2.26 mmol/L;Transaminases N;Test au Latex N;Waaler Rose:N;Anticorps anti nucl&eacute;aires:N&eacute;gative;Anticorps anti-Sm &nbsp;N&eacute;gatif;anti-Sm/RNP ,Anti-SSA(Ro),Anti-SSB(La),anti-Jo-1:n&eacute;gatifs;anti-Scl-70,anti-PM-Scl,anti-centrom&egrave;res:n&eacute;gatifs.</p>\r\n<p>Ac ant-cytoplasme PN-ANCA,anti -synthetases ,mal du poumon de fermier et d\'eleveur d\'oiseaux adress&eacute; en metropole.</p>\r\n<p>Ce jour le patient est toujours dyspn&eacute;ique et nous attendons le LBA pour demarrer une corticoth&eacute;rapie .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(374,40,'2013-10-15','Dr Vinguetama\r\nDr Ronzier\r\nReeducation Fonctionelle\r\nDr Serveaux\r\nClinique de Ste Clotilde','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CLOTILDE Jean Claude n&eacute; le 29/07/1944 qui a &eacute;t&eacute; branch&eacute; pour une polygraphie nocturne dans la nuit du 14 au 15/10/2013.Nous allons voir si on peut y recueillir des informations.</p>\r\n<p>Ce patient pr&eacute;sente une maladie de Steele-Richardson-Olsyenski et est actuellement en r&eacute;education fonctionelle &agrave; la Clinique Ste Clotilde.</p>\r\n<p>Il pr&eacute;sente une somnolence diurne excessive avec un score d\'Epworth &agrave; 5/24,un score de Mallampati &agrave; 3/4 avec des ronflements et 4 nyctiuries par nuit.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>l\'EFR retrouve un trouble ventilatoire mixte avec un VEMS &agrave; 1.86 soit 67% de la norme .Le patient est donc Gold II dans sa composante obstructive.le Tiffeneau est &agrave; 79%.La phlethysmographie est dans les limites de la normale et il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(375,41,'2013-10-15','Dr Vinguetama-Perianagom','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme CLOTILDE Monique Gilette n&eacute;e le 25/08/1942.</p>\r\n<p>Cette dame est mari&eacute; sans enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie ainsi qu\'une hysterectomie pour fibrome.</p>\r\n<p>Elle est trait&eacute; pour DID ,HTA .Elle n\'a pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Son asthme a demarr&eacute; en 2000 et elle est trait&eacute; par Seretide et Singulair.</p>\r\n<p>Malheureusement Mme Clotilde ne m\'a pas apport&eacute; sa tradiographie thoracique.</p>\r\n<p>L\'auscultation pulmonaire est sans grande particularit&eacute;.</p>\r\n<p>L\'EFR du 12/08/2013 &eacute;tait dans les limites de la normale.</p>\r\n<p>Il convient donc de poursuivre le meme traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(376,235,'2013-10-15','Dr Satsou\r\nSt Andre \r\nRavine Creuse','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PITOU Jeannine n&eacute;e le 23/01/1950.</p>\r\n<p>Cette dame non fumeuse est mari&eacute; et a 6 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une cholecystectomie en 1983 et une c&eacute;sarienne.</p>\r\n<p>En juillet 2012 elle a pr&eacute;sent&eacute; un adenocarcinome pulmonaire primitif droit avec un &eacute;panchement pleural droit qui a &eacute;t&eacute; talqu&eacute;.L\'analyse en biologie mol&eacute;culaire a montr&eacute; une mutation du g&egrave;ne de l\'EGFR(exon 19).</p>\r\n<p>Depuis Mme PITOU est trait&eacute; par IRESSA 250mg/j avec TERTALYSAL 300mg/j.Elle ne pr&eacute;sente pas de troubles dermatologiques et se lave au savon de Marseille.</p>\r\n<p>Mme Pitou est en bon &eacute;tat g&eacute;n&eacute;ral avec un poids de 75Kilos pour 1m56,soit une BMI de 30.8.</p>\r\n<p>La palpation des aires ganglionnaires est normale et l\'auscultation pulmonaire est sans grande<span style=\"font-size: 11px;\">&nbsp;particularit&eacute;.</span></p>\r\n<p>&nbsp;L\'EFR &nbsp;retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT est &agrave;2.81 soit 62% de la normeavec un &nbsp;VR &agrave; 66% Le VEMS est &agrave;&nbsp;1.28 soit64% de la norme avec un Tiffeneau &agrave; 92% de la norme.il existe un trouble du transfert avec TLCO &agrave;67% de la norme.</p>\r\n<p>Le dossier de Mme PITOU sera pr&eacute;sent&eacute; en RCP d\'Oncologie thoracique le 17/10/2013 .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(378,240,'2013-10-15','Dr Ah Sing','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour en consultation Mme Voisin Marie Sylvie n&eacute;e le 11/07/1963 et qui pr&eacute;sente un syndrome d\'Eisenmenger. Mme Voisin est trait&eacute; par TRACLEER depuis plus de 2 ans. Elle ressent parfois des c&eacute;phal&eacute;es avec bouff&eacute;es de chaleur. Les transaminases sont normales. L\'Hb est &agrave; 15.7g/100ml. La cr&eacute;atinin&eacute;mie est &agrave; 83micromol/L avec une Clairance corrig&eacute;e &agrave; 65ml/mn/1.73.</p>\r\n<p>La GDS &agrave; AA montre pH &agrave; 7,46 pCO2 &agrave; 35 pO2 &agrave; 55mmm Hg.</p>\r\n<p>L\'EFR montre un trouble respiratoire Mixte avec VEMS &agrave; 0.98 soit 44% de la norme;avec un Tiffeneau &agrave; 83%.</p>\r\n<p>le VGT est &agrave; 118% avec VR 142% et CPT &agrave; 85%.Il existe donc une distension pulmonaire.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.89 et il n\'existe pas de trouble du transfert.</p>\r\n<p>L\'auscultation pulmonaire est ce jour sans grande particularit&eacute; et nous allons renforcer le traitement par Onbrez 150 microg/j associ&eacute; &agrave; Spiriva Respimat 2B/J car Mme Voisin se plaint de difficult&eacute;s &agrave; respirer le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(379,138,'2013-10-15','Dr DUVAL','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. VITRY Xavier n&eacute; le 10/12/1928.</p>\r\n<p>M. Vitry a eu une appendicectomie,une prostatectomie et une endariectomie carotidienne gauche.Il a &eacute;t&eacute; op&eacute;r&eacute; recemment d\'un h&eacute;matome sous dural bilat&eacute;ral.</p>\r\n<p>Ce patient pr&eacute;sente une BPCO post tabagique, un syndrome m&eacute;tabolique avec HTA, diab&egrave;te de type II et arterite.</p>\r\n<p>M.Vitry a pr&eacute;sent&eacute; un AVC en 2000 et un UGD en 2000.Il pr&eacute;sente par ailleurs un glaucome chronique &agrave; angle ouvert.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'EFR avait montr&eacute; chez lui un trouble ventilatoire obstructive Gold II avec signes de distension pulmonaire et augmentation de la resistance des voies a&eacute;riennes.</p>\r\n<p>Le scanner thoracique en date du 20/08/2013 retrouve un emphyseme centro lobulaire &eacute;volu&eacute; &agrave; predominance droite avec une distension pulmonaire.Il s\'y associe un emphyseme para septal avec un aspect de fibrose &agrave; large maille des segments apical des lobes inf&eacute;rieurs.</p>\r\n<p>Il convient d\'augmenter ONBREZ &agrave; 300microg/J ;Spiriva respimat 2B;Aerosolth&eacute;trapie (Bricanyl-Atrovent)X3 PulmicortX2 et kin&eacute;sieth&eacute;rapie respiratoire.Ceci associ&eacute; &agrave; l\'oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(380,208,'2013-10-15','Dr Alain BONNE','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour Mme PARIS Marie Daniela n&eacute;e le 03/11/1972.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re et un fils asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on retrouve chirurgical pour les menisques gauche.</p>\r\n<p>Mme PARIS pr&eacute;sente un asthme depuis la tendre enfance .</p>\r\n<p>En ce moment elle est enceinte de 3mois.</p>\r\n<p>Elle pr&eacute;sente une symptomatologie de RGO.</p>\r\n<p>l\'auscultation est ce jour &nbsp;dans les limites de la normale.</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale;la plethysmographie montre une distension pulmonaire mod&eacute;r&eacute;e avec l&eacute;g&egrave;re diminution de la TLCO &agrave; 73% de la norme.</p>\r\n<p>Elle poursuivra le traitement SYMBICORT 1BX2 avec rin&ccedil;age &nbsp;et GAVISCON en gel 3 fois par jour.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(381,190,'2013-10-15','Dr DUVAL\r\nDr GAZAILLE','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai vu ce jour M. TEVANE Nicolas n&eacute; le 25/04/1924.</p>\r\n<p>L\'examen clinique montre une matit&eacute; des deux bases .</p>\r\n<p>J\'ai appel&eacute; ce jour le Dr Gazaille car je n\'ai rien recu &agrave; son sujet et je pense que son &eacute;panchement pleural n\'a toujours pas &eacute;t&eacute; explor&eacute;.Je demande donc une radiographie thoracique et je reverrai ce lmalade le 06/11/2013.</p>\r\n<p>En attendant je place ce patient sous a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X2 ainsi que Onbrez 150 21B/j et kin&eacute;siettt respiratoire.</p>\r\n<p>je le reverrai en consultation le 06/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(382,228,'2013-10-15','Dr Richard RAMILISON','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MARIONNETTE Mimose n&eacute;e le 16/06/1944.</p>\r\n<p>Cette dame veuve a 4 enfants.Elle est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour kyste de l\'ovaire gauche , de la main gauche et d\'une hernie discale.Elle est trait&eacute; pour HTA.Elle a pr&eacute;sent&eacute; un AVC en 2008 avec recidive en 2012.</p>\r\n<p>Elle pr&eacute;sente un asthme ayant d&eacute;but&eacute; il y a plusieurs ann&eacute;es.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Mme Marionette presente 3 nyctiuries .Son score d\'Epworth est de 5/24.Son score de Mallampati est de 1/4.</p>\r\n<p>Son EFR en date du 08/10/2013 est dans les limites de la normale.</p>\r\n<p>Elle est trait&eacute; par FLIXOTIDE 2 B le soir avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(383,417,'2013-10-15','Dr Philippe MAS','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme CRESENCE Marie Risla n&eacute;e le 14/01/1957.</p>\r\n<p>Cette dame est non fumeuse, ex-femme de menage, 2 enfants.Dans ses ant&eacute;c&egrave;dents familiaux on note une soeur, un enfant et des cousines asthmatiques.Dans ses ant&eacute;c&egrave;dents personnels on note un goitre avec hyperthyroidie d&eacute;courte depuis un an et demi.</p>\r\n<p>Son asthme a d&eacute;marr&eacute; &agrave; l\'age de 40 ans, deux consultations aux Urgences hospitali&egrave;res pour asthme.Patiente suivie par moi depuis environ 3 ans. A b&eacute;n&eacute;fici&eacute; d\'une &eacute;ducation th&eacute;rapeutique dans le cadre de l\'Ecole de l\'asthme. Actuellement sous XOLAIR 375mgX2/mois.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale. Elle n\'est pas tr&egrave;s dyspn&eacute;ique dans sa vie de tous les jours mais doit recourir &agrave; la Ventoline 2 fois par jour.</p>\r\n<p>la radiographie thoracique retrouve des signes de distensuion thoracique avec aplatissement des coupoles diaphragmatiques sans anomalies parenchymateuses.la NFS retrouve 208 eosinocytes/mm3.Les RAST aux trophallerg&egrave;nes montrent une allergie Classe 3 au Soja,&agrave; l\'arachide et &agrave; l\'avocat ainsi qu\'au Kiwi.Les RAST aux pneumallerg&egrave;nes montrent une allergie classe 3 au bouleau,&agrave; l\'olivier,au chene,au platane, au cypr&egrave;s(classe4);au pollens de bl&eacute; et de phl&eacute;ole d\'ambroise;classe 3 au phan&egrave;res de chien.Tr&egrave;s allergique aux acariens Classe 4 et 5.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif Gold II mod&eacute;r&eacute; avec un VEMS &agrave; 1.27 soit 54% de la norme;le Tiffeneau est &agrave; 80% et il existe des signes de distension pulmonaire:VGT &agrave; 131% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.99 sans trouble de la diffusion.</p>\r\n<p>&nbsp;Nous maintenons chez elle le meme traitement: XOLAIR 375 mgX2/mois, Singulair 10mg 1cp le soir et Ventoline 2X2</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(384,170,'2013-10-15','Dr Colomb','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LEBON marie therese n&eacute;e le 24/05/1932.</p>\r\n<p>Cette dame veuve a 7 enfants.Elle est ancienne cuisini&egrave;re &agrave; la commune de St Denis.</p>\r\n<p>Elle est non fumeuse et est trait&eacute; pour polyarthrite rhumatoide par le Dr Ribera et pour insuffisance cardiaque gauche par le Dr Amzallag.</p>\r\n<p>Un traitement anti reflux gastro oesophagien a &eacute;t&eacute; mis en route et lui a &eacute;t&eacute; b&eacute;n&eacute;fique.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV/V de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Mme LEBON a &eacute;t&eacute; explor&eacute; au CHU de St Pierre qui a retrouv&eacute; un syndrome interstitiel des bases avec &eacute;paississement des septaintralobulaireset des plages de verre d&eacute;poli sans argument pour une fibrose pulmonaire.Par ailleurs les anticorps antipeptides citrullin&eacute;s sont tr&egrave;s positifs &agrave; 263U/L.Il convient donc de surveiller de pr&egrave;sMme Lebon d\'autant plus qu\'elle se plaint de g&egrave;ne respiratoire important.</p>\r\n<p>Elle pr&eacute;sente 3 nyctiuries en moyenne avec une hypersomnie diurne.</p>\r\n<p>Le score de Mallampati est de 4 /4.Son perimetre cervical est de 45 cm avec un perim&egrave;tre abdominal &agrave; 109 cm.</p>\r\n<p>Nous allons programmer une EFR et une polygraphie nocturne &agrave; Mme lebon ;</p>\r\n<p>Nous la placons sous a&eacute;rosolth&eacute;rapie (bricanyl-atrovent)x2/j avec onbrez 150/j et kin&eacute;siettt respiratoireX3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(385,113,'2013-12-30','Dr I.Patel\r\nSOS Oxygène','<p>Cher Ibrahim</p>\r\n<p>Je te &nbsp;remercie de m\'avoir adress&eacute; pour avis Mme REMILIE Marie C&eacute;line, n&eacute;e le 05/08/1940.</p>\r\n<p>cette dame se sent mieux .L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Elle n\'a plus de ddouleurs thoraciques.</p>\r\n<p>On poursuivra chez elle a&eacute;rosolth&eacute;rapie(BRICANYL-ATROVENT)X2 avec kin&eacute;siettt respiratoireX3/semaine.</p>\r\n<p>Elle prendra en outre de la VENTOLINE 2B &agrave; la demande.</p>\r\n<p>Je demande une GDS &agrave; AA chez cette patiente.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher Ibrahim, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(386,563,'2013-10-15','Dr REDON Joelle','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. HOAREAU Noah n&eacute; le 22/04/2003.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une histoire de rhinite avec bronchite depuis la naissance.</p>\r\n<p>Il fait des crises d\'asthme depuis l\'enfance .Il a eu un bilan allergologique qui a r&eacute;v&egrave;le une allergie aux acariens.</p>\r\n<p>Lundi 07/10/2013 il a pr&eacute;sent&eacute; de la fi&egrave;vre et depuis il tousse toutes les nuits.</p>\r\n<p>le 05/12/2012 il a present&eacute; un foyer dans la pyrmide basale du lobe inf&eacute;rieur droit qui a regress&eacute; sur la radiographie du 15/12/2013.</p>\r\n<p>le 05/12/2012 une radiographie des sinus maxillaires notait une sinusite ethmoido-maxillaire bilat&eacute;rale et frontale gauche.Une radiographie thoracique du 07/10/2013 retrouve un foyer heterog&egrave;ne comblant l\'angle cardiophr&eacute;nique droit.Actuellement Noah est trait&eacute; par AMOXICILLINE demarr&eacute; jeudi 10/10/2013,PULMICORT et VENTOLINE.</p>\r\n<p>Ce jour on note une toux grasse persistante avec &agrave; l\'auscultation un freinage expiratoire;</p>\r\n<p>Je conseille un traitement par SINGULAIR:5mg 1 cp le soir avec SERETIDE 125 microg X2 &agrave; l\'aide d\'une chambre d\'inhalation.Pour l\'infection pulmonaire il convient de poursuivre l\'antibiotique pendant 10jours au minimum avec vaccination tous les 5 ans contre le pneumocoque PNEUMO23.pour la sinusite il convient de le traiter par a&eacute;rosolth&eacute;rapie avec bicarbonate 14p mille m et s avec Kin&eacute;sieth&eacute;rapie respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(387,91,'2013-10-16','Dr Tamburini\r\nMedecin de bord\r\nCosta Croisieres','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. EVRIN Joseph Axel n&eacute; le 23/10/1939 .ce monsieur est un ancien fumeur 1pqt &agrave; 1pqt1/2/jour.</p>\r\n<p>Il est trait&eacute; pour HTA,suivi par Dr Begue pour un adenocarcinome prostatique trait&eacute; par radioth&eacute;rapie seule.</p>\r\n<p>Ce patient presente &nbsp;une BPCO avec un trouble ventilatoire obstructif mod&eacute;r&eacute; avec un VEMS &agrave; 1.4 soit 62% de la norme,le Tiffeneau est &agrave; 70%.Il existe des signes de distension pulmonaire avec VGT &agrave; 121% et VR &agrave; 119%.On note une augmentation de la resistance des voies a&eacute;riennes &agrave; 0.85 sans troubles du transfert.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; au CHGM pour decompensation de sa BPCO.</p>\r\n<p>Il doit faire une croisi&egrave;re fin octobre 2013 pendant deux semaines.</p>\r\n<p>Je lui conseille pendant toute la dur&eacute;e de la croisi&egrave;re:A&eacute;rosolth&eacute;rapie(Bricanyl-atrovent)X3/j et PulmicortX2/j avec rin&ccedil;age de la bouche ,Onbrez 300microg/j,Spiriva Respimat 2B/j.</p>\r\n<p>Il portera avec lui:Augmentin &agrave; prendre &agrave; raison de 1gX3 pendant 10 jours associ&eacute; &agrave; Ultralevure 2X3 en cas de crachats sales.En cas de forte g&egrave;ne respiratoire:Solupred 60mg en diminuant de 5mg tous les deux jours en vue arret.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(388,243,'2013-10-16','Dr Bruno CADET\r\nDr Gazaille','<p>Chers Coll&egrave;gues</p>\r\n<p>J\'ai vu ce jour M. TESTAN Joseph Marcel n&eacute; le 12/10/1933 qui pr&eacute;sente une masse lobaire sup&eacute;rieure droite de 29 mm d\'allure suspecte.</p>\r\n<p><span style=\"font-size: 11px;\">J\'ai rappel&eacute; ce jour le Dr Gazaille au sujet de ce malade.Il n\'a toujours pas eu sa fibroscopie bronchique et le Dr Gazaille m\'a dit que les secretaires du service allaient le convoquer.</span></p>\r\n<p><span style=\"font-size: 11px;\">le lui prescrit une NFS-plaquettes avec TP et TCA en vue de la fibroscopie bronchique.</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(389,173,'2013-10-16','Dr Goeury','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MOUCOUVEIA Marie Renette n&eacute;e le 21/09/1956.Cette dame mari&eacute; ,6 enfants,est employ&eacute; de maison.</p>\r\n<p>Elle a un grandp&egrave;re maternel asthmatique.Dans ses ant&eacute;c&egrave;dents personnels on note une ligature des trompes et une intervention de la cheville droite.Elle est trait&eacute; pour HTA.</p>\r\n<p>Son asthme a d&eacute;but&eacute; en 1989 apr&egrave;s un accouchement.Actuellement son asthme est bien equilibr&eacute; sous XOLAIR 225 mgX2/mois,Symbicort 1BX2/j et Singulair 10mg 1 cp le soir.Elle pr&eacute;sente un ronflement nocturne .Son score d\'Epworth est &agrave; 14/24.Le score de Mallampati est de3 /4.L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Je demande ce jour une radiographie pulmonire avec NFS-plqt,IgE totales,RAST aux Pneumallerg&egrave;nes et aux Trophallerg&egrave;nes.L\'EFR du 04/09/2013 retrouvait une distension pulmonaire avec VR &agrave; 133% CPT &agrave; 106% Le VEMS &eacute;tait &agrave; 1.41 soit 76% de la norme avec un Tiffeneau &agrave;, 77% et une augmentation de la resistance des voies a&eacute;riennes &agrave; 0.6.la TLCO &eacute;tait &agrave; 70% de la norme.Elle poursuivra le meme traitement .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(390,147,'2013-10-16','Dr Bruno CADET','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOUTMEZ Herminie Nelcie n&eacute;e le 23/06/1940.</p>\r\n<p>Cette dame &eacute;tait fumeuse 1pqt/j et est sevr&eacute; suite &agrave; son AVC il y 9 ans me dit elle.Elle totalise environ 20PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un AVC il y 9 ans environ ,une appendicectomie et une lobectomie sup&eacute;rieure gauche le 15/07/2008 pour un adenocarcinome pulmonaire.</p>\r\n<p>Elle est trait&eacute; pour DNID,HTA et BPCO.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III/IVde l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Elle pr&eacute;sente 2 nyctiuries et se sent fatigu&eacute;.Le score de Mallampati est de 2/4.</p>\r\n<p>l\'auscultation pulmonaire retrouve une diminution des bruits pulmonaires stethacoustiques.</p>\r\n<p>Ses EFR retrouvaient un trouble ventilatoire obstructif s&eacute;v&egrave;re Gold 3 avec un VEMS &agrave; 0.64 soit 35% de la norme avec un Tiffeneau &agrave; 75%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.63.</p>\r\n<p>Sur le plan biologique l\'Hct est &agrave; 40.6% avec Cr&eacute;atinine 111 &nbsp;micromol/L ce qui donne une clairance corrig&eacute;e &agrave; 44.Transaminases normales.</p>\r\n<p>Le scanner TAP est inchang&eacute; par rapport &agrave; l\'examen de mars 2012.</p>\r\n<p>Je conseille le traitement suivant :A&eacute;rosoltt(bricanyl-atrovent)X2/j onbrez 300/j;Miflonil 4001X2 avec rin&ccedil;age;spiriva Respimat2B/j .Elle refuse pour l\'instant la kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(391,439,'2013-10-16','Dr Grevelynche','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour l\'enfant MAILLOT Kenza n&eacute;e le 08/02/2004.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une cousine et un fr&egrave;re asthmatique.</p>\r\n<p>Histoire de la maladie : Kenza pr&eacute;sente un asthme depuis la tendre enfance mais n\'a jamais &eacute;t&eacute; hospitalis&eacute;e pour asthme.</p>\r\n<p>Le traitement anti reflux lui a &eacute;t&eacute; profitable.De meme on note une regression de la toux ;l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>la radiographie thoracique est dans les limites de la normale.Je demande un dosage d\'IgE totales et des RAST aux Pneumallergenes et aux Trophallerg&egrave;nes avec NFS pour rechercher une hypereosinophilie.</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale.La plethysmographie retrouve des VGT &agrave; 145% de la normale pouvant traduire une distension pulmonaire.Les resistances des voies a&amp;&eacute;riennes sont augment&eacute;es &agrave; 1.04.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(392,31,'2013-10-16','Dr Maigrat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GUICHARD Jean Pierre n&eacute; le 20/02/1949.</p>\r\n<p>Ce patient est un ancien fumeur sevr&eacute; depuis 1an.il totalise environ 22PA.</p>\r\n<p>Il est mari&eacute; 1 enfant.Il exercait la profession de manoeuvre macon.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une insuffisance h&eacute;patique post ethylique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IIIde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>La radiographie thoracique montre une distension thoracique avec aplatissement des coupoles diaphragmatiques avec de grosses arteres pulmonaires.</p>\r\n<p>sur le plan biologique on note un Hct &agrave; 36.4% avec des GDS &agrave; AA pH:7.5 pCO2:29Torr pO2 :74 Torr SaO2:96%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec un VEMS &agrave; 1.13 soit 42% de la norme; le Tiffeneau est &agrave; 59%Iil existe des signes de distension pulmonaire avec VGT &agrave; 189% CPT &agrave; 112% VR &agrave; 194% de la norme./Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.73.</p>\r\n<p>Sur le plan th&eacute;rapeutique le patient poursuivra:Onbrez 300;Spiriva Respimat 2B/j;miflonil400 1X2;A&eacute;rosolttt Bricanyl-Atrovent et kin&eacute;siett respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(393,122,'2013-10-16','Dr Marc GIGANTE','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous adresse en vue d\'une cystoscopie M. GRONDIN Luc n&eacute; le 17/02/1947.</p>\r\n<p>Ce patient, ancien fumeur, est sevr&eacute; depuis 2007. Il a eu une lobectomie sup&eacute;rieure gauche le 13/10/2007 suivie d\'une chimioth&eacute;rapie adjuvante pour un ad&eacute;nocarcinome bronchiolo-alv&eacute;olaire. Son dernier scanner thoracique date du 14/01/2013 et ne montrait pas de l&eacute;sion &eacute;volutive.</p>\r\n<p>Le scanner thoracique du 03/10/2013 retrouve des s&eacute;quelles de lobectomie &agrave; gauche sans particularit&eacute; avec toutefois &nbsp;une l&eacute;sion pari&eacute;tale de la face post&eacute;rieure de la vessie de 8 mm.L\' echographie r&eacute;nale et v&eacute;sicale du 11/10/2013 a montr&eacute; une l&eacute;sion tissulaire v&eacute;g&eacute;tante endo-luminale de 9 mm de diam&egrave;tre isol&eacute;e.</p>\r\n<p>&nbsp;</p>\r\n<p>En vous remerciant pour ce que vous ferez pour ce patient,veuillez agr&egrave;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(394,320,'2013-10-16','Dr DOUSSAUD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme THIAN MENG M Francine n&eacute;e le 21/10/1925.</p>\r\n<p>Cette dame est veuve et a 10 enfants.</p>\r\n<p>Mme Thian Meng a eu une cholecystectomie,elle a &eacute;t&eacute; op&eacute;r&eacute;e des 2 genoux et de la cataracte en mars 2013.</p>\r\n<p>En 2005 elle a pr&eacute;sent&eacute; une embolie pulmonaire au retour d\'un voyage.Elle est trait&eacute; pour une HTA.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultatiopn pulmonaire retrouve une diminuition des bruits pulmonaires stethacoustiques.On note un oed&egrave;me de la jambe droite pour laquelle je prescrit une echopgraphie des membres inf&eacute;rieurs qu\'elle vous fera voir.</p>\r\n<p>Son scanner thoracique sans injection montre une distension thoracique avec des DDB des lobes inf&eacute;rieurs et du lobe moyen s\'associant &agrave; des impactions mucoides.On note la pr&eacute;sence de plages hyperclaires dues &agrave; des phenom&egrave;nes de trappage li&eacute;s &agrave; une atteinte bronchiolaire &eacute;parse.</p>\r\n<p>L\'EFR de ce jour retrouve un trouble ventilatoire restrictif avec CPT &agrave; 68% avec un VEMS &agrave; 0.57 soit 41% de la norme.Le Tiffeneau est &agrave; 84% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.45.</p>\r\n<p>Je lui prescrit de l\'oxygenottt de courte dur&eacute;e avec la Phcie cheung leung.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(395,224,'2013-10-16','Dr Andriatavy','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SAUTRON Jules n&eacute; le 09/02/1926.</p>\r\n<p>Ce monsieur ancien fumeur 2 paquets/jour est sevr&eacute; depuis 35 ans.</p>\r\n<p>M.Sautron a &eacute;t&eacute; op&eacute;r&eacute; de l\'appendicite et des hemorroides.</p>\r\n<p>il &eacute;tait trait&eacute; pour HTA.il apr&eacute;sent&eacute; un AVC le 18/12/2002.Il pr&eacute;sente 3 &agrave; 4 nyctiuries.Son score d\'Epworth peut etre &eacute;valu&eacute; &agrave; 9/24.</p>\r\n<p>Le score de Mallampati est de 2 /4.</p>\r\n<p>Il aura une polygraphie nocturne le 27/01/2014.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(396,223,'2013-10-16','Dr ANDRIATAVY','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SAUTRON Berthe n&eacute;e le 05/10/1935.</p>\r\n<p>Cette dame est mari&eacute; ,une fille.Elle esty non fumeuse.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e de l\'appendicite et des hemorroides.</p>\r\n<p>Elle a pr&eacute;sent&eacute; un asthme dans l\'enfance avec urticaire et rhinite allergique.Elle est allergique &agrave; la cigarette.L\'auscultation pulmonaire est ce jour dans les limites de la normale.&nbsp;</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 80% de la norme, sans trouble du transfert. Le VEMS est &agrave; 1.41 soit 71% de la norme. Le tiffeneau est &agrave; 89 % de la norme.</p>\r\n<p>Il faut poursuivre la kin&eacute;sieth&eacute;rapie respiratoire.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(397,145,'2013-10-17','Dr Roselyne MARIMOUTOU','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MARIMOUTOU Albert n&eacute; le 27/05/1963.</p>\r\n<p>Vous trouverez cijoint copie des EFR et polysomnographie.</p>\r\n<p>Du fait qu\'il est entrain&eacute; &agrave; tenir l\'apn&eacute;e je dirais que ses EFR sont dans les limites de la normale.</p>\r\n<p>En ce qui concerne la polygraphie nocturne nous conseillons de completer cet examen par une polysomnographie.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(398,396,'2013-10-17','Dr Eric FONTAINE','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme CADET Marie France n&eacute;e le 09/09/1954.Mme cadet est mari&eacute; 2 enfants.</p>\r\n<p>Cette dame pr&eacute;sente dans ses ant&eacute;c&egrave;dents familiaux un fils asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une tympanoplastie,varices et appendicectomie ainsi qu\'une rhinite allergique.Elle pr&eacute;sente une allergie &agrave; la penicilline et &agrave; l\'aspirine.</p>\r\n<p>Son asthme a demarr&eacute; &agrave; la R&eacute;union en 1988.Elle n\'a jamais &eacute;t&eacute; hospitalis&eacute; pour asthme, mais son asthme s\'est aggrav&eacute; depuis 6ans,sa derni&egrave;re grosse criqse date de mars 2012.</p>\r\n<p>L\'ausculation pulmonaire est ce jour normal .</p>\r\n<p>Le scanner des sinus retrouve un aspect congestif de la muqueuse au niveau des fosses nasales avec hypertrophie des cornets pouvant favoriser des ph&eacute;nom&egrave;nes de rhinite.A traiter par PULMICORT en a&eacute;rosolth&eacute;rapie.</p>\r\n<p>La NFS ne retrouve pas d\'hypereosinophilie avec des IgE totales inf&eacute;rieure &agrave; 25UI/ml.</p>\r\n<p>Le CLA30 mixte au pneumallerg&egrave;nes est non significatif de meme pour les allerg&egrave;nes alimentaires.Seul D.farinae est positif &agrave; 1.</p>\r\n<p>L\'EFR &nbsp;r&eacute;alis&eacute;e ce jour montre une spirographie et une plethysmographie dans les limites de la normale.La TLCO est &agrave; 69% de la norme et je demande ce jour une radiographie thoracique.</p>\r\n<p>En attendant il convient que Mme Cadet poursuive seretide 500 BX2;Aerius 5mg et singulair 10mg 1cp le soir;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(399,238,'2013-10-17','Dr Andriatavy\r\nDr Laurent  Grand Pré\r\nORL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAKOTOMALALA URSULA MARIE n&eacute;e le 31/01/1973.</p>\r\n<p>Cette dame divorc&eacute;e a 3 enfants.Elle travaille comme agent d\'entretien.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une fille asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note un curetage ut&eacute;rin et un panaris ainsi qu\'un asthme dans l\'enfance.</p>\r\n<p>actuellement elle pr&eacute;sente un ronflement s&eacute;v&egrave;re avec un score d\'Epworth &agrave; 14/24.</p>\r\n<p>Le score de Mallampati est de 2/4.L\'auscultation pulmonaire est ce jour sans grande particularit&eacute;.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec dosage d\'IgE totales et RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>L\'EFR pratiqu&eacute; dce jour r&eacute;v&egrave;le un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 67% de la norme.La spirographie est dans les limites de la normale.On note une augmentation de la resistance des voies a&eacute;riennes avec RVA &agrave; 0.38 sans trouble du transfert.</p>\r\n<p>Elle b&eacute;n&eacute;ficiera d\'une polygraphie nocturne le 18/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(400,282,'2013-10-17','Dr Jean SERGE\r\nDr Sanogo\r\nCardilogue\r\nISIS Medical','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. BELAIR paul, n&eacute; le 06/02/1939;</p>\r\n<p>Ce monsieur vit en concubinage et a 6 enfants.Il travaillait comme docker et est &agrave; la retraite depuis 1991.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un tabagisme &agrave; environ 40Pa sevr&eacute; depuis 2000.</p>\r\n<p>il a &eacute;t&eacute; oper&eacute; en 1965 du rachis et de l\'art&egrave;re r&eacute;nale me dit il.</p>\r\n<p>Il est suivi pour HTA,insuffisance coronarienne &nbsp;et BPCO s&eacute;v&egrave;re.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec assordissement des bruits pulmonaires stethacoustiques et quelques sibilances.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif s&eacute;v&egrave;re Gold III avec un VEMS &agrave; 0.82 soit 33% de la norme.Il existe une distension pulmonaire avec VGT &agrave; 219% CPT &agrave; 145% et VR &agrave; 258% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.96 et il existe des troubles de la diffusion avec TLCO &agrave; 28% de la norme.</p>\r\n<p>La radiographie thoracique retrouve des signes de distension thoracique avec aplatissement des coupoles diaphragmatiques et grosses art&egrave;res pulmonaires.On note une hyperclart&eacute; retrosternale.</p>\r\n<p>Il convient de poursuivre le traitement parCortancyl 40 mg le matin en diminuant de 5 mg tous les deux jours.inexium 40 mg le soir avec Gaviscon 1X3;Onbrez 300/j Spiriva respimat 2B/j;A&eacute;rosolth&eacute;rapie (bricanyl-Atrovent)X3 et PulmicortX2 avec rin&ccedil;age ;Kin&eacute;siettt respiratoire et VNI associ&eacute; &agrave; OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(401,559,'2013-10-17','',''),(402,319,'2013-10-17','Dr AZAIS\r\nSeprodom.','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MADELEINE Pierre n&eacute; le 03/12/1932.</p>\r\n<p>Ce monsieur ancien fumeur sevr&eacute; depuis 5 ans fumait un &nbsp;paquet /jour.Il totalise environ 60PA.</p>\r\n<p>Il s\'agit d\'un ancien manoeuvre macon &agrave; la retraite.Il est mari&eacute; 10 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une HTA avec IVG avec FEVG &agrave; 40/45%,une insuffisance r&eacute;nale chronique,un DID,une BPCO post tabagique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade V de l\'&eacute;chelle du Modified Medical Research Council.Le patient est sous OLd 24H/24.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques fins crepitants aux bases.Le TDM thoracique du 04/09/2013 montre des DDB cylindriques des deux lobes inf&eacute;rieurs et du lobe moyen.Des l&eacute;sions emphysemateuses pr&eacute;dominant aux 2 lobes sup&eacute;rieurs .</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte :GOLD III s&eacute;v&egrave;re dans sa composante obstructive .Il, existe des signes de distension pulmonaire avec VGT &agrave; 226% CPT &agrave; 127% VR &agrave; 258%.Hct &agrave; 23.3%.La GDS &agrave; AA retrouve :</p>\r\n<p>pH 7.54 pCO2 33.6 pO2:61.7 SaO2:94%.</p>\r\n<p>Il convient de poursuivre chez ce patient ;A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X2 PulmicortX2 avec rin&ccedil;age ;Onbrez &nbsp;&agrave; passer &agrave; 300microg/j; Spiriva Respimat 2B/j et Kin&eacute;siettt respiratoire X 2/jour ainsi que OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(403,479,'2013-10-17','','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme DELMOND Andy Risla n&eacute;e le 26/02/1942.</p>\r\n<p>je conserve ce jour les scanners thoraciques et surrenaliens des 10/01/2013,27/06/2013 et du 25/09/2013 &agrave; fin de comparaison.</p>\r\n<p>Dr. B. TANGUY</p>'),(404,572,'2013-10-17','Dr RAJABALY\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. KAMIS Razaaly, n&eacute; le 04/06/1950</p>\r\n<p>ce monsieur est fumeur actuellement 5 cigarettes/jour autrfois 12 &agrave; 15 cigarettes/jour.Il totalise environ 30PA.</p>\r\n<p>Il est commercant,mari&eacute;,3 enfants;</p>\r\n<p>dans ses ant&eacute;c&egrave;dents personnels il a &eacute;t&eacute; op&eacute;r&eacute; d\'une hernie ombilicale &agrave; 2 reprises et d\'une d&eacute;viation de la cloison nasale &nbsp;ainsi que du menisque gauche et de l\'&eacute;paule droite.il est trait&eacute; pour hernie discale,HTA,un prostatisme.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; en 1998 pour une insuffisance coronarienne et a eu la pose de deux stents.L\'echocardiographie datant du 30/03/2012 montre un VG moderement dilat&eacute; avec une fonction systolique globale mod&eacute;r&eacute;ment abaiss&eacute;e.Il n\'a pas &eacute;t&eacute; retrouv&eacute; d\'HTAP.La scintigraphie myocardique du 06/04/2012 montre des s&eacute;quelles d\'infarctus du myocarde transmurale &eacute;tendue.</p>\r\n<p>Il es trait&eacute; par :CORDARONE,HYZAAR,PLAVIX,LOGIMAX,LODALES,INEXIUM,AERIUS,LYRICA,STILNOX,VOLTARENE,DAFALGAN,XATRAL.,VALDOXAN.</p>\r\n<p>Actuellement le patient pr&eacute;sente un serrement thoracique ant&eacute;rieur gauche avec&nbsp;&nbsp;une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Il se couche tard,a des probl&egrave;mes d\'insomnie trait&eacute; par XANAX et STILNOX.</p>\r\n<p>Le score de Mallampati est de 2 /4.Le malade &eacute;tablira un agenda de sommeil.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques sibilances dans le champ pulmonaire ant&eacute;rieur.</p>\r\n<p>Je demande ce jour :une EFR,un scanner thoracique,un dosage de proBNP.A distance une polygraphie nocturne.</p>\r\n<p>Je lui prescrit pour l\'instant de l\'Onbrez 150/j associ&eacute; &agrave; Alvesco 160microg/j &agrave; l\'aide d\'une chambre d\'inhalation A&eacute;rochamber.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(405,523,'2013-10-17','Dr Peyronnet\r\nDr Genin','<p>Cher Confr&egrave;re</p>\r\n<p>M.DELAPORTE Joel n&eacute; le 02/05/1952 a eu ce jour une EFR.</p>\r\n<p>Cet examen a retrouv&eacute; un trouble ventilatoire restrictif avec CPT &agrave; 5.45 soit 78% de la norme;VR &agrave; 71% de la norme.Le VEMS est &agrave; 2.81 soit 85% de la norme avec un Tiffeneau &agrave; 97% et des troubles mod&eacute;r&eacute;s de la diffusion:TLCO &agrave; 74% de la norme.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(406,195,'2013-10-17','Dr Omarjee','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en consultation Mme SAUTRON Eva Marie Therese n&eacute;e le 11/12/1956.</p>\r\n<p>Elle pr&amp;&eacute;sente une toux depuis lundi grasse avec expectoration blanchatre &eacute;paisse.</p>\r\n<p>Je lui renouvelle XOLAIR 375mgX2/mois avec dosage IgE Totales et NFS.</p>\r\n<p>Je la place sous a&eacute;rosolth&eacute;rapie(Bricanyl-atrovent)X2 avec PulmicortX2 avec rin&ccedil;age de la bouche &agrave; l\'eau.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(407,379,'2013-10-17','Dr Jean Paul MOREAU','<p>J</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai re vu ce jour M. HOAREAU Louis n&eacute; le 28/04/1935.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire obstructif Gold IV avec un VEMS &agrave; 0.58 soit 28% de la norme avec un Tiffeneau &agrave; 59% de la norme.Ilm existe des signes de distension pulmonaire avec VGT &agrave; 138%,VR &agrave; 147%. Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.16 .</p>\r\n<p>La radiographie thoraciquen montre des signes de distension thoracique avec abaissement et d&eacute;formation diaphragmatique.Il existe des signes de redistribution vasculaire vers les sommets.Je demande ce jour un TDM thoracique sans injection avec une echocardiographie.</p>\r\n<p>Sur le plan biologique on note un Hct &agrave; 44.3%.</p>\r\n<p>La GDS &agrave; AA retrouve:pH:7.35;pCO2:54.6 Torr;Po2:86.1Torr ;CO2Total 31mmol/l SaO2:96%</p>\r\n<p>Le malade &nbsp;poursuivra : kin&eacute; respi, OLD, VNI, ombrez 300micro/j, Spiriva Respimat 2b, A&eacute;rosol (bricanyl atrovent) x 2, et Pulmicort x 2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Je vous prie de croire, chez confr&egrave;re et ami, &agrave; l\'assurance de ma haute consid&eacute;ration,<br />Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(408,235,'2013-10-18','Dr Satsou','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PITOU Jeannine n&eacute;e le 23/01/1950.</p>\r\n<p>Cette dame non fumeuse est mari&eacute; et a 6 enfants.Dans ses ant&eacute;c&egrave;dents on note une cholecystectomie en 1983 et une c&eacute;sarienne.</p>\r\n<p>En avril 2012 elle a pr&eacute;sent&eacute; un &eacute;panchement pleural droit avec une opacit&eacute; de la base droite qui s\'est r&eacute;v&egrave;l&eacute; etre un adenocarcinome pulmonaire primitif droit .L\' &eacute;panchement pleural droit &nbsp;a &eacute;t&eacute; talqu&eacute;.L\'analyse en biologie mol&eacute;culaire a montr&eacute; une mutation du g&egrave;ne de l\'EGFR(exon 19) au niveau de l\'adenocarcinome.</p>\r\n<p>Depuis Mme PITOU est trait&eacute; par IRESSA 250mg/j avec TERTALYSAL 300mg/j.Elle ne pr&eacute;sente pas de troubles dermatologiques et se lave au savon de Marseille.</p>\r\n<p>Mme Pitou est en bon &eacute;tat g&eacute;n&eacute;ral avec un poids de 75 Kilos pour 1m56,soit une BMI de 30.8.La palpation des aires ganglionnaires est normale et l\'auscultation pulmonaire est sans grande&nbsp;particularit&eacute;.</p>\r\n<p>&nbsp;L\'EFR &nbsp;retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT est &agrave;2.81 soit 62% de la normeavec un &nbsp;VR &agrave; 66% Le VEMS est &agrave;&nbsp;1.28 soit64% de la norme avec un Tiffeneau &agrave; 92% de la norme.il existe un trouble du transfert avec TLCO &agrave;67% de la norme.</p>\r\n<p>Le dossier de Mme PITOU n\'a pu etre pr&eacute;sent&eacute; en RCP d\'Oncologie thoracique le 17/10/2013 car cet RCP a &eacute;t&eacute; annul&eacute;.J\'ai conserv&eacute; le TAP du 03/10/2013 qui sera compar&eacute; &agrave; celui du 03/06/02013 en pr&eacute;sence du Dr Mascarel.</p>\r\n<p>Je lui prescrit ce jour son traitement par IRESSA &agrave;) la meme dose.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(409,174,'2013-10-18','Dr Virapoullé','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour en consultation:M./Mme/L\'enfant KAROUMBATA H&eacute;l&egrave;ne n&eacute;e le18/08/1934;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on noteun p&egrave;re asthmatique.Dans ses ant&eacute;c&egrave;dents personnels c&nbsp;hirurgicaux une appendicectomie et&nbsp;un abc&egrave;s de la jambe gauche.Ant&eacute;c&egrave;dents m&eacute;dicaux un diab&egrave;te insulino d&eacute;pendant et&nbsp;une HTA</p>\r\n<p>Mme Karoumbata .est non fumeuse mais cuisinait au feu de bois dans son enfance.Elle exercait &nbsp;la profession d\'assistante maternelle.&nbsp;Elle est c&eacute;libataire sans enfant.</p>\r\n<p>Histoire de la Maladie:Mme Karoumbata a pr&eacute;sent&eacute; ses premi&egrave;res \"crises d\'asthme\" &agrave; l\'age de 21 ans &agrave; la suite d\'une bronchite.Elle est actuellement trait&eacute; par FORADIL,MIFLONIL,SPIRIVA RESPIMAT et KINESIE THERAPIE RESPIRATOIRE.</p>\r\n<p>Actuellement &agrave; l\'examen clinique on note une diminution des bruits pulmonaires sth&eacute;tacoustiques.La malade va mieux.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re peu r&eacute;versible aux b2mimetiques avec distension pulmonaire et augmentation des resistances des voies a&eacute;riennes.Le VEMS est &agrave; 0.63 soit 48% de la norme;avec un Tiffeneau &agrave; 56%.La VGT est &agrave; 159% CPT &agrave; 105% et VR &agrave; 1401% de la norme.</p>\r\n<p>Le scanner thoracique du 07/09/2013 retrouve effectivement des foyers du lobe sup&eacute;rieur droit avec de petites at&eacute;lectasies distales du lobe moyen et de la lingula qui seront &agrave; controler dans 3 mois.Je garde le scanner pour analyse avec le Dr Mascarel.</p>\r\n<p>Sur le plan biologique on note une Hct &agrave; 40.2&ugrave; il n\'existe pas d\'hypereosinophilie.La CRP est &agrave; 4.6.</p>\r\n<p>Le traitement est reconduit &agrave; l\'identique.</p>\r\n<p>Veuillez agr&egrave;er,cher Confr&egrave;re,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>&nbsp;</p>'),(410,484,'2013-10-18','Dr Jaglale','<p>Cher Confr&egrave;re</p>\r\n<p>Je revois ce jour Melle Canaguy qui me dit avoir eu un rhume au cours des deux derni&egrave;res semaines.</p>\r\n<p>Elle se plaint essentiellement d\'une toux productive avec des secretions visqueuses.</p>\r\n<p>Elle m\'a apport&eacute; sa radiographie pulmonaire du 11/10/2013 qui ne montre pas d\'anomalie parenchymateuse.</p>\r\n<p>Elle m\'a &eacute;galement &nbsp;apport&eacute; son scanner des sinus maxillaires qui est aussi dans les limites de la normale.</p>\r\n<p>Je lui propose un traitement plus radical avec a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent) m et s avec A&eacute;rosolttt de bicarbonate 14 p mille m et s &nbsp;associ&eacute; &agrave; une kin&eacute;siettt respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(411,585,'2013-10-18','dr Bicharzon-lionnet','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MOUTON Herv&eacute; n&eacute; le 29/08/1958.</p>\r\n<p>ce monsieur est en vacances &agrave; la R&eacute;union.Il est ing&eacute;nieur ,non fumeur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents il a &eacute;t&eacute; trait&eacute; pour une pneumopathie de la base droite trait&eacute; &agrave; l\'hopital de Fontainebleau.</p>\r\n<p>Depuis il pr&eacute;sente une toux avec des secretions matinales.</p>\r\n<p>Depuis trois jours il pr&eacute;sente un febricule qui hier soir s\'est transforme en fi&egrave;vre franche.</p>\r\n<p>L\'examen clinique en particulier l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Je lui conseille un traitement par AMOXICILLINE pendant 7 jours.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(412,552,'2013-10-18','Dr Charles-RabesiaKa','<p>Cher Confr&egrave;re</p>\r\n<p>M.Robert ,Gilbert ayant eu hier son LBA au CHU de Bellepierre je pense qu\'il est licite de demarrer une corticoth&eacute;rapie sans tarder.</p>\r\n<p>Il prendra du Cortancyl 60 mg le matin pendant 6 semaines,puis &agrave; doses d&eacute;gressive &agrave; raison de 40 mg le matin pendant 6 semaines &nbsp;dans un premier temps et en fonction du r&eacute;sultat des examens biologiques et de l\'imagerie.</p>\r\n<p>Il est important que M.Robert r&eacute;cup&egrave;re les r&eacute;sultats des precipitines vis &agrave; vis de la maladie des &eacute;leveurs d\'oiseaux car il &eacute;l&egrave;ve 30 poulets et avait jusqu\'&agrave; 300 poulets par mois.Il est important que d&egrave;s &agrave; pr&eacute;sent M.Robert envisage de se d&eacute;barasser de ses poulets.</p>\r\n<p>Nous adjoindrons &agrave; cette corticoth&eacute;rapie de l\'Inexium 40 mg le soir et du Calci D3 1 cp m et s.</p>\r\n<p>Je demande un nouveau scanner apr&egrave;s 5 semaines de traitement et le reverrai apr&egrave;s.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(413,584,'2013-10-18','Dr Doussaud','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Melle GRONDIN Sylvie Elsa n&eacute;e le 25/01/1991.</p>\r\n<p>Cette jeune fille c&eacute;libataire est sans profession.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note des convulsions hyperthermiques en 1991 et 1992.</p>\r\n<p>elle pr&eacute;sente un asthme depuis l\'age de 14 ans trait&eacute; par VENTOLINE et aussi une rhinite allergique.</p>\r\n<p>On ne retrouve pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Il y a une semaine,Melle Grondin a aval&eacute; une pastill&eacute; &agrave; la menthe avec sensation de fausse route;</p>\r\n<p>depuis elle tr&eacute;sente une g&egrave;ne dans la gorge et cela d&eacute;clenche une toux.</p>\r\n<p>L\'auscultation pulmonaire montre un freinage expiratoire &agrave; la toux.</p>\r\n<p>la radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>Je vous conseille le traitement suivant:gararisme &agrave; l\'ELUDRIL m et s pendant 10 jours,FORADIL 1 gel inhal m et s MIFLONIL 400 1 gel inh met s pendant 1 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(414,142,'2013-10-18','Dr Fechner','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme NOEL MURIELLE n&eacute;e le 26/12/1988.</p>\r\n<p>Son asthme est actuellement bien control&eacute; et elle a arret&eacute; de fumer.</p>\r\n<p>L\'auscultation &nbsp;pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Il faut poursuivre le meme traitement en y adjoignant du Spiriva Respimat en raison de la distension pulmonaire.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(415,218,'2013-10-21','','<p>J\'ai vu ce jour M. RACOUTE Augustin n&eacute; le 19/06/1935.</p>\r\n<p>Ce &nbsp;patient est un ancien fumeur 1 paquet/j sevr&eacute; depuis plus de 20 ans totalisant 30PA environ.</p>\r\n<p>Il s\'agit d\'un ancien agriculteur,veuf,8 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une resction endoscopique de la prostate,une appendicectomie.</p>\r\n<p>il est trait&eacute; pour HTA .Je le suis depuis de nombreuses ann&eacute;es pour une BPCO.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.Il pr&eacute;sente une toux matinale avec expectoration blanchatre.</p>\r\n<p>L\'examen clinique retrouve &agrave; l\'auscultation une diminuition des bruits pulmonaires stethacoustiques avec un signe de Harzer.</p>\r\n<p>Le scanner thoracique note une discr&egrave;te d&eacute;formation thoracique sans anomalie parenchymateuse pulmonaire &eacute;volutive.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif GOLD IV tr&egrave;s s&eacute;v&egrave;re avec un VEMS &agrave; 0.49 soit 24% de la norme.Le Tiffeneau est &agrave; 56% .La plethysmographie montre des signes de distension pulmonaire avec VR &agrave; 243% CPT &agrave; 145% VGT &agrave; 222%.il existe des troubles de la diffusion avec TLCO &agrave; 55%.</p>\r\n<p>Sur le plan th&eacute;rapeutique il poursuivra le meme traitement:Onbrez 300 1B/j;Spiriva Respimat 2B/j;Ventoline en cas de besoin;A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 Miflonil 1 gel inhal&eacute; m et s;kin&eacute;sieth&eacute;rapie respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(416,75,'2013-10-21','Dr Paoli\r\nISIS Médical','<p>Cher Confr&egrave;re,</p>\r\n<p><span style=\"font-size: 11px;\">J\'ai vu ce jour M. TSIFOUMBY Georges n&eacute; le 14/10/1954</span>Ce patient ancien fumeur sevr&eacute; depuis 20ans fumait 10 cigarettes/j et totalise environ 15PA.Il travaillait &nbsp;comme coupeur de cannes,macon et ne travaille plus depuis 10 ans.Il est veuf avec 2 enfants.</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une proth&egrave;se totale de hanche gauche le 18/06/2013 pour ost&eacute;on&eacute;crose.Il a eu un AVP et a &eacute;t&eacute; amput&eacute; du bras droit le 16/04/2007.Il pr&eacute;sente un DID ,une HTA et a des ant&eacute;c&egrave;dents de tuberculose pulmonaire avec des DDB et des at&eacute;lectasies des 2 apex associ&eacute; &agrave; &nbsp;plusieurs nodules pulmonaires calcifi&eacute;es.M.Tsifoumby pr&eacute;sente un poids de 89K pour une taille de 163 cm soit un IMC de 32Kg/m2 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Il pr&eacute;sente une toux matinale avec expectoration blanchatre.</p>\r\n<p>Son score d\'Epworth est de 17/24 avec un&nbsp;&nbsp;score de Mallampati est de 3 /4.L\'auscultation pulmonaire retrouve des ronchi dissemin&eacute;s dans les deux champs &nbsp;pulmonaires.</p>\r\n<p>le TDM thoracique des l&eacute;sions nodulaires calcifi&eacute;s des deux champs pulmonaires avec des DDB des deux apex.L\'EFR montre un trouble ventilatoire mixte avec VEMS &agrave; 1.49 soit 52% de la norme avec un Tiffeneau &agrave; 83%.Il existe une distension thoracique importante avec VGT &agrave; 186% CPT &agrave; 130% et VR &agrave; 265% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.55 et il existe des troubles du transfert avec TLCO &agrave; 59% de la norme.M. Tsifoumby a eu le 05/07/2013 une fibroscopie bronchique avec aspiration tracheo bronchique qui a montr&eacute; l\'absence de BK &agrave; l\'examen direct .</p>\r\n<p>M.Tsifoumby a b&eacute;n&eacute;fici&eacute; le 10/10/2013 d\'une polygraphie nocturne .Vous trouverez ci joit le r&eacute;sultat de cet examen qui montre un IAH &agrave; 30/H passant &agrave; 38/H si on y associe les &eacute;venements.On note de nombreuses d&eacute;saturations 43/H avec une saturation minimale de 54% et une saturation moyenne de 89%.On note de nombreux &eacute;crasements de l\'onde de pouls concomitants aux &eacute;pisodes d\'Apn&eacute;s-hypopn&eacute;s.Il sera appareill&eacute; par la soci&eacute;t&eacute; ISIS M&eacute;dical qui le contactera directement.</p>'),(417,581,'2013-10-21','Dr Bruno CADET\r\nRESPIDOM\r\nO2CM.','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BATOU Suzanne n&eacute;e le 24/01/1941.</p>\r\n<p>Mme Batou est c&eacute;libataire sans enfant.Elle est &agrave; la retraite et travaillait comme femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour fibrome ut&eacute;rin,une cholecystectomie,intervention sur des varices.</p>\r\n<p>Elle est trait&eacute; pour DID,HTA,et la BPCO .Elle &eacute;tait soumise &agrave; la fum&eacute;e de feu de bois dans l\'enfance.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont commenc&eacute; &agrave; l\'age de 50 ans.</p>\r\n<p>Elle est appareill&eacute; par RESPIDOM avec a&eacute;rosolth&eacute;rapie &nbsp;ainsi que BIPAP avec un concentrateur d\'oxyg&egrave;ne par la Soci&eacute;t&eacute; O2CM.Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation retrouve des ronchi dans les deux champs pulmonaires.le ventre est ballonn&eacute; et parfois elle pr&eacute;sente des oed&egrave;mes aux membres inf&eacute;rieurs.</p>\r\n<p>Je demande ce jour un TDM thoracique sans injection ainsi qu\'une GDS &agrave; AA et une NFS.</p>\r\n<p>Elle continuera ses A&eacute;rosolttt (Bricanyl-Atrovent)X2 ;pulmicortX2 avec rin&ccedil;age;Kin&eacute;siettt respiratoire 20 s&eacute;ances/mois;Onbrez 150 micro/j;Spiriva Respimat 2B/j.</p>\r\n<p>Je la reverrai pour des EFR le 4/11/2013.Mme Batou a un sommeil de mauvaise qualit&eacute; et nous programmerons une polygraphie nocturne pour elle.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(418,222,'2013-10-21','Dr Gouery\r\nISIS Médical','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MOUCOUVEIA Emile Pierre n&eacute; le 27/09/1976.</p>\r\n<p>Son &nbsp;score de Mallampati est de 2 /4.Son score d\'Epworth est &agrave; 8/20.</p>\r\n<p>Son IMC est &agrave; 30.5 ce qui correspond &agrave; une obesit&eacute; mod&eacute;r&eacute;.</p>\r\n<p>La polygraphie nocturne pratiqu&eacute; le 15/10/2013 montre un Index d\'Apn&eacute;es hypopn&eacute;es de 35/heure.Cet index passe &agrave; 38/heure quand on y ajoute les &eacute;venements obstructifs avec indicateurs non corticaux.</p>\r\n<p>Par ailleurs on retrouve 654 ronflements/H avec une energie moyenne de 94 dB.On note une d&eacute;saturation minimale de 84% .</p>\r\n<p>M. Moucouveia sera appareill&eacute; demain par la Soci&eacute;t&eacute; ISIS M&eacute;dical en principe demain dans un premier temps en mode autopilot&eacute;e avec une PPC entre 5 ety 15 cm d\'eau.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(419,562,'2013-10-21','Dr GUILBAUD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LLOPIS Lydia n&eacute;e le 28/11/1957.</p>\r\n<p>Cette dame non fumeuse ,exerce la profession de comptable.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie et une hyperthyroidie trait&eacute; par Iode 131 &agrave; l\'hopital de Bellepierre.Elle a fait une d&eacute;pression il y 4 ans.</p>\r\n<p>Depuis 6 ans elle pr&eacute;sente une insomnie survenue dans un contexte de stress.Elle a pris deux DONORMYL / semaine .</p>\r\n<p>Elle a &eacute;t&eacute; suivie par le Dr Achninov qui lui a donn&eacute; du TERCIAN XXX gtes pour dormir.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est normale;</p>\r\n<p>Le score de Mallampati est de 1/4.le score d\'epworth est de 6/24 au maximum.</p>\r\n<p>J\'ai donn&eacute; &agrave; mme llopis un agenda de sommeil &agrave; remplir.Nous avons convenu d\'une polysographie nocturne le 04/11/2013.</p>\r\n<p>Mais je pense que son insomnie est avant tout reactionnel &agrave; sa d&eacute;pression et je lui ai conseill&eacute; une th&eacute;rapie comportementale cognitive et de relaxation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(420,69,'2013-10-21','Dr Paratian Uva\r\nSeprodom','<p>Cher ami</p>\r\n<p>J\'ai vu ce jour Mme DENISET Lucie n&eacute;e le 07/03/1939.</p>\r\n<p>L\'Echelle d\'Epworth est &agrave; 19/24.Le score de Mallampati est de 4 /4.et il existe 2 nyctiuries.</p>\r\n<p>Il convient de poursuivre lme meme traitement Aerosoltherapie ,Kin&eacute;siettt respiratoire,Symbicort 400 1X2.</p>\r\n<p>Avec mes remerciements, veuillsz agr&eacute;er, cher ami, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(421,544,'2013-10-21','Dr Thierry BORG','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme COUSIN C&eacute;cile n&eacute;e le 15/12/1983.</p>\r\n<p>Elle va mieux depuis le traitement par l\'a&eacute;rosolth&eacute;rapie par BRICANYLX2/jour et SYMBICORT 2B X2/jour.</p>\r\n<p>L\'auscultation est ce jour dans les limites de la normale.Je pense que l\'on peut repasser &agrave; BRICANYL que le jour uniquement le matin.</p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(422,528,'2013-10-21','Dr Andriantavy','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. TALBOT Francis n&eacute; le 15/06/1947.</p>\r\n<p>Ce patient a b&eacute;n&eacute;fici&eacute; dans la nuit du 10 au 11/10/2013 d\'une polygraphie nocturne.</p>\r\n<p>Cet examen qui a port&eacute; sur une dur&eacute;e valid&eacute;e de 6H18 min a retrouv&eacute; un Index d\'Apn&eacute;e-hypopn&eacute;e de 12/heure.L\'index passe &agrave; 16/h avec les &eacute;v&egrave;nements obstructifs et &agrave; 24/heure en y incluant les diminutions de d&eacute;bit.</p>\r\n<p>Comme on appareille &agrave; 30/heure M.Talbot n\'est pas &agrave; appareill&eacute; pour l\'instant.</p>\r\n<p>J\'ai insist&eacute; aupr&egrave;s de lui pour qu\'il arrete de fumer.Je demande ce jour un doqsage de proBNP.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(423,489,'2013-10-21','Dr Andriantavy','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MARQUET Jean Claude n&eacute; le 07/03/1940.</p>\r\n<p>Les EFR paratiqu&eacute;s ce jour retrouvent une spirographie dans les limites de la normale,l\'absence de trouble de la diffusion .il existe en revanche une distension pulmonaire avec Vr &agrave; 148% et VGT &agrave; 146% de la norme.&nbsp;</p>\r\n<p>il serait bon de pratiquer un TDM thoracique sans injection.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(424,316,'2013-10-21','Dr Fouassin','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. OLIVIER Antoine Roger n&eacute; le 29/04/1940.</p>\r\n<p><span style=\"font-size: 11px;\">Ce patient pr&eacute;sente ce jour une SaO2 &agrave; 91% &agrave; AA avec un pouls &agrave; 112.</span></p>\r\n<p><span style=\"font-size: 11px;\">Il pr&eacute;sente une hypersomnie diurne avec un&nbsp;</span>&nbsp;score de Mallampati est de4 /4.</p>\r\n<p>Nous lui programmons une polygraphie nocturne le 08/01/2013.</p>\r\n<p>En attendant il convient de poursuivre chez lui a&eacute;rosolth&eacute;rapie(BRICANYL-ATROVENT)X2 avec PULMICORTX2 avec rin&ccedil;age .Kin&eacute;sieth&eacute;rapie respiratoire :technique de ventilation dirig&eacute;e 20 s&eacute;ances/mois au domicile du malade ;Onbrez 150 microg/j et Spiriva Respimat 2B/Jour et Oxyg&eacute;noth&eacute;rapie de longue dur&eacute;e 2l/mn 18H/24H.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(425,164,'2013-10-21','Dr Hossenboccus\r\nDr Laurent Grandpré\r\nORL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. POINAPIN Rosaire n&eacute; le 15/04/1964.</p>\r\n<p>Ce monsieur mari&eacute;,4 enfants travaille &agrave; &nbsp;MIDAS comme commercial</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un tabagisme &agrave; 2paquets/jour sevr&eacute; depuis 6 ans.il totalise environ 35PA.Il a eu une appendicectomie et pr&eacute;sente une hypercholesterol&eacute;mie.Il pr&eacute;sente des ronflements importants et a consult&eacute; le Dr Laurent Grandpr&eacute; qui nous l\'a adress&eacute; pour polysomnographie.Son score d\'Epworth est de 12/24.</p>\r\n<p>Le score de Mallampati est de 2 /4.Il pr&eacute;sente rarement des nyctiuries.Son poids est de 73 kilos pour une taille de 1m67 soit un IMC de 26.2 ce qui correspond &agrave; un l&eacute;ger surpoids.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire restrictif avec une CPT &agrave; 62%,et un VGT &agrave; 69% de la norme.Le VEMS est &agrave; 2.65 soit 81% de la norme avec un Tiffeneau &agrave; 97% de la norme.La TLCO est &agrave; 72% de la norme.Ces EFr seront &agrave; recontroler apr&egrave;s kin&eacute;siettt respiratoire.</p>\r\n<p>M.POINAPIN a b&eacute;n&eacute;fici&eacute; dans la nuit du 3 au 04/09/2013 d\'une polysomnographie ;Cet examen &nbsp;a &eacute;t&eacute; valid&eacute; sur 7h59min.Il a &eacute;t&eacute; not&eacute; un Index d\'apn&eacute;e -hypopn&eacute;e de 35/heure passant &agrave; 44/heure en y incluant les &eacute;v&egrave;nements.Le nombre de micro-&eacute;veils est de 41/heure dont 7 sup&eacute;rieur &agrave; 30s soit une dur&eacute;e totale de 97min.Vous trouverez ci-joint une analyse compl&egrave;te de l\'enregistrement.</p>\r\n<p>Nous contactons SOS Oxyg&egrave;ne qui va appareiller ce patient en PPC en mode autopilot&eacute; &agrave; une pression entre 5 et 15 cm d\'eau.Le patient sera contact&eacute; directement chez lui.</p>\r\n<p>Je demande un TDM thoracique sans injection chez ce patient et je le place sous Kin&eacute;siettt respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(426,237,'2013-10-22','Dr Satsou\r\nARAR','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme OLLIVIER Jeanne n&eacute;e le 16/02/1928.</p>\r\n<p>Cette dame veuve a 7 enfants.Elle travaillait comme femme de m&eacute;nage.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention du genou gauche et de la hanche.Elle est trait&eacute; pour HTA.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont commenc&eacute; en 2005 quoiqu\'elle d&eacute;crit un asthme dans l\'enfance et dit que sa m&egrave;re &eacute;tait aussi atteinte d\'asthme.Actuellement elle pr&eacute;sente une dyspn&eacute;e grade V&nbsp;de l\'&eacute;chelle du Modified Medical Research Council.Elle pr&eacute;sente une toux matinale avec expectoration blanchatre.</p>\r\n<p>l\'examen clinique retrouve un signe de Campbell.l\'auscultation pulmonaire retrouve un freinage expiratoire avec des ronchi dans les champs pulmonaires &agrave; predominance droite.</p>\r\n<p>Je demande un TDM thoracique qu\'elle m\'apportera lors de la prochaine consultation.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec VEMS &agrave; 0.52 soit 43% de la norme.Le Tiffeneau est &agrave; 49% avec des signes de distension pulmonaire:VGT &agrave; 283% ;CPT &agrave; 186% et VR &agrave; 317% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;s &agrave; 1.03 .</p>\r\n<p>Sur le plan biologique l\'Hct est &agrave; 37.9% et les GDS &agrave; AA retrouvent:pH 7.45;pCO2:45Torr;pO2:51 Torr ;SaO2:84%.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre:OLD,Onbrez 300/j Spiriva Respimat2B;A&eacute;rosolttt(Bricanyl-Atrovent)X3 et pulmicortX2 avec rin&ccedil;age de la bouche;kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(427,595,'2013-10-22','Dr Ray\r\nDr Laurent Grandpré','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. VIDOT David, n&eacute; le 18/04/1977.</p>\r\n<p>Ce monsieur fumeur 8cigarettes/j travaille &agrave; St pierre comme chef d\'&eacute;quipe.</p>\r\n<p>Il a consult&eacute; le Dr Laurent Grandpr&eacute; pour une g&egrave;ne dans la gorge et une fatigue.</p>\r\n<p>Ilest mari&eacute; et a un enfant.M. Vidot pr&eacute;sente un retrognatisme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une amygdalectomie .Il a eu un pneumothorax post traumatique gauche dans l\'adolescence.Son &eacute;pouse lui a dit qu\'il ronfle .</p>\r\n<p>Il pr&eacute;sente un score d\'Epworth &agrave; 15/24 avec une hypersomnie diurne.Il a eu une polygraphie nocturne tr&egrave;s perturb&eacute; et nous est adress&eacute; pour polysomnographie.il remplira un agenda de sommeil.</p>\r\n<p>M.Vidot pr&eacute;sente un poids de 93kilos pour une taille de 176cm soit un IMC de 30K/m2 ce qui correspond &agrave; la limite entre le surpoids et l\'obesit&eacute; moder&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>L\'EFR montre une spirographie et une plethysmographie dans les limites de la normale.Il n\'existe pas de trouble du transfert ;toutefois on note une augmentation de la resistance des voies a&eacute;riennes &agrave; 0.43.</p>\r\n<p>Nous allons pratiquer une polysomnographie &agrave; M.Vidot le 31/10/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(428,548,'2013-10-22','Dr Pescatori\r\nDr Arnaud LEROY','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai revu ce jour Melle PUTIEN Maelis n&eacute;e le 03/12/1996.</p>\r\n<p><span style=\"font-size: 11px;\">Depuis l\'enfance elle une malformation des cordes vocales ce qui alt&egrave;re sa voix.</span></p>\r\n<p>Elle pr&eacute;sente un IMC &agrave; 36.5(poids &agrave; 91 kilos et taille &agrave; 1m58) ce qui correspond &agrave; la limite d\'une ob&eacute;sit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte &agrave; pr&eacute;dominance restrictive du fait de son ob&eacute;sit&eacute;.</p>\r\n<p>Melle PUTIEN aura une polygraphie nocturne &nbsp;dans la nuit du 15 au 16/10/2013.</p>\r\n<p>Cet examen n\'a pas retrouv&eacute; de syndrome d\'apn&eacute;e du sommeil &agrave; appareiller .L\'index d\'apn&eacute;e hypopn&eacute;e est &agrave; 1 par heure et passe &agrave; 15/heure si on associe &agrave; la fois les limitations de d&eacute;bit et les &eacute;v&egrave;nements.Pour m&eacute;moire les malades ne sont appareill&eacute;s qu\'&agrave; partir de 30/heure.Il n\'existe pas par ailleurs de d&eacute;saturation.</p>\r\n<p>En revanche l\'analyse de l\'agenda de sommeil retrouve une mauvaise hygi&egrave;ne de sommeil et j\'ai eu l\'occasion de lui donnerquelques conseils &nbsp;&agrave; ce sujet.</p>\r\n<p>De meme Melle putien doit maigrir et pour cela faire un r&eacute;gime et poursuivre une gymnastique de musculation abdominale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(429,570,'2013-10-22','Dr Guilbaud','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DARAFY Loana n&eacute;e le 24/09/2007.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une grand m&egrave;re ,un oncle et une tante asthmatique.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels une allergie alimentaire avec eryth&egrave;me de la face et rougeur des yeux quand elle mange du poisson.</p>\r\n<p>Depuis sa tendre enfance elle pr&eacute;sente un asthme trait&eacute; par CELESTENE et FLIXOTIDE et VENTOLINE.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e en P&eacute;diatrie au CHU de Bellepierre pour asthme au mois de juin.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Je prescrit ce jour une radiographie thoracique avec un scanner des sinus maxillaires.</p>\r\n<p>La NFS ne montre pas d\'hypereosinophilie.Les IgE totales sont &agrave; 494UI/ml.Les RAST montrent une allergie &agrave; la morue et aux acariens ;nous allons programmer une EFR.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille :singulair 5 mg le s;seretide 250 2X2 avec rin&ccedil;age et Eludril gargarisme m et s 7jrs/mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(430,592,'2013-10-22','Dr Peyronnet\r\nDr De Monredon','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. LAURENT Paul n&eacute; le 16/01/1938.</p>\r\n<p>Dans ses ant&eacute;c&eacute;dents on note une intervention pour genou gauche en 2006, une chol&eacute;cystectomie et d\'une hernie hiatale. Il &eacute;tait trait&eacute; pour des tremblements. Il a pr&eacute;sent&eacute; un AVC le 13/10/2012et est trait&eacute; par PROPANOLOL, MYSOLINE, ASPEGIC et ATORVASTATINE.</p>\r\n<p>M. Laurent pr&eacute;sente des troubles dfe la m&eacute;moire.</p>\r\n<p>M. Laurent pr&eacute;sente des ronflements avec pauses respiratoires. Son score d\'Epworth peut &ecirc;tre &eacute;valu&eacute; &agrave; 9/21.</p>\r\n<p>Le score de Mallampati est de 2/4.</p>\r\n<p>Je programme chez ce patient une EFR et une polysomnographie nocturne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(431,596,'2013-10-22','Dr Peyronnet','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme LAURENT Marie Th&eacute;r&egrave;se n&eacute;e le 24/08/1940.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; ce jour une EFR.Cet examen peut etre consid&eacute;r&eacute; comme dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(432,78,'2013-10-22','Dr Moussa\r\nISIS Médical','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme MONDIA Marie Th&eacute;r&egrave;se n&eacute;e le 05/01/1944.</p>\r\n<p>Cette dame mari&eacute;e a 25 enfants .Elle travaillait comme cantini&egrave;re &agrave; l\'&eacute;cole.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie,2 c&eacute;sariennes,une &eacute;ventration abdominale,une amgydaletomie ,une fracture du MI droit ,op&eacute;ration du genou droit.Elle est trait&eacute; pour HTA,diab&egrave;te et arythmie.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Ceci associ&eacute; &agrave; un sommeil de mauvaise qualit&eacute; et une hypersomnolence diurne.Elle pr&eacute;sente des ronflements.Son score d\'Epworth est &agrave; 3/21 et&nbsp;le score de Mallampati est de4 /4.</p>\r\n<p>son IMC est &agrave; 42.4 ce qui correspond &agrave; une ob&eacute;sit&eacute; morbide.Son perim&egrave;tre cervical est &agrave; 41 cm avec un perim&egrave;tre abdominal de 134 cm.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 78% de la norme.Le VEMS est &agrave; 1.38 soit 68% avec uin Tiffeneau &agrave; 93%.</p>\r\n<p>la polygraphie nocturne montre un index d\'apn&eacute;es -hypopn&eacute;es &agrave; 35/heure passant &agrave; 48/heure.La patiente d&eacute;sature jusqu\'&agrave; 70% d\'SaO2 passant 51% de son sommeil endessous de 90%.Elle pr&eacute;sente 18 mouvements p&eacute;riodiques des jambes par heure.</p>\r\n<p>En ce qui concerne les ronflements on note 42/heure avec une energie moyenne de 84db.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(433,90,'2013-10-22','Dr Say liang Fat\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ATCHAMA Yoland n&eacute; le 07/06/1969.</p>\r\n<p>Ce monsieur mari&eacute; a 3 enfants.il exercait la profession de chauffeur coursier et est en invalidit&eacute; depuis le 01/03/2012. Il est reconnu comme atteint de maladie professionnel depuis 2002.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une amygdalectomie.Il est trait&eacute; pour tassement rachidiens L1 et des hernies discales D8-D10.</p>\r\n<p>Il pr&eacute;sente un asthme depuis 1999.Sa m&egrave;re &eacute;tait asthmatique.M.Atchama est allergique aux acariens ,pollens.Il pr&eacute;sente &eacute;galement un asthme d\'effort.Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Il se d&eacute;place &agrave; l\'aide d\'une canne.</p>\r\n<p>l\'auscultation pulmonaire retrouve ce jour quleques ronchi dans les deux champs pulmonaires.</p>\r\n<p>Son score d\'Epworth est &eacute;valu&eacute; &agrave; 21/24;son&nbsp;score de Mallampati est de 3/4.</p>\r\n<p>Son perim&egrave;tre cervical est de 43 cm &nbsp;avec un perim&egrave;tre abdominal de 116 cm.</p>\r\n<p>M. Atchama a b&eacute;n&eacute;fici&eacute; d\'une polygraphie nocturne dans la nuit du 09 au 10/10/2013.Cet examen a montr&eacute; un Index d\'Apn&eacute;es-hypopn&eacute;es de 63/heure.Ce nombre passe &agrave; 83/heure quand on y ajoutte les &eacute;v&egrave;nements.VoirRapport ci-joint.570 ronflements ont &eacute;t&eacute; detect&eacute;s/heure avec une &eacute;nergie moyenne de 93db ce qui correspond &agrave; un ronflement majeur.Nous allons l\'appareiller en PPC au mode auto pilot&eacute; entre 5 et 20 cm d\'eau avec la soci&eacute;t&eacute; SOS Oxyg&egrave;ne.</p>\r\n<p>M. Atchama poursuivra:Kin&eacute;siettt respiratoire et de la colonne lombaire\'douleur rachidienne s&eacute;quellaires) 5 jours / semaine.Aerius 5mg;Eludril gargarisme m et s ;Onbrez 300/j;Spiriva Respimat 2b/j;A&eacute;rosolttt (Bricanyl-Atrovent)X4/j;a&eacute;rosolttt PulmicortX2/j;Singulair 10mg/j;Rhinocort 1X2 avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(434,567,'2013-10-22','Dr Nicolas DENIS','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. SOPHIE Louis Vivian n&eacute; le 05/05/1961.</p>\r\n<p>Ce monsieur est mari&eacute; et a 4 enfants.Il exercait la profession de macon.</p>\r\n<p>il s\'agit d\'un ancien fumeur sevr&eacute; depuis 9 ans;il totalise environ 10PA maximum.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DNID.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade i/II de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>'),(435,599,'2013-10-25','Dr Venault\r\nDr Leung Pin\r\nDr GENIN\r\n\r\nDr BLAIS','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. BARDIERE louis christophe, n&eacute; le 27/01/1958</p>\r\n<p>Ce monsieur mari&eacute; a 3 enfants.Il travaille comme comptable.Il est non fumeur.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une greffe r&eacute;nale en 2006,une polypose intestinale en 2009 op&eacute;r&eacute; par le Dr Blais.</p>\r\n<p>Il est trait&eacute; pour diab&egrave;te DID et HTA.Il pr&eacute;sente une dyspn&eacute;e gradeIII/IV de l\'&eacute;chelle du Modified Medical Research Council depuis 15 jours.</p>\r\n<p>L\'examen clinique retrouve de discrets oed&egrave;mes des MI.L\'auscultation pulmonaire retrouve ce jour quelques sous crepitants aux bases.Son SaO2 est &agrave; 98% avec un pouls &agrave; 78.</p>\r\n<p>Son score d\'Epworth peut etre &eacute;valu&eacute; &agrave; 12/24 et le score de Mallampati est de 2 /4.Son IMC est de38.2K/m2 ce qui correspond &agrave; une ob&eacute;sit&eacute; s&eacute;v&egrave;re.L\'Hb est &agrave; 11g/dl avec un hct &agrave;34%.</p>\r\n<p>Sa radiographie thoracique montre une augmentation de volume de la silhouette cardiovasculaire avec redistribution vasculaire vers les sommets.Au total on a un aspect de poumon cardiaque.</p>\r\n<p>L\'EFR retrouve un trouble ventilatoire Mixte s&eacute;v&egrave;re avec une CPT &agrave; 33% .le VR est &agrave; 41% avec VGT &agrave; 66% de la norme.Le VEMS est &agrave; 1.27 soit 37% de la norme non r&eacute;versible sous b2inhal&eacute;. une polygraphie nocturne le 6/11/2013.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Je place le patient sous Onbrez 150microg avec Spiriva respimat 2B/J.</p>\r\n<p>Les Pro BNP sont &agrave; &nbsp;&agrave; 2743 et une consultation cardiologique rapproch&eacute;e est hautement souhaitable.</p>\r\n<p>J\'augmente le LASILIX &agrave; 40mgX3.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(436,599,'2013-10-22','','<p>Je sous sign&eacute; Dr Bernard TANGUY certifie que</p>\r\n<p>&nbsp;</p>\r\n<p>M.BARDIERE Louis Christophe n&eacute; le 27/01/1958</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>est venu me consulter ce jour;</p>\r\n<p>&nbsp;</p>\r\n<p>fait &agrave; St Denis le 22/10/2013</p>'),(437,217,'2013-10-22','Dr DOUSSAUD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme CLAIN Marguerite n&eacute;e le 03/02/1928.</p>\r\n<p>Cette dame est veuve et a 9 enfants.Elle exercait la profession de femme de m&eacute;nage.Elle habite seule avec une aide-m&eacute;nag&egrave;re.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une HTA,Un DID.Recemment &nbsp;une an&eacute;mie macrocytaire a &eacute;t&eacute; diagnostiqu&eacute; chez cette patiente avec un taux d\'Hb de 7g/dl avec VGM &agrave; 115 micro3.</p>\r\n<p>La patiente va mieux aujourd\'hui .Elle est moins pale et moins somnolente.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques discrets sibilances.La radiographie thoracique montre une cyphose dorsale avec absence d\'anomalie parenchymateuse &eacute;volutive.</p>\r\n<p>L\'EFR montre un trouble ventilatoire mixte &agrave; pr&eacute;dominance obstructive.Le VEMS est &agrave; 0.58 soit 57% de la norme avec un Tiffeneau &agrave; 77%.Il existe une distension pulmonaire avec VGT &agrave; 137% et VR &agrave; 128% de la norme.Les resistances des voies a&eacute;riennes sontn augment&eacute;es &agrave; 1.15.</p>\r\n<p>Les GDS retrouvent:pH 7041;pCO2 43 TORR;pO2:69Torr;SaO2:94% .</p>\r\n<p>Il convient de poursuivre A&eacute;rosolttt (Bricanyl-Atrovent)X3 et PulmicortX2 avec rin&ccedil;age;O2 liquide 2L/mn 24H sur24 et kin&eacute;siettt respiratoire: 20 s&eacute;ances /mois au domicile de la malade.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(438,371,'2013-10-22','Dr Rochat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme IMIZE Marie Sylviane n&eacute;e le 02/04/1956.</p>\r\n<p>Cette dame veuve a 3 enfants.Elle exerce la profession de femme de m&eacute;nage.Elle a &eacute;t&eacute; soumise &agrave; l\'exposition de feu de bois dans sa jeunesse.</p>\r\n<p>Elle est non fumeuse.Dans ses ant&eacute;c&egrave;dents on note une HTA,une hypokali&eacute;mie.</p>\r\n<p>Elle pr&eacute;sente un \'asthme\' depuis 1979.Sa derni&egrave;re crise d\'asthme date d\'il y a deux semaines &agrave; la suite d\'une exposition chez elle &agrave; la poussi&egrave;re.</p>\r\n<p>Depuis qu\'elle est sous XOLAIR &nbsp;et kin&eacute;siettt respiratoire son asthme est bien equilibr&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>L\'EFR en date du 10/10/2013 retrouvait un trouble ventilatoire obstructif s&eacute;v&egrave;re GOLD III avec un VEMS &agrave; 0.97 soit44% de la norme.Le Tiffeneau est &agrave; 70% .On note aussi une distension pulmonaire avec VGT &agrave; 139% CPT &agrave; 102% et VR &agrave; 148% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.67.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Je demande un TDM thoracique sans injection.</p>\r\n<p>Elle poursuivra le meme traitement pour l\'instant.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(439,486,'2013-10-22','',''),(440,572,'2013-10-22','Dr Rajabaly\r\nDr Leung Pin','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. KAMIS Razaaly, n&eacute; le 04/06/1950</p>\r\n<p>ce monsieur est fumeur actuellement 5 cigarettes/jour autrfois 12 &agrave; 15 cigarettes/jour.Il totalise environ 30PA.</p>\r\n<p>Il est commercant,mari&eacute;,3 enfants;</p>\r\n<p>dans ses ant&eacute;c&egrave;dents personnels il a &eacute;t&eacute; op&eacute;r&eacute; d\'une hernie ombilicale &agrave; 2 reprises et d\'une d&eacute;viation de la cloison nasale &nbsp;ainsi que du menisque gauche et de l\'&eacute;paule droite.il est trait&eacute; pour hernie discale,HTA,un prostatisme.</p>\r\n<p>Il a &eacute;t&eacute; trait&eacute; en 1998 pour une insuffisance coronarienne et a eu la pose de deux stents.L\'echocardiographie datant du 30/03/2012 montre un VG moderement dilat&eacute; avec une fonction systolique globale mod&eacute;r&eacute;ment abaiss&eacute;e.Il n\'a pas &eacute;t&eacute; retrouv&eacute; d\'HTAP.La scintigraphie myocardique du 06/04/2012 montre des s&eacute;quelles d\'infarctus du myocarde transmurale &eacute;tendue.</p>\r\n<p>Il est trait&eacute; parCORDARONE,HYZAAR,PLAVIX,LOGIMAX,LODALES,INEXIUM,AERIUS,LYRICA,STILNOX,VOLTARENE,DAFALGAN,XATRAL.,VALDOXAN.</p>\r\n<p>Actuellement le patient pr&eacute;sente un serrement thoracique ant&eacute;rieur gauche avec&nbsp;&nbsp;une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.Il se couche tard,a des probl&egrave;mes d\'insomnie trait&eacute; par XANAX et STILNOX.</p>\r\n<p>Le score de Mallampati est de 2 /4.Le malade &eacute;tablira un agenda de sommeil.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques sibilances dans le champ pulmonaire ant&eacute;rieur.</p>\r\n<p>La proBNP est &agrave; 131pg/ml ;le scanner TAP est rassurant et note des petites bulles sous pleurales avec des bronches aux parois &eacute;paissies sans DDB.Au niveau sous diaphragmatique on retrouve que quelques kystes corticaux renaux.</p>\r\n<p>Les EFR montrent un trouble ventilatoire mixte mod&eacute;r&eacute; avec un VEMS &agrave; 1.95 soit 69% et un Tiffeneau &agrave; 83%.il existe une distensionpulmonaire mod&eacute;r&eacute; avec VGT &agrave; 115% et VR &agrave; 104% de la norme.par ailleurs on note des troubles mod&eacute;r&eacute;s du transfert avec TLCO &agrave; 67% de la norme.</p>\r\n<p>Je lui prescrit pour l\'instant de l\'Onbrez 150/j associ&eacute; &agrave; Alvesco 160microg/j &agrave; l\'aide d\'une chambre d\'inhalation A&eacute;rochamber.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(441,214,'2013-10-23','Dr Bourdais','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme LARAVINE Marie Gillette n&eacute;e le 29/11/1939.</p>\r\n<p>Elle est fatigu&eacute; le matin au r&eacute;veil.Son score d\'Epworth est &agrave; 8/24.Le score de Mallampati est de 2 /4.</p>\r\n<p>Sa dyspn&eacute;e s\'est am&eacute;lior&eacute; avec le traitement.Elle pr&eacute;sente une toux matinale avec expectoration blanchatre peu visqueuse.</p>\r\n<p>Cette patiente &eacute;tant sous VNI elle ne ronfle pas mais elle n\'a jamais eu une exploration du sommeil.Nous lui programmerons une polygraphie nocturne le 13/01/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(442,238,'2013-10-23','Dr Laurent Grandpré\r\nDr Andriatavy\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAKOTOMALALA Ursula Marie n&eacute;e le 31/01/1973.</p>\r\n<p><span style=\"font-size: 11px;\">Comme vous le savez elle pr&eacute;sente un ronflement s&eacute;v&egrave;re avec un score d\'Epworth &agrave; 14/24.</span></p>\r\n<p>Le score de Mallampati est de 2/4.Son perim&egrave;tre cervical est &agrave; 37cm avec un perim&egrave;tre abdominal &agrave; 101cm.</p>\r\n<p>Son poids est de 76k pour 1m55 soit un IMC de 31K/m2 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.</p>\r\n<p>Son agenda de sommeil montre un sommeil de mauvaise qualit&eacute; avec une moyenne de 4 heures de sommeil .Elle ne pr&eacute;sente pas de nyctiuries.</p>\r\n<p>la polysomnographie pratiqu&eacute; dans la nuit du 18 au 19/10/2013 a retrouv&eacute; un index d\'apn&eacute;es-hypopn&eacute;es de 41/heure.On note 27 micro-&eacute;veils/heure .</p>\r\n<p>Si on associe les &eacute;venements(diminutions) on arrive &agrave; 58/heure.Par ailleurs 35 d&eacute;saturations ont &eacute;t&eacute; enregistr&eacute;s/heure avec une SaO2 minimale de 74%.</p>\r\n<p>32 mouvements p&eacute;riodiques de jambes ont &eacute;t&eacute; recens&eacute;s/heure.</p>\r\n<p>En ce qui concerne les ronflements elle en pr&eacute;sente 160/h avec une energie moyenne de 92db.</p>\r\n<p>Cette dame sera appareill&eacute; en PPC par la Soci&eacute;t&eacute; SOS Oxyg&egrave;ne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(443,503,'2013-10-23','','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme HOARAU Marie Sylvette n&eacute;e le 21/09/1968.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire restrictif tr&egrave;s mod&eacute;r&eacute; avec CPT &agrave; 75% de la norme.Le VEMS est &agrave; 1.95 soit 72% de la norme.Le rapport de Tiffeneau est &agrave; 91% de la norme.il existe un trouble mod&eacute;r&eacute; de la diffusion avec TLCO &agrave; 63% de la norme.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(444,194,'2013-10-23','Dr Say Liang Fat\r\nRESPIDOM','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme HOAREAU Marie Helene n&eacute;e le 16/03/1947.</p>\r\n<p>Actuellement son &eacute;tat est stable.elle se plaint de douleurs arthrosiques.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Elle est trait&eacute; par VNI,OLD ,Kin&eacute;sietherapie respiratoire, XOLAIR 150 mg 1X/mois.</p>\r\n<p>Solupred 10 mg/j; A&eacute;rosolth&eacute;rapie:bricanyl-atroventX3 et pulmicortX2/jour;onbrez 300/j;spiriva 2B/j;mopral 40mg le s.</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(445,480,'2013-10-23','Dr I.Patel\r\nISIS Médical','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOYER celiane Marie n&eacute;e le 05/04/1938.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire mixte avec une composante restrictive mod&eacute;r&eacute;e :CPT &agrave; 84% de la norme.la composante obstructive est GOLD III s&eacute;v&egrave;re avec un VEMS &agrave; 0.76 soit 39% avec un Tiffeneau &agrave; 86%.Il existe des signes de distension pulmonaire avec VGT &agrave; 112% et VR &agrave; 144% de la norme.</p>\r\n<p>La GDS &agrave; AA montre:pH:7.39;pCO2:45Torr;pO2:73Torr;SaO2:94%.hct est &agrave; 42.2%.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(446,38,'2013-10-23','Dr Roseline PAYET\r\nISIS Réunion','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SELLINGUE ITEMA Marie Paule n&eacute;e le 08/07/1937.</p>\r\n<p>Son poids est de 80K pour une taille de 149cm soit un &nbsp;IMC est &agrave; 36 K/m2 ce qui correspond &agrave; une obesit&eacute; s&eacute;v&egrave;re.</p>\r\n<p>Elle pr&eacute;sente une hypersomnie diurne avec un&nbsp;&nbsp;Score d\'Epworth &nbsp;&agrave; 11/12 et un Score de Mallampati &agrave; 3/4.</p>\r\n<p>Mme Sellingue a b&eacute;n&eacute;fici&eacute; d\'une polygraphie nocturne qui retrouve un Index d\'Apn&eacute;es-hypopn&eacute;es de 31/heure.Cet indfex passe &agrave; 56/heure quand on y associe les &eacute;venements.</p>\r\n<p>On retrouve 27 d&eacute;saturations/heure avec une saturation minimale de 77%.</p>\r\n<p>192 ronflements sont retrouv&eacute;s /heure avec une energie moyenne de 81db.</p>\r\n<p>Elle poursuivra son traitement habituel et je la reverrai le 23/10/2013 en consultation.</p>\r\n<p>Mme SELLINGUE pr&eacute;sente donc un syndrome d\'apn&eacute;e de sommeil.</p>\r\n<p>Dans ces conditions nous allons l\'appareiller en PPC ou mieux en BiPAP .</p>\r\n<p>Nous recommendons de la placer sous Onbrez 150/j Spiriva Respimat 2B/j et kin&eacute;siettt respiratoire .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(447,524,'2013-10-23','Dr Corouge','<p>J</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CLAIN Georges Jean Marc n&eacute; le 23/11/1957.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif Gold II mod&eacute;r&eacute; avec un VEMS &agrave; 2.64 soit 73% de la norme.Le Tiffeneau est &agrave; 72%.Il existze une distension pulmonaire avec CPT &agrave; 115% VR 141% VGT &agrave; 144%.Les resistances des voies a&eacute;riennes est augment&eacute;e &agrave; 0.51 avec des tyroubles de la diffusion:TLCO &agrave; 58% de la norme.</p>\r\n<p>La radiographie pulmonaire ne retrouve pas de l&eacute;sion pulmonaire parenchymateuse et on note un &eacute;paississement des parois bronchiques.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(448,547,'2013-10-23','Dr laurent grandpré\r\nDr Venault\r\nSOS Oxygene','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. RAKOTOARIVONY Gaetan, n&eacute; le 06/08/1960.</p>\r\n<p>Ce patient pr&eacute;sente un retroprognatisme .Son poids est de 73k pour 1m67 ce qui r&eacute;alise un IMC de 26.2K/M2 ce qui repr&eacute;sente un surpoids.</p>\r\n<p>Le score de Mallampati est de 2 /4.Le perimetre cervical est &agrave; 39 cm avec un perim&egrave;tre abdominal &agrave; 95 cm.</p>\r\n<p>M.Rakotoarivony pr&eacute;sente 2 nyctiuries.</p>\r\n<p>L\'agenda de sommeil retrouve un sommeil de mauvaise qualit&eacute; avec plusieurs r&eacute;veils nocturnes.</p>\r\n<p><span style=\"font-size: 11px;\">Ce monsieur a b&eacute;n&eacute;fici&eacute; d\'une polysomnographie nocturne dans la nuit du 16 au 17/10/2013.Le temps total de sommeil a &eacute;t&eacute; 5H56min avec une efficacit&eacute; TST/PTS de 78%.</span></p>\r\n<p><span style=\"font-size: 11px;\">Il a &eacute;t&eacute; not&eacute; un Index d\'apn&eacute;es-hypopn&eacute;es de 41/heure passant &agrave; 70/H quand on y associe les &eacute;venements.</span></p>\r\n<p><span style=\"font-size: 11px;\">Le nombre total de micro-&eacute;veils a &eacute;t&eacute; de 26/heure .</span></p>\r\n<p><span style=\"font-size: 11px;\">29 d&eacute;saturations /heure ont &nbsp;&eacute;t&eacute; enregistr&eacute;es avec une minimale de 88%.</span></p>\r\n<p><span style=\"font-size: 11px;\">14 mouvements p&eacute;riodiques des jambes ont &eacute;t&eacute; enregistr&eacute;s/heure.</span></p>\r\n<p><span style=\"font-size: 11px;\">382 ronflements ont &eacute;t&eacute; not&eacute;/h avec une energie moyenne de 88db.</span></p>\r\n<p><span style=\"font-size: 11px;\">SA RADIOGRAPHIE PULMONAIRE EST NORMALE;</span></p>\r\n<p><span style=\"font-size: 11px;\">Il sera appareill&eacute; en PPC en mode autopilot&eacute; entre 5 et 15 cm d\'eau par la Soci&eacute;t&eacute; SOS OXYGENE.</span></p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(449,573,'2013-10-23','Dr Moshinaly\r\nDr Mossello','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme PERITA Catherine, n&eacute;e le 06/06/1967.</p>\r\n<p>Cette dame est fumeuse :un paquet et demi/jour.Elle totalise 12PA.</p>\r\n<p>Elle est c&eacute;libataire sans enfant.Elle est g&eacute;rante de soci&eacute;t&eacute;.Elle a pris 20K en7 ans.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une coelioscopie pour kystes ovariens.</p>\r\n<p>Depuis un an elle ressent des palpitations pour laquelle elle a consult&eacute;e le Dr Moshinaly qui lui a conseill&eacute; de me consulter.</p>\r\n<p>Elle est actuellement trait&eacute; par RISPERDAL,IMOVANE,BISOPROLOL ,FLUVERMAL et AUPHYTOSE.</p>\r\n<p>Elle a un sommeil de mauvaise qualit&eacute; depuis 9 ans et prend des somnif&egrave;res pour dormir.</p>\r\n<p>Elle pr&eacute;sente des ronflements avec pauses respiratoires.</p>\r\n<p>Elle ressent par ailleurs un resserement respitratoire.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normle.</p>\r\n<p>Nous allons programmer une EFR et une polygraphie nocturne dont les r&eacute;sultats vous seront communiqu&eacute;s et un traitement appropri&eacute; lui sera propos&eacute;.Elle remplira un questionnaire d\'echelle d\'Epworth et nous lui enseignerons &agrave; remplir un agenda de sommeil.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(450,559,'2013-10-23','Dr Bobate','<p>Cher Confr&egrave;re</p>\r\n<p>Comme je vous l\'ai dit ce matin, j\'ai examin&eacute; le dossier scannographique et d\'IRM de Mme Joomun hier avec le Dr Mascarel,radiologue.</p>\r\n<p>Ce qui nous a &eacute;tonn&eacute; c\'est que l\'&eacute;panchement pleural qui &eacute;tait cens&eacute; etre n&eacute;oplasique ne se soit pas reproduit.</p>\r\n<p>Le scanner thoracique ne retrouve que des s&eacute;quelles pleurales gauches.</p>\r\n<p>L\'IRM pelvien ne retrouve qu\'un petit kyste fonctionnel de l\'ovaire gauche et un myome interstitiel de l\'ut&eacute;rus de 38 mm.La mammographie montre un ACR1droit et ACR2 gauche.</p>\r\n<p>Comme je vous l\'ai dit les CA125 peuvent etre elev&eacute;s en cas d\'atteinte pleurale.</p>\r\n<p>Il convient donc pour l\'instant de r&eacute;aliser une surveillance de Mme JOOMUN et refaire une radiographie thoracique dans un mois.Si l\'&eacute;panchement pleural se reproduisait une biopsie pleurale serait indiqu&eacute;.</p>\r\n<p>Il convient aussi de la placer sous kin&eacute;siettt respiratoire centr&eacute; sur l\'hemicoupole diaphragmatique gauche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(451,229,'2013-10-23','Dr Ferroul','<p>J\'ai vu ce jour Mme RAMALINGOM MARIYAE n&eacute;e le 24/04/1929.</p>\r\n<p>Cette dame veuve a 3 enfants.Elle travaillait comme cultivatrice.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DID,une hypercholesterol&eacute;mie,de l\'arthrose dans le genou droit.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Mme Ramalingom pr&eacute;sente un IMC &agrave; 28.1 K/m2 avec un poids de 65K pour une taille de 1m52.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour une diminution des bruits pulmonaires stethacoustiques.</p>\r\n<p>L\'EFR avait retrouv&eacute; un trouble ventilatoire mixte avec CPT &agrave; 77%;le VEMS est &agrave; 0.78 soit 60% avec un Tiffeneau &agrave; 84%.Il existe des signes de distension pulmonaire avec VGT &agrave; 110%,Vr &agrave; 112% de la norme.</p>\r\n<p>Je pr&eacute;conise chez elle Spiriva 1b/j Onbrez 300 1b/j avec A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3 et PulmicortX2 avec rin&ccedil;age ainsi que kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(452,243,'2013-10-23','','<p>J\'ai vu ce jour M. TESTAN Joseph Marcel n&eacute; le 12/10/1933 qui pr&eacute;sente une masse lobaire sup&eacute;rieure droite de 29 mm d\'allure suspecte.</p>\r\n<p><span>J\'ai rappel&eacute; ce jour le Dr Gazaille au sujet de ce malade.Il n\'a toujours pas eu sa fibroscopie bronchique et le Dr Gazaille m\'a dit que les secretaires du service allaient le convoquer.</span></p>\r\n<p><span>le lui prescrit une NFS-plaquettes avec TP et TCA en vue de la fibroscopie bronchiquequ\'il aura le 24/10/2013 &agrave; 9H45 avec le Dr M\'buyamba au CHU de Bellepierre.</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(453,530,'2013-10-23','Dr Razakasoa','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Melle RAJAONARISOA Olivia n&eacute;e le 08/01/1994.</p>\r\n<p>Son TDM thoracique sans injection est strictement dans les limites de la normale.</p>\r\n<p>Elle poursuivra le meme traitement pendant 2 &agrave; 3 mois et je la reverrai pour des EFR &agrave; l\'issue.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(454,309,'2013-10-24','Dr Kapler\r\nDr leung Pin\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MASSEAUX Bernard n&eacute; le 26/05/1942.</p>\r\n<p>L\'echocardiographie montre un VG non dilat&eacute; discr&egrave;tement hypertrophique &agrave; fonction systolique globale infranormale.Il existe une HTAP moyenne.Au total le cardiologue note des pressions de remplissage VG &eacute;lev&eacute;es avec un coeur pulmonaire chronique.</p>\r\n<p>L\'an&eacute;mie s\'est corrig&eacute;e le taux d\'Hb &eacute;tant &agrave; 11.5g/dl le 10/10/2013.</p>\r\n<p>M.Masseaux est un ancien gros fumeur:2paquets/jour .Il est sevr&eacute; depuis 9 ans et totalise pr&egrave;s de 60PA.</p>\r\n<p>L\'EFR pratiqu&eacute; le 25/09/2013 retrouve un trouble ventilatoire mixte avec CPT &agrave; 37%,VR &agrave; 36% de la norme.Le VEMS est &agrave; 1.11 soit 46% ce qui correspond &agrave; un composante obstructive Gold III s&eacute;v&egrave;re.Le Tiffeneau est &agrave; 88% de la norme.</p>\r\n<p>M. Masseau est sous VNI &nbsp;et OLD pour syndrome d\'apn&eacute;e de sommeil et nous controlerons son appareillage en pratiquant une polygraphie nocturne en janvier.</p>\r\n<p>Il convient qu\'il poursuive :Kin&eacute;siettt respiratoire,Onbrez 300/j a&eacute;rosolttt (bricanyl-Atrovent)X3 et pulmicortX2 avec rin&ccedil;age et sa th&eacute;rapeutique &agrave; vis&eacute;e cardiologique.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(455,326,'2013-10-24','Dr Bertucchi','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. NOURRY Louis Andr&eacute; n&eacute; le 05/02/1942.</p>\r\n<p>Ce monsieur est mari&eacute;,7 enfants ancien fumeur sevr&eacute; depuis 10 ans.Il totalise environ 20PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour hemorragie digestive sur UGD et une radioth&eacute;rapie pour cancer de la prostate.</p>\r\n<p>Ce patient a b&eacute;n&eacute;fici&eacute; d\'une EFR le 16/10/2013 . Cet examen retrouve un trouble ventilatyoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 70% et VR 56%.Le VEMS est &agrave; 1.97 soit 82% avec un Tiffeneau &agrave; 85% de la norme.Les resistances des voies a&eacute;riennes sont mod&eacute;r&eacute;ment augment&eacute;es &agrave; 0.39.Il n\'existe pas de trouble de la diffusion.</p>\r\n<p>Le scanner thoracique pratiqu&eacute; le 09/08/2013 montre la persistance de petites plages de verre d&eacute;poli du culmen.Il existe une nette r&eacute;gression desimages par rapport au scanner pr&eacute;c&eacute;dent.</p>\r\n<p>je le place sous kin&eacute;siettt respiratoire pendant 2 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(456,332,'2013-10-24','Dr Pierre BERNARD\r\nDr Mascarel','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BOYER Justin Antoine n&eacute; le 01/06/1944.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; le 31/10/2013 d\'un scanner thoracique sans injection.Cet examen a montr&eacute; que l\'elargissement du m&eacute;diastin visible sur la radiographie standard &eacute;tait li&eacute; &agrave; des structures vasculaires sans aspect pathologique.</p>\r\n<p>Le patient se sent mieux et l\'auscultation pulmonaire retrouve&nbsp;</p>\r\n<p>v</p>'),(457,430,'2013-10-24','Dr VANOOT\r\nDr MASCAREL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BOYER Marie Anise n&eacute;e le 13/06/1966.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire Mixte avec CPT &agrave; 70% de la norme.Le VEMS est &agrave; 0.83 soit 31% de la norme ,t&eacute;moignant d\'une composante obstructive Gold III/IV s&eacute;v&egrave;re &agrave; tr&egrave;s s&eacute;v&egrave;re.Il existe des signes de distension pulmonaire avec VR &agrave; 126%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.54.</p>\r\n<p>Je demande ce jour un TDM thoracique sans injection que la patiente fera le 31/10/2013.</p>\r\n<p>Ce document est tr&egrave;s important car je voudrais demander un avis au Pr ALIFANO ,chirurgien Thoracique &agrave; Cochin au sujet des DDB de Mme Boyer.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(458,498,'2013-10-24','Dr VINCENT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. HOARAU Joseph n&eacute; le 11/07/1933.</p>\r\n<p>Sa radiographie thoracique retrouve des s&eacute;quelles de sa thoracoplastie du sommet droit.</p>\r\n<p>ses EFR montrent un trouble ventilatoire Mixte ,mod&eacute;r&eacute; dans sa composante restrictive avec des CPt &agrave; 1.29 soit 71% de la norme.</p>\r\n<p>Le VEMS est &agrave; 0.91 soit 40% ce qui correspond &agrave; une atteinte GOLD III s&eacute;v&egrave;re.Le Tiffeneau est &agrave; 85%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.46.</p>\r\n<p>&nbsp;Je lui prescrit Onbrez 300 microg /j associ&eacute; &agrave; Spiriva Respimat 2B/j et A&eacute;rosolth&eacute;rapie Bricanyl-Atrovent x2/j avec la Soci&eacute;t&eacute; ISIS. ceci associ&eacute; &agrave; kin&eacute;sieth&eacute;rapie respiratoire et de mobilisation X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(459,577,'2013-10-24','Médecin Traitant.','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DI MAURO Arlette n&eacute;e le 07/06/1953.</p>\r\n<p>Cette dame pr&eacute;sente une toux persistante depuis un mois et demi.Il s\'agit plutot d\'une toux laryng&eacute; avec g&egrave;ne dans la gorge.Elle a &eacute;t&eacute; trait&eacute; par AMOXICILLINE 500mgX2 pendant 5 jours.Elle faisait de la fi&egrave;vre le soir.Il lui persiste une g&egrave;ne dans la gorge sans sibilances.</p>\r\n<p>Mme di Mauro ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dent medico-chiruirgical particulier.</p>\r\n<p>Cette dame est mari&eacute; 2 enfants.Elle a fum&eacute; pendant 5 ans 1pqt/jour et totalise environ 5PA.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je lui conseille un traitement par ELUDRIL gargarisme m et s pendant 10jours et en cas de persistance de la toux de r&eacute;aliser une radiographie pulmonaire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(460,429,'2013-10-24','Dr Jean Jacques BRUNET','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme SAGOUBY Guylene n&eacute;e le 15/02/1963.</p>\r\n<p>La VNI est bien support&eacute; .</p>\r\n<p>La Soci&eacute;t&eacute; ISIS M&eacute;dical nous signale une utilisation optimale de la VNI.L\'utilisation moyenne &eacute;tant de 7H58mins51Sec.Avec un pourcentage de jours d\'utilisation de l\'appareil de 100%.&nbsp;</p>\r\n<p>Mme Sagouby poursuivra l\'Onbrez 300microg/j.</p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(461,406,'2013-10-24','Dr Josette FOURNIER\r\nKinésiethérapeute','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. AUGUSTIN Jean Michel n&eacute; le 07/05/1936.</p>\r\n<p>La radiographie thoracique retrouve une distension thoracique avec aplatissement des coupoles diaphragmatiques .on note une calcification aortique avec de profil une hyperclart&eacute; retrosternale et retrocardiaque.</p>\r\n<p>Sur le plan biologique on note un Hct &agrave; 42.6% et des proBNP &agrave; 34 pg/ml.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif avec CPT &agrave; 67% Le VR est &agrave; 35% de la norme .Le VEMS est &agrave; 2.08 soit 82% de la norme.Il existe des troubles mod&eacute;r&eacute;s du transfert avec TLCO &agrave; 71%.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour des ronchi dans les deux champs pulmonaires .on note des oed&egrave;mes discrets des deux membres inf&eacute;rieurs.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre la kin&eacute;siettt respiratoire associ&eacute; &agrave; des a&eacute;rosols (bricanyl-atrovent)x2 et Pulmicortx2 avec rin&ccedil;age;onbrez 300/j</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(462,612,'2013-10-24','Dr Corouge','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CHEUNG-LUNG Joseph n&eacute; le 10/06/1939.</p>\r\n<p>Ce monsieur est mari&eacute;,2 enfants.Il n\'a jamais fum&eacute;;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents op&eacute;r&eacute; de la thyroide par Dr Haffaf.Depuis il est sous LEVOTHYROX.Il a &eacute;t&eacute; op&eacute;r&eacute; d\'une arterite du M.I.droit.Il a &eacute;t&eacute; trait&eacute; par Dr Blais pour une hepatite B.</p>\r\n<p>En raison d\'une toux avec \'rhume dans la gorge\' il a b&eacute;n&eacute;fici&eacute; d\'une radiographie pulmonaire.Cet examen montre une petite distension thoracique avec sur&eacute;l&eacute;vation de l\'hemicoupole diaphragmatioque droite ainsi que ,de profil, une hyperclart&eacute; retrosternale.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Une EFR est pr&eacute;vu pour ce patient.Les r&eacute;sultats vous seront adress&eacute;s.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(463,416,'2013-10-24','Dr I.PATEL\r\nDr Leung Pin','<p>Cher Ibrahim</p>\r\n<p>Je te &nbsp;remercie de m\'avoir adress&eacute; pour avis M. LARTIN Urbain, n&eacute; le 07/11/1926.</p>\r\n<p>Ce pr&eacute;sente des ronflements importants d\'apr&egrave;s son entourage et a pr&eacute;sent&eacute; des thromboses.</p>\r\n<p>Son score d\'Epworth est &agrave; 14/18.Le score de Mallampati est de 2 /4.L\'agenda de sommeil montre un sommeil de bonne qualit&eacute; .Il se couche &agrave; heure fixe et a un lever matinal &agrave; 7H du matin.il se l&egrave;ve n&eacute;anmoins 2 &agrave; 3 fois par nuit en raison des nyctiuries.</p>\r\n<p>Ce monsieur a b&eacute;n&eacute;fici&eacute; d\'une polygraphie ventilatoire dans la nuit du 17 au 18/10/2013.</p>\r\n<p>l\'Index d\'apn&eacute;es-hypopn&eacute;es est de 20/heure et passe &agrave; 30/heure si on y associe les &eacute;v&egrave;nements.</p>\r\n<p>On note 218 d&eacute;saturations soit 24parheure avec des d&eacute;saturations minimales de 78%.La saturation moyenne est de 91% alors qu\'elle est de 95% &agrave; l\'&eacute;veil.M.Lartin passe 27% de son temps de sommeil endessous de 90% de SaO2.</p>\r\n<p>Par ailleurs 233 ronflements ont &eacute;t&eacute; not&eacute;s soit 24 par heure.</p>\r\n<p>Dans ces conditions nous proposons &agrave; M.Lartin de pratiquer une polysomnographie le 14/01/2014.</p>\r\n<p>La radiographie thoracique retrouve une augmentation de volume de la silhouette cardiovasculaire avec une redistribution vasculaire vers les sommets.Il y ainteret &agrave; pratiquer une echocardiographie.</p>\r\n<p>Avec mes remerciements, veilles agr&eacute;er, cher Ibrahim , l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(464,370,'2013-10-24','Dr Leroy\r\nISIS Médical','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. WEISBROD Eric n&eacute; le 25/05/1942.</p>\r\n<p>ce monsieur ancien professeur de math&eacute;matiques est un ancien fumeur.Il totalise environ 50PA.</p>\r\n<p>Il est divorc&eacute; et a 2 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une intervention pour fracture du nez et hernie inguinale gauche.Il pr&eacute;sente de plus une arthrose de la hanche droite.</p>\r\n<p>Ses probl&egrave;mes respiratoires ont d&eacute;but&eacute; par des bronchites l\'hiver dans l\'enfance.il a fait une tuberculose &agrave; Djiboutu en 1995.Il s\'agissait d\'une souche sensible aux anti-tuberculeux.Il a eu 6 mois d\'antibioth&eacute;rapie.</p>\r\n<p>Il a &eacute;t&eacute; hospitalis&eacute; pour decompensation d\'insuffisance respiratoire due &agrave; son emphys&egrave;me fin mai 2011.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council associ&eacute; &agrave; une petite hemoptysie il y a un mois.</p>\r\n<p>&nbsp;L\'auscultation pulmonaire est ce jour sans grande particularit&eacute;.</p>\r\n<p>Je demande ce jour un scanner thoracique sans injection et je le reverrai pour des EFR.&nbsp;</p>\r\n<p>Sur le plan th&eacute;rapeutique M.Weisbrod poursuivra :Onbrez300/j,spiriva Respimat 2B/j;Miflonil 1X2</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(465,456,'2013-10-24','','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. QUEMENER Roger n&eacute; le 12/01/1939.</p>\r\n<p>Il ne supporte pas l\'Onbrez qui lui donne des oed&egrave;mes des chevilles et des palpitations.On arrete donc l\'Onbrez.</p>\r\n<p>L\'Electrophor&egrave;se des proteines montre une l&eacute;g&egrave;re hypoprotid&eacute;mie globale.Les CPK sont Normales avec Anticorps anti-Sm,anti-Sm/RNP,anti-SSA,anti-SSB,anti-Jo-1 n&eacute;gatif.Les ANCA sont n&eacute;gatifs,et les marqueurs de myosites n&eacute;gatifs.</p>\r\n<p>Ce patient &eacute;tant de plus en plus g&eacute;n&eacute; pour respirer il convient de repasser &agrave; 30mg de Solupred.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(466,220,'2013-10-25','Dr Etienne SERY','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GRONDIN Henri Claude n&eacute; le 14/04/1958.</p>\r\n<p><span style=\"font-size: 11px;\">La gazom&eacute;trie au repos retrouve:pH:7.41 pCO2:43Torr;pO2:86Torr;RA:27.3 ;CO2Total:28.6;Sao2:97% BE:2mmol/L.</span></p>\r\n<p>Ce qui pose probl&egrave;me est que ce patient est encore jeune et qu\'il est tr&egrave;s pr&eacute;occup&eacute; par la diminution de ses performances.Je lui conseille une courte corticoth&eacute;rapie tout en sachant qu\'il faudra pendant surveiller et r&eacute;equilibrer son &nbsp;diab&egrave;te.Solupred 40 mg pendant 2 jours en diminuant de 5 mg tous les deux jours.</p>\r\n<p>Je lui prescrit &eacute;galement par RESPIDOM de l\'AlphaC 200.Le reste du traitement &agrave; vis&eacute;e respiratoire inchang&eacute;.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(468,220,'2013-10-25','','<p>Je soussign&eacute; docteur Bernard TANGUY,Pneumologue Agr&eacute;e,</p>\r\n<p>&nbsp;</p>\r\n<p>certifie que M.GRONDIN ,Henri Claude</p>\r\n<p>&nbsp;</p>\r\n<p>n&eacute; le 14/04/1958 pr&eacute;sente une affection qui ne lui permet aucun travail de force;</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; Saint Denis le 25/10/2013.</p>'),(469,280,'2013-10-25','Dr Hitier','<p>J\'ai vu ce jour Mme OLINARD Marie Eveline n&eacute;e le 24/09/1941.</p>\r\n<p>Elle prend de la Ventoline 4 fois par jour.Elle n\'arrive pas &agrave; prendre de l\'Onbrez et du Spiriva Respimat.</p>\r\n<p>En revanche elle prend du Symbicort.il convient donc de poursuivre chez elle de l\'OLD avec des a&eacute;rosolth&eacute;rapie(Bricanyl-Atrovent)X3 et PulmicortX2 avec rin&ccedil;age.Tout cela associ&eacute; &agrave; kin&eacute;siett respiratoire X3/semaine.</p>\r\n<p>Je pense aussi qu\'il faut poursuivre Cetornan5gX2 avec ClinutrenX3/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(470,617,'2013-10-25','Dr Michineau','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GUYVARCH isabelle n&eacute; le 16/01/1963.</p>\r\n<p>Cette dame est non fumeuse actuellement sans emploi.</p>\r\n<p>Elle est mari&eacute; et a deux enfants.dans ses ant&eacute;c&egrave;dents on note une intervention pour des varices .</p>\r\n<p>Elle a des probl&egrave;mes de hernie discale.</p>\r\n<p>Elle consulte pour un herp&egrave;s labial apr&egrave;s une marche &agrave; Cilaos.</p>'),(471,610,'2013-10-25','Dr M.Goulam-Abasse','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. DJOUMOI Madi, n&eacute; le 01/01/1930</p>\r\n<p>ce monsieur est &agrave; la R&eacute;union depuis 3 semaines;il s\'agit d\'un ancien fumeur.Il &eacute;tait gendarme &agrave; Mayotte.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une prostatectomie &agrave; la R&eacute;union en 2006;une hernie inguinale aux Comores.</p>\r\n<p>Actuellement il est trait&eacute; depuis 6 mois pour une tuberculose pulmonaire.</p>\r\n<p>Le patient est somnolent et la famille ne connait pas quel traitement il prend exactement.De plus la famille n\'a pas amen&eacute; le scanner ant&eacute;rieur.Je leur demande de m\'amener tout cela.</p>\r\n<p>De plus je leur prescrit un bilan de surveillance comportant:</p>\r\n<p>3 Tubages gastriques recherche de BK :Ex:direct,Culture,ATB.</p>\r\n<p>Bilirubine,transaminases;Ac.urique;creatinine,Ur&eacute;e.VS,CRP,NFS.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(472,618,'2013-10-25','Dr AKBARALY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. IFANGOUSINE Jean Hugues, n&eacute; le 16/05/1975.</p>\r\n<p>Ce monsieur vit en concubinage et a 2 enfants.Il est sportif et fait du velo.</p>\r\n<p>Il travaille comme artisan electricien.Il ne fume pas.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on ne retrouve pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on retrouve une rhinite allergique.</p>\r\n<p>Son asthme a demarr&eacute; &agrave; l\'age de 30/32 ans.Il a eu un bilan allergologique qui retrouve une allergie aux acariens .</p>\r\n<p>Il n\'a jamais &eacute;t&eacute; hospitalis&eacute; mais est sous traitement par le Dr Vivier ,allergologue.Il est de plus amelior&eacute; par l\'AERIUS le soir.Il ne prend pas de corticosteroide inhal&eacute;.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>La radiographie thoracique retrouve un &eacute;paississement des parois bronchiques.</p>\r\n<p>La radiographie du rachis lombaire retrouve une attitude scoliotique lombaire &agrave; convexit&eacute; droite.</p>\r\n<p>Nous allons pratiquer une EFR le 06/11/2013 et il m\'apportera son Scanner des sinus.</p>\r\n<p>Je demande un dosage d\'IgE totales et de RAST aux pneumallerg&egrave;nes et aux Trophallerg&egrave;nes avec NFS.</p>\r\n<p>Je lui conseille pour l\'instant le traitement suivant:SYMBICORT 1BX2 avec rin&ccedil;age de la bouche par la suite,Singulair 10mg 1cp le soir;aerius 5 mg 1cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(473,162,'2013-10-25','Dr Lebihan','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DRULA Denise Marlene n&eacute;e le 06/09/1951.</p>\r\n<p>Cette dame pr&eacute;sente une hypersomnie diurne avec un Score d\'Epworth &agrave; 13/21.</p>\r\n<p>Le score de Mallampati est de 2/4.</p>\r\n<p>Par ailleurs elle pr&eacute;sente 3 nyctiuries avec un ronflement fort.On note des cephal&eacute;es matinales avec une mauvaise qualit&eacute; des r&eacute;veils.On va lui enseigner &agrave; remplir un agenda de sommeil.</p>\r\n<p>Je lui renouvelle XOLAIR 375 mgX2/mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(474,35,'2013-10-25','Dr Kapler\r\nRESPIDOM','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme SEPEROUMAL Marie Rachel n&eacute;e le 03/04/1966.</p>\r\n<p>Elle a eu ce jour une EFR qui est en am&eacute;lioration par rapport &agrave; celui du 23/07/2013.</p>\r\n<p>Le VEMS est pass&eacute; de 1.05 &agrave; 1.24 et sous b2inhal&eacute;s il passe &agrave; 1.43 soit un gain de 15%, ce qui fait qu\'il existe bien une hyperreactivit&eacute; bronchique.Le Tiffeneau est pass&eacute; de 68 &agrave; 76%.Les resistances des voies a&eacute;riennes ont diminu&eacute;es passant de 1.13 &agrave; 0.84.</p>\r\n<p>Il existe une distension pulmonaire avec VGT &agrave; 147% et VR &agrave; 208% de la norme d\'ou n&eacute;cessit&eacute; d\'entreprendre une kin&eacute;siettt respiratoire efficace.</p>\r\n<p>La polysomnographie-voir r&eacute;sultats ci-joint - retrouve un Index d\'apn&eacute;es,hypopn&eacute;es,et &eacute;venements de 16/heure ;La patiente doit etre suivie mais n\'a pas besoin d\'appareillage pour l\'instant.</p>\r\n<p>Elle poursuivra :kin&eacute;siettt respiratoire:TVD x3/semaine avec A&eacute;rosolttt respiratoire(Bricanyl-Atrovent)X4 ;PulmicortX2 avec rin&ccedil;age;seretide 500 2X2 avec rin&ccedil;age.</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(475,592,'2013-10-25','Dr Peyronnet','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. LAURENT Paul n&eacute; le 16/01/1938.</p>\r\n<p>L\'EFR est dans les limites de la normale.Le VEMS est &agrave; 2.22 soit 83% de la norme.Il ne se modifie pas sous b2 inhal&eacute;s.il n\'y a donc pas d\'hyperr&eacute;activit&eacute; bronchique.le rapport de Tiffeneau est &agrave; 84%.La phl&eacute;thysmographie est dans les limites de la normale ainsi que les resistances des voies a&eacute;riennes .Il n\'y a pas de trouble de la diffusion.</p>\r\n<p>Nous allons programmer une polygraphie nocturne &agrave; ce patient compte tenu de ses ant&eacute;c&egrave;dents d\'AVC et d\'un score d\'Epworth &agrave; 9/21.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(476,238,'2013-10-25','',''),(477,298,'2013-10-25','Dr Vittori','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. THOMAS Antonin n&eacute; le 01/08/1934.</p>\r\n<p>Ses GDS &agrave; AA retrouvent:pH 7.31;pCO2:73;pO2:21;SaO2:37%.Il s\'agissait de sang veineux puisque la SaO2 est cet apr&egrave;smidi &agrave; 98%.Hb &agrave; 13.3 g/dl avec une Hct &agrave; 41.8%.CRP &agrave; 8.</p>\r\n<p>L\'examen clinique montre une distension thoracique majeure avec un signe de Campbell.</p>\r\n<p>L\'auscultation pulmonaire retrouve un assourdissement des bruits pulmonaires stethacoustiques.</p>\r\n<p>M.THOMAS poursuivra le meme traitement :VNI,Kin&eacute;siettt respi:Aerosolttt(bricanyl-atrovent)X3/jSpiriva Respimat 2B/j et Onbrez 300/j;OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(478,242,'2013-10-25','Dr Guilbaud','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour Mme ASENSIO Jacqueline n&eacute;e le 09/03/1942.</p>\r\n<p>Mme Ascensio a b&eacute;n&eacute;fici&eacute; d\'un TDM TAP avec injection et ce scanner retrouve des des l&eacute;sions carcinomateuses inchang&eacute;es.Le dossier est pass&eacute; en RCP d\'Oncologie thjoracique le 24/10/2013 et il a &eacute;t&eacute; d&eacute;cid&eacute; de maintenir le meme traitement.</p>\r\n<p>Nous avons decid&eacute; avec la patiente de laisser le TARCEVA &agrave; 100mg/j tout en controlant un scanner TAP sans injection dans 2 mois .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(479,557,'2013-10-25','Dr Guilbaud','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ASENSIO Manuel n&eacute; le 27/05/1936.</p>\r\n<p>Ce monsieur est un ancien fumeur totalisant environ 25PA.Il exercait la profession de douanier.</p>\r\n<p>Il a &eacute;t&eacute; op&eacute;r&eacute; de la colonne vert&eacute;brale et d\'une proth&egrave;se totrtale de hanche droite.</p>\r\n<p>Il est tarit&eacute; pour DNID,HTA,hypercholesterol&eacute;mie,incontinence urinaire.</p>\r\n<p>Son score d\'Epworth est &agrave; 6/24.Il pr&eacute;sente 2 &agrave; 3 nyctiuries.Le score de Mallampati est de 3 /4.</p>\r\n<p>Le perimetre cervical est &agrave; 44cm avec un perimetre abdominal de 118cm.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Nous allons apprendre &agrave; M.Ascensio &agrave; remplir un agenda de sommeil et lui donner un rendez vous pour une EFR et une polygaphie nocturne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(480,216,'2013-10-25','Dr Samir MESSAI','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu avec beaucoup de plaisir Mme Sabrina MOUNIAPIN n&eacute;e le 06/09/1974 que j\'avais adress&eacute; &agrave; l\'Hopital Ambroise Par&eacute; ou elle a &eacute;t&eacute; hospitalis&eacute;e du 08/09 au 04/10/2013.</p>\r\n<p>elle a b&eacute;n&eacute;fici&eacute; d\'une embolisation extremement complexe avec un l&eacute;g&egrave;re augmentation de la saturation.</p>\r\n<p>ce jour la SaO2 est &agrave; 94% avec uin pouls de 76 sous 1L d\'O2.La SaO2 est inchang&eacute; &agrave; AA.</p>\r\n<p>l\'hemoptysie s\'est compl&egrave;tement tarie.</p>\r\n<p>il est pr&eacute;vu un controle scannographique dans un an.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Il convient de poursuivre le meme traitement:Tegretol 200mg m ,m,s.depakine Chrono 500 1c^p m,m et s;Triatec 2.5 mg le matin;Tardyferon 80mg le m;symbicort Turbuhaler 400 m et s;A&eacute;rosolttt \'(bricanyl-atrovent)X3.d</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>&nbsp;</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p><span style=\"font-size: 11px;\">&nbsp;</span></p>'),(483,278,'2013-10-28','Dr Dhunnoo\r\nDr Thia-Cardiologue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BADOURALY DILAVARHOUSSEN n&eacute; le 23/05/1941.Ce patient continue &agrave; fumer avec la cigrette electronique.Il fumait autrefois un paquet &agrave; un paquet et demi de cigarette par jour depuis l\'age de 14 &agrave; 15 ans.Il totalise plus de 50PA.Il exercait la profession de m&eacute;canicien &agrave; Madagascar.Il est mari&eacute; et a 3 enfants.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une cholecystectomie.Il est trait&eacute; pour DNID et HTAIil a eu une angioplastie avec pose d\'un stent coronarien en 2007.</p>\r\n<p>Le 04 juillet 2008 il a eu une lobectomie inf&eacute;rieure droite associ&eacute; &agrave; une tumorectomie du LSD &nbsp;pour un adenocarcinome &agrave; composante brionchiolo alv&eacute;olaire par le Dr Chamoun avec une chimioth&eacute;rapie adjuvante :CDDP-NVB.Il a ensuite eu des recidives et a eu en tout 4 lignes de CT comprenant la CT adjuvante:2&egrave; ligne:ALIMTA,3&egrave;:TARCEVA 4&egrave;:TAXOTERE .Il a eu en octobre 2012 une aplasie f&eacute;brile avec hospitalisation.Le port &agrave; cath a &eacute;t&eacute; enlev&eacute; puis remis.</p>\r\n<p>En mai 2013 le patient &eacute;tait en progression mais le RCP d\'Oncologie Thoracique avait conseill&eacute; une pause th&eacute;rapeutique.Un TDM TAP a &eacute;t&eacute; pratiqu&eacute; le 08/08/2013 et compar&eacute; avec celui de janvier 2013.</p>\r\n<p>On notait un nodule sous pleural apical droit qui a grossi passant de 13X11 &agrave; 19X15mm;un nodule lobaire inf&eacute;rieur droit qui est pass&eacute; de 17X7 &agrave; 19X10mm;avec majoration des opacit&eacute;s en verre d&eacute;poli multifocales;pr&eacute;sence d\'ad&eacute;nopathies m&eacute;diastinales qui pour certaines ont augment&eacute;esde taille.Pas anomalie sous diaphragmatiques.</p>\r\n<p>Le dossier du patient &eacute;tait repass&eacute; en RCP car il voulait se rendre &agrave; Madagascar pour un mariage.Il lui a &eacute;t&eacute; conseill&eacute; de partir &agrave; Madagascar ,ce qu\'il a fait ,et de repratiquer un TDM thoracique en novembre 2013 puis de repasser le dossier en RCP.M.Badouraly p&egrave;se ce jour 79kilos,il est en bon &eacute;tat g&eacute;n&eacute;ral.L\'auscultation pulmonaire retrouve ce jour des ronchi dans les deux champs pulmonaires.Il aura un TAP avec injection le 28/11/2013 et le dossier sera repr&eacute;sent&eacute; en RCP au mois de d&eacute;cembre 2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(484,178,'2013-10-28','Dr Tcheremkhovit','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme SADON Marie Roseline n&eacute;e le 28/04/1956.</p>\r\n<p>Elle tousse depuis jeudi et a du mal &agrave; expectorer.Elle est sous antibiotiques.</p>\r\n<p>Elle a oubli&eacute; de parter sa prise de sang et ses examens biologiques.</p>\r\n<p>L\'auscultation retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Je pense qu\'il faut la placer sous corticoth&eacute;rapie orale de courte dur&eacute;e:cortancyl 40 mg le matin pendant 2 jours en diminuant de 5 mg tous les 2 jours en vue arret.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(485,572,'2013-10-28','Dr Azad Rajabaly\r\nIsis Réunion','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. KAMIS Razaaly, n&eacute; le 04/06/1950.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; dans la nuit du 23 au 24/10/2013 d\'une polygraphie nocturne qui a retrouv&eacute; un Index d\'Apn&eacute;es-hypopn&eacute;es de 39/H.Cet index passe &agrave; 41/H quand on y adjoint les diminutions de d&eacute;bit et &agrave; 75/H avec les &eacute;v&egrave;nements.</p>\r\n<p>On note 41 d&eacute;saturations / H avec une saturation minimale de 80%.843 ronflements ont &eacute;t&eacute; recens&eacute;s /h avec une &eacute;nergie moyenne de 96db.</p>\r\n<p>Le patient sera appareill&eacute; en PPC avec la Soci&eacute;t&eacute; ISIS R&eacute;union en mode autpilot&eacute; entren 6 et 14 cmd\'H2O.</p>\r\n<p>Les pro BNP sont &agrave; 131pg/ml ce qui fait que la dyspn&eacute;e est bien d\'origine respiratoire et non cardiaque.</p>\r\n<p>Le TDM thoracique note des petites bulles &nbsp;sous pleurales avec des bronches &agrave; parois &eacute;paissies.</p>\r\n<p>&nbsp;On passera &agrave; Onbrez 300micro/J.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(486,206,'2013-10-28','Dr GERARD','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MAILLOT Fran&ccedil;ois n&eacute; le 30/07/1938.</p>\r\n<p><strong><em>ll a un sommeil de mauvaise qualit&eacute;&nbsp;et son score d\'epworth est de 5/18.</em></strong></p>\r\n<p>Le score de Mallampati est de 3/4 et pr&eacute;sente &nbsp;une hypersomnie diurne.</p>\r\n<p>Nous programmons une polygraphie nocturne le 20/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(487,150,'2013-10-28','Dr Dabee','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. AMOURGOM Francis n&eacute; le 09/10/1940.</p>\r\n<p>La famille d\'acceuil dit qu\'il a en ce moment la \'grippe\' et qu\'il ne s\'alimente pas beaucoup.</p>\r\n<p>Je demande un dosage de CRP,albumin&eacute;mie et prealbumin&eacute;mie pour authentifier une d&eacute;nutrition.</p>\r\n<p>L\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires.De plus le malade se plaint de douleur epigastrique.</p>\r\n<p>Je pense qu\'il faut le surveiller de pr&egrave;s et ne pas hesiter en cas d\'aggravation &agrave; l\'hospitaliser &agrave; St Benoit.</p>\r\n<p>Il poursuivra son traitement &agrave; vis&eacute;e respiratoire habituel auquel il serait bon d\'ajouter Augmentin 1gX3 associ&eacute; &agrave; Ultralevure 2X3 pendant 10 jours et Inexium 40 mg pendant 1 mois avec Gaviscon 1X3.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(488,161,'2013-10-28','Dr Goburdhun\r\nDr Kuhl\r\nService de Radiologie\r\nClinique Sainte Clotilde','<p>Chers amis,</p>\r\n<p>J\'ai vu ce jour Mme NATAN MELANIE n&eacute;e le 14/07/1939.</p>\r\n<p>Cette dame&nbsp;a eu une lobectomie inf&eacute;rieure gauche le 21/01/2008 par le Dr Navarro pour un adenocarcinome pulmonaire bien differenci&eacute; class&eacute; pT1N1M0.Elle a ensuite b&eacute;n&eacute;fici&eacute; d\'une chimioth&eacute;rapie adjuvante CBDCA-TAXOTERE.</p>\r\n<p>Elle est non fumeuse et pr&eacute;sente dans ses ant&eacute;c&egrave;dents un DNID,une HTA et une embolie pulmonaire survenue dans les suites de la lobectomie.</p>\r\n<p>Mme Natan a eu un TDM TAP avec injection le 17/10/2013. Cet examen a montr&eacute; une plage de condensation basale gauche contenant un bronchogramme a&eacute;rique de 3.6X4.6 cm &agrave; proximit&eacute; du moignon bronchique.On note au sein de cette condensation une l&eacute;sion tissulaire ovalaire hypodense de 23mm.Par ailleurs il y a apparition d\'un nodule lobaire sup&eacute;rieur droit de 9 mm,lobaire sup&eacute;rieur de 4 mm et lobaire inf&eacute;rieure droit de 8mm.Il existe une fine lame pleurale gauche.On retrouve 2 adenomegalies precarenaire de 6 et 9mm.</p>\r\n<p>La palpation des aires ganglionnaires peripheriques est normale ainsi que l\'auscultation pulmonaire.</p>\r\n<p>On note une douleur en barre epigastriqueavec remont&eacute;e acide dans la bouche.Il existe donc une symptomatologie de reflux gastro oesophagien &agrave; trait&eacute; par INEXIUM et Gaviscon.</p>\r\n<p>le dossier a &eacute;t&eacute; pr&eacute;sent&eacute; le 24/10/2013 en RCP d\'Oncologie thoracique et un rendez vous de ponction sous scanner a &nbsp;&eacute;t&eacute; pris avec le Dr KUHL le 05/11/2013 &agrave;15:30 notamment pour &eacute;tude en biologie mol&eacute;culaire et recherche d\'une mutation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(489,386,'2013-10-28','Dr Goburdhun','<p>Cher ami,</p>\r\n<p>J\'ai vu ce jour M. AYOUBA ABDOU Mohamed n&eacute; le 31/12/1977.</p>\r\n<p>Il passera &agrave; 20mg de Cortancyl le 08/11/2013.</p>\r\n<p>Actuellement il se sent bien et arrive &agrave; marcher pendant une heure.</p>\r\n<p>l\'auscultation pulmonaire retrouve quelques ronchi dans les deux champs pulmonaires .</p>\r\n<p>Comme tu le sais le diagnostic retenu par les Prs Mal et Crestani de Paris est celui de tr&egrave;s probable Syndrome de Sjogren primitif.</p>\r\n<p>Pour l\'instant la greffe pulmonaire est abandonn&eacute; et le malade a &eacute;t&eacute; mis sous corticotherapie 40 mg le matin pendant 3 mois &agrave; compter du 07/07/2013.Il passera &agrave; 30 mg le matin &agrave; compter du 08/10/2013 avec diminution de 10 mg tous les mois jusqu\'&agrave; une dose seuil de 10mg/jour,en dessous de laquelle on ne pourra probablement pas descendre.En cas d\'aggravation lors de la baisse de la corticoth&eacute;rapie on introduira de l\'IMUREL per os &agrave; la dose de 2mg/K/J.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, mes amiti&eacute;s,</p>\r\n<p>&nbsp;</p>'),(490,426,'2013-10-28','Dr Vally\r\nDr Dufoix\r\nOphtalmologiste\r\nBras Panon','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme PAPAYA Jocelyne n&eacute;e le 03/11/1951.Cette dame non fumeuse est mari&eacute;,5 enfants.</p>\r\n<p>Elle travaillait aux services d\'entretien de la BNP.Elle n\'a pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une cholecystectomie,une hysterectomie partielle par le Dr Kah.</p>\r\n<p>Elle est &eacute;galement suivie pour HTA,glyc&eacute;mie limite,hypercholesterol&eacute;mie,glaucome,st&eacute;nose carotidienne &agrave; 50% et 60%</p>\r\n<p><strong>Histoire de la Maladie&nbsp;</strong>:&nbsp;L\'asthme de Mme Papaya a d&eacute;but&eacute; il y a quelques ann&eacute;es.Sa derni&egrave;re crise d\'asthme date de mars 2012.Le soir elle pr&eacute;sente des sifflements.Elle pr&eacute;sente une dyspn&eacute;e grade3 de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>Elle pr&eacute;sente en outre un ronflement g&eacute;nant pour l\'&eacute;poux et des pauses respiratoires.Elle pr&eacute;sente un poids de 72kilos pour une taille de 151cm avec un IMC de 31.6 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;e.Son Score d\'Epworth est &agrave; 17/24.&nbsp;Le score de Mallampati est de 2/4.</p>\r\n<p>La radiographie thoracique retrouve un &eacute;paisissement bronchique mod&eacute;r&eacute;.Les IgE totales sont &agrave; 12UI/ml Il n\'existe pas d\'hypereosinophilie:eosinocytes &agrave; 172/mm3.Les RAST aux pneumallerg&egrave;nes sont n&eacute;gatifs ainsi qu\'aux trophallerg&egrave;nes.Classe 2 aux phan&egrave;res de chien.</p>\r\n<p>L\'EFR montre un trouble ventilatoire restrictif avec CPT &agrave; 66% VR &agrave; 37% de la norme.Spirographie et diffusion dans les limites de la normale.</p>\r\n<p>Sur le plan th&eacute;rapeutique je conseille elle prend pour l\'instant du &nbsp;MIFLONIL400 1X2 avec rincage.Je lui presrit la kin&eacute;siettt respiratoire.Mme &nbsp;Papaya est en traitement pour un glaucome et voudrait savpoir s\'il y a une contreindication d\'utilisation du MIFLONIL.&nbsp;Une polygraphie nocturne est programm&eacute;e le 28/10/2013.</p>\r\n<p>Apr&egrave;s avis avec le Dr Villeroy,ophtalmologiste,il n\'y a pas de risque de faire du MIFLONIL &agrave; condition de consulter un ophtalmologiste pour controler la tension intra oculaire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(491,86,'2013-10-28','Dr C\r\nColette MOREL\r\nRESPIDOM/SEPRODOM','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme MOUTOUSSAMY Bakion, n&eacute;e le 02/10/1926.</p>\r\n<p>Cette dame dame veuve a 11 enfants.Elle a un poids de 75k pour une taille de 146cm ce qui fait un IMC de 35K/m2 soit la limite entre obesit&eacute; mod&eacute;r&eacute; et s&eacute;v&egrave;re.Elle pr&eacute;sente une hypersomnolence diurne avec un&nbsp;score d\'Epworth est de 15/24.Le score de Mallampati est de 3 /4.Elle pr&eacute;sente en outre un syndrome metabolique et est trait&eacute; pour HTA et DID.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; d\'une polygraphie nocturne dans la nuit du 16 au 17/09/2013.Cet examen a retrouv&eacute; un Index d\'apn&eacute;e -hypopn&eacute;es de 77/heure.Cet index passe &agrave; 81/H quand on y associe les limitations de d&eacute;bit.Il existe 84 d&eacute;saturations/H avec une SaO2 miniomale de 63%.Elle pr&eacute;sente par ailleurs 100 ronflements/H avec une energie moyenne de 86db.Il existe donc un syndrome d\'apn&eacute;es du sommeil pour lequel un appareillage sera mis en place par la Soci&eacute;t&eacute; Respidom.</p>\r\n<p>Elle avait &eacute;t&eacute; hospitalis&eacute; au CHU pour une grippe s&eacute;v&egrave;re et conserve sur le plan scannographique pulmonaire des l&eacute;sions de verre d&eacute;poli associ&eacute; &egrave; de la r&eacute;ticulation .Ces l&eacute;sions devront etre recontrol&eacute;s.Il existe par ailleurs une dilatation de l\'art&egrave;re pulmonaire de 38 mm t&eacute;moignant d\'un HTAP.Il existe de plus une hernie hiatale.</p>\r\n<p>Sur le plan biologique,l\'Hct est &agrave; 37.9%.La GDS &agrave; AA retrouve :pH:7.4;pCO2:45Torr;pO2:73Torr SaO2:94%.</p>\r\n<p>Mme Moutoussamy pr&eacute;sente donc un syndrome d\'Ob&eacute;sit&eacute; -hypoventilation &agrave; appareiller par VNI.</p>\r\n<p>On la place sous OLD,VNI,Kin&eacute;siettt respiratoire,Onbrez150 microg;aerosolttt &nbsp;bricanyl-atroventX3:et PulmicortX2 avec rin&ccedil;age.En ce qui concerne le r&eacute;glage de la VNI nous allons demarrer avec un Vt &agrave; 400ml;BPM &agrave; 14;Pente &agrave; 3;Ti &agrave; 1.3;IPAP &agrave;15 et EPAP &agrave; 7.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;&sect;</p>\r\n<p>&nbsp;</p>'),(492,187,'2013-10-28','SOS Médecins','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. COMBRESSAMY Ludovic n&eacute; le 17/04/1977.</p>\r\n<p>il a sejourn&eacute; en metropole du 27/09 au 23/10/2013 et s\'y portait tr&egrave;s bien.</p>\r\n<p>D&egrave;s son retour la rhinite allergique a repris.</p>\r\n<p>l\'auscultation pulmonaire retrouve ce jour des ronchi et quelques sibilances dans les deux champs pulmonaires.</p>\r\n<p>Je pense qu\'il faut renforcer le traitement avec&nbsp;</p>\r\n<p>Symbicort 2BX2 avec rin&ccedil;age de la bouche;Eludril gargarisme 10j/mois;singulair 10 mg 1cp le soir et aerius 5mg 1 cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(493,175,'2013-10-29','Dr Zimny\r\nARAR\r\nDr Mascarel','<p>Chere Consoeur,</p>\r\n<p>J\'ai vu ce jour Mme JANOLAT MARIE ROSE LUCE n&eacute;e le 21/05/1947.</p>\r\n<p>cette dame pr&eacute;sente une fatigue avec hypersomnolence diurne.Elle pr&eacute;sente aussi des cephal&eacute;es matinales avec environ 5 nyctiuries.</p>\r\n<p>Parmi ses facteurs de risque on note un d\'un cancer du poumon op&eacute;r&eacute;e en juin 2010. Cette dame est non fumeuse et pr&eacute;sente comme facteur de risque une ob&eacute;sit&eacute; (94kg pour 1m60), avec un diabete insulino-d&eacute;pendant et une hypertension art&eacute;rielle. Son p&eacute;rimetre cervical est &agrave; 44 cm avec p&eacute;rimetre abdominal &agrave; 131 cm. Le score d\'Epworth est a 9/15, avec une dyspn&eacute;e grade 4 du Modified Medical Research Concil.&nbsp;</p>\r\n<p>L\'EFR &nbsp;retrouve un trouble Ventilatoire Mixte avec VEMS &agrave; 1.06 soit 51% de la norme ; le Tiffeneau est &agrave; 78%. Il existe des signes de distension pulmonaire avec VGT &agrave; 115% et VR &agrave; 88%. La CPT est &agrave; 88%. Par ailleurs on note une augmentation des resistances des voies a&eacute;riennes &agrave; 0.84.</p>\r\n<p>L\'auscultation pulmonaire montre une diminution des bruits pulmonaires stethacoustiques.</p>\r\n<p>Mme Janolat aura une polygraphie nocturne le 30/10/2013 et aura un scanner TAP le 07/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(494,334,'2013-10-29','Dr Chabas','<p>Chers Confr&egrave;res</p>\r\n<p>J\'ai vu ce jour en consultation Mme LUI HIN TSAN Rose Marie n&eacute;e le 10/06/1926.</p>\r\n<p>Cette dame a eu un pontage aorto coronarien en 2001 et est trait&eacute; pour arthrose et HTA avec osteoporose.</p>\r\n<p>Elle pr&eacute;sente depuis sa vaccination anti grippale en juin 2013 du rhume avec eternuement et mal de gorge.</p>\r\n<p>De plus elle pr&eacute;dente une dyspn&eacute;e grade 3 du mMRC.</p>\r\n<p>L\'examen clinique montre une Sao2 &agrave; 95% et une TA &agrave; 16/9.</p>\r\n<p>l\'auscultation retrouve des sous crepitants aux bases;</p>\r\n<p>La radiographie thoracique montre un aplatissement des coupoles diaphragmatiques avec une l&eacute;g&egrave;re augmentation de volume de la silhouette cardiovasculaire.</p>\r\n<p>Les GDS &agrave; AA montrent pH 7.48 pCO2 37Torr pO2 76 Torr SaO2 95%.Les proBNP sont &agrave; 216pg/ml .</p>\r\n<p>Il est n&eacute;cessaire que Mme LUI &nbsp;revoye le Dr Chane Woon Ming pour une echocardiographie.</p>\r\n<p>Les EFR sont dans l\'ensemble satisfaisante:Spirographie et plethysmographie dans les limites de la normale.On note une diminution mod&eacute;r&eacute;e de la TLCO &agrave; 3.46 soit 68% de la norme.</p>\r\n<p>Pour l\'instant on poursuit l\'a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X2/ jour</p>\r\n<p>associ&eacute; &agrave; Kin&eacute;sieth&eacute;rapie respiratoire:technique de Ventilation dirig&eacute;e 3 fois / semaine &agrave; domicile.</p>\r\n<p>Veuillez agr&eacute;er,Chers Confr&egrave;res,l\'assurance de ma haute consid&eacute;ration;</p>\r\n<p>Dr B.TANGUY.</p>\r\n<p>29/10/2013:Je revois ce jr Mme Lui je represcrit l\'aerosolttt et la kin&eacute;siettt respi/</p>\r\n<p>&nbsp;</p>'),(495,177,'2013-10-29','Dr Jean Pierre CATTEAU\r\nEHPAD Clovis Hoareau\r\nDr HALLET','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. MANORO Gabriel, n&eacute; le 31/08/1942</p>\r\n<p>ce patient ancien fumeur pr&eacute;sente une insuffisance respiratoire obstructive tr&egrave;s s&eacute;v&egrave;re avec une hypoxie &agrave; 63TOrr ainsi qu\'une distension pulmonaire.</p>\r\n<p>La radiographie thoracique retrouve des signes de distension thoracique avec aplatissement et d&eacute;formation des coupoles diaphragmatiques&nbsp;</p>\r\n<p>On augmente Onbrez &agrave; 300 microg/j associ&eacute; &agrave; Spiriva Respimat 2b/j et Miflonil 400 1bx2 avec rin&ccedil;age de la bouche et kin&eacute;siettt respiratoire :technique de ventilation dirig&eacute;e :3 s&eacute;ances /semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p><span style=\"font-size: 11px;\">&nbsp;</span></p>'),(496,243,'2013-10-29','Dr Sarah M\'buyamba','<p>Chere Sarah,</p>\r\n<p>Vous aurez le 31/10/2013 M.Testan joseph Marcel en endoscopie.</p>\r\n<p>Pourriez vous demander aux anatpath de m\'adresser un double de leur interpr&eacute;tation?</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, chere Sarah, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>INFLAMMATION AIGUE NON SPEcifique :Biopsies.</p>\r\n<p>ASPI /ABSENCE D\'ELEMENT SUSPECT DE MALIGNITE</p>'),(498,492,'2013-10-29','Dr Taochy\r\nISIS Médical','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PAYET Rose Hermina n&eacute;e le 24/10/1929.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; ce jour d\'une EFR qui retrouve un trouble ventilatoire restrictif avec CPT &agrave; 69% de la norme,VGT &agrave; 72% et VR &agrave; 74% de la norme.Le VEMS est &agrave; 1.27 soit 92% et le Tiffeneau &agrave; 93%.Il existe une resistance des voies a&eacute;riennes &agrave; 0.47.</p>\r\n<p>Par ailleurs cette est trait&eacute; pour syndrome d\'apn&eacute;e du sommeil;</p>\r\n<p>Elle pr&eacute;sente deux nyctiuries et pr&eacute;sente des c&eacute;phal&eacute;es matinales.son score d\'Epworth est &agrave; 9/21.</p>\r\n<p>Le score de Mallampati est de 2 /4.sur le plan facial elle pr&eacute;sente un l&eacute;ger retrognatisme.</p>\r\n<p>Facteurs de Risque:Mme Payet&nbsp;est trait&eacute; pour HTA et DNID ainsi que pour arthrose des genoux, hanches et la r&eacute;gion lombaire et cervicale.Elle a pr&eacute;sent&eacute; un AIT en mai 2012.</p>\r\n<p>Je pense qu\'il convient de poursuivre la kin&eacute;siettt respiratoire avec Onbrez 300 et miflonil 400 X2 avec rin&ccedil;age.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(499,99,'2013-10-29','',''),(500,198,'2013-10-29','Dr Laurence LEGROS','<p>Ch&egrave;re Consoeur</p>\r\n<p>J\'ai revu en consultation ce jour M.SINAPAN Lucien n&eacute; le 02/02/1938.</p>\r\n<p>il n\'a jamais fum&eacute;.</p>\r\n<p>Son &eacute;tat s\'est nettement amelior&eacute; et l\'auscultation ne retrouve ce jour que quelques sibilances.</p>\r\n<p>il convient de poursuivre le traitement par Onbrez 300/j ,Spiriva Respimat 2B/j et kin&eacute;siettt respiratoire &nbsp;3 s&eacute;ances / semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(501,630,'2013-10-29','Dr ','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. MORBY Jean Yves n&eacute; le 23/11/1968.</p>\r\n<p>Ce mari&eacute; est mari&eacute; sans enfant et il est facadier en batiment.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dets on note des allergies :rhinite allergique et allergies oculaires.</p>\r\n<p>il a pr&eacute;sent&eacute; des mycoses cutan&eacute;es;</p>\r\n<p>depuis dimanche il pr&eacute;sente un f&eacute;bricule avec asth&eacute;nie et mal &agrave; la gorge.</p>\r\n<p>Je lui prescrit</p>\r\n<p>Xyzall;Ketoderm;Eludril;Efferalgan.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(502,541,'2013-10-29','Dr Gasnier\r\nService d\'Oncologie,clinique Ste Clotilde\r\nMme Galmar','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re,</p>\r\n<p>Comme convenu avec le Dr Begue ,je vous adresse M.Ibouth ,Slyvestre n&eacute; le 01/01/1935.</p>\r\n<p>ce patient a &eacute;t&eacute; op&eacute;r&eacute; par le Pr Gambiez le 05/04/2012 pour un adenocarcinome de la charni&egrave;re recto-sigmoidienne avec envahissement du dome v&eacute;sical.Une ex&egrave;r&eacute;se compl&egrave;te a &eacute;t&eacute; r&eacute;alis&eacute;e avec colectomie gauche avec anastomose termino-terminale .&nbsp;</p>\r\n<p>Ce monsieur est un ancien fumeur 1 pqt/j sevr&eacute; depuis 1984.Il buvait aussi et est sevr&eacute;.Il exercait la profession de coupeur de canne.Il est c&eacute;libataire sans enfantIl pr&eacute;sente une dyspn&eacute;e grade&nbsp;IVde l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'examen clinique montre un assourdissement des bruits pulmonaires stethacoustiques.L\'EFR montre un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 82%,le VEMS est &agrave; 1.45 soit 60% et le Tiffeneau &agrave; 100%.il existe des signes de distension pulmonaire avec VGT &agrave; 140% VR &agrave; 137 % de la norme.</p>\r\n<p>M.Ibouth a b&eacute;n&eacute;fici&eacute; d\'un TDM TAP sans injection le 17/10/2013. Cet examen retrouve une masse lobaire sup&eacute;rieure gauche de 6.2cm param&eacute;diastinale avec des nodules multiples d\'allure secondaire.A ce lacher de ballon on note des l&eacute;sions h&eacute;patiques nodulaires &eacute;voquant des l&eacute;sions secondaires.</p>\r\n<p>J\'adresse donc M.Ibouth au Dr Gasnier ,oncologue pour la prise en charge th&eacute;rapeutique le 05/11/2013 &agrave; 16:15.</p>\r\n<p>Sur le plan th&eacute;rapeutique il covient de poursuivre a&eacute;rosolth&eacute;rapie(Bricanyl-atrovent)X2, Onbrez 300 /j et Kin&eacute;siettt respiratoire x3/semaine;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(504,203,'2013-10-29','Dr Goburdhun','<p>Cher ami</p>\r\n<p>J\'ai revu ce jour Mme NUMA Anne Marie n&eacute;e le 09/05/1926 trait&eacute;e pour asthme s&eacute;v&egrave;re d\'origine allergique par XOLAIR 300mg toutes les 4 semaines en S/C.</p>\r\n<p>Mme NUMA presente dans ses ant&eacute;c&egrave;dents une cardiopathie isch&eacute;mique il y a 2 ans .Elle est trait&eacute; pour HTA.</p>\r\n<p>Elle est veuve et a 6 enfants.</p>\r\n<p>Son asthme est actuellement bien control&eacute; .</p>\r\n<p>L\'EFR pratiqu&eacute; ce jour est dans les limites de la normale.</p>\r\n<p>Elle poursuivra&nbsp;</p>\r\n<p>A&eacute;rosolth&eacute;rapie Bricanyl-AtroventX2/j&nbsp;</p>\r\n<p>Miflonil 400X2/j</p>\r\n<p>Singulair 10mg 1 cp le soir.</p>\r\n<p>et XOLAIR.</p>\r\n<p>Je la reverrai en consultation le 29/10/2013.</p>\r\n<p>je te prie de croire en mes amiti&eacute;s</p>\r\n<p>Dr B.TANGUY</p>'),(505,98,'2013-10-29','Dr Chabas','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GRONDIN Marie Odette n&eacute;e le 10/11/1950.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note un fils qui a pr&eacute;sent&eacute; des &eacute;pisodes asthmatiques.</p>\r\n<p>Mme Grondin a d&eacute;ja pr&eacute;sent&eacute; de l\'ecz&egrave;ma,de l\'urticaire,une conjonctivite et une rhinite allergique.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e des amygdales &nbsp;et a pr&eacute;sent&eacute; une dipht&eacute;rie dans l\'enfance.Elle fait de l\'asthme depuis 2 &agrave; 3 ans.</p>\r\n<p>Sous traitement tout a regr&eacute;ss&eacute; et l\'asthme est bien control&eacute;.L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>La radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>Les IgE totales sont &agrave; 2193UI/ml.Il n\'existe pas d\'hypereosinophilie.Mme Grondin pr&eacute;sente une allergie classe 4 aux phan&egrave;res de chat et classe 2 aux phan&egrave;res de chien.En ce qui concerne les acariens son allergie est de classe2.;Elle est classe 4 &agrave; bon nombre de pneumallerg&egrave;nes;En ce qui concerne les trophallerg&egrave;nes elle est classe 4 &agrave; l\'avocat et classe 3 &agrave; l\'arachide;classe aux crevettes ,soja.</p>\r\n<p>Ses EFR montrent un trouble ventilatoire obstructif tr&egrave;s mod&eacute;r&eacute; avec un VEMS &agrave; 1.4 soit 76% de la norme passant &agrave; 1.59 soit 85% de la norme sous b2mimetiques,traduisant une hyperreactivit&eacute; bronchique.</p>\r\n<p>Poursuivre le meme traitement FORADIL 1 gel inhal&eacute; m et s et MIFLONIL 200 1 gel inhal&eacute; m et s avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(506,610,'2013-10-29','Dr Goulam Abasse\r\nlaboratoire de la trinité\r\n0262305454','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. MADI Djoumoi, n&eacute; le 01/01/1930</p>\r\n<p>Ce monsieur est &agrave; la R&eacute;union depuis 3 semaines;il s\'agit d\'un ancien fumeur.Il &eacute;tait gendarme &agrave; Mayotte.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une prostatectomie &agrave; la R&eacute;union en 2006;une hernie inguinale aux Comores.</p>\r\n<p>Actuellement il est trait&eacute; depuis 6 mois pour une tuberculose pulmonaire &agrave; Mayotte.Il est actuellement trait&eacute; par Rimifon 300mg et Rifadine 600mg.En juin/juillet 2013 la recherche de BAAR &eacute;tait n&eacute;gatif &agrave; l\'examen direct &agrave; Mayotte.</p>\r\n<p>Le patient est somnolent et la famille ne connait pas quel traitement il prend exactement.De plus la famille n\'a pas amen&eacute; le scanner ant&eacute;rieur.Je leur demande de m\'amener tout cela.</p>\r\n<p>J\'ai appel&eacute; le laboratoire de la Trinit&eacute; mais aucuin r&eacute;sultat n\'est disponible pour l\'instant. je reverraio ce patient avec son ancien scanner le 04/11/2013 &agrave; 16:00.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(507,230,'2013-10-30','Dr Thierry PAUVERT\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme DE VILLEPRE Marie Laurence n&eacute;e le 22/08/1931.</p>\r\n<p>Cette dame mari&eacute; a 7 enfants. Elle est sans profession.elle cuisinait au feu de bois pour sa famille.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une appendicectomie, une intervention pour kyste de l\'ovaire droite et fracture du poignet droit.</p>\r\n<p>Mme De villepr&eacute; est trait&eacute; pour syndrome d\'apn&eacute;es du sommeil avec appareillage avec SOS Oxyg&egrave;ne.Elle est moins somnolente .Actuellement son score d\'Epworth est &agrave; 9/21.Le score de Mallampati est de 3/4.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IIde l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire .</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire mixte avec CPT &agrave; 72% VR &agrave; 59% le VEMS est &agrave; 1.40 soit 86% passant &agrave; 1.53 sous b2inhal&eacute;s traduisant une bronchor&eacute;activit&eacute; sans trouble du transfert.</p>\r\n<p>Il convient de poursuivre chz elle Symbicort 200 BX2 avec rin&ccedil;age de la bouche associ&eacute; &agrave; Bricanyl 1B/J.</p>\r\n<p>Je lui conseille de faire une kin&eacute;siettt respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(508,26,'2013-10-30','Dr Pierron\r\nDr Fontaine\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme. GAUTHIER Denise n&eacute; le 16/11/1932.</p>\r\n<p>Cette dame est divorc&eacute;e et a 4 enfants.Elle est ancienne directrice d\'&eacute;cole &agrave; la retraite.</p>\r\n<p>Elle est non fumeuse et dans ses ant&eacute;c&egrave;dents on note 4 interventions:kyste &agrave; l\'ovaire droite,,polypes &agrave; l\'uterus.</p>\r\n<p>Elle est surtout trait&eacute; pour d&eacute;pression et syndrome bipolaire,HTA,arthrose dans l\'&eacute;paule droite.</p>\r\n<p>Elle est trait&eacute; par D&eacute;pamide,atarax,efferalgan,flector gel.</p>\r\n<p>Elle a &eacute;t&eacute; trait&eacute; pour asthme par a&eacute;rosolth&eacute;rapie au mois de juin 2013.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade I de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultation pulmonaire retrouve un l&eacute;ger freinage expiratoire avec qulques sibilances.</p>\r\n<p>L\'EFR du 26/07/2013 montre une distension pulmonaire avec VGT &agrave; 115% VR &agrave; 132% .Le VEMS est &agrave; 1.16 soit 74% il passe &agrave; 1.49 soit 95&ugrave; de la norme sous bronchodilatateur avec une am&eacute;lioration de 28%.Cela traduit une bronchor&eacute;activit&eacute;.</p>\r\n<p>Mme Gauthier a par ailleurs des probl&egrave;mes de sommeil et pr&eacute;sente 3 nyctiuries.</p>\r\n<p>On va lui enseigner &agrave; remplir un agenda de sommeil et je la reverrai dans 3 semaines.</p>\r\n<p>Je lui conseille un traitement par FORADIL et MIFLONIL.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(509,336,'2013-10-30','Dr KOENIG','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour en cosultation M. GRAVINA Marie Joseph n&eacute; le 02/07/1949.</p>\r\n<p>Le scanner thoracique du 05/10/2013 compar&eacute; &agrave; celui du &nbsp;17/11/2011 retyrouve des calcifications pleurales &eacute;tendues de la base droite d\'aspect inchang&eacute; .Il n\'existe pas de l&eacute;sion parenchymateuse &eacute;volutive.</p>\r\n<p>La gazom&eacute;trie &agrave; AA retrouve pH 7.38;pCO2 40.1 Torr pO2 81.4 Torr;SaO2 97%.hb &agrave; 15.2 g/dl.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour quleques ronchi aux bases.L\'EFR retrouve un trouble ventilatoire mixte avec CPT &agrave; &nbsp;65% de la norme, le VR est &agrave; 68% de la norme.On note une composante obstructive Gold II, mod&eacute;r&eacute;, avec VEMS &agrave; 55% de la norme. La TLCO est &agrave; 84% de la norme donc sans particularit&eacute;.</p>\r\n<p>Il convient donc de poursuivre la kin&eacute;siettt respiratoire et passer &agrave; Onbrez 300 /J;</p>\r\n<p>&nbsp;Veuillez agr&eacute;er, cher Confr&egrave;re,l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(510,609,'2013-10-30','Dr Goulam Abasse\r\nDr Kichenin\r\nCardiologue\r\nDr GAY','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme COJONDE Val&eacute;rie THEONIA, n&eacute;e le 18/05/1928.</p>\r\n<p>Cette dame est veuve et a eu 8 enfants.Elle travaillait comme blanchiseuse.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une op&eacute;ration pour fibrome ut&eacute;rin et une appendicectomie.Elle a &eacute;t&eacute; op&eacute;r&eacute;e des 2 genoux,et de la cataracte,Elle est trait&eacute; pour angine de poitrine,HTA.Elle dit avoir &eacute;t&eacute; trait&eacute; pour diab&egrave;te.</p>\r\n<p>Elle est trait&eacute; par AMLOR 5 mg,INEXIUM 20mg,CORDARONE et ventoline.Elle se plaint de dyspn&eacute;e depuis 1 mois.</p>\r\n<p>Mme Cojonde pr&eacute;sente une symptomatologie de reflux gastro oesophagien,Et on note &agrave; l\'examen clinique une hernie inguinale gauche.L\'auscultation pulmonaire montre un l&eacute;ger assoudissement des bruits pulmonaires stethacoustiques.</p>\r\n<p>mme COJONDE pr&eacute;sente 3 nyctiuries,avec tete lourde le matin.Son scoreb d\'Epworth est &agrave; 3/21 ;le score de Mallampati est de 2 /4.</p>\r\n<p>Sur le plan biologique l\'Hb est &agrave; 14.7g/dl,la glyc&eacute;mie &agrave; 4.99 mmol/l ;clairance &agrave; la creatinine &nbsp;70.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire avec dosage de proBNP et je programme une EFR.</p>\r\n<p>Je demande &agrave; la patiente de consulter le Dr Kichenin pour pratiquer une echocardiographie.</p>\r\n<p>En attendant je la place sous oxg&eacute;noth&eacute;rapie de courte dur&eacute;e &agrave; raison de 2L/mn et a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/J;Je la reverrai le 07/11/2013 avec le r&eacute;sultats des examens demand&eacute;s et pratiquer une EFR pour adapter son traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(511,613,'2013-10-30','Dr I.PATEL','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAZEFARSON Sandra n&eacute;e le 12/01/1980.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents familiaux on note une m&egrave;re asthmatique un grandp&egrave;re maternel asthmatique.ses 2 fils sont aussi asthmatiques.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels elle a un fibrome ut&eacute;rin.</p>\r\n<p>Son asthme a d&eacute;but&eacute; il y a deux ans en meme temps que son fibrome qui lui occasionne des metrorragies.Elle pr&eacute;sente des r&egrave;gles abondantes.</p>\r\n<p>Elle se sent fatigu&eacute; le matin au r&eacute;veil avec c&eacute;phal&eacute;es et a 3 nyctiuries.Sa famille lui dit qu\'elle ronfle avec des pauses respiratoires.son score d\'Epworth est &agrave; 18/24 avec un&nbsp;&nbsp;score de Mallampati est de 2 /4.</p>\r\n<p>L\'auscultation pulmonaire montre des ronchi dans les deux champs pulmonaires;</p>\r\n<p>Je lui conseille de prendre du FORADIL 1 gelX2 avec MIFLONIL 1 gelX2 avec rincage de la bouche et kin&eacute;siettt respiratoire avec musculation des abdominaux.</p>\r\n<p>je la reverrai le 04/11 pour des EFR et le 05/11 pour une polygraphie nocturne.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(512,192,'2013-10-30','Dr Dallel','<p>Chers confr&egrave;res</p>\r\n<p>J\'ai revu ce jour M. SELLY Hubert n&eacute; le 02/11/1945.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>l\'hb est &agrave; 14.5 g/dl,la clairance r&eacute;nale est &agrave; 40ml/mn.</p>\r\n<p>il convient qu\'il poursuive la kin&eacute;siettt respiratoire avec musculation des abdominaux et nous controlerons ses EFR en janvier 2014.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(513,479,'2013-10-30','Dr Richard PIERRAT','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme DELMOND Andy Risla n&eacute;e le 26/02/1942.</p>\r\n<p>nous avons compar&eacute;s ses scanners thoraciques et surrenaliens des 10/01/2013,27/06/2013 et du 25/09/2013 &agrave; fin de comparaison.Les 3 scanners sont identiques et il n\'existe aucune r&eacute;cidive.</p>\r\n<p><span style=\"font-size: 11px;\">Mme Delmond poursuivra IRESSA 250mg 1cp/jour et je la reverrai d&eacute;but janvier avec une radiographie pulmonaire;le prochain scanner sera pratiqu&eacute; fin mars 2014.</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(514,456,'2013-10-30','dr issac Ismael\r\n','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. QUEMENER Roger n&eacute; le 12/01/1939.</p>\r\n<p>Il pr&eacute;sente toujours un f&eacute;bricule le soir avec une douleur dans la poitrine avec difficult&eacute; de respirer en position allong&eacute;.</p>\r\n<p>le Dr Chopra ,cardiologue,lui a dit que tout &eacute;tait bien sur le plan cardiologique;</p>\r\n<p>M.Quemener a eu une polygraphie nocturne dans la nuit du 24 au 25/10/2013.Cet examen a retrouv&eacute; un index d\'apn&eacute;es-hypopn&eacute;es &agrave; 33/H.Cet index passe &agrave; 35/H avec les limitations et &agrave; 48/h avec les &eacute;venements .Le nombre de d&eacute;saturations est &agrave; 42/heure avec une d&eacute;saturation minimale de 81%.</p>\r\n<p>le nombre de ronflement est de 170/H avec une energie moyenne de 82db.</p>\r\n<p>Il y a indication &agrave; appareiller M.Quemener en PPC mais il pr&eacute;f&egrave;re attendre le mois de janvier pour cela.</p>\r\n<p>l\'auscultation pulmonaire retrouve des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>il refuse l\'onbrez qui lui entraine des oed&egrave;mes.</p>\r\n<p>je lui conseille une a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X3/j et Bicarbonate 14 p mille avec Kin&eacute;siettt respiratoirex3/semaine.</p>\r\n<p>En attendant poursuivre Soluppred 30mg &agrave; r&eacute;duire &agrave; 20 mg d&egrave;s qu\'il se sentira mieux;</p>\r\n<p>J\'ai conserv&eacute; le TDM du 30/09/2013 pour adresser au Pr H.NUNES pour avis.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>J</p>'),(515,601,'2013-10-30','Dr Wan Hoi\r\nDr Ledig','<p>&nbsp;</p>\r\n<p>Cher Robert</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour enregistrement polygraphique du sommeil M. AMOUNY Georges Michel, n&eacute; le 04/02/1959.</p>\r\n<p>Ce monsieur vit en concubinage et a 2 enfants.Il est non fumeur et a travaill&eacute; &agrave; l\'ONF ou il s\'occupait des espaces verts.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une insuffisance coronarienne avec angioplastie et pose de stent.Il pr&eacute;sente &eacute;galement une surdit&eacute;.Il est &eacute;galement trait&eacute; pour DNID et HTA.</p>\r\n<p>Il pr&eacute;sente un ronflement depuis plusieurs ann&eacute;es avec pauses respiratoires.I pr&eacute;sente une hypersomnie diurne. M.Amouny pr&eacute;sente 2 nyctiuries.Son score d\'Epworth peut etre &eacute;valu&eacute; &agrave; 6/21.Le score de Mallampati est de 2 /4.</p>\r\n<p>Son perimetre cervical est de 40 cm;son perimetre abdominal est de 100cm</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.Nous allons lui apprendre &agrave; remplir un agenda de sommeil.je lui programme une EFR le 4/11/2013 &agrave; 8H30 et une polygraphie nocturne le &nbsp;05/11/2013 &agrave;17:30.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(516,2,'2013-10-30','Dr Pothier\r\nDr Genin\r\nDr Mascarel','<p>&nbsp;</p>\r\n<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. LEBRETON Pierre n&eacute; le 23/02/1952.</p>\r\n<p>Ce patient a pr&eacute;sent&eacute; une douleur vive du genou droit qui s\'est accrue.la radiographie du 24/09/2013 retrouve une g&eacute;ode sous chondrale de la styloide fibulaire en rapport avec un d&eacute;but d\'arthrose.J\'ai conseill&eacute; &agrave; M.Lebreton de le mettre une attelle pour bloquer l\'articulation tout en mettant des bas de contention pour &eacute;viter une thrombose veineuse des membres inf&eacute;rieurs et discuter avec le Dr Genin d\'une anticoagulation.</p>\r\n<p>Je conseille &eacute;galement un TDM thoracique sans injection et je le reverrai pour des EFR car il se plaint de g&egrave;ne respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(517,612,'2013-10-30','Dr Corouge\r\nDr Kantalin','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CHEUNG-LUNG Joseph n&eacute; le 10/06/1939.</p>\r\n<p>IL a b&eacute;n&eacute;fici&eacute; d\'une EFR qui est quasiment dans les limites de la normale.</p>\r\n<p>Le VEMS est &agrave; 2.02 soit 79% de la norme.Le Tiffeneau est &agrave; 88% de la norme.La CPT est &agrave; 80% avec VGT &agrave; 74% de la normale.La resistance des voies a&eacute;riennes est augment&eacute;e &agrave; 0.42 sans trouble du transfert.</p>\r\n<p>On peut lui proposer un traitement par FORADIL 1 b X 2 pendant 2 mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(518,482,'2013-10-30','Dr Chane Wai Nam\r\nSOS Oxygène','<p>&nbsp;Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour M. CARPAYE Christian n&eacute; le 05/06/1938.</p>\r\n<p>L\'auscultation pulmonaire retrouve des rales velcro aux deux bases.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire restrictif avec CPT &agrave; 63% de la norme;VR &agrave; 52% et VGT &agrave; 68% de la norme.La spirographie est dans les limites de la normale avec un VEMS &agrave; 2.28 soit 89% le Tiffeneau est &agrave; 99% de la norme.Il existe des troubles du transfert avec TLCO &agrave; 53%.</p>\r\n<p><span style=\"font-size: 11px;\">M. Carpaye a eu un TDM thoracique le 24/10/2013;Cet examen a montr&eacute; un aspect de fibrose avec rayon de miel &agrave; pr&eacute;dominance sous pleurale associ&eacute;e &agrave; de la r&eacute;ticulation.l\'aspect &eacute;tant &eacute;vocateur d\'une UIP.Il n\'a pas &eacute;t&eacute; retrouv&eacute; de modification par rapport au &nbsp;TDM de mai 2013.</span></p>\r\n<p><span style=\"font-size: 11px;\">Sur le plan th&eacute;rapeutique je conseille une kin&eacute;siettt respiratoire X3/semaine avec a&eacute;rosolth&eacute;rapie PulmicortX2/j avec rin&ccedil;age de la bouche &agrave; l\'eau par la suite.</span></p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(519,101,'2013-10-30','',''),(520,166,'2013-10-31','Dr DIVI','<p>Cher Confr&egrave;re et ami</p>\r\n<p>j\'ai revu ce jour M.DALLEAU Moise n&eacute; le 24/012/1948.</p>\r\n<p>Il s\'agit d\'un ancien fumeur jusqu\'&agrave; 1paquet et demi/jour sevr&eacute; en 2000 &agrave; la suite d\'un AVC.Il totalise pr&egrave;s de 50PA.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un HTA et un AVC en 2000 pour lequel il a parfaitement recup&eacute;r&eacute;.</p>\r\n<p>Il dit pr&eacute;senter une dyspn&eacute;e grade II de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Je prescrit un TDM thoracique de d&eacute;pistage comme il s\'agit d\'un ancien gros fumeur et je le reverrai en Consultation dans 3 mois.Iil poursivra la kin&eacute;siettt respiratoire 2x/semaine ainsi qu Onbrez 300/j;spiriva Respimat 2b/j et miflonil 400 1Bx2/j avec rin&ccedil;age de la bouche &agrave; l\'eau associ&eacute; &agrave; la PPC.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re et ami, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>i</p>'),(521,352,'2013-10-31','Dr Nadia RAMASSAMY\r\nPharmacie de Ste Suzanne\r\nDr Guijarro\r\nAngiologue','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PAQUIRY Roger n&eacute; le 06/08/1931.</p>\r\n<p>Ce monsieur n\'a jamais fum&eacute;.Il est mari&eacute; et 5 enfants.Il exercait la profession de coupeur de cannes.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une HTA,DID et insuffisance respiratoire.</p>\r\n<p>Depuis plusieurs ann&eacute;es il pr&eacute;sente une g&egrave;ne respiratoire avec toux et expectoration muco-purulente.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Son IMC est &agrave; 30.5 ce qui correspond &agrave; une ob&eacute;sit&eacute; mod&eacute;r&eacute;(poids de 80K pour une taille de 162cm).</p>\r\n<p>Il pr&eacute;sente une symptomatologie de RGO et le traitement anti reflux l\'a amelior&eacute;.</p>\r\n<p>L\'auscultation pulmonaire retrouve un freinage expiratoire avec des ronchi.</p>\r\n<p>Le score de Mallampati est de 3 /4.m.Paquiry pr&eacute;sente une hypersomnie diurne avec un Score d\'Epworth &eacute;valu&eacute; &agrave; 18/21.Il b&eacute;n&eacute;ficiera d\'une polygraphie ventilatoire le 22/01/2014 &agrave; 16H.</p>\r\n<p>le TDM thoracique en date du 05/09/2013 montre un &eacute;paississement des parois bronchiques avec hyperclart&amp;&eacute; parenchymateuse due &agrave; une atteinte bronch&eacute;olaire entrainant des ph&eacute;nom&egrave;nes de vasoconstriction.On note un petit bronchoc&egrave;le du lobe inf&eacute;rieur droit.Echodoppler veineux des MI &eacute;tait normale le 11/09/2013.Je conseille un RV avec le Dr Guiljarro,angiologue.</p>\r\n<p>L\'EFR a montr&eacute; un trouble ventilatoire obstructif s&eacute;v&egrave;re GOLD III avec un VEMS &agrave; 0.82 soit 39% de la norme avec un Tiffeneau &agrave; 60%.Il existe une distension pulmonaire avec VGT &agrave; 134% et VR &agrave; 134%.</p>\r\n<p>Il poursuivra l\'OLD,la kin&eacute;siettt respiratoire,l\'a&eacute;rosolth&eacute;rapie(bricanyl-atrovent)X2/j et PulmicortX2 avec rin&ccedil;age associ&eacute; &agrave; Spiriva Respimat2B/j et Onbrez 300 1B/j ce qui permettera de diminuer la consommation de Ventoline.</p>\r\n<p>&nbsp;Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(522,193,'2013-10-31','Dr METE','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme ALAISE Daniela Marie n&eacute;e le 26/03/1971.</p>\r\n<p>Son asthme est actuellement bien control&eacute;.Elle a recommenc&eacute; &agrave; pratiquer de la marche.</p>\r\n<p>L\'auscultation puklmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Je lui renouvelle XOLAIR 375 mgX2/mois .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(523,501,'2013-10-31','Dr Patrice HUMBERT','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PICARDO Louisette suzanne n&eacute;e le 30/08/1930.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; ce jour d\'une EFR qui retrouve un trouble ventilatoire obstructif avec VEMS &agrave; 0.81 soit 63% de la norme.Il existe une distension pulmonaire avec VGT &agrave; 133%,VR &agrave; 148%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.77.</p>\r\n<p>Sur le plan biologique l\'Hb est &agrave; 13.5g/dl avec Hct &agrave; 10.9%.</p>\r\n<p>Les GDS &agrave; AA montrent:pH 7.49 pCO2:38 Torr; pO2:83Torr SaO2:97%.</p>\r\n<p>Il convient &nbsp;de poursuivre une Kin&eacute;sieth&eacute;rapie respiratoire associ&eacute; &agrave; l\'a&eacute;rosolth&eacute;rapie:Bricanyl-Atrovent)X4/j et Pulmicort)X2 avec rincage de la bouche .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(524,509,'2013-10-31','Drv Ramilison','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BEOLET Andre Claude n&eacute; le 19/07/1939.</p>\r\n<p>Ses EFR montrent une spirographie dans les limites de la normale.</p>\r\n<p>La plethysmographie retrouve une distension pulmonira avec VGT &agrave; 114% et VR &agrave; 12% de la norme.Il n\'existe pas de trouble du transfert.</p>\r\n<p>Sur le plan th&eacute;rapeutique nous lui prescrivons du Spiriva Respimat 2B/j.</p>\r\n<p>M.Beolet pr&eacute;sente un ronflement .Il pr&eacute;sente 3 nyctiuries.</p>\r\n<p>Son score d\'Epworth est de 6/24.Le score de Mallampati est de 2 /4.</p>\r\n<p>Son sommeil est de mauvaise qualit&eacute; et il pr&eacute;sente une hypersomnie diurne.</p>\r\n<p>Nous allons apprendre au patient &agrave; remplir un agenda de sommeil et nous lui programmons une polygraphie ventilatoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(525,508,'2013-10-31','Dr Ramilison','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme BEOLET Daniele n&eacute;e le 23/06/1948.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire mixte tr&egrave;s mod&eacute;r&eacute; avec CPT &agrave;79% de la norme.VGT &agrave; 76% .Le VEMS est &agrave; &agrave; 1.42 soit 72% avec un Tiffeneau &agrave; 82%.</p>\r\n<p>les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.6 .il n\'existe pas de trouble du transfert.</p>\r\n<p>Son asthme est actuellement bien &eacute;quilibr&eacute; et l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(526,628,'2013-10-31','Dr Sylvie GLORIEUX\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. BOULLEY Jean Claude, n&eacute; le 16/02/1944</p>\r\n<p>Ce monsieur fumeur 1paquet et demi/j totalise environ 60PA.</p>\r\n<p>Il est mari&eacute; et a 3 enfants.Il est retrait&eacute; ex-artisan menuiserie.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note prostatectomie en 01/2011,et une angioplastie avec stent coronarien en 10/2012.Il &nbsp;pr&eacute;sente par ailleurs une insuffisance r&eacute;nale chronique mod&eacute;r&eacute;e avec AC/FA &nbsp;et cardiopathie hypertrophique non isch&eacute;mique.</p>\r\n<p>Ce patient pr&eacute;sente un important ronflement avec des pauses respiratoires.il dit ne pas pr&eacute;senter d\'hypersomnie particuli&egrave;re mais passe des nuits sans dormir;il prend 2 caf&eacute;s et un th&eacute; par jour.</p>\r\n<p>Son score d\'Epworth est difficile &agrave; &eacute;valuer;Le score de Mallampati est de 3 /4.</p>\r\n<p>Le perim&egrave;tre cervical est de 45 cm avec un perim&egrave;tre abdominal &agrave; 104cm.</p>\r\n<p>l\'auscultation pulmonaire retrouve des ronchi dans les deux champs pulmonaires.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>Il a rendez pour des EFR le 06/11/2013 et m\'apportera son scanner thoracique.</p>\r\n<p>Une polygraphie ventilatoire est pr&eacute;vue le 12/11/2013 &agrave; 16:30</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(527,627,'2013-10-31','Dr  Sylvie GLORIEUX\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. DUBARD Jean Pierre, n&eacute; le 04/01/1949</p>\r\n<p>Ce monsieur est fumeur et fume actuellement des cigarettes &eacute;lectroniques.Il fumait un demi paquet/j et totalise environ 20PA.il est chauffeur camion &agrave; la retraite.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note un DNID,une HTA,une hypercholesterol&eacute;mie.</p>\r\n<p>Il pr&eacute;sente un ronflement depuis toujours. Actuellement il pr&eacute;sente des c&eacute;phal&eacute;es matinales avec 3 nyctiuries.son sommeil est de mauvaise qualit&eacute; et nous allons lui enseigner &agrave; remplir un agenda de sommeil.</p>\r\n<p>Son score d\'Epworth est &agrave; 18/24.Le score de Mallampati est de 2 /4.</p>\r\n<p>Le perimetre cervical est de 41cm avec un perimetre abdominal de 101cm.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale;</p>\r\n<p>On note une symptomatologie de reflux gastro oesophagien &agrave; traiter par INEXIUM 40 mg m et s associ&eacute; &agrave; GAVISCON 1 sachetX3.</p>\r\n<p>Je le reverrai en EFR le 20/11/2013 avec une polygraphie ventilatoire le 14/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(528,557,'2013-10-31','Dr Guilbaud','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ASENSIO Manuel n&eacute; le 27/05/1936.</p>\r\n<p>Ses EFR sont dans les limites de la normale</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(529,506,'2013-10-31','Dr Wan Hoi','<p>Cher ami</p>\r\n<p>J\'ai revu ce jour M.Law-Yen laurent n&eacute; le 04/01/1982 .sa tracheotomie shunt sa st&eacute;nose trach&eacute;ale et il \'guerit\' ses probl&egrave;mes ventilatoires.</p>\r\n<p>Nous ne pouvons lui r&eacute;aliser une polygraphie ventilatoire comme il le souhaite ;</p>\r\n<p>L\'analyse de son agenda de sommeil montre qu\'il se couche tard &nbsp;et &agrave; des heures irreguli&egrave;res maist n\'a pas de difficult&eacute; d\'endormissement.</p>\r\n<p>Nous pouvons lui proposer une polysomnographie pour d&eacute;tecter des micro-&eacute;veils;</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(530,632,'2013-10-31','Dr CHUONG\r\nDr MEYER','<p>Cher ami</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour avis Mme ADOLPHE Patricia, n&eacute;e le 09/01/1962.</p>\r\n<p>Cette dame est mari&eacute; et a 3 enfants.Elle &eacute;tait s&eacute;cr&eacute;taire m&eacute;dical.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une hemithyroidectomie des pour des nodules thyroidiens et un goitre &nbsp;il y a10ans.</p>\r\n<p>Elle est suivi pour asthme depuis 1982 ann&eacute;e de la naissance de sa premi&egrave;re fille.Dans la famille elle a un grand p&egrave;re et des enfants asthmatiques.</p>\r\n<p>Elle est trait&eacute; par LEVOTHYROX 100 et Seretide 500 1BX2 avec un traitement homeopathique.</p>\r\n<p>Depuis cette ann&eacute;e elle se sent fatigu&eacute;e.Elle ronfle beaucoup et son mari note des pauses dans son sommeil.Elle se reveille en sursaut.Elle presente 5 nyctiuries.Elle a souvent des migraines.</p>\r\n<p>Son score d\'Epworth est &eacute;valu&eacute; &agrave; 9/21.Le score de Mallampati est de 3 /4.Son perimetre cervical est &agrave; 37cm;son perimetre abdominal est &agrave; 104 cm.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Nous allons enseigner &agrave; Mme Adolphe &agrave; remplir un agenda de sommeil et lui pratiquer une EFR et une polygraphie nocturne dont les r&eacute;sultats te seront communiqu&eacute;s.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(531,640,'2013-10-31','Dr Wan Hoi\r\nDr Dupuis','<p>Cher Robert</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour avis M. RIVIERE Marie Alice, n&eacute; le 22/05/1943.</p>\r\n<p>Elle pr&eacute;sente une toux depuis jeudi derni&egrave;re avec fi&egrave;vre &agrave; 40.</p>\r\n<p>elle a eu une expectoration sale;elle n\'a pas &eacute;t&eacute; vaccin&eacute; contre la grippe ni le pneumo23.</p>\r\n<p>Cette dame vit seule et a une fille de 46 ans.il s\'agit d\'une ancienne aide soignante de bloc op&eacute;ratoire.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une peritonite appendiculaire,une occlusion intestinale,une c&eacute;sarienne ,un kyste de l\'ovaire une hysterectomie une amygdalectomie ,une hernie discale ;</p>\r\n<p>Elle est trait&eacute; pour HTA et un prediab&egrave;te.Elle est allergique &agrave; la penicilline.</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>je lui prescrit des a&eacute;rosols (BRICANYL-ATROVENT) x 3 ou X 2 si tachycardie avec PULMICORT X 2/j associ&eacute; &agrave; une kin&eacute;siettt respiratoire X 1/jour.</p>\r\n<p>L\'antibioth&eacute;rapie est &agrave; poursuivre et je la reverrai la semaine prochaine.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher Robert , l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(532,115,'2013-10-31','Dr Marc AZZOLIN','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai revu ce jour M.GASNIER Yannis Joel n&eacute; le 01/05/1977.</p>\r\n<p>Il a repris la marche et le tennis et a perdu 5 kilos.Il s\'est bien adapt&eacute; &agrave; l\'appareil de PPc qu\'il garde entre 2 et 4 heures.</p>\r\n<p>Le TSH est &agrave; 1.564 avec T4 normal.La glyc&eacute;mie est &agrave; 5.6 mmol/L. HbA11C normal.Cholesterol et ac.Urique limite sup&eacute;rieur.</p>\r\n<p>l\'auscultation pulmonaire\" est ce jour dans les limites de la normale.</p>\r\n<p>je lui conseille de faire des abdominaux .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(533,426,'2013-11-04','Dr Vally','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme PAPAYA Jocelyne n&eacute;e le 03/11/1951.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; dans la nuit du 28 au 29/10/2013 d\'une polygraphie ventilatoire qui a retrouv&eacute; un index d\'apn&eacute;es-hypopn&eacute;es de 2/heure.cet index passe &agrave; 21/heure quand on y associe les &eacute;v&egrave;nements(diminutions).</p>\r\n<p>On note 2 d&eacute;saturations par heure avec &nbsp;une moyenne de 93% et une minimale de 89%.</p>\r\n<p>Il existe 2 mouvements p&eacute;riodiques des jambes par heure.</p>\r\n<p>En revanche 116 ronflements par heure ont &eacute;t&eacute; identifi&eacute;s avec une energie moyenne de 87db ce qui correspond &agrave; un ronflement important.</p>\r\n<p>Pour l\'instant il n\'y a pas d\'appareillage &agrave; proposer.</p>\r\n<p>Je demande &agrave; Mme Papaya de prendre MIFLONIL 1BX2 avec rin&ccedil;age de la bouche et faire controler sa tension intraoculaire en janvier.eventuellement on pourra lui proposer une polysomnographie.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p><span style=\"font-size: 11px;\">&nbsp;</span></p>'),(534,357,'2013-11-04','Dr Vally','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. PAPAYA NARASSOUMOULOUNAID Germain n&eacute; le 26/06/1945.</p>\r\n<p>Son IMC est de 27K/m2 et son index d\'Epworth de 15/21.Le score de Mallampati est de 2/4.</p>\r\n<p>Il existe un l&eacute;ger retrognatisme.</p>\r\n<p>Ses EFR montraient un trouble ventilatoire restrictif mod&eacute;r&eacute; avec CPT &agrave; 77% VR &agrave; 74% .Le Vems &eacute;tait &agrave; 2.28 soit 85%&nbsp;</p>\r\n<p>Il existe des troubles mod&eacute;r&eacute;s du transfert avec un TLCO &agrave; 72% de la norme.</p>\r\n<p>M.Papaya a b&eacute;n&eacute;fici&eacute; dans la nuit du 28/10 au 29/10/2013 d\'une polygaphie nocturne.Cet examen retrouve un index d\'apn&eacute;es-hypopn&eacute;es de 5/heure.Cet index passe &agrave; 7/H avec les &eacute;v&eacute;nements obstructifs et &agrave; 33/heure quand on y ajoute les &eacute;v&eacute;nementsd obstructifs avec indicateurs non corticaux.dans ces conditions nous allons reprendre M.Papaya pour cette fois ci une polysomnographie le 19/11/3013 &agrave; 17Heure.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(535,601,'2013-11-04','Dr Wan Hoi\r\nDr Ledig\r\nSOS Oxygène','<p>Cher Robert</p>\r\n<p>Je te remercie de m\'avoir adress&eacute; pour enregistrement polygraphique du sommeil M. AMOUNY Georges Michel, n&eacute; le 04/02/1959.</p>\r\n<p>Cet examen a &eacute;t&eacute; r&eacute;alis&eacute; dans la nuit du 5 au 6/11/2013 sur une dur&eacute;e valid&eacute;e de 8H23min.</p>\r\n<p>M.amouny pr&eacute;sente une IMC de 29./K/m2 et 2 nyctiuries.Il pr&eacute;sente en outre un syndrome metabolique avec un DNID,une HTA,une insuffisance coronarienne.Il a &eacute;t&eacute; stent&eacute;.</p>\r\n<p>Son Score d\'Epworth est &agrave; 6/21 avec un&nbsp;&nbsp;score de Mallampati est de 2 /4.</p>\r\n<p>Son perimetre cervical est de 40cm avec un perimetre abdominal de 100cm.</p>\r\n<p>On note un Index d\'Apn&eacute;es-hypopn&eacute;es(IAH) de 36/heure avec un iAH et &eacute;v&egrave;nements de 51/heure.</p>\r\n<p>55 d&eacute;saturations ont &eacute;t&eacute; recens&eacute;es par heure avec une SaO2 minimale de 70%.</p>\r\n<p>181 ronflements/H on &eacute;t&eacute; not&eacute;s avec une energie moyenne de 85db.</p>\r\n<p>M.Amouny pr&eacute;sente donc un syndrome d\'apn&eacute;es de sommeil n&eacute;cessitant un appareillage en pression positive continue.Il sera appareill&eacute; par la soci&eacute;t&eacute; SOS Oxyg&egrave;ne en mode autopilot&eacute;e avec une pression entre 5 et 15 cm d\'eau.</p>\r\n<p>Avec mes remerciements, je te prie d\'agr&eacute;er, cher Robert, l\'assurance de mes sentiments amicaux,</p>\r\n<p>Dr. Bernard TANGUY</p>\r\n<p>&nbsp;</p>'),(536,640,'2013-11-04','Dr Wan Hoi','<p>Cher Robert</p>\r\n<p>je revois ce jour Mme RIVIERE Marie Alice n&eacute;e le 22/05/1943.</p>\r\n<p>Elle a continu&eacute; &agrave; faire de la fi&egrave;vre ce week end.Elle a eu une radiographie thoracique ce jour.cet examen n\'a pas de foyer pneumonique ni d\'&eacute;panchement pleural.Elle pr&eacute;sente une symptomatologie de reflux gastro oesophagien &agrave; traiter par Inexium 40 mg m et s avec Gaviscon 1X3 pendant 3 mois.</p>\r\n<p>j\'ajoute de la PYOSTACINE 500mg 2cpX3 pdt 10jrs.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher Robert, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(537,661,'2013-11-04','Dr Jaglale-Letniowski','<p>Cher Consoeur</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. CHADUC sandra, n&eacute; le 02/09/1981.</p>\r\n<p>Cett</p>\r\n<p>e vous remercie de m\'avoir adress&eacute; pour avis M. CHADUC sandra, n&eacute; le 02/09/1981.</p>\r\n<p>Cette dame mari&eacute; un enfant est non fumeuse.</p>\r\n<p>Elle travaillait &agrave; l\'a&eacute;roport de Saint Denis.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une intervention neurochirurgicale par le Dr Leriche d\'un astrocytome.elle a aussi &eacute;t&eacute; op&eacute;r&eacute;e des ovaires(Kyste et &eacute;panchement ovarien).</p>\r\n<p>Elle est trait&eacute;e pour une fibromyalgie.l\'IRM a d&eacute;c&egrave;l&eacute;e une microd&eacute;chirure discale L5-S1 en 2012.</p>\r\n<p>elle pr&eacute;sente de plus une allergie au PRIMPERAN et une intol&eacute;rance au TRAMADOL et au ZITHROMAX.</p>\r\n<p>La semaine derni&egrave;re Mme CHADUC a &eacute;t&eacute; hospitalis&eacute;e en Neurologie pour un AVC isch&eacute;mique avec dysarthrie r&eacute;gressive .Le bilan &eacute;tiologique est en cours.</p>\r\n<p>Mme Chaduc ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Chaque fois qu\'elle est soumise &agrave; la climatisation elle pr&eacute;sente un wheezing avec g&egrave;ne laryng&eacute;e.</p>\r\n<p>Elle prestente une expectoration matinale blanchatre.</p>\r\n<p>L\'auscultation pulmonaire retrouve des sibilnces dans les deux champs pulmonaires.</p>\r\n<p>Elle m\'apportera sa R Th et un dosage &nbsp;d\'IgE totales ,RAST aux pneumallerg&egrave;nes &nbsp;et aux Trophallerg&egrave;nes avec NFS -Plqt.</p>\r\n<p>je lui propose de pratiquer une EFR et un traitement par SYMBICORT 400 1B X2 avec rin&ccedil;age de la bouche .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>e dame mari&eacute; un enfant est non fumeuse.</p>\r\n<p>Elle travaillait &agrave; l\'a&eacute;roport de Saint Denis.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une intervention neurochirurgicale par le Dr Leriche d\'un astrocytome.elle a aussi &eacute;t&eacute; op&eacute;r&eacute;e des ovaires(Kyste et &eacute;panchement ovarien).</p>\r\n<p>Elle est trait&eacute;e pour une fibromyalgie.l\'IRM a d&eacute;c&egrave;l&eacute;e une microd&eacute;chirure discale L5-S1 en 2012.</p>\r\n<p>elle pr&eacute;sente de plus une allergie au PRIMPERAN et une intol&eacute;rance au TRAMADOL et au ZITHROMAX.</p>\r\n<p>La semaine derni&egrave;re Mme CHADUC a &eacute;t&eacute; hospitalis&eacute;e en Neurologie pour un AVC isch&eacute;mique avec dysarthrie r&eacute;gressive .Le bilan &eacute;tiologique est en cours.</p>\r\n<p>Mme Chaduc ne pr&eacute;sente pas d\'ant&eacute;c&egrave;dent familial d\'asthme.</p>\r\n<p>Chaque fois qu\'elle est soumise &agrave; la climatisation elle pr&eacute;sente un wheezing avec g&egrave;ne laryng&eacute;e.</p>\r\n<p>Elle prestente une expectoration matinale blanchatre.</p>\r\n<p>L\'auscultation pulmonaire retrouve des sibilnces dans les deux champs pulmonaires.</p>\r\n<p>Elle m\'apportera sa R Th et un dosage &nbsp;d\'IgE totales ,RAST aux pneumallerg&egrave;nes &nbsp;et aux Trophallerg&egrave;nes avec NFS -Plqt.</p>\r\n<p>je lui propose de pratiquer une EFR et un traitement par SYMBICORT 400 1B X2 avec rin&ccedil;age de la bouche .</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(538,613,'2013-11-04','','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme RAZEFARSON Sandra n&eacute;e le 12/01/1980.</p>\r\n<p>le traitement lui a &eacute;t&eacute; tr&egrave;s profitable.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire restrictif avec CPT &agrave; 67% de la norme.Le VEMS est &agrave; 1.47 soit 52% avec un Tiffeneau &agrave; 100% de la norme.il existe une dimunition de la TLCO &agrave; 63%.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(539,293,'2013-11-04','Dr Moreau\r\nSeprodom','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. VALERY Lucas n&eacute; le 23/06/1940.</p>\r\n<p>Il est toujours dyspn&eacute;ique &agrave; la marche.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour &nbsp;une diminution des bruits pulmonaires stethacoustiques.</p>\r\n<p>je lui prescrit des a&eacute;rosol (Bricanyl-Atrovent)x2/j en plus de Onbrez 300/j Spiriva Respimat X2/j et kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(540,405,'2013-11-04','',''),(541,610,'2013-11-04','Dr Goulam Abasse\r\nDr Mascarel','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis M. MADI Djoumoi, n&eacute; le 01/01/1930 qui est trait&eacute; pour tuberculose pulmonaire depuis 6 mois &agrave; Mayotte.Ce patient est &agrave; la R&eacute;union depuis le 1/10/2013.</p>\r\n<p>La VS est &agrave; 9mm &agrave; 1&egrave;re heure et la CRP &agrave; 11mg/l.</p>\r\n<p>Le bilan hepato r&eacute;nal est satisfaisant avec Creatinine &agrave; 64microlol/l et une clairance calcul&eacute;e MDRD &agrave; 103.6ml/mn.La bilirubine est &agrave; 7.1micromol/L avec des SGOT &agrave; 24 et des SGPT &agrave; moins 6UI/L.</p>\r\n<p>L\'Hb est &agrave; 13.7g/dlm.</p>\r\n<p>en revanche l\'electrophor&egrave;se des protides retrouve une hypoalbumin&eacute;mie &agrave; 31.5g/l associ&eacute; &agrave; une hypergammaglobulin&eacute;mie &agrave; 29.3%.</p>\r\n<p>Malheureusement la famille ne dispose que de radiographie osseuses.je l\'adresse donc ce jeudi au Dr mascarel &agrave; la Clinique saint Vincent pour un TDM thoracique avec &nbsp;injection et je reverrai ce patient la semaine prochaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(542,390,'2013-11-04','Dr I.Patel','<p>Cher ami</p>\r\n<p>J\'ai vu ce jour Mme VELNA Mathilde M France n&eacute;e le 30/01/1939.</p>\r\n<p>Ses EFR sont dans les limites de la normale.</p>\r\n<p>Sous traitement le RGO a compl&egrave;tement regress&eacute;.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(543,524,'2013-11-04','Dr Corouge','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. CLAIN Georges Jean Marc n&eacute; le 23/11/1957.</p>\r\n<p>Son perimetre cervical est de 42cm avec un perimetre abdominal de 118cm.</p>\r\n<p>Le score de Mallampati est de 3 /4.Le Score d\'Epworth est difficile &agrave; calculer mais le patient d&eacute;crit un retard de phase de sommeil.il se couche entre 0.30 et 2:30 du matin et se l&egrave;ve entre 12:30 et 13:00.</p>\r\n<p>Il pr&eacute;sente entre 2 et 4 nyctiuries.Nous allons lui enseigner &agrave; remplir un agenda de sommeil ;</p>\r\n<p>Il&nbsp;poursuivra: Onbrez 300/j;Spiriva Respimat 2B/j et Pulmicort40 1BX2/j associ&eacute; &agrave; kin&eacute;siettt respiratoire :technique de ventilation dirig&eacute;e et musculation des abdominaux.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(544,60,'2013-11-04','Dr Laurent Grandpré\r\nSOS Oxygène','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. SERGE Jean Marcellin n&eacute; le 30/05/1959.</p>\r\n<p>Il se l&egrave;ve 4 &agrave; 5 fois dans la nuit pour &eacute;teindre l\'appareil en raison des fuites.Le patient se rend compte que l\'appareillage n\'est pas efficace.</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour une<strong>&nbsp;polysomnographie</strong>&nbsp;M. SERGE Jean Marcellin, n&eacute; le 30/05/1959.</p>\r\n<p>Ce patient pr&eacute;sente un poids de 70 kilos pour une taille de 1m57 soit une BMI de 28,4 ce qui correspond &agrave; un surpoids.</p>\r\n<p>M.SERGE exerce la profession d\'&eacute;lectricien. Il est non fumeur.</p>\r\n<p>Ses EFR sont dans les limites de la normale.</p>\r\n<p>Son Score d\'Epworth est de 18/24.</p>\r\n<p>Son Score de Mallampati est &agrave; 3.</p>\r\n<p>Il pr&eacute;sente un ronflement intense.</p>\r\n<p>L\'analyse de son&nbsp;<strong>agenda de sommeil&nbsp;</strong>retrouve une bonne efficacit&eacute; de sommeil (a savoir le temps pass&eacute; au lit par rapport &nbsp;au temps dormi). On note en moyenne 7 heures de sommeil avec absence de difficult&eacute; d\'endormissement. Il y a peu de reveil nocturne, sauf perturbation par les enfants.</p>\r\n<p><strong><em>Analyse de&nbsp;</em>la&nbsp;polysomnographie :</strong></p>\r\n<p><strong>&nbsp; Analyse du ronflement</strong>: On note 1397 ronflements, soit 193 par heure avec une energie de 91dB.</p>\r\n<p>&nbsp;&nbsp;<strong>Analyse du sommeil</strong>: est comparable &agrave; celle de l\'agenda de sommeil mais retrouve de nombreux micro-&eacute;veils: 82 soit 12/heure. 46 de ces micro&eacute;veils durent plus de 30 secondes et on note une dur&eacute;e totale de 86 minutes de micro-&eacute;veils.</p>\r\n<p><strong>&nbsp; Analyse des mouvements periodiques de jambes</strong></p>\r\n<p>On note 5 MPJ, soit 1 par heure.</p>\r\n<p>&nbsp;&nbsp;<strong>Analyse des &eacute;venements respiratoires :</strong></p>\r\n<p>Ils totalisent 59 Apn&eacute;es &nbsp;soit 9/heure. On note 55 &eacute;venements obstructives, une centrale et 0 Mixtes.</p>\r\n<p>S\'y associent: 160 hypopn&eacute;es,soit 24/heure. 120 hypopn&eacute;es s\'accompagnent de d&eacute;saturation et 2 de micro&eacute;veils. Le patient passe 32% de son sommeil en d&eacute;saturation.</p>\r\n<p>Au total<strong>&nbsp;l\'Index d\'apn&eacute;es-hypopn&eacute;es est de 32/heure</strong>&nbsp;ce qui justifie l\'appareillage du patient en auto-pilot&eacute;e de 4 &agrave; 14 cm d\'H2O par la Soci&eacute;t&eacute; SOS-Oxyg&egrave;ne.</p>\r\n<p>Revu le 16/09/2013: Patient moins somnolent ce jour depuis qu\'il a &eacute;t&eacute; appareill&eacute; il y a 2 semaines.Nous sommes en attente du dossier d\'observance de SOS Oxyg&egrave;ne.</p>\r\n<p>Nez toujours bouch&eacute;.Patient pr&eacute;sentant une classe 3 vis &agrave; vis des acariens et insectes.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, chers Confr&egrave;res, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(545,182,'2013-11-05','Dr Moussa','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour Mme SIDAT Khateejan n&eacute;e le 24/11/1948.</p>\r\n<p>Elle ressent une opression thoracique depuis deux semaines avec des &eacute;ternuements.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour quelques ronchi avec un l&eacute;ger freinage expiratoire.</p>\r\n<p>Je lui prescrit ce jour une radiographie pulmonaire.</p>\r\n<p>Je lui prescrit ELUDRIL gargarisme m et s pendant 10jours,Foradil 1BX2 avec Miflonil 1BX2 avec rin&ccedil;age de la bouche &agrave; l\'eau ,Singulair 10mg 1 cp le s et XOLAIR 300mg 1 fois par mois ,RHINOTROPHYL 1 pulv:X3/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(546,399,'2013-11-05','Dr Michèle LE BIDAN','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme LOUISE Raymonde n&eacute;e le 20/04/1946.</p>\r\n<p>Sa radiographie thoracique retrouve un abaissement des coupoles diaphragmatiques avec de grosses art&egrave;res pulmonaires.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec un VEMS &agrave; 0.47 soit 34&ugrave; de la norme.Le Tiffeneau est &agrave; 59% de la norme.Il existe une distension pulmonaire s&eacute;v&egrave;re avec VGT &agrave; 171% CPT &agrave; 124% et VR &agrave; 207% de la norme.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.83 et il existe un trouble mod&eacute;r&eacute; du transfert avec TLCO &agrave; 73% de la norme.</p>\r\n<p>il convient que tous les ans au mois de mai Mme LOUISE se vaccine contre la grippe et tous les cinq ans par le Pneumo 23 contre le pneumocoque.</p>\r\n<p>Sur le plan th&eacute;rapeutique il convient de poursuivre l\'OLD,l\'a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X3/j;onbrez 300/j;Spiriva-Respimat 2B/j;Kin&eacute;siettt Respiratoire 20 s&eacute;ances/mois au domicile de la malade.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(547,414,'2013-11-05','Dr RAY','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour M. LEVENEUR Jean Baptiste n&eacute; le 22/06/1931.</p>\r\n<p>Ce patient va mieux et a tir&eacute; b&eacute;n&eacute;fice du traitement.</p>\r\n<p>l\'auscultation pulmonaire retrouve ce jour quelques ronchi dans les deux champs pulmonaires.</p>\r\n<p>Il convient de poursuivre le meme traitement en passant &agrave; Onbrez 300 microg/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(548,30,'2013-11-05','Dr Goulam Abasse','<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme GOULAM HOUSSEN Kaniza n&eacute;e le 12/12/1930.</p>\r\n<p>Cette dame va mieux ,elle n\'est plus fi&egrave;vreuse et respire mieux.</p>\r\n<p>L\'auscultation pulmonaire est redevenue normale.</p>\r\n<p>Mme &nbsp;Goulam houssen poursuivra:a&eacute;rosolth&eacute;rapie:Bricanyl-AtroventX2 associ&eacute; &agrave; PulmicortX2 avec rin&ccedil;age de la bouche.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(549,664,'2013-11-05','Dr Goulam Abasse\r\nPhcie cheung leung','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ABDOUL RASSUL Myl&egrave;ne n&eacute;e le 22/07/1989.</p>\r\n<p>Elle pr&eacute;sente une toux s&eacute;che de nature laryng&eacute;e &nbsp;depuis un mois.Cette toux est parfois &eacute;m&eacute;tisante.</p>\r\n<p>elle n\'est pas fumeuse mais vit avec sa m&egrave;re qui est fumeuse.</p>\r\n<p>sa petite soeur est asthmatique.</p>\r\n<p>Mme Abdoul rassul est mari&eacute; et a un enfant.</p>\r\n<p>Il n\'existe de symptomatologie franche de RGO mais cette peut etre absente.</p>\r\n<p>Nous allons programmer une EFR le 12/11/2013 &agrave; 9:00.</p>\r\n<p>3 diagnostics meritent d\'etre explor&eacute;s devant une toux chronique:la rhinorrh&eacute;e post&eacute;rieure,l\'asthme et le reflux gastro-oesophagien.</p>\r\n<p>Nous allons demarrer un traitement ant-inflammatoire avec Pulmicortx2 en a&eacute;rosolth&eacute;rapie avec rin&ccedil;age de la bouche &agrave; l\'eau et je reverrai Mme abdoul pour adapter son traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(550,413,'2013-11-05','Dr Omarjee','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. SANS Julien n&eacute; le 24/07/1949.</p>\r\n<p>Son EFR retrouve une spirographie dans les limites de la normale.Le VEMS est &agrave; 2.36 soit 96% de la norme.Le Tiffeneau est &agrave; 86%.Il existe une distension pulmonaire avec des resistances des voies a&eacute;riennes &agrave; 1.03 &nbsp;sans trouble du transfert.</p>\r\n<p>Sa radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>le patient continue &agrave; cracher sale le matin.</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les li&ugrave;mites de la normale.</p>\r\n<p>Je pense que l\'origine est ORL et je lui prescrit de l\'ELUDRIL gargatrisme m ets pendant 10jours. , RHINOTROPHYL 1pulv dans chq narine 3 fois /j ;ikl poursuivra FORADIL etb MIFLONIL.</p>\r\n<p>Les IgE totales sont &agrave; 614 UI/ml.Les RAST n<span style=\"font-size: 11px;\">e d&eacute;c&egrave;lent qu\'un taux relativement faible d\'allergie Classe 1 ou 2 aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(551,26,'2013-11-05','Dr Pierron','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GAUTHIER Denise n&eacute; le 16/11/1932.</p>\r\n<p>Sa radiographie thoracique retrouve un d&eacute;roulement de la ligne para aortique gauche .je lui prescrit un scanner thoracique sans injection.La NFS et la CRP sont dans les limites de la normale.Je lui conseille FLODIL LP 5mg /j .</p>\r\n<p>Je lui demande de faire un regime sans sel et de faire attention &agrave; sa TA.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(552,472,'2013-11-05','Dr Le Bihan','<p>Cher Consoeur,</p>\r\n<p>J\'ai vu ce jour M. HOARAU Antoine n&eacute; le 07/08/1937.</p>\r\n<p>Ce malade va mieux mais refuse la kin&eacute;siettt respiratoire.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour une diminution des bruits pulmonaires stethacoustiques.Il convient de poursuivre chez lui :Onbrez 300/j spiriva Respimat 2b/j et Pulmicort 400 1Bx2 avec rin&ccedil;age de la bouche &agrave; l\'eau.</p>\r\n<p>Il aura son PET Scan jeudi.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(553,188,'2013-11-05','Dr Courchinoux','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme HASSANALY Samina n&eacute;e le 29/03/1959.</p>\r\n<p>Elle est dyspn&eacute;ique &agrave; l\'effort &agrave; la mont&eacute;e du 3&egrave; &eacute;tage.</p>\r\n<p>Elle a arret&eacute; le Spiriva qu\'elle ne supporte pas.</p>\r\n<p>L\'auscultation pulmonaire retrouve ce jour des ronchi dans les deux champs pulmonaires .</p>\r\n<p>Zithromax 250 mgX3/semaine, FORADIL, SPIRIVA RESPIMAT VENTOLINE et kinesiettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(554,189,'2013-11-05','Dr Goulam Abasse\r\nDr Mascarel','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. HASSANALY Rossanaly n&eacute; le 25/10/1938.</p>\r\n<p>Il fait du velo 30mins tous les jours et marche 1heure /jour.</p>\r\n<p>Toutefois il sent une aggravation de sa dyspn&eacute;e.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III, de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>L\'auscultation pulmonaire retyrouve des ronchi et des sibilances dans les deux champs pulmonaires.</p>\r\n<p>Le patient prendra a&eacute;rosolth&eacute;rapie (Bricanyl-atrovent)X3 avec Pulmicort X2 avec rin&ccedil;age de la bouche et &nbsp;onbrez 300/j Spiriva Respimat 2B/j ainsi que kin&eacute;siettt respiratoire X2/semaine.</p>\r\n<p>M.Hassanaly aura un TDM thoracique sans injection le 23/01/2014 pour surveiller le petit relief endo bronchique de la BLID.</p>\r\n<p><span style=\"font-size: 11px;\">Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</span></p>\r\n<p>Dr. B. TANGUY</p>'),(555,278,'2013-11-05','Dr Dhunnoo','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BADOURALY DILAVARHOUSSEN n&eacute; le 23/05/1941.</p>\r\n<p>Ses EFR motrent un trouble ventilatoire restrictif en am&eacute;lioratibn par rapport au 30/07/2013.</p>\r\n<p>La CPT est pass&eacute; de 57 &agrave; 64% de la norme.Le VR est pass&eacute; de 65% &agrave; 79% de la norme.Le VEMS est stable &agrave; 1.35 soit 51%.On note &eacute;galement une am&eacute;lioration des troubles du transfert qui sont pass&eacute;s de 31% &agrave; 49% de la norme.</p>\r\n<p><span style=\"font-size: 11px;\">&nbsp;</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(556,176,'2013-11-06','Dr LEVEQUE','<p>Cher Confrere,</p>\r\n<p>J\'ai vu ce jour Mme ALIDINA Rosemine n&eacute;e le 04/05/1960.</p>\r\n<p>Son &eacute;tat s\'est amelior&eacute; et l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Sa radiographie thoracique retrouve une distension thoracique avec aplatissement des coupoles diaphragmatiques et accentuation de la trame vasculaire.</p>\r\n<p>De plus elle pr&eacute;sente une irritation laryng&eacute; probablement d\'origine allergique .Nous demansdons ce jour un dosage des IgE totales et des RASt aux aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Elle poursuivra le meme traitement :</p>\r\n<p>Symbicort 1BX2 rincage; Spiriva Respimat 2B;kin&eacute;sieth&eacute;rapie respiratoire 3 s&eacute;ances / semaine pendant 1 moi</p>\r\n<p>associ&eacute; &agrave; ELUDRIL gargarisme X2/j 10jrs/mois et RHINOTROPHYL 1pulv:X3/j dans chq narine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(557,430,'2013-11-06','Pr M.Alifano\r\nService de chirurgie Thoracique\r\nHopital Cochin\r\n27,Rue de Faubourg Saint Jacques,\r\n75014,PARIS.','<p>Monsieur,</p>\r\n<p>Je vous adresse pour avis le dossier de&nbsp;Mme BOYER Marie Anise n&eacute;e le 13/06/1966.Cette dame mari&eacute;e, 3 enfants n\'a jamais fum&eacute;.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note : une appendicectomie, une c&eacute;sarienne, une cholecystectomie.En 2006 il lui a &eacute;t&eacute; d&eacute;couvert un goitre.</p>\r\n<p>Histoire de la maladie: Mme Boyer a pr&eacute;sent&eacute; une coqueluche &agrave; l\'age de deux ans et a conserv&eacute; une DDB bilat&eacute;rale.</p>\r\n<p>Elle a &eacute;t&eacute; hospitalis&eacute;e en novembre 2011 pour DDB.Sa SaO2 est de 98%.</p>\r\n<p>Elle pr&eacute;sente une toux avec expectoration visqueuse et abondante;</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade IV de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>L\'auscultation retrouve un freinage expiratoire avec sibilances dans les 2 champs pulmonaires.</p>\r\n<p>Je vous adresse le CD de son scanner thoracique du 31/10/2013 ainsi que ses EFR en date du 24/10/2013.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire Mixte avec CPT &agrave; 70% de la norme.Le VEMS est &agrave; 0.83 soit 31% de la norme ,t&eacute;moignant d\'une composante obstructive Gold III/IV s&eacute;v&egrave;re &agrave; tr&egrave;s s&eacute;v&egrave;re.Il existe des signes de distension pulmonaire avec VR &agrave; 126%.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 1.54.</p>\r\n<p>J\'y joins une copie de ses derniers pr&eacute;l&egrave;vements d\'expectoration qui ont montr&eacute; d\'assez nombreux cocci Gram + ;quelques bacilles gram n&eacute;gatifs et une flore polybacterienne commensale.</p>\r\n<p>Pensez vous qu\' une possibilit&eacute; chirurgicale peut etre envisag&eacute;e peut &nbsp;dans son cas.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, Monsieur, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(558,68,'2013-11-06','Dr Imbert','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ANGAMA Adrienne n&eacute; le 04/03/1952 qui a b&eacute;n&eacute;fici&eacute; d\'EFR.</p>\r\n<p>Cet examen retrouve un trouble ventilatoire mixte mod&eacute;r&eacute; ;la CPT est &agrave; 73% de la norme;le VEMS est &agrave; 1.53 soit 59% avec un Tiffeneau &agrave; 87% de lma norme.Sous b2inhal&eacute;s le VEMS passe &agrave; 1.77 soit une augmentation de 16%,ce qui traduit une bronchor&eacute;activit&eacute;.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.87 et il n\'existe pas de trouble du transfert.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(559,654,'2013-11-06','Dr AKBARALY Moise\r\nDr Gojon -ORL.','<p>Cher Confr&egrave;re</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis l\'enfant DALLEAU Orane, n&eacute; le 02/07/2005.</p>\r\n<p>Cet enfant a des ant&eacute;c&egrave;dents familiaux d\'asthme du cote de son p&egrave;re.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une bthallass&eacute;mie h&eacute;t&eacute;rozygote,une otite en mars 2008.elle est allergique &agrave; la penicilline.</p>\r\n<p>Elle pr&eacute;sente 2 &agrave; 3 &eacute;pisodes infectieuses par an suivies de manifestations asthmatiques .</p>\r\n<p>L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>la radiographie thoracique note un l&eacute;ger &eacute;^paississement des parois bronchiques sans l&eacute;sion parenchymateuses&nbsp;</p>\r\n<p>pulmonaires &eacute;volutives.Nous lui pratiquerons une EFR le 12/11/2013 &agrave; 10:00.</p>\r\n<p>Je demande un dosage d\'IgE totales avec RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Je lui mets pour l\'instant souis SINGULAIR 5mg le soir au coucher.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(560,46,'2013-11-06','Dr Azzolin','<p>J\'ai revu ce jour en consultation Mme ECLAPIER Marie Suzette n&eacute;e le 04/04/1939</p>\r\n<p>Cette dame mari&eacute;e 10 enfants ne pr&eacute;sente pas d\'ant&eacute;c&eacute;dents m&eacute;dico-chirurgicaux notable &agrave; part d\'un tremblement essentiel suivi par le Dr Dandelot &agrave; l\'&eacute;poque.</p>\r\n<p>Histoire de la Maladie: Mme Eclapier a &eacute;t&eacute; hospitalis&eacute;e le 23/12/2012 pour une dyspn&eacute;e aigue au CHGM.&nbsp;</p>\r\n<p>Actuellement elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du modified Medical Research Council avec sous traitement r&eacute;gression de la toux et de l\'expectoration.</p>\r\n<p>La Sao2 est &agrave; 93% et le pouls &agrave; 98.La TA est &agrave; 13/9</p>\r\n<p>L\'auscultation pulmonaire retrouve des ronchi dans les 2 champs pulmonaires.</p>\r\n<p>L\'EFR a montr&eacute; un Trouble Ventilatoire Obstructif Gold II avec distension pulmonaire: VGT &agrave; 126%,VR &agrave; 130% et augmentation de la r&eacute;sistance des voies a&eacute;riennes.</p>\r\n<p>La gazom&eacute;trie &agrave; AA montre: pH 7,41 pO2 61 Torr pCO2 48 Torr SaO2 90%.</p>\r\n<p>La radiographie thoracique retrouve des S.de distension thoracique avec aplatissement des coupoles diaphragmatiques, grosses A. pulmonaires et accentuation de la trame vasculaire dans les 23 champs pulmonaires. Il convient de poursuivre chez cette dame vaccination anti grippale tous les ans, pneumo 23 tous les 5 ans, OLD avec ISIS M&eacute;dical 2L/mn, Kin&eacute;sith&eacute;rapie respiratoire technique de ventilation Dirig&eacute;e tous les jours, A&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent) x 2/jour, et PulmicortX2/j avec rin&ccedil;age de la bouche &agrave; l\'eau.</p>\r\n<p>Je la reverrai en consultation le 06/11/2013.</p>\r\n<p>Veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de ma haute consid&eacute;ration.</p>\r\n<p>Dr B. TANGUY.</p>'),(561,190,'2013-11-06','Dr Duval','<p>Ch&egrave;re Consoeur</p>\r\n<p>J\'ai vu ce jour M. TEVANE Nicolas n&eacute; le 25/04/1924.</p>\r\n<p>La radiographie thoracique pratiqu&eacute; le 05/11/2013 ne retrouve pas d\'&eacute;panchement pleural et la ponction pleurale n\'a donc plus lieu d\'etre.</p>\r\n<p>En revanche le patient se plaint de douleurs testiculaires et scrotales qui le g&egrave;nent &eacute;norm&eacute;ment.L\'interrogatoire est tr&egrave;s difficile en raison de la surdit&eacute; profonde du patient.</p>\r\n<p>Je demande ce jour une NFS avec CRP .Je pense qu\'un examen urologique s\'impose.<span style=\"font-size: 11px;\"><br /></span></p>\r\n<p>En attendant il convient de poursuivre chez &nbsp;ce patient a&eacute;rosolth&eacute;rapie (Bricanyl-Atrovent)X2 ainsi que Onbrez 300 1B/j et kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGU</p>'),(562,570,'2013-11-06','Dr Guilbaud','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Enft DARAFY Loana n&eacute;e le 24/09/2007.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Le scanner des sinus maxillaires retrouve un minime &eacute;paississement muqueux .</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale.La plethysmographie montre des signes de distension pulmonaire avec VGT &agrave; 143% VR &agrave; 132%et augmentation de la resistance des voies a&eacute;riennes &agrave; 0.80.</p>\r\n<p>&nbsp;Sur le plan th&eacute;rapeutique je conseille :singulair 5 mg le s;seretide 50 2X2 avec rin&ccedil;age et Eludril gargarisme m et s 7jrs/mois.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(563,320,'2013-11-06','Dr Doussaud','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme THIAN MENG M Francine n&eacute;e le 21/10/1925.</p>\r\n<p>L\'echo doppler v des M.I. ne retrouve pas d\'image de thrombophl&eacute;bite .</p>\r\n<p>je lui prescrit de la kin&eacute;siettt respiratoire et de mobilisation</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(564,25,'2013-11-06','Dr Fun Yan Yuen','<p>Cher Confrere</p>\r\n<p>J\'ai vu ce jour M. RASOANANTENAINA Edwige n&eacute; le 19/02/1953.</p>\r\n<p>Cette dame est trait&eacute;e pour syndrome d\'apn&eacute;e de sommeil par PPC.Son observance est de 5H54 avec un IAH de 2.1 en date du 25/09/2013.l\'appareil est bien tol&eacute;r&eacute; par la patiente.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.elle pr&eacute;sente une rhinite allergique.</p>\r\n<p>Elle peut donc arreter le FORADIL et poursuivra singulair 10 mg 1 cp le soir et MIFLONIL 400 1Bx2 avec rin&ccedil;age de la bouche par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(565,505,'2013-11-06','Dr LEGROS','<p>Cher Consoeur,</p>\r\n<p>J\'ai vu ce jour Mme VIRGINIUS Diane Marie Beatrice n&eacute;e le 15/06/1974.</p>\r\n<p>Ses EFRretrouvent un trouble ventilatoire obstructif mod&eacute;r&eacute; Gold II avec un VEMS &agrave; 1.55 soit 65% de la norme passant &agrave; 1.6 soit 67% apr&egrave;s b2inhal&eacute;s.Il s\'y associe une distension pulmonaire avec VGT &agrave; 110% et VR &agrave; 157%.</p>\r\n<p>Il existe des troubles modf&eacute;r&eacute;s du transfert avec TLCO &agrave; 63% de la norme.</p>\r\n<p>Sur le plan biologique il n\'existe pas d\'hypereosinophilie.Les RAST aux pneumallerg&egrave;nes &nbsp;et trophallerg&egrave;nes sont normales.Les IgE totales sont normales &agrave; 38UI/ml.</p>\r\n<p>je demande cve jour un TDM thoracique sans injection et je rajoute au traitement du Spiriva Respimat 2B/j.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(566,637,'2013-11-06','Dr Chabas\r\nDr Vivier','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour l\'enfant PAYET Alexandre n&eacute; le 27/07/2007.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents familiaux on note un p&egrave;re allergique aux acariens ;</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une intervention des v&eacute;g&eacute;tations &agrave; l\'age de 18 mois.</p>\r\n<p>Il pr&eacute;sente un asthme &agrave; l\'effort et a &eacute;t&eacute; hospitalis&eacute; en 03/04/2013 pour une dyspn&eacute;e laryng&eacute;e avec SaO2 &agrave; 76%.</p>\r\n<p>L\'enfant Payet a eu un bilan allergologique qui retrouve des tests cutan&eacute;s positifs aux acariens.</p>\r\n<p>laz NFS retrouve une hypereosinophilie &agrave; 1.29G/L.</p>\r\n<p>L\'examen clinique retrouve des adenom&eacute;galies sous angulo maxillaires bilat&eacute;rales.</p>\r\n<p>Je demande un dosage d\'IgE totales avec une radiographie pulmonaire et je place Alexandre sous:</p>\r\n<p>ELUDRIL gargarisme m et s ;RHINOTROPHYL 1 pulv:ds chq narine X3/j avec Laroscorbine 1 cp eff le m.</p>\r\n<p>avec kin&eacute;siettt respiratoire X2/semaine .</p>\r\n<p>je le reverrai vendredi pour des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(567,628,'2013-11-06','Dr Sylvie GLORIEUX','<p>Cher Consoeur</p>\r\n<p>J\'ai vu ce jour M. BOULLEY Jean Claude n&eacute; le 16/02/1944.</p>\r\n<p>Son EFR retrouve :Spirographie dans les limites de la normale;Plethysmographie:Signes de distension pulmonaire :VGT 141% VR 146% de la normale.Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.38.</p>\r\n<p>Il n\'existe pas de trouble du transfert.</p>\r\n<p>Le TDM thoracique ne retrouve pas de l&eacute;sion pleuro pulmonaire mais il a &eacute;t&eacute; not&eacute; des lithiases v&eacute;siculaires &agrave; l\'&eacute;tage sous diaphragmatique.</p>\r\n<p>M.Boulley aura un enregistrement du sommeil le 12/11/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(568,282,'2013-11-06','Dr Jean SERGE\r\nISIS Médical','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. BELAIR paul n&eacute; le 06/02/1939.</p>\r\n<p>Ce patient a eu hier une gazom&eacute;trie au CHU F&eacute;lix Guyon dont je n\'ai pas encore eu les r&eacute;sultats.</p>\r\n<p>M.Belair va mieux et devra poursuivre le meme traitement.</p>\r\n<p>Actuellement 10 mg le matin en diminuant de 5 mg tous les deux jours en vue arret .Inexium 40 mg le soir avec Gaviscon 1X3;Onbrez 300/j Spiriva Respimat 2B/j;A&eacute;rosolth&eacute;rapie (bricanyl-Atrovent)X3 et PulmicortX2 avec rin&ccedil;age ;Kin&eacute;siettt respiratoire et VNI associ&eacute; &agrave; OLD.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(569,184,'2013-11-07','Dr Calichiama\r\nDr Vivier','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. THIONVILLE Mathieu Yannis n&eacute; le 01/01/1983.Ce patient b&eacute;n&eacute;ficie de l\'AAH pour retrard mental.</p>\r\n<p>Les IgE sp&eacute;cifiques aux acariens sont tr&egrave;s positifs &agrave; D.pteronyssinus 15.8 KUA/L ;&agrave;7.47KUA/L D.Farinae et &agrave; 5.29 KUA/L &agrave; B.Tropicalis.</p>\r\n<p>M.Thionville pr&amp;&eacute;sente une symptomatologie de RGO avec une possible rhinorrh&eacute;e post&eacute;rieure:nez bouch&eacute; et secretions .</p>\r\n<p>La kin&eacute;siettt respiratoire lui a fait du bien.&nbsp;L\'auscultation respiratoire est ce jour dans les limites de la normale.</p>\r\n<p>Poursuivre la kin&eacute;siettt respiratoire &nbsp;auquel de rajoute un ttt de rhinorrh&eacute;e postr en le revoyant dans 15 jrs pour faire le pt et prescrire &eacute;ventuellt 1 ttt anti reflux.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Avec mes remerciements, veillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(570,184,'2013-11-07','','<p>Je soussign&eacute; Dr Bernard TANGUY ,Pneumologue Agr&eacute;e,certifie que &nbsp;l\'&eacute;tat de sant&eacute; de&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>M.THIONVILLE Mathieu n&eacute; le 01/01/1983&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>n&eacute;cessite un environnement propre sans feuillage pouvant induire une humidit&eacute; ou une salet&eacute; quelconque.</p>\r\n<p>&nbsp;</p>\r\n<p>Fait &agrave; St Denis le 07/11/2013.</p>'),(571,331,'2013-11-07','Dr Eric BOURDAIS','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai revu ce jour M. CARPIN Jean Klebert n&eacute; le 10/07/1969.</p>\r\n<p>Il va mieux et pratique de la marche d&egrave;s qu\'il peut.</p>\r\n<p>L\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Il convient donsc de poursuivre l\'Onbrez 300 et kin&eacute;siettt respiratoire et je le reverrai en janvier 2014 pour des EFR.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(572,609,'2013-11-07','Dr Moshinaly\r\nDr Goulam Abasse\r\nDr Kichenin','<p>Cher Ami</p>\r\n<p>A la demande du Dr KICHENIN je t\'adresse &nbsp;Mme COJONDE Val&eacute;rie THEONIA n&eacute;e le 18/05/1928.</p>\r\n<p>Cette dame est en pouss&eacute;e d\'insuffisance cardiaque et sera hospitalis&eacute;e dans ton service jeudi 14/11/2013 &agrave; 14H30.</p>\r\n<p>Elle a revu hier le Dr christian KICHENIN qui a retrouv&eacute; une FEVG &agrave; 52%.L\'echocardiographie a par ailleurs retrouv&eacute; une grosse calcification de l\'anneau mitral avec IM grade 2.</p>\r\n<p>les pro-BNP est &agrave; 1902 pg/ml avec une glyc&eacute;mie &agrave; 1.99 mmol/l et une creatin&eacute;mie &agrave; 69 micromol/l.</p>\r\n<p>La patiente est sous cordarone et le Dr Kichenin l\'a mise sous LASILIX pour pouss&eacute;e d\'insuffisance cardiaque.</p>\r\n<p>La radiographie thoracique retrouve une cardiom&eacute;galie avec discr&egrave;te l&eacute;sion emphys&eacute;mateuse .</p>\r\n<p>L\'EFR montre une spirographie dans les limites de la normale avec une distension pulmonaire mod&eacute;r&eacute;e:VGT &agrave; 130% et VR &agrave; 116% de la normale.</p>\r\n<p>Je lui prescrit un ttt anti reflux RGO.</p>\r\n<p>Le Dr Kichenin souhaite une hospitalisation en cardiologie.</p>\r\n<p>Avec mes remerciements, veuilles agr&eacute;er, cher Ami, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(573,96,'2013-11-07','Dr Bonne','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme ROBERT Marie Monique n&eacute;e le 23/06/1946.</p>\r\n<p>Ses EFR retrouvent un trouble ventilatoire restrictif avec CPT &agrave; 56% avec VR &agrave; 62% .Le VEMS est &agrave; 1.45 soit 58% de la norme passant &agrave; 1.47 soit 59% sous b2inhal&eacute;s.Il existe un trouble du transfert avec TLCO &agrave; 57% de la norme.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(574,33,'2013-11-07','Dr Mareuil','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. ARIVE Jean Jimmy n&eacute; le 10/03/1968.</p>\r\n<p>Ce monsieur mari&eacute;,4 enfants a &eacute;t&eacute; menuisier et gardien et est actuellement sans profession.</p>\r\n<p>Il n\'a jamais fum&eacute; et dans ses ant&eacute;c&egrave;dents on note une appendicectomie et un epistaxis.</p>\r\n<p>Il a pr&eacute;sent&eacute; une hemoptysie l\'ann&eacute;e derni&egrave;re et a eu une fibroscopie bronchique qui n\'avait rien retrouv&eacute; de particulier.Le scanner avait &agrave; l\'&eacute;poque retrouv&eacute; des l&eacute;sions de verre d&eacute;poli.</p>\r\n<p>Actuellemenet l\'hemoptysie a regress&eacute;e.</p>\r\n<p>l\'auscultation pulmonaire est dans les limites de la normale ainsi que la radiographie thoracique.</p>\r\n<p>l\'EFR en date du 16/08/2013 &eacute;tait &eacute;galement dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>'),(575,471,'2013-11-07','Dr M.I. Bobate','<p>cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MALEK RASSOUL Fatma n&eacute;e le 25/09/1948.</p>\r\n<p>Le TDM thoracique pratiqu&eacute; le 24/10/2013 montre de discr&egrave;tes DDB lobaires sup&eacute;rieures gauches associ&eacute;es &agrave; un petit infiltrat sous pleural ant&eacute;rieur d\'allure s&eacute;quellaire.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>La patiente va mieux.L\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Son reflux gastro- oesophagien s\'est am&eacute;lior&eacute;.Son score d\'Epworth est &agrave; 9/24.</p>\r\n<p>Le score de Mallampati est de 1 /4.nous allons lui faire remplir un agenda de sommeil.Il lui sera fix&eacute; une polygraphie nocturne.</p>\r\n<p>Poursuivre la kin&eacute;siettt respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(576,618,'2013-11-07','Dr Akbaraly','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. IFANGOUSINE Jean Hugues n&eacute; le 16/05/1975.</p>\r\n<p>ses EFR montrent une spirographie dans les limites de la normale;la plethysmographie montre une distension pulmonaire avec VGT &agrave; 139% VR &agrave; 147% de la norme.Il existe un trouble mod&eacute;r&eacute; de la diffusion avec TLCO &agrave; 70% de la norme.</p>\r\n<p>La NFS montre une hypereosinophilie &agrave; 797/mm3.Les IgE totales sont augment&eacute;es &agrave; 639UI/ml.</p>\r\n<p>Les RAST retyrouvent une allergie classe 3 aux acariens &nbsp;/ insectes;une allergie classe 1 fraise,kiwi,et bananes.</p>\r\n<p>Sous le traitement instaur&eacute; le patient va nettement mieux.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(577,663,'2013-11-07','Dr Hubert de L\'Isle','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme. PEYOU Marie Ange n&eacute; le 04/01/1957.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents personnels on note une thyroidectomie et Mme PEYOU est sous LEVOTHYROX.</p>\r\n<p>elle aurait un diab&egrave;te mod&eacute;r&eacute; ainsi qu\'un adenome de l\'hypophyse.</p>\r\n<p>Mme Peyou est mari&eacute; et a 3 enfants.elle est femme au foyer.</p>\r\n<p>Elle a du mal &agrave; respirer avec des sibilances dans les deux champs pulmonaires depuis deux ans.</p>\r\n<p>Elle a &eacute;t&eacute; trait&eacute; par Cortisone orale et antibioth&eacute;rapie ainsi qu\'a&eacute;rosolth&eacute;rapie.</p>\r\n<p>L\'examen clinique retrouve un retrognatisme .l\'auscultation montre des sibilances et des ronchi dans les 2 champs pulmonaires.Son score d\'epworth est &agrave; 18/24.Nous allons lui faire remplir un agenda de sommeil.Elle pr&eacute;sente 3 nyctiuries et son sommeil est tr&egrave;s perturb&eacute;.</p>\r\n<p>Le score de Mallampati est de 2/4.le perimetre cervical est &agrave; 35cm avec un perimetre abdominal &agrave; 88cm.</p>\r\n<p>Je demande ce jour une radiographie pulmonaire et Mme Peyou aura une EFR le 13/11/2013 nous pr&eacute;voyons &eacute;galement une polygraphie nocturne;MmE PEYOU &nbsp;fera une NFS ,un dosage d\'IgE totales et des RAST aux pneumallerg&egrave;nes et aux trophallerg&egrave;nes.</p>\r\n<p>Sur le plan th&eacute;rapeutique je la place sous a&eacute;rosolth&eacute;rapie(Bricanyl-atrovent)X3/j associ&eacute; &agrave; PulmicortX2 avec rin&ccedil;age de la bouche &agrave; l\'eau.Symbicort400 1Bx2 avec rin&ccedil;age de la bouche.kin&eacute;siettt respiratoire X3/semaine.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(578,120,'2013-11-07','Dr Kapler\r\nSOS Oxygène','<p>Cher Confr&egrave;re,</p>\r\n<p>J\'ai vu ce jour M. ALEXIS Jean Claude n&eacute; le 12/12/1944.</p>\r\n<p>ce patient pr&eacute;sente un \'Overlap-syndrome\'associant une BPCO et un syndrome d\'apn&eacute;es de sommeil.</p>\r\n<p>de plus on peut parler de SOh syndrome d\'ob&eacute;sit&eacute; hypoventilation dans la mesure ou il existe une hypercapnie &agrave; 52Torr associ&eacute; &agrave; une ob&eacute;sit&eacute; avec un IMC de 31K/m2 soit une ob&eacute;sit&eacute; mod&eacute;r&eacute;.</p>\r\n<p>Il est de plus DID et HTA.</p>\r\n<p>Il a b&eacute;n&eacute;fici&eacute; d\'un enregistrement polygraphique nocturne dans la nuit du 26 au 27/09/2013.&nbsp;Le patient s\'est endormi &agrave; 22:15 et s\'est reveill&eacute; &agrave; 7:10. Il a eu 2 r&eacute;veils nocturnes &agrave; 1:00 et &agrave; 3:30.</p>\r\n<p>L\'IAH (Index Apn&eacute;e/Hypopn&eacute;e) s\'est revel&eacute; &ecirc;tre &agrave; 33 par heure, avec 43 apn&eacute;es, hypopn&eacute;es et evenements par heure. L\'examen a &eacute;t&eacute; effectu&eacute; sans oxyg&eacute;noth&eacute;rapie et le patient &agrave; pr&eacute;sent&eacute; 368 d&eacute;saturations, soit 44 d&eacute;saturations par heure de sommeil. On notait une saturation minimale a 61%, avec une saturation moyenne &agrave; 87%. A l\'eveil, la saturation est a 92%. Le capteur de son n\'&eacute;tait plus en place ce qui n\'a pas permis d\'authentifier les ronflements.</p>\r\n<p><span style=\"font-size: 11px;\">Ce patient a &eacute;t&eacute; appareill&eacute; dans un premier temps par PPC puis avec un BIPAP.Il ne supporte pas l\'appareil allong&eacute; mais le tolere en position assise.Je lui demande de l\'essayer dans un premier temps dans la journ&eacute;e puis je le reverrai dans un mois.</span></p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(579,140,'2013-11-07','','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. DIJOUX Guy Remy n&eacute; le 05/04/1958.</p>\r\n<p>Il se sent mieux en particulier &agrave; l\'effort.</p>\r\n<p>Ce monsieur a eu ce jour une EFR et la TLCO a &eacute;t&eacute; retrouv&eacute; &agrave; 85% soit en am&eacute;lioration par rapport au 13/09/2013 ou on avait not&eacute; une TLCO &agrave; 71% de la norme.</p>\r\n<p>nous pouvons donc arreter ce jour la cortici th&eacute;rapie tout en surveillant la TLCO le 6/12/2013.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(580,31,'2013-11-07','Dr Maigrat','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. GUICHARD Jean Pierre n&eacute; le 20/02/1949.</p>\r\n<p>Il ne supporte plus les a&eacute;rosols;il continuera le reste du traitement.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>Ce patient est un ancien fumeur sevr&eacute; depuis 1an.il totalise environ 22PA.</p>\r\n<p>Il est mari&eacute; 1 enfant.Il exercait la profession de manoeuvre macon.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une insuffisance h&eacute;patique post ethylique.</p>\r\n<p>Il pr&eacute;sente une dyspn&eacute;e grade III de l\'&eacute;chelle du Modified Research Council.</p>\r\n<p>La radiographie thoracique montre une distension thoracique avec aplatissement des coupoles diaphragmatiques avec de grosses arteres pulmonaires.</p>\r\n<p>sur le plan biologique on note un Hct &agrave; 36.4% avec des GDS &agrave; AA pH:7.5 pCO2:29Torr pO2 :74 Torr SaO2:96%.</p>\r\n<p>L\'EFR montre un trouble ventilatoire obstructif Gold III s&eacute;v&egrave;re avec un VEMS &agrave; 1.13 soit 42% de la norme; le Tiffeneau est &agrave; 59%Iil existe des signes de distension pulmonaire avec VGT &agrave; 189% CPT &agrave; 112% VR &agrave; 194% de la norme./Les resistances des voies a&eacute;riennes sont augment&eacute;es &agrave; 0.73.</p>\r\n<p>Sur le plan th&eacute;rapeutique le patient poursuivra:Onbrez 300;Spiriva Respimat 2B/j;miflonil400 1X2;A&eacute;rosolttt Bricanyl-Atrovent et kin&eacute;siett respiratoire.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(581,613,'2013-11-07','Dr I.Patel','<p>&nbsp;</p>\r\n<p>Cher Ami</p>\r\n<p>J\'ai vu ce jour Mme RAZEFARSON Sandra n&eacute;e le 12/01/1980.</p>\r\n<p>Cette dame a b&eacute;n&eacute;fici&eacute; d\'une polygraphie ventilatoire dans la nuit du 5 au 6/11/2013.</p>\r\n<p>Cet examen a montr&eacute; un index d\'apn&eacute;es-hypopn&eacute;es de 19/H. &nbsp;Cet index passe &agrave; 38/H quand on y associe les &eacute;v&eacute;nements(diminutions).</p>\r\n<p>746 ronflements ont &eacute;t&eacute; d&eacute;tect&eacute;s / H avec une &eacute;nergie moyenne de 89db.</p>\r\n<p>De plus il existe 9 d&eacute;saturations/H avec une SaO2 minimale de 89%.</p>\r\n<p>il y a donc une forte suspicion de syndrome d\'apn&eacute;es du sommeil chez cette dame.</p>\r\n<p>Nous allons la reprendre le 13/11/2013 ^pour pratiquer une polysomnographie afin de d&eacute;tecter des micro &eacute;veils.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Ami, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(582,640,'2013-11-07','Dr Dupuis','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>Je revois ce jour Mme RIVIERE Marie Alice n&eacute;e le 22/05/1943.</p>\r\n<p>Cette dame va mieux et devra poursuivre son traitement.je la reverrai dans un mois et on mettra &agrave; jour sa vaccination anti grippale et du pneumo 23.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY.</p>\r\n<p>&nbsp;</p>'),(583,656,'2013-11-07','Dr Cole-Rocher\r\nDr Jop\r\ncardiologue','<p>Cher Confr&egrave;re,</p>\r\n<p>Je vous remercie de m\'avoir adress&eacute; pour avis Mme LAUGIER Marianne, n&eacute;e le 30/10/1928.</p>\r\n<p>Cette dame pr&eacute;sente une dyspn&eacute;e depuis une ann&eacute;e.</p>\r\n<p>Dans vos ant&eacute;c&egrave;dents on note une GEU,une ovariectomie droite puis une hysterectomie,une hernie inguinale droite.</p>\r\n<p>Elle a b&eacute;n&eacute;fici&eacute; d\'un remplacement valvulaire aortique sur RAo en mai 2011.</p>\r\n<p>Mme Laugier ressent des sibilances dans les deux champs pulmonaires de facon intermittente.</p>\r\n<p>Elle pr&eacute;sente une dyspn&eacute;e grade II/III de l\'&eacute;chelle du Modified Medical Research Council.</p>\r\n<p>l\'auscultation pulmonaire est ce jour dans les limites de la normale.</p>\r\n<p>Mme laugier b&eacute;n&eacute;ficiera d\'une EFR mardi 12/11/2013 &agrave; 8:30.</p>\r\n<p>La NFS retrouve :Hb 13.8 g/dl;toutefois les ALAT sont &agrave; 137 et les ASAT &agrave; 96UI/L avec gamma -G-T &agrave; 230 UI/L en date du 04/11/2013.Les GDS retrouvent pH 7.52 pCo2:31 Torr pO2:101Torr ;RA 25.3;&lt;Co2 t:26.3;BE27.3 SaO2:98%.</p>\r\n<p>Il convient donc que Mme laugier me ram&egrave;ne sa radiographie pulmonaire ,de pratiquer un dosage de proBNP,elle a eu une echocardiographie avec le Dr jop qui &eacute;tait rassurant.</p>\r\n<p>Je la place sous SYMBICORT 2BX2/j avec rin&ccedil;age de la bouche l\'eau par la suite.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(584,173,'2013-11-07','Dr Goeury\r\nISIS Médical','<p>&nbsp;Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MOUCOUVEIA Marie Renette n&eacute;e le 21/09/1956.</p>\r\n<p>Sa radiographie pulmonaire est dans les limites de la normale.</p>\r\n<p>la biologie retrouve:Hb 12.8g/dl,les RAST retrouvent une allergie classe 3 aux acariens.Il n\'existe pas d\'hypereosinophilie.les IgE totales sont &agrave; 508UI/mL.</p>\r\n<p>Mme Moucouveia pesant 86 kilos son taitement par XOLAIR devrait etre de 450 mg toutes les deux semaines.</p>\r\n<p>Je modifie donc l\'ordonnance en fonction.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(585,234,'2013-11-08','DR Kon Sun Tack','<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme PEROUMAL ELLAMA Ange Marie C&eacute;line n&eacute;e le 14/12/1933.</p>\r\n<p>Ellva assez bien et est trait&eacute;e par SERETIDE 250 1BX2 &nbsp;&agrave; l\'aide d\'une chambre d\'inhalation et SINGULAIR 10 mg 1 cp le soir.Elle est par ailleurs trait&eacute;e par DOLIPRANE en cas de cephal&eacute;es et douleurs arthosiques des deux genoux.Elle est &eacute;galement trait&eacute;e pour diab&egrave;te insulino d&eacute;pendant.Elle prend &eacute;galement de LAMALINE en cas de fortes douleurs.</p>\r\n<p>L\'auscultation pulmonaire est &nbsp;ce jour sans grande particularit&eacute;.</p>\r\n<p>Il convient de poursuivre le meme traitement sur le plan respiratoire et la placer sous kin&eacute;siettt d\'&eacute;tirement pour ses genoux avec electrostimulation.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>'),(586,671,'2013-11-08','Dr kon Sun Tack\r\nDr AhMouck','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme. PEROUMAL ELLAMA Marie Jeanne n&eacute; le 16/08/1938.</p>\r\n<p>Cette dame est non fumeuse,c&eacute;libataire sans enfant.</p>\r\n<p>Elle travaillait comme secretaire comptable &agrave; l\'usine de la Mare.</p>\r\n<p>dans ses ant&eacute;c&egrave;dents on note une appendicectomie et une cholecystectomie.</p>\r\n<p>elle est trait&eacute; pour HTA ,angine de poitrine et arthrose.</p>\r\n<p>Elle se plaint de douleurs dans les mollets et des varices ainsi que de lombalgies.</p>\r\n<p>Elle pr&eacute;sente un ronflement important .son score d\'Epworth est &agrave; 15/24 .</p>\r\n<p>Le score de Mallampati est de2 /4.</p>\r\n<p>je lui donne un RV pour EFR et nous programmerons une polygraphie nocturne.</p>\r\n<p>Elle fera une echo doppler des M.I. et je conseille une kin&eacute;siettt pour ses lombalgies.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(587,403,'2013-11-08','Dr Colette Morel\r\nDr Omarjee','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme AUBRAS Marie Lise n&eacute;e le 02/03/1958.</p>\r\n<p>cette dame a &eacute;t&eacute; hospitalis&eacute;e du 05/09 au 25/09/2013 au CHU F&eacute;lix Guyon pour r&eacute;activation d\'une tuberculose pulmonaire.Elle est actuellemnt trait&eacute; depuis le 11/09/2013 par RIFATER et DEXAMBUTOL.</p>\r\n<p>Son poids est de 47.7 kilos.L\'auscultation pulmonaire retrouve ce jour des sibilances dans les champs pulmonaires.</p>\r\n<p>Son dernier bilan biologique en date du 06/11/2013 retrouve une VS de 6 &agrave; la 1&egrave;re heure avec une CRP &agrave;1.La clairance &agrave; la Cr&eacute;atinine est &agrave; 91 (Clairance corrig&eacute;e).Les ALAT sont &nbsp;&agrave; 69UI/L et les ASAT &agrave; 47UI/L et les gamma -GT &agrave; 38.</p>\r\n<p>Il convient donc de surveiller dans 2 semaines la fonction h&eacute;patique.</p>\r\n<p>J\'ai t&eacute;l&eacute;phon&eacute; ce jour au laboratoire de bacteriolmogie du CHU F.Guyon.Les BK sont multisensibles ce qui fait qu\'on peut diminuer le traitement &agrave; compter du 11/11/2013.</p>\r\n<p>Mme Aubras prendra d&eacute;sormais du RIFINAH 2cp/j le matin &agrave; jeun associ&eacute; &agrave; FORADIL 1 gel inh: m ets et SINGULAIR 10 mg 1 cp le soir.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>&nbsp;</p>'),(588,171,'2013-11-08','Dr Fouassin\r\nDr Rahoelina','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour Mme MOREAU LUCETTE MARIE n&eacute;e le 16/10/1948.</p>\r\n<p>Cette dame ,non fumeuse,spar&eacute;e et a 3 enfants.</p>\r\n<p>Elle a &eacute;t&eacute; op&eacute;r&eacute;e d\'un goitre patr Dr Lamarque.</p>\r\n<p>Elle est trait&eacute;e pour un asthme difficile &agrave; traiter avec plusieurs hospitalisations .Elle est actuellement sous &nbsp;XOLAIR 300mg en S/c /mois et depuis son &eacute;tat s\'est nettement am&eacute;lior&eacute;.</p>\r\n<p>Elle est &eacute;galement trait&eacute;e par FORADIL,FLIXOTIDE,SINGULAIR.</p>\r\n<p>Ce jour l\'auscultation pulmonaire est dans les limites de la normale.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance de mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>'),(589,79,'2013-11-08','Dr Jean-Marc HOARAU','<p>J\'ai vu ce jour M. ROBERT Maximin&nbsp;<span style=\"font-size: 11px;\">Ce monsieur mari&eacute; est sans enfant.Il exercait la profession de ferailleur.</span></p>\r\n<p>D<span style=\"font-size: 11px;\">n&eacute; le 31/10/1937.</span></p>\r\n<p>Son &eacute;tat respiratoire est stable mais il se plaint de c&eacute;phal&eacute;es.Il pr&eacute;sente 4 nyctiuries.</p>\r\n<p>Son score d\'Epworth peut etre &eacute;valu&eacute; &agrave; 12/24.</p>\r\n<p>Le score de Mallampati est de 2 /4.Une polygraphie nocturne devra etre pr&eacute;vue chez lui.</p>\r\n<p>Son traitement reste inchang&eacute;:Symbicort 400 1X2;Spiriva Respimat 2B;aerosolttt (Bricanyl-Atrovent)X3;PulmicortX2</p>\r\n<p>Kin&eacute;siett respiratoire 4 s&eacute;ances/semaine;Cetornan5gX2 et CLINUTREN HPX3/J.</p>\r\n<p>Avec mes remerciements, veuillez agr&eacute;er, cher Confr&egrave;re, l\'assurance des mes sentiments distingu&eacute;s,</p>\r\n<p>Dr. B. TANGUY</p>\r\n<p>Cher Confr&egrave;re</p>'),(590,634,'2013-11-08','Dr I.Patel','<p>Cher Confr&egrave;re</p>\r\n<p>J\'ai vu ce jour M. THIAKIME Gertrude Bernadette &nbsp;n&eacute; le 22/11/1922.</p>\r\n<p>Cette dame est mari&eacute;e sans enfant.Elle travaillait comme cuisini&egrave;re.</p>\r\n<p>Dans ses ant&eacute;c&egrave;dents on note une colectomie en 2010 &nbsp;par le Pr Gambier pour un adenocarcinome.</p>\r\n<p>Elle pr&eacute;sente des lombalgies avec arthrose des genoux